/* $Id: init.c,v 1.72 2005/12/02 21:04:15 phil Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H defined */

#ifdef HAVE_STDLIB_H			/* before stdio */
#include <stdlib.h>			/* for malloc */
#else  /* HAVE_STDLIB_H not defined */
extern void *malloc();
#endif /* HAVE_STDLIB_H not defined */

#include <stdio.h>
#include <signal.h>

#include "h.h"
#include "snotypes.h"
#include "macros.h"
#include "lib.h"			/* io_init(), io_input() protos */
#include "str.h"			/* strlen() */
#include "units.h"			/* UNIT[IOPT] */

#include "equ.h"			/* SIL equ's */
#include "res.h"			/* for data.h */
#include "data.h"			/* SIL data */
#include "proc.h"			/* for SYSCUT() */

/* return type of signal handler functions */
#ifndef SIGFUNC_T
#define SIGFUNC_T void
#endif /* SIGFUNC_T not defined */

#ifndef NDYNAMIC
#define NDYNAMIC (64*1024)		/* default dynamic region size */
#endif /* NDYNAMIC not defined */

#ifndef PSSIZE
#define PSSIZE (SPDLDR/DESCR)		/* default pattern stack size */
#endif /* PSSIZE not defined */

#ifndef ISSIZE
#define ISSIZE STSIZE
#endif /* ISSIZE not defined */

#ifdef NO_STATIC_VARS
#include "vars.h"
#else  /* NO_STATIC_VARS not defined */

#ifdef HAVE_BUILD_VARS
extern const char build_date[];		/* from build.c */
#endif /* HAVE_BUILD_VARS defined */

/* global for access by io.c; */
int rflag;

/* global for access by host.c; */
int ndynamic;
int pmstack;
int istack;
char *params;
char **argv;
int firstarg;
int argc;
int nfiles;
#endif /* NO_STATIC_VARS not defined */

extern int optind;
extern char *optarg;
extern int getopt();

static void
p( flag, str )
    char flag;
    char *str;
{
    fprintf(stderr, "-%c\t%s\n", flag, str);
}

static char *
showk( n )
    int n;
{
    static char buf[32];
    int k, m;

    k = n / 1024;
    m = k / 1024;

    if (m*1024*1024 == n)
	sprintf(buf, "%dm", m);
    else if (k*1024 == n)
	sprintf(buf, "%dk", k);
    else
	sprintf(buf, "%d", n);

    return buf;
}

static void
usage( jname, justversion )
    char *jname;
    int justversion;
{
    extern const char snoname[], vers[], vdate[];
    fprintf( stderr, "%s version %s (%s)\n", snoname, vers, vdate );
#ifdef HAVE_BUILD_VARS
    fprintf( stderr, "built %s\n", build_date);
#endif /* HAVE_BUILD_VARS defined */
    if (justversion)
	exit(1);

    fprintf( stderr,
	    "Usage: %s [options...] [files...] [parameters...]\n", jname );
/* XXX stuff about parameters */
    p('b',"toggle display of startup banner");
    fprintf(stderr,
	    "-d DESCRS[km]\n\tsize of dynamic region in descriptors (default: %s)\n", showk(NDYNAMIC));
    p('f',"toggle folding of identifiers to upper case (-CASE)");
    p('g',"enable GC trace (&GTRACE)");
    p('h',"help (this message)");
    p('k',"toggle running programs with compilation errors (-[NO]ERRORS)");
    p('l',"enable listings (-LIST)");
    p('n',"toggle running program after compilation (-[NO]EXECUTE)");
    p('p',"toggle SPITBOL operators (-PLUSOPS)");
    p('r',"toggle reading INPUT from after END statement");
    p('s',"toggle display of statistics");
    fprintf(stderr, "-u PARMS\n\tparameter data available via HOST(0)\n");
    p('v',"display version and exit");
#ifdef PRELOAD
    p('L',"toggle pre-loading");
#endif /* PRELOAD defined */
    p('M',"process multiple files for program code");
    fprintf(stderr, "-P DESCRS[km]\n");
    fprintf(stderr, "\tsize of pattern match stack in descriptors (default: %s)\n", showk(PSSIZE));
    fprintf(stderr, "-S DESCRS[km]\n");
    fprintf(stderr, "\tsize of interpreter stack in descriptors (default: %s)\n", showk(ISSIZE));

    fprintf(stderr, "\n");
    fprintf(stderr, "For memory region sizes a suffix of 'k' (1024) and 'm' (1024*1024)\n");
    fprintf(stderr, "can be used. A descriptor takes up %d bytes.\n", DESCR );
    exit(1);
}

static int
getk( str, out )
    char *str;
    int *out;
{
    char suff;
    switch (sscanf(str, "%d%c", out, &suff)) {
    case 2:				/* number & suffix */
	if (suff == 'k' || suff == 'K')
	    *out *= 1024;
	else if (suff == 'm' || suff == 'M')
	    *out *= 1024*1024;
	else
	    return 0;			/* bad suffix; fail */
	/* FALL */
    case 1:				/* just number */
	return 1;			/* return OK */

    default:				/* no number */
	return 0;			/* fail */
    }
}

/*
 * create c-string of args from start .. argc in a malloc'ed buffer.
 * fills in an optional SPEC
 */

static char *
getargs(start, sp)
    int start;				/* which argument to start on */
    struct spec *sp;			/* dest spec, or NULL */
{
    int i;
    char *parms;
    register char *pp;
    int len;

    len = 0;
    for (i = start; i < argc; i++)
	len += strlen(argv[i]) + 1;	/* add one for space or NUL */

    parms = malloc(len);
    if (!parms)
	return NULL;			/* XXX perror & exit? */

    pp = parms;
    for (i = start; i < argc; i++) {
	register char *ap;

	if (pp != parms)
	    *pp++ = ' ';

	ap = argv[i];
	while ((*pp = *ap++))
	    pp++;
    }

    if (sp) {
	S_A(sp) = (int_t) parms;	/* OY! */
	S_F(sp) = 0;			/* NOTE: *not* a PTR! */
	S_V(sp) = 0;
	S_O(sp) = 0;
	S_L(sp) = len - 1;		/* omit trailing NUL */
	CLR_S_UNUSED(sp);
    }

    return parms;
}

void
io_init()				/* here from INIT */
{
    FILE *termin;

    io_initvars();

    if (nfiles == 0) {			/* no input file(s)? */
#ifdef MEM_IO_TEST
	char *str = "\tOUTPUT = 'Hello World'\n\tOUTPUT = INPUT\nEND\nFOO\n";
	io_input_string( "input", str );
#else  /* MEM_IO_TEST not defined */
	/* read code from stdin.... Macro SPITBOL requires '-' for this */
#ifdef PRELOAD
	io_input_file("-");		/* implicit "-"! */
#else  /* PRELOAD not defined */
	/* blows away preload list */
	if (!io_mkfile_noclose(UNITI, stdin, STDIN_NAME)) {
	    perror("could not attach stdin to INPUT");
	    exit(1);
	}
#endif /* PRELOAD not defined */
#endif /* MEM_IO_TEST not defined */
    }
    else {
	if (!io_skip(UNITI)) {		/* force file open */
	    char *fname;
	    fname = io_fname(UNITI);
	    if (!fname)
		fname = "unknown input file";
	    perror(fname);
	    exit(1);
	}
    }

    /* XXX support -o outputfile? */

    if (!io_mkfile_noclose(UNITO, stdout, STDOUT_NAME)) {
	perror("could not attach stdout to OUTPUT");
	exit(1);
    }

    if (!io_mkfile_noclose(UNITP, stderr, STDERR_NAME)) {
	perror("could not attach stderr to TERMINAL");
	exit(1);
    }

    termin = term_input();		/* call system dependant function */
    if (termin && !io_mkfile_noclose(UNITT, termin, TERMIN_NAME)) {
	perror("could not open TERMINAL for input");
	exit(1);
    }
} /* io_init */

#ifdef PRELOAD
static int
trypreload( var, defdir, file )
    char *var, *defdir, *file;
{
    char *path;

    if (var || defdir) {
	char *dir = NULL;
	int ret = 0;

	if (var)
	    dir = getenv(var);

	if (!dir)
	    dir = defdir;

	path = malloc(strlen(dir) + 1 + strlen(file) + 1);
	if (!path)
	    return 0;
	sprintf(path, "%s%s%s", dir, DIR_SEP, file);
	if (exists(path)) {
	    io_input_file(path);
	    ret = 1;
	}
	free(path);
	return ret;
    }
    else if (exists(file)) {
	io_input_file(file);
	return 1;
    }
    return 0;
} /* trypreload */
#endif /* PRELOAD defined */

/* called from main.c after init_data, before xfer to SIL BEGIN label */
void
init_args( ac, av )
    int ac;
    char *av[];
{
    int errs;
    int c;
    int multifile;
    int justversion;
#ifdef PRELOAD
    int preload = 0;			/* default to OFF! */
#endif /* PRELOAD defined */

    ndynamic = NDYNAMIC;
    pmstack = PSSIZE;
    istack = ISSIZE;

    /* save in globals for HOST(), getparm(), init() */
    argc = ac;
    argv = av;

#ifdef vms
    argc = getredirection(argc, argv);
#endif /* vms defined */

    errs = 0;
    multifile = 0;			/* SITBOL behavior */
    justversion = 0;

    /*
     * ***** NOTE ******
     *
     * * Options are compatible (where possible) with Catspaw Macro SPITBOL
     *
     * * When adding options, update usage() function (above) and man page!!!
     *
     * * '+' at start is required w/ GNU libc (Linux) to avoid broken
     *		default (non POSIX) behavior (continues picking up
     *		switches after first file) and is HOPEFULLY harmless
     *		(-+ if given should fall into default case.  If we
     *		ever want a real -+ option, ANOTHER + will need to be
     *		added, but it better not want an argument!)
     */

    while ((c = getopt(argc, argv, "+bd:fghklnprsu:vLMP:S:")) != -1) {
	switch (c) {
	case 'b':
	    D_A(BANRCL) = !D_A(BANRCL);	/* toggle banner output */
	    break;

	case 'd':			/* number of dynamic descrs */
	    if (!getk(optarg, &ndynamic))
		errs++;
	    /* XXX enforce a minimum?? */
	    break;

	case 'f':			/* toggle case folding */
	    D_A(CASECL) = !D_A(CASECL);
	    break;

	case 'g':
	    D_A(GCTRCL) = -1;		/* enable &GCTRACE */
	    break;

	case 'v':			/* version */
	    justversion = 1;
	    errs++;
	    break;

	case 'h':			/* help */
	    justversion = 0;
	    errs++;
	    break;

	case 'k':
	    /* toggle running programs with compile errors */
	    D_A(NERRCL) = !D_A(NERRCL);
	    break;

	case 'l':			/* -LIST */
	    /* XXX should take an argument!!! */
	    D_A(LISTCL) = 1;
	    break;

	case 'n':			/* toggle -[NO]EXECUTE */
	    D_A(EXECCL) = !D_A(EXECCL);
	    break;

	case 'p':			/* toggle -PLUSOPS */
	    D_A(SPITCL) = !D_A(SPITCL);
	    break;

	case 'r':			/* read INPUT from source after END */
	    rflag = !rflag;
	    break;

	case 's':			/* toggle statistics */
	    D_A(STATCL) = !D_A(STATCL);
	    break;

	case 'u':			/* parameter data */
	    params = optarg;
	    break;

#ifdef PRELOAD
	case 'L':			/* pre-load files */
	    preload = !preload;
	    break;
#endif /* PRELOAD defined */

	case 'M':			/* multi-file input */
	    multifile = !multifile;
	    break;

	case 'P':			/* pattern match stack size */
	    if (!getk(optarg, &pmstack))
		errs++;
	    break;

	case 'S':			/* interpreter stack size */
	    if (!getk(optarg, &istack))
		errs++;
	    break;

	default:
	    errs++;
	}
    }

#ifdef PRELOAD
    /*
     * NOTE! THIS FEATURE IS DISABLED, UNDOCUMENTED and UNSUPPORTED.
     * IT MAY DISAPPEAR ALTOGETHER!
     * Or, It may appear in a future release, but not in this exact form!
     *
     * Use at your own risk!  It may make your code less portable
     * than if you had used -INCLUDE "/path/file.sno"!!!!
     */

    if (preload) {
	/* try version based filename(s) as well as unversioned? */
	/* XXX defend against including same file twice?! use io_include()? */
	
	/*
	 * modification of this file reserved to CSNOBOL4 distribution
	 * creator!! Do not edit locally, it may be crushed by the
	 * install process.  YOU HAVE BEEN WARNED!!!
	 */
	trypreload("SNODIR", SNOLIB_DIR, "dist-preload.sno");

	/* all of the following files may be created/modified by local users */
	trypreload("SNODIR", SNOLIB_DIR, "preload.sno");
	trypreload("HOME",   NULL,	 "preload.sno");
	trypreload(NULL,     NULL,	 "preload.sno");
    }
#endif /* PRELOAD defined */

    /*
     * append first file (or all additional args until "--" seen
     * in "multi-file" mode) to INPUT stream
     */

    while (optind < argc) {
	if (strcmp(argv[optind], "--") == 0) { /* terminator? */
	    optind++;			/* skip it */
	    break;			/* leave loop */
	}
	io_input_file( argv[optind] );
	optind++;
	nfiles++;
	if (!multifile)			/* not in multi-file mode? */
	    break;			/* break out */
    }

    /* if no -u option, process any remaining items as arguments for HOST(0) */
    if (params == NULL && optind < argc) {
	params = getargs(optind, NULL);
    }

    firstarg = optind;			/* save for HOST(3) */

    if (errs) {
	usage(argv[0], justversion);
    }

    io_init();				/* AFTER io_input calls! */
#ifdef HAVE_OS_INIT
    os_init();
#endif /* HAVE_OS_INIT defined */
}

#ifndef NO_STATIC_VARS
volatile int math_error;		/* see macros.h */
#endif /* NO_STATIC_VARS not defined */

static SIGFUNC_T
math_catch(sig)
    int sig;
{
#ifdef SIGFPE
    signal(SIGFPE, math_catch);
#endif /* SIGFPE defined */
#ifdef SIGOVER
    signal(SIGOVER, math_catch);
#endif /* SIGOVER defined */

    math_error = TRUE;
    /* XXX need to longjump out on some systems to avoid restarting insn? */
}

static SIGFUNC_T
err_catch(sig)
    int sig;
{
    D_A(SIGNCL) = sig;			/* save signal number for output */
    SYSCUT(NORET);
}

#ifdef SIGTSTP
static SIGFUNC_T
suspend(sig)
    int sig;
{
    tty_suspend();			/* restore tty mode(s) */

    /* reestablish handler (does any system with job control,
     * in case signal() has System V semantics
     */
    signal(SIGTSTP, suspend);

    /* no need to restore tty modes; next I/O will reset as needed */
}
#endif /* SIGTSTP defined */

/* called by SIL INIT macro (first SIL op executed) */
void
init()
{
    char *ptr;

    /****************
     * allocate dynamic data region
     */

    ndynamic *= DESCR;			/* get bytes */

    ptr = dynamic(ndynamic);

    if (ptr == NULL) {
	fprintf( stderr, "%s: could not allocate dynamic region of %d bytes\n",
		argv[0], ndynamic);
	exit(1);
    }

    bzero( ptr, ndynamic );		/* XXX needed? */

    D_A(FRSGPT) = D_A(HDSGPT) = (int_t) ptr; /* first dynamic descr */

    /* first descr past end of dynamic storage */
    D_A(TLSGP1) = (int_t) ptr + ndynamic;


    /****************
     * allocate pattern match stack
     */

    pmstack *= DESCR;			/* get bytes */

    ptr = malloc(pmstack);		/* NOTE: malloc(), not dynamic() */
    if (ptr == NULL) {
	fprintf( stderr, "%s: could not allocate pattern stack of %d bytes\n",
		argv[0], pmstack);
	exit(1);
    }

    /* set up stack title */
    D_A(ptr) = (int_t) ptr;
    D_F(ptr) = TTL + MARK;
    D_V(ptr) = pmstack;			/* length in bytes */

    /* pointers to top of stack */
    D_A(PDLPTR) = D_A(PDLHED) = (int_t) ptr;

    /* pointer to end of stack for overflow checks */
    D_A(PDLEND) = (int_t) ptr + pmstack - NODESZ;

    /****************
     * allocate interpreter stack
     */

    istack *= DESCR;			/* get bytes */

    ptr = malloc(istack);		/* NOTE: malloc(), not dynamic() */
    if (ptr == NULL) {
	fprintf( stderr, "%s: could not allocate interpreter stack of %d bytes\n",
		argv[0], istack);
	exit(1);
    }

    /* set up stack title */
    D_A(ptr) = (int_t) ptr;
    D_F(ptr) = TTL + MARK;
    D_V(ptr) = istack;			/* length in bytes */

    /* pointers to top of stack */
    D_A(STKPTR) = D_A(STKHED) = (int_t) ptr;

    /* pointer to end of stack, for overflow checks */
    D_A(STKEND) = (int_t) ptr + istack;

    /****************
     * setup signal handlers
     */

    signal( SIGINT, err_catch );

    /* catch bad memory references */
    signal( SIGSEGV, err_catch );
#ifdef SIGBUS
    signal( SIGBUS, err_catch );
#endif /* SIGBUS defined */

    /* catch math errors */
#ifdef SIGFPE
    signal(SIGFPE, math_catch);
#endif /* SIGFPE defined */
#ifdef SIGOVER
    signal(SIGOVER, math_catch);
#endif /* SIGOVER defined */

    /* catch resource limit errors */
#ifdef SIGXCPU
    signal(SIGXCPU, err_catch);
#endif /* SIGXCPU defined */
#ifdef SIGXFSZ
    signal(SIGXFSZ, err_catch);
#endif /* SIGXFSZ defined */

    /* catch network errors! */
#ifdef SIGPIPE
    signal(SIGPIPE, err_catch);
#endif /* SIGPIPE defined */

    /* catch suspend */
#ifdef SIGTSTP
    signal(SIGTSTP, suspend);
#endif /* SIGTSTP defined */
}

/* 9/21/96 - set specifier to point to entire command line for &PARM */
int
getparm( sp )
    struct spec *sp;
{
    return getargs(0, sp) != NULL;
}
