#include <IOKit/IOKitLib.h>
#include <IOKit/pwr_mgt/IOPMLib.h>
#include <IOKit/IOReturn.h>
#include <mach/mach_init.h>        /* for bootstrap_port */
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>

int main(int argc, char *argv[])
{
    mach_port_t master;
    io_connect_t pmcon;
    
    if (IOMasterPort(bootstrap_port, &master) != kIOReturnSuccess) {
        perror("IOMasterPort() failed");
        exit(1);
    }
    
    pmcon = IOPMFindPowerManagement(master);
    if (pmcon == 0) {
        fprintf(stderr, "IOPMFindPowerManagement() failed!\n");
        exit(1);
    }
    
    if (IOPMSleepSystem(pmcon) != kIOReturnSuccess) {
        perror("IOPMSleepSystem() failed");
        exit(1);
    }
    
    return 0;
}
