#pragma once
#include "bar_manager.h"
#include "message.h"

enum event_type {
  EVENT_TYPE_UNKNOWN,
  APPLICATION_FRONT_SWITCHED,
  SPACE_CHANGED,
  DISPLAY_ADDED,
  DISPLAY_REMOVED,
  DISPLAY_MOVED,
  DISPLAY_RESIZED,
  DISPLAY_CHANGED,
  MENU_BAR_HIDDEN_CHANGED,
  SYSTEM_WOKE,
  SYSTEM_WILL_SLEEP,
  SHELL_REFRESH,
  ANIMATOR_REFRESH,
  MACH_MESSAGE,
  MOUSE_UP,
  MOUSE_DRAGGED,
  MOUSE_ENTERED,
  MOUSE_EXITED,
  MOUSE_SCROLLED,
  VOLUME_CHANGED,
  WIFI_CHANGED,
  BRIGHTNESS_CHANGED,
  POWER_SOURCE_CHANGED,
  MEDIA_CHANGED,
  COVER_CHANGED,
  SPACE_WINDOWS_CHANGED,
  DISTRIBUTED_NOTIFICATION,
  HOTLOAD,

  INIT_MUTEX,
  EVENT_TYPE_COUNT
};

struct event {
  void* context;
  enum event_type type;
};

void event_post(struct event *event);
