#ifndef LOG_H
#define LOG_H

extern bool g_verbose;

static inline void debug(const char *format, ...) {
    if (!g_verbose) return;

    va_list args;
    va_start(args, format);
    vfprintf(stdout, format, args);
    va_end(args);
}

static inline void error(const char *format, ...) {
    va_list args;
    va_start(args, format);
    vfprintf(stderr, format, args);
    va_end(args);
    exit(EXIT_FAILURE);
}

#endif
