// Code generated by github.com/markbates/pkger/mapgen. DO NOT EDIT.

package maps

import (
	"encoding/json"
	"fmt"
	"sort"
	"sync"

	"github.com/markbates/pkger/here"
)

// Infos wraps sync.Map and uses the following types:
// key:   string
// value: here.Info
type Infos struct {
	data *sync.Map
	once *sync.Once
}

func (m *Infos) Data() *sync.Map {
	if m.once == nil {
		m.once = &sync.Once{}
	}
	m.once.Do(func() {
		if m.data == nil {
			m.data = &sync.Map{}
		}
	})
	return m.data
}

func (m *Infos) MarshalJSON() ([]byte, error) {
	mm := map[string]interface{}{}
	m.data.Range(func(key, value interface{}) bool {
		mm[fmt.Sprintf("%s", key)] = value
		return true
	})
	return json.Marshal(mm)
}

func (m *Infos) UnmarshalJSON(b []byte) error {
	mm := map[string]here.Info{}

	if err := json.Unmarshal(b, &mm); err != nil {
		return err
	}
	for k, v := range mm {
		m.Store(k, v)
	}
	return nil
}

// Delete the key from the map
func (m *Infos) Delete(key string) {
	m.Data().Delete(key)
}

// Load the key from the map.
// Returns here.Info or bool.
// A false return indicates either the key was not found
// or the value is not of type here.Info
func (m *Infos) Load(key string) (here.Info, bool) {
	m.Data()
	i, ok := m.data.Load(key)
	if !ok {
		return here.Info{}, false
	}
	s, ok := i.(here.Info)
	return s, ok
}

// Range over the here.Info values in the map
func (m *Infos) Range(f func(key string, value here.Info) bool) {
	m.Data().Range(func(k, v interface{}) bool {
		key, ok := k.(string)
		if !ok {
			return false
		}
		value, ok := v.(here.Info)
		if !ok {
			return false
		}
		return f(key, value)
	})
}

// Store a here.Info in the map
func (m *Infos) Store(key string, value here.Info) {
	m.Data().Store(key, value)
}

// Keys returns a list of keys in the map
func (m *Infos) Keys() []string {
	var keys []string
	m.Range(func(key string, value here.Info) bool {
		keys = append(keys, key)
		return true
	})
	sort.Strings(keys)
	return keys
}
