// Code generated by protoc-gen-go. DO NOT EDIT.
// source: skaffold.proto

package proto

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Enum indicating builders used
type BuilderType int32

const (
	// Could not determine builder type
	BuilderType_UNKNOWN_BUILDER_TYPE BuilderType = 0
	// JIB Builder
	BuilderType_JIB BuilderType = 1
	// Bazel Builder
	BuilderType_BAZEL BuilderType = 2
	// Buildpacks Builder
	BuilderType_BUILDPACKS BuilderType = 3
	// Custom Builder
	BuilderType_CUSTOM BuilderType = 4
	// Kaniko Builder
	BuilderType_KANIKO BuilderType = 5
	// Docker Builder
	BuilderType_DOCKER BuilderType = 6
)

var BuilderType_name = map[int32]string{
	0: "UNKNOWN_BUILDER_TYPE",
	1: "JIB",
	2: "BAZEL",
	3: "BUILDPACKS",
	4: "CUSTOM",
	5: "KANIKO",
	6: "DOCKER",
}

var BuilderType_value = map[string]int32{
	"UNKNOWN_BUILDER_TYPE": 0,
	"JIB":                  1,
	"BAZEL":                2,
	"BUILDPACKS":           3,
	"CUSTOM":               4,
	"KANIKO":               5,
	"DOCKER":               6,
}

func (x BuilderType) String() string {
	return proto.EnumName(BuilderType_name, int32(x))
}

func (BuilderType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{0}
}

// Enum indicating build type i.e. local, cluster vs GCB
type BuildType int32

const (
	// Could not determine Build Type
	BuildType_UNKNOWN_BUILD_TYPE BuildType = 0
	// Cluster Build
	BuildType_CLUSTER BuildType = 1
	// GCB Build
	BuildType_GCB BuildType = 2
	// Local Build
	BuildType_LOCAL BuildType = 3
)

var BuildType_name = map[int32]string{
	0: "UNKNOWN_BUILD_TYPE",
	1: "CLUSTER",
	2: "GCB",
	3: "LOCAL",
}

var BuildType_value = map[string]int32{
	"UNKNOWN_BUILD_TYPE": 0,
	"CLUSTER":            1,
	"GCB":                2,
	"LOCAL":              3,
}

func (x BuildType) String() string {
	return proto.EnumName(BuildType_name, int32(x))
}

func (BuildType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{1}
}

// Enum indicating test tools used
type TesterType int32

const (
	// Could not determine Test Type
	TesterType_UNKNOWN_TEST_TYPE TesterType = 0
	// Unit tests
	TesterType_UNIT TesterType = 1
	// Container Structure tests
	TesterType_CONTAINER_STRUCTURE_TEST TesterType = 2
)

var TesterType_name = map[int32]string{
	0: "UNKNOWN_TEST_TYPE",
	1: "UNIT",
	2: "CONTAINER_STRUCTURE_TEST",
}

var TesterType_value = map[string]int32{
	"UNKNOWN_TEST_TYPE":        0,
	"UNIT":                     1,
	"CONTAINER_STRUCTURE_TEST": 2,
}

func (x TesterType) String() string {
	return proto.EnumName(TesterType_name, int32(x))
}

func (TesterType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{2}
}

// Enum indicating deploy tools used
type DeployerType int32

const (
	// Could not determine Deployer Type
	DeployerType_UNKNOWN_DEPLOYER_TYPE DeployerType = 0
	// Helm Deployer
	DeployerType_HELM DeployerType = 1
	// Kustomize Deployer
	DeployerType_KUSTOMIZE DeployerType = 2
	// Kubectl Deployer
	DeployerType_KUBECTL DeployerType = 3
)

var DeployerType_name = map[int32]string{
	0: "UNKNOWN_DEPLOYER_TYPE",
	1: "HELM",
	2: "KUSTOMIZE",
	3: "KUBECTL",
}

var DeployerType_value = map[string]int32{
	"UNKNOWN_DEPLOYER_TYPE": 0,
	"HELM":                  1,
	"KUSTOMIZE":             2,
	"KUBECTL":               3,
}

func (x DeployerType) String() string {
	return proto.EnumName(DeployerType_name, int32(x))
}

func (DeployerType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{3}
}

// Enum indicating cluster type the application is deployed to
type ClusterType int32

const (
	// Could not determine Cluster Type
	ClusterType_UNKNOWN_CLUSTER_TYPE ClusterType = 0
	// Minikube Cluster
	ClusterType_MINIKUBE ClusterType = 1
	// GKE cluster
	ClusterType_GKE ClusterType = 2
	// All Cluster except Minikube and GKE
	ClusterType_OTHER ClusterType = 3
)

var ClusterType_name = map[int32]string{
	0: "UNKNOWN_CLUSTER_TYPE",
	1: "MINIKUBE",
	2: "GKE",
	3: "OTHER",
}

var ClusterType_value = map[string]int32{
	"UNKNOWN_CLUSTER_TYPE": 0,
	"MINIKUBE":             1,
	"GKE":                  2,
	"OTHER":                3,
}

func (x ClusterType) String() string {
	return proto.EnumName(ClusterType_name, int32(x))
}

func (ClusterType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{4}
}

// Enum for Status codes
// These error codes are prepended by Phase Name e.g.
// BUILD, TEST, DEPLOY, STATUSCHECK, DEVINIT
// For Success Error codes, use range 200 to 250.
// For Unknown error codes, use range 500 to 600.
// For Cancelled Error code, use range 800 to 850.
type StatusCode int32

const (
	// A default status code for events that do not have an associated phase.
	// Typically seen with the DevEndEvent event on success.
	StatusCode_OK StatusCode = 0
	// Status Check Success
	StatusCode_STATUSCHECK_SUCCESS StatusCode = 200
	// Build Success
	StatusCode_BUILD_SUCCESS StatusCode = 201
	// Deploy Success
	StatusCode_DEPLOY_SUCCESS StatusCode = 202
	// Test Success
	StatusCode_TEST_SUCCESS StatusCode = 203
	// Build error due to push access denied
	StatusCode_BUILD_PUSH_ACCESS_DENIED StatusCode = 101
	// Build error due to GCP project not found.
	StatusCode_BUILD_PROJECT_NOT_FOUND StatusCode = 102
	// Docker build error due to docker daemon not running
	StatusCode_BUILD_DOCKER_DAEMON_NOT_RUNNING StatusCode = 103
	// Build error due to user application code, e.g. compilation error, dockerfile error etc
	StatusCode_BUILD_USER_ERROR StatusCode = 104
	// Build error due to docker not available
	StatusCode_BUILD_DOCKER_UNAVAILABLE StatusCode = 105
	// Docker build error due to user not authorized to perform the action
	StatusCode_BUILD_DOCKER_UNAUTHORIZED StatusCode = 106
	// Docker system build error
	StatusCode_BUILD_DOCKER_SYSTEM_ERR StatusCode = 107
	// Docker build error due to Docker build container is already in the desired state
	StatusCode_BUILD_DOCKER_NOT_MODIFIED_ERR StatusCode = 108
	// Docker build error indicating a feature not supported
	StatusCode_BUILD_DOCKER_NOT_IMPLEMENTED_ERR StatusCode = 109
	// Docker build error indicates that for given build, data was lost or there is data corruption
	StatusCode_BUILD_DOCKER_DATA_LOSS_ERR StatusCode = 110
	// Docker build error indicates user is forbidden to perform the build or step/action.
	StatusCode_BUILD_DOCKER_FORBIDDEN_ERR StatusCode = 111
	// Docker build error due to some internal error and docker container state conflicts with the requested action and can't be performed
	StatusCode_BUILD_DOCKER_CONFLICT_ERR StatusCode = 112
	// Docker build error indicates the requested object does not exist
	StatusCode_BUILD_DOCKER_ERROR_NOT_FOUND StatusCode = 113
	// Docker build error indication invalid parameter sent to docker command
	StatusCode_BUILD_DOCKER_INVALID_PARAM_ERR StatusCode = 114
	// Docker build failed due to dockerfile not found
	StatusCode_BUILD_DOCKERFILE_NOT_FOUND StatusCode = 115
	// Docker build failed due `cacheFrom` user config error
	StatusCode_BUILD_DOCKER_CACHE_FROM_PULL_ERR StatusCode = 116
	// Build error due to digest for built artifact could not be retrieved from docker daemon.
	StatusCode_BUILD_DOCKER_GET_DIGEST_ERR StatusCode = 117
	// Build error due to digest for built artifact could not be retrieved from registry.
	StatusCode_BUILD_REGISTRY_GET_DIGEST_ERR StatusCode = 118
	// Build error indicating unknown Jib plugin type. Should be one of [maven, gradle]
	StatusCode_BUILD_UNKNOWN_JIB_PLUGIN_TYPE StatusCode = 119
	// Build error determining dependency for jib gradle project.
	StatusCode_BUILD_JIB_GRADLE_DEP_ERR StatusCode = 120
	// Build error determining dependency for jib gradle project.
	StatusCode_BUILD_JIB_MAVEN_DEP_ERR StatusCode = 121
	// Docker build error when listing containers.
	StatusCode_INIT_DOCKER_NETWORK_LISTING_CONTAINERS StatusCode = 122
	// Docker build error indicating an invalid container name (or id).
	StatusCode_INIT_DOCKER_NETWORK_INVALID_CONTAINER_NAME StatusCode = 123
	// Docker build error indicating the container referenced does not exists in the docker context used.
	StatusCode_INIT_DOCKER_NETWORK_CONTAINER_DOES_NOT_EXIST StatusCode = 124
	// Container image pull error
	StatusCode_STATUSCHECK_IMAGE_PULL_ERR StatusCode = 300
	// Container creating error
	StatusCode_STATUSCHECK_CONTAINER_CREATING StatusCode = 301
	// Container run error
	StatusCode_STATUSCHECK_RUN_CONTAINER_ERR StatusCode = 302
	// Container is already terminated
	StatusCode_STATUSCHECK_CONTAINER_TERMINATED StatusCode = 303
	// Deployment waiting for rollout
	StatusCode_STATUSCHECK_DEPLOYMENT_ROLLOUT_PENDING StatusCode = 304
	// Container restarting error
	StatusCode_STATUSCHECK_CONTAINER_RESTARTING StatusCode = 356
	// Readiness probe failed
	StatusCode_STATUSCHECK_UNHEALTHY StatusCode = 357
	// Node memory pressure error
	StatusCode_STATUSCHECK_NODE_MEMORY_PRESSURE StatusCode = 400
	// Node disk pressure error
	StatusCode_STATUSCHECK_NODE_DISK_PRESSURE StatusCode = 401
	// Node network unavailable error
	StatusCode_STATUSCHECK_NODE_NETWORK_UNAVAILABLE StatusCode = 402
	// Node PID pressure error
	StatusCode_STATUSCHECK_NODE_PID_PRESSURE StatusCode = 403
	// Node unschedulable error
	StatusCode_STATUSCHECK_NODE_UNSCHEDULABLE StatusCode = 404
	// Node unreachable error
	StatusCode_STATUSCHECK_NODE_UNREACHABLE StatusCode = 405
	// Node not ready error
	StatusCode_STATUSCHECK_NODE_NOT_READY StatusCode = 406
	// Scheduler failure error
	StatusCode_STATUSCHECK_FAILED_SCHEDULING StatusCode = 407
	// Kubectl connection error
	StatusCode_STATUSCHECK_KUBECTL_CONNECTION_ERR StatusCode = 409
	// Kubectl process killed error
	StatusCode_STATUSCHECK_KUBECTL_PID_KILLED StatusCode = 410
	// Kubectl client fetch err
	StatusCode_STATUSCHECK_KUBECTL_CLIENT_FETCH_ERR StatusCode = 411
	StatusCode_STATUSCHECK_DEPLOYMENT_FETCH_ERR     StatusCode = 412
	// Pod Initializing
	StatusCode_STATUSCHECK_POD_INITIALIZING StatusCode = 451
	// Could not determine error and phase
	StatusCode_UNKNOWN_ERROR StatusCode = 500
	// Status Check error unknown
	StatusCode_STATUSCHECK_UNKNOWN StatusCode = 501
	// Container is unschedulable due to unknown reasons
	StatusCode_STATUSCHECK_UNKNOWN_UNSCHEDULABLE StatusCode = 502
	// Container is waiting due to unknown reason
	StatusCode_STATUSCHECK_CONTAINER_WAITING_UNKNOWN StatusCode = 503
	// Container event reason unknown
	StatusCode_STATUSCHECK_UNKNOWN_EVENT StatusCode = 509
	// Deploy failed due to unknown reason
	StatusCode_DEPLOY_UNKNOWN StatusCode = 504
	// SYNC failed due to known reason
	StatusCode_SYNC_UNKNOWN StatusCode = 505
	// Build failed due to unknown reason
	StatusCode_BUILD_UNKNOWN StatusCode = 506
	// Dev Init failed due to unknown reason
	StatusCode_DEVINIT_UNKNOWN StatusCode = 507
	// Cleanup failed due to unknown reason
	StatusCode_CLEANUP_UNKNOWN StatusCode = 508
	// Initialization of the Skaffold session failed due to unknown reason(s)
	StatusCode_INIT_UNKNOWN StatusCode = 510
	// Build failed due to docker unknown error
	StatusCode_BUILD_DOCKER_UNKNOWN StatusCode = 511
	// Test failed due to unknown reason
	StatusCode_TEST_UNKNOWN StatusCode = 512
	// File Sync Initialize failure
	StatusCode_SYNC_INIT_ERROR StatusCode = 601
	// Failed to configure watcher for build dependencies in dev loop
	StatusCode_DEVINIT_REGISTER_BUILD_DEPS StatusCode = 701
	// Failed to configure watcher for test dependencies in dev loop
	StatusCode_DEVINIT_REGISTER_TEST_DEPS StatusCode = 702
	// Failed to configure watcher for deploy dependencies in dev loop
	StatusCode_DEVINIT_REGISTER_DEPLOY_DEPS StatusCode = 703
	// Failed to configure watcher for Skaffold configuration file.
	StatusCode_DEVINIT_REGISTER_CONFIG_DEP StatusCode = 704
	// Failed to configure watcher for build dependencies for a base image with v1 manifest.
	StatusCode_DEVINIT_UNSUPPORTED_V1_MANIFEST StatusCode = 705
	// User cancelled the skaffold dev run
	StatusCode_STATUSCHECK_USER_CANCELLED StatusCode = 800
	// Deadline for status check exceeded
	StatusCode_STATUSCHECK_DEADLINE_EXCEEDED StatusCode = 801
	// Build Cancelled
	StatusCode_BUILD_CANCELLED StatusCode = 802
	// Deploy cancelled due to user cancellation or one or more deployers failed.
	StatusCode_DEPLOY_CANCELLED StatusCode = 803
	// Docker build cancelled.
	StatusCode_BUILD_DOCKER_CANCELLED StatusCode = 804
	// Build error due to docker deadline was reached before the docker action completed
	StatusCode_BUILD_DOCKER_DEADLINE StatusCode = 805
	// Skaffold was unable to create the configured tagger
	StatusCode_INIT_CREATE_TAGGER_ERROR StatusCode = 901
	// Skaffold was unable to start as Minikube appears to be paused
	StatusCode_INIT_MINIKUBE_PAUSED_ERROR StatusCode = 902
	// Skaffold was unable to start as Minikube appears to be stopped
	StatusCode_INIT_MINIKUBE_NOT_RUNNING_ERROR StatusCode = 903
	// Skaffold was unable to create a configured image builder
	StatusCode_INIT_CREATE_BUILDER_ERROR StatusCode = 904
	// Skaffold was unable to create a configured deployer
	StatusCode_INIT_CREATE_DEPLOYER_ERROR StatusCode = 905
	// Skaffold was unable to create a configured test
	StatusCode_INIT_CREATE_TEST_DEP_ERROR StatusCode = 906
	// Skaffold encountered an error validating the artifact cache
	StatusCode_INIT_CACHE_ERROR StatusCode = 907
	// Skaffold encountered an error when configuring file watching
	StatusCode_INIT_CREATE_WATCH_TRIGGER_ERROR StatusCode = 908
	// Skaffold encountered an error when evaluating artifact dependencies
	StatusCode_INIT_CREATE_ARTIFACT_DEP_ERROR StatusCode = 909
	// Unable to connect to cluster
	StatusCode_DEPLOY_CLUSTER_CONNECTION_ERR StatusCode = 1001
	// Could not retrieve debug helpers.
	StatusCode_DEPLOY_DEBUG_HELPER_RETRIEVE_ERR StatusCode = 1002
	// Deploy clean up error
	StatusCode_DEPLOY_CLEANUP_ERR StatusCode = 1003
	// Unable to apply helm labels.
	StatusCode_DEPLOY_HELM_APPLY_LABELS StatusCode = 1004
	// Deploy error due to user deploy config for helm deployer
	StatusCode_DEPLOY_HELM_USER_ERR StatusCode = 1005
	// Helm error when no build result is found of value  specified in helm `artifactOverrides`
	StatusCode_DEPLOY_NO_MATCHING_BUILD StatusCode = 1006
	// Unable to get helm client version
	StatusCode_DEPLOY_HELM_VERSION_ERR StatusCode = 1007
	// Helm version not supported.
	StatusCode_DEPLOY_HELM_MIN_VERSION_ERR StatusCode = 1008
	// Unable to retrieve kubectl version
	StatusCode_DEPLOY_KUBECTL_VERSION_ERR StatusCode = 1109
	// User specified offline mode for rendering but remote manifests presents.
	StatusCode_DEPLOY_KUBECTL_OFFLINE_MODE_ERR StatusCode = 1010
	// Error waiting for previous version deletion before next version is active.
	StatusCode_DEPLOY_ERR_WAITING_FOR_DELETION StatusCode = 1011
	// Error reading manifests
	StatusCode_DEPLOY_READ_MANIFEST_ERR StatusCode = 1012
	// Error reading remote manifests
	StatusCode_DEPLOY_READ_REMOTE_MANIFEST_ERR StatusCode = 1013
	// Errors listing manifests
	StatusCode_DEPLOY_LIST_MANIFEST_ERR StatusCode = 1014
	// Deploy error due to user deploy config for kubectl deployer
	StatusCode_DEPLOY_KUBECTL_USER_ERR StatusCode = 1015
	// Deploy error due to user deploy config for kustomize deployer
	StatusCode_DEPLOY_KUSTOMIZE_USER_ERR StatusCode = 1016
	// Error replacing a built artifact in the manifests
	StatusCode_DEPLOY_REPLACE_IMAGE_ERR StatusCode = 1017
	// Error transforming a manifest during skaffold debug
	StatusCode_DEPLOY_TRANSFORM_MANIFEST_ERR StatusCode = 1018
	// Error setting user specified additional labels.
	StatusCode_DEPLOY_SET_LABEL_ERR StatusCode = 1019
	// Error writing hydrated kubernetes manifests.
	StatusCode_DEPLOY_MANIFEST_WRITE_ERR StatusCode = 1020
	// Error getting images from a kubernetes manifest.
	StatusCode_DEPLOY_PARSE_MANIFEST_IMAGES_ERR StatusCode = 1021
	// Helm config `createNamespace` not available
	StatusCode_DEPLOY_HELM_CREATE_NS_NOT_AVAILABLE StatusCode = 1022
)

var StatusCode_name = map[int32]string{
	0:    "OK",
	200:  "STATUSCHECK_SUCCESS",
	201:  "BUILD_SUCCESS",
	202:  "DEPLOY_SUCCESS",
	203:  "TEST_SUCCESS",
	101:  "BUILD_PUSH_ACCESS_DENIED",
	102:  "BUILD_PROJECT_NOT_FOUND",
	103:  "BUILD_DOCKER_DAEMON_NOT_RUNNING",
	104:  "BUILD_USER_ERROR",
	105:  "BUILD_DOCKER_UNAVAILABLE",
	106:  "BUILD_DOCKER_UNAUTHORIZED",
	107:  "BUILD_DOCKER_SYSTEM_ERR",
	108:  "BUILD_DOCKER_NOT_MODIFIED_ERR",
	109:  "BUILD_DOCKER_NOT_IMPLEMENTED_ERR",
	110:  "BUILD_DOCKER_DATA_LOSS_ERR",
	111:  "BUILD_DOCKER_FORBIDDEN_ERR",
	112:  "BUILD_DOCKER_CONFLICT_ERR",
	113:  "BUILD_DOCKER_ERROR_NOT_FOUND",
	114:  "BUILD_DOCKER_INVALID_PARAM_ERR",
	115:  "BUILD_DOCKERFILE_NOT_FOUND",
	116:  "BUILD_DOCKER_CACHE_FROM_PULL_ERR",
	117:  "BUILD_DOCKER_GET_DIGEST_ERR",
	118:  "BUILD_REGISTRY_GET_DIGEST_ERR",
	119:  "BUILD_UNKNOWN_JIB_PLUGIN_TYPE",
	120:  "BUILD_JIB_GRADLE_DEP_ERR",
	121:  "BUILD_JIB_MAVEN_DEP_ERR",
	122:  "INIT_DOCKER_NETWORK_LISTING_CONTAINERS",
	123:  "INIT_DOCKER_NETWORK_INVALID_CONTAINER_NAME",
	124:  "INIT_DOCKER_NETWORK_CONTAINER_DOES_NOT_EXIST",
	300:  "STATUSCHECK_IMAGE_PULL_ERR",
	301:  "STATUSCHECK_CONTAINER_CREATING",
	302:  "STATUSCHECK_RUN_CONTAINER_ERR",
	303:  "STATUSCHECK_CONTAINER_TERMINATED",
	304:  "STATUSCHECK_DEPLOYMENT_ROLLOUT_PENDING",
	356:  "STATUSCHECK_CONTAINER_RESTARTING",
	357:  "STATUSCHECK_UNHEALTHY",
	400:  "STATUSCHECK_NODE_MEMORY_PRESSURE",
	401:  "STATUSCHECK_NODE_DISK_PRESSURE",
	402:  "STATUSCHECK_NODE_NETWORK_UNAVAILABLE",
	403:  "STATUSCHECK_NODE_PID_PRESSURE",
	404:  "STATUSCHECK_NODE_UNSCHEDULABLE",
	405:  "STATUSCHECK_NODE_UNREACHABLE",
	406:  "STATUSCHECK_NODE_NOT_READY",
	407:  "STATUSCHECK_FAILED_SCHEDULING",
	409:  "STATUSCHECK_KUBECTL_CONNECTION_ERR",
	410:  "STATUSCHECK_KUBECTL_PID_KILLED",
	411:  "STATUSCHECK_KUBECTL_CLIENT_FETCH_ERR",
	412:  "STATUSCHECK_DEPLOYMENT_FETCH_ERR",
	451:  "STATUSCHECK_POD_INITIALIZING",
	500:  "UNKNOWN_ERROR",
	501:  "STATUSCHECK_UNKNOWN",
	502:  "STATUSCHECK_UNKNOWN_UNSCHEDULABLE",
	503:  "STATUSCHECK_CONTAINER_WAITING_UNKNOWN",
	509:  "STATUSCHECK_UNKNOWN_EVENT",
	504:  "DEPLOY_UNKNOWN",
	505:  "SYNC_UNKNOWN",
	506:  "BUILD_UNKNOWN",
	507:  "DEVINIT_UNKNOWN",
	508:  "CLEANUP_UNKNOWN",
	510:  "INIT_UNKNOWN",
	511:  "BUILD_DOCKER_UNKNOWN",
	512:  "TEST_UNKNOWN",
	601:  "SYNC_INIT_ERROR",
	701:  "DEVINIT_REGISTER_BUILD_DEPS",
	702:  "DEVINIT_REGISTER_TEST_DEPS",
	703:  "DEVINIT_REGISTER_DEPLOY_DEPS",
	704:  "DEVINIT_REGISTER_CONFIG_DEP",
	705:  "DEVINIT_UNSUPPORTED_V1_MANIFEST",
	800:  "STATUSCHECK_USER_CANCELLED",
	801:  "STATUSCHECK_DEADLINE_EXCEEDED",
	802:  "BUILD_CANCELLED",
	803:  "DEPLOY_CANCELLED",
	804:  "BUILD_DOCKER_CANCELLED",
	805:  "BUILD_DOCKER_DEADLINE",
	901:  "INIT_CREATE_TAGGER_ERROR",
	902:  "INIT_MINIKUBE_PAUSED_ERROR",
	903:  "INIT_MINIKUBE_NOT_RUNNING_ERROR",
	904:  "INIT_CREATE_BUILDER_ERROR",
	905:  "INIT_CREATE_DEPLOYER_ERROR",
	906:  "INIT_CREATE_TEST_DEP_ERROR",
	907:  "INIT_CACHE_ERROR",
	908:  "INIT_CREATE_WATCH_TRIGGER_ERROR",
	909:  "INIT_CREATE_ARTIFACT_DEP_ERROR",
	1001: "DEPLOY_CLUSTER_CONNECTION_ERR",
	1002: "DEPLOY_DEBUG_HELPER_RETRIEVE_ERR",
	1003: "DEPLOY_CLEANUP_ERR",
	1004: "DEPLOY_HELM_APPLY_LABELS",
	1005: "DEPLOY_HELM_USER_ERR",
	1006: "DEPLOY_NO_MATCHING_BUILD",
	1007: "DEPLOY_HELM_VERSION_ERR",
	1008: "DEPLOY_HELM_MIN_VERSION_ERR",
	1109: "DEPLOY_KUBECTL_VERSION_ERR",
	1010: "DEPLOY_KUBECTL_OFFLINE_MODE_ERR",
	1011: "DEPLOY_ERR_WAITING_FOR_DELETION",
	1012: "DEPLOY_READ_MANIFEST_ERR",
	1013: "DEPLOY_READ_REMOTE_MANIFEST_ERR",
	1014: "DEPLOY_LIST_MANIFEST_ERR",
	1015: "DEPLOY_KUBECTL_USER_ERR",
	1016: "DEPLOY_KUSTOMIZE_USER_ERR",
	1017: "DEPLOY_REPLACE_IMAGE_ERR",
	1018: "DEPLOY_TRANSFORM_MANIFEST_ERR",
	1019: "DEPLOY_SET_LABEL_ERR",
	1020: "DEPLOY_MANIFEST_WRITE_ERR",
	1021: "DEPLOY_PARSE_MANIFEST_IMAGES_ERR",
	1022: "DEPLOY_HELM_CREATE_NS_NOT_AVAILABLE",
}

var StatusCode_value = map[string]int32{
	"OK":                                           0,
	"STATUSCHECK_SUCCESS":                          200,
	"BUILD_SUCCESS":                                201,
	"DEPLOY_SUCCESS":                               202,
	"TEST_SUCCESS":                                 203,
	"BUILD_PUSH_ACCESS_DENIED":                     101,
	"BUILD_PROJECT_NOT_FOUND":                      102,
	"BUILD_DOCKER_DAEMON_NOT_RUNNING":              103,
	"BUILD_USER_ERROR":                             104,
	"BUILD_DOCKER_UNAVAILABLE":                     105,
	"BUILD_DOCKER_UNAUTHORIZED":                    106,
	"BUILD_DOCKER_SYSTEM_ERR":                      107,
	"BUILD_DOCKER_NOT_MODIFIED_ERR":                108,
	"BUILD_DOCKER_NOT_IMPLEMENTED_ERR":             109,
	"BUILD_DOCKER_DATA_LOSS_ERR":                   110,
	"BUILD_DOCKER_FORBIDDEN_ERR":                   111,
	"BUILD_DOCKER_CONFLICT_ERR":                    112,
	"BUILD_DOCKER_ERROR_NOT_FOUND":                 113,
	"BUILD_DOCKER_INVALID_PARAM_ERR":               114,
	"BUILD_DOCKERFILE_NOT_FOUND":                   115,
	"BUILD_DOCKER_CACHE_FROM_PULL_ERR":             116,
	"BUILD_DOCKER_GET_DIGEST_ERR":                  117,
	"BUILD_REGISTRY_GET_DIGEST_ERR":                118,
	"BUILD_UNKNOWN_JIB_PLUGIN_TYPE":                119,
	"BUILD_JIB_GRADLE_DEP_ERR":                     120,
	"BUILD_JIB_MAVEN_DEP_ERR":                      121,
	"INIT_DOCKER_NETWORK_LISTING_CONTAINERS":       122,
	"INIT_DOCKER_NETWORK_INVALID_CONTAINER_NAME":   123,
	"INIT_DOCKER_NETWORK_CONTAINER_DOES_NOT_EXIST": 124,
	"STATUSCHECK_IMAGE_PULL_ERR":                   300,
	"STATUSCHECK_CONTAINER_CREATING":               301,
	"STATUSCHECK_RUN_CONTAINER_ERR":                302,
	"STATUSCHECK_CONTAINER_TERMINATED":             303,
	"STATUSCHECK_DEPLOYMENT_ROLLOUT_PENDING":       304,
	"STATUSCHECK_CONTAINER_RESTARTING":             356,
	"STATUSCHECK_UNHEALTHY":                        357,
	"STATUSCHECK_NODE_MEMORY_PRESSURE":             400,
	"STATUSCHECK_NODE_DISK_PRESSURE":               401,
	"STATUSCHECK_NODE_NETWORK_UNAVAILABLE":         402,
	"STATUSCHECK_NODE_PID_PRESSURE":                403,
	"STATUSCHECK_NODE_UNSCHEDULABLE":               404,
	"STATUSCHECK_NODE_UNREACHABLE":                 405,
	"STATUSCHECK_NODE_NOT_READY":                   406,
	"STATUSCHECK_FAILED_SCHEDULING":                407,
	"STATUSCHECK_KUBECTL_CONNECTION_ERR":           409,
	"STATUSCHECK_KUBECTL_PID_KILLED":               410,
	"STATUSCHECK_KUBECTL_CLIENT_FETCH_ERR":         411,
	"STATUSCHECK_DEPLOYMENT_FETCH_ERR":             412,
	"STATUSCHECK_POD_INITIALIZING":                 451,
	"UNKNOWN_ERROR":                                500,
	"STATUSCHECK_UNKNOWN":                          501,
	"STATUSCHECK_UNKNOWN_UNSCHEDULABLE":            502,
	"STATUSCHECK_CONTAINER_WAITING_UNKNOWN":        503,
	"STATUSCHECK_UNKNOWN_EVENT":                    509,
	"DEPLOY_UNKNOWN":                               504,
	"SYNC_UNKNOWN":                                 505,
	"BUILD_UNKNOWN":                                506,
	"DEVINIT_UNKNOWN":                              507,
	"CLEANUP_UNKNOWN":                              508,
	"INIT_UNKNOWN":                                 510,
	"BUILD_DOCKER_UNKNOWN":                         511,
	"TEST_UNKNOWN":                                 512,
	"SYNC_INIT_ERROR":                              601,
	"DEVINIT_REGISTER_BUILD_DEPS":                  701,
	"DEVINIT_REGISTER_TEST_DEPS":                   702,
	"DEVINIT_REGISTER_DEPLOY_DEPS":                 703,
	"DEVINIT_REGISTER_CONFIG_DEP":                  704,
	"DEVINIT_UNSUPPORTED_V1_MANIFEST":              705,
	"STATUSCHECK_USER_CANCELLED":                   800,
	"STATUSCHECK_DEADLINE_EXCEEDED":                801,
	"BUILD_CANCELLED":                              802,
	"DEPLOY_CANCELLED":                             803,
	"BUILD_DOCKER_CANCELLED":                       804,
	"BUILD_DOCKER_DEADLINE":                        805,
	"INIT_CREATE_TAGGER_ERROR":                     901,
	"INIT_MINIKUBE_PAUSED_ERROR":                   902,
	"INIT_MINIKUBE_NOT_RUNNING_ERROR":              903,
	"INIT_CREATE_BUILDER_ERROR":                    904,
	"INIT_CREATE_DEPLOYER_ERROR":                   905,
	"INIT_CREATE_TEST_DEP_ERROR":                   906,
	"INIT_CACHE_ERROR":                             907,
	"INIT_CREATE_WATCH_TRIGGER_ERROR":              908,
	"INIT_CREATE_ARTIFACT_DEP_ERROR":               909,
	"DEPLOY_CLUSTER_CONNECTION_ERR":                1001,
	"DEPLOY_DEBUG_HELPER_RETRIEVE_ERR":             1002,
	"DEPLOY_CLEANUP_ERR":                           1003,
	"DEPLOY_HELM_APPLY_LABELS":                     1004,
	"DEPLOY_HELM_USER_ERR":                         1005,
	"DEPLOY_NO_MATCHING_BUILD":                     1006,
	"DEPLOY_HELM_VERSION_ERR":                      1007,
	"DEPLOY_HELM_MIN_VERSION_ERR":                  1008,
	"DEPLOY_KUBECTL_VERSION_ERR":                   1109,
	"DEPLOY_KUBECTL_OFFLINE_MODE_ERR":              1010,
	"DEPLOY_ERR_WAITING_FOR_DELETION":              1011,
	"DEPLOY_READ_MANIFEST_ERR":                     1012,
	"DEPLOY_READ_REMOTE_MANIFEST_ERR":              1013,
	"DEPLOY_LIST_MANIFEST_ERR":                     1014,
	"DEPLOY_KUBECTL_USER_ERR":                      1015,
	"DEPLOY_KUSTOMIZE_USER_ERR":                    1016,
	"DEPLOY_REPLACE_IMAGE_ERR":                     1017,
	"DEPLOY_TRANSFORM_MANIFEST_ERR":                1018,
	"DEPLOY_SET_LABEL_ERR":                         1019,
	"DEPLOY_MANIFEST_WRITE_ERR":                    1020,
	"DEPLOY_PARSE_MANIFEST_IMAGES_ERR":             1021,
	"DEPLOY_HELM_CREATE_NS_NOT_AVAILABLE":          1022,
}

func (x StatusCode) String() string {
	return proto.EnumName(StatusCode_name, int32(x))
}

func (StatusCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{5}
}

// Enum for Suggestion codes
type SuggestionCode int32

const (
	// default nil suggestion.
	// This is usually set when no error happens.
	SuggestionCode_NIL SuggestionCode = 0
	// Add Default Repo
	SuggestionCode_ADD_DEFAULT_REPO SuggestionCode = 100
	// Verify Default Repo
	SuggestionCode_CHECK_DEFAULT_REPO SuggestionCode = 101
	// Verify default repo in the global config
	SuggestionCode_CHECK_DEFAULT_REPO_GLOBAL_CONFIG SuggestionCode = 102
	// run gcloud docker auth configure
	SuggestionCode_GCLOUD_DOCKER_AUTH_CONFIGURE SuggestionCode = 103
	// Run docker auth configure
	SuggestionCode_DOCKER_AUTH_CONFIGURE SuggestionCode = 104
	// Verify Gcloud Project
	SuggestionCode_CHECK_GCLOUD_PROJECT SuggestionCode = 105
	// Check if docker is running
	SuggestionCode_CHECK_DOCKER_RUNNING SuggestionCode = 106
	// Fix User Build Error
	SuggestionCode_FIX_USER_BUILD_ERR SuggestionCode = 107
	// Docker build internal error, try again
	SuggestionCode_DOCKER_BUILD_RETRY SuggestionCode = 108
	// Fix `cacheFrom` config for given artifact and try again
	SuggestionCode_FIX_CACHE_FROM_ARTIFACT_CONFIG SuggestionCode = 109
	// Fix `dockerfile` config for a given artifact and try again.
	SuggestionCode_FIX_SKAFFOLD_CONFIG_DOCKERFILE SuggestionCode = 110
	// Use a supported Jib plugin type
	SuggestionCode_FIX_JIB_PLUGIN_CONFIGURATION SuggestionCode = 111
	// Docker build network invalid docker container name (or id).
	SuggestionCode_FIX_DOCKER_NETWORK_CONTAINER_NAME SuggestionCode = 112
	// Docker build network container not existing in the current context.
	SuggestionCode_CHECK_DOCKER_NETWORK_CONTAINER_RUNNING SuggestionCode = 113
	// Check cluster connection
	SuggestionCode_CHECK_CLUSTER_CONNECTION SuggestionCode = 201
	// Check minikube status
	SuggestionCode_CHECK_MINIKUBE_STATUS SuggestionCode = 202
	// Install helm tool
	SuggestionCode_INSTALL_HELM SuggestionCode = 203
	// Upgrade helm tool
	SuggestionCode_UPGRADE_HELM SuggestionCode = 204
	// Fix helm `releases.artifactOverrides` config to match with `build.artiofacts`
	SuggestionCode_FIX_SKAFFOLD_CONFIG_HELM_ARTIFACT_OVERRIDES SuggestionCode = 205
	// Upgrade helm version to v3.2.0 and higher.
	SuggestionCode_UPGRADE_HELM32 SuggestionCode = 206
	// Set `releases.createNamespace` to false.
	SuggestionCode_FIX_SKAFFOLD_CONFIG_HELM_CREATE_NAMESPACE SuggestionCode = 207
	// Install kubectl tool
	SuggestionCode_INSTALL_KUBECTL SuggestionCode = 220
	// Container run error
	SuggestionCode_CHECK_CONTAINER_LOGS SuggestionCode = 301
	// Pod Health check error
	SuggestionCode_CHECK_READINESS_PROBE SuggestionCode = 302
	// Check Container image
	SuggestionCode_CHECK_CONTAINER_IMAGE SuggestionCode = 303
	// Node pressure error
	SuggestionCode_ADDRESS_NODE_MEMORY_PRESSURE SuggestionCode = 400
	// Node disk pressure error
	SuggestionCode_ADDRESS_NODE_DISK_PRESSURE SuggestionCode = 401
	// Node network unavailable error
	SuggestionCode_ADDRESS_NODE_NETWORK_UNAVAILABLE SuggestionCode = 402
	// Node PID pressure error
	SuggestionCode_ADDRESS_NODE_PID_PRESSURE SuggestionCode = 403
	// Node unschedulable error
	SuggestionCode_ADDRESS_NODE_UNSCHEDULABLE SuggestionCode = 404
	// Node unreachable error
	SuggestionCode_ADDRESS_NODE_UNREACHABLE SuggestionCode = 405
	// Node not ready error
	SuggestionCode_ADDRESS_NODE_NOT_READY SuggestionCode = 406
	// Scheduler failure error
	SuggestionCode_ADDRESS_FAILED_SCHEDULING SuggestionCode = 407
	// Cluster Connectivity error
	SuggestionCode_CHECK_HOST_CONNECTION SuggestionCode = 408
	// Minikube is stopped: use `minikube start`
	SuggestionCode_START_MINIKUBE SuggestionCode = 501
	// Minikube is paused: use `minikube unpause`
	SuggestionCode_UNPAUSE_MINIKUBE SuggestionCode = 502
	// Run Docker pull for the image with v1 manifest and try again.
	SuggestionCode_RUN_DOCKER_PULL SuggestionCode = 551
	// Rerun with correct offline flag value.
	SuggestionCode_SET_RENDER_FLAG_OFFLINE_FALSE SuggestionCode = 600
	// Open an issue so this situation can be diagnosed
	SuggestionCode_OPEN_ISSUE SuggestionCode = 900
)

var SuggestionCode_name = map[int32]string{
	0:   "NIL",
	100: "ADD_DEFAULT_REPO",
	101: "CHECK_DEFAULT_REPO",
	102: "CHECK_DEFAULT_REPO_GLOBAL_CONFIG",
	103: "GCLOUD_DOCKER_AUTH_CONFIGURE",
	104: "DOCKER_AUTH_CONFIGURE",
	105: "CHECK_GCLOUD_PROJECT",
	106: "CHECK_DOCKER_RUNNING",
	107: "FIX_USER_BUILD_ERR",
	108: "DOCKER_BUILD_RETRY",
	109: "FIX_CACHE_FROM_ARTIFACT_CONFIG",
	110: "FIX_SKAFFOLD_CONFIG_DOCKERFILE",
	111: "FIX_JIB_PLUGIN_CONFIGURATION",
	112: "FIX_DOCKER_NETWORK_CONTAINER_NAME",
	113: "CHECK_DOCKER_NETWORK_CONTAINER_RUNNING",
	201: "CHECK_CLUSTER_CONNECTION",
	202: "CHECK_MINIKUBE_STATUS",
	203: "INSTALL_HELM",
	204: "UPGRADE_HELM",
	205: "FIX_SKAFFOLD_CONFIG_HELM_ARTIFACT_OVERRIDES",
	206: "UPGRADE_HELM32",
	207: "FIX_SKAFFOLD_CONFIG_HELM_CREATE_NAMESPACE",
	220: "INSTALL_KUBECTL",
	301: "CHECK_CONTAINER_LOGS",
	302: "CHECK_READINESS_PROBE",
	303: "CHECK_CONTAINER_IMAGE",
	400: "ADDRESS_NODE_MEMORY_PRESSURE",
	401: "ADDRESS_NODE_DISK_PRESSURE",
	402: "ADDRESS_NODE_NETWORK_UNAVAILABLE",
	403: "ADDRESS_NODE_PID_PRESSURE",
	404: "ADDRESS_NODE_UNSCHEDULABLE",
	405: "ADDRESS_NODE_UNREACHABLE",
	406: "ADDRESS_NODE_NOT_READY",
	407: "ADDRESS_FAILED_SCHEDULING",
	408: "CHECK_HOST_CONNECTION",
	501: "START_MINIKUBE",
	502: "UNPAUSE_MINIKUBE",
	551: "RUN_DOCKER_PULL",
	600: "SET_RENDER_FLAG_OFFLINE_FALSE",
	900: "OPEN_ISSUE",
}

var SuggestionCode_value = map[string]int32{
	"NIL":                                         0,
	"ADD_DEFAULT_REPO":                            100,
	"CHECK_DEFAULT_REPO":                          101,
	"CHECK_DEFAULT_REPO_GLOBAL_CONFIG":            102,
	"GCLOUD_DOCKER_AUTH_CONFIGURE":                103,
	"DOCKER_AUTH_CONFIGURE":                       104,
	"CHECK_GCLOUD_PROJECT":                        105,
	"CHECK_DOCKER_RUNNING":                        106,
	"FIX_USER_BUILD_ERR":                          107,
	"DOCKER_BUILD_RETRY":                          108,
	"FIX_CACHE_FROM_ARTIFACT_CONFIG":              109,
	"FIX_SKAFFOLD_CONFIG_DOCKERFILE":              110,
	"FIX_JIB_PLUGIN_CONFIGURATION":                111,
	"FIX_DOCKER_NETWORK_CONTAINER_NAME":           112,
	"CHECK_DOCKER_NETWORK_CONTAINER_RUNNING":      113,
	"CHECK_CLUSTER_CONNECTION":                    201,
	"CHECK_MINIKUBE_STATUS":                       202,
	"INSTALL_HELM":                                203,
	"UPGRADE_HELM":                                204,
	"FIX_SKAFFOLD_CONFIG_HELM_ARTIFACT_OVERRIDES": 205,
	"UPGRADE_HELM32":                              206,
	"FIX_SKAFFOLD_CONFIG_HELM_CREATE_NAMESPACE":   207,
	"INSTALL_KUBECTL":                             220,
	"CHECK_CONTAINER_LOGS":                        301,
	"CHECK_READINESS_PROBE":                       302,
	"CHECK_CONTAINER_IMAGE":                       303,
	"ADDRESS_NODE_MEMORY_PRESSURE":                400,
	"ADDRESS_NODE_DISK_PRESSURE":                  401,
	"ADDRESS_NODE_NETWORK_UNAVAILABLE":            402,
	"ADDRESS_NODE_PID_PRESSURE":                   403,
	"ADDRESS_NODE_UNSCHEDULABLE":                  404,
	"ADDRESS_NODE_UNREACHABLE":                    405,
	"ADDRESS_NODE_NOT_READY":                      406,
	"ADDRESS_FAILED_SCHEDULING":                   407,
	"CHECK_HOST_CONNECTION":                       408,
	"START_MINIKUBE":                              501,
	"UNPAUSE_MINIKUBE":                            502,
	"RUN_DOCKER_PULL":                             551,
	"SET_RENDER_FLAG_OFFLINE_FALSE":               600,
	"OPEN_ISSUE":                                  900,
}

func (x SuggestionCode) String() string {
	return proto.EnumName(SuggestionCode_name, int32(x))
}

func (SuggestionCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{6}
}

type StateResponse struct {
	State                *State   `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateResponse) Reset()         { *m = StateResponse{} }
func (m *StateResponse) String() string { return proto.CompactTextString(m) }
func (*StateResponse) ProtoMessage()    {}
func (*StateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{0}
}

func (m *StateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateResponse.Unmarshal(m, b)
}
func (m *StateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateResponse.Marshal(b, m, deterministic)
}
func (m *StateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateResponse.Merge(m, src)
}
func (m *StateResponse) XXX_Size() int {
	return xxx_messageInfo_StateResponse.Size(m)
}
func (m *StateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateResponse proto.InternalMessageInfo

func (m *StateResponse) GetState() *State {
	if m != nil {
		return m.State
	}
	return nil
}

type Response struct {
	Msg                  string   `protobuf:"bytes,1,opt,name=msg,proto3" json:"msg,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Response) Reset()         { *m = Response{} }
func (m *Response) String() string { return proto.CompactTextString(m) }
func (*Response) ProtoMessage()    {}
func (*Response) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{1}
}

func (m *Response) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Response.Unmarshal(m, b)
}
func (m *Response) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Response.Marshal(b, m, deterministic)
}
func (m *Response) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Response.Merge(m, src)
}
func (m *Response) XXX_Size() int {
	return xxx_messageInfo_Response.Size(m)
}
func (m *Response) XXX_DiscardUnknown() {
	xxx_messageInfo_Response.DiscardUnknown(m)
}

var xxx_messageInfo_Response proto.InternalMessageInfo

func (m *Response) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

type Request struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Request) Reset()         { *m = Request{} }
func (m *Request) String() string { return proto.CompactTextString(m) }
func (*Request) ProtoMessage()    {}
func (*Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{2}
}

func (m *Request) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Request.Unmarshal(m, b)
}
func (m *Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Request.Marshal(b, m, deterministic)
}
func (m *Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Request.Merge(m, src)
}
func (m *Request) XXX_Size() int {
	return xxx_messageInfo_Request.Size(m)
}
func (m *Request) XXX_DiscardUnknown() {
	xxx_messageInfo_Request.DiscardUnknown(m)
}

var xxx_messageInfo_Request proto.InternalMessageInfo

func (m *Request) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// `State` represents the current state of the Skaffold components
type State struct {
	BuildState           *BuildState                `protobuf:"bytes,1,opt,name=buildState,proto3" json:"buildState,omitempty"`
	DeployState          *DeployState               `protobuf:"bytes,2,opt,name=deployState,proto3" json:"deployState,omitempty"`
	ForwardedPorts       map[int32]*PortEvent       `protobuf:"bytes,4,rep,name=forwardedPorts,proto3" json:"forwardedPorts,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	StatusCheckState     *StatusCheckState          `protobuf:"bytes,5,opt,name=statusCheckState,proto3" json:"statusCheckState,omitempty"`
	FileSyncState        *FileSyncState             `protobuf:"bytes,6,opt,name=fileSyncState,proto3" json:"fileSyncState,omitempty"`
	DebuggingContainers  []*DebuggingContainerEvent `protobuf:"bytes,7,rep,name=debuggingContainers,proto3" json:"debuggingContainers,omitempty"`
	Metadata             *Metadata                  `protobuf:"bytes,8,opt,name=metadata,proto3" json:"metadata,omitempty"`
	TestState            *TestState                 `protobuf:"bytes,9,opt,name=testState,proto3" json:"testState,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *State) Reset()         { *m = State{} }
func (m *State) String() string { return proto.CompactTextString(m) }
func (*State) ProtoMessage()    {}
func (*State) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{3}
}

func (m *State) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_State.Unmarshal(m, b)
}
func (m *State) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_State.Marshal(b, m, deterministic)
}
func (m *State) XXX_Merge(src proto.Message) {
	xxx_messageInfo_State.Merge(m, src)
}
func (m *State) XXX_Size() int {
	return xxx_messageInfo_State.Size(m)
}
func (m *State) XXX_DiscardUnknown() {
	xxx_messageInfo_State.DiscardUnknown(m)
}

var xxx_messageInfo_State proto.InternalMessageInfo

func (m *State) GetBuildState() *BuildState {
	if m != nil {
		return m.BuildState
	}
	return nil
}

func (m *State) GetDeployState() *DeployState {
	if m != nil {
		return m.DeployState
	}
	return nil
}

func (m *State) GetForwardedPorts() map[int32]*PortEvent {
	if m != nil {
		return m.ForwardedPorts
	}
	return nil
}

func (m *State) GetStatusCheckState() *StatusCheckState {
	if m != nil {
		return m.StatusCheckState
	}
	return nil
}

func (m *State) GetFileSyncState() *FileSyncState {
	if m != nil {
		return m.FileSyncState
	}
	return nil
}

func (m *State) GetDebuggingContainers() []*DebuggingContainerEvent {
	if m != nil {
		return m.DebuggingContainers
	}
	return nil
}

func (m *State) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *State) GetTestState() *TestState {
	if m != nil {
		return m.TestState
	}
	return nil
}

type Metadata struct {
	Build  *BuildMetadata  `protobuf:"bytes,1,opt,name=build,proto3" json:"build,omitempty"`
	Deploy *DeployMetadata `protobuf:"bytes,2,opt,name=deploy,proto3" json:"deploy,omitempty"`
	Test   *TestMetadata   `protobuf:"bytes,3,opt,name=test,proto3" json:"test,omitempty"`
	// Additional key value pairs to describe the build pipeline
	Additional           map[string]string `protobuf:"bytes,99,rep,name=additional,proto3" json:"additional,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Metadata) Reset()         { *m = Metadata{} }
func (m *Metadata) String() string { return proto.CompactTextString(m) }
func (*Metadata) ProtoMessage()    {}
func (*Metadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{4}
}

func (m *Metadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metadata.Unmarshal(m, b)
}
func (m *Metadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metadata.Marshal(b, m, deterministic)
}
func (m *Metadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metadata.Merge(m, src)
}
func (m *Metadata) XXX_Size() int {
	return xxx_messageInfo_Metadata.Size(m)
}
func (m *Metadata) XXX_DiscardUnknown() {
	xxx_messageInfo_Metadata.DiscardUnknown(m)
}

var xxx_messageInfo_Metadata proto.InternalMessageInfo

func (m *Metadata) GetBuild() *BuildMetadata {
	if m != nil {
		return m.Build
	}
	return nil
}

func (m *Metadata) GetDeploy() *DeployMetadata {
	if m != nil {
		return m.Deploy
	}
	return nil
}

func (m *Metadata) GetTest() *TestMetadata {
	if m != nil {
		return m.Test
	}
	return nil
}

func (m *Metadata) GetAdditional() map[string]string {
	if m != nil {
		return m.Additional
	}
	return nil
}

type BuildMetadata struct {
	NumberOfArtifacts int32                         `protobuf:"varint,1,opt,name=numberOfArtifacts,proto3" json:"numberOfArtifacts,omitempty"`
	Builders          []*BuildMetadata_ImageBuilder `protobuf:"bytes,2,rep,name=builders,proto3" json:"builders,omitempty"`
	Type              BuildType                     `protobuf:"varint,3,opt,name=type,proto3,enum=proto.BuildType" json:"type,omitempty"`
	// Additional key value pairs to describe the deploy pipeline
	Additional           map[string]string `protobuf:"bytes,99,rep,name=additional,proto3" json:"additional,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *BuildMetadata) Reset()         { *m = BuildMetadata{} }
func (m *BuildMetadata) String() string { return proto.CompactTextString(m) }
func (*BuildMetadata) ProtoMessage()    {}
func (*BuildMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{5}
}

func (m *BuildMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildMetadata.Unmarshal(m, b)
}
func (m *BuildMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildMetadata.Marshal(b, m, deterministic)
}
func (m *BuildMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildMetadata.Merge(m, src)
}
func (m *BuildMetadata) XXX_Size() int {
	return xxx_messageInfo_BuildMetadata.Size(m)
}
func (m *BuildMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_BuildMetadata proto.InternalMessageInfo

func (m *BuildMetadata) GetNumberOfArtifacts() int32 {
	if m != nil {
		return m.NumberOfArtifacts
	}
	return 0
}

func (m *BuildMetadata) GetBuilders() []*BuildMetadata_ImageBuilder {
	if m != nil {
		return m.Builders
	}
	return nil
}

func (m *BuildMetadata) GetType() BuildType {
	if m != nil {
		return m.Type
	}
	return BuildType_UNKNOWN_BUILD_TYPE
}

func (m *BuildMetadata) GetAdditional() map[string]string {
	if m != nil {
		return m.Additional
	}
	return nil
}

type BuildMetadata_ImageBuilder struct {
	Type                 BuilderType `protobuf:"varint,1,opt,name=type,proto3,enum=proto.BuilderType" json:"type,omitempty"`
	Count                int32       `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *BuildMetadata_ImageBuilder) Reset()         { *m = BuildMetadata_ImageBuilder{} }
func (m *BuildMetadata_ImageBuilder) String() string { return proto.CompactTextString(m) }
func (*BuildMetadata_ImageBuilder) ProtoMessage()    {}
func (*BuildMetadata_ImageBuilder) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{5, 0}
}

func (m *BuildMetadata_ImageBuilder) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildMetadata_ImageBuilder.Unmarshal(m, b)
}
func (m *BuildMetadata_ImageBuilder) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildMetadata_ImageBuilder.Marshal(b, m, deterministic)
}
func (m *BuildMetadata_ImageBuilder) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildMetadata_ImageBuilder.Merge(m, src)
}
func (m *BuildMetadata_ImageBuilder) XXX_Size() int {
	return xxx_messageInfo_BuildMetadata_ImageBuilder.Size(m)
}
func (m *BuildMetadata_ImageBuilder) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildMetadata_ImageBuilder.DiscardUnknown(m)
}

var xxx_messageInfo_BuildMetadata_ImageBuilder proto.InternalMessageInfo

func (m *BuildMetadata_ImageBuilder) GetType() BuilderType {
	if m != nil {
		return m.Type
	}
	return BuilderType_UNKNOWN_BUILDER_TYPE
}

func (m *BuildMetadata_ImageBuilder) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

// TestMetadata describes the test pipeline
type TestMetadata struct {
	Testers              []*TestMetadata_Tester `protobuf:"bytes,1,rep,name=Testers,proto3" json:"Testers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *TestMetadata) Reset()         { *m = TestMetadata{} }
func (m *TestMetadata) String() string { return proto.CompactTextString(m) }
func (*TestMetadata) ProtoMessage()    {}
func (*TestMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{6}
}

func (m *TestMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestMetadata.Unmarshal(m, b)
}
func (m *TestMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestMetadata.Marshal(b, m, deterministic)
}
func (m *TestMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestMetadata.Merge(m, src)
}
func (m *TestMetadata) XXX_Size() int {
	return xxx_messageInfo_TestMetadata.Size(m)
}
func (m *TestMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_TestMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_TestMetadata proto.InternalMessageInfo

func (m *TestMetadata) GetTesters() []*TestMetadata_Tester {
	if m != nil {
		return m.Testers
	}
	return nil
}

type TestMetadata_Tester struct {
	Type                 TesterType `protobuf:"varint,1,opt,name=type,proto3,enum=proto.TesterType" json:"type,omitempty"`
	Count                int32      `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *TestMetadata_Tester) Reset()         { *m = TestMetadata_Tester{} }
func (m *TestMetadata_Tester) String() string { return proto.CompactTextString(m) }
func (*TestMetadata_Tester) ProtoMessage()    {}
func (*TestMetadata_Tester) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{6, 0}
}

func (m *TestMetadata_Tester) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestMetadata_Tester.Unmarshal(m, b)
}
func (m *TestMetadata_Tester) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestMetadata_Tester.Marshal(b, m, deterministic)
}
func (m *TestMetadata_Tester) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestMetadata_Tester.Merge(m, src)
}
func (m *TestMetadata_Tester) XXX_Size() int {
	return xxx_messageInfo_TestMetadata_Tester.Size(m)
}
func (m *TestMetadata_Tester) XXX_DiscardUnknown() {
	xxx_messageInfo_TestMetadata_Tester.DiscardUnknown(m)
}

var xxx_messageInfo_TestMetadata_Tester proto.InternalMessageInfo

func (m *TestMetadata_Tester) GetType() TesterType {
	if m != nil {
		return m.Type
	}
	return TesterType_UNKNOWN_TEST_TYPE
}

func (m *TestMetadata_Tester) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

type DeployMetadata struct {
	Deployers            []*DeployMetadata_Deployer `protobuf:"bytes,1,rep,name=deployers,proto3" json:"deployers,omitempty"`
	Cluster              ClusterType                `protobuf:"varint,2,opt,name=cluster,proto3,enum=proto.ClusterType" json:"cluster,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *DeployMetadata) Reset()         { *m = DeployMetadata{} }
func (m *DeployMetadata) String() string { return proto.CompactTextString(m) }
func (*DeployMetadata) ProtoMessage()    {}
func (*DeployMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{7}
}

func (m *DeployMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployMetadata.Unmarshal(m, b)
}
func (m *DeployMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployMetadata.Marshal(b, m, deterministic)
}
func (m *DeployMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployMetadata.Merge(m, src)
}
func (m *DeployMetadata) XXX_Size() int {
	return xxx_messageInfo_DeployMetadata.Size(m)
}
func (m *DeployMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeployMetadata proto.InternalMessageInfo

func (m *DeployMetadata) GetDeployers() []*DeployMetadata_Deployer {
	if m != nil {
		return m.Deployers
	}
	return nil
}

func (m *DeployMetadata) GetCluster() ClusterType {
	if m != nil {
		return m.Cluster
	}
	return ClusterType_UNKNOWN_CLUSTER_TYPE
}

type DeployMetadata_Deployer struct {
	Type                 DeployerType `protobuf:"varint,1,opt,name=type,proto3,enum=proto.DeployerType" json:"type,omitempty"`
	Count                int32        `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *DeployMetadata_Deployer) Reset()         { *m = DeployMetadata_Deployer{} }
func (m *DeployMetadata_Deployer) String() string { return proto.CompactTextString(m) }
func (*DeployMetadata_Deployer) ProtoMessage()    {}
func (*DeployMetadata_Deployer) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{7, 0}
}

func (m *DeployMetadata_Deployer) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployMetadata_Deployer.Unmarshal(m, b)
}
func (m *DeployMetadata_Deployer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployMetadata_Deployer.Marshal(b, m, deterministic)
}
func (m *DeployMetadata_Deployer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployMetadata_Deployer.Merge(m, src)
}
func (m *DeployMetadata_Deployer) XXX_Size() int {
	return xxx_messageInfo_DeployMetadata_Deployer.Size(m)
}
func (m *DeployMetadata_Deployer) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployMetadata_Deployer.DiscardUnknown(m)
}

var xxx_messageInfo_DeployMetadata_Deployer proto.InternalMessageInfo

func (m *DeployMetadata_Deployer) GetType() DeployerType {
	if m != nil {
		return m.Type
	}
	return DeployerType_UNKNOWN_DEPLOYER_TYPE
}

func (m *DeployMetadata_Deployer) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

// `BuildState` maps Skaffold artifacts to their current build states
type BuildState struct {
	// A map of `artifact name -> build-state`.
	// Artifact name is defined in the `skaffold.yaml`.
	// The `build-state` can be: <br>
	// - `"Not started"`: not yet started <br>
	// - `"In progress"`: build started <br>
	// - `"Complete"`: build succeeded <br>
	// - `"Failed"`: build failed
	Artifacts            map[string]string `protobuf:"bytes,1,rep,name=artifacts,proto3" json:"artifacts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	AutoTrigger          bool              `protobuf:"varint,2,opt,name=autoTrigger,proto3" json:"autoTrigger,omitempty"`
	StatusCode           StatusCode        `protobuf:"varint,3,opt,name=statusCode,proto3,enum=proto.StatusCode" json:"statusCode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *BuildState) Reset()         { *m = BuildState{} }
func (m *BuildState) String() string { return proto.CompactTextString(m) }
func (*BuildState) ProtoMessage()    {}
func (*BuildState) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{8}
}

func (m *BuildState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildState.Unmarshal(m, b)
}
func (m *BuildState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildState.Marshal(b, m, deterministic)
}
func (m *BuildState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildState.Merge(m, src)
}
func (m *BuildState) XXX_Size() int {
	return xxx_messageInfo_BuildState.Size(m)
}
func (m *BuildState) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildState.DiscardUnknown(m)
}

var xxx_messageInfo_BuildState proto.InternalMessageInfo

func (m *BuildState) GetArtifacts() map[string]string {
	if m != nil {
		return m.Artifacts
	}
	return nil
}

func (m *BuildState) GetAutoTrigger() bool {
	if m != nil {
		return m.AutoTrigger
	}
	return false
}

func (m *BuildState) GetStatusCode() StatusCode {
	if m != nil {
		return m.StatusCode
	}
	return StatusCode_OK
}

// `TestState` describes the current state of the test
type TestState struct {
	// Status of the current test
	Status string `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Teststate status code
	StatusCode           StatusCode `protobuf:"varint,2,opt,name=statusCode,proto3,enum=proto.StatusCode" json:"statusCode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *TestState) Reset()         { *m = TestState{} }
func (m *TestState) String() string { return proto.CompactTextString(m) }
func (*TestState) ProtoMessage()    {}
func (*TestState) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{9}
}

func (m *TestState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestState.Unmarshal(m, b)
}
func (m *TestState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestState.Marshal(b, m, deterministic)
}
func (m *TestState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestState.Merge(m, src)
}
func (m *TestState) XXX_Size() int {
	return xxx_messageInfo_TestState.Size(m)
}
func (m *TestState) XXX_DiscardUnknown() {
	xxx_messageInfo_TestState.DiscardUnknown(m)
}

var xxx_messageInfo_TestState proto.InternalMessageInfo

func (m *TestState) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *TestState) GetStatusCode() StatusCode {
	if m != nil {
		return m.StatusCode
	}
	return StatusCode_OK
}

// `DeployState` describes the status of the current deploy
type DeployState struct {
	Status               string     `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	AutoTrigger          bool       `protobuf:"varint,2,opt,name=autoTrigger,proto3" json:"autoTrigger,omitempty"`
	StatusCode           StatusCode `protobuf:"varint,3,opt,name=statusCode,proto3,enum=proto.StatusCode" json:"statusCode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *DeployState) Reset()         { *m = DeployState{} }
func (m *DeployState) String() string { return proto.CompactTextString(m) }
func (*DeployState) ProtoMessage()    {}
func (*DeployState) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{10}
}

func (m *DeployState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployState.Unmarshal(m, b)
}
func (m *DeployState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployState.Marshal(b, m, deterministic)
}
func (m *DeployState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployState.Merge(m, src)
}
func (m *DeployState) XXX_Size() int {
	return xxx_messageInfo_DeployState.Size(m)
}
func (m *DeployState) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployState.DiscardUnknown(m)
}

var xxx_messageInfo_DeployState proto.InternalMessageInfo

func (m *DeployState) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *DeployState) GetAutoTrigger() bool {
	if m != nil {
		return m.AutoTrigger
	}
	return false
}

func (m *DeployState) GetStatusCode() StatusCode {
	if m != nil {
		return m.StatusCode
	}
	return StatusCode_OK
}

// `StatusCheckState` describes the state of status check of current deployed resources.
type StatusCheckState struct {
	Status string `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// A map of `resource name -> status-check-state`. Where `resource-name` is the kubernetes resource name.
	// The `status-check-state` can be <br>
	// - `"Not started"`: indicates that `status-check` has just started. <br>
	// - `"In progress"`: InProgress is sent after every resource check is complete. <br>
	// - `"Succeeded"`:
	// - `"Failed"`:
	Resources map[string]string `protobuf:"bytes,2,rep,name=resources,proto3" json:"resources,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// StatusCheck statusCode
	StatusCode           StatusCode `protobuf:"varint,3,opt,name=statusCode,proto3,enum=proto.StatusCode" json:"statusCode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *StatusCheckState) Reset()         { *m = StatusCheckState{} }
func (m *StatusCheckState) String() string { return proto.CompactTextString(m) }
func (*StatusCheckState) ProtoMessage()    {}
func (*StatusCheckState) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{11}
}

func (m *StatusCheckState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StatusCheckState.Unmarshal(m, b)
}
func (m *StatusCheckState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StatusCheckState.Marshal(b, m, deterministic)
}
func (m *StatusCheckState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatusCheckState.Merge(m, src)
}
func (m *StatusCheckState) XXX_Size() int {
	return xxx_messageInfo_StatusCheckState.Size(m)
}
func (m *StatusCheckState) XXX_DiscardUnknown() {
	xxx_messageInfo_StatusCheckState.DiscardUnknown(m)
}

var xxx_messageInfo_StatusCheckState proto.InternalMessageInfo

func (m *StatusCheckState) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *StatusCheckState) GetResources() map[string]string {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *StatusCheckState) GetStatusCode() StatusCode {
	if m != nil {
		return m.StatusCode
	}
	return StatusCode_OK
}

// `FileSyncState` contains the status of the current file sync
type FileSyncState struct {
	Status               string   `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	AutoTrigger          bool     `protobuf:"varint,2,opt,name=autoTrigger,proto3" json:"autoTrigger,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FileSyncState) Reset()         { *m = FileSyncState{} }
func (m *FileSyncState) String() string { return proto.CompactTextString(m) }
func (*FileSyncState) ProtoMessage()    {}
func (*FileSyncState) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{12}
}

func (m *FileSyncState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FileSyncState.Unmarshal(m, b)
}
func (m *FileSyncState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FileSyncState.Marshal(b, m, deterministic)
}
func (m *FileSyncState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileSyncState.Merge(m, src)
}
func (m *FileSyncState) XXX_Size() int {
	return xxx_messageInfo_FileSyncState.Size(m)
}
func (m *FileSyncState) XXX_DiscardUnknown() {
	xxx_messageInfo_FileSyncState.DiscardUnknown(m)
}

var xxx_messageInfo_FileSyncState proto.InternalMessageInfo

func (m *FileSyncState) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *FileSyncState) GetAutoTrigger() bool {
	if m != nil {
		return m.AutoTrigger
	}
	return false
}

// `Event` describes an event in the Skaffold process.
// It is one of MetaEvent, BuildEvent, TestEvent, DeployEvent, PortEvent, StatusCheckEvent, ResourceStatusCheckEvent, FileSyncEvent, or DebuggingContainerEvent.
type Event struct {
	// Types that are valid to be assigned to EventType:
	//	*Event_MetaEvent
	//	*Event_BuildEvent
	//	*Event_DeployEvent
	//	*Event_PortEvent
	//	*Event_StatusCheckEvent
	//	*Event_ResourceStatusCheckEvent
	//	*Event_FileSyncEvent
	//	*Event_DebuggingContainerEvent
	//	*Event_DevLoopEvent
	//	*Event_TerminationEvent
	//	*Event_TestEvent
	EventType            isEvent_EventType `protobuf_oneof:"event_type"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{13}
}

func (m *Event) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Event.Unmarshal(m, b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Event.Marshal(b, m, deterministic)
}
func (m *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(m, src)
}
func (m *Event) XXX_Size() int {
	return xxx_messageInfo_Event.Size(m)
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

type isEvent_EventType interface {
	isEvent_EventType()
}

type Event_MetaEvent struct {
	MetaEvent *MetaEvent `protobuf:"bytes,1,opt,name=metaEvent,proto3,oneof"`
}

type Event_BuildEvent struct {
	BuildEvent *BuildEvent `protobuf:"bytes,2,opt,name=buildEvent,proto3,oneof"`
}

type Event_DeployEvent struct {
	DeployEvent *DeployEvent `protobuf:"bytes,3,opt,name=deployEvent,proto3,oneof"`
}

type Event_PortEvent struct {
	PortEvent *PortEvent `protobuf:"bytes,4,opt,name=portEvent,proto3,oneof"`
}

type Event_StatusCheckEvent struct {
	StatusCheckEvent *StatusCheckEvent `protobuf:"bytes,5,opt,name=statusCheckEvent,proto3,oneof"`
}

type Event_ResourceStatusCheckEvent struct {
	ResourceStatusCheckEvent *ResourceStatusCheckEvent `protobuf:"bytes,6,opt,name=resourceStatusCheckEvent,proto3,oneof"`
}

type Event_FileSyncEvent struct {
	FileSyncEvent *FileSyncEvent `protobuf:"bytes,7,opt,name=fileSyncEvent,proto3,oneof"`
}

type Event_DebuggingContainerEvent struct {
	DebuggingContainerEvent *DebuggingContainerEvent `protobuf:"bytes,8,opt,name=debuggingContainerEvent,proto3,oneof"`
}

type Event_DevLoopEvent struct {
	DevLoopEvent *DevLoopEvent `protobuf:"bytes,9,opt,name=devLoopEvent,proto3,oneof"`
}

type Event_TerminationEvent struct {
	TerminationEvent *TerminationEvent `protobuf:"bytes,10,opt,name=terminationEvent,proto3,oneof"`
}

type Event_TestEvent struct {
	TestEvent *TestEvent `protobuf:"bytes,11,opt,name=TestEvent,proto3,oneof"`
}

func (*Event_MetaEvent) isEvent_EventType() {}

func (*Event_BuildEvent) isEvent_EventType() {}

func (*Event_DeployEvent) isEvent_EventType() {}

func (*Event_PortEvent) isEvent_EventType() {}

func (*Event_StatusCheckEvent) isEvent_EventType() {}

func (*Event_ResourceStatusCheckEvent) isEvent_EventType() {}

func (*Event_FileSyncEvent) isEvent_EventType() {}

func (*Event_DebuggingContainerEvent) isEvent_EventType() {}

func (*Event_DevLoopEvent) isEvent_EventType() {}

func (*Event_TerminationEvent) isEvent_EventType() {}

func (*Event_TestEvent) isEvent_EventType() {}

func (m *Event) GetEventType() isEvent_EventType {
	if m != nil {
		return m.EventType
	}
	return nil
}

func (m *Event) GetMetaEvent() *MetaEvent {
	if x, ok := m.GetEventType().(*Event_MetaEvent); ok {
		return x.MetaEvent
	}
	return nil
}

func (m *Event) GetBuildEvent() *BuildEvent {
	if x, ok := m.GetEventType().(*Event_BuildEvent); ok {
		return x.BuildEvent
	}
	return nil
}

func (m *Event) GetDeployEvent() *DeployEvent {
	if x, ok := m.GetEventType().(*Event_DeployEvent); ok {
		return x.DeployEvent
	}
	return nil
}

func (m *Event) GetPortEvent() *PortEvent {
	if x, ok := m.GetEventType().(*Event_PortEvent); ok {
		return x.PortEvent
	}
	return nil
}

func (m *Event) GetStatusCheckEvent() *StatusCheckEvent {
	if x, ok := m.GetEventType().(*Event_StatusCheckEvent); ok {
		return x.StatusCheckEvent
	}
	return nil
}

func (m *Event) GetResourceStatusCheckEvent() *ResourceStatusCheckEvent {
	if x, ok := m.GetEventType().(*Event_ResourceStatusCheckEvent); ok {
		return x.ResourceStatusCheckEvent
	}
	return nil
}

func (m *Event) GetFileSyncEvent() *FileSyncEvent {
	if x, ok := m.GetEventType().(*Event_FileSyncEvent); ok {
		return x.FileSyncEvent
	}
	return nil
}

func (m *Event) GetDebuggingContainerEvent() *DebuggingContainerEvent {
	if x, ok := m.GetEventType().(*Event_DebuggingContainerEvent); ok {
		return x.DebuggingContainerEvent
	}
	return nil
}

func (m *Event) GetDevLoopEvent() *DevLoopEvent {
	if x, ok := m.GetEventType().(*Event_DevLoopEvent); ok {
		return x.DevLoopEvent
	}
	return nil
}

func (m *Event) GetTerminationEvent() *TerminationEvent {
	if x, ok := m.GetEventType().(*Event_TerminationEvent); ok {
		return x.TerminationEvent
	}
	return nil
}

func (m *Event) GetTestEvent() *TestEvent {
	if x, ok := m.GetEventType().(*Event_TestEvent); ok {
		return x.TestEvent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Event) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Event_MetaEvent)(nil),
		(*Event_BuildEvent)(nil),
		(*Event_DeployEvent)(nil),
		(*Event_PortEvent)(nil),
		(*Event_StatusCheckEvent)(nil),
		(*Event_ResourceStatusCheckEvent)(nil),
		(*Event_FileSyncEvent)(nil),
		(*Event_DebuggingContainerEvent)(nil),
		(*Event_DevLoopEvent)(nil),
		(*Event_TerminationEvent)(nil),
		(*Event_TestEvent)(nil),
	}
}

// `TerminationEvent` marks the end of the skaffold session
type TerminationEvent struct {
	Status               string         `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	Err                  *ActionableErr `protobuf:"bytes,2,opt,name=err,proto3" json:"err,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *TerminationEvent) Reset()         { *m = TerminationEvent{} }
func (m *TerminationEvent) String() string { return proto.CompactTextString(m) }
func (*TerminationEvent) ProtoMessage()    {}
func (*TerminationEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{14}
}

func (m *TerminationEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TerminationEvent.Unmarshal(m, b)
}
func (m *TerminationEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TerminationEvent.Marshal(b, m, deterministic)
}
func (m *TerminationEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TerminationEvent.Merge(m, src)
}
func (m *TerminationEvent) XXX_Size() int {
	return xxx_messageInfo_TerminationEvent.Size(m)
}
func (m *TerminationEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_TerminationEvent.DiscardUnknown(m)
}

var xxx_messageInfo_TerminationEvent proto.InternalMessageInfo

func (m *TerminationEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *TerminationEvent) GetErr() *ActionableErr {
	if m != nil {
		return m.Err
	}
	return nil
}

// `DevLoopEvent` marks the start and end of a dev loop.
type DevLoopEvent struct {
	Iteration            int32          `protobuf:"varint,1,opt,name=iteration,proto3" json:"iteration,omitempty"`
	Status               string         `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	Err                  *ActionableErr `protobuf:"bytes,3,opt,name=err,proto3" json:"err,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *DevLoopEvent) Reset()         { *m = DevLoopEvent{} }
func (m *DevLoopEvent) String() string { return proto.CompactTextString(m) }
func (*DevLoopEvent) ProtoMessage()    {}
func (*DevLoopEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{15}
}

func (m *DevLoopEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DevLoopEvent.Unmarshal(m, b)
}
func (m *DevLoopEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DevLoopEvent.Marshal(b, m, deterministic)
}
func (m *DevLoopEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DevLoopEvent.Merge(m, src)
}
func (m *DevLoopEvent) XXX_Size() int {
	return xxx_messageInfo_DevLoopEvent.Size(m)
}
func (m *DevLoopEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_DevLoopEvent.DiscardUnknown(m)
}

var xxx_messageInfo_DevLoopEvent proto.InternalMessageInfo

func (m *DevLoopEvent) GetIteration() int32 {
	if m != nil {
		return m.Iteration
	}
	return 0
}

func (m *DevLoopEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *DevLoopEvent) GetErr() *ActionableErr {
	if m != nil {
		return m.Err
	}
	return nil
}

// `ActionableErr` defines an error that occurred along with an optional list of suggestions
type ActionableErr struct {
	ErrCode              StatusCode    `protobuf:"varint,1,opt,name=errCode,proto3,enum=proto.StatusCode" json:"errCode,omitempty"`
	Message              string        `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	Suggestions          []*Suggestion `protobuf:"bytes,3,rep,name=suggestions,proto3" json:"suggestions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ActionableErr) Reset()         { *m = ActionableErr{} }
func (m *ActionableErr) String() string { return proto.CompactTextString(m) }
func (*ActionableErr) ProtoMessage()    {}
func (*ActionableErr) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{16}
}

func (m *ActionableErr) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ActionableErr.Unmarshal(m, b)
}
func (m *ActionableErr) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ActionableErr.Marshal(b, m, deterministic)
}
func (m *ActionableErr) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActionableErr.Merge(m, src)
}
func (m *ActionableErr) XXX_Size() int {
	return xxx_messageInfo_ActionableErr.Size(m)
}
func (m *ActionableErr) XXX_DiscardUnknown() {
	xxx_messageInfo_ActionableErr.DiscardUnknown(m)
}

var xxx_messageInfo_ActionableErr proto.InternalMessageInfo

func (m *ActionableErr) GetErrCode() StatusCode {
	if m != nil {
		return m.ErrCode
	}
	return StatusCode_OK
}

func (m *ActionableErr) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *ActionableErr) GetSuggestions() []*Suggestion {
	if m != nil {
		return m.Suggestions
	}
	return nil
}

// `MetaEvent` provides general information regarding Skaffold
type MetaEvent struct {
	// entry, for example: `"Starting Skaffold: {Version:v0.39.0-16-g5bb7c9e0 ConfigVersion:skaffold/v1 GitVersion: GitCommit:5bb7c9e078e4d522a5ffc42a2f1274fd17d75902 GitTreeState:dirty BuildDate01:29Z GoVersion:go1.13rc1 Compiler:gc Platform:linux/amd64}"`
	Entry string `protobuf:"bytes,1,opt,name=entry,proto3" json:"entry,omitempty"`
	// Metadata describing skaffold pipeline
	Metadata             *Metadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *MetaEvent) Reset()         { *m = MetaEvent{} }
func (m *MetaEvent) String() string { return proto.CompactTextString(m) }
func (*MetaEvent) ProtoMessage()    {}
func (*MetaEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{17}
}

func (m *MetaEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetaEvent.Unmarshal(m, b)
}
func (m *MetaEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetaEvent.Marshal(b, m, deterministic)
}
func (m *MetaEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetaEvent.Merge(m, src)
}
func (m *MetaEvent) XXX_Size() int {
	return xxx_messageInfo_MetaEvent.Size(m)
}
func (m *MetaEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_MetaEvent.DiscardUnknown(m)
}

var xxx_messageInfo_MetaEvent proto.InternalMessageInfo

func (m *MetaEvent) GetEntry() string {
	if m != nil {
		return m.Entry
	}
	return ""
}

func (m *MetaEvent) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// `BuildEvent` describes the build status per artifact, and will be emitted by Skaffold anytime a build starts or finishes, successfully or not.
// If the build fails, an error will be attached to the event.
type BuildEvent struct {
	Artifact             string         `protobuf:"bytes,1,opt,name=artifact,proto3" json:"artifact,omitempty"`
	Status               string         `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	Err                  string         `protobuf:"bytes,3,opt,name=err,proto3" json:"err,omitempty"`
	ErrCode              StatusCode     `protobuf:"varint,4,opt,name=errCode,proto3,enum=proto.StatusCode" json:"errCode,omitempty"`
	ActionableErr        *ActionableErr `protobuf:"bytes,5,opt,name=actionableErr,proto3" json:"actionableErr,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *BuildEvent) Reset()         { *m = BuildEvent{} }
func (m *BuildEvent) String() string { return proto.CompactTextString(m) }
func (*BuildEvent) ProtoMessage()    {}
func (*BuildEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{18}
}

func (m *BuildEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildEvent.Unmarshal(m, b)
}
func (m *BuildEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildEvent.Marshal(b, m, deterministic)
}
func (m *BuildEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildEvent.Merge(m, src)
}
func (m *BuildEvent) XXX_Size() int {
	return xxx_messageInfo_BuildEvent.Size(m)
}
func (m *BuildEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildEvent.DiscardUnknown(m)
}

var xxx_messageInfo_BuildEvent proto.InternalMessageInfo

func (m *BuildEvent) GetArtifact() string {
	if m != nil {
		return m.Artifact
	}
	return ""
}

func (m *BuildEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *BuildEvent) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

func (m *BuildEvent) GetErrCode() StatusCode {
	if m != nil {
		return m.ErrCode
	}
	return StatusCode_OK
}

func (m *BuildEvent) GetActionableErr() *ActionableErr {
	if m != nil {
		return m.ActionableErr
	}
	return nil
}

// `TestEvent` represents the status of a test, and is emitted by Skaffold
// anytime a test starts or completes, successfully or not.
type TestEvent struct {
	Status               string         `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	ActionableErr        *ActionableErr `protobuf:"bytes,2,opt,name=actionableErr,proto3" json:"actionableErr,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *TestEvent) Reset()         { *m = TestEvent{} }
func (m *TestEvent) String() string { return proto.CompactTextString(m) }
func (*TestEvent) ProtoMessage()    {}
func (*TestEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{19}
}

func (m *TestEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestEvent.Unmarshal(m, b)
}
func (m *TestEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestEvent.Marshal(b, m, deterministic)
}
func (m *TestEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestEvent.Merge(m, src)
}
func (m *TestEvent) XXX_Size() int {
	return xxx_messageInfo_TestEvent.Size(m)
}
func (m *TestEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_TestEvent.DiscardUnknown(m)
}

var xxx_messageInfo_TestEvent proto.InternalMessageInfo

func (m *TestEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *TestEvent) GetActionableErr() *ActionableErr {
	if m != nil {
		return m.ActionableErr
	}
	return nil
}

// `DeployEvent` represents the status of a deployment, and is emitted by Skaffold
// anytime a deployment starts or completes, successfully or not.
type DeployEvent struct {
	Status               string         `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	Err                  string         `protobuf:"bytes,2,opt,name=err,proto3" json:"err,omitempty"`
	ErrCode              StatusCode     `protobuf:"varint,3,opt,name=errCode,proto3,enum=proto.StatusCode" json:"errCode,omitempty"`
	ActionableErr        *ActionableErr `protobuf:"bytes,4,opt,name=actionableErr,proto3" json:"actionableErr,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *DeployEvent) Reset()         { *m = DeployEvent{} }
func (m *DeployEvent) String() string { return proto.CompactTextString(m) }
func (*DeployEvent) ProtoMessage()    {}
func (*DeployEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{20}
}

func (m *DeployEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployEvent.Unmarshal(m, b)
}
func (m *DeployEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployEvent.Marshal(b, m, deterministic)
}
func (m *DeployEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployEvent.Merge(m, src)
}
func (m *DeployEvent) XXX_Size() int {
	return xxx_messageInfo_DeployEvent.Size(m)
}
func (m *DeployEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployEvent.DiscardUnknown(m)
}

var xxx_messageInfo_DeployEvent proto.InternalMessageInfo

func (m *DeployEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *DeployEvent) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

func (m *DeployEvent) GetErrCode() StatusCode {
	if m != nil {
		return m.ErrCode
	}
	return StatusCode_OK
}

func (m *DeployEvent) GetActionableErr() *ActionableErr {
	if m != nil {
		return m.ActionableErr
	}
	return nil
}

// `StatusCheckEvent` describes if the status check for kubernetes rollout has started, is in progress, has succeeded or failed.
type StatusCheckEvent struct {
	Status               string         `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	Message              string         `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	Err                  string         `protobuf:"bytes,3,opt,name=err,proto3" json:"err,omitempty"`
	ErrCode              StatusCode     `protobuf:"varint,4,opt,name=errCode,proto3,enum=proto.StatusCode" json:"errCode,omitempty"`
	ActionableErr        *ActionableErr `protobuf:"bytes,5,opt,name=actionableErr,proto3" json:"actionableErr,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *StatusCheckEvent) Reset()         { *m = StatusCheckEvent{} }
func (m *StatusCheckEvent) String() string { return proto.CompactTextString(m) }
func (*StatusCheckEvent) ProtoMessage()    {}
func (*StatusCheckEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{21}
}

func (m *StatusCheckEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StatusCheckEvent.Unmarshal(m, b)
}
func (m *StatusCheckEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StatusCheckEvent.Marshal(b, m, deterministic)
}
func (m *StatusCheckEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatusCheckEvent.Merge(m, src)
}
func (m *StatusCheckEvent) XXX_Size() int {
	return xxx_messageInfo_StatusCheckEvent.Size(m)
}
func (m *StatusCheckEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_StatusCheckEvent.DiscardUnknown(m)
}

var xxx_messageInfo_StatusCheckEvent proto.InternalMessageInfo

func (m *StatusCheckEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *StatusCheckEvent) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *StatusCheckEvent) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

func (m *StatusCheckEvent) GetErrCode() StatusCode {
	if m != nil {
		return m.ErrCode
	}
	return StatusCode_OK
}

func (m *StatusCheckEvent) GetActionableErr() *ActionableErr {
	if m != nil {
		return m.ActionableErr
	}
	return nil
}

// A Resource StatusCheck Event, indicates progress for each kubernetes deployment.
// For every resource, there will be exactly one event with `status` *Succeeded* or *Failed* event.
// There can be multiple events with `status` *Pending*.
// Skaffold polls for resource status every 0.5 second. If the resource status changes, an event with `status` “Pending”, “Complete” and “Failed”
// will be sent with the new status.
type ResourceStatusCheckEvent struct {
	Resource             string         `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	Status               string         `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	Message              string         `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	Err                  string         `protobuf:"bytes,4,opt,name=err,proto3" json:"err,omitempty"`
	StatusCode           StatusCode     `protobuf:"varint,5,opt,name=statusCode,proto3,enum=proto.StatusCode" json:"statusCode,omitempty"`
	ActionableErr        *ActionableErr `protobuf:"bytes,6,opt,name=actionableErr,proto3" json:"actionableErr,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ResourceStatusCheckEvent) Reset()         { *m = ResourceStatusCheckEvent{} }
func (m *ResourceStatusCheckEvent) String() string { return proto.CompactTextString(m) }
func (*ResourceStatusCheckEvent) ProtoMessage()    {}
func (*ResourceStatusCheckEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{22}
}

func (m *ResourceStatusCheckEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResourceStatusCheckEvent.Unmarshal(m, b)
}
func (m *ResourceStatusCheckEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResourceStatusCheckEvent.Marshal(b, m, deterministic)
}
func (m *ResourceStatusCheckEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceStatusCheckEvent.Merge(m, src)
}
func (m *ResourceStatusCheckEvent) XXX_Size() int {
	return xxx_messageInfo_ResourceStatusCheckEvent.Size(m)
}
func (m *ResourceStatusCheckEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceStatusCheckEvent.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceStatusCheckEvent proto.InternalMessageInfo

func (m *ResourceStatusCheckEvent) GetResource() string {
	if m != nil {
		return m.Resource
	}
	return ""
}

func (m *ResourceStatusCheckEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *ResourceStatusCheckEvent) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *ResourceStatusCheckEvent) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

func (m *ResourceStatusCheckEvent) GetStatusCode() StatusCode {
	if m != nil {
		return m.StatusCode
	}
	return StatusCode_OK
}

func (m *ResourceStatusCheckEvent) GetActionableErr() *ActionableErr {
	if m != nil {
		return m.ActionableErr
	}
	return nil
}

// PortEvent Event describes each port forwarding event.
type PortEvent struct {
	LocalPort            int32        `protobuf:"varint,1,opt,name=localPort,proto3" json:"localPort,omitempty"`
	RemotePort           int32        `protobuf:"varint,2,opt,name=remotePort,proto3" json:"remotePort,omitempty"`
	PodName              string       `protobuf:"bytes,3,opt,name=podName,proto3" json:"podName,omitempty"`
	ContainerName        string       `protobuf:"bytes,4,opt,name=containerName,proto3" json:"containerName,omitempty"`
	Namespace            string       `protobuf:"bytes,5,opt,name=namespace,proto3" json:"namespace,omitempty"`
	PortName             string       `protobuf:"bytes,6,opt,name=portName,proto3" json:"portName,omitempty"`
	ResourceType         string       `protobuf:"bytes,7,opt,name=resourceType,proto3" json:"resourceType,omitempty"`
	ResourceName         string       `protobuf:"bytes,8,opt,name=resourceName,proto3" json:"resourceName,omitempty"`
	Address              string       `protobuf:"bytes,9,opt,name=address,proto3" json:"address,omitempty"`
	TargetPort           *IntOrString `protobuf:"bytes,10,opt,name=targetPort,proto3" json:"targetPort,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *PortEvent) Reset()         { *m = PortEvent{} }
func (m *PortEvent) String() string { return proto.CompactTextString(m) }
func (*PortEvent) ProtoMessage()    {}
func (*PortEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{23}
}

func (m *PortEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PortEvent.Unmarshal(m, b)
}
func (m *PortEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PortEvent.Marshal(b, m, deterministic)
}
func (m *PortEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PortEvent.Merge(m, src)
}
func (m *PortEvent) XXX_Size() int {
	return xxx_messageInfo_PortEvent.Size(m)
}
func (m *PortEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_PortEvent.DiscardUnknown(m)
}

var xxx_messageInfo_PortEvent proto.InternalMessageInfo

func (m *PortEvent) GetLocalPort() int32 {
	if m != nil {
		return m.LocalPort
	}
	return 0
}

func (m *PortEvent) GetRemotePort() int32 {
	if m != nil {
		return m.RemotePort
	}
	return 0
}

func (m *PortEvent) GetPodName() string {
	if m != nil {
		return m.PodName
	}
	return ""
}

func (m *PortEvent) GetContainerName() string {
	if m != nil {
		return m.ContainerName
	}
	return ""
}

func (m *PortEvent) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *PortEvent) GetPortName() string {
	if m != nil {
		return m.PortName
	}
	return ""
}

func (m *PortEvent) GetResourceType() string {
	if m != nil {
		return m.ResourceType
	}
	return ""
}

func (m *PortEvent) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *PortEvent) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *PortEvent) GetTargetPort() *IntOrString {
	if m != nil {
		return m.TargetPort
	}
	return nil
}

// FileSyncEvent describes the sync status.
type FileSyncEvent struct {
	FileCount            int32          `protobuf:"varint,1,opt,name=fileCount,proto3" json:"fileCount,omitempty"`
	Image                string         `protobuf:"bytes,2,opt,name=image,proto3" json:"image,omitempty"`
	Status               string         `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	Err                  string         `protobuf:"bytes,4,opt,name=err,proto3" json:"err,omitempty"`
	ErrCode              StatusCode     `protobuf:"varint,5,opt,name=errCode,proto3,enum=proto.StatusCode" json:"errCode,omitempty"`
	ActionableErr        *ActionableErr `protobuf:"bytes,6,opt,name=actionableErr,proto3" json:"actionableErr,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *FileSyncEvent) Reset()         { *m = FileSyncEvent{} }
func (m *FileSyncEvent) String() string { return proto.CompactTextString(m) }
func (*FileSyncEvent) ProtoMessage()    {}
func (*FileSyncEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{24}
}

func (m *FileSyncEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FileSyncEvent.Unmarshal(m, b)
}
func (m *FileSyncEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FileSyncEvent.Marshal(b, m, deterministic)
}
func (m *FileSyncEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileSyncEvent.Merge(m, src)
}
func (m *FileSyncEvent) XXX_Size() int {
	return xxx_messageInfo_FileSyncEvent.Size(m)
}
func (m *FileSyncEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_FileSyncEvent.DiscardUnknown(m)
}

var xxx_messageInfo_FileSyncEvent proto.InternalMessageInfo

func (m *FileSyncEvent) GetFileCount() int32 {
	if m != nil {
		return m.FileCount
	}
	return 0
}

func (m *FileSyncEvent) GetImage() string {
	if m != nil {
		return m.Image
	}
	return ""
}

func (m *FileSyncEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *FileSyncEvent) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

func (m *FileSyncEvent) GetErrCode() StatusCode {
	if m != nil {
		return m.ErrCode
	}
	return StatusCode_OK
}

func (m *FileSyncEvent) GetActionableErr() *ActionableErr {
	if m != nil {
		return m.ActionableErr
	}
	return nil
}

// DebuggingContainerEvent is raised when a debugging container is started or terminated
type DebuggingContainerEvent struct {
	Status               string            `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	PodName              string            `protobuf:"bytes,2,opt,name=podName,proto3" json:"podName,omitempty"`
	ContainerName        string            `protobuf:"bytes,3,opt,name=containerName,proto3" json:"containerName,omitempty"`
	Namespace            string            `protobuf:"bytes,4,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Artifact             string            `protobuf:"bytes,5,opt,name=artifact,proto3" json:"artifact,omitempty"`
	Runtime              string            `protobuf:"bytes,6,opt,name=runtime,proto3" json:"runtime,omitempty"`
	WorkingDir           string            `protobuf:"bytes,7,opt,name=workingDir,proto3" json:"workingDir,omitempty"`
	DebugPorts           map[string]uint32 `protobuf:"bytes,8,rep,name=debugPorts,proto3" json:"debugPorts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *DebuggingContainerEvent) Reset()         { *m = DebuggingContainerEvent{} }
func (m *DebuggingContainerEvent) String() string { return proto.CompactTextString(m) }
func (*DebuggingContainerEvent) ProtoMessage()    {}
func (*DebuggingContainerEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{25}
}

func (m *DebuggingContainerEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DebuggingContainerEvent.Unmarshal(m, b)
}
func (m *DebuggingContainerEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DebuggingContainerEvent.Marshal(b, m, deterministic)
}
func (m *DebuggingContainerEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebuggingContainerEvent.Merge(m, src)
}
func (m *DebuggingContainerEvent) XXX_Size() int {
	return xxx_messageInfo_DebuggingContainerEvent.Size(m)
}
func (m *DebuggingContainerEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_DebuggingContainerEvent.DiscardUnknown(m)
}

var xxx_messageInfo_DebuggingContainerEvent proto.InternalMessageInfo

func (m *DebuggingContainerEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *DebuggingContainerEvent) GetPodName() string {
	if m != nil {
		return m.PodName
	}
	return ""
}

func (m *DebuggingContainerEvent) GetContainerName() string {
	if m != nil {
		return m.ContainerName
	}
	return ""
}

func (m *DebuggingContainerEvent) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *DebuggingContainerEvent) GetArtifact() string {
	if m != nil {
		return m.Artifact
	}
	return ""
}

func (m *DebuggingContainerEvent) GetRuntime() string {
	if m != nil {
		return m.Runtime
	}
	return ""
}

func (m *DebuggingContainerEvent) GetWorkingDir() string {
	if m != nil {
		return m.WorkingDir
	}
	return ""
}

func (m *DebuggingContainerEvent) GetDebugPorts() map[string]uint32 {
	if m != nil {
		return m.DebugPorts
	}
	return nil
}

// LogEntry describes an event and a string description of the event.
type LogEntry struct {
	Timestamp            *timestamp.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Event                *Event               `protobuf:"bytes,2,opt,name=event,proto3" json:"event,omitempty"`
	Entry                string               `protobuf:"bytes,3,opt,name=entry,proto3" json:"entry,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *LogEntry) Reset()         { *m = LogEntry{} }
func (m *LogEntry) String() string { return proto.CompactTextString(m) }
func (*LogEntry) ProtoMessage()    {}
func (*LogEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{26}
}

func (m *LogEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry.Unmarshal(m, b)
}
func (m *LogEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry.Marshal(b, m, deterministic)
}
func (m *LogEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry.Merge(m, src)
}
func (m *LogEntry) XXX_Size() int {
	return xxx_messageInfo_LogEntry.Size(m)
}
func (m *LogEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry proto.InternalMessageInfo

func (m *LogEntry) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *LogEntry) GetEvent() *Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *LogEntry) GetEntry() string {
	if m != nil {
		return m.Entry
	}
	return ""
}

type UserIntentRequest struct {
	Intent               *Intent  `protobuf:"bytes,1,opt,name=intent,proto3" json:"intent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UserIntentRequest) Reset()         { *m = UserIntentRequest{} }
func (m *UserIntentRequest) String() string { return proto.CompactTextString(m) }
func (*UserIntentRequest) ProtoMessage()    {}
func (*UserIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{27}
}

func (m *UserIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserIntentRequest.Unmarshal(m, b)
}
func (m *UserIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserIntentRequest.Marshal(b, m, deterministic)
}
func (m *UserIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserIntentRequest.Merge(m, src)
}
func (m *UserIntentRequest) XXX_Size() int {
	return xxx_messageInfo_UserIntentRequest.Size(m)
}
func (m *UserIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UserIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UserIntentRequest proto.InternalMessageInfo

func (m *UserIntentRequest) GetIntent() *Intent {
	if m != nil {
		return m.Intent
	}
	return nil
}

type TriggerRequest struct {
	State                *TriggerState `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *TriggerRequest) Reset()         { *m = TriggerRequest{} }
func (m *TriggerRequest) String() string { return proto.CompactTextString(m) }
func (*TriggerRequest) ProtoMessage()    {}
func (*TriggerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{28}
}

func (m *TriggerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TriggerRequest.Unmarshal(m, b)
}
func (m *TriggerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TriggerRequest.Marshal(b, m, deterministic)
}
func (m *TriggerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TriggerRequest.Merge(m, src)
}
func (m *TriggerRequest) XXX_Size() int {
	return xxx_messageInfo_TriggerRequest.Size(m)
}
func (m *TriggerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TriggerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TriggerRequest proto.InternalMessageInfo

func (m *TriggerRequest) GetState() *TriggerState {
	if m != nil {
		return m.State
	}
	return nil
}

// TriggerState represents trigger state for a given phase.
type TriggerState struct {
	// Types that are valid to be assigned to Val:
	//	*TriggerState_Enabled
	Val                  isTriggerState_Val `protobuf_oneof:"val"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *TriggerState) Reset()         { *m = TriggerState{} }
func (m *TriggerState) String() string { return proto.CompactTextString(m) }
func (*TriggerState) ProtoMessage()    {}
func (*TriggerState) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{29}
}

func (m *TriggerState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TriggerState.Unmarshal(m, b)
}
func (m *TriggerState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TriggerState.Marshal(b, m, deterministic)
}
func (m *TriggerState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TriggerState.Merge(m, src)
}
func (m *TriggerState) XXX_Size() int {
	return xxx_messageInfo_TriggerState.Size(m)
}
func (m *TriggerState) XXX_DiscardUnknown() {
	xxx_messageInfo_TriggerState.DiscardUnknown(m)
}

var xxx_messageInfo_TriggerState proto.InternalMessageInfo

type isTriggerState_Val interface {
	isTriggerState_Val()
}

type TriggerState_Enabled struct {
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3,oneof"`
}

func (*TriggerState_Enabled) isTriggerState_Val() {}

func (m *TriggerState) GetVal() isTriggerState_Val {
	if m != nil {
		return m.Val
	}
	return nil
}

func (m *TriggerState) GetEnabled() bool {
	if x, ok := m.GetVal().(*TriggerState_Enabled); ok {
		return x.Enabled
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*TriggerState) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*TriggerState_Enabled)(nil),
	}
}

// Intent represents user intents for a given phase.
type Intent struct {
	Build                bool     `protobuf:"varint,1,opt,name=build,proto3" json:"build,omitempty"`
	Sync                 bool     `protobuf:"varint,2,opt,name=sync,proto3" json:"sync,omitempty"`
	Deploy               bool     `protobuf:"varint,3,opt,name=deploy,proto3" json:"deploy,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent) Reset()         { *m = Intent{} }
func (m *Intent) String() string { return proto.CompactTextString(m) }
func (*Intent) ProtoMessage()    {}
func (*Intent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{30}
}

func (m *Intent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent.Unmarshal(m, b)
}
func (m *Intent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent.Marshal(b, m, deterministic)
}
func (m *Intent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent.Merge(m, src)
}
func (m *Intent) XXX_Size() int {
	return xxx_messageInfo_Intent.Size(m)
}
func (m *Intent) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent.DiscardUnknown(m)
}

var xxx_messageInfo_Intent proto.InternalMessageInfo

func (m *Intent) GetBuild() bool {
	if m != nil {
		return m.Build
	}
	return false
}

func (m *Intent) GetSync() bool {
	if m != nil {
		return m.Sync
	}
	return false
}

func (m *Intent) GetDeploy() bool {
	if m != nil {
		return m.Deploy
	}
	return false
}

// Suggestion defines the action a user needs to recover from an error.
type Suggestion struct {
	SuggestionCode       SuggestionCode `protobuf:"varint,1,opt,name=suggestionCode,proto3,enum=proto.SuggestionCode" json:"suggestionCode,omitempty"`
	Action               string         `protobuf:"bytes,2,opt,name=action,proto3" json:"action,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Suggestion) Reset()         { *m = Suggestion{} }
func (m *Suggestion) String() string { return proto.CompactTextString(m) }
func (*Suggestion) ProtoMessage()    {}
func (*Suggestion) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{31}
}

func (m *Suggestion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Suggestion.Unmarshal(m, b)
}
func (m *Suggestion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Suggestion.Marshal(b, m, deterministic)
}
func (m *Suggestion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Suggestion.Merge(m, src)
}
func (m *Suggestion) XXX_Size() int {
	return xxx_messageInfo_Suggestion.Size(m)
}
func (m *Suggestion) XXX_DiscardUnknown() {
	xxx_messageInfo_Suggestion.DiscardUnknown(m)
}

var xxx_messageInfo_Suggestion proto.InternalMessageInfo

func (m *Suggestion) GetSuggestionCode() SuggestionCode {
	if m != nil {
		return m.SuggestionCode
	}
	return SuggestionCode_NIL
}

func (m *Suggestion) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

// IntOrString is a type that can hold an int32 or a string.
type IntOrString struct {
	Type                 int32    `protobuf:"varint,1,opt,name=type,proto3" json:"type,omitempty"`
	IntVal               int32    `protobuf:"varint,2,opt,name=intVal,proto3" json:"intVal,omitempty"`
	StrVal               string   `protobuf:"bytes,3,opt,name=strVal,proto3" json:"strVal,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IntOrString) Reset()         { *m = IntOrString{} }
func (m *IntOrString) String() string { return proto.CompactTextString(m) }
func (*IntOrString) ProtoMessage()    {}
func (*IntOrString) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{32}
}

func (m *IntOrString) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IntOrString.Unmarshal(m, b)
}
func (m *IntOrString) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IntOrString.Marshal(b, m, deterministic)
}
func (m *IntOrString) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntOrString.Merge(m, src)
}
func (m *IntOrString) XXX_Size() int {
	return xxx_messageInfo_IntOrString.Size(m)
}
func (m *IntOrString) XXX_DiscardUnknown() {
	xxx_messageInfo_IntOrString.DiscardUnknown(m)
}

var xxx_messageInfo_IntOrString proto.InternalMessageInfo

func (m *IntOrString) GetType() int32 {
	if m != nil {
		return m.Type
	}
	return 0
}

func (m *IntOrString) GetIntVal() int32 {
	if m != nil {
		return m.IntVal
	}
	return 0
}

func (m *IntOrString) GetStrVal() string {
	if m != nil {
		return m.StrVal
	}
	return ""
}

func init() {
	proto.RegisterEnum("proto.BuilderType", BuilderType_name, BuilderType_value)
	proto.RegisterEnum("proto.BuildType", BuildType_name, BuildType_value)
	proto.RegisterEnum("proto.TesterType", TesterType_name, TesterType_value)
	proto.RegisterEnum("proto.DeployerType", DeployerType_name, DeployerType_value)
	proto.RegisterEnum("proto.ClusterType", ClusterType_name, ClusterType_value)
	proto.RegisterEnum("proto.StatusCode", StatusCode_name, StatusCode_value)
	proto.RegisterEnum("proto.SuggestionCode", SuggestionCode_name, SuggestionCode_value)
	proto.RegisterType((*StateResponse)(nil), "proto.StateResponse")
	proto.RegisterType((*Response)(nil), "proto.Response")
	proto.RegisterType((*Request)(nil), "proto.Request")
	proto.RegisterType((*State)(nil), "proto.State")
	proto.RegisterMapType((map[int32]*PortEvent)(nil), "proto.State.ForwardedPortsEntry")
	proto.RegisterType((*Metadata)(nil), "proto.Metadata")
	proto.RegisterMapType((map[string]string)(nil), "proto.Metadata.AdditionalEntry")
	proto.RegisterType((*BuildMetadata)(nil), "proto.BuildMetadata")
	proto.RegisterMapType((map[string]string)(nil), "proto.BuildMetadata.AdditionalEntry")
	proto.RegisterType((*BuildMetadata_ImageBuilder)(nil), "proto.BuildMetadata.ImageBuilder")
	proto.RegisterType((*TestMetadata)(nil), "proto.TestMetadata")
	proto.RegisterType((*TestMetadata_Tester)(nil), "proto.TestMetadata.Tester")
	proto.RegisterType((*DeployMetadata)(nil), "proto.DeployMetadata")
	proto.RegisterType((*DeployMetadata_Deployer)(nil), "proto.DeployMetadata.Deployer")
	proto.RegisterType((*BuildState)(nil), "proto.BuildState")
	proto.RegisterMapType((map[string]string)(nil), "proto.BuildState.ArtifactsEntry")
	proto.RegisterType((*TestState)(nil), "proto.TestState")
	proto.RegisterType((*DeployState)(nil), "proto.DeployState")
	proto.RegisterType((*StatusCheckState)(nil), "proto.StatusCheckState")
	proto.RegisterMapType((map[string]string)(nil), "proto.StatusCheckState.ResourcesEntry")
	proto.RegisterType((*FileSyncState)(nil), "proto.FileSyncState")
	proto.RegisterType((*Event)(nil), "proto.Event")
	proto.RegisterType((*TerminationEvent)(nil), "proto.TerminationEvent")
	proto.RegisterType((*DevLoopEvent)(nil), "proto.DevLoopEvent")
	proto.RegisterType((*ActionableErr)(nil), "proto.ActionableErr")
	proto.RegisterType((*MetaEvent)(nil), "proto.MetaEvent")
	proto.RegisterType((*BuildEvent)(nil), "proto.BuildEvent")
	proto.RegisterType((*TestEvent)(nil), "proto.TestEvent")
	proto.RegisterType((*DeployEvent)(nil), "proto.DeployEvent")
	proto.RegisterType((*StatusCheckEvent)(nil), "proto.StatusCheckEvent")
	proto.RegisterType((*ResourceStatusCheckEvent)(nil), "proto.ResourceStatusCheckEvent")
	proto.RegisterType((*PortEvent)(nil), "proto.PortEvent")
	proto.RegisterType((*FileSyncEvent)(nil), "proto.FileSyncEvent")
	proto.RegisterType((*DebuggingContainerEvent)(nil), "proto.DebuggingContainerEvent")
	proto.RegisterMapType((map[string]uint32)(nil), "proto.DebuggingContainerEvent.DebugPortsEntry")
	proto.RegisterType((*LogEntry)(nil), "proto.LogEntry")
	proto.RegisterType((*UserIntentRequest)(nil), "proto.UserIntentRequest")
	proto.RegisterType((*TriggerRequest)(nil), "proto.TriggerRequest")
	proto.RegisterType((*TriggerState)(nil), "proto.TriggerState")
	proto.RegisterType((*Intent)(nil), "proto.Intent")
	proto.RegisterType((*Suggestion)(nil), "proto.Suggestion")
	proto.RegisterType((*IntOrString)(nil), "proto.IntOrString")
}

func init() { proto.RegisterFile("skaffold.proto", fileDescriptor_4f2d38e344f9dbf5) }

var fileDescriptor_4f2d38e344f9dbf5 = []byte{
	// 4122 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x5a, 0x69, 0x8c, 0x1c, 0x49,
	0x56, 0x76, 0xdd, 0x55, 0xaf, 0x0f, 0x67, 0x87, 0xdd, 0x76, 0xb9, 0x7c, 0xb5, 0x6b, 0x6d, 0xef,
	0x4c, 0xcf, 0xd0, 0xf6, 0xd8, 0x2b, 0xb4, 0x98, 0x19, 0x50, 0x76, 0x66, 0x54, 0x55, 0xba, 0xb3,
	0x32, 0x8b, 0xc8, 0xac, 0xf6, 0xb4, 0x25, 0x94, 0x2a, 0x77, 0xa7, 0x6b, 0x6a, 0xdd, 0x5d, 0xd5,
	0x53, 0x55, 0xed, 0xd9, 0x5e, 0x10, 0x42, 0x88, 0x7b, 0x00, 0x01, 0xcb, 0x0d, 0x3f, 0x96, 0x4b,
	0xfb, 0x87, 0xeb, 0x2f, 0x42, 0xb0, 0x20, 0x84, 0x60, 0x39, 0x7f, 0x20, 0x10, 0x8b, 0x90, 0x10,
	0xd2, 0xf2, 0x63, 0xb9, 0x05, 0x33, 0xb3, 0xf7, 0x82, 0xe2, 0xca, 0x8c, 0xac, 0xc3, 0xc7, 0x22,
	0xc4, 0x2f, 0x57, 0xc6, 0xfb, 0xde, 0x19, 0x2f, 0xde, 0x7b, 0x11, 0x6e, 0x58, 0x1e, 0x3d, 0xea,
	0x3c, 0x7c, 0x38, 0xd8, 0xdf, 0xdb, 0x38, 0x1c, 0x0e, 0xc6, 0x03, 0x94, 0x63, 0xff, 0x54, 0x2e,
	0x74, 0x07, 0x83, 0xee, 0x7e, 0x78, 0xa3, 0x73, 0xd8, 0xbb, 0xd1, 0xe9, 0xf7, 0x07, 0xe3, 0xce,
	0xb8, 0x37, 0xe8, 0x8f, 0x38, 0xa8, 0x72, 0x59, 0x50, 0xd9, 0xd7, 0x83, 0xa3, 0x87, 0x37, 0xc6,
	0xbd, 0x83, 0x70, 0x34, 0xee, 0x1c, 0x1c, 0x0a, 0xc0, 0xf9, 0x49, 0x40, 0x78, 0x70, 0x38, 0x3e,
	0xe6, 0xc4, 0xea, 0x6d, 0x58, 0xf2, 0xc6, 0x9d, 0x71, 0x48, 0xc2, 0xd1, 0xe1, 0xa0, 0x3f, 0x0a,
	0x51, 0x15, 0x72, 0x23, 0xba, 0x50, 0x4e, 0xad, 0xa5, 0x5e, 0x58, 0xb8, 0xb5, 0xc8, 0x71, 0x1b,
	0x1c, 0xc4, 0x49, 0xd5, 0x0b, 0x50, 0x8c, 0xf0, 0x1a, 0x64, 0x0e, 0x46, 0x5d, 0x86, 0x2e, 0x11,
	0xfa, 0xb3, 0x7a, 0x11, 0x0a, 0x24, 0x7c, 0xf3, 0x28, 0x1c, 0x8d, 0x11, 0x82, 0x6c, 0xbf, 0x73,
	0x10, 0x0a, 0x2a, 0xfb, 0x5d, 0xfd, 0x83, 0x2c, 0xe4, 0x98, 0x34, 0xf4, 0x0a, 0xc0, 0x83, 0xa3,
	0xde, 0xfe, 0x9e, 0xa7, 0xe8, 0x5b, 0x11, 0xfa, 0x36, 0x23, 0x02, 0x51, 0x40, 0xe8, 0x03, 0xb0,
	0xb0, 0x17, 0x1e, 0xee, 0x0f, 0x8e, 0x39, 0x4f, 0x9a, 0xf1, 0x20, 0xc1, 0x63, 0xc6, 0x14, 0xa2,
	0xc2, 0x50, 0x03, 0x96, 0x1f, 0x0e, 0x86, 0x6f, 0x75, 0x86, 0x7b, 0xe1, 0x5e, 0x6b, 0x30, 0x1c,
	0x8f, 0xca, 0xd9, 0xb5, 0xcc, 0x0b, 0x0b, 0xb7, 0xd6, 0x54, 0xe7, 0x36, 0x6a, 0x09, 0x08, 0xee,
	0x8f, 0x87, 0xc7, 0x64, 0x82, 0x0f, 0x19, 0xa0, 0xd1, 0x10, 0x1c, 0x8d, 0x8c, 0x37, 0xc2, 0xdd,
	0x47, 0xdc, 0x88, 0x1c, 0x33, 0xe2, 0xac, 0x22, 0x4b, 0x25, 0x93, 0x29, 0x06, 0x74, 0x07, 0x96,
	0x1e, 0xf6, 0xf6, 0x43, 0xef, 0xb8, 0xbf, 0xcb, 0x25, 0xe4, 0x99, 0x84, 0xd3, 0x42, 0x42, 0x4d,
	0xa5, 0x91, 0x24, 0x14, 0xb5, 0xe0, 0xd4, 0x5e, 0xf8, 0xe0, 0xa8, 0xdb, 0xed, 0xf5, 0xbb, 0xc6,
	0xa0, 0x3f, 0xee, 0xf4, 0xfa, 0xe1, 0x70, 0x54, 0x2e, 0x30, 0x7f, 0x2e, 0x45, 0x81, 0x98, 0x44,
	0xe0, 0xc7, 0x61, 0x7f, 0x4c, 0x66, 0xb1, 0xa2, 0x97, 0xa0, 0x78, 0x10, 0x8e, 0x3b, 0x7b, 0x9d,
	0x71, 0xa7, 0x5c, 0x64, 0x86, 0x9c, 0x14, 0x62, 0x9a, 0x62, 0x99, 0x44, 0x00, 0xb4, 0x01, 0xa5,
	0x71, 0x38, 0x1a, 0x73, 0xb3, 0x4b, 0x0c, 0xad, 0x09, 0xb4, 0x2f, 0xd7, 0x49, 0x0c, 0xa9, 0x78,
	0x70, 0x6a, 0x46, 0x58, 0x69, 0xd2, 0x3c, 0x0a, 0x8f, 0xd9, 0x96, 0xe7, 0x08, 0xfd, 0x89, 0xae,
	0x43, 0xee, 0x71, 0x67, 0xff, 0x48, 0x6e, 0xa9, 0x14, 0x4a, 0x79, 0xb8, 0xed, 0x9c, 0x7c, 0x27,
	0xfd, 0xc1, 0xd4, 0xdd, 0x6c, 0x31, 0xa3, 0x65, 0xab, 0x3f, 0x94, 0x86, 0xa2, 0xb4, 0x10, 0xad,
	0x43, 0x8e, 0x65, 0x89, 0xc8, 0xa2, 0xd3, 0x6a, 0x16, 0x45, 0x6e, 0x70, 0x08, 0xfa, 0x1a, 0xc8,
	0xf3, 0xe4, 0x10, 0xba, 0x56, 0x13, 0xe9, 0x13, 0xa1, 0x05, 0x08, 0xbd, 0x1f, 0xb2, 0xd4, 0x9f,
	0x72, 0x86, 0x81, 0x4f, 0x29, 0xde, 0x46, 0x50, 0x06, 0x40, 0xdf, 0x08, 0xd0, 0xd9, 0xdb, 0xeb,
	0xd1, 0xb3, 0xd9, 0xd9, 0x2f, 0xef, 0xb2, 0x1d, 0xb9, 0x3c, 0x11, 0xca, 0x0d, 0x3d, 0x42, 0xf0,
	0x04, 0x53, 0x58, 0x2a, 0xaf, 0xc1, 0xc9, 0x09, 0xb2, 0x1a, 0xa8, 0x12, 0x0f, 0xd4, 0x69, 0x35,
	0x50, 0x25, 0x25, 0x2c, 0xd5, 0x77, 0xd3, 0xb0, 0x94, 0x70, 0x18, 0xbd, 0x0c, 0x2b, 0xfd, 0xa3,
	0x83, 0x07, 0xe1, 0xd0, 0x7d, 0xa8, 0x0f, 0xc7, 0xbd, 0x87, 0x9d, 0xdd, 0xf1, 0x48, 0x04, 0x7d,
	0x9a, 0x80, 0x5e, 0x83, 0x22, 0x0b, 0x10, 0xcd, 0xa7, 0x34, 0xb3, 0xfe, 0xca, 0xac, 0x30, 0x6e,
	0x58, 0x07, 0x9d, 0x6e, 0xb8, 0xc9, 0x91, 0x24, 0x62, 0x41, 0x57, 0x21, 0x3b, 0x3e, 0x3e, 0x0c,
	0x59, 0x9c, 0x96, 0xa3, 0x0d, 0x64, 0x38, 0xff, 0xf8, 0x30, 0x24, 0x8c, 0x8a, 0xcc, 0x19, 0x41,
	0xba, 0x3a, 0x53, 0xcd, 0x93, 0x22, 0x65, 0xc3, 0xa2, 0x6a, 0x05, 0xba, 0x2e, 0x74, 0xa7, 0x98,
	0x6e, 0xa4, 0xca, 0x0b, 0x87, 0x8a, 0xf6, 0xd3, 0x90, 0xdb, 0x1d, 0x1c, 0xf5, 0xc7, 0x2c, 0x78,
	0x39, 0xc2, 0x3f, 0xfe, 0xb7, 0x71, 0x7f, 0x3b, 0x05, 0x8b, 0x6a, 0x3a, 0xa0, 0x0f, 0x40, 0x81,
	0x7e, 0xd3, 0x38, 0xa6, 0x98, 0x83, 0x95, 0x19, 0x49, 0xb3, 0xc1, 0x21, 0x44, 0x42, 0x2b, 0x18,
	0xf2, 0xfc, 0x27, 0xba, 0x96, 0xf0, 0x66, 0x45, 0x61, 0x7e, 0xba, 0x33, 0xd5, 0x3f, 0x4c, 0xc1,
	0x72, 0x32, 0x93, 0xd1, 0xab, 0x50, 0xe2, 0xb9, 0x1c, 0x5b, 0x74, 0x69, 0x66, 0xce, 0x8b, 0xcf,
	0x70, 0x48, 0x62, 0x06, 0xf4, 0x32, 0x14, 0x76, 0xf7, 0x8f, 0xa8, 0x6e, 0xa6, 0x28, 0x0e, 0xaf,
	0xc1, 0x57, 0x99, 0x45, 0x12, 0x52, 0xb1, 0xa0, 0x28, 0x85, 0xb0, 0x93, 0x13, 0xfb, 0x71, 0x2a,
	0xa1, 0xf2, 0x19, 0x3c, 0xf9, 0xfb, 0x14, 0x40, 0xdc, 0x06, 0xd0, 0x37, 0x40, 0xa9, 0xa3, 0x24,
	0xb1, 0x5a, 0xbf, 0x63, 0xd4, 0x46, 0x94, 0xce, 0x3c, 0x69, 0x62, 0x16, 0xb4, 0x06, 0x0b, 0x9d,
	0xa3, 0xf1, 0xc0, 0x1f, 0xf6, 0xba, 0x5d, 0xe1, 0x4b, 0x91, 0xa8, 0x4b, 0xb4, 0x1f, 0x89, 0x5a,
	0x3d, 0xd8, 0x93, 0x79, 0xbc, 0x92, 0x2c, 0xeb, 0x83, 0xbd, 0x90, 0x28, 0xa0, 0xca, 0xab, 0xb0,
	0x9c, 0xd4, 0xf8, 0x5c, 0x99, 0xb3, 0x0d, 0xa5, 0xa8, 0x6a, 0xa2, 0x33, 0x90, 0xe7, 0x82, 0x05,
	0xaf, 0xf8, 0x9a, 0xb0, 0x2a, 0xfd, 0x0c, 0x56, 0x55, 0x3f, 0x02, 0x0b, 0x4a, 0x2f, 0x9c, 0x2b,
	0xf9, 0xff, 0x22, 0x22, 0xd5, 0x7f, 0x48, 0x81, 0x36, 0xd9, 0x03, 0xe7, 0x5a, 0x60, 0x42, 0x69,
	0x18, 0x8e, 0x06, 0x47, 0xc3, 0xdd, 0x50, 0xd6, 0x9c, 0xeb, 0x73, 0xfa, 0xe8, 0x06, 0x91, 0x40,
	0xb1, 0xb3, 0x11, 0xe3, 0x57, 0xb9, 0x6f, 0x49, 0x79, 0xcf, 0xb5, 0x6f, 0x16, 0x2c, 0x25, 0x9a,
	0xf4, 0x57, 0x1f, 0xe1, 0xea, 0xdf, 0xe6, 0x20, 0xc7, 0x1a, 0x1c, 0xba, 0x09, 0x25, 0xda, 0x66,
	0xd9, 0x87, 0x68, 0x63, 0x9a, 0xd2, 0x3d, 0xd8, 0x7a, 0xe3, 0x04, 0x89, 0x41, 0xe8, 0xb6, 0x98,
	0x9f, 0x38, 0x4b, 0x7a, 0x7a, 0x7e, 0x92, 0x3c, 0x0a, 0x0c, 0x7d, 0xad, 0x9c, 0xa0, 0x38, 0x57,
	0x66, 0xc6, 0x04, 0x25, 0xd9, 0x54, 0x20, 0x35, 0xef, 0x50, 0x36, 0xe3, 0x72, 0x76, 0x76, 0x93,
	0xa6, 0xe6, 0x45, 0x20, 0x84, 0x13, 0xb3, 0x12, 0x67, 0x9c, 0x3b, 0x2b, 0x49, 0xfe, 0x29, 0x16,
	0xf4, 0xcd, 0x50, 0x96, 0x5b, 0x3d, 0x89, 0x17, 0x83, 0x93, 0x6c, 0xb2, 0x64, 0x0e, 0xac, 0x71,
	0x82, 0xcc, 0x15, 0x81, 0x5e, 0x8d, 0x87, 0x31, 0x2e, 0xb3, 0x30, 0x73, 0x18, 0x93, 0x82, 0x92,
	0x60, 0x74, 0x1f, 0xce, 0xee, 0xcd, 0x1e, 0xb6, 0xc4, 0x2c, 0xf5, 0x94, 0x91, 0xac, 0x71, 0x82,
	0xcc, 0x13, 0x80, 0xbe, 0x0e, 0x16, 0xf7, 0xc2, 0xc7, 0xf6, 0x60, 0x70, 0xc8, 0x05, 0x96, 0x12,
	0x03, 0x88, 0xa9, 0x90, 0x1a, 0x27, 0x48, 0x02, 0x4a, 0x43, 0x3f, 0x0e, 0x87, 0x07, 0xbd, 0x3e,
	0xbb, 0x29, 0x70, 0x76, 0x48, 0x84, 0xde, 0x9f, 0x20, 0xd3, 0xd0, 0x4f, 0xb2, 0xd0, 0x3d, 0xa7,
	0xf5, 0x89, 0xf3, 0x2f, 0x4c, 0x4d, 0x7b, 0xd1, 0x9e, 0x47, 0x1f, 0x9b, 0x8b, 0x00, 0x21, 0xfd,
	0x11, 0xd0, 0xba, 0x5e, 0x25, 0xa0, 0x4d, 0xea, 0x99, 0x7b, 0x54, 0xae, 0x43, 0x26, 0x1c, 0x0e,
	0x45, 0x16, 0xcb, 0xe8, 0xeb, 0xbb, 0xac, 0x29, 0x3f, 0xd8, 0x0f, 0xf1, 0x70, 0x48, 0x28, 0xa0,
	0xba, 0x0f, 0x8b, 0xaa, 0xeb, 0xe8, 0x02, 0x94, 0x7a, 0xe3, 0x70, 0xc8, 0x34, 0x88, 0xd9, 0x26,
	0x5e, 0x50, 0xb4, 0xa5, 0x67, 0x69, 0xcb, 0x3c, 0x4d, 0xdb, 0xdb, 0x29, 0x58, 0x4a, 0x2c, 0xa3,
	0x97, 0xa0, 0x10, 0x0e, 0x87, 0xac, 0xd2, 0xa4, 0xe6, 0x55, 0x1a, 0x89, 0x40, 0x65, 0x28, 0x1c,
	0x84, 0xa3, 0x51, 0xa7, 0x2b, 0x8b, 0x88, 0xfc, 0x44, 0xb7, 0x61, 0x61, 0x74, 0xd4, 0xed, 0x86,
	0x23, 0x76, 0x95, 0x2b, 0x67, 0x58, 0xed, 0x8b, 0x44, 0x45, 0x14, 0xa2, 0xa2, 0xaa, 0x0e, 0x94,
	0xa2, 0x52, 0x40, 0xcb, 0x53, 0x48, 0x2b, 0x97, 0x88, 0x23, 0xff, 0x48, 0x4c, 0xf3, 0xe9, 0xa7,
	0x4c, 0xf3, 0xd5, 0xdf, 0x92, 0x1d, 0x96, 0x4b, 0xac, 0x40, 0x51, 0xb6, 0x4b, 0x21, 0x34, 0xfa,
	0x9e, 0x1b, 0x48, 0x2d, 0x0e, 0x64, 0x89, 0x85, 0x4c, 0x0d, 0x50, 0xf6, 0xa9, 0x01, 0xba, 0x03,
	0x4b, 0x1d, 0x35, 0xbc, 0xa2, 0x40, 0xcc, 0xde, 0x91, 0x24, 0xb4, 0x1a, 0x28, 0xd9, 0x39, 0x37,
	0xad, 0xa6, 0x14, 0xa4, 0x9f, 0x5d, 0xc1, 0xc7, 0x52, 0xb2, 0x8f, 0x3e, 0x59, 0x87, 0x16, 0xa7,
	0xee, 0x74, 0x0c, 0x32, 0xcf, 0x1f, 0x83, 0xec, 0xb3, 0x9b, 0xf8, 0x89, 0x64, 0xb7, 0x7d, 0xb2,
	0x9d, 0xf3, 0xb3, 0xf1, 0xff, 0x71, 0x17, 0x3f, 0x93, 0x82, 0xf2, 0xbc, 0xc2, 0x4d, 0x33, 0x52,
	0x16, 0x6e, 0x99, 0x91, 0xf2, 0x7b, 0x6e, 0x46, 0x2a, 0x5e, 0x66, 0x66, 0x7a, 0x99, 0x8d, 0xbd,
	0x4c, 0x4e, 0x0e, 0xb9, 0x67, 0x98, 0x1c, 0xa6, 0x7d, 0xcd, 0x3f, 0xbb, 0xaf, 0x9f, 0x4a, 0x43,
	0x29, 0x6a, 0x96, 0xb4, 0x72, 0xed, 0x0f, 0x76, 0x3b, 0xfb, 0x74, 0x45, 0x56, 0xae, 0x68, 0x01,
	0x5d, 0x02, 0x18, 0x86, 0x07, 0x83, 0x71, 0xc8, 0xc8, 0x7c, 0x30, 0x56, 0x56, 0xa8, 0x9b, 0x87,
	0x83, 0x3d, 0xa7, 0x73, 0x10, 0xb9, 0x29, 0x3e, 0xd1, 0x55, 0x58, 0xda, 0x95, 0x9d, 0x84, 0xd1,
	0xb9, 0xc3, 0xc9, 0x45, 0xaa, 0xbd, 0xdf, 0x39, 0x08, 0x47, 0x87, 0x9d, 0x5d, 0xee, 0x79, 0x89,
	0xc4, 0x0b, 0x34, 0xf0, 0xb4, 0x91, 0x33, 0xf6, 0x3c, 0x0f, 0xbc, 0xfc, 0x46, 0x55, 0x58, 0x94,
	0x9b, 0x40, 0x67, 0x78, 0xd6, 0x30, 0x4b, 0x24, 0xb1, 0xa6, 0x62, 0x98, 0x8c, 0x62, 0x12, 0xc3,
	0xe4, 0x94, 0xa1, 0xd0, 0xd9, 0xdb, 0x1b, 0x86, 0xa3, 0x11, 0x6b, 0x6d, 0x25, 0x22, 0x3f, 0xd1,
	0x2d, 0x80, 0x71, 0x67, 0xd8, 0x0d, 0xc7, 0xcc, 0x77, 0x48, 0x8c, 0x28, 0x56, 0x7f, 0xec, 0x0e,
	0xbd, 0xf1, 0xb0, 0xd7, 0xef, 0x12, 0x05, 0x55, 0xfd, 0xeb, 0x54, 0x3c, 0x94, 0x45, 0xf1, 0xa5,
	0xcd, 0xda, 0x60, 0x37, 0x0b, 0x11, 0xdf, 0x68, 0x81, 0x96, 0xcf, 0xde, 0x41, 0x7c, 0x14, 0xf8,
	0x87, 0x92, 0x54, 0x99, 0x59, 0x47, 0x3c, 0x3b, 0xf3, 0x80, 0xe4, 0x9e, 0xff, 0x80, 0x3c, 0x47,
	0xd2, 0xbc, 0x93, 0x86, 0xb3, 0x73, 0xa6, 0x87, 0x27, 0x9d, 0x74, 0x99, 0x1c, 0xe9, 0xa7, 0x24,
	0x47, 0xe6, 0xa9, 0xc9, 0x91, 0x9d, 0x91, 0x1c, 0x51, 0x9f, 0xc8, 0x4d, 0xf4, 0x89, 0x32, 0x14,
	0x86, 0x47, 0xfd, 0x71, 0x2f, 0xca, 0x1b, 0xf9, 0x49, 0x13, 0xfa, 0xad, 0xc1, 0xf0, 0x51, 0xaf,
	0xdf, 0x35, 0x7b, 0x43, 0x91, 0x34, 0xca, 0x0a, 0x72, 0x00, 0xd8, 0x24, 0xc4, 0x1f, 0xe8, 0x8a,
	0xac, 0x21, 0x6e, 0x3c, 0x79, 0x7a, 0xe2, 0xeb, 0xca, 0x73, 0x9d, 0x22, 0x81, 0xde, 0xea, 0x27,
	0xc8, 0x4f, 0x9b, 0xf1, 0x97, 0xd4, 0x19, 0xff, 0xdb, 0xa0, 0x68, 0x0f, 0xba, 0x9c, 0xef, 0x83,
	0x50, 0x8a, 0x1e, 0x55, 0xc5, 0x68, 0x5e, 0xd9, 0xe0, 0xaf, 0xaa, 0x1b, 0xf2, 0x55, 0x75, 0xc3,
	0x97, 0x08, 0x12, 0x83, 0x51, 0x15, 0x72, 0xa1, 0x32, 0x9d, 0xcb, 0xd7, 0x54, 0xf1, 0xa4, 0x15,
	0x26, 0x1b, 0x79, 0x46, 0x69, 0xe4, 0xd5, 0x3b, 0xb0, 0xd2, 0x1e, 0x85, 0x43, 0xab, 0x3f, 0xa6,
	0x50, 0xf1, 0x9e, 0x7a, 0x0d, 0xf2, 0x3d, 0xb6, 0x20, 0xac, 0x58, 0x8a, 0x0f, 0x05, 0x45, 0x09,
	0x62, 0xf5, 0xeb, 0x61, 0x59, 0xdc, 0x2f, 0x24, 0xe3, 0x8b, 0xc9, 0x57, 0xdd, 0xe8, 0x15, 0x8b,
	0xa3, 0x12, 0x8f, 0xbb, 0xaf, 0xc0, 0xa2, 0xba, 0x8c, 0x2a, 0x50, 0x08, 0x59, 0x32, 0xf2, 0xc7,
	0xb5, 0x62, 0xe3, 0x04, 0x91, 0x0b, 0x9b, 0x39, 0xc8, 0x3c, 0xee, 0xec, 0x57, 0xef, 0x42, 0x9e,
	0x5b, 0x40, 0x7d, 0x89, 0xdf, 0xe1, 0x8a, 0xf2, 0xc5, 0x0d, 0x41, 0x76, 0x74, 0xdc, 0xdf, 0x15,
	0xf7, 0x1f, 0xf6, 0x9b, 0xa6, 0xae, 0x78, 0x85, 0xcb, 0xb0, 0x55, 0xf1, 0x55, 0xdd, 0x05, 0x88,
	0xc7, 0x1f, 0xf4, 0x1a, 0x2c, 0xc7, 0x03, 0x90, 0x32, 0x74, 0xad, 0x4e, 0x4d, 0x4a, 0xec, 0xc0,
	0x4d, 0x80, 0xa9, 0x12, 0x7e, 0x98, 0x64, 0x8f, 0xe0, 0x5f, 0xd5, 0x6f, 0x82, 0x05, 0xa5, 0x8e,
	0x50, 0xfb, 0xa2, 0x87, 0x8a, 0x9c, 0x78, 0x93, 0x38, 0xc3, 0x42, 0xbd, 0xdd, 0xd9, 0x17, 0xb5,
	0x57, 0x7c, 0xf1, 0x23, 0x37, 0xa4, 0xeb, 0x51, 0x85, 0xa0, 0x5f, 0xeb, 0x03, 0x58, 0x50, 0xde,
	0x9b, 0x50, 0x19, 0x4e, 0xb7, 0x9d, 0x2d, 0xc7, 0xbd, 0xe7, 0x04, 0x9b, 0x6d, 0xcb, 0x36, 0x31,
	0x09, 0xfc, 0x9d, 0x16, 0xd6, 0x4e, 0xa0, 0x02, 0x64, 0xee, 0x5a, 0x9b, 0x5a, 0x0a, 0x95, 0x20,
	0xb7, 0xa9, 0xdf, 0xc7, 0xb6, 0x96, 0x46, 0xcb, 0x00, 0x0c, 0xd5, 0xd2, 0x8d, 0x2d, 0x4f, 0xcb,
	0x20, 0x80, 0xbc, 0xd1, 0xf6, 0x7c, 0xb7, 0xa9, 0x65, 0xe9, 0xef, 0x2d, 0xdd, 0xb1, 0xb6, 0x5c,
	0x2d, 0x47, 0x7f, 0x9b, 0xae, 0xb1, 0x85, 0x89, 0x96, 0x5f, 0x37, 0xa1, 0x14, 0x3d, 0xae, 0xa1,
	0x33, 0x80, 0x12, 0xea, 0xa4, 0xb2, 0x05, 0x28, 0x18, 0x76, 0xdb, 0xf3, 0x31, 0xd1, 0x52, 0x54,
	0x73, 0xdd, 0xd8, 0xd4, 0xd2, 0x54, 0xb3, 0xed, 0x1a, 0xba, 0xad, 0x65, 0xd6, 0xb7, 0x00, 0xe2,
	0x87, 0x25, 0xb4, 0x0a, 0x2b, 0x52, 0x8c, 0x8f, 0x3d, 0x5f, 0x4a, 0x29, 0x42, 0xb6, 0xed, 0x58,
	0xbe, 0x96, 0x42, 0x17, 0xa0, 0x6c, 0xb8, 0x8e, 0xaf, 0x5b, 0x0e, 0x26, 0x81, 0xe7, 0x93, 0xb6,
	0xe1, 0xb7, 0x09, 0x66, 0x60, 0x2d, 0xbd, 0xee, 0xd2, 0xd9, 0x3c, 0x7e, 0xdd, 0x41, 0xe7, 0x60,
	0x55, 0x8a, 0x33, 0x71, 0xcb, 0x76, 0x77, 0xe2, 0x28, 0x14, 0x21, 0xdb, 0xc0, 0x76, 0x53, 0x4b,
	0xa1, 0x25, 0x28, 0x6d, 0x31, 0x5f, 0xad, 0xfb, 0x58, 0x4b, 0x53, 0x8b, 0xb7, 0xda, 0x9b, 0xd8,
	0xf0, 0xa9, 0x75, 0x16, 0x2c, 0x28, 0xaf, 0x4c, 0x6a, 0x50, 0x85, 0x57, 0x52, 0xdc, 0x22, 0x14,
	0x9b, 0x96, 0x63, 0x51, 0x4e, 0xe1, 0xe8, 0x16, 0xe6, 0x8e, 0xba, 0x7e, 0x03, 0x13, 0x2d, 0xb3,
	0xfe, 0xc9, 0x0a, 0x40, 0x5c, 0x9a, 0x51, 0x1e, 0xd2, 0xee, 0x96, 0x76, 0x02, 0x95, 0xe1, 0x94,
	0xe7, 0xeb, 0x7e, 0xdb, 0x33, 0x1a, 0xd8, 0xd8, 0x0a, 0xbc, 0xb6, 0x61, 0x60, 0xcf, 0xd3, 0xfe,
	0x28, 0x85, 0x10, 0x2c, 0xf1, 0x50, 0xca, 0xb5, 0x4f, 0xa6, 0xd0, 0x29, 0x58, 0xe6, 0x8e, 0x44,
	0x8b, 0x7f, 0x9c, 0x42, 0x2b, 0xb0, 0xc8, 0x82, 0x25, 0x97, 0xfe, 0x84, 0x85, 0x89, 0xf3, 0xb6,
	0xda, 0x5e, 0x23, 0xd0, 0xd9, 0x7a, 0x60, 0x62, 0xc7, 0xc2, 0xa6, 0x16, 0xa2, 0xf3, 0x70, 0x56,
	0x50, 0x89, 0x7b, 0x17, 0x1b, 0x7e, 0xe0, 0xb8, 0x7e, 0x50, 0x73, 0xdb, 0x8e, 0xa9, 0x3d, 0x44,
	0xef, 0x83, 0xcb, 0x9c, 0xc8, 0x37, 0x3a, 0x30, 0x75, 0xdc, 0x74, 0x1d, 0x06, 0x21, 0x6d, 0xc7,
	0xb1, 0x9c, 0xba, 0xd6, 0x45, 0xa7, 0x41, 0xe3, 0xa0, 0xb6, 0x87, 0x49, 0x80, 0x09, 0x71, 0x89,
	0xf6, 0x46, 0xac, 0x55, 0xb0, 0xb6, 0x1d, 0x7d, 0x5b, 0xb7, 0x6c, 0x7d, 0xd3, 0xc6, 0x5a, 0x0f,
	0x5d, 0x84, 0x73, 0x93, 0xd4, 0xb6, 0xdf, 0x70, 0x89, 0x75, 0x1f, 0x9b, 0xda, 0x87, 0x62, 0xa3,
	0x04, 0xd9, 0xdb, 0xf1, 0x7c, 0xdc, 0xa4, 0xb2, 0xb5, 0x47, 0xe8, 0x0a, 0x5c, 0x4c, 0x10, 0xa9,
	0x35, 0x4d, 0xd7, 0xb4, 0x6a, 0x16, 0x36, 0x19, 0x64, 0x1f, 0x5d, 0x85, 0xb5, 0x29, 0x88, 0xd5,
	0x6c, 0xd9, 0xb8, 0x89, 0x1d, 0x5f, 0xa0, 0x0e, 0xd0, 0x25, 0xa8, 0x4c, 0x78, 0xe7, 0xeb, 0x81,
	0xed, 0x7a, 0x1e, 0xa3, 0xf7, 0xa7, 0xe8, 0x35, 0x97, 0x6c, 0x5a, 0xa6, 0x89, 0x1d, 0x46, 0x1f,
	0x4c, 0x39, 0x61, 0xb8, 0x4e, 0xcd, 0xb6, 0x0c, 0x9f, 0x91, 0x0f, 0xd1, 0x1a, 0x5c, 0x48, 0x90,
	0x59, 0x64, 0x94, 0xf0, 0xbe, 0x89, 0xaa, 0x70, 0x29, 0x81, 0xb0, 0x9c, 0x6d, 0xdd, 0xb6, 0xcc,
	0xa0, 0xa5, 0x13, 0x9d, 0x7b, 0x3b, 0x9c, 0x34, 0xa2, 0x66, 0xd9, 0x58, 0x91, 0x31, 0x9a, 0x72,
	0xd5, 0xd0, 0x8d, 0x06, 0x0e, 0x6a, 0xc4, 0x6d, 0x06, 0xad, 0xb6, 0x6d, 0x33, 0x29, 0x63, 0x74,
	0x19, 0xce, 0x27, 0x50, 0x75, 0xec, 0x07, 0xa6, 0x55, 0xa7, 0x99, 0x42, 0x01, 0x47, 0x71, 0x50,
	0x09, 0xae, 0x5b, 0x9e, 0x4f, 0x76, 0x26, 0x21, 0x8f, 0x63, 0x88, 0x4c, 0xfb, 0xbb, 0xd6, 0x66,
	0xd0, 0xb2, 0xdb, 0x75, 0xcb, 0xe1, 0x99, 0xff, 0x56, 0xbc, 0xe9, 0x94, 0x54, 0x27, 0xba, 0x69,
	0x63, 0x7a, 0xd8, 0x98, 0x80, 0x0f, 0xc7, 0xbb, 0x4a, 0xa9, 0x4d, 0x7d, 0x1b, 0x3b, 0x11, 0xf1,
	0x18, 0xad, 0xc3, 0x75, 0xcb, 0xb1, 0xfc, 0x68, 0xc7, 0xb0, 0x7f, 0xcf, 0x25, 0x5b, 0x81, 0x6d,
	0x79, 0xbe, 0xe5, 0xd4, 0x83, 0xe8, 0xa0, 0x7b, 0xda, 0x47, 0xd0, 0x06, 0xac, 0xcf, 0xc2, 0xca,
	0xf0, 0xc5, 0x45, 0xc1, 0xd1, 0x9b, 0x58, 0xfb, 0x16, 0x74, 0x13, 0x5e, 0x9e, 0x85, 0x8f, 0x71,
	0xa6, 0x8b, 0x3d, 0x16, 0x55, 0xfc, 0xba, 0xe5, 0xf9, 0xda, 0xb7, 0xa2, 0xcb, 0x50, 0x51, 0x4f,
	0xa2, 0xd5, 0xd4, 0xeb, 0x38, 0x8e, 0xe7, 0xaf, 0xa4, 0xd1, 0xfb, 0xe0, 0x92, 0x0a, 0x88, 0x45,
	0x19, 0x04, 0xeb, 0xd4, 0x62, 0xed, 0x57, 0xd3, 0xa8, 0x0a, 0x17, 0x55, 0x10, 0x69, 0x3b, 0x0a,
	0x90, 0x0a, 0xfa, 0xb5, 0x34, 0xba, 0x06, 0x6b, 0xb3, 0x05, 0xf9, 0x98, 0x34, 0x2d, 0x47, 0xf7,
	0xb1, 0xa9, 0xfd, 0x7a, 0x1a, 0xbd, 0x04, 0xd7, 0x55, 0x18, 0x3f, 0xf8, 0x34, 0x9b, 0x03, 0xe2,
	0xda, 0xb6, 0xdb, 0xf6, 0x83, 0x16, 0x76, 0x4c, 0xaa, 0xf7, 0x37, 0x9e, 0x20, 0x93, 0x60, 0xcf,
	0xd7, 0x09, 0x33, 0xef, 0xd3, 0x69, 0x54, 0x81, 0x55, 0x15, 0xd6, 0x76, 0x1a, 0x58, 0xb7, 0xfd,
	0xc6, 0x8e, 0xf6, 0x8f, 0x53, 0x22, 0x1c, 0xd7, 0xc4, 0x41, 0x13, 0x37, 0x5d, 0xb2, 0x13, 0xb4,
	0x08, 0xf6, 0xbc, 0x36, 0xc1, 0xda, 0x0f, 0x67, 0x26, 0xc3, 0xc0, 0x60, 0xa6, 0xe5, 0x6d, 0xc5,
	0xa0, 0x1f, 0xc9, 0xa0, 0x17, 0xe1, 0xea, 0x14, 0x48, 0xee, 0x81, 0x5a, 0x16, 0x7e, 0x34, 0x33,
	0x19, 0x31, 0x06, 0x6d, 0xd1, 0x13, 0x21, 0xc5, 0x7d, 0x74, 0xb6, 0xce, 0xb6, 0x43, 0xbf, 0xcc,
	0x36, 0x17, 0xf4, 0x63, 0x19, 0x74, 0x05, 0x2e, 0xcc, 0x00, 0x11, 0xac, 0x1b, 0x0d, 0x06, 0xf9,
	0xf1, 0xcc, 0xe4, 0x1e, 0x73, 0xb3, 0x68, 0x65, 0xc3, 0xba, 0xb9, 0xa3, 0xfd, 0xc4, 0x94, 0x31,
	0x35, 0xdd, 0xb2, 0xb1, 0x19, 0x08, 0x45, 0x34, 0x86, 0x3f, 0x99, 0x41, 0xef, 0x87, 0xaa, 0x8a,
	0x11, 0xdd, 0x82, 0x86, 0xdc, 0xc1, 0x86, 0x6f, 0xb9, 0xbc, 0x56, 0xfc, 0xf4, 0x94, 0xd5, 0x12,
	0x48, 0x9d, 0xdb, 0xb2, 0x6c, 0x1b, 0x9b, 0xda, 0xcf, 0x4c, 0x45, 0x2a, 0x92, 0x66, 0x5b, 0x74,
	0xa7, 0x6b, 0xd8, 0x37, 0x1a, 0x4c, 0xde, 0xcf, 0x66, 0x26, 0x37, 0x48, 0x49, 0x88, 0x18, 0xf6,
	0x73, 0x53, 0x71, 0x68, 0xb9, 0x66, 0x40, 0x8f, 0x82, 0xa5, 0xdb, 0xd6, 0x7d, 0xea, 0xc2, 0xef,
	0x67, 0x68, 0x6f, 0x91, 0x27, 0x9a, 0x17, 0xef, 0x77, 0x32, 0x93, 0x9d, 0x48, 0xd0, 0xb5, 0x77,
	0x33, 0xe8, 0x3a, 0x5c, 0x99, 0x41, 0x99, 0xd8, 0x80, 0xf7, 0x32, 0x68, 0x1d, 0xae, 0xcd, 0xce,
	0xc1, 0x7b, 0xba, 0xc5, 0x4e, 0xb4, 0x94, 0xf9, 0xd9, 0x0c, 0xba, 0x04, 0xe7, 0x66, 0xc9, 0xc4,
	0xdb, 0xd8, 0xf1, 0xb5, 0x2f, 0x67, 0x94, 0x4e, 0x27, 0x99, 0x3e, 0x97, 0xa1, 0x9d, 0xce, 0xdb,
	0x71, 0x8c, 0x68, 0xe9, 0xf3, 0x99, 0xb8, 0x4b, 0xca, 0xb5, 0x2f, 0x64, 0xd0, 0x69, 0x38, 0x69,
	0xe2, 0x6d, 0x76, 0xfc, 0xe5, 0xea, 0x17, 0xd9, 0xaa, 0x61, 0x63, 0xdd, 0x69, 0xb7, 0xa2, 0xd5,
	0x2f, 0x31, 0x91, 0x09, 0xe0, 0x57, 0x32, 0xe8, 0x1c, 0x9c, 0x9e, 0x68, 0x54, 0x9c, 0xf4, 0xdf,
	0x99, 0xa8, 0xd5, 0xca, 0xa5, 0x6f, 0xcf, 0x52, 0xb1, 0xcc, 0x26, 0x26, 0x85, 0x07, 0xf3, 0x53,
	0x59, 0xb4, 0x06, 0xe7, 0xa5, 0x09, 0xbc, 0xba, 0x62, 0x22, 0x06, 0x23, 0x13, 0xb7, 0x3c, 0xed,
	0xb7, 0x73, 0x34, 0x15, 0xa7, 0x10, 0x4c, 0x36, 0x03, 0xfc, 0x4e, 0x8e, 0x6e, 0xe3, 0x14, 0x40,
	0x84, 0x84, 0x41, 0x3e, 0x91, 0x9b, 0xa9, 0x85, 0x76, 0x24, 0xab, 0x4e, 0x21, 0xda, 0xef, 0xe6,
	0xd0, 0x55, 0xb8, 0x1c, 0x87, 0xc2, 0x6b, 0xb7, 0x5a, 0x2e, 0xa1, 0xcd, 0x70, 0xfb, 0x95, 0xa0,
	0xa9, 0x3b, 0x56, 0x8d, 0x8e, 0x4d, 0xbf, 0x97, 0x9b, 0x3c, 0x16, 0xac, 0xa9, 0x1b, 0xba, 0x63,
	0x60, 0x96, 0xa4, 0x1f, 0xcb, 0x4f, 0x1e, 0x0b, 0x13, 0xeb, 0xa6, 0x6d, 0x39, 0x38, 0xc0, 0xaf,
	0x1b, 0x18, 0x9b, 0xd8, 0xd4, 0x7e, 0x3e, 0x4f, 0x03, 0xc1, 0x3d, 0x8c, 0x39, 0x7f, 0x21, 0x8f,
	0x56, 0x41, 0x13, 0x46, 0xc7, 0xcb, 0xbf, 0x98, 0x47, 0xe7, 0xe1, 0xcc, 0x44, 0x0b, 0x93, 0xc4,
	0x5f, 0xca, 0xd3, 0x22, 0x95, 0x6c, 0xd2, 0x42, 0x9d, 0xf6, 0xcb, 0x79, 0x74, 0x11, 0xca, 0xcc,
	0x1b, 0x56, 0x73, 0x71, 0xe0, 0xeb, 0xf5, 0x7a, 0x34, 0x81, 0x7c, 0x57, 0x81, 0x7a, 0xc2, 0xc8,
	0x72, 0x18, 0x0b, 0x5a, 0x7a, 0xdb, 0xe3, 0xdd, 0xdf, 0x25, 0xda, 0x77, 0x17, 0x68, 0x40, 0x92,
	0x00, 0x65, 0xb0, 0x11, 0xa8, 0xef, 0x29, 0xd0, 0xec, 0x54, 0xb5, 0xc8, 0x09, 0x9a, 0xd3, 0xbf,
	0x37, 0x56, 0x23, 0xe8, 0xd1, 0x70, 0xc9, 0x01, 0xdf, 0x37, 0x05, 0x90, 0x1b, 0x2b, 0x00, 0xdf,
	0x5f, 0xa0, 0x71, 0xe1, 0x00, 0xd6, 0xbb, 0xf9, 0xf2, 0xdb, 0xb1, 0x79, 0x82, 0xef, 0x9e, 0x4e,
	0xcf, 0xb5, 0x4f, 0x2c, 0xc5, 0xcb, 0x1f, 0x28, 0xd0, 0xc2, 0xa2, 0xa2, 0x68, 0x79, 0xaf, 0xe9,
	0x86, 0xaa, 0xe1, 0x07, 0x0b, 0x74, 0xcf, 0x64, 0xe4, 0xc5, 0xac, 0x3a, 0x51, 0xa1, 0x3e, 0x53,
	0xa0, 0x15, 0x25, 0x4a, 0xa9, 0xcd, 0x76, 0x3d, 0x68, 0x60, 0xbb, 0xc5, 0x7a, 0x86, 0x4f, 0x2c,
	0xbc, 0xcd, 0xec, 0xd2, 0xfe, 0xa9, 0x80, 0xce, 0x02, 0x8a, 0x44, 0xf1, 0x13, 0x44, 0x09, 0xff,
	0x5c, 0xa0, 0xbb, 0x21, 0x08, 0x74, 0x98, 0x0e, 0xf4, 0x56, 0xcb, 0xde, 0x09, 0x6c, 0x7d, 0x13,
	0xdb, 0x9e, 0xf6, 0x2f, 0x05, 0x7a, 0x92, 0x54, 0xb2, 0x1c, 0x16, 0xb5, 0x7f, 0x55, 0x39, 0x1d,
	0x37, 0x68, 0x52, 0x37, 0xe9, 0x06, 0xb0, 0x40, 0x6b, 0xff, 0x56, 0x40, 0x17, 0xe0, 0xac, 0xca,
	0xb9, 0x8d, 0x89, 0x27, 0xcd, 0xfe, 0xf7, 0x02, 0xcf, 0xfb, 0x98, 0xda, 0xb4, 0x9c, 0x04, 0xe2,
	0x3f, 0x0a, 0xfc, 0x74, 0x31, 0x84, 0x2c, 0xa8, 0x2a, 0xe0, 0xaf, 0x8a, 0xfc, 0x60, 0x24, 0x00,
	0x6e, 0xad, 0xc6, 0x72, 0xba, 0x49, 0x9b, 0x02, 0x45, 0xfd, 0x67, 0x41, 0x41, 0x61, 0x12, 0x97,
	0xb1, 0x9a, 0x4b, 0x73, 0xd2, 0xc6, 0x34, 0x92, 0xda, 0x7f, 0xa9, 0xbe, 0xd0, 0x3e, 0x12, 0x9d,
	0x2c, 0x26, 0xe4, 0x1d, 0x55, 0x08, 0x23, 0x13, 0xdc, 0x74, 0x7d, 0x9c, 0x44, 0xbd, 0xab, 0x0a,
	0xa1, 0xf3, 0x4f, 0x92, 0xfc, 0x9e, 0x1a, 0x10, 0x69, 0x6f, 0x14, 0xcd, 0xcf, 0xb2, 0x7c, 0x8d,
	0xa8, 0xe2, 0x2a, 0x13, 0xd3, 0x3f, 0x97, 0xb4, 0xb0, 0x65, 0xeb, 0x06, 0x16, 0xe3, 0x0d, 0x25,
	0x7f, 0x5e, 0x4d, 0x15, 0x9f, 0xe8, 0x8e, 0x57, 0x73, 0x49, 0x33, 0x69, 0xc0, 0x17, 0xd4, 0xbd,
	0xf4, 0xb0, 0xcf, 0xf7, 0x98, 0x91, 0xbe, 0xa8, 0x6a, 0x8f, 0x98, 0xee, 0x11, 0xcb, 0xe7, 0xe2,
	0xbf, 0xa4, 0x66, 0x59, 0x4b, 0x27, 0x9e, 0xe2, 0x3a, 0x33, 0x82, 0x8f, 0xde, 0x5f, 0x2e, 0xa0,
	0x17, 0xe0, 0x7d, 0xea, 0xae, 0x8a, 0xe4, 0x76, 0xf8, 0x94, 0x16, 0x8f, 0x0c, 0x5f, 0x29, 0xac,
	0x7f, 0xbc, 0x04, 0xcb, 0xc9, 0x9b, 0x37, 0xbd, 0x72, 0x39, 0x96, 0xad, 0x9d, 0xa0, 0x57, 0x13,
	0xdd, 0xa4, 0x65, 0xb6, 0xa6, 0xb7, 0x6d, 0x5a, 0x17, 0x5b, 0xae, 0xb6, 0x47, 0xef, 0xa7, 0xb2,
	0x74, 0x29, 0xeb, 0x21, 0x1d, 0xa5, 0xa7, 0xd7, 0x83, 0xba, 0xed, 0x6e, 0xea, 0xb6, 0x28, 0xa5,
	0xda, 0x43, 0x3a, 0xd6, 0xd7, 0x0d, 0xdb, 0x6d, 0x47, 0x15, 0x89, 0xde, 0x5c, 0x04, 0x99, 0x4e,
	0x28, 0x5d, 0x7a, 0xd3, 0x9c, 0x4d, 0x7a, 0x83, 0x5e, 0x1a, 0xb9, 0x0a, 0x21, 0x42, 0x5c, 0xba,
	0xb4, 0x5e, 0x4c, 0x11, 0xac, 0xf2, 0x7e, 0xf5, 0x21, 0x6a, 0x6e, 0xcd, 0x7a, 0x9d, 0x6f, 0x21,
	0x2f, 0x85, 0xfc, 0x1e, 0x74, 0x06, 0x90, 0xc0, 0xca, 0xc9, 0xdd, 0x27, 0x3b, 0xda, 0x3e, 0xbd,
	0x55, 0x50, 0xbc, 0x72, 0x11, 0x88, 0x6a, 0x82, 0x70, 0xe2, 0x40, 0x62, 0xbc, 0x2d, 0xbd, 0x56,
	0x73, 0x6d, 0x33, 0x6a, 0x14, 0xd1, 0x1d, 0x43, 0xeb, 0x53, 0x47, 0x29, 0x46, 0x99, 0xf2, 0xa5,
	0x27, 0x3a, 0x4b, 0xf6, 0x01, 0xba, 0x06, 0x57, 0x28, 0x62, 0xee, 0x58, 0xcd, 0xc6, 0xef, 0x43,
	0x3a, 0xda, 0x27, 0x5c, 0x9b, 0x06, 0x4a, 0x67, 0xdf, 0xa4, 0xc9, 0x29, 0x06, 0x86, 0xa9, 0x3a,
	0x45, 0xef, 0xbc, 0x15, 0x58, 0xe5, 0xe4, 0xa8, 0x64, 0xf3, 0x56, 0x24, 0xae, 0xbe, 0x96, 0xe3,
	0xf9, 0xba, 0x6d, 0xb3, 0x9c, 0xa1, 0x57, 0xdf, 0x15, 0x58, 0x6c, 0xb7, 0xe8, 0x3d, 0x04, 0xf3,
	0xa5, 0x3f, 0x4d, 0xa1, 0x9b, 0xf0, 0xd2, 0x2c, 0xcf, 0x79, 0xc9, 0x92, 0x71, 0x72, 0xb7, 0x31,
	0x21, 0x96, 0x89, 0x3d, 0xed, 0xcf, 0xd8, 0x3d, 0x5b, 0x15, 0x72, 0xfb, 0x96, 0xf6, 0xe7, 0x29,
	0xb4, 0x01, 0x2f, 0xce, 0x15, 0x23, 0x93, 0x55, 0x6f, 0x62, 0xaf, 0xa5, 0x1b, 0x58, 0xfb, 0x8b,
	0x14, 0x6d, 0x88, 0xd2, 0x38, 0xf9, 0xa2, 0xf0, 0x77, 0x29, 0x7a, 0x8e, 0x26, 0xc7, 0x23, 0xdb,
	0xad, 0x7b, 0xf4, 0xee, 0x10, 0x79, 0x4a, 0xeb, 0x84, 0xe5, 0xd0, 0x3b, 0x7b, 0x8b, 0xb8, 0x9b,
	0x98, 0xde, 0x19, 0x22, 0x5a, 0xcc, 0xc6, 0x4e, 0x0f, 0xbd, 0x28, 0x5c, 0x81, 0x0b, 0xba, 0x69,
	0xd2, 0x71, 0x79, 0xee, 0xd0, 0x7e, 0x19, 0x2a, 0x09, 0xc8, 0xd4, 0xc0, 0x7e, 0x0d, 0xd6, 0x12,
	0x80, 0x39, 0xc3, 0xfa, 0x25, 0x38, 0x97, 0x80, 0x4d, 0x0e, 0xea, 0x93, 0x7a, 0xa6, 0x86, 0xf4,
	0x8b, 0x50, 0x9e, 0x00, 0x24, 0x06, 0xf4, 0xf3, 0x70, 0x26, 0x69, 0x86, 0x3a, 0x9c, 0x2b, 0xca,
	0x67, 0x0e, 0xe6, 0x51, 0x8c, 0x1a, 0xae, 0xe7, 0xab, 0x59, 0xf4, 0x53, 0x6c, 0x9e, 0x64, 0xf7,
	0xa0, 0x28, 0x8b, 0xe8, 0x60, 0xbb, 0x0a, 0x5a, 0xdb, 0x61, 0x13, 0x42, 0xbc, 0xfc, 0x1e, 0x9b,
	0x14, 0xe9, 0xbd, 0x4d, 0xa4, 0x2e, 0xbd, 0x02, 0x6a, 0x1f, 0xcf, 0xb2, 0x19, 0x08, 0x53, 0x6b,
	0x1c, 0x3a, 0x0a, 0xd4, 0x6c, 0xbd, 0x1e, 0xb5, 0x8c, 0x9a, 0x6e, 0x7b, 0x58, 0xfb, 0x9b, 0x2c,
	0x3a, 0x09, 0xe0, 0xb6, 0xb0, 0x13, 0x58, 0x9e, 0xd7, 0xc6, 0xda, 0x77, 0x16, 0x6e, 0xfd, 0x66,
	0x0e, 0x4e, 0x7a, 0xe2, 0x8f, 0x6a, 0xbd, 0x70, 0xf8, 0xb8, 0xb7, 0x1b, 0x22, 0x03, 0x8a, 0xf5,
	0x50, 0xfe, 0xd1, 0xcd, 0xd4, 0x33, 0x2e, 0x3e, 0x38, 0x1c, 0x1f, 0x57, 0x12, 0x7f, 0xf6, 0x5a,
	0x5d, 0xf9, 0x8e, 0xbf, 0xfc, 0xf4, 0x47, 0xd3, 0x0b, 0xa8, 0x74, 0xe3, 0xf1, 0x2b, 0x37, 0xd8,
	0x2b, 0x29, 0xaa, 0x43, 0x91, 0x3d, 0xe2, 0xda, 0x83, 0x2e, 0x92, 0xff, 0xc3, 0x2a, 0xdf, 0x8b,
	0x2b, 0x93, 0x0b, 0xd5, 0x55, 0x26, 0xe0, 0x24, 0x5a, 0xa2, 0x02, 0xf8, 0x7f, 0x90, 0xef, 0x0f,
	0xba, 0x2f, 0xa4, 0x6e, 0xa6, 0x50, 0x1d, 0xf2, 0x4c, 0xd0, 0x68, 0xae, 0x2d, 0x53, 0xd2, 0x10,
	0x93, 0xb6, 0x88, 0x20, 0x92, 0x36, 0xba, 0x99, 0x42, 0xaf, 0x43, 0x01, 0x7f, 0x38, 0xdc, 0x3d,
	0x1a, 0x87, 0xa8, 0x2c, 0x38, 0xa6, 0x1e, 0x90, 0x2b, 0x73, 0x74, 0x54, 0xcf, 0x33, 0x91, 0xab,
	0xd5, 0x05, 0x26, 0x92, 0x8b, 0xb9, 0x23, 0x9e, 0x93, 0x51, 0x07, 0x4a, 0xfa, 0xd1, 0x78, 0xc0,
	0x5e, 0x1b, 0xd1, 0x6a, 0xf2, 0xe9, 0xf8, 0x69, 0x82, 0xaf, 0x31, 0xc1, 0x97, 0x2b, 0x67, 0xa8,
	0x60, 0xf6, 0x1a, 0x7c, 0xa3, 0x73, 0x34, 0x1e, 0x04, 0x52, 0x07, 0x7f, 0x74, 0x46, 0x01, 0x14,
	0xa9, 0x0a, 0xef, 0xb8, 0xbf, 0xfb, 0xbc, 0x1a, 0xae, 0x32, 0x0d, 0x97, 0x2a, 0xab, 0x6c, 0x73,
	0x8e, 0xfb, 0xbb, 0x33, 0x15, 0xec, 0x02, 0x50, 0x05, 0xfc, 0x79, 0xf2, 0x79, 0x55, 0x5c, 0x67,
	0x2a, 0xd6, 0x2a, 0x67, 0xa9, 0x0a, 0xfe, 0x4e, 0x3d, 0x53, 0x89, 0x0d, 0xf9, 0x46, 0xa7, 0xbf,
	0xb7, 0x1f, 0xa2, 0xc4, 0x43, 0xff, 0x5c, 0xb9, 0x17, 0x98, 0xdc, 0x33, 0xd5, 0x95, 0x78, 0x23,
	0x6f, 0xbc, 0xc1, 0x04, 0xdc, 0x49, 0xad, 0x3f, 0xc8, 0x33, 0xf4, 0xed, 0xff, 0x09, 0x00, 0x00,
	0xff, 0xff, 0x0c, 0xa6, 0xcd, 0x0b, 0x16, 0x2e, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SkaffoldServiceClient is the client API for SkaffoldService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SkaffoldServiceClient interface {
	// Returns the state of the current Skaffold execution
	GetState(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*State, error)
	// DEPRECATED. Events should be used instead.
	// TODO remove (https://github.com/GoogleContainerTools/skaffold/issues/3168)
	EventLog(ctx context.Context, opts ...grpc.CallOption) (SkaffoldService_EventLogClient, error)
	// Returns all the events of the current Skaffold execution from the start
	Events(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (SkaffoldService_EventsClient, error)
	// Allows for a single execution of some or all of the phases (build, sync, deploy) in case autoBuild, autoDeploy or autoSync are disabled.
	Execute(ctx context.Context, in *UserIntentRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Allows for enabling or disabling automatic build trigger
	AutoBuild(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Allows for enabling or disabling automatic sync trigger
	AutoSync(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Allows for enabling or disabling automatic deploy trigger
	AutoDeploy(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// EXPERIMENTAL. It allows for custom events to be implemented in custom builders for example.
	Handle(ctx context.Context, in *Event, opts ...grpc.CallOption) (*empty.Empty, error)
}

type skaffoldServiceClient struct {
	cc *grpc.ClientConn
}

func NewSkaffoldServiceClient(cc *grpc.ClientConn) SkaffoldServiceClient {
	return &skaffoldServiceClient{cc}
}

func (c *skaffoldServiceClient) GetState(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*State, error) {
	out := new(State)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/GetState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldServiceClient) EventLog(ctx context.Context, opts ...grpc.CallOption) (SkaffoldService_EventLogClient, error) {
	stream, err := c.cc.NewStream(ctx, &_SkaffoldService_serviceDesc.Streams[0], "/proto.SkaffoldService/EventLog", opts...)
	if err != nil {
		return nil, err
	}
	x := &skaffoldServiceEventLogClient{stream}
	return x, nil
}

type SkaffoldService_EventLogClient interface {
	Send(*LogEntry) error
	Recv() (*LogEntry, error)
	grpc.ClientStream
}

type skaffoldServiceEventLogClient struct {
	grpc.ClientStream
}

func (x *skaffoldServiceEventLogClient) Send(m *LogEntry) error {
	return x.ClientStream.SendMsg(m)
}

func (x *skaffoldServiceEventLogClient) Recv() (*LogEntry, error) {
	m := new(LogEntry)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *skaffoldServiceClient) Events(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (SkaffoldService_EventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_SkaffoldService_serviceDesc.Streams[1], "/proto.SkaffoldService/Events", opts...)
	if err != nil {
		return nil, err
	}
	x := &skaffoldServiceEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type SkaffoldService_EventsClient interface {
	Recv() (*LogEntry, error)
	grpc.ClientStream
}

type skaffoldServiceEventsClient struct {
	grpc.ClientStream
}

func (x *skaffoldServiceEventsClient) Recv() (*LogEntry, error) {
	m := new(LogEntry)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *skaffoldServiceClient) Execute(ctx context.Context, in *UserIntentRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/Execute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldServiceClient) AutoBuild(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/AutoBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldServiceClient) AutoSync(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/AutoSync", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldServiceClient) AutoDeploy(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/AutoDeploy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldServiceClient) Handle(ctx context.Context, in *Event, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/Handle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SkaffoldServiceServer is the server API for SkaffoldService service.
type SkaffoldServiceServer interface {
	// Returns the state of the current Skaffold execution
	GetState(context.Context, *empty.Empty) (*State, error)
	// DEPRECATED. Events should be used instead.
	// TODO remove (https://github.com/GoogleContainerTools/skaffold/issues/3168)
	EventLog(SkaffoldService_EventLogServer) error
	// Returns all the events of the current Skaffold execution from the start
	Events(*empty.Empty, SkaffoldService_EventsServer) error
	// Allows for a single execution of some or all of the phases (build, sync, deploy) in case autoBuild, autoDeploy or autoSync are disabled.
	Execute(context.Context, *UserIntentRequest) (*empty.Empty, error)
	// Allows for enabling or disabling automatic build trigger
	AutoBuild(context.Context, *TriggerRequest) (*empty.Empty, error)
	// Allows for enabling or disabling automatic sync trigger
	AutoSync(context.Context, *TriggerRequest) (*empty.Empty, error)
	// Allows for enabling or disabling automatic deploy trigger
	AutoDeploy(context.Context, *TriggerRequest) (*empty.Empty, error)
	// EXPERIMENTAL. It allows for custom events to be implemented in custom builders for example.
	Handle(context.Context, *Event) (*empty.Empty, error)
}

// UnimplementedSkaffoldServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSkaffoldServiceServer struct {
}

func (*UnimplementedSkaffoldServiceServer) GetState(ctx context.Context, req *empty.Empty) (*State, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetState not implemented")
}
func (*UnimplementedSkaffoldServiceServer) EventLog(srv SkaffoldService_EventLogServer) error {
	return status.Errorf(codes.Unimplemented, "method EventLog not implemented")
}
func (*UnimplementedSkaffoldServiceServer) Events(req *empty.Empty, srv SkaffoldService_EventsServer) error {
	return status.Errorf(codes.Unimplemented, "method Events not implemented")
}
func (*UnimplementedSkaffoldServiceServer) Execute(ctx context.Context, req *UserIntentRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Execute not implemented")
}
func (*UnimplementedSkaffoldServiceServer) AutoBuild(ctx context.Context, req *TriggerRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AutoBuild not implemented")
}
func (*UnimplementedSkaffoldServiceServer) AutoSync(ctx context.Context, req *TriggerRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AutoSync not implemented")
}
func (*UnimplementedSkaffoldServiceServer) AutoDeploy(ctx context.Context, req *TriggerRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AutoDeploy not implemented")
}
func (*UnimplementedSkaffoldServiceServer) Handle(ctx context.Context, req *Event) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Handle not implemented")
}

func RegisterSkaffoldServiceServer(s *grpc.Server, srv SkaffoldServiceServer) {
	s.RegisterService(&_SkaffoldService_serviceDesc, srv)
}

func _SkaffoldService_GetState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(empty.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).GetState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/GetState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).GetState(ctx, req.(*empty.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldService_EventLog_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SkaffoldServiceServer).EventLog(&skaffoldServiceEventLogServer{stream})
}

type SkaffoldService_EventLogServer interface {
	Send(*LogEntry) error
	Recv() (*LogEntry, error)
	grpc.ServerStream
}

type skaffoldServiceEventLogServer struct {
	grpc.ServerStream
}

func (x *skaffoldServiceEventLogServer) Send(m *LogEntry) error {
	return x.ServerStream.SendMsg(m)
}

func (x *skaffoldServiceEventLogServer) Recv() (*LogEntry, error) {
	m := new(LogEntry)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _SkaffoldService_Events_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(empty.Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SkaffoldServiceServer).Events(m, &skaffoldServiceEventsServer{stream})
}

type SkaffoldService_EventsServer interface {
	Send(*LogEntry) error
	grpc.ServerStream
}

type skaffoldServiceEventsServer struct {
	grpc.ServerStream
}

func (x *skaffoldServiceEventsServer) Send(m *LogEntry) error {
	return x.ServerStream.SendMsg(m)
}

func _SkaffoldService_Execute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).Execute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/Execute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).Execute(ctx, req.(*UserIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldService_AutoBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).AutoBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/AutoBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).AutoBuild(ctx, req.(*TriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldService_AutoSync_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).AutoSync(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/AutoSync",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).AutoSync(ctx, req.(*TriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldService_AutoDeploy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).AutoDeploy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/AutoDeploy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).AutoDeploy(ctx, req.(*TriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldService_Handle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Event)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).Handle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/Handle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).Handle(ctx, req.(*Event))
	}
	return interceptor(ctx, in, info, handler)
}

var _SkaffoldService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "proto.SkaffoldService",
	HandlerType: (*SkaffoldServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetState",
			Handler:    _SkaffoldService_GetState_Handler,
		},
		{
			MethodName: "Execute",
			Handler:    _SkaffoldService_Execute_Handler,
		},
		{
			MethodName: "AutoBuild",
			Handler:    _SkaffoldService_AutoBuild_Handler,
		},
		{
			MethodName: "AutoSync",
			Handler:    _SkaffoldService_AutoSync_Handler,
		},
		{
			MethodName: "AutoDeploy",
			Handler:    _SkaffoldService_AutoDeploy_Handler,
		},
		{
			MethodName: "Handle",
			Handler:    _SkaffoldService_Handle_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "EventLog",
			Handler:       _SkaffoldService_EventLog_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "Events",
			Handler:       _SkaffoldService_Events_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "skaffold.proto",
}
