// Code generated by protoc-gen-go. DO NOT EDIT.
// source: skaffold.proto

package proto

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Enum indicating builders used
type BuilderType int32

const (
	// Could not determine builder type
	BuilderType_UNKNOWN_BUILDER_TYPE BuilderType = 0
	// JIB Builder
	BuilderType_JIB BuilderType = 1
	// Bazel Builder
	BuilderType_BAZEL BuilderType = 2
	// Buildpacks Builder
	BuilderType_BUILDPACKS BuilderType = 3
	// Custom Builder
	BuilderType_CUSTOM BuilderType = 4
	// Kaniko Builder
	BuilderType_KANIKO BuilderType = 5
	// Docker Builder
	BuilderType_DOCKER BuilderType = 6
)

var BuilderType_name = map[int32]string{
	0: "UNKNOWN_BUILDER_TYPE",
	1: "JIB",
	2: "BAZEL",
	3: "BUILDPACKS",
	4: "CUSTOM",
	5: "KANIKO",
	6: "DOCKER",
}

var BuilderType_value = map[string]int32{
	"UNKNOWN_BUILDER_TYPE": 0,
	"JIB":                  1,
	"BAZEL":                2,
	"BUILDPACKS":           3,
	"CUSTOM":               4,
	"KANIKO":               5,
	"DOCKER":               6,
}

func (x BuilderType) String() string {
	return proto.EnumName(BuilderType_name, int32(x))
}

func (BuilderType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{0}
}

// Enum indicating build type i.e. local, cluster vs GCB
type BuildType int32

const (
	// Could not determine Build Type
	BuildType_UNKNOWN_BUILD_TYPE BuildType = 0
	// Cluster Build
	BuildType_CLUSTER BuildType = 1
	// GCB Build
	BuildType_GCB BuildType = 2
	// Local Build
	BuildType_LOCAL BuildType = 3
)

var BuildType_name = map[int32]string{
	0: "UNKNOWN_BUILD_TYPE",
	1: "CLUSTER",
	2: "GCB",
	3: "LOCAL",
}

var BuildType_value = map[string]int32{
	"UNKNOWN_BUILD_TYPE": 0,
	"CLUSTER":            1,
	"GCB":                2,
	"LOCAL":              3,
}

func (x BuildType) String() string {
	return proto.EnumName(BuildType_name, int32(x))
}

func (BuildType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{1}
}

// Enum indicating deploy tools used
type DeployerType int32

const (
	// Could not determine Deployer Type
	DeployerType_UNKNOWN_DEPLOYER_TYPE DeployerType = 0
	// Helm Deployer
	DeployerType_HELM DeployerType = 1
	// Kustomize Deployer
	DeployerType_KUSTOMIZE DeployerType = 2
	// Kubectl Deployer
	DeployerType_KUBECTL DeployerType = 3
)

var DeployerType_name = map[int32]string{
	0: "UNKNOWN_DEPLOYER_TYPE",
	1: "HELM",
	2: "KUSTOMIZE",
	3: "KUBECTL",
}

var DeployerType_value = map[string]int32{
	"UNKNOWN_DEPLOYER_TYPE": 0,
	"HELM":                  1,
	"KUSTOMIZE":             2,
	"KUBECTL":               3,
}

func (x DeployerType) String() string {
	return proto.EnumName(DeployerType_name, int32(x))
}

func (DeployerType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{2}
}

// Enum indicating cluster type the application is deployed to
type ClusterType int32

const (
	// Could not determine Cluster Type
	ClusterType_UNKNOWN_CLUSTER_TYPE ClusterType = 0
	// Minikube Cluster
	ClusterType_MINIKUBE ClusterType = 1
	// GKE cluster
	ClusterType_GKE ClusterType = 2
	// All Cluster except Minikube and GKE
	ClusterType_OTHER ClusterType = 3
)

var ClusterType_name = map[int32]string{
	0: "UNKNOWN_CLUSTER_TYPE",
	1: "MINIKUBE",
	2: "GKE",
	3: "OTHER",
}

var ClusterType_value = map[string]int32{
	"UNKNOWN_CLUSTER_TYPE": 0,
	"MINIKUBE":             1,
	"GKE":                  2,
	"OTHER":                3,
}

func (x ClusterType) String() string {
	return proto.EnumName(ClusterType_name, int32(x))
}

func (ClusterType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{3}
}

// Enum for Status codes
// These error codes are prepended by Phase Name e.g.
// BUILD, DEPLOY, STATUSCHECK, DEVINIT
type StatusCode int32

const (
	// A default status code for events that do not have an associated phase.
	// Typically seen with the DevEndEvent event on success.
	StatusCode_OK StatusCode = 0
	// Status Check Success
	StatusCode_STATUSCHECK_SUCCESS StatusCode = 200
	// Build Success
	StatusCode_BUILD_SUCCESS StatusCode = 201
	// Deploy Success
	StatusCode_DEPLOY_SUCCESS StatusCode = 202
	// Build error due to push access denied
	StatusCode_BUILD_PUSH_ACCESS_DENIED StatusCode = 101
	// Build error due to GCP project not found.
	StatusCode_BUILD_PROJECT_NOT_FOUND StatusCode = 102
	// Container image pull error
	StatusCode_STATUSCHECK_IMAGE_PULL_ERR StatusCode = 300
	// Container creating error
	StatusCode_STATUSCHECK_CONTAINER_CREATING StatusCode = 301
	// Container run error
	StatusCode_STATUSCHECK_RUN_CONTAINER_ERR StatusCode = 302
	// Container is already terminated
	StatusCode_STATUSCHECK_CONTAINER_TERMINATED StatusCode = 303
	// Deployment waiting for rollout
	StatusCode_STATUSCHECK_DEPLOYMENT_ROLLOUT_PENDING StatusCode = 304
	// Container restarting error
	StatusCode_STATUSCHECK_CONTAINER_RESTARTING StatusCode = 356
	// Readiness probe failed
	StatusCode_STATUSCHECK_UNHEALTHY StatusCode = 357
	// Node memory pressure error
	StatusCode_STATUSCHECK_NODE_MEMORY_PRESSURE StatusCode = 400
	// Node disk pressure error
	StatusCode_STATUSCHECK_NODE_DISK_PRESSURE StatusCode = 401
	// Node network unavailable error
	StatusCode_STATUSCHECK_NODE_NETWORK_UNAVAILABLE StatusCode = 402
	// Node PID pressure error
	StatusCode_STATUSCHECK_NODE_PID_PRESSURE StatusCode = 403
	// Node unschedulable error
	StatusCode_STATUSCHECK_NODE_UNSCHEDULABLE StatusCode = 404
	// Node unreachable error
	StatusCode_STATUSCHECK_NODE_UNREACHABLE StatusCode = 405
	// Node not ready error
	StatusCode_STATUSCHECK_NODE_NOT_READY StatusCode = 406
	// Scheduler failure error
	StatusCode_STATUSCHECK_FAILED_SCHEDULING StatusCode = 407
	// Kubectl connection error
	StatusCode_STATUSCHECK_KUBECTL_CONNECTION_ERR StatusCode = 409
	// Kubectl process killed error
	StatusCode_STATUSCHECK_KUBECTL_PID_KILLED StatusCode = 410
	// Kubectl client fetch err
	StatusCode_STATUSCHECK_KUBECTL_CLIENT_FETCH_ERR StatusCode = 411
	StatusCode_STATUSCHECK_DEPLOYMENT_FETCH_ERR     StatusCode = 412
	// Pod Initializing
	StatusCode_STATUSCHECK_POD_INITIALIZING StatusCode = 451
	// Could not determine error and phase
	StatusCode_UNKNOWN_ERROR StatusCode = 500
	// Status Check error unknown
	StatusCode_STATUSCHECK_UNKNOWN StatusCode = 501
	// Container is unschedulable due to unknown reasons
	StatusCode_STATUSCHECK_UNKNOWN_UNSCHEDULABLE StatusCode = 502
	// Container is waiting due to unknown reason
	StatusCode_STATUSCHECK_CONTAINER_WAITING_UNKNOWN StatusCode = 503
	// Container event reason unknown
	StatusCode_STATUSCHECK_UNKNOWN_EVENT StatusCode = 509
	// Deploy failed due to unknown reason
	StatusCode_DEPLOY_UNKNOWN StatusCode = 504
	// SYNC failed due to known reason
	StatusCode_SYNC_UNKNOWN StatusCode = 505
	// Build failed due to unknown reason
	StatusCode_BUILD_UNKNOWN StatusCode = 506
	// Dev Init failed due to unknown reason
	StatusCode_DEVINIT_UNKNOWN StatusCode = 507
	// Cleanup failed due to unknown reason
	StatusCode_CLEANUP_UNKNOWN StatusCode = 508
	// File Sync Initialize failure
	StatusCode_SYNC_INIT_ERROR StatusCode = 601
	// Failed to configure watcher for build dependencies in dev loop
	StatusCode_DEVINIT_REGISTER_BUILD_DEPS StatusCode = 701
	// Failed to configure watcher for test dependencies in dev loop
	StatusCode_DEVINIT_REGISTER_TEST_DEPS StatusCode = 702
	// Failed to configure watcher for deploy dependencies in dev loop
	StatusCode_DEVINIT_REGISTER_DEPLOY_DEPS StatusCode = 703
	// Failed to configure watcher for Skaffold configuration file.
	StatusCode_DEVINIT_REGISTER_CONFIG_DEP StatusCode = 704
	// User cancelled the skaffold dev run
	StatusCode_STATUSCHECK_USER_CANCELLED StatusCode = 800
	// Deadline for status check exceeded
	StatusCode_STATUSCHECK_DEADLINE_EXCEEDED StatusCode = 801
)

var StatusCode_name = map[int32]string{
	0:   "OK",
	200: "STATUSCHECK_SUCCESS",
	201: "BUILD_SUCCESS",
	202: "DEPLOY_SUCCESS",
	101: "BUILD_PUSH_ACCESS_DENIED",
	102: "BUILD_PROJECT_NOT_FOUND",
	300: "STATUSCHECK_IMAGE_PULL_ERR",
	301: "STATUSCHECK_CONTAINER_CREATING",
	302: "STATUSCHECK_RUN_CONTAINER_ERR",
	303: "STATUSCHECK_CONTAINER_TERMINATED",
	304: "STATUSCHECK_DEPLOYMENT_ROLLOUT_PENDING",
	356: "STATUSCHECK_CONTAINER_RESTARTING",
	357: "STATUSCHECK_UNHEALTHY",
	400: "STATUSCHECK_NODE_MEMORY_PRESSURE",
	401: "STATUSCHECK_NODE_DISK_PRESSURE",
	402: "STATUSCHECK_NODE_NETWORK_UNAVAILABLE",
	403: "STATUSCHECK_NODE_PID_PRESSURE",
	404: "STATUSCHECK_NODE_UNSCHEDULABLE",
	405: "STATUSCHECK_NODE_UNREACHABLE",
	406: "STATUSCHECK_NODE_NOT_READY",
	407: "STATUSCHECK_FAILED_SCHEDULING",
	409: "STATUSCHECK_KUBECTL_CONNECTION_ERR",
	410: "STATUSCHECK_KUBECTL_PID_KILLED",
	411: "STATUSCHECK_KUBECTL_CLIENT_FETCH_ERR",
	412: "STATUSCHECK_DEPLOYMENT_FETCH_ERR",
	451: "STATUSCHECK_POD_INITIALIZING",
	500: "UNKNOWN_ERROR",
	501: "STATUSCHECK_UNKNOWN",
	502: "STATUSCHECK_UNKNOWN_UNSCHEDULABLE",
	503: "STATUSCHECK_CONTAINER_WAITING_UNKNOWN",
	509: "STATUSCHECK_UNKNOWN_EVENT",
	504: "DEPLOY_UNKNOWN",
	505: "SYNC_UNKNOWN",
	506: "BUILD_UNKNOWN",
	507: "DEVINIT_UNKNOWN",
	508: "CLEANUP_UNKNOWN",
	601: "SYNC_INIT_ERROR",
	701: "DEVINIT_REGISTER_BUILD_DEPS",
	702: "DEVINIT_REGISTER_TEST_DEPS",
	703: "DEVINIT_REGISTER_DEPLOY_DEPS",
	704: "DEVINIT_REGISTER_CONFIG_DEP",
	800: "STATUSCHECK_USER_CANCELLED",
	801: "STATUSCHECK_DEADLINE_EXCEEDED",
}

var StatusCode_value = map[string]int32{
	"OK":                                     0,
	"STATUSCHECK_SUCCESS":                    200,
	"BUILD_SUCCESS":                          201,
	"DEPLOY_SUCCESS":                         202,
	"BUILD_PUSH_ACCESS_DENIED":               101,
	"BUILD_PROJECT_NOT_FOUND":                102,
	"STATUSCHECK_IMAGE_PULL_ERR":             300,
	"STATUSCHECK_CONTAINER_CREATING":         301,
	"STATUSCHECK_RUN_CONTAINER_ERR":          302,
	"STATUSCHECK_CONTAINER_TERMINATED":       303,
	"STATUSCHECK_DEPLOYMENT_ROLLOUT_PENDING": 304,
	"STATUSCHECK_CONTAINER_RESTARTING":       356,
	"STATUSCHECK_UNHEALTHY":                  357,
	"STATUSCHECK_NODE_MEMORY_PRESSURE":       400,
	"STATUSCHECK_NODE_DISK_PRESSURE":         401,
	"STATUSCHECK_NODE_NETWORK_UNAVAILABLE":   402,
	"STATUSCHECK_NODE_PID_PRESSURE":          403,
	"STATUSCHECK_NODE_UNSCHEDULABLE":         404,
	"STATUSCHECK_NODE_UNREACHABLE":           405,
	"STATUSCHECK_NODE_NOT_READY":             406,
	"STATUSCHECK_FAILED_SCHEDULING":          407,
	"STATUSCHECK_KUBECTL_CONNECTION_ERR":     409,
	"STATUSCHECK_KUBECTL_PID_KILLED":         410,
	"STATUSCHECK_KUBECTL_CLIENT_FETCH_ERR":   411,
	"STATUSCHECK_DEPLOYMENT_FETCH_ERR":       412,
	"STATUSCHECK_POD_INITIALIZING":           451,
	"UNKNOWN_ERROR":                          500,
	"STATUSCHECK_UNKNOWN":                    501,
	"STATUSCHECK_UNKNOWN_UNSCHEDULABLE":      502,
	"STATUSCHECK_CONTAINER_WAITING_UNKNOWN":  503,
	"STATUSCHECK_UNKNOWN_EVENT":              509,
	"DEPLOY_UNKNOWN":                         504,
	"SYNC_UNKNOWN":                           505,
	"BUILD_UNKNOWN":                          506,
	"DEVINIT_UNKNOWN":                        507,
	"CLEANUP_UNKNOWN":                        508,
	"SYNC_INIT_ERROR":                        601,
	"DEVINIT_REGISTER_BUILD_DEPS":            701,
	"DEVINIT_REGISTER_TEST_DEPS":             702,
	"DEVINIT_REGISTER_DEPLOY_DEPS":           703,
	"DEVINIT_REGISTER_CONFIG_DEP":            704,
	"STATUSCHECK_USER_CANCELLED":             800,
	"STATUSCHECK_DEADLINE_EXCEEDED":          801,
}

func (x StatusCode) String() string {
	return proto.EnumName(StatusCode_name, int32(x))
}

func (StatusCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{4}
}

// Enum for Suggestion codes
type SuggestionCode int32

const (
	// default nil suggestion.
	// This is usually set when no error happens.
	SuggestionCode_NIL SuggestionCode = 0
	// Build error suggestion codes
	SuggestionCode_ADD_DEFAULT_REPO                 SuggestionCode = 100
	SuggestionCode_CHECK_DEFAULT_REPO               SuggestionCode = 101
	SuggestionCode_CHECK_DEFAULT_REPO_GLOBAL_CONFIG SuggestionCode = 102
	SuggestionCode_GCLOUD_DOCKER_AUTH_CONFIGURE     SuggestionCode = 103
	SuggestionCode_DOCKER_AUTH_CONFIGURE            SuggestionCode = 104
	SuggestionCode_CHECK_GCLOUD_PROJECT             SuggestionCode = 105
	// Container run error
	SuggestionCode_CHECK_CONTAINER_LOGS SuggestionCode = 301
	// Pod Health check error
	SuggestionCode_CHECK_READINESS_PROBE SuggestionCode = 302
	// Check Container image
	SuggestionCode_CHECK_CONTAINER_IMAGE SuggestionCode = 303
	// Node pressure error
	SuggestionCode_ADDRESS_NODE_MEMORY_PRESSURE SuggestionCode = 400
	// Node disk pressure error
	SuggestionCode_ADDRESS_NODE_DISK_PRESSURE SuggestionCode = 401
	// Node network unavailable error
	SuggestionCode_ADDRESS_NODE_NETWORK_UNAVAILABLE SuggestionCode = 402
	// Node PID pressure error
	SuggestionCode_ADDRESS_NODE_PID_PRESSURE SuggestionCode = 403
	// Node unschedulable error
	SuggestionCode_ADDRESS_NODE_UNSCHEDULABLE SuggestionCode = 404
	// Node unreachable error
	SuggestionCode_ADDRESS_NODE_UNREACHABLE SuggestionCode = 405
	// Node not ready error
	SuggestionCode_ADDRESS_NODE_NOT_READY SuggestionCode = 406
	// Scheduler failure error
	SuggestionCode_ADDRESS_FAILED_SCHEDULING SuggestionCode = 407
	// Cluster Connectivity error
	SuggestionCode_CHECK_HOST_CONNECTION SuggestionCode = 408
)

var SuggestionCode_name = map[int32]string{
	0:   "NIL",
	100: "ADD_DEFAULT_REPO",
	101: "CHECK_DEFAULT_REPO",
	102: "CHECK_DEFAULT_REPO_GLOBAL_CONFIG",
	103: "GCLOUD_DOCKER_AUTH_CONFIGURE",
	104: "DOCKER_AUTH_CONFIGURE",
	105: "CHECK_GCLOUD_PROJECT",
	301: "CHECK_CONTAINER_LOGS",
	302: "CHECK_READINESS_PROBE",
	303: "CHECK_CONTAINER_IMAGE",
	400: "ADDRESS_NODE_MEMORY_PRESSURE",
	401: "ADDRESS_NODE_DISK_PRESSURE",
	402: "ADDRESS_NODE_NETWORK_UNAVAILABLE",
	403: "ADDRESS_NODE_PID_PRESSURE",
	404: "ADDRESS_NODE_UNSCHEDULABLE",
	405: "ADDRESS_NODE_UNREACHABLE",
	406: "ADDRESS_NODE_NOT_READY",
	407: "ADDRESS_FAILED_SCHEDULING",
	408: "CHECK_HOST_CONNECTION",
}

var SuggestionCode_value = map[string]int32{
	"NIL":                              0,
	"ADD_DEFAULT_REPO":                 100,
	"CHECK_DEFAULT_REPO":               101,
	"CHECK_DEFAULT_REPO_GLOBAL_CONFIG": 102,
	"GCLOUD_DOCKER_AUTH_CONFIGURE":     103,
	"DOCKER_AUTH_CONFIGURE":            104,
	"CHECK_GCLOUD_PROJECT":             105,
	"CHECK_CONTAINER_LOGS":             301,
	"CHECK_READINESS_PROBE":            302,
	"CHECK_CONTAINER_IMAGE":            303,
	"ADDRESS_NODE_MEMORY_PRESSURE":     400,
	"ADDRESS_NODE_DISK_PRESSURE":       401,
	"ADDRESS_NODE_NETWORK_UNAVAILABLE": 402,
	"ADDRESS_NODE_PID_PRESSURE":        403,
	"ADDRESS_NODE_UNSCHEDULABLE":       404,
	"ADDRESS_NODE_UNREACHABLE":         405,
	"ADDRESS_NODE_NOT_READY":           406,
	"ADDRESS_FAILED_SCHEDULING":        407,
	"CHECK_HOST_CONNECTION":            408,
}

func (x SuggestionCode) String() string {
	return proto.EnumName(SuggestionCode_name, int32(x))
}

func (SuggestionCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{5}
}

type StateResponse struct {
	State                *State   `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateResponse) Reset()         { *m = StateResponse{} }
func (m *StateResponse) String() string { return proto.CompactTextString(m) }
func (*StateResponse) ProtoMessage()    {}
func (*StateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{0}
}

func (m *StateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateResponse.Unmarshal(m, b)
}
func (m *StateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateResponse.Marshal(b, m, deterministic)
}
func (m *StateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateResponse.Merge(m, src)
}
func (m *StateResponse) XXX_Size() int {
	return xxx_messageInfo_StateResponse.Size(m)
}
func (m *StateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateResponse proto.InternalMessageInfo

func (m *StateResponse) GetState() *State {
	if m != nil {
		return m.State
	}
	return nil
}

type Response struct {
	Msg                  string   `protobuf:"bytes,1,opt,name=msg,proto3" json:"msg,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Response) Reset()         { *m = Response{} }
func (m *Response) String() string { return proto.CompactTextString(m) }
func (*Response) ProtoMessage()    {}
func (*Response) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{1}
}

func (m *Response) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Response.Unmarshal(m, b)
}
func (m *Response) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Response.Marshal(b, m, deterministic)
}
func (m *Response) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Response.Merge(m, src)
}
func (m *Response) XXX_Size() int {
	return xxx_messageInfo_Response.Size(m)
}
func (m *Response) XXX_DiscardUnknown() {
	xxx_messageInfo_Response.DiscardUnknown(m)
}

var xxx_messageInfo_Response proto.InternalMessageInfo

func (m *Response) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

type Request struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Request) Reset()         { *m = Request{} }
func (m *Request) String() string { return proto.CompactTextString(m) }
func (*Request) ProtoMessage()    {}
func (*Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{2}
}

func (m *Request) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Request.Unmarshal(m, b)
}
func (m *Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Request.Marshal(b, m, deterministic)
}
func (m *Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Request.Merge(m, src)
}
func (m *Request) XXX_Size() int {
	return xxx_messageInfo_Request.Size(m)
}
func (m *Request) XXX_DiscardUnknown() {
	xxx_messageInfo_Request.DiscardUnknown(m)
}

var xxx_messageInfo_Request proto.InternalMessageInfo

func (m *Request) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// `State` represents the current state of the Skaffold components
type State struct {
	BuildState           *BuildState                `protobuf:"bytes,1,opt,name=buildState,proto3" json:"buildState,omitempty"`
	DeployState          *DeployState               `protobuf:"bytes,2,opt,name=deployState,proto3" json:"deployState,omitempty"`
	ForwardedPorts       map[int32]*PortEvent       `protobuf:"bytes,4,rep,name=forwardedPorts,proto3" json:"forwardedPorts,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	StatusCheckState     *StatusCheckState          `protobuf:"bytes,5,opt,name=statusCheckState,proto3" json:"statusCheckState,omitempty"`
	FileSyncState        *FileSyncState             `protobuf:"bytes,6,opt,name=fileSyncState,proto3" json:"fileSyncState,omitempty"`
	DebuggingContainers  []*DebuggingContainerEvent `protobuf:"bytes,7,rep,name=debuggingContainers,proto3" json:"debuggingContainers,omitempty"`
	Metadata             *Metadata                  `protobuf:"bytes,8,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *State) Reset()         { *m = State{} }
func (m *State) String() string { return proto.CompactTextString(m) }
func (*State) ProtoMessage()    {}
func (*State) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{3}
}

func (m *State) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_State.Unmarshal(m, b)
}
func (m *State) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_State.Marshal(b, m, deterministic)
}
func (m *State) XXX_Merge(src proto.Message) {
	xxx_messageInfo_State.Merge(m, src)
}
func (m *State) XXX_Size() int {
	return xxx_messageInfo_State.Size(m)
}
func (m *State) XXX_DiscardUnknown() {
	xxx_messageInfo_State.DiscardUnknown(m)
}

var xxx_messageInfo_State proto.InternalMessageInfo

func (m *State) GetBuildState() *BuildState {
	if m != nil {
		return m.BuildState
	}
	return nil
}

func (m *State) GetDeployState() *DeployState {
	if m != nil {
		return m.DeployState
	}
	return nil
}

func (m *State) GetForwardedPorts() map[int32]*PortEvent {
	if m != nil {
		return m.ForwardedPorts
	}
	return nil
}

func (m *State) GetStatusCheckState() *StatusCheckState {
	if m != nil {
		return m.StatusCheckState
	}
	return nil
}

func (m *State) GetFileSyncState() *FileSyncState {
	if m != nil {
		return m.FileSyncState
	}
	return nil
}

func (m *State) GetDebuggingContainers() []*DebuggingContainerEvent {
	if m != nil {
		return m.DebuggingContainers
	}
	return nil
}

func (m *State) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

type Metadata struct {
	Build  *BuildMetadata  `protobuf:"bytes,1,opt,name=build,proto3" json:"build,omitempty"`
	Deploy *DeployMetadata `protobuf:"bytes,2,opt,name=deploy,proto3" json:"deploy,omitempty"`
	// Additional key value pairs to describe the build pipeline
	Additional           map[string]string `protobuf:"bytes,99,rep,name=additional,proto3" json:"additional,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Metadata) Reset()         { *m = Metadata{} }
func (m *Metadata) String() string { return proto.CompactTextString(m) }
func (*Metadata) ProtoMessage()    {}
func (*Metadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{4}
}

func (m *Metadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metadata.Unmarshal(m, b)
}
func (m *Metadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metadata.Marshal(b, m, deterministic)
}
func (m *Metadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metadata.Merge(m, src)
}
func (m *Metadata) XXX_Size() int {
	return xxx_messageInfo_Metadata.Size(m)
}
func (m *Metadata) XXX_DiscardUnknown() {
	xxx_messageInfo_Metadata.DiscardUnknown(m)
}

var xxx_messageInfo_Metadata proto.InternalMessageInfo

func (m *Metadata) GetBuild() *BuildMetadata {
	if m != nil {
		return m.Build
	}
	return nil
}

func (m *Metadata) GetDeploy() *DeployMetadata {
	if m != nil {
		return m.Deploy
	}
	return nil
}

func (m *Metadata) GetAdditional() map[string]string {
	if m != nil {
		return m.Additional
	}
	return nil
}

type BuildMetadata struct {
	NumberOfArtifacts int32                         `protobuf:"varint,1,opt,name=numberOfArtifacts,proto3" json:"numberOfArtifacts,omitempty"`
	Builders          []*BuildMetadata_ImageBuilder `protobuf:"bytes,2,rep,name=builders,proto3" json:"builders,omitempty"`
	Type              BuildType                     `protobuf:"varint,3,opt,name=type,proto3,enum=proto.BuildType" json:"type,omitempty"`
	// Additional key value pairs to describe the deploy pipeline
	Additional           map[string]string `protobuf:"bytes,99,rep,name=additional,proto3" json:"additional,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *BuildMetadata) Reset()         { *m = BuildMetadata{} }
func (m *BuildMetadata) String() string { return proto.CompactTextString(m) }
func (*BuildMetadata) ProtoMessage()    {}
func (*BuildMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{5}
}

func (m *BuildMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildMetadata.Unmarshal(m, b)
}
func (m *BuildMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildMetadata.Marshal(b, m, deterministic)
}
func (m *BuildMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildMetadata.Merge(m, src)
}
func (m *BuildMetadata) XXX_Size() int {
	return xxx_messageInfo_BuildMetadata.Size(m)
}
func (m *BuildMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_BuildMetadata proto.InternalMessageInfo

func (m *BuildMetadata) GetNumberOfArtifacts() int32 {
	if m != nil {
		return m.NumberOfArtifacts
	}
	return 0
}

func (m *BuildMetadata) GetBuilders() []*BuildMetadata_ImageBuilder {
	if m != nil {
		return m.Builders
	}
	return nil
}

func (m *BuildMetadata) GetType() BuildType {
	if m != nil {
		return m.Type
	}
	return BuildType_UNKNOWN_BUILD_TYPE
}

func (m *BuildMetadata) GetAdditional() map[string]string {
	if m != nil {
		return m.Additional
	}
	return nil
}

type BuildMetadata_ImageBuilder struct {
	Type                 BuilderType `protobuf:"varint,1,opt,name=type,proto3,enum=proto.BuilderType" json:"type,omitempty"`
	Count                int32       `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *BuildMetadata_ImageBuilder) Reset()         { *m = BuildMetadata_ImageBuilder{} }
func (m *BuildMetadata_ImageBuilder) String() string { return proto.CompactTextString(m) }
func (*BuildMetadata_ImageBuilder) ProtoMessage()    {}
func (*BuildMetadata_ImageBuilder) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{5, 0}
}

func (m *BuildMetadata_ImageBuilder) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildMetadata_ImageBuilder.Unmarshal(m, b)
}
func (m *BuildMetadata_ImageBuilder) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildMetadata_ImageBuilder.Marshal(b, m, deterministic)
}
func (m *BuildMetadata_ImageBuilder) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildMetadata_ImageBuilder.Merge(m, src)
}
func (m *BuildMetadata_ImageBuilder) XXX_Size() int {
	return xxx_messageInfo_BuildMetadata_ImageBuilder.Size(m)
}
func (m *BuildMetadata_ImageBuilder) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildMetadata_ImageBuilder.DiscardUnknown(m)
}

var xxx_messageInfo_BuildMetadata_ImageBuilder proto.InternalMessageInfo

func (m *BuildMetadata_ImageBuilder) GetType() BuilderType {
	if m != nil {
		return m.Type
	}
	return BuilderType_UNKNOWN_BUILDER_TYPE
}

func (m *BuildMetadata_ImageBuilder) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

type DeployMetadata struct {
	Deployers            []*DeployMetadata_Deployer `protobuf:"bytes,1,rep,name=deployers,proto3" json:"deployers,omitempty"`
	Cluster              ClusterType                `protobuf:"varint,2,opt,name=cluster,proto3,enum=proto.ClusterType" json:"cluster,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *DeployMetadata) Reset()         { *m = DeployMetadata{} }
func (m *DeployMetadata) String() string { return proto.CompactTextString(m) }
func (*DeployMetadata) ProtoMessage()    {}
func (*DeployMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{6}
}

func (m *DeployMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployMetadata.Unmarshal(m, b)
}
func (m *DeployMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployMetadata.Marshal(b, m, deterministic)
}
func (m *DeployMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployMetadata.Merge(m, src)
}
func (m *DeployMetadata) XXX_Size() int {
	return xxx_messageInfo_DeployMetadata.Size(m)
}
func (m *DeployMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeployMetadata proto.InternalMessageInfo

func (m *DeployMetadata) GetDeployers() []*DeployMetadata_Deployer {
	if m != nil {
		return m.Deployers
	}
	return nil
}

func (m *DeployMetadata) GetCluster() ClusterType {
	if m != nil {
		return m.Cluster
	}
	return ClusterType_UNKNOWN_CLUSTER_TYPE
}

type DeployMetadata_Deployer struct {
	Type                 DeployerType `protobuf:"varint,1,opt,name=type,proto3,enum=proto.DeployerType" json:"type,omitempty"`
	Count                int32        `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *DeployMetadata_Deployer) Reset()         { *m = DeployMetadata_Deployer{} }
func (m *DeployMetadata_Deployer) String() string { return proto.CompactTextString(m) }
func (*DeployMetadata_Deployer) ProtoMessage()    {}
func (*DeployMetadata_Deployer) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{6, 0}
}

func (m *DeployMetadata_Deployer) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployMetadata_Deployer.Unmarshal(m, b)
}
func (m *DeployMetadata_Deployer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployMetadata_Deployer.Marshal(b, m, deterministic)
}
func (m *DeployMetadata_Deployer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployMetadata_Deployer.Merge(m, src)
}
func (m *DeployMetadata_Deployer) XXX_Size() int {
	return xxx_messageInfo_DeployMetadata_Deployer.Size(m)
}
func (m *DeployMetadata_Deployer) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployMetadata_Deployer.DiscardUnknown(m)
}

var xxx_messageInfo_DeployMetadata_Deployer proto.InternalMessageInfo

func (m *DeployMetadata_Deployer) GetType() DeployerType {
	if m != nil {
		return m.Type
	}
	return DeployerType_UNKNOWN_DEPLOYER_TYPE
}

func (m *DeployMetadata_Deployer) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

// `BuildState` maps Skaffold artifacts to their current build states
type BuildState struct {
	// A map of `artifact name -> build-state`.
	// Artifact name is defined in the `skaffold.yaml`.
	// The `build-state` can be: <br>
	// - `"Not started"`: not yet started <br>
	// - `"In progress"`: build started <br>
	// - `"Complete"`: build succeeded <br>
	// - `"Failed"`: build failed
	Artifacts            map[string]string `protobuf:"bytes,1,rep,name=artifacts,proto3" json:"artifacts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	AutoTrigger          bool              `protobuf:"varint,2,opt,name=autoTrigger,proto3" json:"autoTrigger,omitempty"`
	StatusCode           StatusCode        `protobuf:"varint,3,opt,name=statusCode,proto3,enum=proto.StatusCode" json:"statusCode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *BuildState) Reset()         { *m = BuildState{} }
func (m *BuildState) String() string { return proto.CompactTextString(m) }
func (*BuildState) ProtoMessage()    {}
func (*BuildState) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{7}
}

func (m *BuildState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildState.Unmarshal(m, b)
}
func (m *BuildState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildState.Marshal(b, m, deterministic)
}
func (m *BuildState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildState.Merge(m, src)
}
func (m *BuildState) XXX_Size() int {
	return xxx_messageInfo_BuildState.Size(m)
}
func (m *BuildState) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildState.DiscardUnknown(m)
}

var xxx_messageInfo_BuildState proto.InternalMessageInfo

func (m *BuildState) GetArtifacts() map[string]string {
	if m != nil {
		return m.Artifacts
	}
	return nil
}

func (m *BuildState) GetAutoTrigger() bool {
	if m != nil {
		return m.AutoTrigger
	}
	return false
}

func (m *BuildState) GetStatusCode() StatusCode {
	if m != nil {
		return m.StatusCode
	}
	return StatusCode_OK
}

// `DeployState` describes the status of the current deploy
type DeployState struct {
	Status               string     `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	AutoTrigger          bool       `protobuf:"varint,2,opt,name=autoTrigger,proto3" json:"autoTrigger,omitempty"`
	StatusCode           StatusCode `protobuf:"varint,3,opt,name=statusCode,proto3,enum=proto.StatusCode" json:"statusCode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *DeployState) Reset()         { *m = DeployState{} }
func (m *DeployState) String() string { return proto.CompactTextString(m) }
func (*DeployState) ProtoMessage()    {}
func (*DeployState) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{8}
}

func (m *DeployState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployState.Unmarshal(m, b)
}
func (m *DeployState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployState.Marshal(b, m, deterministic)
}
func (m *DeployState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployState.Merge(m, src)
}
func (m *DeployState) XXX_Size() int {
	return xxx_messageInfo_DeployState.Size(m)
}
func (m *DeployState) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployState.DiscardUnknown(m)
}

var xxx_messageInfo_DeployState proto.InternalMessageInfo

func (m *DeployState) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *DeployState) GetAutoTrigger() bool {
	if m != nil {
		return m.AutoTrigger
	}
	return false
}

func (m *DeployState) GetStatusCode() StatusCode {
	if m != nil {
		return m.StatusCode
	}
	return StatusCode_OK
}

// `StatusCheckState` describes the state of status check of current deployed resources.
type StatusCheckState struct {
	Status string `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// A map of `resource name -> status-check-state`. Where `resource-name` is the kubernetes resource name.
	// The `status-check-state` can be <br>
	// - `"Not started"`: indicates that `status-check` has just started. <br>
	// - `"In progress"`: InProgress is sent after every resource check is complete. <br>
	// - `"Succeeded"`:
	// - `"Failed"`:
	Resources map[string]string `protobuf:"bytes,2,rep,name=resources,proto3" json:"resources,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// StatusCheck statusCode
	StatusCode           StatusCode `protobuf:"varint,3,opt,name=statusCode,proto3,enum=proto.StatusCode" json:"statusCode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *StatusCheckState) Reset()         { *m = StatusCheckState{} }
func (m *StatusCheckState) String() string { return proto.CompactTextString(m) }
func (*StatusCheckState) ProtoMessage()    {}
func (*StatusCheckState) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{9}
}

func (m *StatusCheckState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StatusCheckState.Unmarshal(m, b)
}
func (m *StatusCheckState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StatusCheckState.Marshal(b, m, deterministic)
}
func (m *StatusCheckState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatusCheckState.Merge(m, src)
}
func (m *StatusCheckState) XXX_Size() int {
	return xxx_messageInfo_StatusCheckState.Size(m)
}
func (m *StatusCheckState) XXX_DiscardUnknown() {
	xxx_messageInfo_StatusCheckState.DiscardUnknown(m)
}

var xxx_messageInfo_StatusCheckState proto.InternalMessageInfo

func (m *StatusCheckState) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *StatusCheckState) GetResources() map[string]string {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *StatusCheckState) GetStatusCode() StatusCode {
	if m != nil {
		return m.StatusCode
	}
	return StatusCode_OK
}

// `FileSyncState` contains the status of the current file sync
type FileSyncState struct {
	Status               string   `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	AutoTrigger          bool     `protobuf:"varint,2,opt,name=autoTrigger,proto3" json:"autoTrigger,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FileSyncState) Reset()         { *m = FileSyncState{} }
func (m *FileSyncState) String() string { return proto.CompactTextString(m) }
func (*FileSyncState) ProtoMessage()    {}
func (*FileSyncState) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{10}
}

func (m *FileSyncState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FileSyncState.Unmarshal(m, b)
}
func (m *FileSyncState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FileSyncState.Marshal(b, m, deterministic)
}
func (m *FileSyncState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileSyncState.Merge(m, src)
}
func (m *FileSyncState) XXX_Size() int {
	return xxx_messageInfo_FileSyncState.Size(m)
}
func (m *FileSyncState) XXX_DiscardUnknown() {
	xxx_messageInfo_FileSyncState.DiscardUnknown(m)
}

var xxx_messageInfo_FileSyncState proto.InternalMessageInfo

func (m *FileSyncState) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *FileSyncState) GetAutoTrigger() bool {
	if m != nil {
		return m.AutoTrigger
	}
	return false
}

// `Event` describes an event in the Skaffold process.
// It is one of MetaEvent, BuildEvent, DeployEvent, PortEvent, StatusCheckEvent, ResourceStatusCheckEvent, FileSyncEvent, or DebuggingContainerEvent.
type Event struct {
	// Types that are valid to be assigned to EventType:
	//	*Event_MetaEvent
	//	*Event_BuildEvent
	//	*Event_DeployEvent
	//	*Event_PortEvent
	//	*Event_StatusCheckEvent
	//	*Event_ResourceStatusCheckEvent
	//	*Event_FileSyncEvent
	//	*Event_DebuggingContainerEvent
	//	*Event_DevLoopEvent
	EventType            isEvent_EventType `protobuf_oneof:"event_type"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{11}
}

func (m *Event) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Event.Unmarshal(m, b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Event.Marshal(b, m, deterministic)
}
func (m *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(m, src)
}
func (m *Event) XXX_Size() int {
	return xxx_messageInfo_Event.Size(m)
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

type isEvent_EventType interface {
	isEvent_EventType()
}

type Event_MetaEvent struct {
	MetaEvent *MetaEvent `protobuf:"bytes,1,opt,name=metaEvent,proto3,oneof"`
}

type Event_BuildEvent struct {
	BuildEvent *BuildEvent `protobuf:"bytes,2,opt,name=buildEvent,proto3,oneof"`
}

type Event_DeployEvent struct {
	DeployEvent *DeployEvent `protobuf:"bytes,3,opt,name=deployEvent,proto3,oneof"`
}

type Event_PortEvent struct {
	PortEvent *PortEvent `protobuf:"bytes,4,opt,name=portEvent,proto3,oneof"`
}

type Event_StatusCheckEvent struct {
	StatusCheckEvent *StatusCheckEvent `protobuf:"bytes,5,opt,name=statusCheckEvent,proto3,oneof"`
}

type Event_ResourceStatusCheckEvent struct {
	ResourceStatusCheckEvent *ResourceStatusCheckEvent `protobuf:"bytes,6,opt,name=resourceStatusCheckEvent,proto3,oneof"`
}

type Event_FileSyncEvent struct {
	FileSyncEvent *FileSyncEvent `protobuf:"bytes,7,opt,name=fileSyncEvent,proto3,oneof"`
}

type Event_DebuggingContainerEvent struct {
	DebuggingContainerEvent *DebuggingContainerEvent `protobuf:"bytes,8,opt,name=debuggingContainerEvent,proto3,oneof"`
}

type Event_DevLoopEvent struct {
	DevLoopEvent *DevLoopEvent `protobuf:"bytes,9,opt,name=devLoopEvent,proto3,oneof"`
}

func (*Event_MetaEvent) isEvent_EventType() {}

func (*Event_BuildEvent) isEvent_EventType() {}

func (*Event_DeployEvent) isEvent_EventType() {}

func (*Event_PortEvent) isEvent_EventType() {}

func (*Event_StatusCheckEvent) isEvent_EventType() {}

func (*Event_ResourceStatusCheckEvent) isEvent_EventType() {}

func (*Event_FileSyncEvent) isEvent_EventType() {}

func (*Event_DebuggingContainerEvent) isEvent_EventType() {}

func (*Event_DevLoopEvent) isEvent_EventType() {}

func (m *Event) GetEventType() isEvent_EventType {
	if m != nil {
		return m.EventType
	}
	return nil
}

func (m *Event) GetMetaEvent() *MetaEvent {
	if x, ok := m.GetEventType().(*Event_MetaEvent); ok {
		return x.MetaEvent
	}
	return nil
}

func (m *Event) GetBuildEvent() *BuildEvent {
	if x, ok := m.GetEventType().(*Event_BuildEvent); ok {
		return x.BuildEvent
	}
	return nil
}

func (m *Event) GetDeployEvent() *DeployEvent {
	if x, ok := m.GetEventType().(*Event_DeployEvent); ok {
		return x.DeployEvent
	}
	return nil
}

func (m *Event) GetPortEvent() *PortEvent {
	if x, ok := m.GetEventType().(*Event_PortEvent); ok {
		return x.PortEvent
	}
	return nil
}

func (m *Event) GetStatusCheckEvent() *StatusCheckEvent {
	if x, ok := m.GetEventType().(*Event_StatusCheckEvent); ok {
		return x.StatusCheckEvent
	}
	return nil
}

func (m *Event) GetResourceStatusCheckEvent() *ResourceStatusCheckEvent {
	if x, ok := m.GetEventType().(*Event_ResourceStatusCheckEvent); ok {
		return x.ResourceStatusCheckEvent
	}
	return nil
}

func (m *Event) GetFileSyncEvent() *FileSyncEvent {
	if x, ok := m.GetEventType().(*Event_FileSyncEvent); ok {
		return x.FileSyncEvent
	}
	return nil
}

func (m *Event) GetDebuggingContainerEvent() *DebuggingContainerEvent {
	if x, ok := m.GetEventType().(*Event_DebuggingContainerEvent); ok {
		return x.DebuggingContainerEvent
	}
	return nil
}

func (m *Event) GetDevLoopEvent() *DevLoopEvent {
	if x, ok := m.GetEventType().(*Event_DevLoopEvent); ok {
		return x.DevLoopEvent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Event) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Event_MetaEvent)(nil),
		(*Event_BuildEvent)(nil),
		(*Event_DeployEvent)(nil),
		(*Event_PortEvent)(nil),
		(*Event_StatusCheckEvent)(nil),
		(*Event_ResourceStatusCheckEvent)(nil),
		(*Event_FileSyncEvent)(nil),
		(*Event_DebuggingContainerEvent)(nil),
		(*Event_DevLoopEvent)(nil),
	}
}

// `DevLoopEvent` marks the start and end of a dev loop.
type DevLoopEvent struct {
	Iteration            int32          `protobuf:"varint,1,opt,name=iteration,proto3" json:"iteration,omitempty"`
	Status               string         `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	Err                  *ActionableErr `protobuf:"bytes,3,opt,name=err,proto3" json:"err,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *DevLoopEvent) Reset()         { *m = DevLoopEvent{} }
func (m *DevLoopEvent) String() string { return proto.CompactTextString(m) }
func (*DevLoopEvent) ProtoMessage()    {}
func (*DevLoopEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{12}
}

func (m *DevLoopEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DevLoopEvent.Unmarshal(m, b)
}
func (m *DevLoopEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DevLoopEvent.Marshal(b, m, deterministic)
}
func (m *DevLoopEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DevLoopEvent.Merge(m, src)
}
func (m *DevLoopEvent) XXX_Size() int {
	return xxx_messageInfo_DevLoopEvent.Size(m)
}
func (m *DevLoopEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_DevLoopEvent.DiscardUnknown(m)
}

var xxx_messageInfo_DevLoopEvent proto.InternalMessageInfo

func (m *DevLoopEvent) GetIteration() int32 {
	if m != nil {
		return m.Iteration
	}
	return 0
}

func (m *DevLoopEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *DevLoopEvent) GetErr() *ActionableErr {
	if m != nil {
		return m.Err
	}
	return nil
}

// `ActionableErr` defines an error that occurred along with an optional list of suggestions
type ActionableErr struct {
	ErrCode              StatusCode    `protobuf:"varint,1,opt,name=errCode,proto3,enum=proto.StatusCode" json:"errCode,omitempty"`
	Message              string        `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	Suggestions          []*Suggestion `protobuf:"bytes,3,rep,name=suggestions,proto3" json:"suggestions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ActionableErr) Reset()         { *m = ActionableErr{} }
func (m *ActionableErr) String() string { return proto.CompactTextString(m) }
func (*ActionableErr) ProtoMessage()    {}
func (*ActionableErr) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{13}
}

func (m *ActionableErr) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ActionableErr.Unmarshal(m, b)
}
func (m *ActionableErr) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ActionableErr.Marshal(b, m, deterministic)
}
func (m *ActionableErr) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActionableErr.Merge(m, src)
}
func (m *ActionableErr) XXX_Size() int {
	return xxx_messageInfo_ActionableErr.Size(m)
}
func (m *ActionableErr) XXX_DiscardUnknown() {
	xxx_messageInfo_ActionableErr.DiscardUnknown(m)
}

var xxx_messageInfo_ActionableErr proto.InternalMessageInfo

func (m *ActionableErr) GetErrCode() StatusCode {
	if m != nil {
		return m.ErrCode
	}
	return StatusCode_OK
}

func (m *ActionableErr) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *ActionableErr) GetSuggestions() []*Suggestion {
	if m != nil {
		return m.Suggestions
	}
	return nil
}

// `MetaEvent` provides general information regarding Skaffold
type MetaEvent struct {
	// entry, for example: `"Starting Skaffold: {Version:v0.39.0-16-g5bb7c9e0 ConfigVersion:skaffold/v1 GitVersion: GitCommit:5bb7c9e078e4d522a5ffc42a2f1274fd17d75902 GitTreeState:dirty BuildDate01:29Z GoVersion:go1.13rc1 Compiler:gc Platform:linux/amd64}"`
	Entry string `protobuf:"bytes,1,opt,name=entry,proto3" json:"entry,omitempty"`
	// Metadata describing skaffold pipeline
	Metadata             *Metadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *MetaEvent) Reset()         { *m = MetaEvent{} }
func (m *MetaEvent) String() string { return proto.CompactTextString(m) }
func (*MetaEvent) ProtoMessage()    {}
func (*MetaEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{14}
}

func (m *MetaEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetaEvent.Unmarshal(m, b)
}
func (m *MetaEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetaEvent.Marshal(b, m, deterministic)
}
func (m *MetaEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetaEvent.Merge(m, src)
}
func (m *MetaEvent) XXX_Size() int {
	return xxx_messageInfo_MetaEvent.Size(m)
}
func (m *MetaEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_MetaEvent.DiscardUnknown(m)
}

var xxx_messageInfo_MetaEvent proto.InternalMessageInfo

func (m *MetaEvent) GetEntry() string {
	if m != nil {
		return m.Entry
	}
	return ""
}

func (m *MetaEvent) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// `BuildEvent` describes the build status per artifact, and will be emitted by Skaffold anytime a build starts or finishes, successfully or not.
// If the build fails, an error will be attached to the event.
type BuildEvent struct {
	Artifact             string         `protobuf:"bytes,1,opt,name=artifact,proto3" json:"artifact,omitempty"`
	Status               string         `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	Err                  string         `protobuf:"bytes,3,opt,name=err,proto3" json:"err,omitempty"`
	ErrCode              StatusCode     `protobuf:"varint,4,opt,name=errCode,proto3,enum=proto.StatusCode" json:"errCode,omitempty"`
	ActionableErr        *ActionableErr `protobuf:"bytes,5,opt,name=actionableErr,proto3" json:"actionableErr,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *BuildEvent) Reset()         { *m = BuildEvent{} }
func (m *BuildEvent) String() string { return proto.CompactTextString(m) }
func (*BuildEvent) ProtoMessage()    {}
func (*BuildEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{15}
}

func (m *BuildEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildEvent.Unmarshal(m, b)
}
func (m *BuildEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildEvent.Marshal(b, m, deterministic)
}
func (m *BuildEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildEvent.Merge(m, src)
}
func (m *BuildEvent) XXX_Size() int {
	return xxx_messageInfo_BuildEvent.Size(m)
}
func (m *BuildEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildEvent.DiscardUnknown(m)
}

var xxx_messageInfo_BuildEvent proto.InternalMessageInfo

func (m *BuildEvent) GetArtifact() string {
	if m != nil {
		return m.Artifact
	}
	return ""
}

func (m *BuildEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *BuildEvent) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

func (m *BuildEvent) GetErrCode() StatusCode {
	if m != nil {
		return m.ErrCode
	}
	return StatusCode_OK
}

func (m *BuildEvent) GetActionableErr() *ActionableErr {
	if m != nil {
		return m.ActionableErr
	}
	return nil
}

// `DeployEvent` represents the status of a deployment, and is emitted by Skaffold
// anytime a deployment starts or completes, successfully or not.
type DeployEvent struct {
	Status               string         `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	Err                  string         `protobuf:"bytes,2,opt,name=err,proto3" json:"err,omitempty"`
	ErrCode              StatusCode     `protobuf:"varint,3,opt,name=errCode,proto3,enum=proto.StatusCode" json:"errCode,omitempty"`
	ActionableErr        *ActionableErr `protobuf:"bytes,4,opt,name=actionableErr,proto3" json:"actionableErr,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *DeployEvent) Reset()         { *m = DeployEvent{} }
func (m *DeployEvent) String() string { return proto.CompactTextString(m) }
func (*DeployEvent) ProtoMessage()    {}
func (*DeployEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{16}
}

func (m *DeployEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployEvent.Unmarshal(m, b)
}
func (m *DeployEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployEvent.Marshal(b, m, deterministic)
}
func (m *DeployEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployEvent.Merge(m, src)
}
func (m *DeployEvent) XXX_Size() int {
	return xxx_messageInfo_DeployEvent.Size(m)
}
func (m *DeployEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployEvent.DiscardUnknown(m)
}

var xxx_messageInfo_DeployEvent proto.InternalMessageInfo

func (m *DeployEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *DeployEvent) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

func (m *DeployEvent) GetErrCode() StatusCode {
	if m != nil {
		return m.ErrCode
	}
	return StatusCode_OK
}

func (m *DeployEvent) GetActionableErr() *ActionableErr {
	if m != nil {
		return m.ActionableErr
	}
	return nil
}

// `StatusCheckEvent` describes if the status check for kubernetes rollout has started, is in progress, has succeeded or failed.
type StatusCheckEvent struct {
	Status               string         `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	Message              string         `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	Err                  string         `protobuf:"bytes,3,opt,name=err,proto3" json:"err,omitempty"`
	ErrCode              StatusCode     `protobuf:"varint,4,opt,name=errCode,proto3,enum=proto.StatusCode" json:"errCode,omitempty"`
	ActionableErr        *ActionableErr `protobuf:"bytes,5,opt,name=actionableErr,proto3" json:"actionableErr,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *StatusCheckEvent) Reset()         { *m = StatusCheckEvent{} }
func (m *StatusCheckEvent) String() string { return proto.CompactTextString(m) }
func (*StatusCheckEvent) ProtoMessage()    {}
func (*StatusCheckEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{17}
}

func (m *StatusCheckEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StatusCheckEvent.Unmarshal(m, b)
}
func (m *StatusCheckEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StatusCheckEvent.Marshal(b, m, deterministic)
}
func (m *StatusCheckEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatusCheckEvent.Merge(m, src)
}
func (m *StatusCheckEvent) XXX_Size() int {
	return xxx_messageInfo_StatusCheckEvent.Size(m)
}
func (m *StatusCheckEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_StatusCheckEvent.DiscardUnknown(m)
}

var xxx_messageInfo_StatusCheckEvent proto.InternalMessageInfo

func (m *StatusCheckEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *StatusCheckEvent) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *StatusCheckEvent) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

func (m *StatusCheckEvent) GetErrCode() StatusCode {
	if m != nil {
		return m.ErrCode
	}
	return StatusCode_OK
}

func (m *StatusCheckEvent) GetActionableErr() *ActionableErr {
	if m != nil {
		return m.ActionableErr
	}
	return nil
}

// A Resource StatusCheck Event, indicates progress for each kubernetes deployment.
// For every resource, there will be exactly one event with `status` *Succeeded* or *Failed* event.
// There can be multiple events with `status` *Pending*.
// Skaffold polls for resource status every 0.5 second. If the resource status changes, an event with `status` “Pending”, “Complete” and “Failed”
// will be sent with the new status.
type ResourceStatusCheckEvent struct {
	Resource             string         `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	Status               string         `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	Message              string         `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	Err                  string         `protobuf:"bytes,4,opt,name=err,proto3" json:"err,omitempty"`
	StatusCode           StatusCode     `protobuf:"varint,5,opt,name=statusCode,proto3,enum=proto.StatusCode" json:"statusCode,omitempty"`
	ActionableErr        *ActionableErr `protobuf:"bytes,6,opt,name=actionableErr,proto3" json:"actionableErr,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ResourceStatusCheckEvent) Reset()         { *m = ResourceStatusCheckEvent{} }
func (m *ResourceStatusCheckEvent) String() string { return proto.CompactTextString(m) }
func (*ResourceStatusCheckEvent) ProtoMessage()    {}
func (*ResourceStatusCheckEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{18}
}

func (m *ResourceStatusCheckEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResourceStatusCheckEvent.Unmarshal(m, b)
}
func (m *ResourceStatusCheckEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResourceStatusCheckEvent.Marshal(b, m, deterministic)
}
func (m *ResourceStatusCheckEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceStatusCheckEvent.Merge(m, src)
}
func (m *ResourceStatusCheckEvent) XXX_Size() int {
	return xxx_messageInfo_ResourceStatusCheckEvent.Size(m)
}
func (m *ResourceStatusCheckEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceStatusCheckEvent.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceStatusCheckEvent proto.InternalMessageInfo

func (m *ResourceStatusCheckEvent) GetResource() string {
	if m != nil {
		return m.Resource
	}
	return ""
}

func (m *ResourceStatusCheckEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *ResourceStatusCheckEvent) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *ResourceStatusCheckEvent) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

func (m *ResourceStatusCheckEvent) GetStatusCode() StatusCode {
	if m != nil {
		return m.StatusCode
	}
	return StatusCode_OK
}

func (m *ResourceStatusCheckEvent) GetActionableErr() *ActionableErr {
	if m != nil {
		return m.ActionableErr
	}
	return nil
}

// PortEvent Event describes each port forwarding event.
type PortEvent struct {
	LocalPort            int32    `protobuf:"varint,1,opt,name=localPort,proto3" json:"localPort,omitempty"`
	RemotePort           int32    `protobuf:"varint,2,opt,name=remotePort,proto3" json:"remotePort,omitempty"`
	PodName              string   `protobuf:"bytes,3,opt,name=podName,proto3" json:"podName,omitempty"`
	ContainerName        string   `protobuf:"bytes,4,opt,name=containerName,proto3" json:"containerName,omitempty"`
	Namespace            string   `protobuf:"bytes,5,opt,name=namespace,proto3" json:"namespace,omitempty"`
	PortName             string   `protobuf:"bytes,6,opt,name=portName,proto3" json:"portName,omitempty"`
	ResourceType         string   `protobuf:"bytes,7,opt,name=resourceType,proto3" json:"resourceType,omitempty"`
	ResourceName         string   `protobuf:"bytes,8,opt,name=resourceName,proto3" json:"resourceName,omitempty"`
	Address              string   `protobuf:"bytes,9,opt,name=address,proto3" json:"address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PortEvent) Reset()         { *m = PortEvent{} }
func (m *PortEvent) String() string { return proto.CompactTextString(m) }
func (*PortEvent) ProtoMessage()    {}
func (*PortEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{19}
}

func (m *PortEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PortEvent.Unmarshal(m, b)
}
func (m *PortEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PortEvent.Marshal(b, m, deterministic)
}
func (m *PortEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PortEvent.Merge(m, src)
}
func (m *PortEvent) XXX_Size() int {
	return xxx_messageInfo_PortEvent.Size(m)
}
func (m *PortEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_PortEvent.DiscardUnknown(m)
}

var xxx_messageInfo_PortEvent proto.InternalMessageInfo

func (m *PortEvent) GetLocalPort() int32 {
	if m != nil {
		return m.LocalPort
	}
	return 0
}

func (m *PortEvent) GetRemotePort() int32 {
	if m != nil {
		return m.RemotePort
	}
	return 0
}

func (m *PortEvent) GetPodName() string {
	if m != nil {
		return m.PodName
	}
	return ""
}

func (m *PortEvent) GetContainerName() string {
	if m != nil {
		return m.ContainerName
	}
	return ""
}

func (m *PortEvent) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *PortEvent) GetPortName() string {
	if m != nil {
		return m.PortName
	}
	return ""
}

func (m *PortEvent) GetResourceType() string {
	if m != nil {
		return m.ResourceType
	}
	return ""
}

func (m *PortEvent) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *PortEvent) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

// FileSyncEvent describes the sync status.
type FileSyncEvent struct {
	FileCount            int32          `protobuf:"varint,1,opt,name=fileCount,proto3" json:"fileCount,omitempty"`
	Image                string         `protobuf:"bytes,2,opt,name=image,proto3" json:"image,omitempty"`
	Status               string         `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	Err                  string         `protobuf:"bytes,4,opt,name=err,proto3" json:"err,omitempty"`
	ErrCode              StatusCode     `protobuf:"varint,5,opt,name=errCode,proto3,enum=proto.StatusCode" json:"errCode,omitempty"`
	ActionableErr        *ActionableErr `protobuf:"bytes,6,opt,name=actionableErr,proto3" json:"actionableErr,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *FileSyncEvent) Reset()         { *m = FileSyncEvent{} }
func (m *FileSyncEvent) String() string { return proto.CompactTextString(m) }
func (*FileSyncEvent) ProtoMessage()    {}
func (*FileSyncEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{20}
}

func (m *FileSyncEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FileSyncEvent.Unmarshal(m, b)
}
func (m *FileSyncEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FileSyncEvent.Marshal(b, m, deterministic)
}
func (m *FileSyncEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileSyncEvent.Merge(m, src)
}
func (m *FileSyncEvent) XXX_Size() int {
	return xxx_messageInfo_FileSyncEvent.Size(m)
}
func (m *FileSyncEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_FileSyncEvent.DiscardUnknown(m)
}

var xxx_messageInfo_FileSyncEvent proto.InternalMessageInfo

func (m *FileSyncEvent) GetFileCount() int32 {
	if m != nil {
		return m.FileCount
	}
	return 0
}

func (m *FileSyncEvent) GetImage() string {
	if m != nil {
		return m.Image
	}
	return ""
}

func (m *FileSyncEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *FileSyncEvent) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

func (m *FileSyncEvent) GetErrCode() StatusCode {
	if m != nil {
		return m.ErrCode
	}
	return StatusCode_OK
}

func (m *FileSyncEvent) GetActionableErr() *ActionableErr {
	if m != nil {
		return m.ActionableErr
	}
	return nil
}

// DebuggingContainerEvent is raised when a debugging container is started or terminated
type DebuggingContainerEvent struct {
	Status               string            `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	PodName              string            `protobuf:"bytes,2,opt,name=podName,proto3" json:"podName,omitempty"`
	ContainerName        string            `protobuf:"bytes,3,opt,name=containerName,proto3" json:"containerName,omitempty"`
	Namespace            string            `protobuf:"bytes,4,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Artifact             string            `protobuf:"bytes,5,opt,name=artifact,proto3" json:"artifact,omitempty"`
	Runtime              string            `protobuf:"bytes,6,opt,name=runtime,proto3" json:"runtime,omitempty"`
	WorkingDir           string            `protobuf:"bytes,7,opt,name=workingDir,proto3" json:"workingDir,omitempty"`
	DebugPorts           map[string]uint32 `protobuf:"bytes,8,rep,name=debugPorts,proto3" json:"debugPorts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *DebuggingContainerEvent) Reset()         { *m = DebuggingContainerEvent{} }
func (m *DebuggingContainerEvent) String() string { return proto.CompactTextString(m) }
func (*DebuggingContainerEvent) ProtoMessage()    {}
func (*DebuggingContainerEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{21}
}

func (m *DebuggingContainerEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DebuggingContainerEvent.Unmarshal(m, b)
}
func (m *DebuggingContainerEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DebuggingContainerEvent.Marshal(b, m, deterministic)
}
func (m *DebuggingContainerEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebuggingContainerEvent.Merge(m, src)
}
func (m *DebuggingContainerEvent) XXX_Size() int {
	return xxx_messageInfo_DebuggingContainerEvent.Size(m)
}
func (m *DebuggingContainerEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_DebuggingContainerEvent.DiscardUnknown(m)
}

var xxx_messageInfo_DebuggingContainerEvent proto.InternalMessageInfo

func (m *DebuggingContainerEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *DebuggingContainerEvent) GetPodName() string {
	if m != nil {
		return m.PodName
	}
	return ""
}

func (m *DebuggingContainerEvent) GetContainerName() string {
	if m != nil {
		return m.ContainerName
	}
	return ""
}

func (m *DebuggingContainerEvent) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *DebuggingContainerEvent) GetArtifact() string {
	if m != nil {
		return m.Artifact
	}
	return ""
}

func (m *DebuggingContainerEvent) GetRuntime() string {
	if m != nil {
		return m.Runtime
	}
	return ""
}

func (m *DebuggingContainerEvent) GetWorkingDir() string {
	if m != nil {
		return m.WorkingDir
	}
	return ""
}

func (m *DebuggingContainerEvent) GetDebugPorts() map[string]uint32 {
	if m != nil {
		return m.DebugPorts
	}
	return nil
}

// LogEntry describes an event and a string description of the event.
type LogEntry struct {
	Timestamp            *timestamp.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Event                *Event               `protobuf:"bytes,2,opt,name=event,proto3" json:"event,omitempty"`
	Entry                string               `protobuf:"bytes,3,opt,name=entry,proto3" json:"entry,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *LogEntry) Reset()         { *m = LogEntry{} }
func (m *LogEntry) String() string { return proto.CompactTextString(m) }
func (*LogEntry) ProtoMessage()    {}
func (*LogEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{22}
}

func (m *LogEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry.Unmarshal(m, b)
}
func (m *LogEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry.Marshal(b, m, deterministic)
}
func (m *LogEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry.Merge(m, src)
}
func (m *LogEntry) XXX_Size() int {
	return xxx_messageInfo_LogEntry.Size(m)
}
func (m *LogEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry proto.InternalMessageInfo

func (m *LogEntry) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *LogEntry) GetEvent() *Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *LogEntry) GetEntry() string {
	if m != nil {
		return m.Entry
	}
	return ""
}

type UserIntentRequest struct {
	Intent               *Intent  `protobuf:"bytes,1,opt,name=intent,proto3" json:"intent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UserIntentRequest) Reset()         { *m = UserIntentRequest{} }
func (m *UserIntentRequest) String() string { return proto.CompactTextString(m) }
func (*UserIntentRequest) ProtoMessage()    {}
func (*UserIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{23}
}

func (m *UserIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserIntentRequest.Unmarshal(m, b)
}
func (m *UserIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserIntentRequest.Marshal(b, m, deterministic)
}
func (m *UserIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserIntentRequest.Merge(m, src)
}
func (m *UserIntentRequest) XXX_Size() int {
	return xxx_messageInfo_UserIntentRequest.Size(m)
}
func (m *UserIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UserIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UserIntentRequest proto.InternalMessageInfo

func (m *UserIntentRequest) GetIntent() *Intent {
	if m != nil {
		return m.Intent
	}
	return nil
}

type TriggerRequest struct {
	State                *TriggerState `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *TriggerRequest) Reset()         { *m = TriggerRequest{} }
func (m *TriggerRequest) String() string { return proto.CompactTextString(m) }
func (*TriggerRequest) ProtoMessage()    {}
func (*TriggerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{24}
}

func (m *TriggerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TriggerRequest.Unmarshal(m, b)
}
func (m *TriggerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TriggerRequest.Marshal(b, m, deterministic)
}
func (m *TriggerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TriggerRequest.Merge(m, src)
}
func (m *TriggerRequest) XXX_Size() int {
	return xxx_messageInfo_TriggerRequest.Size(m)
}
func (m *TriggerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TriggerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TriggerRequest proto.InternalMessageInfo

func (m *TriggerRequest) GetState() *TriggerState {
	if m != nil {
		return m.State
	}
	return nil
}

// TriggerState represents trigger state for a given phase.
type TriggerState struct {
	// Types that are valid to be assigned to Val:
	//	*TriggerState_Enabled
	Val                  isTriggerState_Val `protobuf_oneof:"val"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *TriggerState) Reset()         { *m = TriggerState{} }
func (m *TriggerState) String() string { return proto.CompactTextString(m) }
func (*TriggerState) ProtoMessage()    {}
func (*TriggerState) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{25}
}

func (m *TriggerState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TriggerState.Unmarshal(m, b)
}
func (m *TriggerState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TriggerState.Marshal(b, m, deterministic)
}
func (m *TriggerState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TriggerState.Merge(m, src)
}
func (m *TriggerState) XXX_Size() int {
	return xxx_messageInfo_TriggerState.Size(m)
}
func (m *TriggerState) XXX_DiscardUnknown() {
	xxx_messageInfo_TriggerState.DiscardUnknown(m)
}

var xxx_messageInfo_TriggerState proto.InternalMessageInfo

type isTriggerState_Val interface {
	isTriggerState_Val()
}

type TriggerState_Enabled struct {
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3,oneof"`
}

func (*TriggerState_Enabled) isTriggerState_Val() {}

func (m *TriggerState) GetVal() isTriggerState_Val {
	if m != nil {
		return m.Val
	}
	return nil
}

func (m *TriggerState) GetEnabled() bool {
	if x, ok := m.GetVal().(*TriggerState_Enabled); ok {
		return x.Enabled
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*TriggerState) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*TriggerState_Enabled)(nil),
	}
}

// Intent represents user intents for a given phase.
type Intent struct {
	Build                bool     `protobuf:"varint,1,opt,name=build,proto3" json:"build,omitempty"`
	Sync                 bool     `protobuf:"varint,2,opt,name=sync,proto3" json:"sync,omitempty"`
	Deploy               bool     `protobuf:"varint,3,opt,name=deploy,proto3" json:"deploy,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent) Reset()         { *m = Intent{} }
func (m *Intent) String() string { return proto.CompactTextString(m) }
func (*Intent) ProtoMessage()    {}
func (*Intent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{26}
}

func (m *Intent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent.Unmarshal(m, b)
}
func (m *Intent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent.Marshal(b, m, deterministic)
}
func (m *Intent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent.Merge(m, src)
}
func (m *Intent) XXX_Size() int {
	return xxx_messageInfo_Intent.Size(m)
}
func (m *Intent) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent.DiscardUnknown(m)
}

var xxx_messageInfo_Intent proto.InternalMessageInfo

func (m *Intent) GetBuild() bool {
	if m != nil {
		return m.Build
	}
	return false
}

func (m *Intent) GetSync() bool {
	if m != nil {
		return m.Sync
	}
	return false
}

func (m *Intent) GetDeploy() bool {
	if m != nil {
		return m.Deploy
	}
	return false
}

// Suggestion defines the action a user needs to recover from an error.
type Suggestion struct {
	SuggestionCode       SuggestionCode `protobuf:"varint,1,opt,name=suggestionCode,proto3,enum=proto.SuggestionCode" json:"suggestionCode,omitempty"`
	Action               string         `protobuf:"bytes,2,opt,name=action,proto3" json:"action,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Suggestion) Reset()         { *m = Suggestion{} }
func (m *Suggestion) String() string { return proto.CompactTextString(m) }
func (*Suggestion) ProtoMessage()    {}
func (*Suggestion) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{27}
}

func (m *Suggestion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Suggestion.Unmarshal(m, b)
}
func (m *Suggestion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Suggestion.Marshal(b, m, deterministic)
}
func (m *Suggestion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Suggestion.Merge(m, src)
}
func (m *Suggestion) XXX_Size() int {
	return xxx_messageInfo_Suggestion.Size(m)
}
func (m *Suggestion) XXX_DiscardUnknown() {
	xxx_messageInfo_Suggestion.DiscardUnknown(m)
}

var xxx_messageInfo_Suggestion proto.InternalMessageInfo

func (m *Suggestion) GetSuggestionCode() SuggestionCode {
	if m != nil {
		return m.SuggestionCode
	}
	return SuggestionCode_NIL
}

func (m *Suggestion) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

func init() {
	proto.RegisterEnum("proto.BuilderType", BuilderType_name, BuilderType_value)
	proto.RegisterEnum("proto.BuildType", BuildType_name, BuildType_value)
	proto.RegisterEnum("proto.DeployerType", DeployerType_name, DeployerType_value)
	proto.RegisterEnum("proto.ClusterType", ClusterType_name, ClusterType_value)
	proto.RegisterEnum("proto.StatusCode", StatusCode_name, StatusCode_value)
	proto.RegisterEnum("proto.SuggestionCode", SuggestionCode_name, SuggestionCode_value)
	proto.RegisterType((*StateResponse)(nil), "proto.StateResponse")
	proto.RegisterType((*Response)(nil), "proto.Response")
	proto.RegisterType((*Request)(nil), "proto.Request")
	proto.RegisterType((*State)(nil), "proto.State")
	proto.RegisterMapType((map[int32]*PortEvent)(nil), "proto.State.ForwardedPortsEntry")
	proto.RegisterType((*Metadata)(nil), "proto.Metadata")
	proto.RegisterMapType((map[string]string)(nil), "proto.Metadata.AdditionalEntry")
	proto.RegisterType((*BuildMetadata)(nil), "proto.BuildMetadata")
	proto.RegisterMapType((map[string]string)(nil), "proto.BuildMetadata.AdditionalEntry")
	proto.RegisterType((*BuildMetadata_ImageBuilder)(nil), "proto.BuildMetadata.ImageBuilder")
	proto.RegisterType((*DeployMetadata)(nil), "proto.DeployMetadata")
	proto.RegisterType((*DeployMetadata_Deployer)(nil), "proto.DeployMetadata.Deployer")
	proto.RegisterType((*BuildState)(nil), "proto.BuildState")
	proto.RegisterMapType((map[string]string)(nil), "proto.BuildState.ArtifactsEntry")
	proto.RegisterType((*DeployState)(nil), "proto.DeployState")
	proto.RegisterType((*StatusCheckState)(nil), "proto.StatusCheckState")
	proto.RegisterMapType((map[string]string)(nil), "proto.StatusCheckState.ResourcesEntry")
	proto.RegisterType((*FileSyncState)(nil), "proto.FileSyncState")
	proto.RegisterType((*Event)(nil), "proto.Event")
	proto.RegisterType((*DevLoopEvent)(nil), "proto.DevLoopEvent")
	proto.RegisterType((*ActionableErr)(nil), "proto.ActionableErr")
	proto.RegisterType((*MetaEvent)(nil), "proto.MetaEvent")
	proto.RegisterType((*BuildEvent)(nil), "proto.BuildEvent")
	proto.RegisterType((*DeployEvent)(nil), "proto.DeployEvent")
	proto.RegisterType((*StatusCheckEvent)(nil), "proto.StatusCheckEvent")
	proto.RegisterType((*ResourceStatusCheckEvent)(nil), "proto.ResourceStatusCheckEvent")
	proto.RegisterType((*PortEvent)(nil), "proto.PortEvent")
	proto.RegisterType((*FileSyncEvent)(nil), "proto.FileSyncEvent")
	proto.RegisterType((*DebuggingContainerEvent)(nil), "proto.DebuggingContainerEvent")
	proto.RegisterMapType((map[string]uint32)(nil), "proto.DebuggingContainerEvent.DebugPortsEntry")
	proto.RegisterType((*LogEntry)(nil), "proto.LogEntry")
	proto.RegisterType((*UserIntentRequest)(nil), "proto.UserIntentRequest")
	proto.RegisterType((*TriggerRequest)(nil), "proto.TriggerRequest")
	proto.RegisterType((*TriggerState)(nil), "proto.TriggerState")
	proto.RegisterType((*Intent)(nil), "proto.Intent")
	proto.RegisterType((*Suggestion)(nil), "proto.Suggestion")
}

func init() { proto.RegisterFile("skaffold.proto", fileDescriptor_4f2d38e344f9dbf5) }

var fileDescriptor_4f2d38e344f9dbf5 = []byte{
	// 2866 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x59, 0x4b, 0x8c, 0xdb, 0xc6,
	0x19, 0x5e, 0x89, 0x92, 0x56, 0xfa, 0xf7, 0x61, 0x7a, 0xec, 0xb5, 0x65, 0x79, 0x63, 0xaf, 0x59,
	0xdb, 0x71, 0x36, 0xe9, 0x3a, 0x89, 0x8b, 0x22, 0x75, 0x93, 0x16, 0x5c, 0x72, 0xbc, 0xa2, 0x97,
	0x4b, 0x0a, 0x14, 0x95, 0xc4, 0x06, 0x0a, 0x81, 0x96, 0xb8, 0x8a, 0x60, 0xad, 0xb8, 0xa5, 0x28,
	0xa7, 0xdb, 0x43, 0x0f, 0xbd, 0xf6, 0xd2, 0x36, 0x4d, 0xdf, 0x87, 0xf4, 0xd0, 0x5b, 0x5f, 0xd7,
	0x22, 0x68, 0x53, 0xa0, 0x87, 0x3e, 0xae, 0x05, 0x0a, 0xf4, 0x54, 0x04, 0x48, 0x0e, 0x45, 0xaf,
	0x49, 0xdf, 0x05, 0x8a, 0x79, 0x90, 0x1c, 0xea, 0xe1, 0x8d, 0x53, 0x14, 0x3d, 0xad, 0xe6, 0x9f,
	0xef, 0x7f, 0xce, 0x3f, 0xff, 0xff, 0x73, 0x16, 0x56, 0x47, 0xf7, 0xbd, 0xfd, 0xfd, 0x60, 0xd0,
	0xdd, 0x3a, 0x0c, 0x83, 0x28, 0x40, 0x45, 0xfa, 0xa7, 0xb6, 0xde, 0x0b, 0x82, 0xde, 0xc0, 0xbf,
	0xee, 0x1d, 0xf6, 0xaf, 0x7b, 0xc3, 0x61, 0x10, 0x79, 0x51, 0x3f, 0x18, 0x8e, 0x18, 0xa8, 0x76,
	0x91, 0xef, 0xd2, 0xd5, 0xbd, 0xf1, 0xfe, 0xf5, 0xa8, 0x7f, 0xe0, 0x8f, 0x22, 0xef, 0xe0, 0x90,
	0x03, 0xce, 0x4f, 0x02, 0xfc, 0x83, 0xc3, 0xe8, 0x88, 0x6d, 0x2a, 0x37, 0x60, 0xa5, 0x19, 0x79,
	0x91, 0xef, 0xf8, 0xa3, 0xc3, 0x60, 0x38, 0xf2, 0x91, 0x02, 0xc5, 0x11, 0x21, 0x54, 0x73, 0x1b,
	0xb9, 0x6b, 0x4b, 0xcf, 0x2e, 0x33, 0xdc, 0x16, 0x03, 0xb1, 0x2d, 0x65, 0x1d, 0xca, 0x09, 0x5e,
	0x06, 0xe9, 0x60, 0xd4, 0xa3, 0xe8, 0x8a, 0x43, 0x7e, 0x2a, 0x8f, 0xc1, 0xa2, 0xe3, 0x7f, 0x76,
	0xec, 0x8f, 0x22, 0x84, 0xa0, 0x30, 0xf4, 0x0e, 0x7c, 0xbe, 0x4b, 0x7f, 0x2b, 0xaf, 0x17, 0xa0,
	0x48, 0xa5, 0xa1, 0x67, 0x00, 0xee, 0x8d, 0xfb, 0x83, 0x6e, 0x53, 0xd0, 0x77, 0x92, 0xeb, 0xdb,
	0x4e, 0x36, 0x1c, 0x01, 0x84, 0x3e, 0x06, 0x4b, 0x5d, 0xff, 0x70, 0x10, 0x1c, 0x31, 0x9e, 0x3c,
	0xe5, 0x41, 0x9c, 0x47, 0x4f, 0x77, 0x1c, 0x11, 0x86, 0xea, 0xb0, 0xba, 0x1f, 0x84, 0xaf, 0x7a,
	0x61, 0xd7, 0xef, 0x36, 0x82, 0x30, 0x1a, 0x55, 0x0b, 0x1b, 0xd2, 0xb5, 0xa5, 0x67, 0x37, 0x44,
	0xe7, 0xb6, 0x6e, 0x65, 0x20, 0x78, 0x18, 0x85, 0x47, 0xce, 0x04, 0x1f, 0xd2, 0x40, 0x26, 0x21,
	0x18, 0x8f, 0xb4, 0x57, 0xfc, 0xce, 0x7d, 0x66, 0x44, 0x91, 0x1a, 0x71, 0x56, 0x90, 0x25, 0x6e,
	0x3b, 0x53, 0x0c, 0xe8, 0x26, 0xac, 0xec, 0xf7, 0x07, 0x7e, 0xf3, 0x68, 0xd8, 0x61, 0x12, 0x4a,
	0x54, 0xc2, 0x69, 0x2e, 0xe1, 0x96, 0xb8, 0xe7, 0x64, 0xa1, 0xa8, 0x01, 0xa7, 0xba, 0xfe, 0xbd,
	0x71, 0xaf, 0xd7, 0x1f, 0xf6, 0xb4, 0x60, 0x18, 0x79, 0xfd, 0xa1, 0x1f, 0x8e, 0xaa, 0x8b, 0xd4,
	0x9f, 0x0b, 0x49, 0x20, 0x26, 0x11, 0xf8, 0x81, 0x3f, 0x8c, 0x9c, 0x59, 0xac, 0xe8, 0x49, 0x28,
	0x1f, 0xf8, 0x91, 0xd7, 0xf5, 0x22, 0xaf, 0x5a, 0xa6, 0x86, 0x9c, 0xe0, 0x62, 0xf6, 0x38, 0xd9,
	0x49, 0x00, 0xb5, 0x26, 0x9c, 0x9a, 0x11, 0x26, 0x92, 0x04, 0xf7, 0xfd, 0x23, 0x7a, 0x84, 0x45,
	0x87, 0xfc, 0x44, 0x57, 0xa1, 0xf8, 0xc0, 0x1b, 0x8c, 0xe3, 0x23, 0x92, 0xb9, 0x48, 0xc2, 0xc3,
	0x6c, 0x61, 0xdb, 0x37, 0xf3, 0xcf, 0xe5, 0x6e, 0x17, 0xca, 0x92, 0x5c, 0x50, 0xde, 0xcd, 0x41,
	0x39, 0xd6, 0x88, 0x36, 0xa1, 0x48, 0x4f, 0x9d, 0x67, 0xc5, 0x69, 0x31, 0x2b, 0x12, 0xb3, 0x18,
	0x04, 0x7d, 0x14, 0x4a, 0xec, 0xb0, 0xb9, 0xae, 0xb5, 0x4c, 0x3a, 0x24, 0x68, 0x0e, 0x42, 0x9f,
	0x06, 0xf0, 0xba, 0xdd, 0x3e, 0xb9, 0x42, 0xde, 0xa0, 0xda, 0xa1, 0x81, 0xbb, 0x38, 0xe1, 0xf1,
	0x96, 0x9a, 0x20, 0x58, 0x1e, 0x08, 0x2c, 0xb5, 0x17, 0xe0, 0xc4, 0xc4, 0xb6, 0xe8, 0x7f, 0x85,
	0xf9, 0x7f, 0x5a, 0xf4, 0xbf, 0x22, 0x78, 0xab, 0xbc, 0x9f, 0x87, 0x95, 0x8c, 0x1f, 0xe8, 0x29,
	0x38, 0x39, 0x1c, 0x1f, 0xdc, 0xf3, 0x43, 0x7b, 0x5f, 0x0d, 0xa3, 0xfe, 0xbe, 0xd7, 0x89, 0x46,
	0x3c, 0x96, 0xd3, 0x1b, 0xe8, 0x05, 0x28, 0x53, 0xbf, 0xc9, 0xb1, 0xe7, 0xa9, 0xf5, 0x97, 0x66,
	0x45, 0x67, 0xcb, 0x38, 0xf0, 0x7a, 0xfe, 0x36, 0x43, 0x3a, 0x09, 0x0b, 0xba, 0x0c, 0x85, 0xe8,
	0xe8, 0xd0, 0xaf, 0x4a, 0x1b, 0xb9, 0x6b, 0xab, 0xc9, 0xb9, 0x50, 0x9c, 0x7b, 0x74, 0xe8, 0x3b,
	0x74, 0x17, 0xe9, 0x33, 0x82, 0x74, 0x79, 0xa6, 0x9a, 0x87, 0x45, 0xca, 0x84, 0x65, 0xd1, 0x0a,
	0x74, 0x95, 0xeb, 0xce, 0x51, 0xdd, 0x48, 0x94, 0xe7, 0x87, 0x82, 0xf6, 0xd3, 0x50, 0xec, 0x04,
	0xe3, 0x61, 0x44, 0x83, 0x57, 0x74, 0xd8, 0xe2, 0xbf, 0x8d, 0xfb, 0xaf, 0x72, 0xb0, 0x9a, 0x4d,
	0x09, 0xf4, 0x3c, 0x54, 0x58, 0x52, 0x90, 0x58, 0xe6, 0x26, 0xae, 0x90, 0x88, 0xe4, 0x4b, 0x3f,
	0x74, 0x52, 0x06, 0xf4, 0x14, 0x2c, 0x76, 0x06, 0xe3, 0x51, 0xe4, 0x87, 0x54, 0x59, 0xea, 0x90,
	0xc6, 0xa8, 0xd4, 0xa1, 0x18, 0x52, 0x33, 0xa0, 0x1c, 0x0b, 0x41, 0x8f, 0x67, 0xe2, 0x70, 0x2a,
	0xa3, 0xf2, 0xf8, 0x40, 0x28, 0x7f, 0xcc, 0x01, 0xa4, 0xf5, 0x11, 0x7d, 0x0a, 0x2a, 0x9e, 0x90,
	0x36, 0x62, 0x61, 0x4b, 0x51, 0x5b, 0x49, 0x02, 0xb1, 0x63, 0x4a, 0x59, 0xd0, 0x06, 0x2c, 0x79,
	0xe3, 0x28, 0x70, 0xc3, 0x7e, 0xaf, 0xc7, 0x7d, 0x29, 0x3b, 0x22, 0x89, 0x14, 0x6a, 0x5e, 0xc4,
	0x82, 0x6e, 0x9c, 0x39, 0x27, 0xb3, 0xf5, 0x2e, 0xe8, 0xfa, 0x8e, 0x00, 0xaa, 0x3d, 0x0f, 0xab,
	0x59, 0x8d, 0x8f, 0x74, 0x56, 0x9f, 0x87, 0x25, 0xa1, 0x98, 0xa3, 0x33, 0x50, 0x62, 0xa2, 0x39,
	0x37, 0x5f, 0xfd, 0x4f, 0x2c, 0x57, 0xde, 0xce, 0x81, 0x3c, 0x59, 0xc4, 0xe7, 0x5a, 0xa0, 0x43,
	0x25, 0xf4, 0x47, 0xc1, 0x38, 0xec, 0xf8, 0xf1, 0x6d, 0xbc, 0x3a, 0xa7, 0x11, 0x6c, 0x39, 0x31,
	0x90, 0x9f, 0x40, 0xc2, 0xf8, 0x21, 0xe3, 0x9b, 0x95, 0xf7, 0x48, 0xf1, 0x35, 0x60, 0x25, 0xd3,
	0x65, 0x3e, 0x7c, 0x84, 0x95, 0xb7, 0x0b, 0x50, 0xa4, 0x15, 0x1d, 0x3d, 0x0d, 0x15, 0xd2, 0x27,
	0xe8, 0x82, 0xd7, 0x6d, 0x59, 0xa8, 0xab, 0x94, 0x5e, 0x5f, 0x70, 0x52, 0x10, 0xba, 0xc1, 0x07,
	0x00, 0xc6, 0x92, 0x9f, 0x1e, 0x00, 0x62, 0x1e, 0x01, 0x86, 0x3e, 0x1e, 0x8f, 0x00, 0x8c, 0x4b,
	0x9a, 0x31, 0x02, 0xc4, 0x6c, 0x22, 0x90, 0x98, 0x77, 0x18, 0x77, 0x9f, 0x6a, 0x61, 0x76, 0x57,
	0x22, 0xe6, 0x25, 0x20, 0x84, 0x33, 0xcd, 0x9e, 0x31, 0xce, 0x6d, 0xf6, 0x31, 0xff, 0x14, 0x0b,
	0xfa, 0x0c, 0x54, 0xe3, 0xa3, 0x9e, 0xc4, 0xf3, 0xce, 0x1f, 0xb7, 0x1f, 0x67, 0x0e, 0xac, 0xbe,
	0xe0, 0xcc, 0x15, 0x81, 0x9e, 0x4f, 0xa7, 0x09, 0x26, 0x73, 0x71, 0xe6, 0x34, 0x11, 0x0b, 0xca,
	0x82, 0xd1, 0x5d, 0x38, 0xdb, 0x9d, 0x3d, 0x2d, 0xf0, 0x61, 0xe0, 0x98, 0x99, 0xa2, 0xbe, 0xe0,
	0xcc, 0x13, 0x80, 0x3e, 0x01, 0xcb, 0x5d, 0xff, 0x81, 0x19, 0x04, 0x87, 0x4c, 0x60, 0x85, 0x0a,
	0x4c, 0xcb, 0x5d, 0xba, 0x55, 0x5f, 0x70, 0x32, 0xd0, 0xed, 0x65, 0x00, 0x9f, 0xfc, 0x68, 0x93,
	0x32, 0xa8, 0x0c, 0x60, 0x59, 0x44, 0xa3, 0x75, 0xa8, 0xf4, 0x23, 0x3f, 0xa4, 0x63, 0x30, 0x6f,
	0x94, 0x29, 0x41, 0xc8, 0xe5, 0x7c, 0x26, 0x97, 0xaf, 0x82, 0xe4, 0x87, 0x21, 0x4f, 0x98, 0x38,
	0x3c, 0x6a, 0x87, 0xf6, 0x93, 0x7b, 0x03, 0x1f, 0x87, 0xa1, 0x43, 0x00, 0xca, 0x97, 0x72, 0xb0,
	0x92, 0x21, 0xa3, 0x27, 0x61, 0xd1, 0x0f, 0x43, 0x7a, 0x39, 0x73, 0xf3, 0x2e, 0x67, 0x8c, 0x40,
	0x55, 0x58, 0x3c, 0xf0, 0x47, 0x23, 0xaf, 0x17, 0xdf, 0xbb, 0x78, 0x89, 0x6e, 0xc0, 0xd2, 0x68,
	0xdc, 0xeb, 0xf9, 0x23, 0x3a, 0xbe, 0x57, 0x25, 0x5a, 0x2e, 0x12, 0x51, 0xc9, 0x8e, 0x23, 0xa2,
	0x14, 0x0b, 0x2a, 0xc9, 0xed, 0x21, 0x37, 0xda, 0x27, 0x97, 0x9d, 0xdf, 0x52, 0xb6, 0xc8, 0x4c,
	0x70, 0xf9, 0x63, 0x26, 0x38, 0xe5, 0xcd, 0xb8, 0x79, 0x30, 0x89, 0x35, 0x28, 0xc7, 0x9d, 0x80,
	0x0b, 0x4d, 0xd6, 0x73, 0x03, 0x29, 0xa7, 0x81, 0xac, 0xd0, 0x90, 0x89, 0x01, 0x2a, 0x1c, 0x1b,
	0xa0, 0x9b, 0xb0, 0xe2, 0x89, 0xe1, 0xe5, 0x77, 0x6a, 0xf6, 0x89, 0x64, 0xa1, 0xca, 0x1b, 0xb9,
	0xb8, 0x33, 0x30, 0xf3, 0xe7, 0xd5, 0x2d, 0x6e, 0x62, 0x7e, 0xa6, 0x89, 0xd2, 0xa3, 0x9b, 0x58,
	0xf8, 0xe0, 0x26, 0xbe, 0x95, 0xed, 0x1f, 0x0f, 0xb7, 0x73, 0x7e, 0xb2, 0xfc, 0x1f, 0x83, 0xfc,
	0xa7, 0x1c, 0x54, 0xe7, 0x95, 0x22, 0x92, 0x30, 0x71, 0x29, 0x8a, 0x13, 0x26, 0x5e, 0xcf, 0x4d,
	0x18, 0xc1, 0x4b, 0x69, 0xa6, 0x97, 0x85, 0xd4, 0xcb, 0x6c, 0x2f, 0x2c, 0x7e, 0x80, 0x5e, 0x38,
	0xed, 0x6b, 0xe9, 0x83, 0xfb, 0xfa, 0xfd, 0x3c, 0x54, 0x92, 0xf2, 0x4f, 0x0a, 0xcb, 0x20, 0xe8,
	0x78, 0x03, 0x42, 0x89, 0x0b, 0x4b, 0x42, 0x40, 0x17, 0x00, 0x42, 0xff, 0x20, 0x88, 0x7c, 0xba,
	0xcd, 0x46, 0x32, 0x81, 0x42, 0xdc, 0x3c, 0x0c, 0xba, 0x16, 0xf9, 0xe0, 0xe5, 0x6e, 0xf2, 0x25,
	0xba, 0x0c, 0x2b, 0x9d, 0xb8, 0x36, 0xd2, 0x7d, 0xe6, 0x70, 0x96, 0x48, 0xb4, 0x93, 0x2f, 0xe4,
	0xd1, 0xa1, 0xd7, 0x61, 0x9e, 0x57, 0x9c, 0x94, 0x40, 0x02, 0x4f, 0x5a, 0x13, 0x65, 0x2f, 0xb1,
	0xc0, 0xc7, 0x6b, 0xa4, 0xc0, 0x72, 0x7c, 0x08, 0x64, 0x7a, 0xa4, 0x2d, 0xa0, 0xe2, 0x64, 0x68,
	0x22, 0x86, 0xca, 0x28, 0x67, 0x31, 0x54, 0x4e, 0x15, 0x16, 0xbd, 0x6e, 0x37, 0xf4, 0x47, 0x23,
	0x5a, 0xac, 0x2b, 0x4e, 0xbc, 0x54, 0x7e, 0x9f, 0x4b, 0x47, 0x86, 0x24, 0x56, 0xa4, 0x95, 0x68,
	0x74, 0x3e, 0xe5, 0xb1, 0x4a, 0x08, 0xa4, 0x52, 0xf5, 0x0f, 0xd2, 0xb4, 0x66, 0x0b, 0x21, 0x41,
	0xa4, 0x59, 0xd7, 0xb5, 0x30, 0x33, 0xd9, 0x8b, 0x8f, 0x9e, 0xec, 0x8f, 0x90, 0x00, 0xef, 0xe5,
	0xe1, 0xec, 0x9c, 0xde, 0xf6, 0xb0, 0x5b, 0x1b, 0x1f, 0x74, 0xfe, 0x98, 0x83, 0x96, 0x8e, 0x3d,
	0xe8, 0xc2, 0x8c, 0x83, 0x4e, 0x4a, 0x72, 0x71, 0xa2, 0x24, 0x57, 0x61, 0x31, 0x1c, 0x0f, 0xa3,
	0x7e, 0x92, 0x03, 0xf1, 0x92, 0x24, 0xe7, 0xab, 0x41, 0x78, 0xbf, 0x3f, 0xec, 0xe9, 0xfd, 0x90,
	0x27, 0x80, 0x40, 0x41, 0x16, 0x00, 0xed, 0xd3, 0xec, 0xfd, 0xa3, 0x4c, 0x7b, 0xcf, 0xd6, 0xc3,
	0x7b, 0x3b, 0xa3, 0x0b, 0xaf, 0x21, 0x82, 0x04, 0xf2, 0x35, 0x36, 0xb1, 0x7d, 0xdc, 0x04, 0xba,
	0x22, 0x4e, 0xa0, 0x5f, 0x80, 0xb2, 0x19, 0xf4, 0x18, 0xdf, 0x73, 0x50, 0x49, 0xde, 0xac, 0xf8,
	0xe0, 0x58, 0xdb, 0x62, 0x8f, 0x56, 0x5b, 0xf1, 0xa3, 0xd5, 0x96, 0x1b, 0x23, 0x9c, 0x14, 0x8c,
	0x14, 0x28, 0xfa, 0xc2, 0xec, 0x18, 0x3f, 0x56, 0xf1, 0x17, 0x06, 0x3f, 0xdb, 0x33, 0x25, 0xa1,
	0x67, 0x2a, 0x37, 0xe1, 0x64, 0x6b, 0xe4, 0x87, 0xc6, 0x30, 0x22, 0x50, 0xfe, 0x5c, 0x75, 0x05,
	0x4a, 0x7d, 0x4a, 0xe0, 0x56, 0xac, 0x70, 0x79, 0x1c, 0xc5, 0x37, 0x95, 0x4f, 0xc2, 0x2a, 0x9f,
	0x7e, 0x63, 0xc6, 0x27, 0xb2, 0x8f, 0x66, 0xf1, 0x88, 0xc3, 0x51, 0x99, 0xb7, 0xb3, 0x67, 0x60,
	0x59, 0x24, 0xa3, 0x1a, 0x2c, 0xfa, 0x34, 0x19, 0xd9, 0x5b, 0x47, 0xb9, 0xbe, 0xe0, 0xc4, 0x84,
	0xed, 0x22, 0x48, 0x0f, 0xbc, 0x81, 0x72, 0x1b, 0x4a, 0xcc, 0x02, 0xe2, 0x4b, 0xfa, 0x2c, 0x52,
	0x8e, 0x1f, 0x40, 0x10, 0x14, 0x46, 0x47, 0xc3, 0x0e, 0x9f, 0xce, 0xe9, 0x6f, 0x92, 0xba, 0xfc,
	0x51, 0x44, 0xa2, 0x54, 0xbe, 0x52, 0x3a, 0x00, 0xe9, 0xa4, 0x81, 0x5e, 0x80, 0xd5, 0x74, 0xd6,
	0x10, 0xe6, 0x9b, 0xb5, 0xa9, 0xa1, 0x84, 0x5e, 0xb8, 0x09, 0x30, 0x51, 0xc2, 0x2e, 0x53, 0x5c,
	0xef, 0xd9, 0x6a, 0x33, 0x80, 0x25, 0xe1, 0xa3, 0x1e, 0x55, 0xe1, 0x74, 0xcb, 0xda, 0xb5, 0xec,
	0x97, 0xac, 0xf6, 0x76, 0xcb, 0x30, 0x75, 0xec, 0xb4, 0xdd, 0x3b, 0x0d, 0x2c, 0x2f, 0xa0, 0x45,
	0x90, 0x6e, 0x1b, 0xdb, 0x72, 0x0e, 0x55, 0xa0, 0xb8, 0xad, 0xde, 0xc5, 0xa6, 0x9c, 0x47, 0xab,
	0x00, 0x14, 0xd5, 0x50, 0xb5, 0xdd, 0xa6, 0x2c, 0x21, 0x80, 0x92, 0xd6, 0x6a, 0xba, 0xf6, 0x9e,
	0x5c, 0x20, 0xbf, 0x77, 0x55, 0xcb, 0xd8, 0xb5, 0xe5, 0x22, 0xf9, 0xad, 0xdb, 0xda, 0x2e, 0x76,
	0xe4, 0xd2, 0xa6, 0x0e, 0x95, 0xe4, 0x05, 0x03, 0x9d, 0x01, 0x94, 0x51, 0x17, 0x2b, 0x5b, 0x82,
	0x45, 0xcd, 0x6c, 0x35, 0x5d, 0xec, 0xc8, 0x39, 0xa2, 0x79, 0x47, 0xdb, 0x96, 0xf3, 0x44, 0xb3,
	0x69, 0x6b, 0xaa, 0x29, 0x4b, 0x9b, 0x36, 0x19, 0x33, 0xd3, 0x6f, 0x70, 0x74, 0x0e, 0xd6, 0x62,
	0x41, 0x3a, 0x6e, 0x98, 0xf6, 0x9d, 0xd4, 0xf0, 0x32, 0x14, 0xea, 0xd8, 0xdc, 0x93, 0x73, 0x68,
	0x05, 0x2a, 0xbb, 0xd4, 0x3c, 0xe3, 0x2e, 0x96, 0xf3, 0x44, 0xc9, 0x6e, 0x6b, 0x1b, 0x6b, 0x2e,
	0x11, 0x68, 0xc0, 0x92, 0xf0, 0x16, 0x20, 0xc6, 0x81, 0x1b, 0x12, 0x8b, 0x5b, 0x86, 0xf2, 0x9e,
	0x61, 0x19, 0x84, 0x93, 0xdb, 0xb6, 0x8b, 0x99, 0x6d, 0xb6, 0x5b, 0xc7, 0x8e, 0x2c, 0x6d, 0xfe,
	0x19, 0x00, 0xd2, 0xd2, 0x87, 0x4a, 0x90, 0xb7, 0x77, 0xe5, 0x05, 0x54, 0x85, 0x53, 0x4d, 0x57,
	0x75, 0x5b, 0x4d, 0xad, 0x8e, 0xb5, 0xdd, 0x76, 0xb3, 0xa5, 0x69, 0xb8, 0xd9, 0x94, 0x7f, 0x9d,
	0x43, 0x08, 0x56, 0x98, 0xf7, 0x31, 0xed, 0x37, 0x39, 0x74, 0x0a, 0x56, 0x99, 0x23, 0x09, 0xf1,
	0xb7, 0x39, 0xb4, 0x0e, 0x55, 0x06, 0x6c, 0xb4, 0x9a, 0xf5, 0xb6, 0x4a, 0xe9, 0x6d, 0x1d, 0x5b,
	0x06, 0xd6, 0x65, 0x1f, 0x9d, 0x87, 0xb3, 0x7c, 0xd7, 0xb1, 0x6f, 0x63, 0xcd, 0x6d, 0x5b, 0xb6,
	0xdb, 0xbe, 0x65, 0xb7, 0x2c, 0x5d, 0xde, 0x47, 0x17, 0xa1, 0x26, 0x6a, 0x37, 0xf6, 0xd4, 0x1d,
	0xdc, 0x6e, 0xb4, 0x4c, 0xb3, 0x8d, 0x1d, 0x47, 0xfe, 0x41, 0x1e, 0x7d, 0x04, 0x2e, 0x88, 0x00,
	0xcd, 0xb6, 0x5c, 0xd5, 0xb0, 0xb0, 0xd3, 0xd6, 0x1c, 0xac, 0xba, 0x86, 0xb5, 0x23, 0xff, 0x30,
	0x8f, 0x14, 0x78, 0x4c, 0x04, 0x39, 0x2d, 0x4b, 0x00, 0x12, 0x41, 0x3f, 0xca, 0xa3, 0x2b, 0xb0,
	0x31, 0x5b, 0x90, 0x8b, 0x9d, 0x3d, 0xc3, 0x52, 0x5d, 0xac, 0xcb, 0x3f, 0xce, 0xa3, 0x27, 0xe1,
	0xaa, 0x08, 0x63, 0xce, 0xee, 0x61, 0xcb, 0x6d, 0x3b, 0xb6, 0x69, 0xda, 0x2d, 0xb7, 0xdd, 0xc0,
	0x96, 0x4e, 0xf4, 0xfe, 0xe4, 0x21, 0x32, 0x1d, 0xdc, 0x74, 0x55, 0x87, 0x9a, 0xf7, 0x4e, 0x1e,
	0xd5, 0x60, 0x4d, 0x84, 0xb5, 0xac, 0x3a, 0x56, 0x4d, 0xb7, 0x7e, 0x47, 0x7e, 0x77, 0x4a, 0x84,
	0x65, 0xeb, 0xb8, 0xbd, 0x87, 0xf7, 0x6c, 0xe7, 0x4e, 0xbb, 0xe1, 0xe0, 0x66, 0xb3, 0xe5, 0x60,
	0xf9, 0xcb, 0xd2, 0x64, 0x18, 0x28, 0x4c, 0x37, 0x9a, 0xbb, 0x29, 0xe8, 0x2b, 0x12, 0x7a, 0x02,
	0x2e, 0x4f, 0x81, 0x2c, 0xec, 0xbe, 0x64, 0x3b, 0x44, 0xa9, 0xfa, 0xa2, 0x6a, 0x98, 0xea, 0xb6,
	0x89, 0xe5, 0xaf, 0x4a, 0x93, 0x11, 0xa3, 0xd0, 0x86, 0xa1, 0xa7, 0xe2, 0x5e, 0x9b, 0xad, 0xb3,
	0x65, 0x91, 0x95, 0xde, 0x62, 0x82, 0xbe, 0x26, 0xa1, 0x4b, 0xb0, 0x3e, 0x03, 0xe4, 0x60, 0x55,
	0xab, 0x53, 0xc8, 0xeb, 0xd2, 0xe4, 0x19, 0x33, 0xb3, 0x6c, 0xb7, 0xed, 0x60, 0x55, 0xbf, 0x23,
	0x7f, 0x7d, 0xca, 0x98, 0x5b, 0xaa, 0x61, 0x62, 0xbd, 0xcd, 0x15, 0x91, 0x18, 0x7e, 0x43, 0x42,
	0x8f, 0x83, 0x22, 0x62, 0xf8, 0x0d, 0x21, 0x21, 0xb7, 0xb0, 0xe6, 0x1a, 0xb6, 0x45, 0xcf, 0xf9,
	0x5b, 0x53, 0x56, 0xc7, 0x40, 0xe2, 0xdc, 0xae, 0x61, 0x9a, 0x58, 0x97, 0xbf, 0x3d, 0x15, 0xa9,
	0x44, 0x9a, 0x69, 0x90, 0x93, 0xbe, 0x85, 0x5d, 0xad, 0x4e, 0xe5, 0x7d, 0x47, 0x9a, 0x3c, 0x20,
	0x21, 0x21, 0x52, 0xd8, 0x77, 0xa7, 0xe2, 0xd0, 0xb0, 0xf5, 0xb6, 0x61, 0x19, 0xae, 0xa1, 0x9a,
	0xc6, 0x5d, 0xe2, 0xc2, 0x2f, 0x25, 0x72, 0x9f, 0xe2, 0xcb, 0x8b, 0x1d, 0xc7, 0x76, 0xe4, 0xf7,
	0xa4, 0xc9, 0xdb, 0xc7, 0xf7, 0xe5, 0xf7, 0x25, 0x74, 0x15, 0x2e, 0xcd, 0xd8, 0x99, 0x38, 0x80,
	0xbf, 0x48, 0x68, 0x13, 0xae, 0xcc, 0xce, 0xc1, 0x97, 0x54, 0x83, 0x24, 0x60, 0x22, 0xf3, 0xaf,
	0x12, 0xba, 0x00, 0xe7, 0x66, 0xc9, 0xc4, 0x2f, 0x62, 0xcb, 0x95, 0xff, 0x2d, 0x09, 0xb7, 0x3b,
	0x66, 0xfa, 0x9b, 0x84, 0x4e, 0xc2, 0x72, 0xf3, 0x8e, 0xa5, 0x25, 0xa4, 0xbf, 0x4b, 0x69, 0x65,
	0x88, 0x69, 0xff, 0x90, 0xd0, 0x69, 0x38, 0xa1, 0xe3, 0x17, 0x89, 0xcf, 0x09, 0xf5, 0x9f, 0x94,
	0xaa, 0x99, 0x58, 0xb5, 0x5a, 0x8d, 0x84, 0xfa, 0x2f, 0x4a, 0xa5, 0x22, 0x29, 0x9a, 0xc5, 0xe2,
	0x0f, 0x05, 0xb4, 0x01, 0xe7, 0x63, 0x09, 0x0e, 0xde, 0x31, 0x68, 0x75, 0x63, 0x6a, 0x74, 0xdc,
	0x68, 0xca, 0x3f, 0x2b, 0x92, 0x4c, 0x9a, 0x42, 0xb8, 0xb8, 0xe9, 0x32, 0xc0, 0xcf, 0x8b, 0xe4,
	0x14, 0xa6, 0x00, 0xdc, 0x23, 0x0a, 0x79, 0xab, 0x38, 0x53, 0x8b, 0x66, 0x5b, 0xb7, 0x8c, 0x1d,
	0x02, 0x91, 0x7f, 0x51, 0x9c, 0xcc, 0xd7, 0x56, 0x93, 0x20, 0x54, 0x4b, 0xc3, 0x34, 0x7b, 0xde,
	0x28, 0x4d, 0xe6, 0xab, 0x8e, 0x55, 0xdd, 0x34, 0x2c, 0xdc, 0xc6, 0x2f, 0x6b, 0x18, 0xeb, 0x58,
	0x97, 0xbf, 0x57, 0xda, 0x7c, 0xb3, 0x00, 0xab, 0xd9, 0xde, 0x47, 0x8a, 0xb2, 0x65, 0x98, 0xf2,
	0x02, 0x3a, 0x0d, 0xb2, 0xaa, 0x13, 0xaf, 0x6e, 0xa9, 0x2d, 0x93, 0x98, 0xd1, 0xb0, 0xe5, 0x2e,
	0x69, 0x3a, 0xb1, 0x3c, 0x81, 0x4e, 0x06, 0xc2, 0x8d, 0x69, 0x7a, 0x7b, 0xc7, 0xb4, 0xb7, 0x55,
	0x93, 0x5b, 0x2e, 0xef, 0xa3, 0x0d, 0x58, 0xdf, 0xd1, 0x4c, 0xbb, 0xa5, 0xb7, 0x59, 0x4b, 0x6b,
	0xab, 0x2d, 0xb7, 0xce, 0xb7, 0xc9, 0x7d, 0xee, 0x91, 0x5e, 0x34, 0x7b, 0xeb, 0x15, 0xd2, 0x56,
	0x98, 0x0a, 0x2e, 0x82, 0x57, 0x6a, 0xb9, 0x8f, 0xce, 0xc5, 0x3b, 0x69, 0x5e, 0x99, 0xf6, 0x4e,
	0x93, 0x14, 0xdd, 0x1a, 0xac, 0xf1, 0x72, 0x8b, 0x55, 0xdd, 0xb0, 0x48, 0xcd, 0x6f, 0x38, 0xf6,
	0x36, 0x26, 0xc5, 0x36, 0xd9, 0x4b, 0xd9, 0x68, 0x69, 0x27, 0x15, 0xf6, 0x12, 0xac, 0xab, 0xba,
	0x4e, 0xea, 0xcc, 0xdc, 0x6a, 0x77, 0x11, 0x6a, 0x19, 0xc8, 0x54, 0xa5, 0xbb, 0x02, 0x1b, 0x19,
	0xc0, 0x9c, 0x2a, 0x77, 0x01, 0xce, 0x65, 0x60, 0x93, 0x15, 0x6e, 0x52, 0xcf, 0x54, 0x75, 0x7b,
	0x0c, 0xaa, 0x13, 0x80, 0x4c, 0x65, 0x3b, 0x0f, 0x67, 0xb2, 0x66, 0x88, 0x55, 0x4d, 0x50, 0x3e,
	0xb3, 0xa2, 0x25, 0x31, 0xaa, 0xdb, 0x4d, 0x57, 0x28, 0x64, 0xf2, 0x37, 0xa5, 0x67, 0x7f, 0x5a,
	0x84, 0x13, 0x4d, 0xfe, 0x9f, 0xdc, 0xa6, 0x1f, 0x3e, 0xe8, 0x77, 0x7c, 0xa4, 0x41, 0x79, 0xc7,
	0x8f, 0xf8, 0x63, 0xeb, 0xd4, 0x70, 0x8b, 0x0f, 0x0e, 0xa3, 0xa3, 0x5a, 0xe6, 0x7f, 0xad, 0xca,
	0xc9, 0x2f, 0xfe, 0xee, 0x9d, 0xd7, 0xf2, 0x4b, 0xa8, 0x72, 0xfd, 0xc1, 0x33, 0xd7, 0xe9, 0xec,
	0x88, 0x76, 0xa0, 0x4c, 0x47, 0x5b, 0x33, 0xe8, 0xa1, 0xf8, 0x89, 0x27, 0x9e, 0xa2, 0x6b, 0x93,
	0x04, 0x65, 0x8d, 0x0a, 0x38, 0x81, 0x56, 0x88, 0x00, 0xf6, 0x9a, 0x36, 0x08, 0x7a, 0xd7, 0x72,
	0x4f, 0xe7, 0xd0, 0x0e, 0x94, 0xa8, 0xa0, 0xd1, 0x5c, 0x5b, 0xa6, 0xa4, 0x21, 0x2a, 0x6d, 0x19,
	0x41, 0x22, 0x6d, 0xf4, 0x74, 0x0e, 0xbd, 0x0c, 0x8b, 0xf8, 0x73, 0x7e, 0x67, 0x1c, 0xf9, 0xa8,
	0xca, 0x39, 0xa6, 0xc6, 0xea, 0xda, 0x1c, 0x1d, 0xca, 0x79, 0x2a, 0x72, 0x4d, 0x59, 0xa2, 0x22,
	0x99, 0x98, 0x9b, 0x7c, 0xc8, 0x46, 0x1e, 0x54, 0xd4, 0x71, 0x14, 0xd0, 0xb1, 0x0e, 0xad, 0x65,
	0x07, 0xea, 0xe3, 0x04, 0x5f, 0xa1, 0x82, 0x2f, 0xd6, 0xce, 0x10, 0xc1, 0x74, 0x46, 0xbe, 0xee,
	0x8d, 0xa3, 0xa0, 0x1d, 0xeb, 0x60, 0xa3, 0x38, 0x6a, 0x43, 0x99, 0xa8, 0x20, 0x9f, 0xb4, 0x8f,
	0xaa, 0xe1, 0x32, 0xd5, 0x70, 0xa1, 0xb6, 0x46, 0x0f, 0xe7, 0x68, 0xd8, 0x99, 0xa9, 0xa0, 0x03,
	0x40, 0x14, 0xb0, 0xa1, 0xf2, 0x51, 0x55, 0x5c, 0xa5, 0x2a, 0x36, 0x6a, 0x67, 0x89, 0x0a, 0x36,
	0xbd, 0xcf, 0x54, 0x62, 0x42, 0xa9, 0xee, 0x0d, 0xbb, 0x03, 0x1f, 0x65, 0x3e, 0x7f, 0xe6, 0xca,
	0x5d, 0xa7, 0x72, 0xcf, 0x28, 0x27, 0xd3, 0x83, 0xbc, 0xfe, 0x0a, 0x15, 0x70, 0x33, 0xb7, 0x79,
	0xaf, 0x44, 0xd1, 0x37, 0xfe, 0x13, 0x00, 0x00, 0xff, 0xff, 0xe2, 0x15, 0xc3, 0x84, 0x8b, 0x20,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SkaffoldServiceClient is the client API for SkaffoldService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SkaffoldServiceClient interface {
	// Returns the state of the current Skaffold execution
	GetState(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*State, error)
	// DEPRECATED. Events should be used instead.
	// TODO remove (https://github.com/GoogleContainerTools/skaffold/issues/3168)
	EventLog(ctx context.Context, opts ...grpc.CallOption) (SkaffoldService_EventLogClient, error)
	// Returns all the events of the current Skaffold execution from the start
	Events(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (SkaffoldService_EventsClient, error)
	// Allows for a single execution of some or all of the phases (build, sync, deploy) in case autoBuild, autoDeploy or autoSync are disabled.
	Execute(ctx context.Context, in *UserIntentRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Allows for enabling or disabling automatic build trigger
	AutoBuild(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Allows for enabling or disabling automatic sync trigger
	AutoSync(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Allows for enabling or disabling automatic deploy trigger
	AutoDeploy(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// EXPERIMENTAL. It allows for custom events to be implemented in custom builders for example.
	Handle(ctx context.Context, in *Event, opts ...grpc.CallOption) (*empty.Empty, error)
}

type skaffoldServiceClient struct {
	cc *grpc.ClientConn
}

func NewSkaffoldServiceClient(cc *grpc.ClientConn) SkaffoldServiceClient {
	return &skaffoldServiceClient{cc}
}

func (c *skaffoldServiceClient) GetState(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*State, error) {
	out := new(State)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/GetState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldServiceClient) EventLog(ctx context.Context, opts ...grpc.CallOption) (SkaffoldService_EventLogClient, error) {
	stream, err := c.cc.NewStream(ctx, &_SkaffoldService_serviceDesc.Streams[0], "/proto.SkaffoldService/EventLog", opts...)
	if err != nil {
		return nil, err
	}
	x := &skaffoldServiceEventLogClient{stream}
	return x, nil
}

type SkaffoldService_EventLogClient interface {
	Send(*LogEntry) error
	Recv() (*LogEntry, error)
	grpc.ClientStream
}

type skaffoldServiceEventLogClient struct {
	grpc.ClientStream
}

func (x *skaffoldServiceEventLogClient) Send(m *LogEntry) error {
	return x.ClientStream.SendMsg(m)
}

func (x *skaffoldServiceEventLogClient) Recv() (*LogEntry, error) {
	m := new(LogEntry)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *skaffoldServiceClient) Events(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (SkaffoldService_EventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_SkaffoldService_serviceDesc.Streams[1], "/proto.SkaffoldService/Events", opts...)
	if err != nil {
		return nil, err
	}
	x := &skaffoldServiceEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type SkaffoldService_EventsClient interface {
	Recv() (*LogEntry, error)
	grpc.ClientStream
}

type skaffoldServiceEventsClient struct {
	grpc.ClientStream
}

func (x *skaffoldServiceEventsClient) Recv() (*LogEntry, error) {
	m := new(LogEntry)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *skaffoldServiceClient) Execute(ctx context.Context, in *UserIntentRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/Execute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldServiceClient) AutoBuild(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/AutoBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldServiceClient) AutoSync(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/AutoSync", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldServiceClient) AutoDeploy(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/AutoDeploy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldServiceClient) Handle(ctx context.Context, in *Event, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/Handle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SkaffoldServiceServer is the server API for SkaffoldService service.
type SkaffoldServiceServer interface {
	// Returns the state of the current Skaffold execution
	GetState(context.Context, *empty.Empty) (*State, error)
	// DEPRECATED. Events should be used instead.
	// TODO remove (https://github.com/GoogleContainerTools/skaffold/issues/3168)
	EventLog(SkaffoldService_EventLogServer) error
	// Returns all the events of the current Skaffold execution from the start
	Events(*empty.Empty, SkaffoldService_EventsServer) error
	// Allows for a single execution of some or all of the phases (build, sync, deploy) in case autoBuild, autoDeploy or autoSync are disabled.
	Execute(context.Context, *UserIntentRequest) (*empty.Empty, error)
	// Allows for enabling or disabling automatic build trigger
	AutoBuild(context.Context, *TriggerRequest) (*empty.Empty, error)
	// Allows for enabling or disabling automatic sync trigger
	AutoSync(context.Context, *TriggerRequest) (*empty.Empty, error)
	// Allows for enabling or disabling automatic deploy trigger
	AutoDeploy(context.Context, *TriggerRequest) (*empty.Empty, error)
	// EXPERIMENTAL. It allows for custom events to be implemented in custom builders for example.
	Handle(context.Context, *Event) (*empty.Empty, error)
}

// UnimplementedSkaffoldServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSkaffoldServiceServer struct {
}

func (*UnimplementedSkaffoldServiceServer) GetState(ctx context.Context, req *empty.Empty) (*State, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetState not implemented")
}
func (*UnimplementedSkaffoldServiceServer) EventLog(srv SkaffoldService_EventLogServer) error {
	return status.Errorf(codes.Unimplemented, "method EventLog not implemented")
}
func (*UnimplementedSkaffoldServiceServer) Events(req *empty.Empty, srv SkaffoldService_EventsServer) error {
	return status.Errorf(codes.Unimplemented, "method Events not implemented")
}
func (*UnimplementedSkaffoldServiceServer) Execute(ctx context.Context, req *UserIntentRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Execute not implemented")
}
func (*UnimplementedSkaffoldServiceServer) AutoBuild(ctx context.Context, req *TriggerRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AutoBuild not implemented")
}
func (*UnimplementedSkaffoldServiceServer) AutoSync(ctx context.Context, req *TriggerRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AutoSync not implemented")
}
func (*UnimplementedSkaffoldServiceServer) AutoDeploy(ctx context.Context, req *TriggerRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AutoDeploy not implemented")
}
func (*UnimplementedSkaffoldServiceServer) Handle(ctx context.Context, req *Event) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Handle not implemented")
}

func RegisterSkaffoldServiceServer(s *grpc.Server, srv SkaffoldServiceServer) {
	s.RegisterService(&_SkaffoldService_serviceDesc, srv)
}

func _SkaffoldService_GetState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(empty.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).GetState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/GetState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).GetState(ctx, req.(*empty.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldService_EventLog_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SkaffoldServiceServer).EventLog(&skaffoldServiceEventLogServer{stream})
}

type SkaffoldService_EventLogServer interface {
	Send(*LogEntry) error
	Recv() (*LogEntry, error)
	grpc.ServerStream
}

type skaffoldServiceEventLogServer struct {
	grpc.ServerStream
}

func (x *skaffoldServiceEventLogServer) Send(m *LogEntry) error {
	return x.ServerStream.SendMsg(m)
}

func (x *skaffoldServiceEventLogServer) Recv() (*LogEntry, error) {
	m := new(LogEntry)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _SkaffoldService_Events_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(empty.Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SkaffoldServiceServer).Events(m, &skaffoldServiceEventsServer{stream})
}

type SkaffoldService_EventsServer interface {
	Send(*LogEntry) error
	grpc.ServerStream
}

type skaffoldServiceEventsServer struct {
	grpc.ServerStream
}

func (x *skaffoldServiceEventsServer) Send(m *LogEntry) error {
	return x.ServerStream.SendMsg(m)
}

func _SkaffoldService_Execute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).Execute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/Execute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).Execute(ctx, req.(*UserIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldService_AutoBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).AutoBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/AutoBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).AutoBuild(ctx, req.(*TriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldService_AutoSync_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).AutoSync(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/AutoSync",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).AutoSync(ctx, req.(*TriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldService_AutoDeploy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).AutoDeploy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/AutoDeploy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).AutoDeploy(ctx, req.(*TriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldService_Handle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Event)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).Handle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/Handle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).Handle(ctx, req.(*Event))
	}
	return interceptor(ctx, in, info, handler)
}

var _SkaffoldService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "proto.SkaffoldService",
	HandlerType: (*SkaffoldServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetState",
			Handler:    _SkaffoldService_GetState_Handler,
		},
		{
			MethodName: "Execute",
			Handler:    _SkaffoldService_Execute_Handler,
		},
		{
			MethodName: "AutoBuild",
			Handler:    _SkaffoldService_AutoBuild_Handler,
		},
		{
			MethodName: "AutoSync",
			Handler:    _SkaffoldService_AutoSync_Handler,
		},
		{
			MethodName: "AutoDeploy",
			Handler:    _SkaffoldService_AutoDeploy_Handler,
		},
		{
			MethodName: "Handle",
			Handler:    _SkaffoldService_Handle_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "EventLog",
			Handler:       _SkaffoldService_EventLog_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "Events",
			Handler:       _SkaffoldService_Events_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "skaffold.proto",
}
