// Code generated by protoc-gen-go. DO NOT EDIT.
// source: skaffold.proto

package proto

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Enum indicating builders used
type BuilderType int32

const (
	// Could not determine builder type
	BuilderType_UNKNOWN_BUILDER_TYPE BuilderType = 0
	// JIB Builder
	BuilderType_JIB BuilderType = 1
	// Bazel Builder
	BuilderType_BAZEL BuilderType = 2
	// Buildpacks Builder
	BuilderType_BUILDPACKS BuilderType = 3
	// Custom Builder
	BuilderType_CUSTOM BuilderType = 4
	// Kaniko Builder
	BuilderType_KANIKO BuilderType = 5
	// Docker Builder
	BuilderType_DOCKER BuilderType = 6
)

var BuilderType_name = map[int32]string{
	0: "UNKNOWN_BUILDER_TYPE",
	1: "JIB",
	2: "BAZEL",
	3: "BUILDPACKS",
	4: "CUSTOM",
	5: "KANIKO",
	6: "DOCKER",
}

var BuilderType_value = map[string]int32{
	"UNKNOWN_BUILDER_TYPE": 0,
	"JIB":                  1,
	"BAZEL":                2,
	"BUILDPACKS":           3,
	"CUSTOM":               4,
	"KANIKO":               5,
	"DOCKER":               6,
}

func (x BuilderType) String() string {
	return proto.EnumName(BuilderType_name, int32(x))
}

func (BuilderType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{0}
}

// Enum indicating build type i.e. local, cluster vs GCB
type BuildType int32

const (
	// Could not determine Build Type
	BuildType_UNKNOWN_BUILD_TYPE BuildType = 0
	// Cluster Build
	BuildType_CLUSTER BuildType = 1
	// GCB Build
	BuildType_GCB BuildType = 2
	// Local Build
	BuildType_LOCAL BuildType = 3
)

var BuildType_name = map[int32]string{
	0: "UNKNOWN_BUILD_TYPE",
	1: "CLUSTER",
	2: "GCB",
	3: "LOCAL",
}

var BuildType_value = map[string]int32{
	"UNKNOWN_BUILD_TYPE": 0,
	"CLUSTER":            1,
	"GCB":                2,
	"LOCAL":              3,
}

func (x BuildType) String() string {
	return proto.EnumName(BuildType_name, int32(x))
}

func (BuildType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{1}
}

// Enum indicating deploy tools used
type DeployerType int32

const (
	// Could not determine Deployer Type
	DeployerType_UNKNOWN_DEPLOYER_TYPE DeployerType = 0
	// Helm Deployer
	DeployerType_HELM DeployerType = 1
	// Kustomize Deployer
	DeployerType_KUSTOMIZE DeployerType = 2
	// Kubectl Deployer
	DeployerType_KUBECTL DeployerType = 3
)

var DeployerType_name = map[int32]string{
	0: "UNKNOWN_DEPLOYER_TYPE",
	1: "HELM",
	2: "KUSTOMIZE",
	3: "KUBECTL",
}

var DeployerType_value = map[string]int32{
	"UNKNOWN_DEPLOYER_TYPE": 0,
	"HELM":                  1,
	"KUSTOMIZE":             2,
	"KUBECTL":               3,
}

func (x DeployerType) String() string {
	return proto.EnumName(DeployerType_name, int32(x))
}

func (DeployerType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{2}
}

// Enum indicating cluster type the application is deployed to
type ClusterType int32

const (
	// Could not determine Cluster Type
	ClusterType_UNKNOWN_CLUSTER_TYPE ClusterType = 0
	// Minikube Cluster
	ClusterType_MINIKUBE ClusterType = 1
	// GKE cluster
	ClusterType_GKE ClusterType = 2
	// All Cluster except Minikube and GKE
	ClusterType_OTHER ClusterType = 3
)

var ClusterType_name = map[int32]string{
	0: "UNKNOWN_CLUSTER_TYPE",
	1: "MINIKUBE",
	2: "GKE",
	3: "OTHER",
}

var ClusterType_value = map[string]int32{
	"UNKNOWN_CLUSTER_TYPE": 0,
	"MINIKUBE":             1,
	"GKE":                  2,
	"OTHER":                3,
}

func (x ClusterType) String() string {
	return proto.EnumName(ClusterType_name, int32(x))
}

func (ClusterType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{3}
}

// Enum for Status codes
// These error codes are prepended by Phase Name e.g.
// BUILD, DEPLOY, STATUSCHECK, DEVINIT
type StatusCode int32

const (
	// Could not determine error and phase
	StatusCode_UNKNOWN_ERROR StatusCode = 0
	// Status Check Success
	StatusCode_STATUSCHECK_SUCCESS StatusCode = 200
	// Build Success
	StatusCode_BUILD_SUCCESS StatusCode = 201
	// Build error due to push access denied
	StatusCode_BUILD_PUSH_ACCESS_DENIED StatusCode = 101
	// Build error due to GCP project not found.
	StatusCode_BUILD_PROJECT_NOT_FOUND StatusCode = 102
	// Container image pull error
	StatusCode_STATUSCHECK_IMAGE_PULL_ERR StatusCode = 300
	// Container creating error
	StatusCode_STATUSCHECK_CONTAINER_CREATING StatusCode = 301
	// Container run error
	StatusCode_STATUSCHECK_RUN_CONTAINER_ERR StatusCode = 302
	// Container is already terminated
	StatusCode_STATUSCHECK_CONTAINER_TERMINATED StatusCode = 303
	// Container restarting error
	StatusCode_STATUSCHECK_CONTAINER_RESTARTING StatusCode = 356
	// Node memory pressure error
	StatusCode_STATUSCHECK_NODE_MEMORY_PRESSURE StatusCode = 400
	// Node disk pressure error
	StatusCode_STATUSCHECK_NODE_DISK_PRESSURE StatusCode = 401
	// Node network unavailable error
	StatusCode_STATUSCHECK_NODE_NETWORK_UNAVAILABLE StatusCode = 402
	// Node PID pressure error
	StatusCode_STATUSCHECK_NODE_PID_PRESSURE StatusCode = 403
	// Node unschedulable error
	StatusCode_STATUSCHECK_NODE_UNSCHEDULABLE StatusCode = 404
	// Node unreachable error
	StatusCode_STATUSCHECK_NODE_UNREACHABLE StatusCode = 405
	// Node not ready error
	StatusCode_STATUSCHECK_NODE_NOT_READY StatusCode = 406
	// Status Check error unknown
	StatusCode_STATUSCHECK_UNKNOWN StatusCode = 501
	// Container is unschedulable due to unknown reasons
	StatusCode_STATUSCHECK_UNKNOWN_UNSCHEDULABLE StatusCode = 502
	// Container is waiting due to unknown reason
	StatusCode_STATUSCHECK_CONTAINER_WAITING_UNKNOWN StatusCode = 503
	// Deploy failed due to unknown reason
	StatusCode_DEPLOY_UNKNOWN StatusCode = 504
	// SYNC failed due to known reason
	StatusCode_SYNC_UNKNOWN StatusCode = 505
	// Build failed due to unknown reason
	StatusCode_BUILD_UNKNOWN StatusCode = 506
	// Dev Init failed due to unknown reason
	StatusCode_DEVINIT_UNKNOWN StatusCode = 507
	// Cleanup failed due to unknown reason
	StatusCode_CLEANUP_UNKNOWN StatusCode = 508
	// File Sync Initialize failure
	StatusCode_SYNC_INIT_ERROR StatusCode = 601
	// Failed to configure watcher for build dependencies in dev loop
	StatusCode_DEVINIT_REGISTER_BUILD_DEPS StatusCode = 701
	// Failed to configure watcher for test dependencies in dev loop
	StatusCode_DEVINIT_REGISTER_TEST_DEPS StatusCode = 702
	// Failed to configure watcher for deploy dependencies in dev loop
	StatusCode_DEVINIT_REGISTER_DEPLOY_DEPS StatusCode = 703
	// Failed to configure watcher for Skaffold configuration file.
	StatusCode_DEVINIT_REGISTER_CONFIG_DEP StatusCode = 704
)

var StatusCode_name = map[int32]string{
	0:   "UNKNOWN_ERROR",
	200: "STATUSCHECK_SUCCESS",
	201: "BUILD_SUCCESS",
	101: "BUILD_PUSH_ACCESS_DENIED",
	102: "BUILD_PROJECT_NOT_FOUND",
	300: "STATUSCHECK_IMAGE_PULL_ERR",
	301: "STATUSCHECK_CONTAINER_CREATING",
	302: "STATUSCHECK_RUN_CONTAINER_ERR",
	303: "STATUSCHECK_CONTAINER_TERMINATED",
	356: "STATUSCHECK_CONTAINER_RESTARTING",
	400: "STATUSCHECK_NODE_MEMORY_PRESSURE",
	401: "STATUSCHECK_NODE_DISK_PRESSURE",
	402: "STATUSCHECK_NODE_NETWORK_UNAVAILABLE",
	403: "STATUSCHECK_NODE_PID_PRESSURE",
	404: "STATUSCHECK_NODE_UNSCHEDULABLE",
	405: "STATUSCHECK_NODE_UNREACHABLE",
	406: "STATUSCHECK_NODE_NOT_READY",
	501: "STATUSCHECK_UNKNOWN",
	502: "STATUSCHECK_UNKNOWN_UNSCHEDULABLE",
	503: "STATUSCHECK_CONTAINER_WAITING_UNKNOWN",
	504: "DEPLOY_UNKNOWN",
	505: "SYNC_UNKNOWN",
	506: "BUILD_UNKNOWN",
	507: "DEVINIT_UNKNOWN",
	508: "CLEANUP_UNKNOWN",
	601: "SYNC_INIT_ERROR",
	701: "DEVINIT_REGISTER_BUILD_DEPS",
	702: "DEVINIT_REGISTER_TEST_DEPS",
	703: "DEVINIT_REGISTER_DEPLOY_DEPS",
	704: "DEVINIT_REGISTER_CONFIG_DEP",
}

var StatusCode_value = map[string]int32{
	"UNKNOWN_ERROR":                         0,
	"STATUSCHECK_SUCCESS":                   200,
	"BUILD_SUCCESS":                         201,
	"BUILD_PUSH_ACCESS_DENIED":              101,
	"BUILD_PROJECT_NOT_FOUND":               102,
	"STATUSCHECK_IMAGE_PULL_ERR":            300,
	"STATUSCHECK_CONTAINER_CREATING":        301,
	"STATUSCHECK_RUN_CONTAINER_ERR":         302,
	"STATUSCHECK_CONTAINER_TERMINATED":      303,
	"STATUSCHECK_CONTAINER_RESTARTING":      356,
	"STATUSCHECK_NODE_MEMORY_PRESSURE":      400,
	"STATUSCHECK_NODE_DISK_PRESSURE":        401,
	"STATUSCHECK_NODE_NETWORK_UNAVAILABLE":  402,
	"STATUSCHECK_NODE_PID_PRESSURE":         403,
	"STATUSCHECK_NODE_UNSCHEDULABLE":        404,
	"STATUSCHECK_NODE_UNREACHABLE":          405,
	"STATUSCHECK_NODE_NOT_READY":            406,
	"STATUSCHECK_UNKNOWN":                   501,
	"STATUSCHECK_UNKNOWN_UNSCHEDULABLE":     502,
	"STATUSCHECK_CONTAINER_WAITING_UNKNOWN": 503,
	"DEPLOY_UNKNOWN":                        504,
	"SYNC_UNKNOWN":                          505,
	"BUILD_UNKNOWN":                         506,
	"DEVINIT_UNKNOWN":                       507,
	"CLEANUP_UNKNOWN":                       508,
	"SYNC_INIT_ERROR":                       601,
	"DEVINIT_REGISTER_BUILD_DEPS":           701,
	"DEVINIT_REGISTER_TEST_DEPS":            702,
	"DEVINIT_REGISTER_DEPLOY_DEPS":          703,
	"DEVINIT_REGISTER_CONFIG_DEP":           704,
}

func (x StatusCode) String() string {
	return proto.EnumName(StatusCode_name, int32(x))
}

func (StatusCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{4}
}

type StateResponse struct {
	State                *State   `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateResponse) Reset()         { *m = StateResponse{} }
func (m *StateResponse) String() string { return proto.CompactTextString(m) }
func (*StateResponse) ProtoMessage()    {}
func (*StateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{0}
}

func (m *StateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateResponse.Unmarshal(m, b)
}
func (m *StateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateResponse.Marshal(b, m, deterministic)
}
func (m *StateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateResponse.Merge(m, src)
}
func (m *StateResponse) XXX_Size() int {
	return xxx_messageInfo_StateResponse.Size(m)
}
func (m *StateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateResponse proto.InternalMessageInfo

func (m *StateResponse) GetState() *State {
	if m != nil {
		return m.State
	}
	return nil
}

type Response struct {
	Msg                  string   `protobuf:"bytes,1,opt,name=msg,proto3" json:"msg,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Response) Reset()         { *m = Response{} }
func (m *Response) String() string { return proto.CompactTextString(m) }
func (*Response) ProtoMessage()    {}
func (*Response) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{1}
}

func (m *Response) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Response.Unmarshal(m, b)
}
func (m *Response) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Response.Marshal(b, m, deterministic)
}
func (m *Response) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Response.Merge(m, src)
}
func (m *Response) XXX_Size() int {
	return xxx_messageInfo_Response.Size(m)
}
func (m *Response) XXX_DiscardUnknown() {
	xxx_messageInfo_Response.DiscardUnknown(m)
}

var xxx_messageInfo_Response proto.InternalMessageInfo

func (m *Response) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

type Request struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Request) Reset()         { *m = Request{} }
func (m *Request) String() string { return proto.CompactTextString(m) }
func (*Request) ProtoMessage()    {}
func (*Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{2}
}

func (m *Request) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Request.Unmarshal(m, b)
}
func (m *Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Request.Marshal(b, m, deterministic)
}
func (m *Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Request.Merge(m, src)
}
func (m *Request) XXX_Size() int {
	return xxx_messageInfo_Request.Size(m)
}
func (m *Request) XXX_DiscardUnknown() {
	xxx_messageInfo_Request.DiscardUnknown(m)
}

var xxx_messageInfo_Request proto.InternalMessageInfo

func (m *Request) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// `State` represents the current state of the Skaffold components
type State struct {
	BuildState           *BuildState                `protobuf:"bytes,1,opt,name=buildState,proto3" json:"buildState,omitempty"`
	DeployState          *DeployState               `protobuf:"bytes,2,opt,name=deployState,proto3" json:"deployState,omitempty"`
	ForwardedPorts       map[int32]*PortEvent       `protobuf:"bytes,4,rep,name=forwardedPorts,proto3" json:"forwardedPorts,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	StatusCheckState     *StatusCheckState          `protobuf:"bytes,5,opt,name=statusCheckState,proto3" json:"statusCheckState,omitempty"`
	FileSyncState        *FileSyncState             `protobuf:"bytes,6,opt,name=fileSyncState,proto3" json:"fileSyncState,omitempty"`
	DebuggingContainers  []*DebuggingContainerEvent `protobuf:"bytes,7,rep,name=debuggingContainers,proto3" json:"debuggingContainers,omitempty"`
	Metadata             *Metadata                  `protobuf:"bytes,8,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *State) Reset()         { *m = State{} }
func (m *State) String() string { return proto.CompactTextString(m) }
func (*State) ProtoMessage()    {}
func (*State) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{3}
}

func (m *State) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_State.Unmarshal(m, b)
}
func (m *State) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_State.Marshal(b, m, deterministic)
}
func (m *State) XXX_Merge(src proto.Message) {
	xxx_messageInfo_State.Merge(m, src)
}
func (m *State) XXX_Size() int {
	return xxx_messageInfo_State.Size(m)
}
func (m *State) XXX_DiscardUnknown() {
	xxx_messageInfo_State.DiscardUnknown(m)
}

var xxx_messageInfo_State proto.InternalMessageInfo

func (m *State) GetBuildState() *BuildState {
	if m != nil {
		return m.BuildState
	}
	return nil
}

func (m *State) GetDeployState() *DeployState {
	if m != nil {
		return m.DeployState
	}
	return nil
}

func (m *State) GetForwardedPorts() map[int32]*PortEvent {
	if m != nil {
		return m.ForwardedPorts
	}
	return nil
}

func (m *State) GetStatusCheckState() *StatusCheckState {
	if m != nil {
		return m.StatusCheckState
	}
	return nil
}

func (m *State) GetFileSyncState() *FileSyncState {
	if m != nil {
		return m.FileSyncState
	}
	return nil
}

func (m *State) GetDebuggingContainers() []*DebuggingContainerEvent {
	if m != nil {
		return m.DebuggingContainers
	}
	return nil
}

func (m *State) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

type Metadata struct {
	Build  *BuildMetadata  `protobuf:"bytes,1,opt,name=build,proto3" json:"build,omitempty"`
	Deploy *DeployMetadata `protobuf:"bytes,2,opt,name=deploy,proto3" json:"deploy,omitempty"`
	// Additional key value pairs to describe the build pipeline
	Additional           map[string]string `protobuf:"bytes,99,rep,name=additional,proto3" json:"additional,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Metadata) Reset()         { *m = Metadata{} }
func (m *Metadata) String() string { return proto.CompactTextString(m) }
func (*Metadata) ProtoMessage()    {}
func (*Metadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{4}
}

func (m *Metadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metadata.Unmarshal(m, b)
}
func (m *Metadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metadata.Marshal(b, m, deterministic)
}
func (m *Metadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metadata.Merge(m, src)
}
func (m *Metadata) XXX_Size() int {
	return xxx_messageInfo_Metadata.Size(m)
}
func (m *Metadata) XXX_DiscardUnknown() {
	xxx_messageInfo_Metadata.DiscardUnknown(m)
}

var xxx_messageInfo_Metadata proto.InternalMessageInfo

func (m *Metadata) GetBuild() *BuildMetadata {
	if m != nil {
		return m.Build
	}
	return nil
}

func (m *Metadata) GetDeploy() *DeployMetadata {
	if m != nil {
		return m.Deploy
	}
	return nil
}

func (m *Metadata) GetAdditional() map[string]string {
	if m != nil {
		return m.Additional
	}
	return nil
}

type BuildMetadata struct {
	NumberOfArtifacts int32                         `protobuf:"varint,1,opt,name=numberOfArtifacts,proto3" json:"numberOfArtifacts,omitempty"`
	Builders          []*BuildMetadata_ImageBuilder `protobuf:"bytes,2,rep,name=builders,proto3" json:"builders,omitempty"`
	Type              BuildType                     `protobuf:"varint,3,opt,name=type,proto3,enum=proto.BuildType" json:"type,omitempty"`
	// Additional key value pairs to describe the deploy pipeline
	Additional           map[string]string `protobuf:"bytes,99,rep,name=additional,proto3" json:"additional,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *BuildMetadata) Reset()         { *m = BuildMetadata{} }
func (m *BuildMetadata) String() string { return proto.CompactTextString(m) }
func (*BuildMetadata) ProtoMessage()    {}
func (*BuildMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{5}
}

func (m *BuildMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildMetadata.Unmarshal(m, b)
}
func (m *BuildMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildMetadata.Marshal(b, m, deterministic)
}
func (m *BuildMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildMetadata.Merge(m, src)
}
func (m *BuildMetadata) XXX_Size() int {
	return xxx_messageInfo_BuildMetadata.Size(m)
}
func (m *BuildMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_BuildMetadata proto.InternalMessageInfo

func (m *BuildMetadata) GetNumberOfArtifacts() int32 {
	if m != nil {
		return m.NumberOfArtifacts
	}
	return 0
}

func (m *BuildMetadata) GetBuilders() []*BuildMetadata_ImageBuilder {
	if m != nil {
		return m.Builders
	}
	return nil
}

func (m *BuildMetadata) GetType() BuildType {
	if m != nil {
		return m.Type
	}
	return BuildType_UNKNOWN_BUILD_TYPE
}

func (m *BuildMetadata) GetAdditional() map[string]string {
	if m != nil {
		return m.Additional
	}
	return nil
}

type BuildMetadata_ImageBuilder struct {
	Type                 BuilderType `protobuf:"varint,1,opt,name=type,proto3,enum=proto.BuilderType" json:"type,omitempty"`
	Count                int32       `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *BuildMetadata_ImageBuilder) Reset()         { *m = BuildMetadata_ImageBuilder{} }
func (m *BuildMetadata_ImageBuilder) String() string { return proto.CompactTextString(m) }
func (*BuildMetadata_ImageBuilder) ProtoMessage()    {}
func (*BuildMetadata_ImageBuilder) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{5, 0}
}

func (m *BuildMetadata_ImageBuilder) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildMetadata_ImageBuilder.Unmarshal(m, b)
}
func (m *BuildMetadata_ImageBuilder) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildMetadata_ImageBuilder.Marshal(b, m, deterministic)
}
func (m *BuildMetadata_ImageBuilder) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildMetadata_ImageBuilder.Merge(m, src)
}
func (m *BuildMetadata_ImageBuilder) XXX_Size() int {
	return xxx_messageInfo_BuildMetadata_ImageBuilder.Size(m)
}
func (m *BuildMetadata_ImageBuilder) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildMetadata_ImageBuilder.DiscardUnknown(m)
}

var xxx_messageInfo_BuildMetadata_ImageBuilder proto.InternalMessageInfo

func (m *BuildMetadata_ImageBuilder) GetType() BuilderType {
	if m != nil {
		return m.Type
	}
	return BuilderType_UNKNOWN_BUILDER_TYPE
}

func (m *BuildMetadata_ImageBuilder) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

type DeployMetadata struct {
	Deployers            []*DeployMetadata_Deployer `protobuf:"bytes,1,rep,name=deployers,proto3" json:"deployers,omitempty"`
	Cluster              ClusterType                `protobuf:"varint,2,opt,name=cluster,proto3,enum=proto.ClusterType" json:"cluster,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *DeployMetadata) Reset()         { *m = DeployMetadata{} }
func (m *DeployMetadata) String() string { return proto.CompactTextString(m) }
func (*DeployMetadata) ProtoMessage()    {}
func (*DeployMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{6}
}

func (m *DeployMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployMetadata.Unmarshal(m, b)
}
func (m *DeployMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployMetadata.Marshal(b, m, deterministic)
}
func (m *DeployMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployMetadata.Merge(m, src)
}
func (m *DeployMetadata) XXX_Size() int {
	return xxx_messageInfo_DeployMetadata.Size(m)
}
func (m *DeployMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeployMetadata proto.InternalMessageInfo

func (m *DeployMetadata) GetDeployers() []*DeployMetadata_Deployer {
	if m != nil {
		return m.Deployers
	}
	return nil
}

func (m *DeployMetadata) GetCluster() ClusterType {
	if m != nil {
		return m.Cluster
	}
	return ClusterType_UNKNOWN_CLUSTER_TYPE
}

type DeployMetadata_Deployer struct {
	Type                 DeployerType `protobuf:"varint,1,opt,name=type,proto3,enum=proto.DeployerType" json:"type,omitempty"`
	Count                int32        `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *DeployMetadata_Deployer) Reset()         { *m = DeployMetadata_Deployer{} }
func (m *DeployMetadata_Deployer) String() string { return proto.CompactTextString(m) }
func (*DeployMetadata_Deployer) ProtoMessage()    {}
func (*DeployMetadata_Deployer) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{6, 0}
}

func (m *DeployMetadata_Deployer) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployMetadata_Deployer.Unmarshal(m, b)
}
func (m *DeployMetadata_Deployer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployMetadata_Deployer.Marshal(b, m, deterministic)
}
func (m *DeployMetadata_Deployer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployMetadata_Deployer.Merge(m, src)
}
func (m *DeployMetadata_Deployer) XXX_Size() int {
	return xxx_messageInfo_DeployMetadata_Deployer.Size(m)
}
func (m *DeployMetadata_Deployer) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployMetadata_Deployer.DiscardUnknown(m)
}

var xxx_messageInfo_DeployMetadata_Deployer proto.InternalMessageInfo

func (m *DeployMetadata_Deployer) GetType() DeployerType {
	if m != nil {
		return m.Type
	}
	return DeployerType_UNKNOWN_DEPLOYER_TYPE
}

func (m *DeployMetadata_Deployer) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

// `BuildState` maps Skaffold artifacts to their current build states
type BuildState struct {
	// A map of `artifact name -> build-state`.
	// Artifact name is defined in the `skaffold.yaml`.
	// The `build-state` can be: <br>
	// - `"Not started"`: not yet started <br>
	// - `"In progress"`: build started <br>
	// - `"Complete"`: build succeeded <br>
	// - `"Failed"`: build failed
	Artifacts            map[string]string `protobuf:"bytes,1,rep,name=artifacts,proto3" json:"artifacts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *BuildState) Reset()         { *m = BuildState{} }
func (m *BuildState) String() string { return proto.CompactTextString(m) }
func (*BuildState) ProtoMessage()    {}
func (*BuildState) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{7}
}

func (m *BuildState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildState.Unmarshal(m, b)
}
func (m *BuildState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildState.Marshal(b, m, deterministic)
}
func (m *BuildState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildState.Merge(m, src)
}
func (m *BuildState) XXX_Size() int {
	return xxx_messageInfo_BuildState.Size(m)
}
func (m *BuildState) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildState.DiscardUnknown(m)
}

var xxx_messageInfo_BuildState proto.InternalMessageInfo

func (m *BuildState) GetArtifacts() map[string]string {
	if m != nil {
		return m.Artifacts
	}
	return nil
}

// `DeployState` describes the status of the current deploy
type DeployState struct {
	Status               string   `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeployState) Reset()         { *m = DeployState{} }
func (m *DeployState) String() string { return proto.CompactTextString(m) }
func (*DeployState) ProtoMessage()    {}
func (*DeployState) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{8}
}

func (m *DeployState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployState.Unmarshal(m, b)
}
func (m *DeployState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployState.Marshal(b, m, deterministic)
}
func (m *DeployState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployState.Merge(m, src)
}
func (m *DeployState) XXX_Size() int {
	return xxx_messageInfo_DeployState.Size(m)
}
func (m *DeployState) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployState.DiscardUnknown(m)
}

var xxx_messageInfo_DeployState proto.InternalMessageInfo

func (m *DeployState) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

// `StatusCheckState` describes the state of status check of current deployed resources.
type StatusCheckState struct {
	Status string `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// A map of `resource name -> status-check-state`. Where `resource-name` is the kubernetes resource name.
	// The `status-check-state` can be <br>
	// - `"Not started"`: indicates that `status-check` has just started. <br>
	// - `"In progress"`: InProgress is sent after every resource check is complete. <br>
	// - `"Succeeded"`:
	// - `"Failed"`:
	Resources            map[string]string `protobuf:"bytes,2,rep,name=resources,proto3" json:"resources,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *StatusCheckState) Reset()         { *m = StatusCheckState{} }
func (m *StatusCheckState) String() string { return proto.CompactTextString(m) }
func (*StatusCheckState) ProtoMessage()    {}
func (*StatusCheckState) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{9}
}

func (m *StatusCheckState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StatusCheckState.Unmarshal(m, b)
}
func (m *StatusCheckState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StatusCheckState.Marshal(b, m, deterministic)
}
func (m *StatusCheckState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatusCheckState.Merge(m, src)
}
func (m *StatusCheckState) XXX_Size() int {
	return xxx_messageInfo_StatusCheckState.Size(m)
}
func (m *StatusCheckState) XXX_DiscardUnknown() {
	xxx_messageInfo_StatusCheckState.DiscardUnknown(m)
}

var xxx_messageInfo_StatusCheckState proto.InternalMessageInfo

func (m *StatusCheckState) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *StatusCheckState) GetResources() map[string]string {
	if m != nil {
		return m.Resources
	}
	return nil
}

// `FileSyncState` contains the status of the current file sync
type FileSyncState struct {
	Status               string   `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FileSyncState) Reset()         { *m = FileSyncState{} }
func (m *FileSyncState) String() string { return proto.CompactTextString(m) }
func (*FileSyncState) ProtoMessage()    {}
func (*FileSyncState) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{10}
}

func (m *FileSyncState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FileSyncState.Unmarshal(m, b)
}
func (m *FileSyncState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FileSyncState.Marshal(b, m, deterministic)
}
func (m *FileSyncState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileSyncState.Merge(m, src)
}
func (m *FileSyncState) XXX_Size() int {
	return xxx_messageInfo_FileSyncState.Size(m)
}
func (m *FileSyncState) XXX_DiscardUnknown() {
	xxx_messageInfo_FileSyncState.DiscardUnknown(m)
}

var xxx_messageInfo_FileSyncState proto.InternalMessageInfo

func (m *FileSyncState) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

// `Event` describes an event in the Skaffold process.
// It is one of MetaEvent, BuildEvent, DeployEvent, PortEvent, StatusCheckEvent, ResourceStatusCheckEvent, FileSyncEvent, or DebuggingContainerEvent.
type Event struct {
	// Types that are valid to be assigned to EventType:
	//	*Event_MetaEvent
	//	*Event_BuildEvent
	//	*Event_DeployEvent
	//	*Event_PortEvent
	//	*Event_StatusCheckEvent
	//	*Event_ResourceStatusCheckEvent
	//	*Event_FileSyncEvent
	//	*Event_DebuggingContainerEvent
	//	*Event_DevLoopEvent
	EventType            isEvent_EventType `protobuf_oneof:"event_type"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{11}
}

func (m *Event) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Event.Unmarshal(m, b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Event.Marshal(b, m, deterministic)
}
func (m *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(m, src)
}
func (m *Event) XXX_Size() int {
	return xxx_messageInfo_Event.Size(m)
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

type isEvent_EventType interface {
	isEvent_EventType()
}

type Event_MetaEvent struct {
	MetaEvent *MetaEvent `protobuf:"bytes,1,opt,name=metaEvent,proto3,oneof"`
}

type Event_BuildEvent struct {
	BuildEvent *BuildEvent `protobuf:"bytes,2,opt,name=buildEvent,proto3,oneof"`
}

type Event_DeployEvent struct {
	DeployEvent *DeployEvent `protobuf:"bytes,3,opt,name=deployEvent,proto3,oneof"`
}

type Event_PortEvent struct {
	PortEvent *PortEvent `protobuf:"bytes,4,opt,name=portEvent,proto3,oneof"`
}

type Event_StatusCheckEvent struct {
	StatusCheckEvent *StatusCheckEvent `protobuf:"bytes,5,opt,name=statusCheckEvent,proto3,oneof"`
}

type Event_ResourceStatusCheckEvent struct {
	ResourceStatusCheckEvent *ResourceStatusCheckEvent `protobuf:"bytes,6,opt,name=resourceStatusCheckEvent,proto3,oneof"`
}

type Event_FileSyncEvent struct {
	FileSyncEvent *FileSyncEvent `protobuf:"bytes,7,opt,name=fileSyncEvent,proto3,oneof"`
}

type Event_DebuggingContainerEvent struct {
	DebuggingContainerEvent *DebuggingContainerEvent `protobuf:"bytes,8,opt,name=debuggingContainerEvent,proto3,oneof"`
}

type Event_DevLoopEvent struct {
	DevLoopEvent *DevLoopEvent `protobuf:"bytes,9,opt,name=devLoopEvent,proto3,oneof"`
}

func (*Event_MetaEvent) isEvent_EventType() {}

func (*Event_BuildEvent) isEvent_EventType() {}

func (*Event_DeployEvent) isEvent_EventType() {}

func (*Event_PortEvent) isEvent_EventType() {}

func (*Event_StatusCheckEvent) isEvent_EventType() {}

func (*Event_ResourceStatusCheckEvent) isEvent_EventType() {}

func (*Event_FileSyncEvent) isEvent_EventType() {}

func (*Event_DebuggingContainerEvent) isEvent_EventType() {}

func (*Event_DevLoopEvent) isEvent_EventType() {}

func (m *Event) GetEventType() isEvent_EventType {
	if m != nil {
		return m.EventType
	}
	return nil
}

func (m *Event) GetMetaEvent() *MetaEvent {
	if x, ok := m.GetEventType().(*Event_MetaEvent); ok {
		return x.MetaEvent
	}
	return nil
}

func (m *Event) GetBuildEvent() *BuildEvent {
	if x, ok := m.GetEventType().(*Event_BuildEvent); ok {
		return x.BuildEvent
	}
	return nil
}

func (m *Event) GetDeployEvent() *DeployEvent {
	if x, ok := m.GetEventType().(*Event_DeployEvent); ok {
		return x.DeployEvent
	}
	return nil
}

func (m *Event) GetPortEvent() *PortEvent {
	if x, ok := m.GetEventType().(*Event_PortEvent); ok {
		return x.PortEvent
	}
	return nil
}

func (m *Event) GetStatusCheckEvent() *StatusCheckEvent {
	if x, ok := m.GetEventType().(*Event_StatusCheckEvent); ok {
		return x.StatusCheckEvent
	}
	return nil
}

func (m *Event) GetResourceStatusCheckEvent() *ResourceStatusCheckEvent {
	if x, ok := m.GetEventType().(*Event_ResourceStatusCheckEvent); ok {
		return x.ResourceStatusCheckEvent
	}
	return nil
}

func (m *Event) GetFileSyncEvent() *FileSyncEvent {
	if x, ok := m.GetEventType().(*Event_FileSyncEvent); ok {
		return x.FileSyncEvent
	}
	return nil
}

func (m *Event) GetDebuggingContainerEvent() *DebuggingContainerEvent {
	if x, ok := m.GetEventType().(*Event_DebuggingContainerEvent); ok {
		return x.DebuggingContainerEvent
	}
	return nil
}

func (m *Event) GetDevLoopEvent() *DevLoopEvent {
	if x, ok := m.GetEventType().(*Event_DevLoopEvent); ok {
		return x.DevLoopEvent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Event) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Event_MetaEvent)(nil),
		(*Event_BuildEvent)(nil),
		(*Event_DeployEvent)(nil),
		(*Event_PortEvent)(nil),
		(*Event_StatusCheckEvent)(nil),
		(*Event_ResourceStatusCheckEvent)(nil),
		(*Event_FileSyncEvent)(nil),
		(*Event_DebuggingContainerEvent)(nil),
		(*Event_DevLoopEvent)(nil),
	}
}

// `DevLoopEvent` marks the start and end of a dev loop.
type DevLoopEvent struct {
	Iteration            int32    `protobuf:"varint,1,opt,name=iteration,proto3" json:"iteration,omitempty"`
	Status               string   `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	Err                  *ErrDef  `protobuf:"bytes,3,opt,name=err,proto3" json:"err,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DevLoopEvent) Reset()         { *m = DevLoopEvent{} }
func (m *DevLoopEvent) String() string { return proto.CompactTextString(m) }
func (*DevLoopEvent) ProtoMessage()    {}
func (*DevLoopEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{12}
}

func (m *DevLoopEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DevLoopEvent.Unmarshal(m, b)
}
func (m *DevLoopEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DevLoopEvent.Marshal(b, m, deterministic)
}
func (m *DevLoopEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DevLoopEvent.Merge(m, src)
}
func (m *DevLoopEvent) XXX_Size() int {
	return xxx_messageInfo_DevLoopEvent.Size(m)
}
func (m *DevLoopEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_DevLoopEvent.DiscardUnknown(m)
}

var xxx_messageInfo_DevLoopEvent proto.InternalMessageInfo

func (m *DevLoopEvent) GetIteration() int32 {
	if m != nil {
		return m.Iteration
	}
	return 0
}

func (m *DevLoopEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *DevLoopEvent) GetErr() *ErrDef {
	if m != nil {
		return m.Err
	}
	return nil
}

// `ErrDef` defines an error occurred along with an optional suggestions
type ErrDef struct {
	ErrCode              StatusCode `protobuf:"varint,1,opt,name=errCode,proto3,enum=proto.StatusCode" json:"errCode,omitempty"`
	Message              string     `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ErrDef) Reset()         { *m = ErrDef{} }
func (m *ErrDef) String() string { return proto.CompactTextString(m) }
func (*ErrDef) ProtoMessage()    {}
func (*ErrDef) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{13}
}

func (m *ErrDef) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ErrDef.Unmarshal(m, b)
}
func (m *ErrDef) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ErrDef.Marshal(b, m, deterministic)
}
func (m *ErrDef) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ErrDef.Merge(m, src)
}
func (m *ErrDef) XXX_Size() int {
	return xxx_messageInfo_ErrDef.Size(m)
}
func (m *ErrDef) XXX_DiscardUnknown() {
	xxx_messageInfo_ErrDef.DiscardUnknown(m)
}

var xxx_messageInfo_ErrDef proto.InternalMessageInfo

func (m *ErrDef) GetErrCode() StatusCode {
	if m != nil {
		return m.ErrCode
	}
	return StatusCode_UNKNOWN_ERROR
}

func (m *ErrDef) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// `MetaEvent` provides general information regarding Skaffold
type MetaEvent struct {
	// entry, for example: `"Starting Skaffold: {Version:v0.39.0-16-g5bb7c9e0 ConfigVersion:skaffold/v1 GitVersion: GitCommit:5bb7c9e078e4d522a5ffc42a2f1274fd17d75902 GitTreeState:dirty BuildDate01:29Z GoVersion:go1.13rc1 Compiler:gc Platform:linux/amd64}"`
	Entry string `protobuf:"bytes,1,opt,name=entry,proto3" json:"entry,omitempty"`
	// Metadata describing skaffold pipeline
	Metadata             *Metadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *MetaEvent) Reset()         { *m = MetaEvent{} }
func (m *MetaEvent) String() string { return proto.CompactTextString(m) }
func (*MetaEvent) ProtoMessage()    {}
func (*MetaEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{14}
}

func (m *MetaEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetaEvent.Unmarshal(m, b)
}
func (m *MetaEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetaEvent.Marshal(b, m, deterministic)
}
func (m *MetaEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetaEvent.Merge(m, src)
}
func (m *MetaEvent) XXX_Size() int {
	return xxx_messageInfo_MetaEvent.Size(m)
}
func (m *MetaEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_MetaEvent.DiscardUnknown(m)
}

var xxx_messageInfo_MetaEvent proto.InternalMessageInfo

func (m *MetaEvent) GetEntry() string {
	if m != nil {
		return m.Entry
	}
	return ""
}

func (m *MetaEvent) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// `BuildEvent` describes the build status per artifact, and will be emitted by Skaffold anytime a build starts or finishes, successfully or not.
// If the build fails, an error will be attached to the event.
type BuildEvent struct {
	Artifact             string     `protobuf:"bytes,1,opt,name=artifact,proto3" json:"artifact,omitempty"`
	Status               string     `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	Err                  string     `protobuf:"bytes,3,opt,name=err,proto3" json:"err,omitempty"`
	ErrCode              StatusCode `protobuf:"varint,4,opt,name=errCode,proto3,enum=proto.StatusCode" json:"errCode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *BuildEvent) Reset()         { *m = BuildEvent{} }
func (m *BuildEvent) String() string { return proto.CompactTextString(m) }
func (*BuildEvent) ProtoMessage()    {}
func (*BuildEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{15}
}

func (m *BuildEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildEvent.Unmarshal(m, b)
}
func (m *BuildEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildEvent.Marshal(b, m, deterministic)
}
func (m *BuildEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildEvent.Merge(m, src)
}
func (m *BuildEvent) XXX_Size() int {
	return xxx_messageInfo_BuildEvent.Size(m)
}
func (m *BuildEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildEvent.DiscardUnknown(m)
}

var xxx_messageInfo_BuildEvent proto.InternalMessageInfo

func (m *BuildEvent) GetArtifact() string {
	if m != nil {
		return m.Artifact
	}
	return ""
}

func (m *BuildEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *BuildEvent) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

func (m *BuildEvent) GetErrCode() StatusCode {
	if m != nil {
		return m.ErrCode
	}
	return StatusCode_UNKNOWN_ERROR
}

// `DeployEvent` represents the status of a deployment, and is emitted by Skaffold
// anytime a deployment starts or completes, successfully or not.
type DeployEvent struct {
	Status               string     `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	Err                  string     `protobuf:"bytes,2,opt,name=err,proto3" json:"err,omitempty"`
	ErrCode              StatusCode `protobuf:"varint,3,opt,name=errCode,proto3,enum=proto.StatusCode" json:"errCode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *DeployEvent) Reset()         { *m = DeployEvent{} }
func (m *DeployEvent) String() string { return proto.CompactTextString(m) }
func (*DeployEvent) ProtoMessage()    {}
func (*DeployEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{16}
}

func (m *DeployEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployEvent.Unmarshal(m, b)
}
func (m *DeployEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployEvent.Marshal(b, m, deterministic)
}
func (m *DeployEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployEvent.Merge(m, src)
}
func (m *DeployEvent) XXX_Size() int {
	return xxx_messageInfo_DeployEvent.Size(m)
}
func (m *DeployEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployEvent.DiscardUnknown(m)
}

var xxx_messageInfo_DeployEvent proto.InternalMessageInfo

func (m *DeployEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *DeployEvent) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

func (m *DeployEvent) GetErrCode() StatusCode {
	if m != nil {
		return m.ErrCode
	}
	return StatusCode_UNKNOWN_ERROR
}

// `StatusCheckEvent` describes if the status check for kubernetes rollout has started, is in progress, has succeeded or failed.
type StatusCheckEvent struct {
	Status               string     `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	Message              string     `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	Err                  string     `protobuf:"bytes,3,opt,name=err,proto3" json:"err,omitempty"`
	ErrCode              StatusCode `protobuf:"varint,4,opt,name=errCode,proto3,enum=proto.StatusCode" json:"errCode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *StatusCheckEvent) Reset()         { *m = StatusCheckEvent{} }
func (m *StatusCheckEvent) String() string { return proto.CompactTextString(m) }
func (*StatusCheckEvent) ProtoMessage()    {}
func (*StatusCheckEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{17}
}

func (m *StatusCheckEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StatusCheckEvent.Unmarshal(m, b)
}
func (m *StatusCheckEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StatusCheckEvent.Marshal(b, m, deterministic)
}
func (m *StatusCheckEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatusCheckEvent.Merge(m, src)
}
func (m *StatusCheckEvent) XXX_Size() int {
	return xxx_messageInfo_StatusCheckEvent.Size(m)
}
func (m *StatusCheckEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_StatusCheckEvent.DiscardUnknown(m)
}

var xxx_messageInfo_StatusCheckEvent proto.InternalMessageInfo

func (m *StatusCheckEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *StatusCheckEvent) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *StatusCheckEvent) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

func (m *StatusCheckEvent) GetErrCode() StatusCode {
	if m != nil {
		return m.ErrCode
	}
	return StatusCode_UNKNOWN_ERROR
}

// A Resource StatusCheck Event, indicates progress for each kubernetes deployment.
// For every resource, there will be exactly one event with `status` *Succeeded* or *Failed* event.
// There can be multiple events with `status` *Pending*.
// Skaffold polls for resource status every 0.5 second. If the resource status changes, an event with `status` “Pending”, “Complete” and “Failed”
// will be sent with the new status.
type ResourceStatusCheckEvent struct {
	Resource             string   `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	Status               string   `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	Message              string   `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	Err                  string   `protobuf:"bytes,4,opt,name=err,proto3" json:"err,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResourceStatusCheckEvent) Reset()         { *m = ResourceStatusCheckEvent{} }
func (m *ResourceStatusCheckEvent) String() string { return proto.CompactTextString(m) }
func (*ResourceStatusCheckEvent) ProtoMessage()    {}
func (*ResourceStatusCheckEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{18}
}

func (m *ResourceStatusCheckEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResourceStatusCheckEvent.Unmarshal(m, b)
}
func (m *ResourceStatusCheckEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResourceStatusCheckEvent.Marshal(b, m, deterministic)
}
func (m *ResourceStatusCheckEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceStatusCheckEvent.Merge(m, src)
}
func (m *ResourceStatusCheckEvent) XXX_Size() int {
	return xxx_messageInfo_ResourceStatusCheckEvent.Size(m)
}
func (m *ResourceStatusCheckEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceStatusCheckEvent.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceStatusCheckEvent proto.InternalMessageInfo

func (m *ResourceStatusCheckEvent) GetResource() string {
	if m != nil {
		return m.Resource
	}
	return ""
}

func (m *ResourceStatusCheckEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *ResourceStatusCheckEvent) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *ResourceStatusCheckEvent) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

// PortEvent Event describes each port forwarding event.
type PortEvent struct {
	LocalPort            int32    `protobuf:"varint,1,opt,name=localPort,proto3" json:"localPort,omitempty"`
	RemotePort           int32    `protobuf:"varint,2,opt,name=remotePort,proto3" json:"remotePort,omitempty"`
	PodName              string   `protobuf:"bytes,3,opt,name=podName,proto3" json:"podName,omitempty"`
	ContainerName        string   `protobuf:"bytes,4,opt,name=containerName,proto3" json:"containerName,omitempty"`
	Namespace            string   `protobuf:"bytes,5,opt,name=namespace,proto3" json:"namespace,omitempty"`
	PortName             string   `protobuf:"bytes,6,opt,name=portName,proto3" json:"portName,omitempty"`
	ResourceType         string   `protobuf:"bytes,7,opt,name=resourceType,proto3" json:"resourceType,omitempty"`
	ResourceName         string   `protobuf:"bytes,8,opt,name=resourceName,proto3" json:"resourceName,omitempty"`
	Address              string   `protobuf:"bytes,9,opt,name=address,proto3" json:"address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PortEvent) Reset()         { *m = PortEvent{} }
func (m *PortEvent) String() string { return proto.CompactTextString(m) }
func (*PortEvent) ProtoMessage()    {}
func (*PortEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{19}
}

func (m *PortEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PortEvent.Unmarshal(m, b)
}
func (m *PortEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PortEvent.Marshal(b, m, deterministic)
}
func (m *PortEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PortEvent.Merge(m, src)
}
func (m *PortEvent) XXX_Size() int {
	return xxx_messageInfo_PortEvent.Size(m)
}
func (m *PortEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_PortEvent.DiscardUnknown(m)
}

var xxx_messageInfo_PortEvent proto.InternalMessageInfo

func (m *PortEvent) GetLocalPort() int32 {
	if m != nil {
		return m.LocalPort
	}
	return 0
}

func (m *PortEvent) GetRemotePort() int32 {
	if m != nil {
		return m.RemotePort
	}
	return 0
}

func (m *PortEvent) GetPodName() string {
	if m != nil {
		return m.PodName
	}
	return ""
}

func (m *PortEvent) GetContainerName() string {
	if m != nil {
		return m.ContainerName
	}
	return ""
}

func (m *PortEvent) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *PortEvent) GetPortName() string {
	if m != nil {
		return m.PortName
	}
	return ""
}

func (m *PortEvent) GetResourceType() string {
	if m != nil {
		return m.ResourceType
	}
	return ""
}

func (m *PortEvent) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *PortEvent) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

// FileSyncEvent describes the sync status.
type FileSyncEvent struct {
	FileCount            int32      `protobuf:"varint,1,opt,name=fileCount,proto3" json:"fileCount,omitempty"`
	Image                string     `protobuf:"bytes,2,opt,name=image,proto3" json:"image,omitempty"`
	Status               string     `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	Err                  string     `protobuf:"bytes,4,opt,name=err,proto3" json:"err,omitempty"`
	ErrCode              StatusCode `protobuf:"varint,5,opt,name=errCode,proto3,enum=proto.StatusCode" json:"errCode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *FileSyncEvent) Reset()         { *m = FileSyncEvent{} }
func (m *FileSyncEvent) String() string { return proto.CompactTextString(m) }
func (*FileSyncEvent) ProtoMessage()    {}
func (*FileSyncEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{20}
}

func (m *FileSyncEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FileSyncEvent.Unmarshal(m, b)
}
func (m *FileSyncEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FileSyncEvent.Marshal(b, m, deterministic)
}
func (m *FileSyncEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileSyncEvent.Merge(m, src)
}
func (m *FileSyncEvent) XXX_Size() int {
	return xxx_messageInfo_FileSyncEvent.Size(m)
}
func (m *FileSyncEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_FileSyncEvent.DiscardUnknown(m)
}

var xxx_messageInfo_FileSyncEvent proto.InternalMessageInfo

func (m *FileSyncEvent) GetFileCount() int32 {
	if m != nil {
		return m.FileCount
	}
	return 0
}

func (m *FileSyncEvent) GetImage() string {
	if m != nil {
		return m.Image
	}
	return ""
}

func (m *FileSyncEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *FileSyncEvent) GetErr() string {
	if m != nil {
		return m.Err
	}
	return ""
}

func (m *FileSyncEvent) GetErrCode() StatusCode {
	if m != nil {
		return m.ErrCode
	}
	return StatusCode_UNKNOWN_ERROR
}

// DebuggingContainerEvent is raised when a debugging container is started or terminated
type DebuggingContainerEvent struct {
	Status               string            `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	PodName              string            `protobuf:"bytes,2,opt,name=podName,proto3" json:"podName,omitempty"`
	ContainerName        string            `protobuf:"bytes,3,opt,name=containerName,proto3" json:"containerName,omitempty"`
	Namespace            string            `protobuf:"bytes,4,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Artifact             string            `protobuf:"bytes,5,opt,name=artifact,proto3" json:"artifact,omitempty"`
	Runtime              string            `protobuf:"bytes,6,opt,name=runtime,proto3" json:"runtime,omitempty"`
	WorkingDir           string            `protobuf:"bytes,7,opt,name=workingDir,proto3" json:"workingDir,omitempty"`
	DebugPorts           map[string]uint32 `protobuf:"bytes,8,rep,name=debugPorts,proto3" json:"debugPorts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *DebuggingContainerEvent) Reset()         { *m = DebuggingContainerEvent{} }
func (m *DebuggingContainerEvent) String() string { return proto.CompactTextString(m) }
func (*DebuggingContainerEvent) ProtoMessage()    {}
func (*DebuggingContainerEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{21}
}

func (m *DebuggingContainerEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DebuggingContainerEvent.Unmarshal(m, b)
}
func (m *DebuggingContainerEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DebuggingContainerEvent.Marshal(b, m, deterministic)
}
func (m *DebuggingContainerEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebuggingContainerEvent.Merge(m, src)
}
func (m *DebuggingContainerEvent) XXX_Size() int {
	return xxx_messageInfo_DebuggingContainerEvent.Size(m)
}
func (m *DebuggingContainerEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_DebuggingContainerEvent.DiscardUnknown(m)
}

var xxx_messageInfo_DebuggingContainerEvent proto.InternalMessageInfo

func (m *DebuggingContainerEvent) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *DebuggingContainerEvent) GetPodName() string {
	if m != nil {
		return m.PodName
	}
	return ""
}

func (m *DebuggingContainerEvent) GetContainerName() string {
	if m != nil {
		return m.ContainerName
	}
	return ""
}

func (m *DebuggingContainerEvent) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *DebuggingContainerEvent) GetArtifact() string {
	if m != nil {
		return m.Artifact
	}
	return ""
}

func (m *DebuggingContainerEvent) GetRuntime() string {
	if m != nil {
		return m.Runtime
	}
	return ""
}

func (m *DebuggingContainerEvent) GetWorkingDir() string {
	if m != nil {
		return m.WorkingDir
	}
	return ""
}

func (m *DebuggingContainerEvent) GetDebugPorts() map[string]uint32 {
	if m != nil {
		return m.DebugPorts
	}
	return nil
}

// LogEntry describes an event and a string description of the event.
type LogEntry struct {
	Timestamp            *timestamp.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Event                *Event               `protobuf:"bytes,2,opt,name=event,proto3" json:"event,omitempty"`
	Entry                string               `protobuf:"bytes,3,opt,name=entry,proto3" json:"entry,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *LogEntry) Reset()         { *m = LogEntry{} }
func (m *LogEntry) String() string { return proto.CompactTextString(m) }
func (*LogEntry) ProtoMessage()    {}
func (*LogEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{22}
}

func (m *LogEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry.Unmarshal(m, b)
}
func (m *LogEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry.Marshal(b, m, deterministic)
}
func (m *LogEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry.Merge(m, src)
}
func (m *LogEntry) XXX_Size() int {
	return xxx_messageInfo_LogEntry.Size(m)
}
func (m *LogEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry proto.InternalMessageInfo

func (m *LogEntry) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *LogEntry) GetEvent() *Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *LogEntry) GetEntry() string {
	if m != nil {
		return m.Entry
	}
	return ""
}

type UserIntentRequest struct {
	Intent               *Intent  `protobuf:"bytes,1,opt,name=intent,proto3" json:"intent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UserIntentRequest) Reset()         { *m = UserIntentRequest{} }
func (m *UserIntentRequest) String() string { return proto.CompactTextString(m) }
func (*UserIntentRequest) ProtoMessage()    {}
func (*UserIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{23}
}

func (m *UserIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserIntentRequest.Unmarshal(m, b)
}
func (m *UserIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserIntentRequest.Marshal(b, m, deterministic)
}
func (m *UserIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserIntentRequest.Merge(m, src)
}
func (m *UserIntentRequest) XXX_Size() int {
	return xxx_messageInfo_UserIntentRequest.Size(m)
}
func (m *UserIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UserIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UserIntentRequest proto.InternalMessageInfo

func (m *UserIntentRequest) GetIntent() *Intent {
	if m != nil {
		return m.Intent
	}
	return nil
}

// Intent represents user intents for a given phase to be unblocked, once.
type Intent struct {
	Build                bool     `protobuf:"varint,1,opt,name=build,proto3" json:"build,omitempty"`
	Sync                 bool     `protobuf:"varint,2,opt,name=sync,proto3" json:"sync,omitempty"`
	Deploy               bool     `protobuf:"varint,3,opt,name=deploy,proto3" json:"deploy,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent) Reset()         { *m = Intent{} }
func (m *Intent) String() string { return proto.CompactTextString(m) }
func (*Intent) ProtoMessage()    {}
func (*Intent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4f2d38e344f9dbf5, []int{24}
}

func (m *Intent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent.Unmarshal(m, b)
}
func (m *Intent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent.Marshal(b, m, deterministic)
}
func (m *Intent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent.Merge(m, src)
}
func (m *Intent) XXX_Size() int {
	return xxx_messageInfo_Intent.Size(m)
}
func (m *Intent) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent.DiscardUnknown(m)
}

var xxx_messageInfo_Intent proto.InternalMessageInfo

func (m *Intent) GetBuild() bool {
	if m != nil {
		return m.Build
	}
	return false
}

func (m *Intent) GetSync() bool {
	if m != nil {
		return m.Sync
	}
	return false
}

func (m *Intent) GetDeploy() bool {
	if m != nil {
		return m.Deploy
	}
	return false
}

func init() {
	proto.RegisterEnum("proto.BuilderType", BuilderType_name, BuilderType_value)
	proto.RegisterEnum("proto.BuildType", BuildType_name, BuildType_value)
	proto.RegisterEnum("proto.DeployerType", DeployerType_name, DeployerType_value)
	proto.RegisterEnum("proto.ClusterType", ClusterType_name, ClusterType_value)
	proto.RegisterEnum("proto.StatusCode", StatusCode_name, StatusCode_value)
	proto.RegisterType((*StateResponse)(nil), "proto.StateResponse")
	proto.RegisterType((*Response)(nil), "proto.Response")
	proto.RegisterType((*Request)(nil), "proto.Request")
	proto.RegisterType((*State)(nil), "proto.State")
	proto.RegisterMapType((map[int32]*PortEvent)(nil), "proto.State.ForwardedPortsEntry")
	proto.RegisterType((*Metadata)(nil), "proto.Metadata")
	proto.RegisterMapType((map[string]string)(nil), "proto.Metadata.AdditionalEntry")
	proto.RegisterType((*BuildMetadata)(nil), "proto.BuildMetadata")
	proto.RegisterMapType((map[string]string)(nil), "proto.BuildMetadata.AdditionalEntry")
	proto.RegisterType((*BuildMetadata_ImageBuilder)(nil), "proto.BuildMetadata.ImageBuilder")
	proto.RegisterType((*DeployMetadata)(nil), "proto.DeployMetadata")
	proto.RegisterType((*DeployMetadata_Deployer)(nil), "proto.DeployMetadata.Deployer")
	proto.RegisterType((*BuildState)(nil), "proto.BuildState")
	proto.RegisterMapType((map[string]string)(nil), "proto.BuildState.ArtifactsEntry")
	proto.RegisterType((*DeployState)(nil), "proto.DeployState")
	proto.RegisterType((*StatusCheckState)(nil), "proto.StatusCheckState")
	proto.RegisterMapType((map[string]string)(nil), "proto.StatusCheckState.ResourcesEntry")
	proto.RegisterType((*FileSyncState)(nil), "proto.FileSyncState")
	proto.RegisterType((*Event)(nil), "proto.Event")
	proto.RegisterType((*DevLoopEvent)(nil), "proto.DevLoopEvent")
	proto.RegisterType((*ErrDef)(nil), "proto.ErrDef")
	proto.RegisterType((*MetaEvent)(nil), "proto.MetaEvent")
	proto.RegisterType((*BuildEvent)(nil), "proto.BuildEvent")
	proto.RegisterType((*DeployEvent)(nil), "proto.DeployEvent")
	proto.RegisterType((*StatusCheckEvent)(nil), "proto.StatusCheckEvent")
	proto.RegisterType((*ResourceStatusCheckEvent)(nil), "proto.ResourceStatusCheckEvent")
	proto.RegisterType((*PortEvent)(nil), "proto.PortEvent")
	proto.RegisterType((*FileSyncEvent)(nil), "proto.FileSyncEvent")
	proto.RegisterType((*DebuggingContainerEvent)(nil), "proto.DebuggingContainerEvent")
	proto.RegisterMapType((map[string]uint32)(nil), "proto.DebuggingContainerEvent.DebugPortsEntry")
	proto.RegisterType((*LogEntry)(nil), "proto.LogEntry")
	proto.RegisterType((*UserIntentRequest)(nil), "proto.UserIntentRequest")
	proto.RegisterType((*Intent)(nil), "proto.Intent")
}

func init() { proto.RegisterFile("skaffold.proto", fileDescriptor_4f2d38e344f9dbf5) }

var fileDescriptor_4f2d38e344f9dbf5 = []byte{
	// 2239 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x58, 0xcb, 0x93, 0x1b, 0x49,
	0xd1, 0x1f, 0xa9, 0xf5, 0xcc, 0x79, 0xb8, 0xa7, 0x3c, 0xb6, 0xf5, 0xc9, 0xb3, 0xf6, 0xb8, 0x3f,
	0xdb, 0x6b, 0x66, 0x97, 0x19, 0xaf, 0x4d, 0x10, 0x8b, 0xc3, 0x0b, 0xa1, 0x69, 0xb5, 0x47, 0x6d,
	0x69, 0x5a, 0x8a, 0x6a, 0x69, 0x8d, 0x1d, 0x41, 0x28, 0xda, 0x52, 0x8d, 0x56, 0x61, 0x49, 0x2d,
	0xba, 0x5b, 0x5e, 0x86, 0x03, 0x44, 0xc0, 0x8d, 0xd3, 0xc2, 0xb2, 0x1c, 0xb8, 0x73, 0x83, 0xe5,
	0xca, 0x85, 0xc7, 0x0d, 0x38, 0x73, 0xe2, 0x48, 0xc4, 0xf2, 0x1f, 0xb0, 0xbc, 0x0f, 0x44, 0xbd,
	0xfa, 0xa1, 0x87, 0x27, 0x36, 0xf6, 0x24, 0x55, 0xd6, 0x2f, 0x7f, 0x99, 0x95, 0x95, 0x95, 0x59,
	0xd5, 0xb0, 0xe5, 0xbf, 0x70, 0x4e, 0x4f, 0xdd, 0x51, 0xff, 0x60, 0xea, 0xb9, 0x81, 0x8b, 0xb2,
	0xec, 0xa7, 0xbc, 0x3b, 0x70, 0xdd, 0xc1, 0x88, 0x1c, 0x3a, 0xd3, 0xe1, 0xa1, 0x33, 0x99, 0xb8,
	0x81, 0x13, 0x0c, 0xdd, 0x89, 0xcf, 0x41, 0xe5, 0xeb, 0x62, 0x96, 0x8d, 0x9e, 0xcf, 0x4e, 0x0f,
	0x83, 0xe1, 0x98, 0xf8, 0x81, 0x33, 0x9e, 0x0a, 0xc0, 0xd5, 0x79, 0x00, 0x19, 0x4f, 0x83, 0x33,
	0x3e, 0xa9, 0xdd, 0x87, 0x4d, 0x3b, 0x70, 0x02, 0x82, 0x89, 0x3f, 0x75, 0x27, 0x3e, 0x41, 0x1a,
	0x64, 0x7d, 0x2a, 0x28, 0xa5, 0xf6, 0x52, 0x77, 0xd6, 0xef, 0x6d, 0x70, 0xdc, 0x01, 0x07, 0xf1,
	0x29, 0x6d, 0x17, 0x0a, 0x21, 0x5e, 0x05, 0x65, 0xec, 0x0f, 0x18, 0xba, 0x88, 0xe9, 0x5f, 0xed,
	0x35, 0xc8, 0x63, 0xf2, 0xcd, 0x19, 0xf1, 0x03, 0x84, 0x20, 0x33, 0x71, 0xc6, 0x44, 0xcc, 0xb2,
	0xff, 0xda, 0x47, 0x19, 0xc8, 0x32, 0x36, 0xf4, 0x16, 0xc0, 0xf3, 0xd9, 0x70, 0xd4, 0xb7, 0x63,
	0xf6, 0xb6, 0x85, 0xbd, 0xa3, 0x70, 0x02, 0xc7, 0x40, 0xe8, 0x4b, 0xb0, 0xde, 0x27, 0xd3, 0x91,
	0x7b, 0xc6, 0x75, 0xd2, 0x4c, 0x07, 0x09, 0x9d, 0x6a, 0x34, 0x83, 0xe3, 0x30, 0x54, 0x83, 0xad,
	0x53, 0xd7, 0x7b, 0xdf, 0xf1, 0xfa, 0xa4, 0xdf, 0x72, 0xbd, 0xc0, 0x2f, 0x65, 0xf6, 0x94, 0x3b,
	0xeb, 0xf7, 0xf6, 0xe2, 0x8b, 0x3b, 0x78, 0x94, 0x80, 0x18, 0x93, 0xc0, 0x3b, 0xc3, 0x73, 0x7a,
	0x48, 0x07, 0x95, 0x86, 0x60, 0xe6, 0xeb, 0xef, 0x91, 0xde, 0x0b, 0xee, 0x44, 0x96, 0x39, 0x71,
	0x25, 0xc6, 0x15, 0x9f, 0xc6, 0x0b, 0x0a, 0xe8, 0x01, 0x6c, 0x9e, 0x0e, 0x47, 0xc4, 0x3e, 0x9b,
	0xf4, 0x38, 0x43, 0x8e, 0x31, 0xec, 0x08, 0x86, 0x47, 0xf1, 0x39, 0x9c, 0x84, 0xa2, 0x16, 0x5c,
	0xec, 0x93, 0xe7, 0xb3, 0xc1, 0x60, 0x38, 0x19, 0xe8, 0xee, 0x24, 0x70, 0x86, 0x13, 0xe2, 0xf9,
	0xa5, 0x3c, 0x5b, 0xcf, 0xb5, 0x30, 0x10, 0xf3, 0x08, 0xe3, 0x25, 0x99, 0x04, 0x78, 0x99, 0x2a,
	0x7a, 0x03, 0x0a, 0x63, 0x12, 0x38, 0x7d, 0x27, 0x70, 0x4a, 0x05, 0xe6, 0xc8, 0x05, 0x41, 0x73,
	0x22, 0xc4, 0x38, 0x04, 0x94, 0x6d, 0xb8, 0xb8, 0x24, 0x4c, 0x34, 0x09, 0x5e, 0x90, 0x33, 0xb6,
	0x85, 0x59, 0x4c, 0xff, 0xa2, 0xdb, 0x90, 0x7d, 0xe9, 0x8c, 0x66, 0x72, 0x8b, 0x54, 0x41, 0x49,
	0x75, 0xb8, 0x2f, 0x7c, 0xfa, 0x41, 0xfa, 0xed, 0xd4, 0xe3, 0x4c, 0x41, 0x51, 0x33, 0xda, 0x5f,
	0x53, 0x50, 0x90, 0x16, 0xd1, 0x3e, 0x64, 0xd9, 0xae, 0x8b, 0xac, 0xd8, 0x89, 0x67, 0x45, 0xe8,
	0x16, 0x87, 0xa0, 0x2f, 0x42, 0x8e, 0x6f, 0xb6, 0xb0, 0x75, 0x29, 0x91, 0x0e, 0x21, 0x5a, 0x80,
	0xd0, 0xd7, 0x00, 0x9c, 0x7e, 0x7f, 0x48, 0x8f, 0x90, 0x33, 0x2a, 0xf5, 0x58, 0xe0, 0xae, 0xcf,
	0xad, 0xf8, 0xa0, 0x12, 0x22, 0x78, 0x1e, 0xc4, 0x54, 0xca, 0xef, 0xc0, 0x85, 0xb9, 0xe9, 0xf8,
	0xfa, 0x8b, 0x7c, 0xfd, 0x3b, 0xf1, 0xf5, 0x17, 0x63, 0xab, 0xd5, 0x3e, 0x4d, 0xc3, 0x66, 0x62,
	0x1d, 0xe8, 0x4d, 0xd8, 0x9e, 0xcc, 0xc6, 0xcf, 0x89, 0xd7, 0x3c, 0xad, 0x78, 0xc1, 0xf0, 0xd4,
	0xe9, 0x05, 0xbe, 0x88, 0xe5, 0xe2, 0x04, 0x7a, 0x07, 0x0a, 0x6c, 0xdd, 0x74, 0xdb, 0xd3, 0xcc,
	0xfb, 0x1b, 0xcb, 0xa2, 0x73, 0x60, 0x8e, 0x9d, 0x01, 0x39, 0xe2, 0x48, 0x1c, 0xaa, 0xa0, 0x9b,
	0x90, 0x09, 0xce, 0xa6, 0xa4, 0xa4, 0xec, 0xa5, 0xee, 0x6c, 0x85, 0xfb, 0xc2, 0x70, 0xed, 0xb3,
	0x29, 0xc1, 0x6c, 0x16, 0x55, 0x97, 0x04, 0xe9, 0xe6, 0x52, 0x33, 0xaf, 0x8a, 0x54, 0x03, 0x36,
	0xe2, 0x5e, 0xa0, 0xdb, 0xc2, 0x76, 0x8a, 0xd9, 0x46, 0x71, 0x3e, 0xe2, 0xc5, 0xac, 0xef, 0x40,
	0xb6, 0xe7, 0xce, 0x26, 0x01, 0x0b, 0x5e, 0x16, 0xf3, 0xc1, 0xe7, 0x8d, 0xfb, 0xef, 0x53, 0xb0,
	0x95, 0x4c, 0x09, 0xf4, 0x10, 0x8a, 0x3c, 0x29, 0x68, 0x2c, 0x53, 0x73, 0x47, 0x28, 0x8e, 0x14,
	0x43, 0xe2, 0xe1, 0x48, 0x01, 0xbd, 0x09, 0xf9, 0xde, 0x68, 0xe6, 0x07, 0xc4, 0x63, 0xc6, 0xa2,
	0x05, 0xe9, 0x5c, 0xca, 0x16, 0x24, 0x21, 0x65, 0x13, 0x0a, 0x92, 0x04, 0xbd, 0x9e, 0x88, 0xc3,
	0xc5, 0x84, 0xc9, 0xf3, 0x03, 0xa1, 0xfd, 0x20, 0x05, 0x10, 0xd5, 0x47, 0xf4, 0x55, 0x28, 0x3a,
	0xb1, 0xb4, 0x89, 0x17, 0xb6, 0x08, 0x75, 0x10, 0x26, 0x10, 0xdf, 0xa6, 0x48, 0xa5, 0xfc, 0x10,
	0xb6, 0x92, 0x93, 0x9f, 0x29, 0xac, 0xb7, 0x60, 0x3d, 0x56, 0x77, 0xd1, 0x65, 0xc8, 0xf1, 0x7a,
	0x27, 0xb4, 0xc5, 0x48, 0xfb, 0x38, 0x05, 0xea, 0x7c, 0x69, 0x5c, 0x05, 0x46, 0x55, 0x28, 0x7a,
	0xc4, 0x77, 0x67, 0x5e, 0x8f, 0xc8, 0x1c, 0xbf, 0xbd, 0xa2, 0xbc, 0x1e, 0x60, 0x09, 0x14, 0xeb,
	0x0a, 0x15, 0xe9, 0xba, 0x92, 0x93, 0x9f, 0x69, 0x5d, 0xaf, 0xc3, 0x66, 0xa2, 0x10, 0xaf, 0x5c,
	0xd9, 0x5f, 0x32, 0x90, 0x65, 0x25, 0x0d, 0xdd, 0x85, 0x22, 0x2d, 0x94, 0x6c, 0x20, 0x0a, 0x97,
	0x1a, 0x2b, 0x2c, 0x4c, 0x5e, 0x5b, 0xc3, 0x11, 0x08, 0xdd, 0x17, 0x1d, 0x90, 0xab, 0xa4, 0x17,
	0x3b, 0xa0, 0xd4, 0x89, 0xc1, 0xd0, 0x97, 0x65, 0x0f, 0xe4, 0x5a, 0xca, 0x92, 0x1e, 0x28, 0xd5,
	0xe2, 0x40, 0xea, 0xde, 0x54, 0x96, 0xdf, 0x52, 0x66, 0x79, 0x59, 0xa6, 0xee, 0x85, 0x20, 0x64,
	0x24, 0xba, 0x1d, 0x57, 0x5c, 0xd9, 0xed, 0xa4, 0xfe, 0x82, 0x0a, 0xfa, 0x06, 0x94, 0xe4, 0xae,
	0xcc, 0xe3, 0x45, 0xeb, 0x93, 0xf5, 0x17, 0xaf, 0x80, 0xd5, 0xd6, 0xf0, 0x4a, 0x0a, 0xf4, 0x30,
	0x6a, 0xa7, 0x9c, 0x33, 0xbf, 0xb4, 0x9d, 0x4a, 0xa2, 0x24, 0x18, 0x3d, 0x83, 0x2b, 0xfd, 0xe5,
	0xed, 0x52, 0x74, 0xc3, 0x73, 0x9a, 0x6a, 0x6d, 0x0d, 0xaf, 0x22, 0x40, 0x5f, 0x81, 0x8d, 0x3e,
	0x79, 0xd9, 0x70, 0xdd, 0x29, 0x27, 0x2c, 0x32, 0xc2, 0xe8, 0xbc, 0x47, 0x53, 0xb5, 0x35, 0x9c,
	0x80, 0x1e, 0x6d, 0x00, 0x10, 0xfa, 0xa7, 0x4b, 0xeb, 0x80, 0x46, 0x60, 0x23, 0x8e, 0x46, 0xbb,
	0x50, 0x1c, 0x06, 0xc4, 0x63, 0xf7, 0x40, 0xd1, 0x29, 0x22, 0x41, 0x2c, 0x53, 0xd3, 0x89, 0x63,
	0x75, 0x1d, 0x14, 0xe2, 0x79, 0x22, 0x61, 0x36, 0x85, 0x17, 0x86, 0xe7, 0x55, 0xc9, 0x29, 0xa6,
	0x33, 0x5a, 0x13, 0x72, 0x7c, 0x88, 0xde, 0x80, 0x3c, 0xf1, 0x3c, 0xdd, 0xed, 0xcb, 0x22, 0xb5,
	0x9d, 0xdc, 0x70, 0xb7, 0x4f, 0xb0, 0x44, 0xa0, 0x12, 0xe4, 0xc7, 0xc4, 0xf7, 0x9d, 0x81, 0x3c,
	0x46, 0x72, 0xa8, 0x59, 0x50, 0x0c, 0x33, 0x9f, 0x9e, 0x35, 0x42, 0x8f, 0xa1, 0x38, 0x3f, 0x7c,
	0x90, 0xb8, 0x7e, 0xa4, 0xcf, 0xb9, 0x7e, 0x68, 0xdf, 0x15, 0x85, 0x8f, 0x13, 0x96, 0xa1, 0x20,
	0xab, 0x98, 0xe0, 0x0c, 0xc7, 0x2b, 0x63, 0xa0, 0x46, 0x31, 0x28, 0xb2, 0x45, 0xc7, 0x97, 0x9a,
	0x39, 0x6f, 0xa9, 0x5a, 0x5f, 0x56, 0x3b, 0xee, 0xc1, 0xaa, 0x02, 0x26, 0xac, 0xa4, 0x97, 0x5a,
	0x51, 0xce, 0xb5, 0xf2, 0xfd, 0x64, 0xb1, 0x7c, 0xb5, 0xad, 0x95, 0xd1, 0xff, 0xbc, 0x6b, 0xfd,
	0x36, 0x94, 0x56, 0x9d, 0x47, 0x1a, 0x7a, 0x79, 0x1e, 0x65, 0xe8, 0xe5, 0x78, 0x65, 0xe8, 0x63,
	0x8e, 0x2a, 0x4b, 0x1d, 0xcd, 0x84, 0x8e, 0x6a, 0x3f, 0x4b, 0x43, 0x31, 0x2c, 0x4a, 0x34, 0xdd,
	0x47, 0x6e, 0xcf, 0x19, 0x51, 0x89, 0x4c, 0xf7, 0x50, 0x80, 0xae, 0x01, 0x78, 0x64, 0xec, 0x06,
	0x84, 0x4d, 0xf3, 0x4e, 0x19, 0x93, 0x50, 0xbb, 0x53, 0xb7, 0x6f, 0xd1, 0x77, 0x88, 0xb0, 0x2b,
	0x86, 0xe8, 0x26, 0x6c, 0xf6, 0xe4, 0x89, 0x65, 0xf3, 0xdc, 0x83, 0xa4, 0x90, 0x5a, 0xa7, 0x0f,
	0x17, 0x7f, 0xea, 0xf4, 0xf8, 0x65, 0xbf, 0x88, 0x23, 0x01, 0x8d, 0x04, 0x2d, 0x98, 0x4c, 0x3d,
	0xc7, 0x23, 0x21, 0xc7, 0x48, 0x83, 0x0d, 0x19, 0x15, 0xda, 0xd4, 0x59, 0x61, 0x2a, 0xe2, 0x84,
	0x2c, 0x8e, 0x61, 0x1c, 0x85, 0x24, 0x86, 0xf1, 0x94, 0x20, 0xef, 0xf4, 0xfb, 0x1e, 0xf1, 0x7d,
	0x56, 0x42, 0x8a, 0x58, 0x0e, 0xb5, 0x9f, 0xa6, 0xa2, 0x36, 0x15, 0xc6, 0x8a, 0x16, 0x38, 0x9d,
	0x5d, 0x1b, 0x44, 0xac, 0x42, 0x01, 0x3d, 0x83, 0xc3, 0x71, 0x94, 0x2a, 0x7c, 0x10, 0xdb, 0x31,
	0x65, 0x59, 0x1a, 0x67, 0x96, 0x26, 0x50, 0xf6, 0xdc, 0x04, 0xfa, 0x5b, 0x1a, 0xae, 0xac, 0xa8,
	0x9a, 0xaf, 0xca, 0x66, 0xb9, 0x59, 0xe9, 0x73, 0x36, 0x4b, 0x39, 0x77, 0xb3, 0x32, 0x4b, 0x36,
	0x2b, 0xac, 0x18, 0xd9, 0xb9, 0x8a, 0x51, 0x82, 0xbc, 0x37, 0x9b, 0xd0, 0xc7, 0xb3, 0xd8, 0x47,
	0x39, 0xa4, 0x09, 0xf6, 0xbe, 0xeb, 0xbd, 0x18, 0x4e, 0x06, 0xd5, 0xa1, 0x27, 0x36, 0x31, 0x26,
	0x41, 0x16, 0x00, 0xeb, 0x00, 0xfc, 0x69, 0x59, 0x60, 0xf7, 0x95, 0x83, 0x57, 0x77, 0x0d, 0x2e,
	0x8f, 0x3d, 0x34, 0x63, 0x0c, 0xf4, 0xa2, 0x3b, 0x37, 0x7d, 0xde, 0xcd, 0x65, 0x33, 0x7e, 0x73,
	0xf9, 0x0e, 0x14, 0x1a, 0xee, 0x80, 0xeb, 0xbd, 0x0d, 0xc5, 0xf0, 0x73, 0x80, 0xb8, 0x92, 0x94,
	0x0f, 0xf8, 0xf7, 0x80, 0x03, 0xf9, 0x3d, 0xe0, 0xa0, 0x2d, 0x11, 0x38, 0x02, 0x23, 0x0d, 0xb2,
	0x24, 0x76, 0x2b, 0x91, 0xdf, 0x01, 0xc4, 0xe3, 0x8d, 0x24, 0x2b, 0xba, 0x12, 0xab, 0xe8, 0xda,
	0x03, 0xd8, 0xee, 0xf8, 0xc4, 0x33, 0x27, 0x01, 0x85, 0x8a, 0x2f, 0x01, 0xb7, 0x20, 0x37, 0x64,
	0x02, 0xe1, 0x85, 0x6c, 0x3f, 0x02, 0x25, 0x26, 0xb5, 0xc7, 0x90, 0xe3, 0x12, 0xca, 0x1d, 0xbd,
	0x00, 0x0b, 0xf2, 0xad, 0x87, 0x20, 0xe3, 0x9f, 0x4d, 0x7a, 0xcc, 0xa9, 0x02, 0x66, 0xff, 0x69,
	0x2a, 0x89, 0xf7, 0x9f, 0xc2, 0xa4, 0x62, 0xb4, 0xef, 0xc2, 0x7a, 0xec, 0x69, 0x81, 0x4a, 0xb0,
	0xd3, 0xb1, 0xea, 0x56, 0xf3, 0x89, 0xd5, 0x3d, 0xea, 0x98, 0x8d, 0xaa, 0x81, 0xbb, 0xed, 0xa7,
	0x2d, 0x43, 0x5d, 0x43, 0x79, 0x50, 0x1e, 0x9b, 0x47, 0x6a, 0x0a, 0x15, 0x21, 0x7b, 0x54, 0x79,
	0x66, 0x34, 0xd4, 0x34, 0xda, 0x02, 0x60, 0xa8, 0x56, 0x45, 0xaf, 0xdb, 0xaa, 0x82, 0x00, 0x72,
	0x7a, 0xc7, 0x6e, 0x37, 0x4f, 0xd4, 0x0c, 0xfd, 0x5f, 0xaf, 0x58, 0x66, 0xbd, 0xa9, 0x66, 0xe9,
	0xff, 0x6a, 0x53, 0xaf, 0x1b, 0x58, 0xcd, 0xed, 0x57, 0xa1, 0x18, 0xbe, 0xa3, 0xd0, 0x65, 0x40,
	0x09, 0x73, 0xd2, 0xd8, 0x3a, 0xe4, 0xf5, 0x46, 0xc7, 0x6e, 0x1b, 0x58, 0x4d, 0x51, 0xcb, 0xc7,
	0xfa, 0x91, 0x9a, 0xa6, 0x96, 0x1b, 0x4d, 0xbd, 0xd2, 0x50, 0x95, 0xfd, 0x26, 0xed, 0xf5, 0xd1,
	0x4b, 0x00, 0xfd, 0x1f, 0x5c, 0x92, 0x44, 0x55, 0xa3, 0xd5, 0x68, 0x3e, 0x8d, 0x1c, 0x2f, 0x40,
	0xa6, 0x66, 0x34, 0x4e, 0xd4, 0x14, 0xda, 0x84, 0x62, 0x9d, 0xb9, 0x67, 0x3e, 0x33, 0xd4, 0x34,
	0x35, 0x52, 0xef, 0x1c, 0x19, 0x7a, 0x9b, 0x12, 0x9a, 0xb0, 0x1e, 0x7b, 0x91, 0xc4, 0xe3, 0x20,
	0x1c, 0x91, 0x74, 0x1b, 0x50, 0x38, 0x31, 0x2d, 0x93, 0x6a, 0x0a, 0xdf, 0xea, 0x06, 0xf7, 0xad,
	0xd9, 0xae, 0x19, 0x58, 0x55, 0xf6, 0x7f, 0x95, 0x07, 0x88, 0x4e, 0x3a, 0xda, 0x86, 0x4d, 0x49,
	0x65, 0x60, 0xdc, 0xc4, 0xea, 0x1a, 0x2a, 0xc1, 0x45, 0xbb, 0x5d, 0x69, 0x77, 0x6c, 0xbd, 0x66,
	0xe8, 0xf5, 0xae, 0xdd, 0xd1, 0x75, 0xc3, 0xb6, 0xd5, 0x3f, 0xa4, 0x10, 0x82, 0x4d, 0x1e, 0x08,
	0x29, 0xfb, 0x63, 0x0a, 0xed, 0x42, 0x89, 0xcb, 0x5a, 0x1d, 0xbb, 0xd6, 0xad, 0x30, 0x79, 0xb7,
	0x6a, 0x58, 0xa6, 0x51, 0x55, 0x09, 0xba, 0x0a, 0x57, 0xc4, 0x2c, 0x6e, 0x3e, 0x36, 0xf4, 0x76,
	0xd7, 0x6a, 0xb6, 0xbb, 0x8f, 0x9a, 0x1d, 0xab, 0xaa, 0x9e, 0xa2, 0xeb, 0x50, 0x8e, 0x1b, 0x32,
	0x4f, 0x2a, 0xc7, 0x46, 0xb7, 0xd5, 0x69, 0x34, 0xa8, 0x2b, 0xea, 0xcf, 0xd3, 0xe8, 0xff, 0xe1,
	0x5a, 0x1c, 0xa0, 0x37, 0xad, 0x76, 0xc5, 0xb4, 0x0c, 0xdc, 0xd5, 0xb1, 0x51, 0x69, 0x9b, 0xd6,
	0xb1, 0xfa, 0x8b, 0x34, 0xd2, 0xe0, 0xb5, 0x38, 0x08, 0x77, 0xac, 0x18, 0x90, 0x12, 0x7d, 0x9c,
	0x46, 0xb7, 0x60, 0x6f, 0x39, 0x51, 0xdb, 0xc0, 0x27, 0xa6, 0x55, 0x69, 0x1b, 0x55, 0xf5, 0x97,
	0xaf, 0x80, 0x61, 0xc3, 0x6e, 0x57, 0x30, 0xb3, 0xf8, 0xc9, 0x02, 0xcc, 0x6a, 0x56, 0x8d, 0xee,
	0x89, 0x71, 0xd2, 0xc4, 0x4f, 0xbb, 0x2d, 0x6c, 0xd8, 0x76, 0x07, 0x1b, 0xea, 0x07, 0xca, 0xbc,
	0xf7, 0x0c, 0x56, 0x35, 0xed, 0x7a, 0x04, 0xfa, 0xa1, 0x82, 0xbe, 0x00, 0x37, 0x17, 0x40, 0x96,
	0xd1, 0x7e, 0xd2, 0xc4, 0xf5, 0x6e, 0xc7, 0xaa, 0xbc, 0x5b, 0x31, 0x1b, 0x95, 0xa3, 0x86, 0xa1,
	0xfe, 0x48, 0x99, 0x5f, 0x28, 0x83, 0xb6, 0xcc, 0x6a, 0x44, 0xf7, 0xe1, 0x72, 0x9b, 0x1d, 0x8b,
	0x8e, 0xaa, 0x1d, 0x4e, 0xf4, 0x63, 0x05, 0xdd, 0x80, 0xdd, 0x25, 0x20, 0x6c, 0x54, 0xf4, 0x1a,
	0x83, 0x7c, 0xa4, 0xcc, 0x6f, 0x0d, 0x77, 0xab, 0xd9, 0xee, 0x62, 0xa3, 0x52, 0x7d, 0xaa, 0xfe,
	0x44, 0x99, 0x4f, 0x12, 0x91, 0x43, 0xea, 0xa7, 0x0a, 0xba, 0x0d, 0x37, 0x96, 0xcc, 0xcc, 0x79,
	0xf1, 0x77, 0x05, 0xed, 0xc3, 0xad, 0xe5, 0xc1, 0x7e, 0x52, 0x31, 0x69, 0xa4, 0x43, 0xce, 0x7f,
	0x28, 0xe8, 0x22, 0x6c, 0xf1, 0x83, 0x13, 0x0a, 0xff, 0xa9, 0xa0, 0x6d, 0xd8, 0xb0, 0x9f, 0x5a,
	0x7a, 0x28, 0xfa, 0x97, 0x12, 0x25, 0xa8, 0x94, 0xfd, 0x5b, 0x41, 0x3b, 0x70, 0xa1, 0x6a, 0xbc,
	0x6b, 0x5a, 0x66, 0x3b, 0x94, 0xfe, 0x87, 0x49, 0xf5, 0x86, 0x51, 0xb1, 0x3a, 0xad, 0x50, 0xfa,
	0x5f, 0x26, 0x65, 0x94, 0x0c, 0xcd, 0xcf, 0xc3, 0x9f, 0x33, 0x68, 0x0f, 0xae, 0x4a, 0x06, 0x6c,
	0x1c, 0x9b, 0xec, 0xbc, 0x71, 0x33, 0x55, 0xa3, 0x65, 0xab, 0xbf, 0xce, 0xd2, 0x70, 0x2d, 0x20,
	0xda, 0x86, 0xdd, 0xe6, 0x80, 0xdf, 0x64, 0x69, 0xc8, 0x17, 0x00, 0x62, 0x45, 0x0c, 0xf2, 0xdb,
	0xec, 0x52, 0x2b, 0x7a, 0xd3, 0x7a, 0x64, 0x1e, 0x53, 0x88, 0xfa, 0xbb, 0xec, 0xbd, 0x0f, 0x14,
	0xb8, 0x60, 0x8b, 0xcf, 0xcb, 0x36, 0xf1, 0x5e, 0x0e, 0x7b, 0x04, 0xe9, 0x50, 0x38, 0x26, 0x81,
	0x78, 0xde, 0x2e, 0xb4, 0x05, 0x63, 0x3c, 0x0d, 0xce, 0xca, 0x89, 0x0f, 0xc0, 0xda, 0xf6, 0xf7,
	0xfe, 0xf4, 0xc9, 0x87, 0xe9, 0x75, 0x54, 0x3c, 0x7c, 0xf9, 0xd6, 0x21, 0xfb, 0x18, 0x8c, 0x8e,
	0xa1, 0xc0, 0x9a, 0x42, 0xc3, 0x1d, 0x20, 0x79, 0x75, 0x97, 0xfd, 0xa7, 0x3c, 0x2f, 0xd0, 0x2e,
	0x31, 0x82, 0x0b, 0x68, 0x93, 0x12, 0xf0, 0x17, 0xce, 0xc8, 0x1d, 0xdc, 0x49, 0xdd, 0x4d, 0xa1,
	0x63, 0xc8, 0x31, 0x22, 0x7f, 0xa5, 0x2f, 0x0b, 0x6c, 0x88, 0xb1, 0x6d, 0x20, 0x08, 0xd9, 0xfc,
	0xbb, 0x29, 0xf4, 0x75, 0xc8, 0x1b, 0xdf, 0x22, 0xbd, 0x59, 0x40, 0x50, 0x49, 0x68, 0x2c, 0x34,
	0xa4, 0xf2, 0x0a, 0x1b, 0xda, 0x55, 0x46, 0x79, 0x49, 0x5b, 0x67, 0x94, 0x9c, 0xe6, 0x81, 0x68,
	0x4f, 0xa8, 0x01, 0xb9, 0x9a, 0x33, 0xe9, 0x8f, 0x08, 0x4a, 0xf4, 0xc3, 0x95, 0x64, 0xbb, 0x8c,
	0xec, 0xb2, 0xb6, 0x1d, 0xf9, 0x77, 0xf8, 0x1e, 0x23, 0x78, 0x90, 0xda, 0x7f, 0x9e, 0x63, 0xe8,
	0xfb, 0xff, 0x0b, 0x00, 0x00, 0xff, 0xff, 0x6b, 0x3f, 0x7a, 0x26, 0xf7, 0x17, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SkaffoldServiceClient is the client API for SkaffoldService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SkaffoldServiceClient interface {
	// Returns the state of the current Skaffold execution
	GetState(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*State, error)
	// DEPRECATED. Events should be used instead.
	// TODO remove (https://github.com/GoogleContainerTools/skaffold/issues/3168)
	EventLog(ctx context.Context, opts ...grpc.CallOption) (SkaffoldService_EventLogClient, error)
	// Returns all the events of the current Skaffold execution from the start
	Events(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (SkaffoldService_EventsClient, error)
	// Allows for a single execution of some or all of the phases (build, sync, deploy) in case autoBuild, autoDeploy or autoSync are disabled.
	Execute(ctx context.Context, in *UserIntentRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// EXPERIMENTAL. It allows for custom events to be implemented in custom builders for example.
	Handle(ctx context.Context, in *Event, opts ...grpc.CallOption) (*empty.Empty, error)
}

type skaffoldServiceClient struct {
	cc *grpc.ClientConn
}

func NewSkaffoldServiceClient(cc *grpc.ClientConn) SkaffoldServiceClient {
	return &skaffoldServiceClient{cc}
}

func (c *skaffoldServiceClient) GetState(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*State, error) {
	out := new(State)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/GetState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldServiceClient) EventLog(ctx context.Context, opts ...grpc.CallOption) (SkaffoldService_EventLogClient, error) {
	stream, err := c.cc.NewStream(ctx, &_SkaffoldService_serviceDesc.Streams[0], "/proto.SkaffoldService/EventLog", opts...)
	if err != nil {
		return nil, err
	}
	x := &skaffoldServiceEventLogClient{stream}
	return x, nil
}

type SkaffoldService_EventLogClient interface {
	Send(*LogEntry) error
	Recv() (*LogEntry, error)
	grpc.ClientStream
}

type skaffoldServiceEventLogClient struct {
	grpc.ClientStream
}

func (x *skaffoldServiceEventLogClient) Send(m *LogEntry) error {
	return x.ClientStream.SendMsg(m)
}

func (x *skaffoldServiceEventLogClient) Recv() (*LogEntry, error) {
	m := new(LogEntry)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *skaffoldServiceClient) Events(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (SkaffoldService_EventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_SkaffoldService_serviceDesc.Streams[1], "/proto.SkaffoldService/Events", opts...)
	if err != nil {
		return nil, err
	}
	x := &skaffoldServiceEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type SkaffoldService_EventsClient interface {
	Recv() (*LogEntry, error)
	grpc.ClientStream
}

type skaffoldServiceEventsClient struct {
	grpc.ClientStream
}

func (x *skaffoldServiceEventsClient) Recv() (*LogEntry, error) {
	m := new(LogEntry)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *skaffoldServiceClient) Execute(ctx context.Context, in *UserIntentRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/Execute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldServiceClient) Handle(ctx context.Context, in *Event, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/proto.SkaffoldService/Handle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SkaffoldServiceServer is the server API for SkaffoldService service.
type SkaffoldServiceServer interface {
	// Returns the state of the current Skaffold execution
	GetState(context.Context, *empty.Empty) (*State, error)
	// DEPRECATED. Events should be used instead.
	// TODO remove (https://github.com/GoogleContainerTools/skaffold/issues/3168)
	EventLog(SkaffoldService_EventLogServer) error
	// Returns all the events of the current Skaffold execution from the start
	Events(*empty.Empty, SkaffoldService_EventsServer) error
	// Allows for a single execution of some or all of the phases (build, sync, deploy) in case autoBuild, autoDeploy or autoSync are disabled.
	Execute(context.Context, *UserIntentRequest) (*empty.Empty, error)
	// EXPERIMENTAL. It allows for custom events to be implemented in custom builders for example.
	Handle(context.Context, *Event) (*empty.Empty, error)
}

// UnimplementedSkaffoldServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSkaffoldServiceServer struct {
}

func (*UnimplementedSkaffoldServiceServer) GetState(ctx context.Context, req *empty.Empty) (*State, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetState not implemented")
}
func (*UnimplementedSkaffoldServiceServer) EventLog(srv SkaffoldService_EventLogServer) error {
	return status.Errorf(codes.Unimplemented, "method EventLog not implemented")
}
func (*UnimplementedSkaffoldServiceServer) Events(req *empty.Empty, srv SkaffoldService_EventsServer) error {
	return status.Errorf(codes.Unimplemented, "method Events not implemented")
}
func (*UnimplementedSkaffoldServiceServer) Execute(ctx context.Context, req *UserIntentRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Execute not implemented")
}
func (*UnimplementedSkaffoldServiceServer) Handle(ctx context.Context, req *Event) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Handle not implemented")
}

func RegisterSkaffoldServiceServer(s *grpc.Server, srv SkaffoldServiceServer) {
	s.RegisterService(&_SkaffoldService_serviceDesc, srv)
}

func _SkaffoldService_GetState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(empty.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).GetState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/GetState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).GetState(ctx, req.(*empty.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldService_EventLog_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SkaffoldServiceServer).EventLog(&skaffoldServiceEventLogServer{stream})
}

type SkaffoldService_EventLogServer interface {
	Send(*LogEntry) error
	Recv() (*LogEntry, error)
	grpc.ServerStream
}

type skaffoldServiceEventLogServer struct {
	grpc.ServerStream
}

func (x *skaffoldServiceEventLogServer) Send(m *LogEntry) error {
	return x.ServerStream.SendMsg(m)
}

func (x *skaffoldServiceEventLogServer) Recv() (*LogEntry, error) {
	m := new(LogEntry)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _SkaffoldService_Events_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(empty.Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SkaffoldServiceServer).Events(m, &skaffoldServiceEventsServer{stream})
}

type SkaffoldService_EventsServer interface {
	Send(*LogEntry) error
	grpc.ServerStream
}

type skaffoldServiceEventsServer struct {
	grpc.ServerStream
}

func (x *skaffoldServiceEventsServer) Send(m *LogEntry) error {
	return x.ServerStream.SendMsg(m)
}

func _SkaffoldService_Execute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).Execute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/Execute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).Execute(ctx, req.(*UserIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldService_Handle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Event)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldServiceServer).Handle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.SkaffoldService/Handle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldServiceServer).Handle(ctx, req.(*Event))
	}
	return interceptor(ctx, in, info, handler)
}

var _SkaffoldService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "proto.SkaffoldService",
	HandlerType: (*SkaffoldServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetState",
			Handler:    _SkaffoldService_GetState_Handler,
		},
		{
			MethodName: "Execute",
			Handler:    _SkaffoldService_Execute_Handler,
		},
		{
			MethodName: "Handle",
			Handler:    _SkaffoldService_Handle_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "EventLog",
			Handler:       _SkaffoldService_EventLog_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "Events",
			Handler:       _SkaffoldService_Events_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "skaffold.proto",
}
