/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.number.PuString;
import jv.object.PsDebug;
import jv.vecmath.P_Vector;
import jv.vecmath.PdVector;
import jv.vecmath.PuData;

public class PdBary
extends P_Vector {
    public double[] m_data;
    private static PdVector[] m_c = null;
    private static PdVector[] m_jc = null;

    public double[] getEntries() {
        return (double[])this.m_data.clone();
    }

    public int getSecondVertexOfEdge() {
        int i;
        int ind = this.isOnEdge();
        if (ind == -1) {
            return -1;
        }
        if (this.m_data.length < 3) {
            return 1;
        }
        if (this.m_data.length == 3) {
            i = 0;
            while (i < this.m_data.length) {
                if (this.m_data[i] != 0.0 && this.m_data[(i + 1) % this.m_data.length] != 0.0) {
                    return (i + 1) % this.m_data.length;
                }
                ++i;
            }
        }
        i = this.m_data.length - 1;
        while (i >= 0) {
            if (this.m_data[i] != 0.0) {
                return i;
            }
            --i;
        }
        return 0;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("");
        strBuf.append(super.toString());
        strBuf.append("\t ******* PdBary *********\n");
        int size = this.getSize();
        strBuf.append("\t size\t = " + size + "\n");
        if (size > 0) {
            strBuf.append("\t m_data = (" + this.m_data[0]);
            int i = 1;
            while (i < size) {
                strBuf.append(", " + this.m_data[i]);
                ++i;
            }
            strBuf.append(")\n");
        } else {
            strBuf.append("\t m_data = null\n");
        }
        return strBuf.toString();
    }

    public PdBary() {
    }

    public PdBary(int aSize) {
        this.m_data = new double[aSize];
    }

    public PdBary(double x, double y) {
        this(2);
        this.m_data[0] = x;
        this.m_data[1] = y;
    }

    public PdBary(double x, double y, double z) {
        this(3);
        this.m_data[0] = x;
        this.m_data[1] = y;
        this.m_data[2] = z;
    }

    public PdBary(double x, double y, double z, double w) {
        this(4);
        this.m_data[0] = x;
        this.m_data[1] = y;
        this.m_data[2] = z;
        this.m_data[3] = w;
    }

    public String toShortString() {
        int j;
        StringBuffer strBuf = new StringBuffer("");
        int size = this.getSize();
        if (this.m_data == null || size == 0) {
            strBuf.append("{ m_data = null} \t");
        } else {
            strBuf.append("{ " + String.valueOf(this.m_data[0]));
            j = 1;
            while (j < size) {
                strBuf.append(", " + String.valueOf(this.m_data[j]));
                ++j;
            }
            strBuf.append("} \t");
        }
        strBuf.append("Attr = ");
        if (this.m_bits == null) {
            strBuf.append("{ } \t");
        } else {
            strBuf.append("{ " + PuString.intToString((int)this.m_bits[0], 4));
            j = 1;
            while (j < this.m_bits.length) {
                strBuf.append("\t " + PuString.intToString((int)this.m_bits[j], 4));
                ++j;
            }
            strBuf.append("} \t");
        }
        strBuf.append("\n");
        return strBuf.toString();
    }

    public double getEntry(int ind) {
        if (ind < 0 || this.m_data == null || this.m_data.length <= ind) {
            PsDebug.warning("index out of range, index=" + ind);
            return 0.0;
        }
        return this.m_data[ind];
    }

    public void setEntry(int ind, double value) {
        if (this.m_data == null || this.m_data.length <= ind) {
            this.setSize(ind + 1);
        }
        this.m_data[ind] = value;
    }

    public int isOnVertex() {
        if (this.m_data == null) {
            return -1;
        }
        this.validate();
        int i = 0;
        while (i < this.m_data.length) {
            if (this.m_data[i] == 1.0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void getVertex(PdVector p, PdBary bary, PdVector v0, PdVector v1, PdVector v2) {
        int dim = v0.getSize();
        double[] b = bary.m_data;
        int i = 0;
        while (i < dim) {
            p.m_data[i] = b[0] * v0.m_data[i] + b[1] * v1.m_data[i] + b[2] * v2.m_data[i];
            ++i;
        }
    }

    public int isOnEdge() {
        if (this.m_data == null) {
            return -1;
        }
        if (this.m_data.length <= 3) {
            return this.isOnFace();
        }
        this.validate();
        int count = 0;
        int i = 0;
        while (i < this.m_data.length) {
            if (this.m_data[i] == 0.0) {
                return count++;
            }
            ++i;
        }
        if (count == 2) {
            return 1;
        }
        return -1;
    }

    public int getFirstVertexOfEdge() {
        int i;
        int ind = this.isOnEdge();
        if (ind == -1) {
            return -1;
        }
        if (this.m_data.length < 3) {
            return ind;
        }
        if (this.m_data.length == 3) {
            i = 0;
            while (i < this.m_data.length) {
                if (this.m_data[i] != 0.0 && this.m_data[(i + 1) % this.m_data.length] != 0.0) {
                    return i;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.m_data.length) {
            if (this.m_data[i] != 0.0) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void validate() {
        if (this.m_data == null) {
            return;
        }
        double sum = 0.0;
        int i = 0;
        while (i < this.m_data.length) {
            if (Math.abs(this.m_data[i]) < 1.0E-10) {
                this.m_data[i] = 0.0;
            } else {
                sum += this.m_data[i];
            }
            ++i;
        }
        if (Math.abs(sum - 1.0) < 1.0E-10) {
            return;
        }
        i = 0;
        while (i < this.m_data.length) {
            if (this.m_data[i] != 0.0) {
                int n = i;
                this.m_data[n] = this.m_data[n] / sum;
            }
            ++i;
        }
    }

    public static PdBary copyNew(PdBary v) {
        if (v == null) {
            PsDebug.warning("missing argument vector");
            return null;
        }
        if (v.m_data == null) {
            PsDebug.warning("missing data of argument vector.");
            return null;
        }
        PdBary newBary = new PdBary(v.getSize());
        newBary.copy(v);
        return newBary;
    }

    public void copy(PdBary vec) {
        if (vec == null) {
            PsDebug.warning("missing argument");
            return;
        }
        super.copy(vec);
        if (vec.m_data == null) {
            this.m_data = null;
            return;
        }
        if (this.m_data == null || this.m_data.length != vec.getSize()) {
            this.setSize(vec.getSize());
        }
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = vec.m_data[i];
            ++i;
        }
    }

    public int getSize() {
        if (this.m_data == null) {
            return 0;
        }
        return this.m_data.length;
    }

    public int setSize(int aSize) {
        if (this.m_data == null || this.m_data.length != aSize) {
            this.m_data = PuData.realloc(this.m_data, aSize);
        }
        return aSize;
    }

    public Object clone() {
        return PdBary.copyNew(this);
    }

    public static void getBary(PdBary bary, PdVector p, PdVector v0, PdVector v1, PdVector v2) {
        int i;
        PdVector[] v = new PdVector[]{v0, v1, v2};
        if (m_c == null) {
            m_c = new PdVector[3];
            i = 0;
            while (i < 3) {
                PdBary.m_c[i] = new PdVector(3);
                ++i;
            }
        }
        if (m_jc == null) {
            m_jc = new PdVector[3];
            i = 0;
            while (i < 3) {
                PdBary.m_jc[i] = new PdVector(3);
                ++i;
            }
        }
        int size = v0.getSize();
        if (m_c[0].getSize() != size) {
            i = 0;
            while (i < 3) {
                m_c[i].setSize(size);
                m_jc[i].setSize(size);
                ++i;
            }
        }
        i = 0;
        while (i < 3) {
            m_c[i].copy(v[(i + 2) % 3]);
            m_c[i].sub(v[(i + 1) % 3]);
            ++i;
        }
        int i2 = 2;
        i = 0;
        while (i < 3) {
            double cSqrNorm = m_c[i].sqrLength();
            double skp = PdVector.dot(m_c[i], m_c[i2]);
            m_jc[i].blend(1.0, m_c[i2], -skp / cSqrNorm, m_c[i]);
            if (++i2 == 3) {
                i2 = 0;
            }
            ++i;
        }
        double sum = 0.0;
        i = 0;
        while (i < 3) {
            bary.m_data[i] = PdVector.area(p, v[(i + 1) % 3], v[(i + 2) % 3]);
            m_c[0].copy(p);
            m_c[0].sub(v[(i + 1) % 3]);
            if (PdVector.dot(m_jc[i], m_c[0]) < 0.0) {
                int n = i;
                bary.m_data[n] = bary.m_data[n] * -1.0;
            }
            sum += bary.m_data[i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            int n = i++;
            bary.m_data[n] = bary.m_data[n] / sum;
        }
    }

    public static void getBary(PdBary bary, PdVector p, PdVector v0, PdVector v1) {
        PdVector[] v = new PdVector[]{v0, v1};
        double sum = 0.0;
        int i = 0;
        while (i < 2) {
            bary.m_data[i] = PdVector.dot(PdVector.subNew(v[i], v[(i + 1) % 2]), PdVector.subNew(p, v[(i + 1) % 2]));
            sum += bary.m_data[i];
            ++i;
        }
        i = 0;
        while (i < 2) {
            int n = i++;
            bary.m_data[n] = bary.m_data[n] / sum;
        }
    }

    public boolean isInside() {
        if (this.m_data == null) {
            return false;
        }
        this.validate();
        int i = 0;
        while (i < this.m_data.length) {
            if (this.m_data[i] < 0.0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int isOnFace() {
        if (this.m_data == null) {
            return -1;
        }
        if (this.m_data.length == 2) {
            return this.isOnVertex();
        }
        this.validate();
        int i = 0;
        while (i < this.m_data.length) {
            if (this.m_data[i] == 0.0) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

