/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import com.wolfram.jlink.StdLink;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jv.anim.PsAnimation;
import jv.anim.PsTimeListenerIf;
import jv.loader.PSGr;
import jv.loader.PgFileDialog;
import jv.loader.PgLoader;
import jv.loader.PjImportModel;
import jv.loader.PjImportModel_Dialog;
import jv.loader.PsCategoryList_IP;
import jv.loader.PsXmlLoader;
import jv.loader.PvDisplayOption;
import jv.number.PdColor;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsConsole;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsMainFrame;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.object.PsUtil;
import jv.object.PsViewerIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.rsrc.PsJavaView;
import jv.vecmath.PdVector;
import jv.viewer.PsAboutApplet;
import jv.viewer.PsAboutDialog;
import jv.viewer.PvControl;
import jv.viewer.PvDisplay;
import jv.viewer.PvDisplayHelp;
import jvx.rsrc.PsModelInfo;

public final class PvViewer
extends PsObject
implements PvViewerIf,
KeyListener,
WindowListener,
Serializable {
    private static final String[][] PROJECTS = new String[][]{{PsConfig.getMessage("Curves"), PsConfig.getMessage("ClassicCurves"), "vgp.curve.surface.PjSurfCurve"}, {PsConfig.getMessage("Curves"), PsConfig.getMessage("Geodesics"), "vgp.curve.geodesic.PjGeodesic"}, {PsConfig.getMessage("Curves"), PsConfig.getMessage("TorusKnots"), "vgp.tutor.torusknot.PjTorusKnot"}, {PsConfig.getMessage("Curves"), PsConfig.getMessage("CycloidCurves"), "vgp.curve.cycloid.PjCycloid"}, {PsConfig.getMessage("Curves"), PsConfig.getMessage("ElasticCurves"), "vgp.curve.elastic.PjElasticCurve"}, {PsConfig.getMessage("Games"), PsConfig.getMessage("Game of Life"), "vgp.game.life.PjLife"}, {PsConfig.getMessage("Games"), PsConfig.getMessage("Minesweeper"), "vgp.game.mines.PjMinesweeper"}, {PsConfig.getMessage("Images"), PsConfig.getMessage("MandelbrotSet"), "vgp.tutor.fractal.PjFractalImage"}, {PsConfig.getMessage("Images"), PsConfig.getMessage("TexturedCube"), "vgp.tutor.texture.PjTextureCube"}, {PsConfig.getMessage("Maps"), PsConfig.getMessage("ConformalMaps"), "vgp.discrete.conformal.PjConformal"}, {PsConfig.getMessage("Maps"), PsConfig.getMessage("ConjugateMaps"), "vgp.discrete.conjugate.PjConjugate"}, {PsConfig.getMessage("Maps"), PsConfig.getMessage("HarmonicMaps"), "vgp.discrete.harmonic.PjHarmonic"}, {PsConfig.getMessage("Models"), PsConfig.getMessage("BrowseModels"), "jv.loader.PjImportModel"}, {PsConfig.getMessage("Models"), PsConfig.getMessage("ModelFromURL"), "vgp.tutor.model.PjModel"}, {PsConfig.getMessage("Models"), PsConfig.getMessage("KeyframeAnimation"), "vgp.tutor.key.PjKeyframe"}, {PsConfig.getMessage("Numeric"), PsConfig.getMessage("ODESolver"), "vgp.tutor.ode.PjExprOde"}, {PsConfig.getMessage("Numeric"), PsConfig.getMessage("EnergyMinimization"), "vgp.discrete.harmonic.PjHarmonic"}, {PsConfig.getMessage("Numeric"), PsConfig.getMessage("RootFinder"), "vgp.tutor.rootFinder.PjRootFinder"}, {PsConfig.getMessage("Surfaces"), PsConfig.getMessage("ClassicSurfaces"), "vgp.surface.common.PjSurface"}, {PsConfig.getMessage("Surfaces"), PsConfig.getMessage("DiscreteCatenoid"), "vgp.discrete.catenoid.PjCatenoid"}, {PsConfig.getMessage("Surfaces"), PsConfig.getMessage("Weierstrass"), "vgp.minimal.weier.PjWeierstrass"}, {PsConfig.getMessage("Surfaces"), PsConfig.getMessage("ParametrizedSurface"), "vgp.tutor.parm.PjParmSurface"}, {PsConfig.getMessage("Surfaces"), PsConfig.getMessage("PlatonicSolids"), "vgp.discrete.platonic.PjPlatonic"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("FirstProject"), "vgp.tutor.firstProject.MyProject"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("LSystem"), "vgp.tutor.lsystem.PjLSystem"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("CameraEvents"), "vgp.tutor.eventCamera.PjEventCamera"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("PickEvents"), "vgp.tutor.pick.PjPickEvent"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("PolygonSet"), "vgp.tutor.polygonSet.PjPolygonSet"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("RivaraBisection"), "vgp.tutor.rivara.PjRivara"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("ScalarField"), "vgp.tutor.height.PjHeight"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("TextureMaps"), "vgp.tutor.texture.PjTexturedSurface"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("4DCube"), "vgp.tutor.transform.PjTransform"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("VectorField"), "vgp.tutor.vectorField.PjVectorField"}, {PsConfig.getMessage("Vector"), PsConfig.getMessage("TangentialFields"), "vgp.vector.vectorField.PjVectorField"}, {PsConfig.getMessage("Vector"), PsConfig.getMessage("HodgeDecomposition"), "vgp.vector.hodge.PjHodge"}, {PsConfig.getMessage("Vector"), PsConfig.getMessage("LineIntegralConv"), "vgp.vector.lic.PjLIC"}};
    private static final String[][] GEOMETRIES = new String[][]{{PsConfig.getMessage("Geometry"), PsConfig.getMessage("Point Set"), "jv.geom.PgPointSet"}, {PsConfig.getMessage("Geometry"), PsConfig.getMessage("Polygon"), "jv.geom.PgPolygon"}, {PsConfig.getMessage("Geometry"), PsConfig.getMessage("Polygon Set"), "jv.geom.PgPolygonSet"}, {PsConfig.getMessage("Geometry"), PsConfig.getMessage("Element Set"), "jv.geom.PgElementSet"}};
    protected PsJavaView m_jvRsrc;
    protected Applet m_applet;
    protected Frame m_frame;
    protected String[][] m_parm;
    protected Vector m_displayVector;
    protected PvDisplayIf m_mainDisplay;
    protected PvDisplayIf m_display;
    protected PvControl m_control;
    protected boolean m_controlShow = false;
    protected transient PvDisplayHelp m_help;
    protected transient PjImportModel_Dialog m_importModelDialog;
    protected int[] m_controlSize = new int[]{5, 5, 370, 680};
    protected int[] m_aboutSize = new int[]{10, 10, 400, 450};
    protected int[] m_helpSize = new int[]{10, 10, 400, 450};
    protected int[] m_consoleSize = new int[]{10, 10, 500, 350};
    protected int[] m_animationSize = new int[]{10, 10, 400, 300};
    protected int[] m_newProjectSize = new int[]{10, 10, 400, 350};
    protected int[] m_importModelSize = new int[]{10, 10, 400, 400};
    protected int[] m_exportBounds = new int[]{10, 10, 400, 600};
    protected String m_imageDirName = null;
    protected String m_importDirName = null;
    protected String m_exportDirName = null;
    protected String m_serialDirName = null;
    protected Hashtable m_geometryCategory;
    protected Hashtable m_geometryClass;
    protected Hashtable m_projectCategory;
    protected Hashtable m_projectList;
    protected Hashtable m_projectClass;
    protected Hashtable m_projectParms;
    protected PjProject m_currentProject;
    protected PgGeometryIf m_currentGeometry;
    private int m_showPanel = -1;
    private boolean m_bShowingDialog = false;
    private boolean m_bStarted = false;
    protected Vector m_frameVector;
    protected boolean m_bHasArchiveJvx = false;
    private boolean m_bIsArchiveTestedJvx = false;

    public boolean showDialog(int aDialog) {
        Point pos;
        PgFileDialog fd = null;
        String fileName = null;
        String ext = null;
        if (this.m_control != null && this.m_control.isShowing()) {
            pos = this.m_control.getLocation();
            Dimension size = this.m_control.getSize();
            this.m_controlSize[0] = size.width;
            this.m_controlSize[1] = size.height;
        } else {
            pos = new Point(this.m_controlSize[0], this.m_controlSize[1]);
        }
        this.m_bShowingDialog = true;
        switch (aDialog) {
            case 21: {
                PsAboutDialog about = new PsAboutDialog(PsConfig.getFrame());
                ((Component)about).setLocation(pos.x + this.m_aboutSize[0], pos.y + this.m_aboutSize[1]);
                ((Component)about).setSize(this.m_aboutSize[2], this.m_aboutSize[3]);
                about.validate();
                about.setModal(true);
                ((Component)about).setVisible(true);
                break;
            }
            case 22: {
                PsAboutApplet aboutApplet = new PsAboutApplet(PsConfig.getFrame());
                ((Component)aboutApplet).setLocation(pos.x + this.m_aboutSize[0] + 20, pos.y + this.m_aboutSize[1] + 20);
                ((Component)aboutApplet).setSize(this.m_aboutSize[2], this.m_aboutSize[3]);
                aboutApplet.validate();
                aboutApplet.setModal(true);
                ((Component)aboutApplet).setVisible(true);
                break;
            }
            case 20: {
                if (this.m_jvRsrc == null) break;
                this.m_jvRsrc.showInfoPanel();
                break;
            }
            case 23: {
                PsDialog animationPanel = null;
                if (this.m_currentProject != null && this.m_currentProject.hasAnimation()) {
                    animationPanel = this.m_currentProject.getAnimation().getAnimationPanel();
                }
                if (animationPanel == null && this.m_currentGeometry != null) {
                    PsTimeListenerIf tl;
                    PsUpdateIf upd = this.m_currentGeometry;
                    while (upd != null && !(upd instanceof PsTimeListenerIf)) {
                        upd = upd.getFather();
                    }
                    if (upd != null && (tl = (PsTimeListenerIf)((Object)upd)).hasAnimation()) {
                        animationPanel = tl.getAnimation().getAnimationPanel();
                    }
                }
                if (animationPanel == null) {
                    PsDebug.warning("missing animation");
                    this.m_bShowingDialog = false;
                    return false;
                }
                ((Component)animationPanel).setLocation(pos.x, pos.y + this.m_controlSize[3] - this.m_animationSize[3]);
                ((Component)animationPanel).setSize(this.m_animationSize[2], this.m_animationSize[3]);
                ((Component)animationPanel).setVisible(true);
                break;
            }
            case 25: {
                Frame frame;
                boolean bJustCreated = PsDebug.hasConsole();
                PsConsole console = PsDebug.getConsole();
                if (console == null) {
                    PsDebug.error("missing console panel", this);
                    this.m_bShowingDialog = false;
                    return false;
                }
                if (!bJustCreated) {
                    if (this.m_control != null && this.m_control.isShowing()) {
                        console.setLocation(pos.x, pos.y + this.m_controlSize[3]);
                    } else {
                        console.setLocation(this.m_consoleSize[0], this.m_consoleSize[1]);
                    }
                    ((Component)console).setSize(this.m_consoleSize[2], this.m_consoleSize[3]);
                }
                ((Component)console).setVisible(true);
                if (!PsConfig.isApplication() || this.m_display == null || (frame = this.m_display.getFrame()) == null) break;
                frame.toFront();
                break;
            }
            case 24: {
                Frame frame;
                if (this.m_control == null) {
                    this.m_control = this.getControl();
                    if (this.m_control == null) {
                        PsDebug.warning("missing control panel");
                        this.m_bShowingDialog = false;
                        return false;
                    }
                }
                this.m_control.setVisible(true);
                if (!PsConfig.isApplication() || this.m_display == null || (frame = this.m_display.getFrame()) == null) break;
                frame.toFront();
                break;
            }
            case 26: {
                if (!PsConfig.isApplication() && this.m_applet != null) {
                    try {
                        URL viewerHelp = new URL(PsConfig.getCodeBase() + "jars/help.html");
                        viewerHelp.openConnection();
                        viewerHelp.openStream();
                        this.m_applet.getAppletContext().showDocument(viewerHelp, "Help on Viewer");
                        break;
                    }
                    catch (Exception exc) {
                        PsDebug.warning("file not found = " + "jars/help.html");
                    }
                }
                if (this.m_help == null) {
                    this.m_help = new PvDisplayHelp(PsConfig.getFrame());
                }
                this.m_help.setLocation(pos.x + this.m_consoleSize[2] / 2, pos.y + this.m_consoleSize[3] / 5);
                ((Component)this.m_help).setSize(this.m_helpSize[2], this.m_helpSize[3]);
                ((Component)this.m_help).setVisible(true);
                break;
            }
            case 27: 
            case 28: {
                Enumeration<Object> e;
                PsDialog dialog;
                PsDebug.notify("add project");
                String[] cat = PvViewer.getCategories(this.m_projectCategory);
                String[][] entry = PvViewer.getEntries(this.m_projectCategory, cat);
                if (entry == null) {
                    PsDebug.warning("no registered projects");
                    break;
                }
                PsCategoryList_IP projIP = new PsCategoryList_IP();
                projIP.setCategories(cat, entry);
                if (aDialog == 28) {
                    projIP.setTitle("Project is added to current scene");
                    dialog = new PsDialog(PsConfig.getFrame(), "Select Add Project", true);
                } else {
                    projIP.setTitle("New project replaces current scene");
                    dialog = new PsDialog(PsConfig.getFrame(), "Select New Project", true);
                }
                dialog.setLayout(new BorderLayout());
                dialog.add("Center", projIP);
                dialog.add("South", dialog.getBottomButtons(5));
                dialog.setLocation(pos.x + this.m_newProjectSize[0], pos.y + this.m_newProjectSize[1]);
                ((Component)dialog).setSize(this.m_newProjectSize[2], this.m_newProjectSize[3]);
                dialog.validate();
                ((Component)dialog).setVisible(true);
                int userAction = dialog.getUserAction();
                if (userAction != 4) break;
                String selectedProj = projIP.getSelectedEntry();
                PsDebug.notify("project selected = " + selectedProj);
                if (selectedProj == null || selectedProj.equals("")) {
                    this.m_bShowingDialog = false;
                    return false;
                }
                if (aDialog == 27) {
                    e = this.m_projectList.keys();
                    while (e.hasMoreElements()) {
                        this.removeProject((String)e.nextElement());
                    }
                    if (this.m_displayVector != null) {
                        e = this.m_displayVector.elements();
                        while (e.hasMoreElements()) {
                            PvDisplayIf disp = (PvDisplayIf)e.nextElement();
                            if (this.m_mainDisplay != null && this.m_mainDisplay == disp) {
                                this.selectDisplay(disp);
                                this.m_mainDisplay.removeGeometries();
                                this.m_mainDisplay.setMajorMode(0);
                                this.m_mainDisplay.init();
                                continue;
                            }
                            this.removeDisplay(disp);
                        }
                    }
                }
                if (!this.selectProject(selectedProj)) {
                    this.m_bShowingDialog = false;
                    return false;
                }
                if (!PsConfig.isApplication()) break;
                e = this.m_frameVector.elements();
                while (e.hasMoreElements()) {
                    Frame frame = (Frame)e.nextElement();
                    PvDisplayIf disp = this.getDisplayOfFrame(frame);
                    if (disp == null || disp != this.m_mainDisplay) continue;
                    frame.setTitle(PsConfig.getProgram() + " v" + PsConfig.getVersion() + ": " + this.m_currentProject.getName());
                }
                break;
            }
            case 29: 
            case 30: {
                PsDialog dialog;
                PsDebug.notify("add geometry");
                String[] cat = PvViewer.getCategories(this.m_geometryCategory);
                String[][] entry = PvViewer.getEntries(this.m_geometryCategory, cat);
                if (entry == null) {
                    PsDebug.warning("no registered geometrys");
                    break;
                }
                PsCategoryList_IP projIP = new PsCategoryList_IP();
                projIP.setCategories(cat, entry);
                if (aDialog == 30) {
                    projIP.setTitle("Empty geometry is added to current scene");
                    dialog = new PsDialog(PsConfig.getFrame(), "Select Add Geometry", true);
                } else {
                    projIP.setTitle("New geometry replaces current scene");
                    dialog = new PsDialog(PsConfig.getFrame(), "Select New Geometry", true);
                }
                dialog.setLayout(new BorderLayout());
                dialog.add("Center", projIP);
                dialog.add("South", dialog.getBottomButtons(5));
                dialog.setLocation(pos.x + this.m_newProjectSize[0], pos.y + this.m_newProjectSize[1]);
                ((Component)dialog).setSize(this.m_newProjectSize[2], this.m_newProjectSize[3]);
                dialog.validate();
                ((Component)dialog).setVisible(true);
                int userAction = dialog.getUserAction();
                if (userAction != 4) break;
                String selectedProj = projIP.getSelectedEntry();
                PsDebug.notify("geometry selected = " + selectedProj);
                if (selectedProj == null || selectedProj.equals("")) {
                    this.m_bShowingDialog = false;
                    return false;
                }
                PgGeometryIf geom = this.getGeometry(selectedProj);
                if (geom == null) {
                    PsDebug.warning("failed to create geometry.");
                    this.m_bShowingDialog = false;
                    return false;
                }
                if (this.m_display == null) {
                    PsDebug.warning("missing display.");
                    this.newDisplay(geom.getName());
                }
                if (aDialog == 29) {
                    Enumeration e = this.m_projectList.keys();
                    while (e.hasMoreElements()) {
                        PjProject proj = this.getProject((String)e.nextElement());
                        proj.removeGeometries();
                    }
                    this.m_display.removeGeometries();
                }
                if (this.m_currentProject != null) {
                    this.m_currentProject.setParent(geom);
                    this.m_currentProject.addGeometry(geom);
                }
                this.m_display.addGeometry(geom);
                this.m_display.selectGeometry(geom);
                this.m_display.update(this.m_display);
                break;
            }
            case 31: {
                PsDebug.notify("import model into current project's geometry");
                if (this.m_importModelDialog != null && this.m_importModelDialog.isShowing()) break;
                PjImportModel impModel = new PjImportModel();
                this.m_importModelDialog = new PjImportModel_Dialog(PsConfig.getFrame());
                this.m_importModelDialog.setParent(impModel);
                this.m_importModelDialog.update(impModel);
                this.m_importModelDialog.setLocation(pos.x + this.m_importModelSize[0], pos.y + this.m_importModelSize[1]);
                ((Component)this.m_importModelDialog).setSize(this.m_importModelSize[2], this.m_importModelSize[3]);
                if (this.m_currentProject != null) {
                    impModel.setParentProject(this.m_currentProject);
                    ((Component)this.m_importModelDialog).setVisible(true);
                    break;
                }
                this.m_importModelDialog.setModal(true);
                if (this.m_display != null && impModel.getGeometry() != null) {
                    impModel.setDisplay(this.m_display);
                    ((Component)this.m_importModelDialog).setVisible(true);
                    impModel.removeDisplay(this.m_display);
                    if (impModel.getConfirm() == PjImportModel.CONFIRM_CANCEL) {
                        int numGeom = impModel.getNumGeometries();
                        int i = 0;
                        while (i < numGeom) {
                            this.m_display.removeGeometry(impModel.getGeometry(i));
                            ++i;
                        }
                        this.m_display.update(this.m_display);
                    } else {
                        this.m_display.selectGeometry(impModel.getGeometry(0));
                    }
                    if (this.m_display.getNumGeometries() == 1) {
                        this.m_display.fit();
                    }
                    this.m_bShowingDialog = false;
                    return true;
                }
                PsDebug.warning("no project or display available to add geometry.");
                this.m_bShowingDialog = false;
                return false;
            }
            case 32: {
                if (this.m_importDirName == null) {
                    this.m_importDirName = PsConfig.getCodeBase() + "models/";
                }
                fd = new PgFileDialog(PsConfig.getFrame(), "Open Geometry", 0);
                fd.setDirectory(this.m_importDirName);
                fd.setVisible(true);
                fileName = fd.getFile();
                if (fileName == null) {
                    PsDebug.notify("dialog cancelled");
                    break;
                }
                this.m_importDirName = fd.getDirectory();
                fileName = this.m_importDirName + fileName;
                fileName.trim();
                if (fileName.endsWith("jvd")) {
                    BufferedReader in = PsUtil.open(fileName);
                    if (in == null) {
                        PsDebug.warning("could not open file = " + fileName);
                        break;
                    }
                    PvDisplayOption[] option = PgLoader.loadDisplay(in, "jvd");
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    if (option == null) {
                        PsDebug.warning("error when reading file = " + fileName);
                        break;
                    }
                    if (this.m_display == null) break;
                    option[0].configure(this.m_display);
                    this.m_display.update(this.m_display);
                    break;
                }
                PjImportModel pjImportDisk = new PjImportModel();
                if (this.m_currentProject != null) {
                    pjImportDisk.setParentProject(this.m_currentProject);
                }
                if (!pjImportDisk.load(fileName) || this.m_currentProject != null || this.m_display == null) break;
                int numGeom = pjImportDisk.getNumGeometries();
                int i = 0;
                while (i < numGeom) {
                    this.m_display.addGeometry(pjImportDisk.getGeometry(i));
                    ++i;
                }
                if (numGeom != 0) {
                    this.m_display.selectGeometry(pjImportDisk.getGeometry(0));
                }
                if (this.m_display.getNumGeometries() == 1) {
                    this.m_display.fit();
                }
                this.m_display.update(this.m_display);
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 48: 
            case 351: {
                ext = aDialog == 33 ? "byu" : (aDialog == 34 ? "fe" : (aDialog == 35 ? "jvx" : (aDialog == 351 ? "jvx" : (aDialog == 36 ? "mgs" : (aDialog == 37 ? "mpl" : (aDialog == 38 ? "obj" : (aDialog == 39 ? "off" : (aDialog == 40 ? "wrl" : (aDialog == 48 ? "jvd" : "jvx")))))))));
                if (PsConfig.isApplication()) {
                    if (this.m_exportDirName == null) {
                        this.m_exportDirName = PsConfig.getCodeBase() + "models/";
                    }
                    fd = new PgFileDialog(PsConfig.getFrame(), "Save", 1);
                    fd.setDirectory(this.m_exportDirName);
                    fd.setExtension(ext);
                    fd.setVisible(true);
                    fileName = fd.getFullFileName();
                    if (fileName == null) {
                        PsDebug.notify("dialog cancelled");
                        this.m_bShowingDialog = false;
                        return false;
                    }
                    this.m_exportDirName = fd.getDirectory();
                }
                if (fileName == null) {
                    fileName = "javaview." + ext;
                }
                this.export(aDialog, fileName);
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                if (!PsConfig.isApplication()) {
                    PsDebug.warning("cannot export image in applet mode.");
                    this.m_bShowingDialog = false;
                    return false;
                }
            }
            case 46: 
            case 47: {
                ext = aDialog == 41 ? "gif" : (aDialog == 42 ? "001.gif" : (aDialog == 43 ? "ppm" : (aDialog == 44 ? "001.ppm" : (aDialog == 47 ? "ps" : (aDialog == 46 ? "eps" : "ppm")))));
                if (this.m_imageDirName == null) {
                    this.m_imageDirName = PsConfig.getCodeBase() + "images/";
                }
                if (PsConfig.isApplication()) {
                    fd = new PgFileDialog(PsConfig.getFrame(), "Save Image", 1);
                    fd.setDirectory(this.m_imageDirName);
                    fd.setExtension(ext);
                    fd.setVisible(true);
                    fileName = fd.getFullFileName();
                    if (fileName == null) {
                        PsDebug.notify("dialog cancelled");
                        this.m_bShowingDialog = false;
                        return false;
                    }
                    this.m_imageDirName = fd.getDirectory();
                }
                if (fileName == null) {
                    fileName = "javaview." + ext;
                }
                if (aDialog != 42 && aDialog != 44) {
                    this.m_bShowingDialog = false;
                    return this.export(aDialog, fileName);
                }
                PsAnimation anim = null;
                if (this.m_currentProject != null && this.m_currentProject.hasAnimation()) {
                    anim = this.m_currentProject.getAnimation();
                }
                if (anim == null && this.m_currentGeometry != null) {
                    PsUpdateIf upd = this.m_currentGeometry;
                    while (upd != null && !(upd instanceof PsTimeListenerIf)) {
                        upd = upd.getFather();
                    }
                    if (upd != null) {
                        PsTimeListenerIf tl = (PsTimeListenerIf)((Object)upd);
                        anim = tl.getAnimation();
                    }
                }
                if (anim != null && anim.isRunning()) {
                    anim.stop();
                }
                double time = 0.0;
                double timeIncr = 1.0;
                int numImages = 100;
                if (anim != null) {
                    double minTime = anim.getMinTime();
                    double maxTime = anim.getMaxTime();
                    timeIncr = anim.getTimePageIncr();
                    time = minTime;
                    numImages = 1 + (int)((maxTime - minTime) / timeIncr);
                    if (numImages > 999) {
                        PsDebug.warning("too many images, 999 < num = " + numImages);
                        this.m_bShowingDialog = false;
                        return false;
                    }
                } else if (this.m_display == null) {
                    PsDebug.warning("missing display");
                    return false;
                }
                ext = aDialog == 42 ? "gif" : "ppm";
                String fileBaseName = PsUtil.getFileBaseName(fd.getFile());
                if (fileBaseName.endsWith("001")) {
                    fileBaseName = PsUtil.getFileBaseName(fileBaseName);
                }
                int i = 0;
                while (i < numImages) {
                    if (anim != null) {
                        anim.setTime(time);
                        time += timeIncr;
                    } else if (this.m_display != null) {
                        this.m_display.incrementAutoRotation();
                    }
                    fileName = i < 9 ? fileBaseName + ".00" + (i + 1) + "." + ext : (i < 99 ? fileBaseName + ".0" + (i + 1) + "." + ext : fileBaseName + "." + (i + 1) + "." + ext);
                    if (!this.export(aDialog, this.m_imageDirName + "/" + fileName)) {
                        PsDebug.warning("error during animation export.");
                        this.m_bShowingDialog = false;
                        return false;
                    }
                    ++i;
                }
                break;
            }
            default: {
                PsDebug.warning("invalid dialog index = " + aDialog);
                this.m_bShowingDialog = false;
                return false;
            }
        }
        this.m_bShowingDialog = false;
        return true;
    }

    public PsDialog getDialog(int aDialog) {
        switch (aDialog) {
            case 23: {
                PsDialog animationPanel = null;
                if (this.m_currentProject != null && this.m_currentProject.getAnimation() != null) {
                    animationPanel = this.m_currentProject.getAnimation().getAnimationPanel();
                }
                return animationPanel;
            }
            case 25: {
                return PsDebug.getConsole();
            }
        }
        PsDebug.warning("invalid dialog index");
        return null;
    }

    private static String[][] getEntries(Hashtable cat, String[] category) {
        if (cat == null || category == null) {
            return null;
        }
        int numCat = category.length;
        String[][] entry = new String[numCat][];
        int numEntries = cat.size();
        int i = 0;
        while (i < numCat) {
            String[] entryTmp = new String[numEntries];
            int numEntriesPerCat = 0;
            Enumeration e = cat.keys();
            while (e.hasMoreElements()) {
                String currEntry = (String)e.nextElement();
                String currCat = (String)cat.get(currEntry);
                if (!currCat.equals(category[i])) continue;
                entryTmp[numEntriesPerCat++] = currEntry;
            }
            entry[i] = new String[numEntriesPerCat];
            if (numEntriesPerCat != 0) {
                int j = 0;
                while (j < numEntriesPerCat) {
                    entry[i][j] = entryTmp[j];
                    ++j;
                }
                PuString.sort(entry[i]);
            }
            ++i;
        }
        return entry;
    }

    private int getNumDisplays() {
        if (this.m_displayVector == null) {
            return 0;
        }
        return this.m_displayVector.size();
    }

    public boolean hideDialog(int aDialog) {
        switch (aDialog) {
            case 23: {
                Component animationPanel = null;
                if (this.m_currentProject != null && this.m_currentProject.getAnimation() != null) {
                    animationPanel = this.m_currentProject.getAnimation().getAnimationPanel();
                }
                if (animationPanel == null) {
                    return true;
                }
                animationPanel.setVisible(false);
                return true;
            }
            case 25: {
                if (PsDebug.hasConsole()) {
                    ((Component)PsDebug.getConsole()).setVisible(false);
                }
                return true;
            }
            case 24: {
                this.m_controlShow = false;
                if (this.m_control != null) {
                    this.m_control.setVisible(false);
                }
                return true;
            }
            case 26: {
                if (this.m_help != null) {
                    ((Component)this.m_help).setVisible(false);
                }
                return true;
            }
        }
        PsDebug.notify("invalid dialog index");
        return false;
    }

    public void keyPressed(KeyEvent event) {
        int key = event.getKeyCode();
        switch (key) {
            case 112: {
                this.showDialog(24);
                return;
            }
            case 113: {
                this.hideDialog(24);
                return;
            }
            case 114: {
                this.showDialog(25);
                return;
            }
            case 115: {
                this.showDialog(23);
                return;
            }
        }
        if (!event.isControlDown()) {
            return;
        }
        switch (key) {
            case 88: {
                if (!event.isShiftDown()) break;
                this.destroy();
                break;
            }
            case 83: {
                this.showDialog(24);
                break;
            }
            case 68: {
                this.showDialog(25);
                break;
            }
            case 65: {
                this.showDialog(23);
                break;
            }
            case 80: {
                if (event.isShiftDown() && this.m_control != null) {
                    this.m_control.releasePanel(10);
                    break;
                }
                this.showPanel(10);
                this.enablePanel(10, true);
                this.showDialog(24);
                break;
            }
            case 73: {
                this.showPanel(12);
                this.enablePanel(12, true);
                this.showDialog(24);
                break;
            }
            case 77: {
                this.showPanel(13);
                this.enablePanel(13, true);
                this.showDialog(24);
                break;
            }
            case 84: {
                this.showPanel(14);
                this.enablePanel(14, true);
                this.showDialog(24);
                break;
            }
            case 79: {
                if (PsConfig.isApplication()) {
                    this.showDialog(32);
                    break;
                }
                this.showDialog(31);
                break;
            }
            case 67: {
                this.showPanel(16);
                this.showDialog(24);
                break;
            }
            case 86: {
                this.showPanel(17);
                this.showDialog(24);
                break;
            }
            default: {
                return;
            }
        }
        if (this.m_display != null) {
            ((PvDisplay)this.m_display).requestFocus();
        }
    }

    private PvDisplayIf getDisplayOfFrame(Frame frame) {
        Component[] compList = frame.getComponents();
        int i = 0;
        while (i < compList.length) {
            if (compList[i] instanceof PvDisplayIf) {
                return (PvDisplayIf)((Object)compList[i]);
            }
            if (compList[i] instanceof Applet) {
                Component[] appletCompList = ((Applet)compList[i]).getComponents();
                int j = 0;
                while (j < appletCompList.length) {
                    if (appletCompList[j] instanceof PvDisplayIf) {
                        return (PvDisplayIf)((Object)appletCompList[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public boolean hasProject(String name) {
        return this.m_projectList.containsKey(name);
    }

    public boolean removeProject(String aName) {
        if (aName == null) {
            PsDebug.warning("missing project name");
            return false;
        }
        if (this.m_currentProject == null) {
            PsDebug.notify("empty current project");
            return false;
        }
        PjProject proj = this.getProject(aName);
        if (proj == null) {
            PsDebug.warning("missing project = " + aName);
            return false;
        }
        if (this.m_currentProject == proj) {
            if (this.m_control != null) {
                this.m_control.removeProject(this.m_currentProject);
            }
            this.m_currentProject = null;
        }
        this.m_projectList.remove(aName);
        proj.dispose();
        return true;
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
        if (!(event.getSource() instanceof Frame)) {
            return;
        }
        Frame frame = (Frame)event.getSource();
        if (frame == this.m_control || this.m_bShowingDialog) {
            return;
        }
        PvDisplayIf disp = this.getDisplayOfFrame(frame);
        if (disp == null) {
            return;
        }
        this.selectDisplay(disp);
    }

    public void enableMenu(int menuId, boolean cond) {
        if (this.m_control != null) {
            this.m_control.enableMenu(menuId, cond);
        }
    }

    protected void serialize(String name) {
        Object obj = null;
        if (name.equalsIgnoreCase(PsConfig.getMessage("mFile_Export_Serialize_Display"))) {
            obj = this.getDisplay();
        } else if (name.equalsIgnoreCase(PsConfig.getMessage("mFile_Export_Serialize_Geometry"))) {
            obj = this.getDisplay().getSelectedGeometry();
        } else if (name.equalsIgnoreCase(PsConfig.getMessage("mFile_Export_Serialize_Applet"))) {
            obj = this.getApplet();
        } else if (name.equalsIgnoreCase(PsConfig.getMessage("mFile_Export_Serialize_Project"))) {
            obj = this.m_currentProject;
        } else {
            return;
        }
        if (obj == null) {
            PsDebug.warning("missing object to serialize.");
            return;
        }
        if (!PsConfig.isApplication()) {
            return;
        }
        PgFileDialog fd = new PgFileDialog(PsConfig.getFrame(), "Serialization", 1);
        fd.setFile(obj.getClass().getName() + ".ser");
        if (this.m_exportDirName == null) {
            this.m_exportDirName = PsConfig.getCodeBase() + "dev/models/serialized/";
        }
        fd.setDirectory(this.m_exportDirName);
        fd.setExtension("ser");
        fd.setVisible(true);
        String fileName = fd.getFullFileName();
        if (fileName == null) {
            PsDebug.notify("dialog cancelled");
            return;
        }
        this.m_exportDirName = fd.getDirectory();
        try {
            FileOutputStream out = new FileOutputStream(fileName);
            ObjectOutputStream s = new ObjectOutputStream(out);
            s.writeObject(obj);
            s.flush();
            s.close();
            out.close();
        }
        catch (NotSerializableException io) {
            PsDebug.message(io.toString());
        }
        catch (IOException io) {
            PsDebug.message(io.toString());
        }
    }

    public boolean export(int aDialog, String fileName) {
        if (this.m_display == null) {
            return false;
        }
        PvDisplayOption dispOption = null;
        switch (aDialog) {
            case 39: 
            case 48: {
                if (this.m_display == null) break;
                dispOption = new PvDisplayOption();
                dispOption.setOptions(this.m_display);
            }
        }
        switch (aDialog) {
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 351: {
                PgLoader.setDisplayOption(dispOption);
                PgLoader.setEnabledSmallSize(351 == aDialog);
                PgLoader.save(this.m_display.getGeometries(), fileName);
                break;
            }
            case 48: {
                PgLoader.saveDisplay(new PvDisplayOption[]{dispOption}, fileName);
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.m_display.setPaintTag(4, false);
                ((PvDisplay)this.m_display).update(this.m_display.getGraphics());
                Image dispImage = this.m_display.getImage();
                PgLoader.save(dispImage, fileName);
                this.m_display.setPaintTag(4, true);
                ((PvDisplay)this.m_display).update(this.m_display.getGraphics());
                break;
            }
            case 46: 
            case 47: {
                String geomName = null;
                geomName = this.m_currentGeometry != null ? this.m_currentGeometry.getName() : PsConfig.getProgram();
                Dimension size = this.m_display.getSize();
                PSGr ps = new PSGr(this.m_display.getGraphics(), geomName, size.width, size.height);
                PvDisplay disp = (PvDisplay)this.m_display;
                boolean bIsShowingBorder = disp.hasPaintTag(4);
                boolean bIsEnabledNewZBuffer = disp.isEnabledNewZBuffer();
                disp.setPaintTag(4, false);
                if (!(disp.isEnabledZBuffer() || disp.m_scene.m_bUseTexture || disp.isShowingBackImage() && disp.getBackgroundImage() != null)) {
                    disp.setPaintTag(8, true);
                    ps.setZoom(PvDisplay.PS_ZOOM);
                }
                if (disp.isEnabledZBuffer() || disp.m_scene.m_bUseTexture) {
                    disp.setEnabledNewZBuffer(true);
                }
                disp.paintGeom(ps);
                if (disp.isEnabledZBuffer() || disp.m_scene.m_bUseTexture) {
                    disp.setEnabledNewZBuffer(bIsEnabledNewZBuffer);
                }
                if (!(disp.isEnabledZBuffer() || disp.m_scene.m_bUseTexture || disp.isShowingBackImage() && disp.getBackgroundImage() != null)) {
                    ps.setZoom(1.0f);
                    disp.setPaintTag(8, false);
                }
                disp.setPaintTag(4, bIsShowingBorder);
                String data = ps.toString();
                if (aDialog == 47) {
                    data = data + "showpage";
                }
                PgLoader.save(data, fileName);
                break;
            }
            default: {
                PsDebug.warning("invalid dialog index = " + aDialog);
                return false;
            }
        }
        return true;
    }

    public boolean export(int aDialog, String fileName, int width, int height) {
        PvDisplayIf disp = this.getDisplay();
        if (disp == null) {
            return false;
        }
        Dimension currDim = disp.getSize();
        if (height == -1) {
            height = (int)((float)width * (float)currDim.height / (float)currDim.width);
        }
        disp.setSizeWithinFrame(width, height);
        boolean val = this.export(aDialog, fileName);
        disp.setSizeWithinFrame(currDim.width, currDim.height);
        return val;
    }

    public String export(int aDialog) {
        String ext = null;
        switch (aDialog) {
            case 33: {
                ext = "byu";
                break;
            }
            case 34: {
                ext = "fe";
                break;
            }
            case 35: {
                ext = "jvx";
                break;
            }
            case 36: {
                ext = "mgs";
                break;
            }
            case 37: {
                ext = "mpl";
                break;
            }
            case 38: {
                ext = "obj";
                break;
            }
            case 39: {
                ext = "off";
                break;
            }
            case 40: {
                ext = "wrl";
                break;
            }
        }
        if (ext != null) {
            PgGeometryIf[] visibleGeom = null;
            if (this.m_display != null) {
                PgGeometryIf[] geom = this.m_display.getGeometries();
                if (geom == null) {
                    return null;
                }
                int numVisible = 0;
                int i = 0;
                while (i < geom.length) {
                    if (geom[i].isVisible()) {
                        ++numVisible;
                    }
                    ++i;
                }
                visibleGeom = new PgGeometryIf[numVisible];
                int ind = 0;
                int i2 = 0;
                while (i2 < geom.length) {
                    if (geom[i2].isVisible()) {
                        visibleGeom[ind++] = geom[i2];
                    }
                    ++i2;
                }
            } else {
                visibleGeom = new PgGeometryIf[]{this.m_currentGeometry};
            }
            return PgLoader.saveToString(visibleGeom, ext);
        }
        switch (aDialog) {
            case 47: {
                ext = "ps";
                break;
            }
            case 46: {
                ext = "eps";
                break;
            }
            default: {
                PsDebug.warning("invalid dialog index = " + aDialog);
                return null;
            }
        }
        if (ext != null) {
            String geomName = null;
            geomName = this.m_currentGeometry != null ? this.m_currentGeometry.getName() : PsConfig.getProgram();
            Dimension size = this.m_display.getSize();
            PSGr ps = new PSGr(this.m_display.getGraphics(), geomName, size.width, size.height);
            PvDisplay disp = (PvDisplay)this.m_display;
            if (!disp.isEnabledClip()) {
                if (!disp.isEnabledZBuffer() && !disp.m_scene.m_bUseTexture) {
                    disp.setPaintTag(8, true);
                    ps.setZoom(PvDisplay.PS_ZOOM);
                }
                Color backColor = disp.getBackgroundColor();
                disp.setBackgroundColor(Color.white);
                disp.paintGeom(ps);
                disp.setBackgroundColor(backColor);
                if (!disp.isEnabledZBuffer() && !disp.m_scene.m_bUseTexture) {
                    ps.setZoom(1.0f);
                    disp.setPaintTag(8, false);
                }
            } else {
                PsDebug.warning("PostScript export temporarily does not print high resolution when clipping enabled.\n\tDisable clipping in ->Panel->Camera->Clipping and print again.");
                disp.paintGeom(ps);
            }
            String data = ps.toString();
            if (aDialog == 47) {
                data = data + "showpage";
            }
            return data;
        }
        return null;
    }

    public Hashtable getProjectClasses() {
        return this.m_projectClass;
    }

    public PvDisplayIf getDisplay() {
        if (this.m_display == null) {
            this.m_display = new PvDisplay(this);
            this.addDisplay("DisplayAWT", this.m_display);
            if (this.m_currentProject != null && !this.m_currentProject.hasDisplay(this.m_display)) {
                this.m_currentProject.setDisplay(this.m_display);
            }
            this.selectDisplay(this.m_display);
        }
        return this.m_display;
    }

    public boolean selectDisplay(PvDisplayIf disp) {
        if (disp == null) {
            PsDebug.warning("missing argument display");
            return false;
        }
        if (!this.hasDisplay(disp)) {
            PsDebug.warning("display with name = " + disp.getName() + " not found.");
            return false;
        }
        this.m_display = disp;
        if (this.m_control != null && this.m_control.getDisplay() != this.m_display) {
            this.m_control.setDisplay(this.m_display);
        }
        if (this.m_display.getSelectedGeometry() != null && this.m_display.getSelectedGeometry() != this.m_currentGeometry) {
            this.setGeometry(this.m_display.getSelectedGeometry());
        }
        if (this.m_mainDisplay == null) {
            this.m_mainDisplay = this.m_display;
        }
        return true;
    }

    public PvDisplayIf[] getDisplays() {
        if (this.m_displayVector == null) {
            return null;
        }
        PvDisplayIf[] disp = new PvDisplayIf[this.m_displayVector.size()];
        int ind = 0;
        Enumeration e = this.m_displayVector.elements();
        while (e.hasMoreElements()) {
            disp[ind++] = (PvDisplayIf)e.nextElement();
        }
        return disp;
    }

    public Applet getApplet() {
        return this.m_applet;
    }

    public void keyTyped(KeyEvent event) {
    }

    public void destroy() {
        this.stop();
        if (this.m_currentProject != null) {
            this.m_currentProject.dispose();
        }
        if (PsConfig.getFrame() != null) {
            PsConfig.getFrame().dispose();
        }
        if (this.m_frameVector != null) {
            Enumeration e = this.m_frameVector.elements();
            while (e.hasMoreElements()) {
                Frame frame = (Frame)e.nextElement();
                ((Component)frame).setVisible(false);
                frame.dispose();
            }
        }
        PsDebug.disposeConsole();
        if (PsConfig.isApplication()) {
            try {
                if (StdLink.getLink() != null) {
                    return;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    private static String[] getCategories(Hashtable cat) {
        int j;
        if (cat == null || cat.size() == 0) {
            return null;
        }
        int numEntries = cat.size();
        String[] catTmp = new String[numEntries];
        int numCat = 0;
        Enumeration e = cat.elements();
        while (e.hasMoreElements()) {
            String currCat = (String)e.nextElement();
            boolean bContains = false;
            j = 0;
            while (j < numCat) {
                if (catTmp[j].equals(currCat)) {
                    bContains = true;
                    break;
                }
                ++j;
            }
            if (bContains) continue;
            catTmp[numCat++] = currCat;
        }
        if (numCat == 0) {
            return null;
        }
        String[] category = new String[numCat];
        j = 0;
        while (j < numCat) {
            category[j] = catTmp[j];
            ++j;
        }
        PuString.sort(category);
        return category;
    }

    public Frame getFrame() {
        return this.m_frame;
    }

    protected boolean selectFrame(Frame frame) {
        if (!this.hasFrame(frame)) {
            PsDebug.warning("frame not found.");
            return false;
        }
        PvDisplayIf disp = this.getDisplayOfFrame(frame);
        if (disp != null && this.hasDisplay(disp)) {
            this.selectDisplay(disp);
        }
        return true;
    }

    public void keyReleased(KeyEvent event) {
    }

    public void windowClosed(WindowEvent event) {
    }

    public void setGeometry(PgGeometryIf geom) {
        if (geom == null) {
            PsDebug.notify("setting null geometry.");
        }
        this.m_currentGeometry = geom;
        if (this.m_control != null) {
            this.m_control.setGeometry(geom);
        }
    }

    public PgGeometryIf getGeometry(String name) {
        PgGeometryIf geometry = null;
        String className = (String)this.m_geometryClass.get(name);
        if (className != null) {
            geometry = (PgGeometryIf)PsUtil.newInstance(className);
        }
        if (geometry == null) {
            PsDebug.warning("could not create instance of " + name, this);
            return null;
        }
        return geometry;
    }

    public void printParameter() {
        if (this.m_parm == null) {
            this.getParameter("Nothing");
        }
        if (this.m_parm == null) {
            PsDebug.message("empty parameter list.");
            return;
        }
        PsDebug.message("parameter list:");
        int i = 0;
        while (i < this.m_parm.length) {
            PsDebug.message("\t Parameter = " + this.m_parm[i][0] + ", Value = " + this.getParameter(this.m_parm[i][0]));
            ++i;
        }
    }

    public boolean addProject(String name, String className, String[] parmList) {
        return this.addProject(null, name, className, parmList);
    }

    public boolean addProject(PjProject aProject) {
        if (aProject == null) {
            PsDebug.warning("missing project");
            return false;
        }
        aProject.setViewer(this);
        String name = aProject.getName();
        if (name == null) {
            PsDebug.warning("missing project name");
            return false;
        }
        this.m_projectList.put(name, aProject);
        return true;
    }

    public boolean addProject(String category, String name, String className, String[] parmList) {
        if (name == null || className == null) {
            PsDebug.warning("missing name or class");
            return false;
        }
        if (this.m_projectClass.containsKey(name)) {
            PsDebug.warning("project name already exists, name = " + name + "\n\texisting name belong to class = " + (String)this.m_projectClass.get(name));
            return false;
        }
        if (category == null) {
            category = "Default";
        }
        this.m_projectCategory.put(name, category);
        this.m_projectClass.put(name, className);
        this.enableMenu(100, true);
        this.enableMenu(110, true);
        if (parmList != null) {
            this.m_projectParms.put(name, parmList);
        }
        return true;
    }

    public void init() {
        int i;
        String rsrcFileName;
        super.init();
        this.m_displayVector = new Vector();
        this.m_frameVector = new Vector();
        Frame frame = PsConfig.getFrame();
        if (frame != null) {
            this.addFrame(frame);
        }
        if ((rsrcFileName = this.getParameter("javaview-rsrc")) != null && !rsrcFileName.equals("")) {
            rsrcFileName = PsConfig.getCodeBase() + rsrcFileName;
            PsDebug.notify("using rsrc file = " + rsrcFileName);
            this.m_jvRsrc = new PsJavaView();
            if (this.m_jvRsrc.read(rsrcFileName)) {
                this.m_aboutSize = this.m_jvRsrc.getWindowSize(2);
                this.m_animationSize = this.m_jvRsrc.getWindowSize(5);
                this.m_consoleSize = this.m_jvRsrc.getWindowSize(4);
                this.m_controlSize = this.m_jvRsrc.getWindowSize(1);
                this.m_exportBounds = this.m_jvRsrc.getWindowSize(8);
                this.m_helpSize = this.m_jvRsrc.getWindowSize(3);
                this.m_importModelSize = this.m_jvRsrc.getWindowSize(7);
                this.m_newProjectSize = this.m_jvRsrc.getWindowSize(6);
            }
        }
        String menuNew = this.getParameter("menu-new-project");
        if (PROJECTS != null && (PsConfig.isApplication() || menuNew != null && menuNew.equalsIgnoreCase("enable"))) {
            i = 0;
            while (i < PROJECTS.length) {
                this.addProject(PROJECTS[i][0], PROJECTS[i][1], PROJECTS[i][2], null);
                ++i;
            }
        }
        if (GEOMETRIES != null) {
            i = 0;
            while (i < GEOMETRIES.length) {
                this.addGeometry(GEOMETRIES[i][0], GEOMETRIES[i][1], GEOMETRIES[i][2]);
                ++i;
            }
        }
    }

    public void windowIconified(WindowEvent event) {
    }

    public boolean showPanel(int aPanel) {
        this.m_showPanel = aPanel;
        if (this.m_control != null) {
            return this.m_control.showPanel(aPanel);
        }
        return true;
    }

    public boolean enablePanel(int aPanel, boolean cond) {
        if (this.m_control != null) {
            return this.m_control.enablePanel(aPanel, true);
        }
        return true;
    }

    public Panel getPanel(int aPanel) {
        if (this.m_control == null) {
            this.m_control = this.getControl();
        }
        return this.m_control.getPanel(aPanel);
    }

    public PjProject getCurrentProject() {
        return this.m_currentProject;
    }

    public void stop() {
        this.m_bStarted = false;
        if (this.m_help != null) {
            this.m_help.dispose();
            this.m_help = null;
        }
        if (this.m_control != null) {
            this.m_control.dispose();
            this.m_control = null;
        }
        if (this.m_currentProject != null) {
            this.m_currentProject.stop();
            this.m_currentProject = null;
        }
        PsDebug.notify("regular stop");
        if (PsDebug.hasConsole()) {
            ((Component)PsDebug.getConsole()).setVisible(false);
        }
    }

    public int getNumFrames() {
        return this.m_frameVector.size();
    }

    private PvControl getControl() {
        if (this.m_control == null) {
            String tmp;
            this.m_control = new PvControl(this);
            if (this.m_control == null) {
                PsDebug.error("missing control panel", this);
                return null;
            }
            if (!this.hasArchive("jvx")) {
                this.enableMenu(15, false);
            }
            this.m_control.addWindowListener(this);
            this.m_control.addKeyListener(this);
            if (this.m_display != null) {
                this.m_control.setDisplay(this.m_display);
            }
            this.m_control.setProject(this.m_currentProject);
            if (this.m_currentGeometry == null && this.m_display != null) {
                PsDebug.notify("missing geometry, registered from display.");
                this.setGeometry(this.m_display.getSelectedGeometry());
            }
            this.m_control.setGeometry(this.m_currentGeometry);
            if (this.m_projectClass != null && this.m_projectClass.size() > 0 && ((tmp = this.getParameter("menu-new-project")) == null || "enable".equalsIgnoreCase(tmp))) {
                this.enableMenu(100, true);
                this.enableMenu(110, true);
            }
            if (this.m_jvRsrc != null) {
                this.enableMenu(54, true);
            }
            if (this.m_showPanel != -1) {
                this.m_control.showPanel(this.m_showPanel);
            }
        }
        return this.m_control;
    }

    public void windowClosing(WindowEvent event) {
        if (!(event.getSource() instanceof Frame)) {
            return;
        }
        Frame frame = (Frame)event.getSource();
        if (frame == this.m_control) {
            this.removeControl();
        } else {
            Enumeration e = this.m_frameVector.elements();
            while (e.hasMoreElements()) {
                if (frame != (Frame)e.nextElement()) continue;
                this.removeFrame(frame);
                break;
            }
        }
        if (PsConfig.isApplication() && this.getNumFrames() == 0 && (this.m_control == null || !this.m_control.isShowing())) {
            this.destroy();
        }
    }

    public boolean hasDisplay(PvDisplayIf disp) {
        if (this.m_displayVector == null) {
            return false;
        }
        return this.m_displayVector.contains(disp);
    }

    public boolean removeDisplay(PvDisplayIf disp) {
        if (disp == null) {
            PsDebug.warning("missing argument display");
            return false;
        }
        if (!this.hasDisplay(disp)) {
            PsDebug.warning("display with name = " + disp.getName() + " not found.");
            return false;
        }
        Frame frame = disp.getFrame();
        if (this.hasFrame(frame)) {
            this.removeFrame(frame);
            frame.dispose();
        } else {
            this.m_displayVector.removeElement(disp);
        }
        return true;
    }

    public PvDisplayIf getSelectedDisplay() {
        return this.m_display;
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (object == this.m_currentProject) {
            PsDebug.notify("event = m_currentProjec): called");
            return true;
        }
        return super.update(object);
    }

    public void start() {
        String parm;
        this.m_bStarted = true;
        if (this.m_currentProject != null) {
            this.m_currentProject.start();
        }
        if ((parm = this.getParameter("Animation")) != null && parm.equalsIgnoreCase("Show")) {
            this.showDialog(23);
        }
        if ((parm = this.getParameter("Panel")) != null) {
            this.showPanel(PvViewer.getPanelId(parm));
        }
        if ((parm = this.getParameter("Control")) != null && parm.equalsIgnoreCase("Show")) {
            this.showDialog(24);
        }
        boolean bRepaint = false;
        parm = this.getParameter("Axes");
        if (parm != null) {
            this.m_mainDisplay.showAxes(parm.equalsIgnoreCase("Show"));
            bRepaint = true;
        }
        if ((parm = this.getParameter("Background")) != null) {
            this.m_mainDisplay.setBackgroundColor(PdColor.parseColor(parm));
            bRepaint = true;
        }
        if ((parm = this.getParameter("BackgroundImage")) != null) {
            this.m_mainDisplay.setBackgroundImage(parm);
            this.m_mainDisplay.showBackImage(true);
            bRepaint = true;
        }
        if ((parm = this.getParameter("Border")) != null) {
            this.m_mainDisplay.setPaintTag(4, parm.equalsIgnoreCase("Show"));
            bRepaint = true;
        }
        if ((parm = this.getParameter("BoundingBox")) != null) {
            this.m_mainDisplay.showBndBox(parm.equalsIgnoreCase("Show"));
            bRepaint = true;
        }
        if ((parm = this.getParameter("Copyright")) != null) {
            ((PvDisplay)this.m_mainDisplay).showCopyright(parm.equalsIgnoreCase("Show"));
            bRepaint = true;
        }
        if ((parm = this.getParameter("Depthcue")) != null) {
            this.m_mainDisplay.showDepthcue(parm.equalsIgnoreCase("Show"));
            bRepaint = true;
        }
        if ((parm = this.getParameter("EdgeAura")) != null) {
            this.m_mainDisplay.showEdgeAura(parm.equalsIgnoreCase("Show"));
            bRepaint = true;
        }
        if ((parm = this.getParameter("Frame")) != null) {
            this.m_mainDisplay.showFrame(parm.equalsIgnoreCase("Show"));
            bRepaint = true;
        }
        if ((parm = this.getParameter("Sorting")) != null) {
            this.m_mainDisplay.setEnabledPainters(parm.equalsIgnoreCase("Show"));
            bRepaint = true;
        }
        if ((parm = this.getParameter("Interest")) != null) {
            PdVector interest = PsXmlLoader.parsePdVector(parm);
            if (interest != null) {
                this.m_mainDisplay.getCamera().setInterest(interest);
            }
            bRepaint = true;
        }
        if ((parm = this.getParameter("ViewDir")) != null) {
            PdVector viewDir = PsXmlLoader.parsePdVector(parm);
            if (viewDir != null) {
                this.m_mainDisplay.getCamera().setViewDir(viewDir);
            }
            bRepaint = true;
        }
        if ((parm = this.getParameter("UpDir")) != null) {
            PdVector upDir = PsXmlLoader.parsePdVector(parm);
            if (upDir != null && upDir.normalize()) {
                this.m_mainDisplay.getCamera().setUpVector(upDir);
            }
            bRepaint = true;
        }
        if ((parm = this.getParameter("Roll")) != null) {
            double roll = PgLoader.parseDouble(parm);
            if (roll != 0.0) {
                this.m_mainDisplay.getCamera().setRoll(roll);
            }
            bRepaint = true;
        }
        if ((parm = this.getParameter("Distance")) != null) {
            double dist = PgLoader.parseDouble(parm);
            if (dist != 0.0) {
                this.m_mainDisplay.getCamera().setDist(dist);
            }
            bRepaint = true;
        }
        if ((parm = this.getParameter("ZBuffer")) != null) {
            this.m_mainDisplay.setEnabledZBuffer(parm.equalsIgnoreCase("Show"));
            bRepaint = true;
        }
        if ((parm = this.getParameter("FastZBuffer")) != null) {
            ((PvDisplay)this.m_mainDisplay).setEnabledFastZBuffer(parm.equalsIgnoreCase("Show"));
            bRepaint = true;
        }
        if ((parm = this.getParameter("NewZBuffer")) != null) {
            ((PvDisplay)this.m_mainDisplay).setEnabledNewZBuffer(parm.equalsIgnoreCase("Show"));
            bRepaint = true;
        }
        if ((parm = this.getParameter("AutoRotate")) != null) {
            String rot = this.getParameter("RotDir");
            if (rot != null) {
                PdVector rotDir = PsXmlLoader.parsePdVector(rot);
                if (rotDir != null) {
                    this.m_mainDisplay.setAutoRotation(rotDir, 0.06283185307179587);
                }
            } else {
                this.m_mainDisplay.setAutoRotation(new PdVector(0.0, 1.0, 0.0), 0.06283185307179587);
            }
            if (parm.equalsIgnoreCase("Show")) {
                this.m_mainDisplay.setEnabledAnimation(true);
                this.m_mainDisplay.start();
            }
        }
        if (bRepaint) {
            this.m_mainDisplay.update(this.m_mainDisplay.getCamera());
        }
    }

    protected boolean hasArchive(String archive) {
        if (this.m_bIsArchiveTestedJvx) {
            return this.m_bHasArchiveJvx;
        }
        this.m_bIsArchiveTestedJvx = true;
        Object test = PsUtil.newInstance("jvx.rsrc.PsModelInfo");
        this.m_bHasArchiveJvx = test == null;
        return this.m_bHasArchiveJvx;
    }

    private boolean hasFrame(Frame frame) {
        return this.m_frameVector != null && this.m_frameVector.contains(frame);
    }

    protected boolean removeFrame(Frame frame) {
        if (!this.hasFrame(frame)) {
            PsDebug.warning("frame not found.");
            return false;
        }
        PvDisplayIf disp = this.getDisplayOfFrame(frame);
        if (disp != null) {
            this.m_displayVector.removeElement(disp);
        }
        frame.removeWindowListener(this);
        this.m_frameVector.removeElement(frame);
        return true;
    }

    public String getParameter(String parmLabel) {
        String tmp;
        int i;
        parmLabel = parmLabel.toLowerCase();
        if (this.m_parm == null && this.m_applet != null && (this.m_parm = this.m_applet.getParameterInfo()) != null) {
            i = 0;
            while (i < this.m_parm.length) {
                this.m_parm[i][0] = this.m_parm[i][0].toLowerCase();
                ++i;
            }
            if (!PsConfig.isApplication()) {
                i = 0;
                while (i < this.m_parm.length) {
                    tmp = this.m_applet.getParameter(this.m_parm[i][0]);
                    if (tmp != null) {
                        this.m_parm[i][2] = tmp;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.m_parm.length) {
                    tmp = System.getProperty(this.m_parm[i][0]);
                    if (tmp != null) {
                        this.m_parm[i][2] = tmp;
                    }
                    ++i;
                }
            }
        }
        if (this.m_parm != null) {
            i = 0;
            while (i < this.m_parm.length) {
                if (this.m_parm[i][0].equalsIgnoreCase(parmLabel)) {
                    return this.m_parm[i][2].trim();
                }
                ++i;
            }
        }
        PsDebug.notify("parameter = " + parmLabel + " not in applet info");
        if (!PsConfig.isApplication() && this.m_applet != null && (tmp = this.m_applet.getParameter(parmLabel)) != null) {
            PsDebug.notify("Parameter = " + parmLabel + ", Value = " + tmp + " found in HTML page");
            return tmp;
        }
        if (PsConfig.isApplication() && (tmp = System.getProperty(parmLabel)) != null) {
            PsDebug.notify("Parameter = " + parmLabel + ", Value = " + tmp + " found in argument list");
            return tmp;
        }
        PsDebug.notify("missing parameter = " + parmLabel);
        return null;
    }

    protected void submit() {
        PsModelInfo sub = (PsModelInfo)PsUtil.newInstance("jvx.rsrc.PsModelInfo");
        if (sub == null) {
            PsDebug.warning("missing class PsModelInfo, probably jvx.jar not available.");
            return;
        }
        sub.showDialog(true, (PsViewerIf)this);
    }

    public boolean addGeometry(String category, String name, String className) {
        if (name == null || className == null) {
            PsDebug.warning("missing name or class");
            return false;
        }
        if (this.m_geometryCategory == null) {
            this.m_geometryCategory = new Hashtable();
        }
        if (this.m_geometryClass == null) {
            this.m_geometryClass = new Hashtable();
        }
        if (this.m_geometryClass.containsKey(name)) {
            PsDebug.warning("geometry name already exists, name = " + name + "\n\texisting name belong to class = " + (String)this.m_geometryClass.get(name));
            return false;
        }
        if (category == null) {
            category = "Default";
        }
        this.m_geometryCategory.put(name, category);
        this.m_geometryClass.put(name, className);
        this.enableMenu(101, true);
        this.enableMenu(111, true);
        return true;
    }

    public PjProject getProject(String name) {
        PjProject project = (PjProject)this.m_projectList.get(name);
        if (project == null) {
            String className = (String)this.m_projectClass.get(name);
            if (className != null) {
                project = (PjProject)PsUtil.newInstance(className);
            }
            if (project == null) {
                PsDebug.warning("could not create instance of " + name, this);
                return null;
            }
            project.setViewer(this);
            this.m_projectList.put(name, project);
        }
        return project;
    }

    public boolean selectProject(String aName) {
        PjProject newProject;
        if (aName == null) {
            PsDebug.warning("missing project name");
            return false;
        }
        if (this.m_currentProject != null) {
            if (aName.equals(this.m_currentProject.getName())) {
                return true;
            }
            this.m_currentProject.stop();
        }
        if ((newProject = this.getProject(aName)) == null) {
            PsDebug.error("could not find project " + aName, this);
            return false;
        }
        if (this.m_applet != null) {
            newProject.setParameter(this.m_applet.getParameterInfo());
        }
        this.m_currentProject = newProject;
        this.m_currentProject.setParent(this);
        if (this.m_display != null) {
            if (this.m_currentProject.hasDisplay(this.m_display)) {
                this.m_currentProject.selectDisplay(this.m_display);
            } else {
                this.m_currentProject.setDisplay(this.m_display);
            }
        }
        if (this.m_bStarted) {
            this.m_currentProject.start();
        }
        if (this.m_control != null) {
            this.m_control.setProject(this.m_currentProject);
        }
        return true;
    }

    public PvViewer() {
        this(null, null);
        this.m_bStarted = true;
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public PvViewer(Applet applet, Frame frame) {
        this.m_applet = applet;
        this.m_frame = frame;
        this.m_projectCategory = new Hashtable();
        this.m_projectClass = new Hashtable();
        this.m_projectList = new Hashtable();
        this.m_projectParms = new Hashtable();
        this.setName(PsConfig.getMessage("ViewerOf") + " " + PsConfig.getProgram());
        PsConfig.init(applet, this, frame);
        if (frame != null) {
            PvDisplay.setDefaultSize(frame.getSize());
        } else if (applet != null) {
            PvDisplay.setDefaultSize(applet.getSize());
        }
        if (PsDebug.isNotify()) {
            this.printParameter();
        }
        if ("Show".equalsIgnoreCase(this.getParameter("Console"))) {
            this.showDialog(25);
        }
        this.init();
    }

    protected static int getPanelId(String aPanel) {
        if ("Project".equalsIgnoreCase(aPanel)) {
            return 10;
        }
        if ("Info".equalsIgnoreCase(aPanel)) {
            return 12;
        }
        if ("Material".equalsIgnoreCase(aPanel)) {
            return 13;
        }
        if ("Config".equalsIgnoreCase(aPanel)) {
            return 15;
        }
        if ("Texture".equalsIgnoreCase(aPanel)) {
            return 14;
        }
        if ("Camera".equalsIgnoreCase(aPanel)) {
            return 16;
        }
        if ("Display".equalsIgnoreCase(aPanel)) {
            return 17;
        }
        PsDebug.warning("panel not found = " + aPanel);
        return -1;
    }

    private void removeControl() {
        this.m_control.removeWindowListener(this);
        this.m_control.dispose();
        this.m_control = null;
    }

    public void addProjects() {
        String proj;
        int cnt = 1;
        while ((proj = this.getParameter("Project" + cnt)) != null) {
            ++cnt;
            StringTokenizer parser = new StringTokenizer(proj, ";");
            int numOfParms = parser.countTokens() - 2;
            String[] pParm = new String[numOfParms];
            String pTitle = parser.nextToken();
            pTitle = pTitle.trim();
            String pClass = parser.nextToken();
            pClass = pClass.trim();
            int i = 0;
            while (i < numOfParms) {
                pParm[i] = parser.nextToken();
                pParm[i] = pParm[i].trim();
                ++i;
            }
            this.addProject(pTitle, pClass, pParm);
            PsDebug.notify("found project" + cnt + " = " + pTitle + "; " + pClass);
        }
        proj = this.getParameter("Select");
        if (proj != null) {
            PsDebug.notify("select project" + proj);
            this.selectProject(proj);
        }
    }

    public Hashtable getProjectInstances() {
        return this.m_projectList;
    }

    public String newDisplay() {
        PgGeometryIf[] geom;
        PvDisplayIf prevDisp = this.m_display;
        PvDisplayIf disp = this.newDisplay(null);
        if (disp == null) {
            return null;
        }
        if (this.m_currentProject != null) {
            PvDisplayIf selDisp = this.m_currentProject.getDisplay();
            this.m_currentProject.setDisplay(disp);
            if (selDisp != null) {
                this.m_currentProject.selectDisplay(selDisp);
            }
        } else if (prevDisp != null && (geom = prevDisp.getGeometries()) != null) {
            int i = 0;
            while (i < geom.length) {
                disp.addGeometry(geom[i]);
                ++i;
            }
            if (this.m_currentGeometry != null && disp.containsGeometry(this.m_currentGeometry)) {
                disp.selectGeometry(this.m_currentGeometry);
            }
        }
        if (prevDisp != null) {
            disp.selectCamera(((PvDisplay)prevDisp).getCurrentCameraType());
            disp.showGrid(((PvDisplay)prevDisp).isShowingGrid());
            disp.showBndBox(prevDisp.isShowingBndBox());
            disp.showFrame(prevDisp.isShowingFrame());
        }
        disp.update(disp);
        return disp.getName();
    }

    public PvDisplayIf newDisplay(String name) {
        PvDisplayIf disp = this.newDisplay(name, true);
        Frame frame = disp.getFrame();
        int numDisp = this.getNumDisplays() - 1;
        if (numDisp > 0) {
            ((Component)frame).setBounds(new Rectangle(5 + 400 * ((numDisp - 1) % 3), 5 + 300 * ((numDisp - 1) / 3), 400, 300));
        } else {
            ((Component)frame).setBounds(new Rectangle(50, 50, 400, 300));
        }
        ((Component)frame).setVisible(true);
        return disp;
    }

    public PvDisplayIf newDisplay(String name, boolean bFrame) {
        int numDisp = this.getNumDisplays();
        if (name == null) {
            name = "DisplayAWT" + String.valueOf(numDisp);
        }
        PvDisplay disp = new PvDisplay(this);
        this.addDisplay(name, disp);
        this.selectDisplay(disp);
        if (bFrame) {
            PsMainFrame frame = new PsMainFrame(disp, name, null);
            frame.pack();
            disp.setFrame(frame);
            this.addFrame(frame);
        }
        return disp;
    }

    public boolean addDisplay(String name, PvDisplayIf disp) {
        if (disp == null) {
            PsDebug.warning("missing argument display");
            return false;
        }
        if (this.m_displayVector == null) {
            PsDebug.error("missing instance variable m_displayVector.", this);
            return false;
        }
        if (this.hasDisplay(disp)) {
            PsDebug.warning("display with name = " + name + " already registered.");
        }
        disp.setParent(this);
        disp.addKeyListener(this);
        disp.setName(name);
        this.m_displayVector.addElement(disp);
        return true;
    }

    protected void deserialize() {
        PgFileDialog fd = new PgFileDialog(PsConfig.getFrame(), "Load Serialized Object", 0);
        if (this.m_serialDirName == null) {
            this.m_serialDirName = PsConfig.getCodeBase() + "dev/models/serialized/";
        }
        fd.setDirectory(this.m_serialDirName);
        fd.setExtension("ser");
        fd.setVisible(true);
        String fileName = fd.getFullFileName();
        if (fileName == null) {
            PsDebug.notify("dialog cancelled.");
            return;
        }
        this.m_serialDirName = fd.getDirectory();
        Object obj = null;
        try {
            FileInputStream in = new FileInputStream(fileName);
            ObjectInputStream s = new ObjectInputStream(in);
            obj = s.readObject();
        }
        catch (Exception ex) {
            PsDebug.message(ex.toString());
        }
        if (obj == null) {
            PsDebug.warning("object not loaded.");
            return;
        }
        String name = fd.getFile();
        if (obj instanceof PvDisplay) {
            PvDisplayIf disp = (PvDisplayIf)obj;
            disp.setName(name);
            PvDisplay dv = (PvDisplay)disp;
            dv.m_viewer = this;
            dv.m_backgroundColor.setParent(dv);
            dv.m_foregroundColor.setParent(dv);
            dv.m_sleep.setParent(dv);
            dv.m_width.setParent(dv);
            dv.m_height.setParent(dv);
            this.addDisplay(name, disp);
            this.selectDisplay(disp);
            PsMainFrame frame = new PsMainFrame(name, null);
            frame.add("Center", (Component)((Object)disp));
            disp.setFrame(frame);
            frame.pack();
            frame.setBounds(new Rectangle(50, 50, 400, 300));
            ((Component)frame).setVisible(true);
            this.addFrame(frame);
        } else if (obj instanceof PgGeometryIf) {
            PgGeometryIf geom = (PgGeometryIf)((PsObject)obj).clone();
            geom.setName(name);
            PvDisplayIf disp = this.getDisplay();
            disp.addGeometry(geom);
            disp.selectGeometry(geom);
            disp.update(disp);
        } else if (obj instanceof Applet) {
            Applet applet = (Applet)obj;
            applet.setName(name);
            PsMainFrame frame = new PsMainFrame(applet, name, null);
            applet.init();
            String osName = System.getProperty("os.name");
            if (osName != null) {
                if (osName.toLowerCase().startsWith("win")) {
                    ((Component)frame).setBounds(new Rectangle(420, 5, 640, 550));
                } else {
                    ((Component)frame).setSize(640, 550);
                }
            }
            ((Component)frame).setVisible(true);
        } else if (obj instanceof PjProject) {
            PjProject proj = (PjProject)obj;
            proj.setName(name);
            this.addProject(proj);
            this.selectProject(name);
        }
    }

    protected boolean addFrame(Frame frame) {
        if (this.hasFrame(frame)) {
            PsDebug.warning("frame already used.");
            return false;
        }
        this.m_frameVector.addElement(frame);
        frame.addWindowListener(this);
        return true;
    }
}

