/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.loader.PgFileDialog;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.GuiStackLayout;
import jv.objectGui.PsImage;
import jv.project.PgGeometryIf;
import jv.viewer.PvDisplay;
import jv.viewer.PvGeometry;

public final class PvDisplay_IP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PvDisplay m_display;
    protected Panel m_pColor;
    protected Panel m_pSize;
    protected Checkbox m_cAnimation;
    protected Checkbox m_cAxes;
    protected Checkbox m_cBackImage;
    protected Checkbox m_cBndbox;
    protected Checkbox m_cClearScreen;
    protected Checkbox m_cDepthcue;
    protected Checkbox m_cEdgeAura;
    protected Checkbox m_cEdgesOnce;
    protected Checkbox m_cFrame;
    protected Checkbox m_cGrid;
    protected Checkbox m_cPainters;
    protected Checkbox m_cZBuffer;
    protected Checkbox m_cFps;
    protected Label m_lFps;
    protected PsPanel m_pFps;
    protected CheckboxGroup m_gSelectionMode;
    protected Checkbox m_cSingle;
    protected Checkbox m_cMultiple;
    protected List m_listVisible;
    protected List m_listSelect;
    protected boolean m_deleteMode = false;
    private Color m_deleteColor;
    protected boolean m_duplicateMode = false;
    private Color m_duplicateColor;
    protected TextField m_tImage;
    protected String m_fileName;
    protected String m_dirName;
    protected Button m_bBrowse;
    protected Choice m_cImageFit;
    protected Button m_bCenter;
    protected Button m_bFit;
    protected Button m_bMerge;
    protected Button m_bDuplicate;
    protected Button m_bDelete;
    protected Button m_bReset;
    private static /* synthetic */ Class class$jv$viewer$PvDisplay_IP;

    private void duplicateGeom(PgGeometryIf geom) {
        if (this.m_display.m_specialGeom.contains(geom)) {
            PsDebug.warning("not allowed to duplicate special geometry");
            return;
        }
        PsDebug.notify("duplicating geometry from display = " + geom.getName());
        PgGeometryIf newGeom = (PgGeometryIf)geom.clone();
        PsObject cfr_ignored_0 = (PsObject)((Object)newGeom);
        newGeom.setName("Clone" + PsObject.getNumObjects() + "-" + geom.getName());
        this.m_display.addGeometry(newGeom);
        this.m_display.selectGeometry(newGeom);
        this.m_display.update(this.m_display);
        this.m_duplicateMode = false;
        this.m_bDuplicate.setBackground(this.m_duplicateColor);
        this.m_bDuplicate.setLabel(PsConfig.getMessage("bDuplicate"));
    }

    private void deleteGeom(PgGeometryIf aGeom) {
        PsDebug.notify("deleting geometry from display = " + aGeom.getName());
        if (aGeom == null) {
            return;
        }
        if (this.m_display.m_specialGeom.get("xy-grid") == aGeom) {
            this.m_display.showGrid(false);
        } else if (this.m_display.m_specialGeom.get("bndbox") == aGeom) {
            this.m_display.showBndBox(false);
        } else if (this.m_display.m_specialGeom.get("frame") == aGeom) {
            this.m_display.showFrame(false);
        } else {
            this.m_display.removeGeometry(aGeom);
            this.m_display.update(this.m_display);
        }
        this.m_deleteMode = false;
        this.m_bDelete.setBackground(this.m_deleteColor);
        this.m_bDelete.setLabel(PsConfig.getMessage("bDelete"));
    }

    public PvDisplay_IP() {
        if (this.getClass() == (class$jv$viewer$PvDisplay_IP != null ? class$jv$viewer$PvDisplay_IP : (class$jv$viewer$PvDisplay_IP = PvDisplay_IP.class$("jv.viewer.PvDisplay_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        PsDebug.notify("entered");
        if (this.m_display == null) {
            return;
        }
        Object source = event.getSource();
        if (source == this.m_cAnimation) {
            PsDebug.notify("switch Animation");
            this.m_display.setEnabledAnimation(this.m_cAnimation.getState());
            if (this.m_cAnimation.getState()) {
                this.m_display.start();
            } else {
                this.m_display.stop();
            }
        } else if (source == this.m_cAxes) {
            PsDebug.notify("switch Axes");
            this.m_display.showAxes(this.m_cAxes.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (source == this.m_cBackImage) {
            PsDebug.notify("switch BackImage");
            boolean newState = this.m_cBackImage.getState();
            this.m_display.showBackImage(newState);
            if (newState) {
                String text = "";
                if (this.loadImage(this.m_display.getBackgroundImageFile()) != null) {
                    text = this.m_display.getBackgroundImageFile();
                }
                ((TextComponent)this.m_tImage).setText(text);
            }
            this.m_cImageFit.setEnabled(newState);
            if (this.m_bBrowse != null) {
                this.m_bBrowse.setEnabled(newState);
            }
            this.m_tImage.setEnabled(newState);
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (source == this.m_cBndbox) {
            PsDebug.notify("switch bndbox");
            this.m_display.showBndBox(this.m_cBndbox.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (source == this.m_cClearScreen) {
            PsDebug.notify("switch clear screen");
            this.m_display.setEnabledClearScreen(this.m_cClearScreen.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (source == this.m_cDepthcue) {
            PsDebug.notify("switch depthcue");
            this.m_display.showDepthcue(this.m_cDepthcue.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (source == this.m_cEdgeAura) {
            PsDebug.notify("switch edges aura");
            this.m_display.showEdgeAura(this.m_cEdgeAura.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (source == this.m_cEdgesOnce) {
            PsDebug.notify("switch edges once");
            this.m_display.showEdgesOnce(this.m_cEdgesOnce.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (source == this.m_cFrame) {
            PsDebug.notify("switch frame");
            this.m_display.showFrame(this.m_cFrame.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (source == this.m_cGrid) {
            PsDebug.notify("switch grid");
            this.m_display.showGrid(this.m_cGrid.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (source == this.m_cPainters) {
            PsDebug.notify("switch painters");
            this.m_display.setEnabledPainters(this.m_cPainters.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (source == this.m_cZBuffer) {
            PsDebug.notify("switch z-buffer");
            this.m_display.setEnabledZBuffer(this.m_cZBuffer.getState());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (source == this.m_cFps) {
            this.m_display.m_bFpsEnabled = this.m_cFps.getState();
            this.m_display.m_sleep.setEnabled(this.m_cFps.getState());
            this.m_lFps.setText(PsConfig.getMessage("lFps"));
            if (this.m_display.m_bFpsEnabled) {
                this.m_display.start();
            } else {
                this.m_display.stop();
            }
        } else if (source == this.m_cSingle) {
            if (this.m_display.hasPaintTag(2048)) {
                return;
            }
            this.m_display.setPaintTag(2048, true);
            if (this.m_display.m_currentGeom != null) {
                this.m_display.selectGeometry(this.m_display.m_currentGeom.getGeometry());
            }
            this.m_display.update(this.m_display);
        } else if (source == this.m_cMultiple) {
            if (!this.m_display.hasPaintTag(2048)) {
                return;
            }
            this.m_display.setPaintTag(2048, false);
            if (this.m_display.m_currentGeom != null) {
                this.m_display.selectGeometry(this.m_display.m_currentGeom.getGeometry());
            }
        } else if (source == this.m_cImageFit) {
            this.m_display.setImageFitMode(this.m_cImageFit.getSelectedIndex());
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (source == this.m_listVisible) {
            int index = (Integer)event.getItem();
            PsDebug.notify("selected index = " + index + " in listVisible");
            if (index < 0 || this.m_listVisible.getItemCount() <= index) {
                return;
            }
            PvGeometry[] geom = this.m_display.getAllGeometryContainers();
            if (this.m_deleteMode) {
                this.deleteGeom(geom[index].getGeometry());
            } else if (this.m_duplicateMode) {
                this.duplicateGeom(geom[index].getGeometry());
            } else {
                switch (event.getStateChange()) {
                    case 1: {
                        PsDebug.notify("show geometry = " + geom[index].getGeometry().getName());
                        if (this.m_display.hasPaintTag(2048)) {
                            this.m_display.selectGeometry(geom[index].getGeometry());
                            this.m_display.update(this.m_display);
                            break;
                        }
                        geom[index].getGeometry().setVisible(true);
                        geom[index].setVisible(true);
                        this.m_display.update(this);
                        break;
                    }
                    case 2: {
                        PsDebug.notify("hide geometry = " + geom[index].getGeometry().getName());
                        geom[index].getGeometry().setVisible(false);
                        geom[index].setVisible(false);
                        this.m_display.update(this);
                    }
                }
            }
        } else if (source == this.m_listSelect) {
            int index = (Integer)event.getItem();
            PsDebug.notify("selected index = " + index + " in listSelect");
            if (index < 0 || this.m_listSelect.getItemCount() <= index) {
                return;
            }
            PvGeometry[] geom = this.m_display.getAllGeometryContainers();
            if (this.m_deleteMode) {
                this.deleteGeom(geom[index].getGeometry());
            } else if (this.m_duplicateMode) {
                this.duplicateGeom(geom[index].getGeometry());
            } else {
                switch (event.getStateChange()) {
                    case 1: {
                        PsDebug.notify("select geometry = " + geom[index].getGeometry().getName());
                        this.m_display.selectGeometry(geom[index].getGeometry());
                        this.m_display.update(this);
                    }
                }
            }
        }
    }

    public void setParent(PsUpdateIf display) {
        super.setParent(display);
        this.m_display = (PvDisplay)display;
        this.setTitle(this.m_display.getName());
        this.m_pColor.add(this.m_display.m_backgroundColor.getInfoPanel());
        this.m_pColor.add(this.m_display.m_foregroundColor.getInfoPanel());
        this.m_pSize.add(this.m_display.m_width.getInfoPanel());
        this.m_pSize.add(this.m_display.m_height.getInfoPanel());
        if (this.m_pFps != null) {
            this.m_pFps.add(this.m_display.m_sleep.getInfoPanel());
        }
    }

    private Image loadImage(String fileName) {
        Image img = PsImage.getImage(fileName);
        boolean bOk = PsImage.loadImage(this, img);
        if (!bOk && PsConfig.isApplication()) {
            img = PsImage.getImage(PsConfig.getCodeBase() + fileName);
            bOk = PsImage.loadImage(this, img);
        }
        if (!bOk) {
            PsDebug.warning("failed loading image = " + fileName);
            return null;
        }
        this.m_display.setBackgroundImage(img);
        this.m_display.showBackImage(true);
        return img;
    }

    public boolean update(Object object) {
        PsDebug.notify("isShowing = " + this.isShowing());
        if (this.m_display == null) {
            PsDebug.warning("missing display");
            return false;
        }
        if (object == this.m_display) {
            int i;
            String title = this.m_display.getName();
            if (title != null && this.getTitle() != null && !title.equals(this.getTitle())) {
                this.setTitle(title);
            }
            if (this.m_cBackImage.getState() != this.m_display.isShowingBackImage()) {
                boolean newState = this.m_display.isShowingBackImage();
                this.m_cBackImage.setState(newState);
                if (newState) {
                    ((TextComponent)this.m_tImage).setText(this.m_display.getBackgroundImageFile());
                }
                this.m_cImageFit.setEnabled(newState);
                if (this.m_bBrowse != null) {
                    this.m_bBrowse.setEnabled(newState);
                }
                this.m_tImage.setEnabled(newState);
            }
            if (this.m_cImageFit.getSelectedIndex() != this.m_display.getImageFitMode()) {
                this.m_cImageFit.select(this.m_display.getImageFitMode());
            }
            if (this.m_cAnimation.getState() != this.m_display.isEnabledAnimation()) {
                this.m_cAnimation.setState(this.m_display.isEnabledAnimation());
            }
            if (this.m_cAxes.getState() != this.m_display.isShowingAxes()) {
                this.m_cAxes.setState(this.m_display.isShowingAxes());
            }
            if (this.m_cBndbox.getState() != this.m_display.isShowingBndBox()) {
                this.m_cBndbox.setState(this.m_display.isShowingBndBox());
            }
            if (this.m_cClearScreen.getState() != this.m_display.isEnabledClearScreen()) {
                this.m_cClearScreen.setState(this.m_display.isEnabledClearScreen());
            }
            if (this.m_cDepthcue.getState() != this.m_display.isShowingDepthcue()) {
                this.m_cDepthcue.setState(this.m_display.isShowingDepthcue());
            }
            if (this.m_cEdgeAura.getState() != this.m_display.isShowingEdgeAura()) {
                this.m_cEdgeAura.setState(this.m_display.isShowingEdgeAura());
            }
            if (this.m_cEdgesOnce.getState() != this.m_display.isShowingEdgesOnce()) {
                this.m_cEdgesOnce.setState(this.m_display.isShowingEdgesOnce());
            }
            if (this.m_cFrame.getState() != this.m_display.isShowingFrame()) {
                this.m_cFrame.setState(this.m_display.isShowingFrame());
            }
            if (this.m_cGrid.getState() != this.m_display.isShowingGrid()) {
                this.m_cGrid.setState(this.m_display.isShowingGrid());
            }
            if (this.m_cPainters.getState() != this.m_display.isEnabledPainters()) {
                this.m_cPainters.setState(this.m_display.isEnabledPainters());
            }
            if (this.m_cZBuffer.getState() != this.m_display.isEnabledZBuffer()) {
                this.m_cZBuffer.setState(this.m_display.isEnabledZBuffer());
            }
            if (this.m_pFps != null && this.m_cFps.getState() != this.m_display.m_bFpsEnabled) {
                this.m_cFps.setState(this.m_display.m_bFpsEnabled);
            }
            PvGeometry[] geom = this.m_display.getAllGeometryContainers();
            PgGeometryIf selectedGeom = this.m_display.getSelectedGeometry();
            boolean bSingle = this.m_display.hasPaintTag(2048);
            if (bSingle && this.m_gSelectionMode.getSelectedCheckbox() != this.m_cSingle) {
                this.m_gSelectionMode.setSelectedCheckbox(this.m_cSingle);
            } else if (!bSingle && this.m_gSelectionMode.getSelectedCheckbox() == this.m_cSingle) {
                this.m_gSelectionMode.setSelectedCheckbox(this.m_cMultiple);
            }
            boolean bItemsSame = true;
            int geomLen = 0;
            int numItems = this.m_listVisible.getItemCount();
            if (geom != null) {
                geomLen = geom.length;
            }
            if (numItems != geomLen) {
                bItemsSame = false;
            } else {
                i = 0;
                while (i < geomLen) {
                    String item = this.m_listVisible.getItem(i);
                    if (item == null || !item.equals(geom[i].getGeometry().getName())) {
                        bItemsSame = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!bItemsSame) {
                if (numItems > 0) {
                    this.m_listVisible.removeAll();
                    this.m_listSelect.removeAll();
                }
                i = 0;
                while (i < geomLen) {
                    this.m_listVisible.add(geom[i].getGeometry().getName());
                    this.m_listSelect.add(geom[i].getGeometry().getName());
                    ++i;
                }
            }
            i = 0;
            while (i < geomLen) {
                if (geom[i].isVisible() != this.m_listVisible.isIndexSelected(i)) {
                    if (geom[i].isVisible()) {
                        this.m_listVisible.select(i);
                    } else {
                        this.m_listVisible.deselect(i);
                    }
                }
                if (geom[i].getGeometry() == selectedGeom) {
                    this.m_listSelect.select(i);
                }
                ++i;
            }
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent event) {
        PsDebug.notify("entered");
        if (this.m_display == null) {
            return;
        }
        Object source = event.getSource();
        if (source == this.m_tImage) {
            this.m_fileName = this.m_tImage.getText();
            this.m_fileName.trim();
            if (this.loadImage(this.m_fileName) == null) {
                return;
            }
            this.m_display.setBackgroundImage(this.m_fileName);
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (source == this.m_bBrowse) {
            if (!PsConfig.isApplication()) {
                this.m_fileName = this.m_tImage.getText();
                this.m_fileName.trim();
            } else {
                PgFileDialog fd = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage("OpenImage"), 0);
                if (this.m_dirName == null) {
                    this.m_dirName = PsConfig.getCodeBase() + "images";
                }
                ((FileDialog)fd).setDirectory(this.m_dirName);
                ((Component)fd).setVisible(true);
                String fileName = fd.getFile();
                if (fileName == null) {
                    PsDebug.notify("dialog cancelled");
                    return;
                }
                PsDebug.notify("file = " + fileName);
                this.m_dirName = ((FileDialog)fd).getDirectory();
                PsDebug.notify("dir  = " + this.m_dirName);
                this.m_fileName = this.m_dirName + fileName;
                this.m_fileName.trim();
                ((TextComponent)this.m_tImage).setText(this.m_fileName);
            }
            if (this.loadImage(this.m_fileName) == null) {
                return;
            }
            this.m_display.setBackgroundImage(this.m_fileName);
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (source == this.m_bCenter) {
            PsDebug.notify("center");
            this.m_display.center();
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (source == this.m_bFit) {
            PsDebug.notify("fit");
            this.m_display.fit();
            this.m_display.update(this.m_display.m_currentCamera);
        } else if (source == this.m_bMerge) {
            PsDebug.notify("merge");
            PgGeometryIf[] allGeom = this.m_display.getGeometries();
            PgGeometryIf geom = null;
            int i = 0;
            while (i < allGeom.length) {
                if (allGeom[i].isVisible()) {
                    geom = allGeom[i];
                    break;
                }
                ++i;
            }
            if (geom == null) {
                PsDebug.warning("missing visible geometry.");
                return;
            }
            i = 0;
            while (i < allGeom.length) {
                if (allGeom[i].isVisible() && allGeom[i] != geom) {
                    geom.merge(allGeom[i]);
                    this.m_display.removeGeometry(allGeom[i]);
                }
                ++i;
            }
            geom.update(geom);
            this.m_display.selectGeometry(geom);
            this.m_display.update(this.m_display);
        } else if (source == this.m_bDuplicate) {
            PsDebug.notify("duplicate");
            if (this.m_duplicateMode) {
                this.m_duplicateMode = false;
                this.m_bDuplicate.setBackground(this.m_duplicateColor);
                this.m_bDuplicate.setLabel(PsConfig.getMessage("bDuplicate"));
            } else {
                this.m_duplicateMode = true;
                this.m_duplicateColor = this.m_bDuplicate.getBackground();
                this.m_bDuplicate.setBackground(Color.red);
                this.m_bDuplicate.setLabel(PsConfig.getMessage("ClickGeom"));
            }
        } else if (source == this.m_bDelete) {
            PsDebug.notify("delete");
            if (this.m_deleteMode) {
                this.m_deleteMode = false;
                this.m_bDelete.setBackground(this.m_deleteColor);
                this.m_bDelete.setLabel(PsConfig.getMessage("bDelete"));
            } else {
                this.m_deleteMode = true;
                this.m_deleteColor = this.m_bDelete.getBackground();
                this.m_bDelete.setBackground(Color.red);
                this.m_bDelete.setLabel(PsConfig.getMessage("ClickGeom"));
            }
        } else if (source == this.m_bReset) {
            this.m_display.init();
            this.update(this.m_display);
            this.m_display.update(this.m_display.m_currentCamera);
        }
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setBorderType(3);
        this.addTitle("");
        this.m_pColor = new Panel();
        this.m_pColor.setLayout(new GridLayout(2, 1));
        this.add(this.m_pColor);
        this.m_pSize = new Panel();
        this.m_pSize.setLayout(new GridLayout(2, 1));
        this.add(this.m_pSize);
        this.addLine(1);
        PsPanel pBackImage = new PsPanel();
        pBackImage.setLayout(new GridLayout(3, 2));
        pBackImage.addTitle(PsConfig.getMessage("BackImage"));
        this.m_cBackImage = new Checkbox(PsConfig.getMessage("Show"));
        this.m_cBackImage.addItemListener(this);
        pBackImage.add(this.m_cBackImage);
        pBackImage.add(new Label(PsConfig.getMessage("Display")));
        this.m_cImageFit = new Choice();
        this.m_cImageFit.addItemListener(this);
        this.m_cImageFit.addItem(PsConfig.getMessage("cCenter"));
        this.m_cImageFit.addItem(PsConfig.getMessage("cTesselate"));
        this.m_cImageFit.addItem(PsConfig.getMessage("cResize"));
        this.m_cImageFit.setEnabled(false);
        pBackImage.add(this.m_cImageFit);
        Panel textPanel = new Panel();
        textPanel.setLayout(new GuiStackLayout(0, 0));
        textPanel.add("WIDE*2", new Label(PsConfig.getMessage("ImageFile")));
        this.m_bBrowse = new Button(PsConfig.getMessage("Load"));
        this.m_bBrowse.addActionListener(this);
        textPanel.add("FILL*1", this.m_bBrowse);
        this.m_bBrowse.setEnabled(false);
        pBackImage.add(textPanel);
        this.m_tImage = new TextField();
        this.m_tImage.addActionListener(this);
        this.m_tImage.setEnabled(false);
        pBackImage.add(this.m_tImage);
        this.add(pBackImage);
        this.addLine(1);
        this.addSubTitle(PsConfig.getMessage("displayTitle"));
        PsPanel pFlags = new PsPanel();
        pFlags.setLayout(new GridLayout(5, 2));
        this.add(pFlags);
        this.m_cAnimation = new Checkbox(PsConfig.getMessage("cAnimation"));
        this.m_cAnimation.addItemListener(this);
        pFlags.add(this.m_cAnimation);
        this.m_cAxes = new Checkbox(PsConfig.getMessage("cAxes"));
        this.m_cAxes.addItemListener(this);
        pFlags.add(this.m_cAxes);
        this.m_cBndbox = new Checkbox(PsConfig.getMessage("cBndbox0"));
        this.m_cBndbox.addItemListener(this);
        pFlags.add(this.m_cBndbox);
        this.m_cDepthcue = new Checkbox(PsConfig.getMessage("cDepthcue"));
        this.m_cDepthcue.addItemListener(this);
        pFlags.add(this.m_cDepthcue);
        this.m_cFrame = new Checkbox(PsConfig.getMessage("cFrame"));
        this.m_cFrame.addItemListener(this);
        pFlags.add(this.m_cFrame);
        this.m_cGrid = new Checkbox(PsConfig.getMessage("cGrid"));
        this.m_cGrid.addItemListener(this);
        pFlags.add(this.m_cGrid);
        this.m_cPainters = new Checkbox(PsConfig.getMessage("cPainters"));
        this.m_cPainters.addItemListener(this);
        pFlags.add(this.m_cPainters);
        this.m_cEdgesOnce = new Checkbox(PsConfig.getMessage("cEdgesOnce"));
        this.m_cEdgesOnce.addItemListener(this);
        this.m_cEdgeAura = new Checkbox(PsConfig.getMessage("cEdgeAura"));
        this.m_cEdgeAura.addItemListener(this);
        pFlags.add(this.m_cEdgeAura);
        this.m_cClearScreen = new Checkbox(PsConfig.getMessage("cClearScreen"));
        this.m_cClearScreen.addItemListener(this);
        pFlags.add(this.m_cClearScreen);
        this.m_cZBuffer = new Checkbox(PsConfig.getMessage("cZBuffer") + " (beta)");
        this.m_cZBuffer.addItemListener(this);
        pFlags.add(this.m_cZBuffer);
        this.addLine(1);
        this.m_pFps = new PsPanel();
        this.m_pFps.setLayout(new GridLayout(2, 1));
        Panel pFps = new Panel();
        pFps.setLayout(new GridLayout(1, 2));
        this.m_cFps = new Checkbox(PsConfig.getMessage("cFps"));
        this.m_cFps.addItemListener(this);
        this.m_cFps.setFont(PsConfig.getFont(3));
        this.m_cFps.setState(false);
        pFps.add(this.m_cFps);
        this.m_lFps = new Label(PsConfig.getMessage("lFps"));
        pFps.add(this.m_lFps);
        this.m_pFps.add(pFps);
        this.addLine(1);
        PsPanel pGeometries = new PsPanel();
        pGeometries.setInsetSize(0);
        this.add(pGeometries);
        PsPanel pHeader = new PsPanel();
        pHeader.setInsetSize(0);
        pHeader.setLayout(new GridLayout(1, 2));
        pHeader.addSubTitle(PsConfig.getMessage("lGeometries"));
        Panel pSelectionMode = new Panel();
        pSelectionMode.setLayout(new GridLayout(1, 2));
        this.m_gSelectionMode = new CheckboxGroup();
        this.m_cSingle = new Checkbox(PsConfig.getMessage("cSingle"), this.m_gSelectionMode, false);
        this.m_cSingle.addItemListener(this);
        pSelectionMode.add(this.m_cSingle);
        this.m_cMultiple = new Checkbox(PsConfig.getMessage("cMultiple"), this.m_gSelectionMode, true);
        this.m_cMultiple.addItemListener(this);
        pSelectionMode.add(this.m_cMultiple);
        pHeader.add(pSelectionMode);
        pGeometries.add(pHeader);
        Panel pGeoms = new Panel();
        pGeoms.setLayout(new GridLayout(1, 2));
        Panel sel = new Panel();
        sel.setLayout(new BorderLayout());
        Label lSel = new Label(PsConfig.getMessage("lSel"));
        sel.add("North", lSel);
        this.m_listSelect = new List(5, false);
        this.m_listSelect.addItemListener(this);
        sel.add("Center", this.m_listSelect);
        pGeoms.add(sel);
        Panel vis = new Panel();
        vis.setLayout(new BorderLayout());
        Label lVis = new Label(PsConfig.getMessage("lVis"));
        vis.add("North", lVis);
        this.m_listVisible = new List(5, true);
        this.m_listVisible.addItemListener(this);
        vis.add("Center", this.m_listVisible);
        pGeoms.add(vis);
        pGeometries.add(pGeoms);
        Panel pBottomButtons = new Panel();
        pBottomButtons.setLayout(new FlowLayout());
        this.add(pBottomButtons);
        this.m_bMerge = new Button(PsConfig.getMessage("bMerge"));
        this.m_bMerge.addActionListener(this);
        pBottomButtons.add(this.m_bMerge);
        this.m_bDuplicate = new Button(PsConfig.getMessage("bDuplicate"));
        this.m_bDuplicate.addActionListener(this);
        pBottomButtons.add(this.m_bDuplicate);
        this.m_bDelete = new Button(PsConfig.getMessage("bDelete"));
        this.m_bDelete.addActionListener(this);
        pBottomButtons.add(this.m_bDelete);
        Panel pBottomButtons2 = new Panel();
        pBottomButtons2.setLayout(new FlowLayout());
        this.add(pBottomButtons2);
        this.m_bCenter = new Button(PsConfig.getMessage("bCenter"));
        this.m_bCenter.addActionListener(this);
        pBottomButtons2.add(this.m_bCenter);
        this.m_bFit = new Button(PsConfig.getMessage("bFit"));
        this.m_bFit.addActionListener(this);
        pBottomButtons2.add(this.m_bFit);
        this.m_bReset = new Button(PsConfig.getMessage("bReset"));
        this.m_bReset.addActionListener(this);
        pBottomButtons2.add(this.m_bReset);
    }
}

