/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PvCameraIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuReflect;
import jv.viewer.PvDisplay;

public final class PvCamera
extends PsObject
implements PvCameraIf {
    private double Z_STRETCH = 1000.0;
    private double SIZE = 10.0;
    private PdVector m_interest = new PdVector(3);
    private PdVector m_position = new PdVector(3);
    private PdVector m_viewDir = new PdVector(3);
    private PdVector m_upVector = new PdVector(3);
    private PdVector m_defaultUpVector = new PdVector(3);
    protected double m_defRoll = 0.0;
    protected PuDouble m_roll;
    protected double m_defFieldOfView = 53.13;
    protected PuDouble m_fieldOfView;
    protected PuDouble m_nearClip;
    private double m_defNearClip = this.SIZE;
    protected PuDouble m_farClip;
    private double m_defFarClip = -this.SIZE;
    protected boolean m_bEnableClip;
    protected PdMatrix m_proj = new PdMatrix(4);
    protected PdMatrix m_projInv = new PdMatrix(4);
    public PdMatrix m_view = new PdMatrix(4);
    public PdMatrix m_viewInv = new PdMatrix(4);
    protected PdMatrix m_incrView = new PdMatrix(4);
    protected PdMatrix m_incrViewInv = new PdMatrix(4);
    public PdMatrix m_trans = new PdMatrix(4);
    public PdMatrix m_transInv = new PdMatrix(4);
    protected int m_mode;
    protected int m_projMode;
    protected double m_nHeight;
    protected double m_nWidth;
    protected double m_fit = -1.0;
    protected double m_scaleTotal = 1.0;
    protected double m_scaleValue;
    protected double m_xTransValue;
    protected double m_yTransValue;
    protected double m_zTransValue;
    protected PdVector m_vecAlt = new PdVector(3);
    protected PdVector m_vec = new PdVector(3);
    protected PdVector m_rotAxis = new PdVector(3);
    protected PdVector m_pick = new PdVector(4);
    protected PdVector m_worldPick = new PdVector(4);
    private double[] m_prevNormLoc = new double[2];
    private double[] m_currNormLoc = new double[2];
    protected PvDisplay m_display;

    public double getRoll() {
        PdVector viewDir = this.getViewDir();
        PdVector zUp = this.m_defaultUpVector.orthogonalPart(null, viewDir);
        PdVector up = this.getUpVector();
        this.m_roll.setValue(PdVector.angleWithOrientation(up, zUp, viewDir) * 180.0 / Math.PI);
        return this.m_roll.getValue();
    }

    public void setRoll(double roll) {
        PdVector viewDir;
        PdVector zUp;
        if (this.m_roll.getValue() != roll * Math.PI / 180.0) {
            this.m_roll.setValue(roll);
        }
        if (!(zUp = this.m_defaultUpVector.orthogonalPart(null, viewDir = this.getViewDir())).normalize()) {
            PdVector dUp = PdVector.copyNew(this.m_defaultUpVector);
            double tmp = dUp.getEntry(2);
            dUp.setEntry(2, dUp.getEntry(1));
            dUp.setEntry(1, tmp);
            zUp = dUp.orthogonalPart(null, viewDir);
            if (!zUp.normalize()) {
                return;
            }
        }
        PdVector ortho = PdVector.crossNew(zUp, viewDir);
        this.m_upVector.blend(Math.cos(roll *= Math.PI / 180), zUp, Math.sin(roll), ortho);
        this.computeView();
    }

    public boolean isEnabledClip() {
        return this.m_bEnableClip;
    }

    public void fit(double diameter) {
        this.setScale(1.1 * this.SIZE / diameter);
    }

    protected void mouseAnimate() {
        if (this.m_display.isEnabledLocalTransform()) {
            this.m_view.rightMult(this.m_incrView);
            this.m_viewInv.leftMult(this.m_incrViewInv);
        } else {
            this.m_view.leftMult(this.m_incrView);
            this.m_viewInv.rightMult(this.m_incrViewInv);
        }
        this.m_trans.mult(this.m_proj, this.m_view);
        this.m_transInv.mult(this.m_viewInv, this.m_projInv);
    }

    private void computeView() {
        PdVector interest = this.getInterest();
        this.m_viewDir.normalize();
        PdVector wDir = new PdVector(3);
        PdVector upDir = this.m_upVector.orthogonalPart(null, this.m_viewDir);
        if (!upDir.normalize()) {
            PsDebug.notify("upVector parallel to line of view, modify 1");
            this.m_upVector.m_data[1] = this.m_upVector.m_data[1] + 1.0;
            upDir = this.m_upVector.orthogonalPart(null, this.m_viewDir);
            if (!upDir.normalize()) {
                PsDebug.notify("upVector parallel to line of view, modify 2");
                this.m_upVector.m_data[2] = this.m_upVector.m_data[2] + 1.0;
                upDir = this.m_upVector.orthogonalPart(null, this.m_viewDir);
                if (!upDir.normalize()) {
                    PsDebug.notify("upVector parallel to line of view, modify 3");
                    this.m_upVector.m_data[2] = this.m_upVector.m_data[2] + 1.0;
                    upDir = this.m_upVector.orthogonalPart(null, this.m_viewDir);
                }
            }
        }
        wDir.cross(this.m_viewDir, upDir);
        double fac = this.getScale();
        int i = 0;
        while (i < 3) {
            this.m_view.m_data[0][i] = fac * wDir.m_data[i];
            this.m_view.m_data[1][i] = fac * upDir.m_data[i];
            this.m_view.m_data[2][i] = -fac * this.m_viewDir.m_data[i];
            this.m_viewInv.m_data[i][0] = wDir.m_data[i] / fac;
            this.m_viewInv.m_data[i][1] = upDir.m_data[i] / fac;
            this.m_viewInv.m_data[i][2] = -this.m_viewDir.m_data[i] / fac;
            this.m_viewInv.m_data[i][3] = -this.m_view.m_data[i][3];
            ++i;
        }
        this.setInterest(interest);
        this.m_trans.mult(this.m_proj, this.m_view);
        this.m_transInv.mult(this.m_viewInv, this.m_projInv);
    }

    public boolean update(Object event) {
        PsDebug.notify("called");
        if (event == this.m_fieldOfView) {
            this.setFieldOfView(this.m_fieldOfView.getValue());
            return super.update(null);
        }
        if (event == this.m_roll) {
            this.setRoll(this.m_roll.getValue());
            return super.update(null);
        }
        if (event == this.m_nearClip) {
            if (this.m_nearClip.getValue() < this.m_farClip.getValue()) {
                this.m_farClip.setValue(this.m_nearClip.getValue());
            }
            return super.update(null);
        }
        if (event == this.m_farClip) {
            if (this.m_farClip.getValue() > this.m_nearClip.getValue()) {
                this.m_nearClip.setValue(this.m_farClip.getValue());
            }
            return super.update(null);
        }
        return super.update(event);
    }

    public PdVector getInterest() {
        int i = 0;
        while (i < 3) {
            this.m_interest.m_data[i] = this.m_viewInv.m_data[i][3];
            ++i;
        }
        return this.m_interest;
    }

    public void setInterest(PdVector pos) {
        int dim = pos.getSize();
        int i = 0;
        while (i < 3) {
            this.m_view.m_data[i][3] = 0.0;
            int k = 0;
            while (k < dim) {
                double[] dArray = this.m_view.m_data[i];
                dArray[3] = dArray[3] - this.m_view.m_data[i][k] * pos.m_data[k];
                ++k;
            }
            this.m_viewInv.m_data[i][3] = pos.m_data[i];
            ++i;
        }
        this.m_trans.mult(this.m_proj, this.m_view);
        this.m_transInv.mult(this.m_viewInv, this.m_projInv);
    }

    protected void resizeImage(double aWidth, double aHeight) {
        if (aWidth <= 0.0 || aHeight <= 0.0) {
            if (this.m_nHeight > 0.0) {
                PsDebug.warning("window has dimensions=0");
            }
            return;
        }
        this.m_nWidth = aWidth;
        this.m_nHeight = aHeight;
        this.computeProjection();
    }

    public void setEnabledClip(boolean flag) {
        this.m_bEnableClip = flag;
    }

    public double getNearClip() {
        return this.m_nearClip.getValue();
    }

    public void setNearClip(double dist) {
        this.m_nearClip.setValue(dist);
    }

    public PdVector[] getBounds() {
        PdVector[] bndBox = null;
        if (this.m_display != null && this.m_display.m_scene != null) {
            bndBox = this.m_display.m_scene.getBounds();
        }
        if (bndBox == null) {
            return null;
        }
        double[] vec = new double[3];
        int i = 0;
        while (i < 2) {
            int k = 0;
            while (k < 3) {
                double tmp = 0.0;
                int l = 0;
                while (l < 3) {
                    tmp += this.m_trans.m_data[k][l] * bndBox[i].m_data[l];
                    ++l;
                }
                vec[k] = (int)(tmp + 0.5 + this.m_trans.m_data[k][3]);
                ++k;
            }
            k = 0;
            while (k < 2) {
                bndBox[i].m_data[k] = vec[k];
                ++k;
            }
            bndBox[i].m_data[2] = vec[2] / this.Z_STRETCH;
            ++i;
        }
        return bndBox;
    }

    public int getProjectionMode() {
        return this.m_projMode;
    }

    public void setProjectionMode(int mode) {
        this.m_projMode = mode;
    }

    protected void mousePressed(int x, int y) {
        PvDisplay.normalizedCoordsFromViewport(this.m_prevNormLoc, x, y, (int)this.m_nWidth, (int)this.m_nHeight);
        this.m_scaleValue = Math.exp(this.m_prevNormLoc[0] + this.m_prevNormLoc[1]);
        this.m_xTransValue = this.m_prevNormLoc[0] * this.SIZE / 2.0;
        this.m_yTransValue = this.m_prevNormLoc[1] * this.SIZE / 2.0;
        this.m_zTransValue = this.m_xTransValue + this.m_yTransValue;
        this.m_vecAlt.invStereoProj(this.m_prevNormLoc[0], this.m_prevNormLoc[1]);
    }

    protected void mouseDragged(int x, int y, boolean bShiftConstraint) {
        PvDisplay.normalizedCoordsFromViewport(this.m_currNormLoc, x, y, (int)this.m_nWidth, (int)this.m_nHeight);
        this.m_incrView.setIdentity();
        this.m_incrViewInv.setIdentity();
        if (this.m_mode == 1) {
            double dValue;
            double value = Math.exp(this.m_currNormLoc[0] + this.m_currNormLoc[1]);
            this.m_incrView.m_data[0][0] = dValue = value / this.m_scaleValue;
            this.m_incrView.m_data[1][1] = dValue;
            this.m_incrView.m_data[2][2] = dValue;
            this.m_incrViewInv.m_data[0][0] = 1.0 / dValue;
            this.m_incrViewInv.m_data[1][1] = 1.0 / dValue;
            this.m_incrViewInv.m_data[2][2] = 1.0 / dValue;
            this.m_scaleTotal *= dValue;
            this.m_scaleValue = value;
        } else if (this.m_mode == 3 || this.m_projMode != 0) {
            double xValue = this.m_currNormLoc[0] * this.SIZE / 2.0;
            double yValue = this.m_currNormLoc[1] * this.SIZE / 2.0;
            double dXValue = xValue - this.m_xTransValue;
            double dYValue = yValue - this.m_yTransValue;
            this.m_incrView.m_data[0][3] = dXValue;
            this.m_incrView.m_data[1][3] = dYValue;
            this.m_incrViewInv.m_data[0][3] = -dXValue;
            this.m_incrViewInv.m_data[1][3] = -dYValue;
            this.m_xTransValue = xValue;
            this.m_yTransValue = yValue;
        } else if (this.m_mode == 0 && this.m_projMode == 0) {
            double angle;
            this.m_vec.invStereoProj(this.m_currNormLoc[0], this.m_currNormLoc[1]);
            if (bShiftConstraint) {
                int axis = 0;
                if (this.m_currNormLoc[1] == this.m_prevNormLoc[1]) {
                    axis = 1;
                }
                if (this.m_vecAlt.getEntry(axis) != 0.0) {
                    this.m_vecAlt.setEntry(axis, 0.0);
                    this.m_vecAlt.normalize();
                }
                this.m_vec.setEntry(axis, 0.0);
                this.m_vec.normalize();
            }
            if ((angle = Math.acos(PdVector.dot(this.m_vec, this.m_vecAlt))) < 1.0E-10) {
                PsDebug.notify("angle too small");
                return;
            }
            this.m_rotAxis.cross(this.m_vecAlt, this.m_vec);
            this.m_vecAlt.copy(this.m_vec);
            if (this.m_rotAxis.length() < 1.0E-10) {
                PsDebug.notify("rotAxis too small");
                return;
            }
            if (!PuReflect.makeRotation(this.m_incrView, this.m_rotAxis, angle)) {
                return;
            }
            this.m_incrViewInv.transpose(this.m_incrView);
        } else if (this.m_mode == 4) {
            double dZValue;
            double xValue = this.m_currNormLoc[0] * this.SIZE / 2.0;
            double yValue = this.m_currNormLoc[1] * this.SIZE / 2.0;
            double zValue = xValue + yValue;
            double dXValue = xValue - this.m_xTransValue;
            double dYValue = yValue - this.m_yTransValue;
            this.m_incrView.m_data[2][3] = dZValue = zValue - this.m_zTransValue;
            this.m_incrViewInv.m_data[2][3] = -dZValue;
            this.m_xTransValue = xValue;
            this.m_yTransValue = yValue;
            this.m_zTransValue = zValue;
        } else {
            return;
        }
        if (this.m_display.isEnabledLocalTransform()) {
            this.m_view.rightMult(this.m_incrView);
            this.m_viewInv.leftMult(this.m_incrViewInv);
        } else {
            this.m_view.leftMult(this.m_incrView);
            this.m_viewInv.rightMult(this.m_incrViewInv);
        }
        this.m_trans.mult(this.m_proj, this.m_view);
        this.m_transInv.mult(this.m_viewInv, this.m_projInv);
        if (this.m_mode != 1 && this.m_mode != 3 && this.m_projMode == 0 && this.m_mode == 0 && this.m_projMode == 0) {
            this.getRoll();
        }
    }

    public PvCamera(PvDisplay display, int projMode) {
        this.m_display = display;
        this.m_projMode = projMode;
        this.m_fieldOfView = new PuDouble(PsConfig.getMessage("fieldOfView"), this);
        this.m_roll = new PuDouble(PsConfig.getMessage("roll"), this);
        this.m_nearClip = new PuDouble(PsConfig.getMessage("nearClip"), this);
        this.m_farClip = new PuDouble(PsConfig.getMessage("farClip"), this);
        this.init();
    }

    protected int getMode() {
        return this.m_mode;
    }

    public PdVector getUpVector() {
        double scale = this.getScale();
        int i = 0;
        while (i < 3) {
            this.m_upVector.m_data[i] = this.m_view.m_data[1][i] / scale;
            ++i;
        }
        return this.m_upVector;
    }

    public void setUpVector(PdVector up) {
        this.m_upVector.copy(up);
        this.computeView();
    }

    protected void setMode(int aMode) {
        this.m_mode = aMode;
    }

    public double getScale() {
        return Math.sqrt(this.m_view.m_data[2][0] * this.m_view.m_data[2][0] + this.m_view.m_data[2][1] * this.m_view.m_data[2][1] + this.m_view.m_data[2][2] * this.m_view.m_data[2][2]);
    }

    public void setScale(double newScale) {
        double currScale = this.getScale();
        double val = newScale / currScale;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                double[] dArray = this.m_view.m_data[i];
                int n = j;
                dArray[n] = dArray[n] * val;
                double[] dArray2 = this.m_viewInv.m_data[i];
                int n2 = j++;
                dArray2[n2] = dArray2[n2] / val;
            }
            double[] dArray = this.m_view.m_data[i];
            dArray[3] = dArray[3] * val;
            ++i;
        }
        this.m_trans.mult(this.m_proj, this.m_view);
        this.m_transInv.mult(this.m_viewInv, this.m_projInv);
    }

    public PdVector getViewDir() {
        double scale = this.getScale();
        int i = 0;
        while (i < 3) {
            this.m_viewDir.m_data[i] = -this.m_view.m_data[2][i] / scale;
            ++i;
        }
        return this.m_viewDir;
    }

    public void setViewDir(PdVector pos) {
        double roll = this.getRoll();
        this.m_viewDir.copy(pos);
        this.computeView();
        this.setRoll(roll);
    }

    public double getDist() {
        double dist = this.SIZE / this.getScale();
        return dist;
    }

    public void setDist(double newDist) {
        this.setScale(this.SIZE / newDist);
    }

    public double getFarClip() {
        return this.m_farClip.getValue();
    }

    public double getFieldOfView() {
        return this.m_fieldOfView.getValue();
    }

    public void setFieldOfView(double angle) {
    }

    public void setFarClip(double dist) {
        this.m_farClip.setValue(dist);
    }

    protected void mouseAnimateGeometry() {
        PuReflect.makeRotation(this.m_incrView, new PdVector(0.0, 0.0, 1.0), 0.06283185307179587);
        this.m_incrViewInv.transpose(this.m_incrView);
        if (this.m_display.isEnabledLocalTransform()) {
            this.m_view.rightMult(this.m_incrView);
            this.m_viewInv.leftMult(this.m_incrViewInv);
        } else {
            this.m_view.leftMult(this.m_incrView);
            this.m_viewInv.rightMult(this.m_incrViewInv);
        }
        this.m_trans.mult(this.m_proj, this.m_view);
        this.m_transInv.mult(this.m_viewInv, this.m_projInv);
    }

    public PdVector getPosition() {
        double dist = this.getDist();
        PdVector interest = this.getInterest();
        PdVector viewDir = this.getViewDir();
        int i = 0;
        while (i < 3) {
            this.m_position.m_data[i] = interest.m_data[i] - dist * viewDir.m_data[i];
            ++i;
        }
        return this.m_position;
    }

    public void setPosition(PdVector pos) {
        double roll = this.getRoll();
        this.m_viewDir.sub(this.getInterest(), pos);
        double dist = this.m_viewDir.length();
        this.computeView();
        this.setDist(dist);
        this.setRoll(roll);
    }

    private void computeProjection() {
        PsDebug.notify("called");
        if (this.m_nWidth <= 0.0 && this.m_nHeight <= 0.0) {
            PsDebug.notify("called with empty window");
            return;
        }
        this.m_proj.m_data[0][0] = Math.min(this.m_nWidth, this.m_nHeight) / this.SIZE;
        this.m_proj.m_data[1][1] = -Math.min(this.m_nWidth, this.m_nHeight) / this.SIZE;
        this.m_proj.m_data[0][3] = (this.m_nWidth - 1.0) / 2.0;
        this.m_proj.m_data[1][3] = (this.m_nHeight - 1.0) / 2.0;
        this.m_projInv.m_data[0][0] = 1.0 / this.m_proj.m_data[0][0];
        this.m_projInv.m_data[1][1] = 1.0 / this.m_proj.m_data[1][1];
        this.m_projInv.m_data[0][3] = -this.m_proj.m_data[0][3] / this.m_proj.m_data[0][0];
        this.m_projInv.m_data[1][3] = -this.m_proj.m_data[1][3] / this.m_proj.m_data[1][1];
        this.m_proj.m_data[2][2] = this.Z_STRETCH;
        this.m_projInv.m_data[2][2] = 1.0 / this.Z_STRETCH;
        this.m_trans.mult(this.m_proj, this.m_view);
        this.m_transInv.mult(this.m_viewInv, this.m_projInv);
    }

    public void init() {
        super.init();
        this.m_fieldOfView.setDefBounds(5.0, 180.0, 1.0, 5.0);
        this.m_fieldOfView.setDefValue(this.m_defFieldOfView);
        this.m_fieldOfView.init();
        this.m_roll.setDefBounds(-180.0, 180.0, 1.0, 10.0);
        this.m_roll.setDefValue(this.m_defRoll);
        this.m_roll.init();
        this.m_nearClip.setDefBounds(this.m_defNearClip - 2.0 * (this.m_defNearClip - this.m_defFarClip), this.m_defNearClip + 2.0 * (this.m_defNearClip - this.m_defFarClip), 0.1, 1.0);
        this.m_nearClip.setDefValue(this.m_defNearClip);
        this.m_nearClip.init();
        this.m_farClip.setDefBounds(this.m_defFarClip - 2.0 * (this.m_defNearClip - this.m_defFarClip), this.m_defNearClip + 2.0 * (this.m_defNearClip - this.m_defFarClip), 0.1, 1.0);
        this.m_farClip.setDefValue(this.m_defFarClip);
        this.m_farClip.init();
        this.m_bEnableClip = false;
        this.m_vecAlt.set(0.0, 0.0, 1.0);
        this.m_pick.set(0.0, 0.0, 0.0, 1.0);
        this.m_proj.setIdentity();
        this.m_projInv.setIdentity();
        this.m_view.setIdentity();
        this.m_viewInv.setIdentity();
        this.m_incrView.setIdentity();
        this.m_incrViewInv.setIdentity();
        this.m_trans.setIdentity();
        this.m_transInv.setIdentity();
        this.computeProjection();
        PsDebug.notify("mode = " + this.m_projMode);
        switch (this.m_projMode) {
            case 0: {
                this.m_viewDir.set(0.1, 0.6, -0.4);
                this.m_defaultUpVector.set(0.0, 0.0, 1.0);
                break;
            }
            case 1: {
                this.m_viewDir.set(0.0, 0.0, -1.0);
                this.m_defaultUpVector.set(0.0, 1.0, 0.0);
                break;
            }
            case 2: {
                this.m_viewDir.set(0.0, 1.0, 0.0);
                this.m_defaultUpVector.set(0.0, 0.0, 1.0);
                break;
            }
            case 3: {
                this.m_viewDir.set(-1.0, 0.0, 0.0);
                this.m_defaultUpVector.set(0.0, 0.0, 1.0);
                break;
            }
            default: {
                PsDebug.error("unkown projection mode = " + this.m_projMode, this);
            }
        }
        this.m_upVector.copy(this.m_defaultUpVector);
        this.setInterest(new PdVector(0.0, 0.0, 0.0));
        this.computeView();
    }
}

