/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.ruler;

import java.util.Enumeration;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PvDisplayIf;
import jv.thirdParty.ruler.PgRuler;
import jv.vecmath.PdVector;

public final class PgAxes
extends PgGeometry {
    public static final int AXES_3DCENTRAL = 0;
    public static final int AXES_3DCORNER = 1;
    public static final int AXES_3DBOUNDINGBOX = 2;
    public static final int AXES_2DXY_CENTER = 3;
    public static final int AXES_2DYZ_CENTER = 4;
    public static final int AXES_2DZX_CENTER = 5;
    public static final int AXES_2DXY_CORNER = 6;
    public static final int AXES_2DYZ_CORNER = 7;
    public static final int AXES_2DZX_CORNER = 8;
    protected final int XN = 0;
    protected final int XUP = 1;
    protected final int YN = 2;
    protected final int YUP = 3;
    protected final int ZN = 4;
    protected final int ZUP = 5;
    protected final int MIN = 0;
    protected final int MAX = 1;
    protected final int X = 0;
    protected final int Y = 1;
    protected final int Z = 2;
    protected final int N = 0;
    protected final int U = 1;
    protected final int NEGN = -1;
    protected final int NEGU = -2;
    protected final double defScale = 5.0;
    protected final int xoff = 7;
    protected final int yoff = 3;
    protected final int[] stdAlignmnt;
    protected boolean[] m_showHashingFlags;
    protected boolean m_bFixedMode;
    protected boolean m_bShowAllMajors;
    protected boolean m_bShowAllMinors;
    protected boolean m_bShowLabels;
    protected boolean m_bShowTitles;
    protected PuInteger m_numMajorHashings;
    protected PuInteger m_numMinorHashings;
    protected PuDouble m_majorHashUnits;
    protected PuDouble m_minorHashUnits;
    protected PdVector[] m_bndBox;
    protected PdVector m_viewVect;
    protected PgRuler[] m_axis;
    protected int m_numAxis;
    protected PgRuler m_xaxis;
    protected PgRuler m_yaxis;
    protected PgRuler m_zaxis;
    protected int m_mode;
    protected double m_scale;
    protected boolean m_bAutoConfigure;
    private String[] m_defAxisLabel;

    public void setTitleAlignments(int[] xAlign, int[] yAlign, int[] zAlign) {
        this.m_xaxis.setNameAlignment(xAlign[0], xAlign[1], xAlign[2], xAlign[3]);
        this.m_yaxis.setNameAlignment(yAlign[0], yAlign[1], yAlign[2], yAlign[3]);
        this.m_zaxis.setNameAlignment(zAlign[0], zAlign[1], zAlign[2], zAlign[3]);
    }

    public boolean isShowingXYGrid() {
        return this.m_showHashingFlags[0] && this.m_showHashingFlags[3];
    }

    public boolean isShowingZXGrid() {
        return this.m_showHashingFlags[4] && this.m_showHashingFlags[1];
    }

    public void showXYGrid(boolean flag) {
        this.m_showHashingFlags[0] = flag;
        this.m_showHashingFlags[3] = flag;
    }

    public void showZXGrid(boolean flag) {
        this.m_showHashingFlags[4] = flag;
        this.m_showHashingFlags[1] = flag;
    }

    public boolean isShowingMinorHashings() {
        return this.m_bShowAllMinors;
    }

    public void showMinorHashings(boolean flag) {
        int i = 0;
        while (i < this.m_numAxis) {
            this.m_axis[i].showMinorHashings(flag);
            ++i;
        }
        this.m_bShowAllMinors = flag;
    }

    public boolean update(Object event) {
        PsDebug.notify("called");
        if (event == this) {
            this.constructAxes();
            this.m_xaxis.update(this.m_xaxis);
            this.m_yaxis.update(this.m_yaxis);
            this.m_zaxis.update(this.m_zaxis);
            return super.update(this);
        }
        if (event == this.m_majorHashUnits || event == this.m_minorHashUnits) {
            this.setFixedHashings(this.m_majorHashUnits.getValue(), this.m_minorHashUnits.getValue());
            return this.update(this);
        }
        if (event == this.m_numMajorHashings || event == this.m_numMinorHashings) {
            this.setPartitionedHashing(this.m_numMajorHashings.getValue(), this.m_numMinorHashings.getValue());
            return this.update(this);
        }
        return super.update(event);
    }

    public boolean isShowingYZGrid() {
        return this.m_showHashingFlags[2] && this.m_showHashingFlags[5];
    }

    public void showYZGrid(boolean flag) {
        this.m_showHashingFlags[2] = flag;
        this.m_showHashingFlags[5] = flag;
    }

    public boolean isShowingLabels() {
        return this.m_bShowLabels;
    }

    public void showLabels(boolean flag) {
        int i = 0;
        while (i < this.m_numAxis) {
            this.m_axis[i].showLabels(flag);
            ++i;
        }
        this.m_bShowLabels = flag;
    }

    public void setAutoConfigure(boolean flag) {
        this.m_bAutoConfigure = flag;
    }

    protected void constructAxes() {
        this.m_xaxis.setHashOffsetInNormalDir(0.0, 0.0, 0.0);
        this.m_xaxis.setHashOffsetInUpDir(0.0, 0.0, 0.0);
        this.m_yaxis.setHashOffsetInNormalDir(0.0, 0.0, 0.0);
        this.m_yaxis.setHashOffsetInUpDir(0.0, 0.0, 0.0);
        this.m_zaxis.setHashOffsetInNormalDir(0.0, 0.0, 0.0);
        this.m_zaxis.setHashOffsetInUpDir(0.0, 0.0, 0.0);
        this.m_xaxis.showHashingsInUpDir(this.m_showHashingFlags[1]);
        this.m_yaxis.showHashingsInUpDir(this.m_showHashingFlags[3]);
        this.m_zaxis.showHashingsInUpDir(this.m_showHashingFlags[5]);
        this.m_xaxis.showHashingsInNormalDir(this.m_showHashingFlags[0]);
        this.m_yaxis.showHashingsInNormalDir(this.m_showHashingFlags[2]);
        this.m_zaxis.showHashingsInNormalDir(this.m_showHashingFlags[4]);
        switch (this.m_mode) {
            case 0: {
                this.setVisibleAxes(true, true, true);
                this.modeCentral();
                break;
            }
            case 1: {
                this.setVisibleAxes(true, true, true);
                this.modeCorner();
                break;
            }
            case 2: {
                this.setVisibleAxes(true, true, true);
                this.modeBoundingBox();
                break;
            }
            case 3: {
                this.setVisibleAxes(true, true, false);
                this.modeCentral();
                this.setTitleAlignments(this.stdAlignmnt, this.stdAlignmnt, this.stdAlignmnt);
                break;
            }
            case 4: {
                this.setVisibleAxes(false, true, true);
                this.modeCentral();
                this.setTitleAlignments(this.stdAlignmnt, this.stdAlignmnt, this.stdAlignmnt);
                this.setHashingsForUninvolvedAxes(0, 0, 1);
                break;
            }
            case 5: {
                this.setVisibleAxes(true, false, true);
                this.modeCentral();
                this.setTitleAlignments(this.stdAlignmnt, this.stdAlignmnt, this.stdAlignmnt);
                this.setHashingsForUninvolvedAxes(1, 0, 0);
                break;
            }
            case 6: {
                this.setVisibleAxes(true, true, false);
                this.modeCorner();
                this.setTitleAlignments(this.stdAlignmnt, this.stdAlignmnt, this.stdAlignmnt);
                break;
            }
            case 7: {
                this.setVisibleAxes(false, true, true);
                this.modeCorner();
                this.setTitleAlignments(this.stdAlignmnt, this.stdAlignmnt, this.stdAlignmnt);
                this.setHashingsForUninvolvedAxes(0, 0, 1);
                break;
            }
            case 8: {
                this.setVisibleAxes(true, false, true);
                this.modeCorner();
                this.setTitleAlignments(this.stdAlignmnt, this.stdAlignmnt, this.stdAlignmnt);
                this.setHashingsForUninvolvedAxes(1, 0, 0);
                break;
            }
            default: {
                this.setVisibleAxes(true, true, true);
                this.modeCentral();
                break;
            }
        }
    }

    protected void setVisibleAxes(boolean showx, boolean showy, boolean showz) {
        if (!showx) {
            this.showXYGrid(showx);
            this.showZXGrid(showx);
        }
        if (!showy) {
            this.showXYGrid(showy);
            this.showYZGrid(showy);
        }
        if (!showz) {
            this.showYZGrid(showz);
            this.showZXGrid(showz);
        }
        this.m_xaxis.setVisible(showx);
        this.m_yaxis.setVisible(showy);
        this.m_zaxis.setVisible(showz);
    }

    public PgGeometry[] getAxes() {
        return this.m_axis;
    }

    protected void setHashingsForUninvolvedAxes(int xdir, int ydir, int zdir) {
        double xLen = this.m_bndBox[1].getEntry(0) - this.m_bndBox[0].getEntry(0);
        double yLen = this.m_bndBox[1].getEntry(1) - this.m_bndBox[0].getEntry(1);
        double zLen = this.m_bndBox[1].getEntry(2) - this.m_bndBox[0].getEntry(2);
        double minAxisLength = this.nonZeroMin(xLen, yLen, zLen);
        double hMaj = 0.06 * minAxisLength;
        double hMin = 0.03 * minAxisLength;
        if (!this.m_showHashingFlags[1] && !this.m_showHashingFlags[0]) {
            switch (xdir) {
                case 0: {
                    this.m_xaxis.setMajorHashSize(0.0, hMaj, 0);
                    this.m_xaxis.setMinorHashSize(0.0, hMin, 0);
                    this.m_xaxis.showHashingsInNormalDir(true);
                    break;
                }
                case -1: {
                    this.m_xaxis.setMajorHashSize(0.0, -hMaj, 0);
                    this.m_xaxis.setMinorHashSize(0.0, -hMin, 0);
                    this.m_xaxis.showHashingsInNormalDir(true);
                    break;
                }
                case 1: {
                    this.m_xaxis.setMajorHashSize(0.0, hMaj, 1);
                    this.m_xaxis.setMinorHashSize(0.0, hMin, 1);
                    this.m_xaxis.showHashingsInUpDir(true);
                    break;
                }
                case -2: {
                    this.m_xaxis.setMajorHashSize(0.0, -hMaj, 1);
                    this.m_xaxis.setMinorHashSize(0.0, -hMin, 1);
                    this.m_xaxis.showHashingsInUpDir(true);
                    break;
                }
            }
        }
        if (!this.m_showHashingFlags[3] && !this.m_showHashingFlags[2]) {
            switch (ydir) {
                case 0: {
                    this.m_yaxis.setMajorHashSize(0.0, hMaj, 0);
                    this.m_yaxis.setMinorHashSize(0.0, hMin, 0);
                    this.m_yaxis.showHashingsInNormalDir(true);
                    break;
                }
                case -1: {
                    this.m_yaxis.setMajorHashSize(0.0, -hMaj, 0);
                    this.m_yaxis.setMinorHashSize(0.0, -hMin, 0);
                    this.m_yaxis.showHashingsInNormalDir(true);
                    break;
                }
                case 1: {
                    this.m_yaxis.setMajorHashSize(0.0, hMaj, 1);
                    this.m_yaxis.setMinorHashSize(0.0, hMin, 1);
                    this.m_yaxis.showHashingsInUpDir(true);
                    break;
                }
                case -2: {
                    this.m_yaxis.setMajorHashSize(0.0, -hMaj, 1);
                    this.m_yaxis.setMinorHashSize(0.0, -hMin, 1);
                    this.m_yaxis.showHashingsInUpDir(true);
                    break;
                }
            }
        }
        if (!this.m_showHashingFlags[5] && !this.m_showHashingFlags[4]) {
            switch (zdir) {
                case 0: {
                    this.m_zaxis.setMajorHashSize(0.0, hMaj, 0);
                    this.m_zaxis.setMinorHashSize(0.0, hMin, 0);
                    this.m_zaxis.showHashingsInNormalDir(true);
                    break;
                }
                case -1: {
                    this.m_zaxis.setMajorHashSize(0.0, -hMaj, 0);
                    this.m_zaxis.setMinorHashSize(0.0, -hMin, 0);
                    this.m_zaxis.showHashingsInNormalDir(true);
                    break;
                }
                case 1: {
                    this.m_zaxis.setMajorHashSize(0.0, hMaj, 1);
                    this.m_zaxis.setMinorHashSize(0.0, hMin, 1);
                    this.m_zaxis.showHashingsInUpDir(true);
                    break;
                }
                case -2: {
                    this.m_zaxis.setMajorHashSize(0.0, -hMaj, 1);
                    this.m_zaxis.setMinorHashSize(0.0, -hMin, 1);
                    this.m_zaxis.showHashingsInUpDir(true);
                    break;
                }
            }
        }
    }

    protected void modeBoundingBox() {
        int i = 0;
        while (i < this.m_numAxis) {
            this.m_axis[i].setMinMax(this.m_bndBox[0].getEntry(i), this.m_bndBox[1].getEntry(i));
            ++i;
        }
        double xAxisLen = this.m_xaxis.getMaxParameter() - this.m_xaxis.getMinParameter();
        double yAxisLen = this.m_yaxis.getMaxParameter() - this.m_yaxis.getMinParameter();
        double zAxisLen = this.m_zaxis.getMaxParameter() - this.m_zaxis.getMinParameter();
        if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
            this.m_xaxis.setMinorHashSize(0.0, yAxisLen, 0);
            this.m_yaxis.setMinorHashSize(0.0, xAxisLen, 1);
            this.m_xaxis.setMajorHashSize(0.0, yAxisLen, 0);
            this.m_yaxis.setMajorHashSize(0.0, xAxisLen, 1);
        }
        if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
            this.m_yaxis.setMinorHashSize(0.0, zAxisLen, 0);
            this.m_zaxis.setMinorHashSize(0.0, yAxisLen, 1);
            this.m_yaxis.setMajorHashSize(0.0, zAxisLen, 0);
            this.m_zaxis.setMajorHashSize(0.0, yAxisLen, 1);
        }
        if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
            this.m_zaxis.setMinorHashSize(0.0, xAxisLen, 0);
            this.m_xaxis.setMinorHashSize(0.0, zAxisLen, 1);
            this.m_zaxis.setMajorHashSize(0.0, xAxisLen, 0);
            this.m_xaxis.setMajorHashSize(0.0, zAxisLen, 1);
        }
        int off = new Double(2.0 * Math.ceil(5.0)).intValue();
        double xcoord = this.m_viewVect.getEntry(0);
        double ycoord = this.m_viewVect.getEntry(1);
        double zcoord = this.m_viewVect.getEntry(2);
        if (xcoord <= 0.0 && ycoord <= 0.0) {
            this.m_xaxis.setOrigin(new PdVector(0.0, this.m_bndBox[1].getEntry(1), this.m_bndBox[0].getEntry(2)));
            this.m_yaxis.setOrigin(new PdVector(this.m_bndBox[1].getEntry(0), 0.0, this.m_bndBox[0].getEntry(2)));
            this.m_zaxis.setOrigin(new PdVector(this.m_bndBox[1].getEntry(0), this.m_bndBox[0].getEntry(1), 0.0));
            int[] nArray = new int[4];
            nArray[0] = 2;
            nArray[2] = off;
            nArray[3] = off;
            int[] xa = nArray;
            int[] ya = new int[]{2, 2, -off, off};
            int[] za = new int[]{2, 2, -off, off};
            this.setTitleAlignments(xa, ya, za);
            if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
                this.m_xaxis.setHashOffsetInNormalDir(0.0, -yAxisLen, 0.0);
                this.m_yaxis.setHashOffsetInUpDir(-xAxisLen, 0.0, 0.0);
            }
            if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
                this.m_zaxis.setHashOffsetInNormalDir(-xAxisLen, yAxisLen, 0.0);
            }
            this.setHashingsForUninvolvedAxes(-1, -2, 1);
        } else if (xcoord <= 0.0 && ycoord > 0.0) {
            this.m_xaxis.setOrigin(new PdVector(0.0, this.m_bndBox[0].getEntry(1), this.m_bndBox[0].getEntry(2)));
            this.m_yaxis.setOrigin(new PdVector(this.m_bndBox[1].getEntry(0), 0.0, this.m_bndBox[0].getEntry(2)));
            this.m_zaxis.setOrigin(new PdVector(this.m_bndBox[0].getEntry(0), this.m_bndBox[0].getEntry(1), 0.0));
            int[] xa = new int[]{2, 2, -off, off};
            int[] nArray = new int[4];
            nArray[0] = 2;
            nArray[2] = off;
            nArray[3] = off;
            int[] ya = nArray;
            int[] za = new int[]{2, 2, -off, off};
            this.setTitleAlignments(xa, ya, za);
            if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
                this.m_yaxis.setHashOffsetInUpDir(-xAxisLen, 0.0, 0.0);
            }
            if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
                this.m_zaxis.setHashOffsetInUpDir(xAxisLen, 0.0, 0.0);
            }
            this.setHashingsForUninvolvedAxes(0, -2, 0);
        } else if (xcoord > 0.0 && ycoord <= 0.0) {
            this.m_xaxis.setOrigin(new PdVector(0.0, this.m_bndBox[1].getEntry(1), this.m_bndBox[0].getEntry(2)));
            this.m_yaxis.setOrigin(new PdVector(this.m_bndBox[0].getEntry(0), 0.0, this.m_bndBox[0].getEntry(2)));
            this.m_zaxis.setOrigin(new PdVector(this.m_bndBox[1].getEntry(0), this.m_bndBox[1].getEntry(1), 0.0));
            int[] xa = new int[]{2, 2, -off, off};
            int[] nArray = new int[4];
            nArray[0] = 2;
            nArray[2] = off;
            nArray[3] = off;
            int[] ya = nArray;
            int[] za = new int[]{2, 2, -off, off};
            this.setTitleAlignments(xa, ya, za);
            if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
                this.m_xaxis.setHashOffsetInNormalDir(0.0, -yAxisLen, 0.0);
            }
            if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
                this.m_zaxis.setHashOffsetInNormalDir(-xAxisLen, 0.0, 0.0);
            }
            if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
                this.m_zaxis.setHashOffsetInUpDir(-xAxisLen, -yAxisLen, 0.0);
            }
            this.setHashingsForUninvolvedAxes(-1, 1, -1);
        } else {
            this.m_xaxis.setOrigin(new PdVector(0.0, this.m_bndBox[0].getEntry(1), this.m_bndBox[0].getEntry(2)));
            this.m_yaxis.setOrigin(new PdVector(this.m_bndBox[0].getEntry(0), 0.0, this.m_bndBox[0].getEntry(2)));
            this.m_zaxis.setOrigin(new PdVector(this.m_bndBox[0].getEntry(0), this.m_bndBox[1].getEntry(1), 0.0));
            int[] nArray = new int[4];
            nArray[0] = 2;
            nArray[2] = off;
            nArray[3] = off;
            int[] xa = nArray;
            int[] ya = new int[]{2, 2, -off, off};
            int[] za = new int[]{2, 2, -off, off};
            this.setTitleAlignments(xa, ya, za);
            if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
                this.m_zaxis.setHashOffsetInNormalDir(0.0, -yAxisLen, 0.0);
            }
            if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
                this.m_zaxis.setHashOffsetInUpDir(0.0, -yAxisLen, 0.0);
            }
            this.setHashingsForUninvolvedAxes(0, 1, -2);
        }
    }

    protected void modeCentral() {
        int i = 0;
        while (i < this.m_numAxis) {
            this.m_axis[i].setOrigin(new PdVector(0.0, 0.0, 0.0));
            this.m_axis[i].setMinMax(this.m_bndBox[0].getEntry(i), this.m_bndBox[1].getEntry(i));
            ++i;
        }
        if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
            this.m_xaxis.setMinorHashSize(this.m_yaxis.getMaxParameter(), this.m_yaxis.getMinParameter(), 0);
            this.m_yaxis.setMinorHashSize(this.m_xaxis.getMaxParameter(), this.m_xaxis.getMinParameter(), 1);
            this.m_xaxis.setMajorHashSize(this.m_yaxis.getMaxParameter(), this.m_yaxis.getMinParameter(), 0);
            this.m_yaxis.setMajorHashSize(this.m_xaxis.getMaxParameter(), this.m_xaxis.getMinParameter(), 1);
        }
        if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
            this.m_yaxis.setMinorHashSize(this.m_zaxis.getMaxParameter(), this.m_zaxis.getMinParameter(), 0);
            this.m_zaxis.setMinorHashSize(this.m_yaxis.getMaxParameter(), this.m_yaxis.getMinParameter(), 1);
            this.m_yaxis.setMajorHashSize(this.m_zaxis.getMaxParameter(), this.m_zaxis.getMinParameter(), 0);
            this.m_zaxis.setMajorHashSize(this.m_yaxis.getMaxParameter(), this.m_yaxis.getMinParameter(), 1);
        }
        if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
            this.m_zaxis.setMinorHashSize(this.m_xaxis.getMaxParameter(), this.m_xaxis.getMinParameter(), 0);
            this.m_xaxis.setMinorHashSize(this.m_zaxis.getMaxParameter(), this.m_zaxis.getMinParameter(), 1);
            this.m_zaxis.setMajorHashSize(this.m_xaxis.getMaxParameter(), this.m_xaxis.getMinParameter(), 0);
            this.m_xaxis.setMajorHashSize(this.m_zaxis.getMaxParameter(), this.m_zaxis.getMinParameter(), 1);
        }
        double xcoord = this.m_viewVect.getEntry(0);
        double ycoord = this.m_viewVect.getEntry(1);
        double zcoord = this.m_viewVect.getEntry(2);
        if (xcoord <= 0.0 && ycoord <= 0.0) {
            int[] xa = new int[]{1, 2, -7, 3};
            int[] nArray = new int[4];
            nArray[0] = 1;
            nArray[2] = 7;
            nArray[3] = 3;
            int[] ya = nArray;
            int[] nArray2 = new int[4];
            nArray2[0] = 1;
            nArray2[2] = -3;
            nArray2[3] = -7;
            int[] za = nArray2;
            if (zcoord > 0.0) {
                za[0] = 0;
                za[3] = 14;
            }
            this.setTitleAlignments(xa, ya, za);
        } else if (xcoord <= 0.0 && ycoord > 0.0) {
            int[] nArray = new int[4];
            nArray[0] = 1;
            nArray[2] = 7;
            nArray[3] = 3;
            int[] xa = nArray;
            int[] nArray3 = new int[4];
            nArray3[1] = 2;
            nArray3[2] = -7;
            nArray3[3] = 3;
            int[] ya = nArray3;
            int[] nArray4 = new int[4];
            nArray4[0] = 1;
            nArray4[2] = -3;
            nArray4[3] = -7;
            int[] za = nArray4;
            if (zcoord > 0.0) {
                za[0] = 0;
                za[3] = 14;
            }
            this.setTitleAlignments(xa, ya, za);
        } else if (xcoord > 0.0 && ycoord <= 0.0) {
            int[] nArray = new int[4];
            nArray[2] = 7;
            nArray[3] = 3;
            int[] xa = nArray;
            int[] ya = new int[]{1, 2, -7, 3};
            int[] nArray5 = new int[4];
            nArray5[0] = 1;
            nArray5[2] = -3;
            nArray5[3] = -7;
            int[] za = nArray5;
            if (zcoord > 0.0) {
                za[0] = 0;
                za[3] = 14;
            }
            this.setTitleAlignments(xa, ya, za);
        } else {
            int[] nArray = new int[4];
            nArray[1] = 2;
            nArray[2] = -7;
            nArray[3] = 3;
            int[] xa = nArray;
            int[] nArray6 = new int[4];
            nArray6[2] = 7;
            nArray6[3] = 3;
            int[] ya = nArray6;
            int[] nArray7 = new int[4];
            nArray7[0] = 1;
            nArray7[2] = -3;
            nArray7[3] = -7;
            int[] za = nArray7;
            if (zcoord > 0.0) {
                za[0] = 0;
                za[3] = 14;
            }
            this.setTitleAlignments(xa, ya, za);
        }
        this.setHashingsForUninvolvedAxes(0, 1, 0);
    }

    public boolean isShowingMajorHashings() {
        return this.m_bShowAllMajors;
    }

    public void showMajorHashings(boolean flag) {
        int i = 0;
        while (i < this.m_numAxis) {
            this.m_axis[i].showMajorHashings(flag);
            ++i;
        }
        this.m_bShowAllMajors = flag;
    }

    public void setFixedHashings(double major, double minor) {
        int i = 0;
        while (i < this.m_numAxis) {
            this.m_axis[i].setFixedHashing(major, minor);
            ++i;
        }
        if (major >= this.m_majorHashUnits.getMax() - 0.5) {
            this.m_majorHashUnits.setBounds(0.1, 2.0 * major);
        }
        if (minor >= this.m_minorHashUnits.getMax() - 0.5) {
            this.m_minorHashUnits.setBounds(0.1, 2.0 * minor);
        }
        this.m_majorHashUnits.setValue(major);
        this.m_minorHashUnits.setValue(minor);
    }

    private double nonZeroMin(double x, double y, double z) {
        double min = Double.MAX_VALUE;
        if (x > 0.0 && x < min) {
            min = x;
        }
        if (y > 0.0 && y < min) {
            min = y;
        }
        if (z > 0.0 && z < min) {
            min = z;
        }
        if (min == Double.MAX_VALUE) {
            min = z;
        }
        return min;
    }

    public void setPartitionedHashing(int major, int minor) {
        int i = 0;
        while (i < this.m_numAxis) {
            this.m_axis[i].setPartitionedHashing(major, minor);
            ++i;
        }
        this.m_numMajorHashings.setValue(major);
        this.m_numMinorHashings.setValue(minor);
    }

    public PgAxes(int dim) {
        super(dim);
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[2] = 7;
        nArray[3] = 3;
        this.stdAlignmnt = nArray;
        this.m_showHashingFlags = new boolean[6];
        this.m_defAxisLabel = new String[]{"x", "y", "z"};
        this.setTag(7);
        this.setName("Axes");
        this.m_viewVect = new PdVector(0.0, 0.0, -1.0);
        this.m_bndBox = new PdVector[2];
        this.m_bndBox[0] = new PdVector(3);
        this.m_bndBox[1] = new PdVector(3);
        PdVector posXDir = new PdVector(1.0, 0.0, 0.0);
        PdVector posYDir = new PdVector(0.0, 1.0, 0.0);
        PdVector posZDir = new PdVector(0.0, 0.0, 1.0);
        this.m_xaxis = new PgRuler(posXDir, posYDir);
        this.m_yaxis = new PgRuler(posYDir, posZDir);
        this.m_zaxis = new PgRuler(posZDir, posXDir);
        this.m_numAxis = 3;
        this.m_axis = new PgRuler[]{this.m_xaxis, this.m_yaxis, this.m_zaxis};
        this.m_majorHashUnits = new PuDouble("Major Units", this);
        this.m_minorHashUnits = new PuDouble("Minor Units", this);
        this.m_numMajorHashings = new PuInteger("Major Hashings", this);
        this.m_numMinorHashings = new PuInteger("Minor Hashings", this);
        this.init();
    }

    public void setMode(int mode) {
        this.m_mode = mode;
        Enumeration enumeration = this.getDisplays();
        if (enumeration == null) {
            return;
        }
        int drawOrder = 1;
        if (this.m_mode == 1) {
            drawOrder = -1;
        }
        while (enumeration.hasMoreElements()) {
            PvDisplayIf disp = (PvDisplayIf)enumeration.nextElement();
            int i = 0;
            while (i < this.m_numAxis) {
                disp.setDrawingOrder(drawOrder, this.m_axis[i]);
                ++i;
            }
        }
    }

    public int getMode() {
        return this.m_mode;
    }

    public boolean isShowingTitles() {
        return this.m_bShowTitles;
    }

    public void showTitles(boolean flag) {
        int i = 0;
        while (i < this.m_numAxis) {
            this.m_axis[i].showRulerName(flag);
            ++i;
        }
        this.m_bShowTitles = flag;
    }

    public void setTitles(String[] axisTitle) {
        int i = 0;
        while (i < this.m_numAxis) {
            this.m_axis[i].setRulerName(axisTitle[i]);
            ++i;
        }
    }

    public void showFixedMode(boolean flag) {
        int i = 0;
        while (i < this.m_numAxis) {
            this.m_axis[i].showFixedMode(flag);
            ++i;
        }
        this.m_bFixedMode = flag;
    }

    private double nonZeroMax(double x, double y, double z) {
        return Math.max(Math.max(x, y), z);
    }

    protected void modeCorner() {
        int i = 0;
        while (i < this.m_numAxis) {
            this.m_axis[i].setMinMax(this.m_bndBox[0].getEntry(i), this.m_bndBox[1].getEntry(i));
            ++i;
        }
        double xAxisLen = this.m_xaxis.getMaxParameter() - this.m_xaxis.getMinParameter();
        double yAxisLen = this.m_yaxis.getMaxParameter() - this.m_yaxis.getMinParameter();
        double zAxisLen = this.m_zaxis.getMaxParameter() - this.m_zaxis.getMinParameter();
        if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
            this.m_xaxis.setMinorHashSize(0.0, yAxisLen, 0);
            this.m_yaxis.setMinorHashSize(0.0, xAxisLen, 1);
            this.m_xaxis.setMajorHashSize(0.0, yAxisLen, 0);
            this.m_yaxis.setMajorHashSize(0.0, xAxisLen, 1);
        }
        if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
            this.m_yaxis.setMinorHashSize(0.0, zAxisLen, 0);
            this.m_zaxis.setMinorHashSize(0.0, yAxisLen, 1);
            this.m_yaxis.setMajorHashSize(0.0, zAxisLen, 0);
            this.m_zaxis.setMajorHashSize(0.0, yAxisLen, 1);
        }
        if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
            this.m_zaxis.setMinorHashSize(0.0, xAxisLen, 0);
            this.m_xaxis.setMinorHashSize(0.0, zAxisLen, 1);
            this.m_zaxis.setMajorHashSize(0.0, xAxisLen, 0);
            this.m_xaxis.setMajorHashSize(0.0, zAxisLen, 1);
        }
        double xcoord = this.m_viewVect.getEntry(0);
        double ycoord = this.m_viewVect.getEntry(1);
        if (xcoord <= 0.0 && ycoord <= 0.0) {
            this.m_xaxis.setOrigin(new PdVector(0.0, this.m_bndBox[0].getEntry(1), this.m_bndBox[0].getEntry(2)));
            this.m_yaxis.setOrigin(new PdVector(this.m_bndBox[0].getEntry(0), 0.0, this.m_bndBox[0].getEntry(2)));
            this.m_zaxis.setOrigin(new PdVector(this.m_bndBox[0].getEntry(0), this.m_bndBox[0].getEntry(1), 0.0));
            int[] xa = new int[]{1, 1, -7, 3};
            int[] nArray = new int[4];
            nArray[0] = 1;
            nArray[2] = 7;
            nArray[3] = 3;
            int[] ya = nArray;
            int[] nArray2 = new int[4];
            nArray2[0] = 1;
            nArray2[2] = -3;
            nArray2[3] = -7;
            int[] za = nArray2;
            this.setTitleAlignments(xa, ya, za);
            this.setHashingsForUninvolvedAxes(0, 1, 1);
        } else if (xcoord <= 0.0 && ycoord > 0.0) {
            this.m_xaxis.setOrigin(new PdVector(0.0, this.m_bndBox[1].getEntry(1), this.m_bndBox[0].getEntry(2)));
            this.m_yaxis.setOrigin(new PdVector(this.m_bndBox[0].getEntry(0), 0.0, this.m_bndBox[0].getEntry(2)));
            this.m_zaxis.setOrigin(new PdVector(this.m_bndBox[0].getEntry(0), this.m_bndBox[1].getEntry(1), 0.0));
            int[] nArray = new int[4];
            nArray[0] = 1;
            nArray[2] = 7;
            nArray[3] = 3;
            int[] xa = nArray;
            int[] nArray3 = new int[4];
            nArray3[1] = 1;
            nArray3[2] = -7;
            nArray3[3] = 3;
            int[] ya = nArray3;
            int[] nArray4 = new int[4];
            nArray4[0] = 1;
            nArray4[2] = -3;
            nArray4[3] = -7;
            int[] za = nArray4;
            this.setTitleAlignments(xa, ya, za);
            if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
                this.m_xaxis.setHashOffsetInNormalDir(0.0, -yAxisLen, 0.0);
            }
            if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
                this.m_zaxis.setHashOffsetInUpDir(0.0, -yAxisLen, 0.0);
            }
            this.setHashingsForUninvolvedAxes(-1, 1, 0);
        } else if (xcoord > 0.0 && ycoord <= 0.0) {
            this.m_xaxis.setOrigin(new PdVector(0.0, this.m_bndBox[0].getEntry(1), this.m_bndBox[0].getEntry(2)));
            this.m_yaxis.setOrigin(new PdVector(this.m_bndBox[1].getEntry(0), 0.0, this.m_bndBox[0].getEntry(2)));
            this.m_zaxis.setOrigin(new PdVector(this.m_bndBox[1].getEntry(0), this.m_bndBox[0].getEntry(1), 0.0));
            int[] nArray = new int[4];
            nArray[2] = 7;
            nArray[3] = 3;
            int[] xa = nArray;
            int[] ya = new int[]{1, 1, -7, 3};
            int[] nArray5 = new int[4];
            nArray5[0] = 1;
            nArray5[2] = -3;
            nArray5[3] = -7;
            int[] za = nArray5;
            this.setTitleAlignments(xa, ya, za);
            if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
                this.m_yaxis.setHashOffsetInUpDir(-xAxisLen, 0.0, 0.0);
            }
            if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
                this.m_zaxis.setHashOffsetInNormalDir(-xAxisLen, 0.0, 0.0);
            }
            this.setHashingsForUninvolvedAxes(0, -2, -1);
        } else {
            this.m_xaxis.setOrigin(new PdVector(0.0, this.m_bndBox[1].getEntry(1), this.m_bndBox[0].getEntry(2)));
            this.m_yaxis.setOrigin(new PdVector(this.m_bndBox[1].getEntry(0), 0.0, this.m_bndBox[0].getEntry(2)));
            this.m_zaxis.setOrigin(new PdVector(this.m_bndBox[1].getEntry(0), this.m_bndBox[1].getEntry(1), 0.0));
            int[] nArray = new int[4];
            nArray[1] = 1;
            nArray[2] = -7;
            nArray[3] = 3;
            int[] xa = nArray;
            int[] nArray6 = new int[4];
            nArray6[2] = 7;
            nArray6[3] = 3;
            int[] ya = nArray6;
            int[] nArray7 = new int[4];
            nArray7[0] = 1;
            nArray7[2] = -3;
            nArray7[3] = -7;
            int[] za = nArray7;
            this.setTitleAlignments(xa, ya, za);
            if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
                this.m_xaxis.setHashOffsetInNormalDir(0.0, -yAxisLen, 0.0);
                this.m_yaxis.setHashOffsetInUpDir(-xAxisLen, 0.0, 0.0);
            }
            if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
                this.m_zaxis.setHashOffsetInNormalDir(-xAxisLen, 0.0, 0.0);
            }
            if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
                this.m_zaxis.setHashOffsetInUpDir(0.0, -yAxisLen, 0.0);
            }
            this.setHashingsForUninvolvedAxes(-1, -2, -2);
        }
    }

    public void init() {
        super.init();
        int i = 0;
        while (i < this.m_showHashingFlags.length) {
            this.m_showHashingFlags[i] = false;
            ++i;
        }
        this.setMode(2);
        this.m_scale = 5.0;
        this.m_bAutoConfigure = true;
        this.m_xaxis.init();
        this.m_yaxis.init();
        this.m_zaxis.init();
        this.m_xaxis.setHashLabel(0, 3, 1, 2);
        this.m_yaxis.setHashLabel(0, 3, 1, 2);
        this.m_zaxis.setHashLabel(-5, 0, 2, 1);
        this.setTitles(this.m_defAxisLabel);
        this.showTitles(true);
        this.setFixedHashings(1.0, 0.5);
        this.m_majorHashUnits.init();
        this.m_minorHashUnits.init();
        this.m_numMajorHashings.init();
        this.m_numMinorHashings.init();
        this.m_majorHashUnits.setValue(this.m_xaxis.getMajorUnit());
        this.m_minorHashUnits.setValue(this.m_xaxis.getMinorUnit());
        this.m_numMajorHashings.setValue(this.m_xaxis.getNumMajorPartitions());
        this.m_numMinorHashings.setValue(this.m_xaxis.getNumMinorPartitions());
        this.m_majorHashUnits.setBounds(0.1, 60.0, 0.1, 1.0);
        this.m_minorHashUnits.setBounds(0.1, 30.0, 0.1, 1.0);
        this.m_numMajorHashings.setBounds(0, 60, 1, 2);
        this.m_numMinorHashings.setBounds(0, 30, 1, 2);
        this.m_bFixedMode = this.m_xaxis.isShowingFixedMode();
        this.m_bShowAllMajors = this.m_xaxis.isShowingMajorHashings();
        this.m_bShowAllMinors = this.m_xaxis.isShowingMinorHashings();
        this.m_bShowLabels = this.m_xaxis.isShowingLabels();
        this.m_bShowTitles = this.m_xaxis.isShowingRulerName();
    }

    public void configure(PdVector[] bndBox, PdVector viewDir) {
        double optNum;
        PdVector.copy(this.m_bndBox, 0, bndBox, 0, 2);
        this.m_viewVect.copy(viewDir);
        if (!this.m_bAutoConfigure) {
            return;
        }
        double nzm = this.nonZeroMax(this.m_bndBox[1].getEntry(0) - this.m_bndBox[0].getEntry(0), this.m_bndBox[1].getEntry(1) - this.m_bndBox[0].getEntry(1), this.m_bndBox[1].getEntry(2) - this.m_bndBox[0].getEntry(2));
        if (nzm > 4.0 * (optNum = 8.0) * this.m_scale) {
            do {
                this.m_scale *= 5.0;
            } while (nzm > 4.0 * optNum * this.m_scale && this.m_scale < 1000000.0);
            this.m_majorHashUnits.setBounds(0.1, 2.0 * nzm);
            this.m_minorHashUnits.setBounds(0.1, 2.0 * nzm);
            this.setFixedHashings(this.m_scale, this.m_scale / 2.0);
        }
        if (nzm < optNum / 2.0 * this.m_scale) {
            do {
                this.m_scale /= 5.0;
            } while (nzm < optNum / 2.0 * this.m_scale && this.m_scale > 1.0E-4);
            this.m_majorHashUnits.setBounds(nzm / 100.0, 2.0 * nzm);
            this.m_minorHashUnits.setBounds(nzm / 300.0, 2.0 * nzm);
            this.setFixedHashings(this.m_scale, this.m_scale / 2.0);
        }
    }
}

