/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Date;
import java.util.Vector;
import jv.loader.PvDisplayOption;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgMathLoader {
    protected int m_dim = 0;
    protected PdVector[] m_circle;
    protected PdVector[] m_disk;
    protected boolean m_isKeyAnimation = false;
    protected boolean m_isAnimation = false;
    protected PgJvxSrc[] m_geom;
    protected PgJvxSrc[][] m_graphics;
    protected Vector graphicsVector;
    protected int m_numGraphics = 0;
    protected PvDisplayOption m_displayOption;
    protected PdVector m_boundingBoxMin;
    protected PdVector m_boundingBoxMax;
    protected PdVector m_viewVertical;
    protected static final int COLOR_FACE_FRONT = 0;
    protected static final int COLOR_FACE_BACK = 1;
    protected static final int COLOR_FACE_FRONT_REFL = 2;
    protected static final int COLOR_FACE_BACK_REFL = 3;
    protected static final int COLOR_FACE_FRONT_NOLIGHTS = 4;
    protected static final int COLOR_FACE_BACK_NOLIGHTS = 5;
    protected static final int COLOR_ELEMENT_EDGE = 6;
    protected static final int COLOR_POINT = 7;
    protected static final int COLOR_POLYGON = 8;

    public boolean isKeyAnimation() {
        return this.m_isKeyAnimation;
    }

    public PgJvxSrc[][] read(BufferedReader in) {
        if (in == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        this.graphicsVector = new Vector();
        try {
            boolean check = this.parseMath(in);
            if (!check) {
                PsDebug.warning("error during parsing of reader");
                return null;
            }
            if (this.m_numGraphics == 0) {
                PsDebug.warning("missing graphics");
                return null;
            }
        }
        catch (IOException e) {
            PsDebug.warning("exception during parsing of reader");
            e.printStackTrace();
            return null;
        }
        this.m_graphics = new PgJvxSrc[this.m_numGraphics][];
        int i = 0;
        while (i < this.m_numGraphics) {
            this.m_graphics[i] = (PgJvxSrc[])this.graphicsVector.elementAt(i);
            ++i;
        }
        this.m_boundingBoxMin = new PdVector(3);
        this.m_boundingBoxMax = new PdVector(3);
        PdVector vertex = this.m_graphics[0][0].getVertex(0);
        if (vertex.getSize() != 3) {
            this.m_boundingBoxMin.setConstant(0.0);
            this.m_boundingBoxMax.setConstant(0.0);
        } else {
            this.m_boundingBoxMin.copy(vertex);
            this.m_boundingBoxMax.copy(vertex);
        }
        this.m_dim = 0;
        int i2 = 0;
        while (i2 < this.m_numGraphics) {
            int numGeometries = this.m_graphics[i2].length;
            int j = 0;
            while (j < numGeometries) {
                PdVector[] vertices = this.m_graphics[i2][j].getVertices();
                int nov = this.m_graphics[i2][j].getNumVertices();
                int dim = this.m_graphics[i2][j].getDimOfVertices();
                if (dim > this.m_dim) {
                    this.m_dim = dim;
                }
                int k = 0;
                while (k < nov) {
                    if (vertices[k].m_data[0] < this.m_boundingBoxMin.m_data[0]) {
                        this.m_boundingBoxMin.m_data[0] = vertices[k].m_data[0];
                    }
                    if (vertices[k].m_data[0] > this.m_boundingBoxMax.m_data[0]) {
                        this.m_boundingBoxMax.m_data[0] = vertices[k].m_data[0];
                    }
                    if (dim > 1) {
                        if (vertices[k].m_data[1] < this.m_boundingBoxMin.m_data[1]) {
                            this.m_boundingBoxMin.m_data[1] = vertices[k].m_data[1];
                        }
                        if (vertices[k].m_data[1] > this.m_boundingBoxMax.m_data[1]) {
                            this.m_boundingBoxMax.m_data[1] = vertices[k].m_data[1];
                        }
                    }
                    if (dim > 2) {
                        if (vertices[k].m_data[2] < this.m_boundingBoxMin.m_data[2]) {
                            this.m_boundingBoxMin.m_data[2] = vertices[k].m_data[2];
                        }
                        if (vertices[k].m_data[2] > this.m_boundingBoxMax.m_data[2]) {
                            this.m_boundingBoxMax.m_data[2] = vertices[k].m_data[2];
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        if (this.m_dim == 3) {
            this.adjustViewer();
        } else {
            this.m_displayOption.setCameraProjection(0, 1);
            PdVector v = new PdVector((this.m_boundingBoxMin.m_data[0] + this.m_boundingBoxMax.m_data[0]) / 2.0, (this.m_boundingBoxMin.m_data[1] + this.m_boundingBoxMax.m_data[1]) / 2.0, 0.0);
            this.m_displayOption.setCameraInterest(0, v);
            PdVector boxSize = PdVector.subNew(this.m_boundingBoxMax, this.m_boundingBoxMin);
            double max = boxSize.max();
            v = new PdVector((this.m_boundingBoxMax.m_data[0] + this.m_boundingBoxMin.m_data[0]) / 2.0, (this.m_boundingBoxMax.m_data[1] + this.m_boundingBoxMin.m_data[1]) / 2.0, max);
            this.m_displayOption.setCameraPosition(0, v);
            this.m_displayOption.setCameraRoll(0, 0.0);
            this.m_displayOption.setCurrentCamera(1);
            this.m_displayOption.clearTag(8);
        }
        int numGeom = 0;
        int i3 = 0;
        while (i3 < this.m_numGraphics) {
            int numGeometries = this.m_graphics[i3].length;
            int j = 0;
            while (j < numGeometries) {
                ++numGeom;
                PgJvxSrc geom = this.m_graphics[i3][j];
                if (geom.getType() == 33 && geom.getDimOfVertices() == 3) {
                    this.computeMathematicaColors(geom);
                }
                ++j;
            }
            ++i3;
        }
        if (!this.isAnimation() && !this.isKeyAnimation() && this.m_graphics.length > 1) {
            PgJvxSrc[][] allGraphics = new PgJvxSrc[][]{new PgJvxSrc[numGeom]};
            int currentGeom = 0;
            int i4 = 0;
            while (i4 < this.m_numGraphics) {
                int numGeometries = this.m_graphics[i4].length;
                int j = 0;
                while (j < numGeometries) {
                    allGraphics[0][currentGeom] = this.m_graphics[i4][j];
                    ++currentGeom;
                    ++j;
                }
                ++i4;
            }
            this.m_graphics = allGraphics;
        }
        return this.m_graphics;
    }

    public void setAnimation(boolean flag) {
        this.m_isAnimation = flag;
    }

    public PvDisplayOption getDisplayOption() {
        return this.m_displayOption;
    }

    public boolean write(Writer writer, PgJvxSrc[] geomArr) throws IOException {
        String ver;
        int j;
        int len;
        int i;
        int numOfPolygons;
        if (geomArr == null || geomArr.length == 0 || geomArr[0] == null) {
            PsDebug.warning("missing geometry");
            return false;
        }
        PgJvxSrc geom = geomArr[0];
        writer.write("(* Produced with JavaView v." + PsConfig.getVersion() + " by " + PsConfig.getAuthors() + "\n");
        writer.write("     File Format = Mathematica Graphics MGS\n");
        writer.write("     Geometry    = " + geom.getName() + "\n");
        writer.write("     Date        = " + new Date().toString() + "\n//\n");
        int numOfVertices = geom.getNumVertices();
        writer.write("     Number of Vertices = " + numOfVertices + "\n");
        int numOfElements = geom.getNumElements();
        if (numOfElements > 0) {
            writer.write("     Number of Elements = " + numOfElements + "\n");
        }
        if ((numOfPolygons = geom.getNumPolygons()) > 0) {
            writer.write("     Number of Polygons = " + numOfPolygons + "\n");
        }
        writer.write("\n End of Header *)\n");
        writer.write("Graphics3D[{");
        PdVector[] vertex = geom.getVertices();
        String col = null;
        Color[] color = null;
        boolean bPrevData = false;
        if (numOfPolygons > 0) {
            bPrevData = true;
            if (!geom.isShowingPolygonColors()) {
                col = PgMathLoader.writeColor(geom.getGlobalPolygonColor());
                writer.write(col + ",");
            } else {
                color = geom.getPolygonColors();
            }
            PiVector[] polygon = geom.getPolygons();
            i = 0;
            while (i < numOfPolygons) {
                if (geom.isShowingPolygonColors()) {
                    col = PgMathLoader.writeColor(color[i]);
                    writer.write("{" + col + ",");
                }
                writer.write("Line[{");
                len = polygon[i].getSize();
                j = 0;
                while (j < len) {
                    if (j > 0) {
                        writer.write(", ");
                    }
                    ver = PgMathLoader.writeVertex(vertex[polygon[i].m_data[j]]);
                    writer.write(ver);
                    ++j;
                }
                writer.write("}]");
                if (geom.isShowingPolygonColors()) {
                    writer.write("}");
                }
                if (i < numOfPolygons - 1) {
                    writer.write(",");
                }
                writer.write("\n");
                ++i;
            }
        } else if (numOfElements > 0) {
            bPrevData = true;
            if (!geom.isShowingEdges()) {
                writer.write("EdgeForm[],");
            }
            if (!geom.isShowingElementColors()) {
                col = PgMathLoader.writeColor(geom.getGlobalElementColor());
                writer.write("SurfaceColor[" + col + "],");
            } else {
                color = geom.getElementColors();
            }
            PiVector[] element = geom.getElements();
            i = 0;
            while (i < numOfElements) {
                if (geom.isShowingElementColors()) {
                    col = PgMathLoader.writeColor(color[i]);
                    writer.write("{" + col + ",");
                }
                writer.write("Polygon[{");
                len = element[i].getSize();
                j = 0;
                while (j < len) {
                    if (j > 0) {
                        writer.write(", ");
                    }
                    ver = PgMathLoader.writeVertex(vertex[element[i].m_data[j]]);
                    writer.write(ver);
                    ++j;
                }
                writer.write("}]");
                if (geom.isShowingElementColors()) {
                    writer.write("}");
                }
                if (i < numOfElements - 1) {
                    writer.write(",");
                }
                writer.write("\n");
                ++i;
            }
        }
        if (numOfVertices > 0 && geom.isShowingVertices()) {
            if (bPrevData) {
                writer.write(",\n");
            }
            int i2 = 0;
            while (i2 < numOfVertices) {
                writer.write("Point[");
                String ver2 = PgMathLoader.writeVertex(vertex[i2]);
                writer.write(ver2);
                writer.write("]");
                if (i2 < numOfVertices - 1) {
                    writer.write(",");
                }
                writer.write("\n");
                ++i2;
            }
        }
        writer.write("}]\n");
        return true;
    }

    private Color readRGBColor(StreamTokenizer st) {
        PdVector col = new PdVector();
        if (this.parseVector(st, col, 3)) {
            return new Color((float)col.m_data[0], (float)col.m_data[1], (float)col.m_data[2]);
        }
        return new Color(1.0f, 0.0f, 0.0f);
    }

    private int readSurfaceColor(StreamTokenizer st, Color[] c) {
        try {
            st.nextToken();
            st.nextToken();
            int exponent = 1;
            c[0] = this.readColor(st);
            c[1] = c[0];
            st.nextToken();
            if (st.ttype == 44) {
                st.nextToken();
                c[1] = this.readColor(st);
                st.nextToken();
                if (st.ttype == 44) {
                    exponent = (int)this.readNumber(st);
                    st.nextToken();
                }
            }
            return exponent;
        }
        catch (Exception e) {
            PsDebug.warning("Exception thrown: " + e + " Line: " + st.lineno());
            return 1;
        }
    }

    private static String writeColor(Color col) {
        if (col == null) {
            PsDebug.warning("missing color");
            return null;
        }
        StringBuffer tmp = new StringBuffer("RGBColor[");
        tmp.append(String.valueOf((double)col.getRed() / 255.0) + ", " + String.valueOf((double)col.getGreen() / 255.0) + ", " + String.valueOf((double)col.getBlue() / 255.0) + "]");
        return tmp.toString();
    }

    private Color readColor(StreamTokenizer st) {
        if (st.ttype != -3 || !"CMYKColor".equals(st.sval) && !"GrayLevel".equals(st.sval) && !"Hue".equals(st.sval) && !"RGBColor".equals(st.sval)) {
            PsDebug.warning("'CMYKColor', 'GrayLevel', 'Hue' or 'RGBColor' expected in line " + st.lineno());
        }
        if ("RGBColor".equals(st.sval)) {
            return this.readRGBColor(st);
        }
        if ("GrayLevel".equals(st.sval)) {
            return this.readGrayLevel(st);
        }
        if ("Hue".equals(st.sval)) {
            return this.readHueColor(st);
        }
        if ("CMYKColor".equals(st.sval)) {
            return this.readGrayLevel(st);
        }
        return Color.white;
    }

    private void setDisplayDefault() {
        this.m_displayOption.clearTag(3);
        this.m_displayOption.clearTag(4);
        this.m_displayOption.setTag(8);
        this.m_displayOption.clearTag(11);
        this.m_displayOption.setTag(17);
        this.m_displayOption.setNumLights(3);
        this.m_displayOption.setLightColor(0, Color.red);
        this.m_displayOption.setLightPosition(0, new PdVector(1.0, 0.0, 1.0));
        this.m_displayOption.setLightType(0, 1);
        this.m_displayOption.setLightColor(1, Color.green);
        this.m_displayOption.setLightPosition(1, new PdVector(1.0, 1.0, 1.0));
        this.m_displayOption.setLightType(1, 1);
        this.m_displayOption.setLightColor(2, Color.blue);
        this.m_displayOption.setLightPosition(2, new PdVector(0.0, 1.0, 1.0));
        this.m_displayOption.setLightType(2, 1);
        this.m_displayOption.setAmbientLight(Color.black);
        this.m_displayOption.setNumCameras(1);
        this.m_displayOption.setCameraPosition(0, new PdVector(1.3, -2.4, 2.0));
        this.m_displayOption.setCameraProjection(0, 0);
        PdVector interest = new PdVector(3);
        interest.setConstant(0.5);
        this.m_displayOption.setCameraInterest(0, interest);
        this.m_displayOption.setEnabledCameraClip(0, false);
        this.m_displayOption.setCameraFieldOfView(0, 53.13);
        this.m_displayOption.setCameraAngle(0, 1.0);
        this.m_displayOption.setCameraRoll(0, 0.0);
        this.m_displayOption.setCurrentCamera(0);
        this.m_displayOption.setCameraAmbient(0, 0);
        this.m_displayOption.setCameraNearClip(0, 0.0);
        this.m_displayOption.setCameraFarClip(0, 0.0);
        this.m_displayOption.setCameraPerspective(0, 0);
        this.m_displayOption.setEnabledCameraTransform(0, false);
        this.m_viewVertical = new PdVector(0.0, 0.0, 1.0);
        PiVector axesEdge = new PiVector(6);
        axesEdge.setConstant(0);
        this.m_displayOption.setAxesEdge(axesEdge);
    }

    private double readNumber(StreamTokenizer st) {
        try {
            st.nextToken();
            if (st.ttype != -2) {
                PsDebug.warning("Number expected Line: " + st.lineno());
            }
            double value = st.nval;
            st.ordinaryChar(69);
            st.ordinaryChar(101);
            st.nextToken();
            if (st.ttype == 42) {
                st.nextToken();
                if (st.ttype == 94) {
                    st.nextToken();
                    if (st.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + st.lineno());
                        st.wordChars(69, 69);
                        st.wordChars(101, 101);
                        return value;
                    }
                    PsDebug.warning("Not formated number found - Please use FormatGraphics.");
                    value *= Math.pow(10.0, st.nval);
                }
            } else if (st.ttype == 69 || st.ttype == 101) {
                st.nextToken();
                if (st.ttype != -2) {
                    PsDebug.warning("Number expected Line: " + st.lineno());
                    st.wordChars(69, 69);
                    st.wordChars(101, 101);
                    return value;
                }
                value *= Math.pow(10.0, st.nval);
            } else {
                st.pushBack();
            }
            st.wordChars(69, 69);
            st.wordChars(101, 101);
            return value;
        }
        catch (Exception e) {
            PsDebug.warning("Exception thrown: " + e + " Line: " + st.lineno());
            st.wordChars(69, 69);
            st.wordChars(101, 101);
            return 0.0;
        }
    }

    private static String writeVertex(PdVector v) {
        if (v == null) {
            PsDebug.warning("missing vertex");
            return null;
        }
        int len = v.getSize();
        if (len < 2) {
            PsDebug.warning("dimension of vertex smaller than 2, return emtpy string.");
            return "";
        }
        if (len > 3) {
            PsDebug.warning("dimension of vertex larger than 3, truncated.");
            len = 3;
        }
        StringBuffer tmp = new StringBuffer("{" + String.valueOf(v.m_data[0]));
        int j = 1;
        while (j < len) {
            tmp.append(", ");
            if (Math.abs(v.m_data[j]) > 1.0E-10) {
                tmp.append((float)v.m_data[j]);
            } else {
                tmp.append(0.0f);
            }
            ++j;
        }
        tmp.append("}");
        return tmp.toString();
    }

    public boolean isAnimation() {
        return this.m_isAnimation;
    }

    private static void geomInitType(PgJvxSrc geom) {
        switch (geom.getType()) {
            case 30: {
                geom.showVertices(true);
                break;
            }
            case 33: {
                geom.assureNeighbours();
                geom.showEdges(true);
                geom.setGlobalElementBackColor(Color.white);
                geom.setGlobalElementColor(Color.white);
                geom.showElements(true);
                break;
            }
            case 32: {
                geom.showVertices(true);
                geom.showPolygons(true);
                geom.showEdges(true);
                break;
            }
            case 36: {
                geom.showVertices(false);
                break;
            }
        }
    }

    private boolean readParametricSurface(StreamTokenizer st) {
        try {
            int numEl;
            int i;
            st.nextToken();
            st.nextToken();
            Vector<PdVector> vertexVector = new Vector<PdVector>();
            Vector[] geomColor = new Vector[4];
            int i2 = 0;
            while (i2 <= 3) {
                geomColor[i2] = new Vector();
                ++i2;
            }
            PiVector faceReflExp = new PiVector();
            PiVector backFaceReflExp = new PiVector();
            Color edgeColor = new Color(0, 0, 0);
            double edgeThickness = 1.0;
            boolean faceColorsDefined = false;
            boolean edgeColorDefined = false;
            boolean showEdges = true;
            boolean showElements = true;
            boolean showElementColors = true;
            int numULines = 0;
            int numVLines = 0;
            double xMin = 0.0;
            double xMax = 0.0;
            double yMin = 0.0;
            double yMax = 0.0;
            while (st.ttype != 125) {
                st.nextToken();
                ++numVLines;
                int uLinesOld = numULines;
                numULines = 0;
                while (st.ttype != 125) {
                    ++numULines;
                    if (this.m_dim == 3) {
                        PdVector v = new PdVector(3);
                        v.m_data[2] = this.readNumber(st);
                        vertexVector.addElement(v);
                    } else if (this.m_dim == 2) {
                        double c = this.readNumber(st);
                        faceColorsDefined = true;
                        i = 0;
                        while (i <= 3) {
                            geomColor[i].addElement(new PdVector(c));
                            ++i;
                        }
                    }
                    st.nextToken();
                }
                if (numVLines > 1 && uLinesOld != numULines) {
                    PsDebug.warning("Number of U-Lines not constant - V-Line: " + numVLines + " Line: " + st.lineno());
                    return false;
                }
                st.nextToken();
            }
            st.nextToken();
            int numOpenBrackets = 1;
            while (numOpenBrackets != 0) {
                if (st.ttype == -1) {
                    PsDebug.warning("PgMathLoader.readElementSet: ']' missing Line: " + st.lineno());
                    return false;
                }
                if (st.ttype == 93) {
                    --numOpenBrackets;
                }
                if (st.ttype == 91) {
                    ++numOpenBrackets;
                }
                if (st.ttype == -3 && !this.readOptions(st)) {
                    if ("AxesLabel".equals(st.sval)) {
                        this.readAxesLabel(st, this.m_dim);
                    } else if ("Mesh".equals(st.sval)) {
                        st.nextToken();
                        st.nextToken();
                        st.nextToken();
                        showEdges = "True".equals(st.sval);
                    } else if ("RGBColor".equals(st.sval) || "Hue".equals(st.sval) || "GrayLevel".equals(st.sval)) {
                        faceColorsDefined = true;
                        Color col = this.readColor(st);
                        i = 0;
                        while (i <= 3) {
                            geomColor[i].addElement(col);
                            ++i;
                        }
                        faceReflExp.addEntry(1);
                        backFaceReflExp.addEntry(1);
                    } else if ("SurfaceColor".equals(st.sval)) {
                        faceColorsDefined = true;
                        Color[] c = new Color[2];
                        int exp = this.readSurfaceColor(st, c);
                        faceReflExp.addEntry(exp);
                        backFaceReflExp.addEntry(exp);
                        int i3 = 0;
                        while (i3 <= 1) {
                            geomColor[i3].addElement(c[0]);
                            ++i3;
                        }
                        i3 = 2;
                        while (i3 <= 3) {
                            geomColor[i3].addElement(c[1]);
                            ++i3;
                        }
                    } else if ("FaceForm".equals(st.sval)) {
                        Color col;
                        Color[] c;
                        st.nextToken();
                        st.nextToken();
                        if (!(st.ttype == -3 && ("CMYKColor".equals(st.sval) || "GrayLevel".equals(st.sval) || "Hue".equals(st.sval) || "RGBColor".equals(st.sval) || "SurfaceColor".equals(st.sval)))) {
                            PsDebug.warning("'CMYKColor', 'GrayLevel', 'Hue', 'RGBColor' or 'SurfaceColor' expected in line " + st.lineno());
                        }
                        faceColorsDefined = true;
                        if ("SurfaceColor".equals(st.sval)) {
                            c = new Color[2];
                            faceReflExp.addEntry(this.readSurfaceColor(st, c));
                            geomColor[0].addElement(c[0]);
                            geomColor[2].addElement(c[1]);
                        } else {
                            col = this.readColor(st);
                            geomColor[0].addElement(col);
                            geomColor[2].addElement(col);
                            faceReflExp.addEntry(1);
                        }
                        st.nextToken();
                        if (st.ttype == 44) {
                            st.nextToken();
                            if (!(st.ttype == -3 && ("CMYKColor".equals(st.sval) || "GrayLevel".equals(st.sval) || "Hue".equals(st.sval) || "RGBColor".equals(st.sval) || "SurfaceColor".equals(st.sval)))) {
                                PsDebug.warning("'CMYKColor', 'GrayLevel', 'Hue', 'RGBColor' or 'SurfaceColor' expected in line " + st.lineno());
                            }
                            if ("SurfaceColor".equals(st.sval)) {
                                c = new Color[2];
                                backFaceReflExp.addEntry(this.readSurfaceColor(st, c));
                                geomColor[1].addElement(c[0]);
                                geomColor[3].addElement(c[1]);
                            } else {
                                col = this.readColor(st);
                                geomColor[1].addElement(col);
                                geomColor[3].addElement(col);
                                backFaceReflExp.addEntry(1);
                            }
                            st.nextToken();
                        } else {
                            int nc = geomColor[0].size() - 1;
                            geomColor[1].addElement(geomColor[0].elementAt(nc));
                            geomColor[3].addElement(geomColor[2].elementAt(nc));
                            backFaceReflExp.addEntry(faceReflExp.m_data[nc]);
                        }
                    } else if ("EdgeForm".equals(st.sval)) {
                        st.nextToken();
                        st.nextToken();
                        if (st.ttype == 93) {
                            showEdges = false;
                        }
                        while (st.ttype != 93) {
                            if (st.ttype != -3) continue;
                            if ("RGBColor".equals(st.sval) || "CMYKColor".equals(st.sval) || "Hue".equals(st.sval) || "GrayLevel".equals(st.sval)) {
                                edgeColorDefined = true;
                                edgeColor = this.readColor(st);
                            }
                            if (!"Thickness".equals(st.sval)) continue;
                            st.nextToken();
                            edgeThickness = 200.0 * this.readNumber(st);
                            st.nextToken();
                        }
                    } else if ("MeshRange".equals(st.sval)) {
                        st.nextToken();
                        st.nextToken();
                        st.parseNumbers();
                        st.nextToken();
                        st.nextToken();
                        xMin = this.readNumber(st);
                        st.nextToken();
                        xMax = this.readNumber(st);
                        st.nextToken();
                        st.nextToken();
                        st.nextToken();
                        yMin = this.readNumber(st);
                        st.nextToken();
                        yMax = this.readNumber(st);
                        st.nextToken();
                        st.nextToken();
                    } else if ("HiddenSurface".equals(st.sval)) {
                        st.nextToken();
                        st.nextToken();
                        st.nextToken();
                        showElements = "True".equals(st.sval);
                    } else if ("Shading".equals(st.sval)) {
                        st.nextToken();
                        st.nextToken();
                        st.nextToken();
                        showElementColors = "True".equals(st.sval);
                    }
                }
                st.ordinaryChar(45);
                st.nextToken();
            }
            if (this.m_dim == 2) {
                ++numULines;
                ++numVLines;
                int i4 = 0;
                while (i4 < numULines * numVLines) {
                    vertexVector.addElement(new PdVector(2));
                    ++i4;
                }
            }
            double dx = (xMax - xMin) / (double)(numULines - 1);
            double dy = (yMax - yMin) / (double)(numVLines - 1);
            int n = 0;
            PgJvxSrc surface = new PgJvxSrc();
            surface.setType(33);
            surface.setNumVertices(numULines * numVLines);
            PdVector[] vertex = surface.getVertices();
            int i5 = 0;
            while (i5 < numVLines) {
                int j = 0;
                while (j < numULines) {
                    vertex[i5 * numULines + j].copy((PdVector)vertexVector.elementAt(n));
                    vertex[i5 * numULines + j].m_data[0] = xMin + (double)j * dx;
                    vertex[i5 * numULines + j].m_data[1] = yMin + (double)i5 * dy;
                    ++n;
                    ++j;
                }
                ++i5;
            }
            surface.setDimOfElements(4);
            surface.setNumElements((numULines - 1) * (numVLines - 1));
            PiVector[] element = surface.getElements();
            PiVector[] neighbour = surface.getNeighbours();
            int ind = 0;
            int i6 = 0;
            while (i6 < numVLines - 1) {
                int j = 0;
                while (j < numULines - 1) {
                    element[ind].m_data[0] = i6 * numULines + j;
                    element[ind].m_data[1] = (i6 + 1) * numULines + j;
                    element[ind].m_data[2] = (i6 + 1) * numULines + j + 1;
                    element[ind].m_data[3] = i6 * numULines + j + 1;
                    if (i6 < numVLines - 2) {
                        neighbour[ind].m_data[0] = ind + numULines - 1;
                    }
                    if (j < numULines - 2) {
                        neighbour[ind].m_data[1] = ind + 1;
                    }
                    if (i6 > 0) {
                        neighbour[ind].m_data[2] = ind - numULines + 1;
                    }
                    if (j > 0) {
                        neighbour[ind].m_data[3] = ind - 1;
                    }
                    ++ind;
                    ++j;
                }
                ++i6;
            }
            PgMathLoader.geomInitType(surface);
            surface.showEdges(showEdges);
            if (this.m_dim == 3) {
                surface.showElements(showElements);
                surface.showElementColors(showElementColors);
                surface.showElementBackColors(showElementColors);
                numEl = (numULines - 1) * (numVLines - 1);
                Color[][] elColor = new Color[4][];
                int i7 = 0;
                while (i7 <= 3) {
                    elColor[i7] = new Color[numEl];
                    ++i7;
                }
                if (faceColorsDefined) {
                    if (geomColor[0].size() == numEl) {
                        i7 = 0;
                        while (i7 < numEl) {
                            int j = 0;
                            while (j <= 3) {
                                elColor[j][i7] = (Color)geomColor[j].elementAt(i7);
                                ++j;
                            }
                            ++i7;
                        }
                        surface.setElementColors(elColor[0]);
                        surface.setElementBackColors(elColor[1]);
                    } else {
                        int j = 0;
                        while (j <= 3) {
                            Color col = (Color)geomColor[j].elementAt(0);
                            int i8 = 0;
                            while (i8 < numEl) {
                                elColor[j][i8] = col;
                                ++i8;
                            }
                            ++j;
                        }
                        surface.setElementColors(elColor[0]);
                        surface.setElementBackColors(elColor[1]);
                    }
                } else {
                    i7 = 0;
                    while (i7 < numEl) {
                        int j = 0;
                        while (j <= 3) {
                            elColor[j][i7] = Color.white;
                            ++j;
                        }
                        ++i7;
                    }
                    surface.setElementColors(elColor[0]);
                    surface.setElementBackColors(elColor[1]);
                }
                if (edgeColorDefined) {
                    surface.setGlobalEdgeColor(edgeColor);
                }
            } else if (this.m_dim == 2) {
                surface.setDimOfVertices(2);
                surface.showElements(showElements);
                surface.showElementColors(showElementColors);
                surface.showElementBackColors(showElementColors);
                numEl = (numULines - 1) * (numVLines - 1);
                Color[] elColor = new Color[numEl];
                if (faceColorsDefined) {
                    if (geomColor[0].size() == numEl) {
                        double val;
                        double min = ((PdVector)geomColor[0].elementAt((int)0)).m_data[0];
                        double max = ((PdVector)geomColor[0].elementAt((int)0)).m_data[0];
                        int i9 = 0;
                        while (i9 < numEl) {
                            val = ((PdVector)geomColor[0].elementAt((int)i9)).m_data[0];
                            if (val > max) {
                                max = val;
                            }
                            if (val < min) {
                                min = val;
                            }
                            ++i9;
                        }
                        if (min == max) {
                            max += 1.0;
                        }
                        i9 = 0;
                        while (i9 < numEl) {
                            val = ((PdVector)geomColor[0].elementAt((int)i9)).m_data[0];
                            val = (val - min) / (max - min);
                            elColor[i9] = new Color((float)val, (float)val, (float)val);
                            ++i9;
                        }
                        surface.setElementColors(elColor);
                        surface.setElementBackColors(elColor);
                    } else {
                        int i10 = 0;
                        while (i10 < numEl) {
                            elColor[i10] = Color.gray;
                            ++i10;
                        }
                        surface.setElementColors(elColor);
                        surface.setElementBackColors(elColor);
                    }
                } else {
                    int i11 = 0;
                    while (i11 < numEl) {
                        elColor[i11] = Color.gray;
                        ++i11;
                    }
                    surface.setElementColors(elColor);
                    surface.setElementBackColors(elColor);
                }
                if (edgeColorDefined) {
                    surface.setGlobalEdgeColor(edgeColor);
                }
            }
            if (!this.m_displayOption.hasTag(17) && this.m_dim == 3) {
                int noe = surface.getNumElements();
                Color[] colors = new Color[noe];
                Color[] backColors = new Color[noe];
                double zMin = vertex[0].m_data[2];
                double zMax = vertex[0].m_data[2];
                int i12 = 0;
                while (i12 < numULines * numVLines) {
                    if (vertex[i12].m_data[2] > zMax) {
                        zMax = vertex[i12].m_data[2];
                    }
                    if (vertex[i12].m_data[2] < zMin) {
                        zMin = vertex[i12].m_data[2];
                    }
                    ++i12;
                }
                double d = zMax - zMin;
                PiVector[] elements = surface.getElements();
                PdVector[] vertices = surface.getVertices();
                int i13 = 0;
                while (i13 < noe) {
                    PiVector el = elements[i13];
                    int elSize = el.getSize();
                    double h = 0.0;
                    int j = 0;
                    while (j < elSize) {
                        h += vertices[el.m_data[j]].m_data[2];
                        ++j;
                    }
                    double gray = ((h /= (double)elSize) - zMin) / d;
                    colors[i13] = new Color((float)gray, (float)gray, (float)gray);
                    backColors[i13] = colors[i13];
                    ++i13;
                }
                surface.setElementColors(colors);
                surface.setElementBackColors(backColors);
            }
            surface.setGlobalEdgeSize(edgeThickness);
            this.m_geom = new PgJvxSrc[1];
            this.m_geom[0] = surface;
            this.graphicsVector.addElement(this.m_geom);
            st.parseNumbers();
            st.pushBack();
            return true;
        }
        catch (Exception e) {
            PsDebug.warning("Exception thrown: " + e + " Line: " + st.lineno());
            return false;
        }
    }

    private void adjustViewer() {
        PdVector interest = this.m_displayOption.getCameraInterest(0);
        PdVector position = this.m_displayOption.getCameraPosition(0);
        PdVector boxSize = PdVector.subNew(this.m_boundingBoxMax, this.m_boundingBoxMin);
        int i = 0;
        while (i < 3) {
            int n = i;
            this.m_viewVertical.m_data[n] = this.m_viewVertical.m_data[n] * boxSize.m_data[i];
            double f = interest.m_data[i];
            interest.m_data[i] = (1.0 - f) * this.m_boundingBoxMin.m_data[i] + f * this.m_boundingBoxMax.m_data[i];
            int n2 = i++;
            boxSize.m_data[n2] = boxSize.m_data[n2] * (1.0 + 2.0 * Math.abs(0.5 - f));
        }
        position.normalize();
        position.multScalar(boxSize.length());
        position.add(interest);
        PdVector direction = PdVector.subNew(position, interest);
        double roll = -PdVector.angle(PdVector.crossNew(direction, this.m_viewVertical), PdVector.crossNew(direction, new PdVector(0.0, 0.0, 1.0)));
        this.m_displayOption.setCameraRoll(0, roll);
        int nol = this.m_displayOption.getNumLights();
        if (nol == 3 && PdVector.subNew(this.m_displayOption.getLightPosition(0), new PdVector(1.0, 0.0, 1.0)).length() == 0.0 && this.m_displayOption.getLightColor(0).getRGB() == -65536 && this.m_displayOption.getLightType(0) == 1 && PdVector.subNew(this.m_displayOption.getLightPosition(1), new PdVector(1.0, 1.0, 1.0)).length() == 0.0 && this.m_displayOption.getLightColor(1).getRGB() == -16711936 && this.m_displayOption.getLightType(1) == 1 && PdVector.subNew(this.m_displayOption.getLightPosition(2), new PdVector(0.0, 1.0, 1.0)).length() == 0.0 && this.m_displayOption.getLightColor(2).getRGB() == -16776961 && this.m_displayOption.getLightType(2) == 1 && this.m_displayOption.getAmbientLight().getRGB() == -16777216) {
            this.m_displayOption.setNumLights(5);
            nol = 5;
            this.m_displayOption.setLightColor(3, Color.gray);
            this.m_displayOption.setLightPosition(3, new PdVector(-1.0, -1.0, -1.0));
            this.m_displayOption.setLightType(3, 1);
            this.m_displayOption.setLightColor(4, Color.blue);
            this.m_displayOption.setLightPosition(4, new PdVector(0.0, 0.0, -1.0));
            this.m_displayOption.setLightType(4, 1);
        }
        int i2 = 0;
        while (i2 < nol) {
            if (this.m_displayOption.getLightType(i2) == 1) {
                PdVector oldPosition = this.m_displayOption.getLightPosition(i2);
                PdVector x = PdVector.crossNew(direction, this.m_viewVertical);
                if (!x.normalize() && !(x = PdVector.crossNew(direction, new PdVector(0.0, 1.0, 0.0))).normalize()) {
                    x = PdVector.crossNew(direction, new PdVector(0.0, 0.0, 1.0));
                    x.normalize();
                }
                PdVector y = PdVector.crossNew(direction, x);
                y.normalize();
                PdVector z = PdVector.copyNew(direction);
                z.normalize();
                PdVector position0 = PdVector.blendNew(-oldPosition.m_data[0], x, -oldPosition.m_data[1], y);
                PdVector newPosition = PdVector.blendNew(oldPosition.m_data[2], z, 1.0, position0);
                this.m_displayOption.setLightPosition(i2, newPosition);
            }
            ++i2;
        }
    }

    private boolean readOptions(StreamTokenizer st) {
        try {
            if ("Boxed".equals(st.sval)) {
                st.nextToken();
                st.nextToken();
                st.nextToken();
                if ("True".equals(st.sval)) {
                    this.m_displayOption.setTag(8);
                } else {
                    this.m_displayOption.clearTag(8);
                }
                return true;
            }
            if ("Axes".equals(st.sval)) {
                st.nextToken();
                st.nextToken();
                st.nextToken();
                if ("True".equals(st.sval) || "Automatic".equals(st.sval)) {
                    this.m_displayOption.setTag(3);
                } else {
                    this.m_displayOption.clearTag(3);
                }
                return true;
            }
            if ("Lighting".equals(st.sval)) {
                st.nextToken();
                st.nextToken();
                st.nextToken();
                if ("True".equals(st.sval)) {
                    this.m_displayOption.setTag(17);
                } else {
                    this.m_displayOption.clearTag(17);
                }
                return true;
            }
            if ("LightSources".equals(st.sval)) {
                st.nextToken();
                st.nextToken();
                st.parseNumbers();
                st.nextToken();
                st.nextToken();
                if (st.ttype == 125) {
                    this.m_displayOption.setNumLights(0);
                } else {
                    st.nextToken();
                    if (st.ttype == -2) {
                        PdVector[] points = new PdVector[1];
                        Color[] colors = new Color[1];
                        points[0] = new PdVector(3);
                        int i = 0;
                        while (i < 3) {
                            st.pushBack();
                            points[0].m_data[i] = this.readNumber(st);
                            st.nextToken();
                            st.nextToken();
                            ++i;
                        }
                        st.nextToken();
                        colors[0] = this.readColor(st);
                        st.nextToken();
                    } else {
                        Vector<PdVector> pts = new Vector<PdVector>();
                        Vector<Color> cls = new Vector<Color>();
                        while (st.ttype != 125) {
                            PdVector point = new PdVector(3);
                            int i = 0;
                            while (i < 3) {
                                point.m_data[i] = this.readNumber(st);
                                st.nextToken();
                                ++i;
                            }
                            st.nextToken();
                            st.nextToken();
                            Color color = this.readColor(st);
                            st.nextToken();
                            pts.addElement(point);
                            cls.addElement(color);
                            st.nextToken();
                            if (st.ttype != 44) continue;
                            st.nextToken();
                            st.nextToken();
                        }
                        PdVector[] points = new PdVector[pts.size()];
                        Color[] colors = new Color[cls.size()];
                        int numLights = pts.size();
                        this.m_displayOption.setNumLights(numLights);
                        int i = 0;
                        while (i < numLights) {
                            points[i] = (PdVector)pts.elementAt(i);
                            colors[i] = (Color)cls.elementAt(i);
                            this.m_displayOption.setLightColor(i, (Color)cls.elementAt(i));
                            this.m_displayOption.setLightPosition(i, (PdVector)pts.elementAt(i));
                            this.m_displayOption.setLightType(i, 1);
                            ++i;
                        }
                    }
                }
                return true;
            }
            if ("ViewPoint".equals(st.sval)) {
                st.nextToken();
                st.nextToken();
                st.parseNumbers();
                PdVector vp = new PdVector();
                if (!this.parseVector(st, vp, 3)) {
                    return false;
                }
                this.m_displayOption.setCameraPosition(0, vp);
                return true;
            }
            if ("ViewCenter".equals(st.sval)) {
                st.nextToken();
                st.nextToken();
                st.parseNumbers();
                st.nextToken();
                if (st.ttype != -3 || !"Automatic".equals(st.sval)) {
                    st.pushBack();
                    PdVector vc = new PdVector();
                    if (!this.parseVector(st, vc, 3)) {
                        return false;
                    }
                    this.m_displayOption.setCameraInterest(0, vc);
                }
                return true;
            }
            if ("AxesEdge".equals(st.sval)) {
                st.nextToken();
                st.nextToken();
                st.parseNumbers();
                st.nextToken();
                PiVector ae = new PiVector(6);
                if (st.ttype == -3 && "Automatic".equals(st.sval)) {
                    int i = 0;
                    while (i < 6) {
                        ae.m_data[i] = -1;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < 3) {
                        st.nextToken();
                        if (st.ttype == -3) {
                            if ("Automatic".equals(st.sval)) {
                                ae.m_data[i * 2] = -1;
                                ae.m_data[i * 2 + 1] = -1;
                            } else {
                                ae.m_data[i * 2] = 0;
                                ae.m_data[i * 2 + 1] = 0;
                            }
                        } else {
                            st.nextToken();
                            ae.m_data[i * 2] = (int)st.nval;
                            st.nextToken();
                            st.nextToken();
                            ae.m_data[i * 2 + 1] = (int)st.nval;
                            st.nextToken();
                        }
                        st.nextToken();
                        ++i;
                    }
                }
                this.m_displayOption.setAxesEdge(ae);
                return true;
            }
            if ("AmbientLight".equals(st.sval)) {
                st.nextToken();
                st.nextToken();
                st.parseNumbers();
                st.nextToken();
                this.m_displayOption.setAmbientLight(this.readColor(st));
                return true;
            }
            if ("BoxRatios".equals(st.sval)) {
                st.nextToken();
                st.nextToken();
                st.parseNumbers();
                st.nextToken();
                PdVector ratios = new PdVector(3);
                if (st.ttype == -3 && "Automatic".equals(st.sval)) {
                    ratios.setConstant(0.0);
                } else {
                    st.pushBack();
                    if (!this.parseVector(st, ratios, 3)) {
                        return false;
                    }
                }
                return true;
            }
            if ("Background".equals(st.sval)) {
                st.nextToken();
                st.nextToken();
                st.nextToken();
                if (st.ttype == -3 && ("RGBColor".equals(st.sval) || "Hue".equals(st.sval) || "GrayLevel".equals(st.sval) || "CMYKColor".equals(st.sval))) {
                    this.m_displayOption.setBackgroundColor(this.readColor(st));
                }
                return true;
            }
            if ("PolygonIntersections".equals(st.sval)) {
                st.nextToken();
                st.nextToken();
                st.nextToken();
                if ("True".equals(st.sval)) {
                    // empty if block
                }
                return true;
            }
            if ("ViewVertical".equals(st.sval)) {
                st.nextToken();
                st.nextToken();
                return this.parseVector(st, this.m_viewVertical, 3);
            }
            return false;
        }
        catch (Exception e) {
            PsDebug.warning("Exception thrown: " + e + " Line: " + st.lineno());
            return false;
        }
    }

    private Color readGrayLevel(StreamTokenizer st) {
        try {
            st.nextToken();
            double gray = this.readNumber(st);
            st.nextToken();
            return new Color((float)gray, (float)gray, (float)gray);
        }
        catch (Exception e) {
            PsDebug.warning("Exception thrown: " + e + " Line: " + st.lineno());
            return new Color(0.5f, 0.5f, 0.5f);
        }
    }

    private void readAxesLabel(StreamTokenizer st, int dim) {
        try {
            st.nextToken();
            st.nextToken();
            st.ordinaryChar(34);
            st.nextToken();
            String[] labels = new String[dim];
            if (st.ttype == -3 && "None".equals(st.sval)) {
                int i = 0;
                while (i < dim) {
                    labels[i] = "";
                    ++i;
                }
                this.m_displayOption.clearTag(4);
            } else if (st.ttype == 123) {
                this.m_displayOption.setTag(4);
                int i = 0;
                while (i < dim) {
                    st.nextToken();
                    if (st.ttype != 34) {
                        PsDebug.warning("AxesLabel should be given in quotes.");
                        this.m_displayOption.clearTag(4);
                        break;
                    }
                    labels[i] = this.readString(st);
                    st.nextToken();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < dim - 1) {
                    labels[i] = "";
                    ++i;
                }
                if (st.ttype == 34) {
                    labels[dim] = this.readString(st);
                    this.m_displayOption.setTag(4);
                } else {
                    PsDebug.warning("AxesLabel should be given in quotes.");
                    this.m_displayOption.clearTag(4);
                }
            }
            st.wordChars(34, 34);
            this.m_displayOption.setAxesLabel(labels);
        }
        catch (Exception e) {
            PsDebug.warning("Exception thrown: " + e + " Line: " + st.lineno());
        }
    }

    private boolean parseMath(BufferedReader bufReader) throws IOException {
        block39: {
            try {
                this.m_displayOption = new PvDisplayOption();
                this.setDisplayDefault();
                StreamTokenizer st = new StreamTokenizer(bufReader);
                st.ordinaryChar(91);
                st.ordinaryChar(93);
                st.ordinaryChar(123);
                st.ordinaryChar(125);
                st.ordinaryChar(42);
                st.ordinaryChar(94);
                st.ordinaryChar(44);
                st.parseNumbers();
                st.eolIsSignificant(false);
                st.whitespaceChars(92, 92);
                int numOpenBrackets1 = 0;
                int numOpenBrackets2 = 0;
                block12: while (true) {
                    switch (st.nextToken()) {
                        default: {
                            PsDebug.warning("parsing broke abnormally reading st.sval = " + st.sval + ", st.ttype = " + st.ttype + "  in line: " + st.lineno());
                            break;
                        }
                        case -1: {
                            PsDebug.notify("EOF token = " + st.sval);
                            if (numOpenBrackets1 != 0) {
                                PsDebug.warning("'}' missing");
                                return false;
                            }
                            if (numOpenBrackets2 != 0) {
                                PsDebug.warning("']' missing");
                                return false;
                            }
                            break block39;
                        }
                        case -3: {
                            if ("InputForm".equals(st.sval)) continue block12;
                            if ("Graphics".equals(st.sval)) {
                                this.m_dim = 2;
                                if (!this.readGraphics(st)) {
                                    PsDebug.warning("failed reading Graphics");
                                    return false;
                                }
                                ++this.m_numGraphics;
                                break;
                            }
                            if ("Graphics3D".equals(st.sval)) {
                                this.m_dim = 3;
                                if (!this.readGraphics(st)) {
                                    PsDebug.warning("failed reading Graphics3D");
                                    return false;
                                }
                                ++this.m_numGraphics;
                                break;
                            }
                            if ("SurfaceGraphics".equals(st.sval)) {
                                this.m_dim = 3;
                                if (!this.readParametricSurface(st)) {
                                    PsDebug.warning("failed reading SurfaceGraphics as ElementSet");
                                    return false;
                                }
                                ++this.m_numGraphics;
                                break;
                            }
                            if ("DensityGraphics".equals(st.sval)) {
                                this.m_dim = 2;
                                if (!this.readParametricSurface(st)) {
                                    PsDebug.warning("failed reading DensityGraphics as ElementSet");
                                    return false;
                                }
                                ++this.m_numGraphics;
                                break;
                            }
                            if ("KeyAnimation".equals(st.sval) || "Animation".equals(st.sval) || "ShowAnimation".equals(st.sval)) {
                                if ("KeyAnimation".equals(st.sval)) {
                                    this.m_isKeyAnimation = true;
                                }
                                if ("Animation".equals(st.sval)) {
                                    this.m_isAnimation = true;
                                }
                                if ("ShowAnimation".equals(st.sval)) {
                                    this.m_isKeyAnimation = true;
                                }
                                st.nextToken();
                                do {
                                    if (st.ttype == 93) continue block12;
                                    st.nextToken();
                                    if (st.ttype == 123 || st.ttype == 125) {
                                        st.nextToken();
                                    }
                                    if (st.ttype != -3 || !"Graphics".equals(st.sval) && !"Graphics3D".equals(st.sval) && !"SurfaceGraphics".equals(st.sval)) {
                                        PsDebug.warning("Expected 'Graphics', 'Graphics3D' or 'SurfaceGraphics' Line: " + st.lineno());
                                        return false;
                                    }
                                    if ("Graphics".equals(st.sval)) {
                                        this.m_dim = 2;
                                        if (!this.readGraphics(st)) {
                                            PsDebug.warning("failed reading Graphics");
                                            return false;
                                        }
                                        ++this.m_numGraphics;
                                    }
                                    if ("Graphics3D".equals(st.sval)) {
                                        this.m_dim = 3;
                                        if (!this.readGraphics(st)) {
                                            PsDebug.warning("failed reading Graphics3D");
                                            return false;
                                        }
                                        ++this.m_numGraphics;
                                    }
                                    if ("SurfaceGraphics".equals(st.sval)) {
                                        this.m_dim = 3;
                                        if (!this.readParametricSurface(st)) {
                                            PsDebug.warning("failed reading SurfaceGraphics as ElementSet");
                                            return false;
                                        }
                                        ++this.m_numGraphics;
                                    }
                                    st.nextToken();
                                    if (st.ttype != 123 && st.ttype != 125) continue;
                                    st.nextToken();
                                } while (st.ttype == 44 || st.ttype == 93);
                                PsDebug.warning("Expected ',' or ']' Line: " + st.lineno());
                                return false;
                            }
                            PsDebug.warning("Unknown command:" + st.sval + " Line: " + st.lineno());
                            return false;
                        }
                        case 40: {
                            st.nextToken();
                            if (st.ttype != 42) {
                                st.pushBack();
                                break;
                            }
                            boolean b = true;
                            while (true) {
                                if (!b) continue block12;
                                st.nextToken();
                                if (st.ttype != 42) continue;
                                st.nextToken();
                                if (st.ttype == 41) {
                                    b = false;
                                    continue;
                                }
                                st.pushBack();
                            }
                        }
                        case 44: {
                            break;
                        }
                        case 123: {
                            ++numOpenBrackets1;
                            break;
                        }
                        case 125: {
                            if (--numOpenBrackets1 >= 0) continue block12;
                            PsDebug.warning("More '}' than '{' Line: " + st.lineno());
                            return false;
                        }
                        case 91: {
                            ++numOpenBrackets2;
                            break;
                        }
                        case 93: {
                            if (--numOpenBrackets2 >= 0) continue block12;
                            PsDebug.warning("More ']' than '[' Line: " + st.lineno());
                            return false;
                        }
                    }
                }
            }
            catch (Exception e) {
                PsDebug.warning("Exception thrown: " + e);
                return false;
            }
        }
        PsDebug.notify("... finished");
        return true;
    }

    private String readString(StreamTokenizer st) {
        try {
            st.nextToken();
            String str = new String("");
            while (st.ttype != 34) {
                if (st.ttype == -3) {
                    str = str + st.sval;
                } else if (st.ttype == -2) {
                    st.pushBack();
                    str = str + Double.toString(this.readNumber(st));
                } else if (st.ttype == 91) {
                    str = str + "[";
                } else if (st.ttype == 93) {
                    str = str + "]";
                } else if (st.ttype == 44) {
                    str = str + ",";
                } else if (st.ttype == 42) {
                    str = str + "*";
                } else if (st.ttype == 94) {
                    str = str + "^";
                } else if (st.ttype == 123) {
                    str = str + "{";
                } else if (st.ttype == 125) {
                    str = str + "}";
                } else if (st.ttype == 40) {
                    str = str + "(";
                } else if (st.ttype == 41) {
                    str = str + ")";
                } else if (st.ttype == 45) {
                    str = str + "-";
                } else if (st.ttype == 62) {
                    str = str + ">";
                }
                st.nextToken();
            }
            return str;
        }
        catch (Exception e) {
            PsDebug.warning("Exception thrown: " + e + " Line: " + st.lineno());
            return "";
        }
    }

    private void computeMathematicaColors(PgJvxSrc geom) {
        if (this.m_displayOption.hasTag(17)) {
            geom.makeElementNormals();
            int noe = geom.getNumElements();
            Color[] colors = new Color[noe];
            Color[] backColors = new Color[noe];
            int nol0 = this.m_displayOption.getNumLights();
            int nol = 0;
            int i = 0;
            while (i < nol0) {
                if (this.m_displayOption.getLightType(i) == 1) {
                    ++nol;
                }
                ++i;
            }
            Color[] lightColor = new Color[nol];
            PdVector[] lightPosition = new PdVector[nol];
            Color ambientLight = this.m_displayOption.getAmbientLight();
            int ii = 0;
            int i2 = 0;
            while (i2 < nol) {
                if (this.m_displayOption.getLightType(i2) == 1) {
                    lightColor[ii] = this.m_displayOption.getLightColor(i2);
                    lightPosition[ii] = this.m_displayOption.getLightPosition(i2);
                    ++ii;
                }
                ++i2;
            }
            PdVector[] normals = geom.getElementNormals();
            Color[] elColor = geom.getElementColors();
            Color[] elBackColor = geom.getElementBackColors();
            int i3 = 0;
            while (i3 < noe) {
                double red = ambientLight.getRed();
                double green = ambientLight.getGreen();
                double blue = ambientLight.getBlue();
                double redBack = ambientLight.getRed();
                double greenBack = ambientLight.getGreen();
                double blueBack = ambientLight.getBlue();
                PdVector normal = PdVector.copyNew(normals[i3]);
                normal.normalize();
                int j = 0;
                while (j < nol) {
                    double factor = PdVector.dot(normal, lightPosition[j]) / lightPosition[j].length();
                    if (factor > 0.0) {
                        red += factor * (double)lightColor[j].getRed();
                        green += factor * (double)lightColor[j].getGreen();
                        blue += factor * (double)lightColor[j].getBlue();
                    } else {
                        redBack -= factor * (double)lightColor[j].getRed();
                        greenBack -= factor * (double)lightColor[j].getGreen();
                        blueBack -= factor * (double)lightColor[j].getBlue();
                    }
                    ++j;
                }
                Color col = elColor[i3];
                red = red > (double)col.getRed() ? (double)col.getRed() / 255.0 : (red /= 255.0);
                green = green > (double)col.getGreen() ? (double)col.getGreen() / 255.0 : (green /= 255.0);
                blue = blue > (double)col.getBlue() ? (double)col.getBlue() / 255.0 : (blue /= 255.0);
                Color colBack = elBackColor[i3];
                redBack = redBack > (double)colBack.getRed() ? (double)colBack.getRed() / 255.0 : (redBack /= 255.0);
                greenBack = greenBack > (double)colBack.getGreen() ? (double)colBack.getGreen() / 255.0 : (greenBack /= 255.0);
                blueBack = blueBack > (double)colBack.getBlue() ? (double)colBack.getBlue() / 255.0 : (blueBack /= 255.0);
                colors[i3] = new Color((float)red, (float)green, (float)blue);
                backColors[i3] = new Color((float)redBack, (float)greenBack, (float)blueBack);
                ++i3;
            }
            geom.setElementColors(colors);
            geom.setElementBackColors(backColors);
        }
    }

    private Color readHueColor(StreamTokenizer st) {
        try {
            st.nextToken();
            double hue = this.readNumber(st);
            double saturation = 1.0;
            double brightness = 1.0;
            st.nextToken();
            if (st.ttype == 44) {
                saturation = this.readNumber(st);
                st.nextToken();
                brightness = this.readNumber(st);
                st.nextToken();
            }
            Color c = new Color(Color.HSBtoRGB((float)hue, (float)saturation, (float)brightness));
            return c;
        }
        catch (Exception e) {
            PsDebug.warning("Exception thrown: " + e + " Line: " + st.lineno());
            return new Color(1.0f, 0.0f, 0.0f);
        }
    }

    private Color readCMYKColor(StreamTokenizer st) {
        PdVector col = new PdVector();
        if (this.parseVector(st, col, 4)) {
            PsDebug.warning("Reading of CMYKColor not implemented yet.");
            return new Color(255, 255, 255);
        }
        PsDebug.warning("Reading of CMYKColor failed.");
        return new Color(255, 255, 255);
    }

    private boolean readGraphics(StreamTokenizer st) {
        try {
            int i;
            Vector[] bColor = new Vector[7];
            Vector<Color> bCommonColor = new Vector<Color>();
            bCommonColor.addElement(Color.white);
            int i2 = 0;
            while (i2 <= 5) {
                bColor[i2] = new Vector();
                bColor[i2].addElement(Color.white);
                ++i2;
            }
            PiVector colorExp = new PiVector(1);
            colorExp.m_data[0] = 1;
            PiVector backColorExp = new PiVector(1);
            backColorExp.m_data[0] = 1;
            bColor[6] = new Vector();
            bColor[6].addElement(Color.black);
            boolean colorsDefined = false;
            boolean elementEdgeColorsDefined = false;
            Vector[] geomColor = new Vector[9];
            int i3 = 0;
            while (i3 <= 8) {
                geomColor[i3] = new Vector();
                ++i3;
            }
            PiVector faceReflectionExponent = new PiVector();
            PiVector backFaceReflectionExponent = new PiVector();
            Vector<PdVector> eVertexVector = new Vector<PdVector>();
            Vector<PiVector> elementVector = new Vector<PiVector>();
            Vector<PdVector> pVertexVector = new Vector<PdVector>();
            Vector<PdVector[]> arrowVector = new Vector<PdVector[]>();
            Vector<PgJvxSrc> polygonVector = new Vector<PgJvxSrc>();
            Vector<PdVector> circleVector = new Vector<PdVector>();
            Vector<PdVector> diskVector = new Vector<PdVector>();
            int numVertices = 0;
            int numElements = 0;
            int numPoints = 0;
            int numArrows = 0;
            int numPolygons = 0;
            int numCircles = 0;
            int numDisks = 0;
            boolean showEdges = true;
            if (this.m_dim == 2) {
                showEdges = false;
            }
            double globalEdgeSize = 1.0;
            int n0 = 0;
            st.nextToken();
            if (st.ttype != 91) {
                PsDebug.warning("'['Expected Line: " + st.lineno());
                return false;
            }
            String unUsedText = "";
            int openBrackets = -1;
            while (openBrackets != 0) {
                int i4;
                if (openBrackets == -1) {
                    openBrackets = 0;
                }
                st.nextToken();
                if (st.ttype == 123) {
                    int i5;
                    int size = bCommonColor.size();
                    if (++openBrackets + 1 > size) {
                        bCommonColor.addElement((Color)bCommonColor.elementAt(size - 1));
                        i5 = 0;
                        while (i5 <= 6) {
                            bColor[i5].addElement(bColor[i5].elementAt(size - 1));
                            ++i5;
                        }
                        colorExp.setSize(openBrackets + 1);
                        backColorExp.setSize(openBrackets + 1);
                        continue;
                    }
                    bCommonColor.setElementAt((Color)bCommonColor.elementAt(openBrackets - 1), openBrackets);
                    i5 = 0;
                    while (i5 <= 6) {
                        bColor[i5].setElementAt(bColor[i5].elementAt(openBrackets - 1), openBrackets);
                        ++i5;
                    }
                    colorExp.m_data[openBrackets] = colorExp.m_data[openBrackets - 1];
                    backColorExp.m_data[openBrackets] = backColorExp.m_data[openBrackets - 1];
                    continue;
                }
                if (st.ttype == 125) {
                    --openBrackets;
                    continue;
                }
                if (st.ttype == 44) continue;
                if (st.ttype != -3) {
                    PsDebug.warning("Graphics primitive identifyer expected Line: " + st.lineno());
                    return false;
                }
                if ("Polygon".equals(st.sval)) {
                    int i6;
                    st.nextToken();
                    st.nextToken();
                    int n = 0;
                    while (st.ttype != 125) {
                        st.nextToken();
                        PdVector v = new PdVector(this.m_dim);
                        i6 = 0;
                        while (i6 < this.m_dim) {
                            v.m_data[i6] = this.readNumber(st);
                            st.nextToken();
                            ++i6;
                        }
                        eVertexVector.addElement(v);
                        ++n;
                        ++numVertices;
                        st.nextToken();
                    }
                    PiVector e = new PiVector(n);
                    i6 = 0;
                    while (i6 < n) {
                        e.m_data[i6] = n0 + i6;
                        ++i6;
                    }
                    n0 += n;
                    elementVector.addElement(e);
                    ++numElements;
                    st.nextToken();
                    i6 = 0;
                    while (i6 <= 6) {
                        geomColor[i6].addElement(bColor[i6].elementAt(openBrackets));
                        ++i6;
                    }
                    faceReflectionExponent.addEntry(colorExp.m_data[openBrackets]);
                    backFaceReflectionExponent.addEntry(backColorExp.m_data[openBrackets]);
                    continue;
                }
                if ("Point".equals(st.sval)) {
                    st.nextToken();
                    PdVector v = new PdVector();
                    if (!this.parseVector(st, v, this.m_dim)) {
                        return false;
                    }
                    pVertexVector.addElement(v);
                    ++numPoints;
                    st.nextToken();
                    geomColor[7].addElement(bCommonColor.elementAt(openBrackets));
                    continue;
                }
                if ("Line".equals(st.sval)) {
                    st.nextToken();
                    st.nextToken();
                    Vector<PdVector> polygonVertexVector = new Vector<PdVector>();
                    int numPolygonVertices = 0;
                    while (st.ttype != 125) {
                        PdVector v = new PdVector();
                        if (!this.parseVector(st, v, this.m_dim)) {
                            return false;
                        }
                        polygonVertexVector.addElement(v);
                        ++numPolygonVertices;
                        st.nextToken();
                    }
                    PgJvxSrc p = new PgJvxSrc();
                    p.setDimOfVertices(this.m_dim);
                    p.setNumVertices(numPolygonVertices);
                    int i7 = 0;
                    while (i7 < numPolygonVertices) {
                        p.setVertex(i7, (PdVector)polygonVertexVector.elementAt(i7));
                        ++i7;
                    }
                    ++numPolygons;
                    polygonVector.addElement(p);
                    st.nextToken();
                    geomColor[8].addElement(bCommonColor.elementAt(openBrackets));
                    continue;
                }
                if ("Arrow".equals(st.sval)) {
                    st.nextToken();
                    PdVector[] vv = new PdVector[2];
                    vv[0] = new PdVector(this.m_dim);
                    if (!this.parseVector(st, vv[0], this.m_dim)) {
                        return false;
                    }
                    st.nextToken();
                    vv[1] = new PdVector(this.m_dim);
                    if (!this.parseVector(st, vv[1], this.m_dim)) {
                        return false;
                    }
                    arrowVector.addElement(vv);
                    while (st.ttype != 93) {
                        st.nextToken();
                    }
                    ++numArrows;
                    continue;
                }
                if ("Circle".equals(st.sval)) {
                    if (this.m_dim != 2) {
                        PsDebug.warning("Wrong dimension of graphics primitive Line: " + st.lineno());
                        return false;
                    }
                    st.nextToken();
                    PdVector v = new PdVector();
                    if (!this.parseVector(st, v, 2)) {
                        return false;
                    }
                    v.setSize(3);
                    st.nextToken();
                    v.m_data[2] = this.readNumber(st);
                    st.nextToken();
                    ++numCircles;
                    circleVector.addElement(v);
                    continue;
                }
                if ("Disk".equals(st.sval)) {
                    if (this.m_dim != 2) {
                        PsDebug.warning("Wrong dimension of graphics primitive Line: " + st.lineno());
                        return false;
                    }
                    st.nextToken();
                    PdVector v = new PdVector();
                    if (!this.parseVector(st, v, 2)) {
                        return false;
                    }
                    v.setSize(3);
                    st.nextToken();
                    v.m_data[2] = this.readNumber(st);
                    st.nextToken();
                    ++numDisks;
                    diskVector.addElement(v);
                    continue;
                }
                if ("Rectangle".equals(st.sval)) {
                    st.nextToken();
                    PdVector min = new PdVector();
                    if (!this.parseVector(st, min, 2)) {
                        return false;
                    }
                    st.nextToken();
                    PdVector max = new PdVector();
                    if (!this.parseVector(st, max, 2)) {
                        return false;
                    }
                    st.nextToken();
                    if (st.ttype == 93) {
                        if (this.m_dim != 2) {
                            PsDebug.warning("Wrong dimension of graphics primitive Line: " + st.lineno());
                            return false;
                        }
                        PiVector e = new PiVector(4);
                        int i8 = 0;
                        while (i8 < 4) {
                            e.m_data[i8] = n0 + i8;
                            ++i8;
                        }
                        elementVector.addElement(e);
                        ++numElements;
                        PdVector[] v = new PdVector[]{min, new PdVector(max.m_data[0], min.m_data[1]), max, new PdVector(min.m_data[0], max.m_data[1])};
                        i4 = 0;
                        while (i4 < 4) {
                            eVertexVector.addElement(v[i4]);
                            ++i4;
                        }
                        numVertices += 4;
                        n0 += 4;
                        i4 = 0;
                        while (i4 <= 6) {
                            geomColor[i4].addElement(bColor[i4].elementAt(openBrackets));
                            ++i4;
                        }
                        faceReflectionExponent.addEntry(colorExp.m_data[openBrackets]);
                        backFaceReflectionExponent.addEntry(backColorExp.m_data[openBrackets]);
                        continue;
                    }
                    unUsedText = unUsedText + "Rectangle[{" + min.m_data[0] + "," + min.m_data[1] + "},{" + max.m_data[0] + "," + max.m_data[1] + "}" + st.sval;
                    int numOpenBrackets = 1;
                    while (numOpenBrackets != 0) {
                        if (st.ttype == -1) {
                            PsDebug.warning("']' missing Line: " + st.lineno());
                            return false;
                        }
                        st.nextToken();
                        if (st.ttype == 93) {
                            --numOpenBrackets;
                            unUsedText = unUsedText + "]";
                        }
                        if (st.ttype == 91) {
                            ++numOpenBrackets;
                            unUsedText = unUsedText + "[";
                        }
                        if (st.ttype == -3) {
                            unUsedText = unUsedText + st.sval;
                            continue;
                        }
                        if (st.ttype == -2) {
                            st.pushBack();
                            unUsedText = unUsedText + Double.toString(this.readNumber(st));
                            continue;
                        }
                        if (st.ttype == 123) {
                            unUsedText = unUsedText + "{";
                            continue;
                        }
                        if (st.ttype == 125) {
                            unUsedText = unUsedText + "}";
                            continue;
                        }
                        if (st.ttype == 44) {
                            unUsedText = unUsedText + ",";
                            continue;
                        }
                        if (st.ttype == 42) {
                            unUsedText = unUsedText + "*";
                            continue;
                        }
                        if (st.ttype != 94) continue;
                        unUsedText = unUsedText + "^";
                    }
                    continue;
                }
                if ("Cuboid".equals(st.sval)) {
                    if (this.m_dim != 3) {
                        PsDebug.warning("Wrong dimension of graphics primitive Line: " + st.lineno());
                        return false;
                    }
                    st.nextToken();
                    PdVector min = new PdVector();
                    if (!this.parseVector(st, min, 3)) {
                        return false;
                    }
                    st.nextToken();
                    PdVector max = new PdVector();
                    if (st.ttype == 44) {
                        if (!this.parseVector(st, max, 3)) {
                            return false;
                        }
                        st.nextToken();
                    } else {
                        max = PdVector.copyNew(min);
                        max.add(1.0);
                    }
                    PiVector[] e = new PiVector[]{new PiVector(n0, n0 + 4, n0 + 5, n0 + 1), new PiVector(n0 + 3, n0 + 2, n0 + 6, n0 + 7), new PiVector(n0, n0 + 1, n0 + 2, n0 + 3), new PiVector(n0 + 4, n0 + 7, n0 + 6, n0 + 5), new PiVector(n0 + 1, n0 + 5, n0 + 6, n0 + 2), new PiVector(n0, n0 + 3, n0 + 7, n0 + 4)};
                    int i9 = 0;
                    while (i9 < 6) {
                        elementVector.addElement(e[i9]);
                        ++i9;
                    }
                    numElements += 6;
                    n0 += 8;
                    PdVector[] v = new PdVector[]{min, new PdVector(max.m_data[0], min.m_data[1], min.m_data[2]), new PdVector(max.m_data[0], min.m_data[1], max.m_data[2]), new PdVector(min.m_data[0], min.m_data[1], max.m_data[2]), new PdVector(min.m_data[0], max.m_data[1], min.m_data[2]), new PdVector(max.m_data[0], max.m_data[1], min.m_data[2]), max, new PdVector(min.m_data[0], max.m_data[1], max.m_data[2])};
                    i4 = 0;
                    while (i4 < 8) {
                        eVertexVector.addElement(v[i4]);
                        ++i4;
                    }
                    numVertices += 8;
                    i4 = 0;
                    while (i4 < 6) {
                        int j = 0;
                        while (j <= 6) {
                            geomColor[j].addElement(bColor[j].elementAt(openBrackets));
                            ++j;
                        }
                        faceReflectionExponent.addEntry(colorExp.m_data[openBrackets]);
                        backFaceReflectionExponent.addEntry(backColorExp.m_data[openBrackets]);
                        ++i4;
                    }
                    continue;
                }
                if ("RGBColor".equals(st.sval) || "GrayLevel".equals(st.sval) || "Hue".equals(st.sval) || "CMYKColor".equals(st.sval)) {
                    colorsDefined = true;
                    Color col = this.readColor(st);
                    bCommonColor.setElementAt(col, openBrackets);
                    int i10 = 4;
                    while (i10 <= 5) {
                        bColor[i10].setElementAt(col, openBrackets);
                        ++i10;
                    }
                    if (this.m_dim == 3) continue;
                    i10 = 0;
                    while (i10 <= 3) {
                        bColor[i10].setElementAt(col, openBrackets);
                        ++i10;
                    }
                    colorExp.m_data[openBrackets] = 1;
                    backColorExp.m_data[openBrackets] = 1;
                    continue;
                }
                if ("SurfaceColor".equals(st.sval)) {
                    colorsDefined = true;
                    Color[] c = new Color[2];
                    colorExp.m_data[openBrackets] = this.readSurfaceColor(st, c);
                    Color col = c[0];
                    Color refl = c[1];
                    backColorExp.m_data[openBrackets] = colorExp.m_data[openBrackets];
                    int i11 = 0;
                    while (i11 <= 1) {
                        bColor[i11].setElementAt(col, openBrackets);
                        ++i11;
                    }
                    i11 = 2;
                    while (i11 <= 3) {
                        bColor[i11].setElementAt(refl, openBrackets);
                        ++i11;
                    }
                    continue;
                }
                if ("EdgeForm".equals(st.sval)) {
                    st.nextToken();
                    st.nextToken();
                    if (st.ttype == 93) {
                        showEdges = false;
                    }
                    while (st.ttype != 93) {
                        if (st.ttype == -3) {
                            if ("RGBColor".equals(st.sval) || "CMYKColor".equals(st.sval) || "Hue".equals(st.sval) || "GrayLevel".equals(st.sval)) {
                                elementEdgeColorsDefined = true;
                                Color col = this.readColor(st);
                                bColor[6].setElementAt(col, openBrackets);
                                st.nextToken();
                            }
                            if (!"Thickness".equals(st.sval)) continue;
                            st.nextToken();
                            globalEdgeSize = 200.0 * this.readNumber(st);
                            st.nextToken();
                            st.nextToken();
                            continue;
                        }
                        st.nextToken();
                    }
                    continue;
                }
                if ("FaceForm".equals(st.sval)) {
                    st.nextToken();
                    st.nextToken();
                    colorsDefined = true;
                    if ("SurfaceColor".equals(st.sval)) {
                        Color[] c = new Color[2];
                        colorExp.m_data[openBrackets] = this.readSurfaceColor(st, c);
                        Color col = c[0];
                        Color refl = c[1];
                        bColor[0].setElementAt(col, openBrackets);
                        bColor[2].setElementAt(refl, openBrackets);
                    } else {
                        Color col = this.readColor(st);
                        bColor[4].setElementAt(col, openBrackets);
                    }
                    st.nextToken();
                    boolean sc = true;
                    if (st.ttype == 44) {
                        st.nextToken();
                        if ("SurfaceColor".equals(st.sval)) {
                            Color[] c = new Color[2];
                            backColorExp.m_data[openBrackets] = this.readSurfaceColor(st, c);
                            Color col = c[0];
                            Color refl = c[1];
                            bColor[1].setElementAt(col, openBrackets);
                            bColor[3].setElementAt(refl, openBrackets);
                        } else {
                            sc = false;
                            Color col = this.readColor(st);
                            bColor[5].setElementAt(col, openBrackets);
                        }
                        st.nextToken();
                        continue;
                    }
                    if (sc) {
                        bColor[1].setElementAt(bColor[0].elementAt(openBrackets), openBrackets);
                        bColor[3].setElementAt(bColor[2].elementAt(openBrackets), openBrackets);
                        backColorExp.m_data[openBrackets] = colorExp.m_data[openBrackets];
                        continue;
                    }
                    bColor[5].setElementAt(bColor[4].elementAt(openBrackets), openBrackets);
                    continue;
                }
                PsDebug.warning("skipping " + st.sval + " Line: " + st.lineno());
                unUsedText = unUsedText + st.sval;
                st.nextToken();
                if (st.ttype != 91) {
                    PsDebug.warning("'[' expected Line: " + st.lineno());
                    return false;
                }
                int numOpenBrackets = 1;
                unUsedText = unUsedText + "[";
                while (numOpenBrackets != 0) {
                    if (st.ttype == -1) {
                        PsDebug.warning("']' missing Line: " + st.lineno());
                        return false;
                    }
                    st.nextToken();
                    if (st.ttype == 93) {
                        --numOpenBrackets;
                        unUsedText = unUsedText + "]";
                    }
                    if (st.ttype == 91) {
                        ++numOpenBrackets;
                        unUsedText = unUsedText + "[";
                    }
                    if (st.ttype == -3) {
                        unUsedText = unUsedText + st.sval;
                        continue;
                    }
                    if (st.ttype == -2) {
                        st.pushBack();
                        unUsedText = unUsedText + Double.toString(this.readNumber(st));
                        continue;
                    }
                    if (st.ttype == 123) {
                        unUsedText = unUsedText + "{";
                        continue;
                    }
                    if (st.ttype == 125) {
                        unUsedText = unUsedText + "}";
                        continue;
                    }
                    if (st.ttype == 44) {
                        unUsedText = unUsedText + ",";
                        continue;
                    }
                    if (st.ttype == 42) {
                        unUsedText = unUsedText + "*";
                        continue;
                    }
                    if (st.ttype != 94) continue;
                    unUsedText = unUsedText + "^";
                }
            }
            boolean useElementColors = true;
            boolean showElements = true;
            st.nextToken();
            int numOpenBrackets = 1;
            while (numOpenBrackets != 0) {
                if (st.ttype == -1) {
                    PsDebug.warning("']' missing Line: " + st.lineno());
                    return false;
                }
                if (st.ttype == 93) {
                    --numOpenBrackets;
                }
                if (st.ttype == 91) {
                    ++numOpenBrackets;
                }
                if (st.ttype == -3 && !this.readOptions(st)) {
                    if ("AxesLabel".equals(st.sval)) {
                        this.readAxesLabel(st, this.m_dim);
                    } else if ("HiddenSurface".equals(st.sval)) {
                        st.nextToken();
                        st.nextToken();
                        st.nextToken();
                        showElements = "True".equals(st.sval);
                    } else if ("Shading".equals(st.sval)) {
                        st.nextToken();
                        st.nextToken();
                        st.nextToken();
                        useElementColors = "True".equals(st.sval);
                    }
                }
                st.ordinaryChar(45);
                st.nextToken();
            }
            int numGeom = 0;
            if (numElements != 0) {
                ++numGeom;
            }
            if (numPoints != 0) {
                ++numGeom;
            }
            if (numArrows != 0) {
                ++numGeom;
            }
            if (numPolygons != 0) {
                ++numGeom;
            }
            this.m_geom = new PgJvxSrc[numGeom];
            int index = 0;
            if (numElements != 0) {
                int j;
                PgJvxSrc elementSet = new PgJvxSrc();
                elementSet.setType(33);
                elementSet.setDimOfVertices(this.m_dim);
                elementSet.setNumVertices(numVertices);
                int i12 = 0;
                while (i12 < numVertices) {
                    elementSet.setVertex(i12, (PdVector)eVertexVector.elementAt(i12));
                    ++i12;
                }
                elementSet.setDimOfElements(-1);
                elementSet.setNumElements(numElements);
                i12 = 0;
                while (i12 < numElements) {
                    elementSet.setElement(i12, (PiVector)elementVector.elementAt(i12));
                    ++i12;
                }
                PgMathLoader.geomInitType(elementSet);
                if (showEdges) {
                    elementSet.showEdges(true);
                } else {
                    elementSet.showEdges(false);
                }
                elementSet.setGlobalEdgeSize(globalEdgeSize);
                elementSet.showElementColors(useElementColors);
                elementSet.showElementBackColors(useElementColors);
                elementSet.showElements(showElements);
                Color[][] elColor = new Color[4][];
                int i13 = 0;
                while (i13 <= 3) {
                    elColor[i13] = new Color[numElements];
                    ++i13;
                }
                if (colorsDefined) {
                    if (this.m_displayOption.hasTag(17)) {
                        i13 = 0;
                        while (i13 < numElements) {
                            j = 0;
                            while (j <= 3) {
                                elColor[j][i13] = (Color)geomColor[j].elementAt(i13);
                                ++j;
                            }
                            ++i13;
                        }
                    } else {
                        i13 = 0;
                        while (i13 < numElements) {
                            elColor[0][i13] = (Color)geomColor[4].elementAt(i13);
                            elColor[1][i13] = (Color)geomColor[5].elementAt(i13);
                            ++i13;
                        }
                    }
                    elementSet.setElementColors(elColor[0]);
                    elementSet.setElementBackColors(elColor[1]);
                    if (elementEdgeColorsDefined) {
                        Color[] elEdgeColor = new Color[numElements];
                        i = 0;
                        while (i < numElements) {
                            elEdgeColor[i] = (Color)geomColor[6].elementAt(i);
                            ++i;
                        }
                    }
                } else {
                    i13 = 0;
                    while (i13 < numElements) {
                        j = 0;
                        while (j <= 3) {
                            elColor[j][i13] = Color.white;
                            ++j;
                        }
                        ++i13;
                    }
                    elementSet.setElementColors(elColor[0]);
                    elementSet.setElementBackColors(elColor[1]);
                }
                this.m_geom[index] = elementSet;
                this.m_geom[index].setName("ElementSet imported from Mathematica");
                ++index;
            }
            if (numPoints != 0) {
                PgJvxSrc pointSet = new PgJvxSrc();
                pointSet.setType(30);
                PgMathLoader.geomInitType(pointSet);
                pointSet.setDimOfVertices(this.m_dim);
                pointSet.setNumVertices(numPoints);
                int i14 = 0;
                while (i14 < numPoints) {
                    pointSet.setVertex(i14, (PdVector)pVertexVector.elementAt(i14));
                    ++i14;
                }
                if (colorsDefined) {
                    Color[] vColor = new Color[numPoints];
                    int i15 = 0;
                    while (i15 < numPoints) {
                        vColor[i15] = (Color)geomColor[7].elementAt(i15);
                        ++i15;
                    }
                    pointSet.setVertexColors(vColor);
                }
                this.m_geom[index] = pointSet;
                this.m_geom[index].setName("PointSet imported from Mathematica");
                ++index;
            }
            if (numArrows != 0) {
                PgJvxSrc vectorField = new PgJvxSrc();
                vectorField.setType(36);
                PgMathLoader.geomInitType(vectorField);
                vectorField.setDimOfVertices(this.m_dim);
                vectorField.setNumVertices(numArrows);
                vectorField.setNumVectorFields(1);
                vectorField.setNumVectors(0, numArrows, this.m_dim);
                PdVector[] vertices = new PdVector[numArrows];
                PdVector[] vectors = new PdVector[numArrows];
                i = 0;
                while (i < numArrows) {
                    vertices[i] = ((PdVector[])arrowVector.elementAt(i))[0];
                    vectors[i] = PdVector.subNew(((PdVector[])arrowVector.elementAt(i))[1], vertices[i]);
                    ++i;
                }
                vectorField.setVertices(vertices);
                vectorField.setVectors(0, vectors);
                vectorField.showVectorArrows(0, true);
                vectorField.setGlobalVectorColor(0, Color.black);
                this.m_geom[index] = vectorField;
                this.m_geom[index].setName("VectorField imported from Mathematica");
                ++index;
            }
            if (numPolygons != 0) {
                PgJvxSrc[] poly = new PgJvxSrc[numPolygons];
                int numPolygonVertices = 0;
                int i16 = 0;
                while (i16 < numPolygons) {
                    poly[i16] = (PgJvxSrc)polygonVector.elementAt(i16);
                    numPolygonVertices += poly[i16].getNumVertices();
                    ++i16;
                }
                PgJvxSrc polygonSet = new PgJvxSrc();
                polygonSet.setType(32);
                PgMathLoader.geomInitType(polygonSet);
                polygonSet.showVertices(false);
                polygonSet.setDimOfVertices(this.m_dim);
                polygonSet.setNumVertices(numPolygonVertices);
                int ind = 0;
                int i17 = 0;
                while (i17 < numPolygons) {
                    int num = poly[i17].getNumVertices();
                    PdVector[] pv = poly[i17].getVertices();
                    int j = 0;
                    while (j < num) {
                        polygonSet.setVertex(ind, pv[j]);
                        ++ind;
                        ++j;
                    }
                    ++i17;
                }
                polygonSet.setDimOfPolygons(-1);
                polygonSet.setNumPolygons(numPolygons);
                PiVector[] polygon = polygonSet.getPolygons();
                int nn = 0;
                int i18 = 0;
                while (i18 < numPolygons) {
                    int num = poly[i18].getNumVertices();
                    polygon[i18].setSize(num);
                    int j = 0;
                    while (j < num) {
                        polygon[i18].m_data[j] = j + nn;
                        ++j;
                    }
                    nn += num;
                    ++i18;
                }
                if (colorsDefined) {
                    Color[] psColor = new Color[numPolygons];
                    int i19 = 0;
                    while (i19 < numPolygons) {
                        psColor[i19] = (Color)geomColor[8].elementAt(i19);
                        ++i19;
                    }
                    polygonSet.setPolygonColors(psColor);
                }
                this.m_geom[index] = polygonSet;
                this.m_geom[index].setName("PgPolygonSet imported from Mathematica");
                ++index;
            }
            if (numCircles != 0) {
                PsDebug.warning(numCircles + " circles found in Mathematica graphics object. Circles get ignored in JavaView.");
            }
            if (numDisks != 0) {
                PsDebug.warning(numDisks + " discs found in Mathematica graphics object. Discs get ignored in JavaView.");
            }
            st.parseNumbers();
            st.pushBack();
            if (numGeom <= 0) {
                PsDebug.warning("No graphics found");
                return false;
            }
            this.graphicsVector.addElement(this.m_geom);
            return true;
        }
        catch (Exception e) {
            PsDebug.warning("Exception thrown: " + e + " Line: " + st.lineno());
            return false;
        }
    }

    private boolean parseVector(StreamTokenizer st, PdVector vec, int dimension) {
        vec.setSize(dimension);
        try {
            st.nextToken();
            int i = 0;
            while (i < dimension) {
                vec.m_data[i] = this.readNumber(st);
                st.nextToken();
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            PsDebug.warning("parseVector throw exception - st.ttype&sval:" + st.ttype + " " + st.sval);
            PsDebug.warning("Exception thrown: " + e + " Line: " + st.lineno());
            return false;
        }
    }

    public void setKeyAnimation(boolean flag) {
        this.m_isKeyAnimation = flag;
    }
}

