/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Component;
import java.awt.Image;
import java.awt.List;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import jv.anim.PsAnimation;
import jv.anim.PsKeyframe;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.loader.PgBdLoader;
import jv.loader.PgExport_Dialog;
import jv.loader.PgJvxLoader;
import jv.loader.PgLoaderIf;
import jv.loader.PgMapleLoader;
import jv.loader.PgMathLoader;
import jv.loader.PgObjLoader;
import jv.loader.PsXmlLoader;
import jv.loader.PvDisplayLoader;
import jv.loader.PvDisplayOption;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.objectGui.PsImage;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.thirdParty.acmeEncoders.GifEncoder;
import jv.thirdParty.acmeEncoders.ImageEncoder;
import jv.thirdParty.acmeEncoders.PpmEncoder;

public final class PgLoader {
    protected static boolean m_bShowAnimationPanel = true;
    protected static PvDisplayOption m_displayOption;
    protected static boolean m_bIsAnimation;
    protected static boolean m_bIsEnabledSmallSize;

    public static void setEnabledSmallSize(boolean flag) {
        m_bIsEnabledSmallSize = flag;
    }

    public static boolean saveDisplay(PvDisplayOption[] option, String fileName) {
        if (option == null) {
            PsDebug.warning("missing option to save.");
            return false;
        }
        if (fileName == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length());
        if (ext == null) {
            PsDebug.warning("missing extension in file name.");
            return false;
        }
        if (!ext.equalsIgnoreCase("jvd")) {
            PsDebug.warning("unknown option file ext = " + ext);
            return false;
        }
        String optionString = PvDisplayLoader.write(option);
        return PgLoader.save(optionString, fileName);
    }

    public static PgGeometry[] read(PgJvxSrc[] geomAnim, boolean bIsAnimation, boolean bShowAnimationPanel) {
        if (geomAnim == null || geomAnim.length == 0) {
            PsDebug.warning("missing geometry animation");
            return null;
        }
        int numKeys = geomAnim.length;
        PgJvxSrc[][] geomSrc = new PgJvxSrc[numKeys][1];
        int j = 0;
        while (j < numKeys) {
            geomSrc[j][0] = geomAnim[j];
            ++j;
        }
        return PgLoader.read(geomSrc, bIsAnimation, bShowAnimationPanel);
    }

    public static PgGeometry[] read(PgJvxSrc[][] geomAnim, boolean bIsAnimation, boolean bShowAnimationPanel) {
        if (geomAnim == null || geomAnim.length == 0) {
            PsDebug.warning("missing geometry animation");
            return null;
        }
        int numKeys = geomAnim.length;
        int numGeoms = geomAnim[0].length;
        PgGeometry[] geomArr = new PgGeometry[numGeoms];
        PsKeyframe[] keyframe = new PsKeyframe[numGeoms];
        int j = 0;
        while (j < numGeoms) {
            int geomType = geomAnim[0][j].getType();
            int dim = geomAnim[0][j].getDimOfVertices();
            keyframe[j] = new PsKeyframe();
            int i = 0;
            while (i < numKeys) {
                PgGeometry geom;
                if (geomType != geomAnim[i][j].getType()) {
                    PsDebug.warning("geometry type changes among key frames");
                    return null;
                }
                if (dim != geomAnim[i][j].getDimOfVertices()) {
                    PsDebug.warning("dimension of vertices changes among key frames");
                    return null;
                }
                switch (geomType) {
                    case 33: {
                        geom = new PgElementSet(dim);
                        break;
                    }
                    case 30: {
                        geom = new PgPointSet(dim);
                        break;
                    }
                    case 32: {
                        geom = new PgPolygonSet(dim);
                        break;
                    }
                    default: {
                        geom = geomAnim[i][j];
                    }
                }
                geom.setJvx(geomAnim[i][j]);
                double currTime = numKeys == 1 ? 0.0 : 100.0 * (double)i / ((double)numKeys - 1.0);
                keyframe[j].addKey(geom, currTime);
                ++i;
            }
            keyframe[j].setTime(0.0);
            geomArr[j] = keyframe[j].getDynamic();
            if (geomArr[j] != null) {
                geomArr[j].setName("Interpol[" + j + "]");
            }
            ++j;
        }
        PsAnimation anim = new PsAnimation();
        anim.setName("Keyframe Animation");
        int j2 = 0;
        while (j2 < numGeoms) {
            anim.addTimeListener(keyframe[j2]);
            ++j2;
        }
        anim.enableKeys(true);
        if (bShowAnimationPanel) {
            anim.getAnimationPanel().show();
        }
        if (bIsAnimation) {
            anim.setTimeInterval(0.0, 100.0, 100.0 / ((double)numKeys - 1.0), 100.0 / ((double)numKeys - 1.0));
        } else {
            anim.setTimeInterval(0.0, 100.0, 10.0 / ((double)numKeys - 1.0), 50.0 / ((double)numKeys - 1.0));
        }
        return geomArr;
    }

    public static String saveToString(PgGeometryIf[] geom, String ext) {
        if (geom == null || geom.length == 0) {
            PsDebug.warning("missing geometry to save.");
            return null;
        }
        if (ext == null) {
            PsDebug.warning("missing file name extension.");
            return null;
        }
        if (ext.equalsIgnoreCase("byu") || ext.equalsIgnoreCase("dxf") || ext.equalsIgnoreCase("fe") || ext.equalsIgnoreCase("mgs") || ext.equalsIgnoreCase("mpl") || ext.equalsIgnoreCase("obj") || ext.equalsIgnoreCase("off") || ext.equalsIgnoreCase("stl")) {
            if (geom.length > 1) {
                PsDebug.warning("only the active geometry of the scene is saved\n\tbecause restriction of the file format resp. export module\n\tUse JVX format to save more geometries in a single file.");
            }
            if ((ext.equalsIgnoreCase("byu") || ext.equalsIgnoreCase("stl")) && !(geom[0] instanceof PgJvxSrc) && !(geom[0] instanceof PgElementSet)) {
                PsDebug.warning("format does not save other geometries besides surfaces, ext = " + ext);
                return null;
            }
        }
        PgJvxSrc[] src = PgLoader.assureJvx(geom);
        StringWriter writer = new StringWriter();
        boolean bOk = false;
        if (ext.equalsIgnoreCase("mgs")) {
            try {
                PgMathLoader mathLoader = new PgMathLoader();
                bOk = mathLoader.write(writer, src);
                if (!bOk) {
                    PsDebug.warning("error during export.");
                    return null;
                }
            }
            catch (IOException ex) {
                PsDebug.warning("failed writing to writer,", ex);
            }
        } else {
            PgLoaderIf loader = PgLoader.getLoader(ext);
            if (loader == null) {
                PsDebug.warning("unknown file extension, no loader found");
                return null;
            }
            if (ext.equalsIgnoreCase("jvx")) {
                PgJvxLoader cfr_ignored_0 = (PgJvxLoader)loader;
                PgJvxLoader.setEnabledSmallSize(PgLoader.isEnabledSmallSize());
            }
            if (m_displayOption != null) {
                loader.setDisplayOption(m_displayOption);
            }
            try {
                bOk = loader.write(writer, src);
                if (!bOk) {
                    PsDebug.warning("error during export.");
                    return null;
                }
            }
            catch (IOException ex) {
                PsDebug.warning("failed writing to writer,", ex);
            }
        }
        return writer.toString();
    }

    public static boolean readAll(List list, String fileName) throws IOException {
        PsXmlNode models;
        if (fileName == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        PsXmlSrc src = PsXmlLoader.read(fileName);
        if (src == null) {
            PsDebug.warning("failed to read list from file = " + fileName, list);
            return false;
        }
        PsXmlNode root = src.getRootNode();
        if (root == null) {
            PsDebug.warning("missing root node when reading list from file = " + fileName, list);
            return false;
        }
        list.removeAll();
        PsXmlNode dirs = root.getChild("directories");
        if (dirs == null) {
            PsDebug.warning("directory contains no directory section, dir = " + fileName);
            return false;
        }
        PsXmlNode[] dirArr = dirs.getChildren("directory");
        if (dirArr != null) {
            PsDebug.message("directory contains no subdirectories, dir = " + fileName, false);
            int i = 0;
            while (i < dirArr.length) {
                PsXmlNode name = dirArr[i].getChild("name");
                if (name == null) {
                    PsDebug.warning("directory has no name, dir = " + fileName);
                }
                list.add(name.getContent());
                ++i;
            }
        }
        if ((models = root.getChild("models")) == null) {
            PsDebug.warning("directory contains no directory section, model = " + fileName);
            return false;
        }
        PsXmlNode[] modelArr = models.getChildren("model");
        if (modelArr != null) {
            int i = 0;
            while (i < modelArr.length) {
                list.add(modelArr[i].getContent());
                ++i;
            }
        }
        return true;
    }

    public static PvDisplayOption getDisplayOption() {
        return m_displayOption;
    }

    public static void setDisplayOption(PvDisplayOption option) {
        m_displayOption = option;
    }

    public static void setAnimation(boolean flag) {
        m_bIsAnimation = flag;
    }

    public static boolean isEnabledSmallSize() {
        return m_bIsEnabledSmallSize;
    }

    public static PgGeometry[] load(PgGeometry[] geom, String data, String ext) {
        if (data == null) {
            PsDebug.warning("missing argument: data");
            return null;
        }
        BufferedReader in = new BufferedReader(new StringReader(data));
        geom = PgLoader.load(geom, in, ext);
        try {
            in.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return geom;
    }

    public static PgGeometry[] load(String fileName) {
        if (fileName == null) {
            PsDebug.warning("missing fileName");
            return null;
        }
        return PgLoader.load(null, fileName);
    }

    public static PgGeometry[] load(PgGeometry[] geom, String fileName) {
        if (fileName == null) {
            PsDebug.warning("missing fileName");
            return null;
        }
        String ext = PsUtil.getFileExtension(fileName);
        if (ext == null) {
            PsDebug.warning("missing extension in file=" + fileName);
            return null;
        }
        PsDebug.notify("reading file = " + fileName);
        BufferedReader in = PsUtil.open(fileName);
        if (in == null) {
            PsDebug.warning("could not open file = " + fileName);
            return null;
        }
        geom = PgLoader.load(geom, in, ext);
        try {
            in.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (geom == null) {
            PsDebug.warning("error when reading file = " + fileName);
            return null;
        }
        int i = 0;
        while (i < geom.length) {
            if (geom[i] != null && (geom[i].getName() == null || geom[i].getName().startsWith("object_"))) {
                if (i == 0) {
                    geom[i].setName(PsUtil.getFileBaseName(fileName));
                } else {
                    geom[i].setName(PsUtil.getFileBaseName(fileName) + "[" + i + "]");
                }
            }
            ++i;
        }
        if (ext.indexOf("jvx") != -1) {
            i = 0;
            while (i < geom.length) {
                Image image;
                String texFile = geom[i].getTextureImageName();
                if (texFile != null && (image = PsImage.getImage(PsUtil.getFilePath(fileName) + texFile)) != null) {
                    if (!PsImage.loadImage(PsConfig.getFrame(), image)) {
                        PsDebug.warning("failed loading image = " + texFile);
                    } else {
                        geom[i].setTextureImage(image);
                    }
                }
                ++i;
            }
        }
        return geom;
    }

    /*
     * Unable to fully structure code
     */
    public static PgGeometry[] load(PgGeometry[] geom, BufferedReader in, String ext) {
        block40: {
            block41: {
                block39: {
                    if (in == null) {
                        PsDebug.warning("missing buffered reader");
                        return null;
                    }
                    if (ext == null) {
                        PsDebug.warning("missing format type");
                        return null;
                    }
                    PsDebug.notify("reading from reader");
                    ext = ext.toLowerCase();
                    PgLoader.setDisplayOption(null);
                    try {
                        if (!in.ready()) {
                            return null;
                        }
                    }
                    catch (Exception ex) {
                        PsDebug.warning("exception = " + ex.toString());
                        PsDebug.message("failed reading from reader.", false);
                        return null;
                    }
                    if (ext.indexOf("mgs") == -1) break block39;
                    loader = new PgMathLoader();
                    if (PgLoader.isAnimation()) {
                        loader.setKeyAnimation(PgLoader.isAnimation());
                    }
                    if ((jvxArr = loader.read(in)) == null || jvxArr.length == 0 || jvxArr[0] == null || jvxArr[0].length == 0) {
                        PsDebug.warning("reading failed");
                        return null;
                    }
                    PgLoader.setDisplayOption(loader.getDisplayOption());
                    if (loader.isAnimation() || loader.isKeyAnimation()) {
                        geom = PgLoader.read(jvxArr, loader.isAnimation(), PgLoader.m_bShowAnimationPanel);
                    } else {
                        geomSrc = jvxArr[0];
                        geom = PgLoader.assureLength(geom, geomSrc.length);
                        i = 0;
                        while (i < geomSrc.length) {
                            geom[i] = PgLoader.assureType(geom[i], geomSrc[i].getType(), geomSrc[i].getDimOfVertices());
                            geom[i].setJvx(geomSrc[i]);
                            ++i;
                        }
                    }
                    break block40;
                }
                if (ext.indexOf("mpl") == -1) break block41;
                loader = new PgMapleLoader();
                geomSrc = loader.read(in);
                if (geomSrc == null || geomSrc.length == 0) {
                    PsDebug.notify("reading failed");
                    return null;
                }
                if (loader.isAnimation()) {
                    geom = PgLoader.read(geomSrc, loader.isAnimation() == false, PgLoader.m_bShowAnimationPanel);
                } else {
                    geom = PgLoader.assureLength(geom, geomSrc.length);
                    i = 0;
                    while (i < geomSrc.length) {
                        geom[i] = PgLoader.assureType(geom[i], geomSrc[i].getType(), geomSrc[i].getDimOfVertices());
                        geom[i].setJvx(geomSrc[i]);
                        switch (geomSrc[i].getType()) {
                            case 30: {
                                vertGeom = (PgPointSet)geom[i];
                                vertGeom.makeVertexColorsFromXYZ();
                                vertGeom.showVertexColors(true);
                                break;
                            }
                            case 33: {
                                elemGeom = (PgElementSet)geom[i];
                                elemGeom.makeElementColorsFromXYZ();
                                elemGeom.showElementColors(true);
                                break;
                            }
                            case 32: {
                                polyGeom = (PgPolygonSet)geom[i];
                                polyGeom.makePolygonColorsFromXYZ();
                                polyGeom.showPolygonColors(true);
                                break;
                            }
                        }
                        ++i;
                    }
                }
                break block40;
            }
            if (ext.indexOf("obj") == -1 && ext.indexOf("edg") == -1) ** GOTO lbl97
            loader = new PgObjLoader();
            geomArr = loader.read(in);
            geomSrc = geomArr[0];
            if (geomSrc != null) {
                geom = PgLoader.assureLength(geom, 1);
                geom[0] = PgLoader.assureType(geom[0], geomSrc.getType(), geomSrc.getDimOfVertices());
                geom[0].setJvx(geomSrc);
                switch (geomSrc.getType()) {
                    case 33: {
                        elemSet = (PgElementSet)geom[0];
                        meshType = loader.m_meshType;
                        if (loader.m_numMeshType > 0 && meshType[0] == 1 && meshType[1] == 2) {
                            elemSet.makeQuadrConn(meshType[3], meshType[2]);
                            break;
                        }
                        elemSet.makeNeighbour();
                        break;
                    }
                }
            } else {
                PsDebug.notify("reading failed");
                return null;
lbl97:
                // 1 sources

                if (ext.indexOf("jvd") != -1) {
                    PsDebug.warning("use method PgLoader.loadDisplay(..) to load a display configuration.");
                    return null;
                }
                if (ext.indexOf("bd") != -1) {
                    loader = (PgBdLoader)PgLoader.getLoader(ext);
                    geomSrc = loader.readElementSet(in);
                    if (geomSrc == null || geomSrc.length == 0) {
                        PsDebug.notify("reading failed");
                        return null;
                    }
                    i = 0;
                    while (i < geomSrc.length) {
                        geomSrc[i].makeNeighbour();
                        ++i;
                    }
                    geom = PgLoader.assureLength(geomSrc, geomSrc.length);
                } else {
                    loader = PgLoader.getLoader(ext);
                    if (loader == null) {
                        PsDebug.warning("unknown file extension, no loader found");
                        return null;
                    }
                    geomSrc = loader.read(in);
                    if (geomSrc == null || geomSrc.length == 0) {
                        PsDebug.notify("reading failed");
                        return null;
                    }
                    PgLoader.setDisplayOption(loader.getDisplayOption());
                    if (loader.isAnimation()) {
                        geom = PgLoader.read(geomSrc, false, PgLoader.m_bShowAnimationPanel);
                    } else {
                        geom = PgLoader.assureLength(geom, geomSrc.length);
                        i = 0;
                        while (i < geomSrc.length) {
                            geom[i] = PgLoader.assureType(geom[i], geomSrc[i].getType(), geomSrc[i].getDimOfVertices());
                            geom[i].setJvx(geomSrc[i]);
                            if (!ext.equalsIgnoreCase("jvx")) {
                                switch (geomSrc[i].getType()) {
                                    case 33: {
                                        elemSet = (PgElementSet)geom[i];
                                        elemSet.makeNeighbour();
                                        break;
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                }
            }
        }
        return geom;
    }

    public static PvDisplayOption[] load(BufferedReader in, String ext) {
        PsDebug.warning("usage of deprecated method.");
        return PgLoader.loadDisplay(in, ext);
    }

    public static boolean readDirs(List list, String fileName) throws IOException {
        if (fileName == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        list.removeAll();
        list.add("..");
        String[] dirName = PgLoader.readDirs(fileName);
        if (dirName != null) {
            int i = 0;
            while (i < dirName.length) {
                list.add(dirName[i]);
                ++i;
            }
        }
        return true;
    }

    public static String[] readDirs(String fileName) throws IOException {
        if (fileName == null) {
            PsDebug.warning("missing fileName");
            return null;
        }
        PsXmlSrc src = PsXmlLoader.read(fileName);
        if (src == null) {
            PsDebug.warning("failed to read list from file = " + fileName);
            return null;
        }
        PsXmlNode root = src.getRootNode();
        if (root == null) {
            PsDebug.warning("could not read list from file = " + fileName);
            return null;
        }
        PsXmlNode dirs = root.getChild("directories");
        if (dirs == null) {
            PsDebug.warning("directory contains no directory section, dir = " + fileName);
            return null;
        }
        PsXmlNode[] dirArr = dirs.getChildren("directory");
        if (dirArr == null) {
            return null;
        }
        String[] dirName = new String[dirArr.length];
        int i = 0;
        while (i < dirArr.length) {
            PsXmlNode name = dirArr[i].getChild("name");
            if (name == null) {
                PsDebug.warning("directory has no name, dir = " + fileName);
            }
            dirName[i] = name.getContent();
            ++i;
        }
        return dirName;
    }

    static {
        m_bIsAnimation = false;
        m_bIsEnabledSmallSize = false;
    }

    public static boolean save(PgGeometryIf[] geom, String fileName) {
        if (geom == null) {
            PsDebug.warning("missing geometries");
            return false;
        }
        if (fileName == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        String ext = PsUtil.getFileExtension(fileName);
        if (ext == null) {
            PsDebug.warning("missing extension in file name.");
            return false;
        }
        ext = ext.toLowerCase();
        String dirName = null;
        String baseName = null;
        int i = 0;
        while (i < geom.length) {
            if (geom[i].isVisible()) {
                if (dirName == null) {
                    dirName = PsUtil.getFilePath(fileName);
                    baseName = PsUtil.getFileBaseName(fileName);
                }
                if (dirName == null || baseName == null) {
                    PsDebug.warning("unable to extract path or base name of file name = " + fileName);
                    break;
                }
                Image textureImage = geom[i].getTextureImage();
                if (textureImage != null) {
                    String textureName;
                    if (!ext.equalsIgnoreCase("jvx")) {
                        PsDebug.warning("geometry format does not know about texture. Texture saved anyway.");
                    }
                    if ((textureName = geom[i].getTextureImageName()) == null) {
                        textureName = baseName + "_" + geom[i].getName() + ".gif";
                        geom[i].setTextureImageName(textureName);
                    } else {
                        if (!(textureName = PsUtil.getFileName(textureName)).endsWith(".gif")) {
                            PsDebug.warning("currently, texture is always saved in GIF format.");
                            textureName = textureName + ".gif";
                        }
                        geom[i].setTextureImageName(textureName);
                    }
                    String textureFile = dirName + textureName;
                    PgLoader.save(textureImage, textureFile);
                }
            }
            ++i;
        }
        if (PsConfig.isApplication()) {
            PgJvxSrc[] src = PgLoader.assureJvx(geom);
            PrintWriter writer = PsUtil.writeFile(fileName);
            if (writer == null) {
                PsDebug.warning("could not open file = " + fileName);
                return false;
            }
            boolean bOk = false;
            if (ext.equalsIgnoreCase("mgs")) {
                try {
                    PgMathLoader mathLoader = new PgMathLoader();
                    bOk = mathLoader.write(writer, src);
                    if (!bOk) {
                        PsDebug.warning("error during export.");
                        writer.close();
                        return false;
                    }
                }
                catch (IOException ex) {
                    PsDebug.warning("failed writing to writer,", ex);
                }
            } else {
                PgLoaderIf loader = PgLoader.getLoader(ext);
                if (loader == null) {
                    PsDebug.warning("unknown file extension, no loader found");
                    writer.close();
                    return false;
                }
                if (m_displayOption != null) {
                    loader.setDisplayOption(m_displayOption);
                }
                if (ext.equalsIgnoreCase("jvx")) {
                    PgJvxLoader cfr_ignored_0 = (PgJvxLoader)loader;
                    PgJvxLoader.setEnabledSmallSize(PgLoader.isEnabledSmallSize());
                }
                try {
                    bOk = loader.write(writer, src);
                    if (!bOk) {
                        PsDebug.warning("error during export.");
                    }
                }
                catch (IOException ex) {
                    PsDebug.warning("failed writing to writer,", ex);
                }
            }
            writer.close();
            return bOk;
        }
        String data = PgLoader.saveToString(geom, ext);
        if (data == null) {
            PsDebug.warning("error during export.");
            return false;
        }
        return PgLoader.save(data, fileName);
    }

    public static boolean save(String data, String fileName) {
        if (data == null) {
            PsDebug.warning("missing data to save.");
            return false;
        }
        if (fileName == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        if (PsConfig.isApplication()) {
            PrintWriter writer = PsUtil.writeFile(fileName);
            if (writer == null) {
                PsDebug.warning("could not open file = " + fileName);
                return false;
            }
            PsDebug.notify("writing = " + fileName);
            writer.println(data);
            writer.close();
        } else {
            PgExport_Dialog expDialog = new PgExport_Dialog(PsConfig.getFrame(), "JavaView " + PsConfig.getMessage("Export"), false);
            String ext = PsUtil.getFileExtension(fileName);
            if (ext != null) {
                expDialog.setFilenameExtension(ext);
            }
            expDialog.setText(data);
            ((Component)expDialog).setVisible(true);
        }
        return true;
    }

    public static boolean save(PvDisplayOption[] option, String fileName) {
        PsDebug.warning("usage of deprecated method.");
        return PgLoader.saveDisplay(option, fileName);
    }

    public static boolean save(Image image, String fileName) {
        if (image == null) {
            PsDebug.warning("missing image to save.");
            return false;
        }
        if (fileName == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length());
        if (ext == null) {
            PsDebug.warning("missing extension in file name.");
            return false;
        }
        if (!ext.equalsIgnoreCase("gif") && !ext.equalsIgnoreCase("ppm")) {
            PsDebug.warning("unknown image file ext = " + ext);
            return false;
        }
        try {
            FileOutputStream out = new FileOutputStream(fileName);
            if (out == null) {
                PsDebug.warning("could not open file = " + fileName);
                return false;
            }
            ImageEncoder encoder = null;
            if (ext.equalsIgnoreCase("gif")) {
                encoder = new GifEncoder(image, (OutputStream)out);
            } else if (ext.equalsIgnoreCase("ppm")) {
                encoder = new PpmEncoder(image, (OutputStream)out);
            }
            if (encoder == null) {
                PsDebug.warning("Failed to create an encoder, ext = " + ext + "\n\t file = " + fileName);
                return false;
            }
            encoder.encode();
            out.flush();
            out.close();
        }
        catch (IOException e) {
            PsDebug.error("Failed to save image: Exception = " + e.toString() + "\n\t file = " + fileName);
            return false;
        }
        return true;
    }

    public static double parseDouble(StreamTokenizer st) throws IOException {
        st.nextToken();
        if (st.ttype != -2) {
            PsDebug.warning("called with tokenType different to TT_NUMBER, st = " + st.toString());
            return 0.0;
        }
        double value = st.nval;
        if (st.nextToken() != -3 || !st.sval.startsWith("e") && !st.sval.startsWith("E")) {
            st.pushBack();
            return value;
        }
        if (st.sval.equals("e") || st.sval.equals("E")) {
            double exp;
            st.nextToken();
            if (st.ttype == 43) {
                st.nextToken();
                exp = st.nval;
            } else if (st.ttype == 45) {
                st.nextToken();
                exp = -st.nval;
            } else {
                exp = st.nval;
            }
            if (st.ttype != -2) {
                PsDebug.warning("Number expected.");
                return 0.0;
            }
            return value * Math.pow(10.0, exp);
        }
        String expr = "1." + st.sval;
        return value * Double.valueOf(expr);
    }

    public static boolean isAnimation() {
        return m_bIsAnimation;
    }

    private static PgGeometry assureType(PgGeometry geom, int type, int dim) {
        if (geom != null && geom.getDimOfVertices() != dim) {
            geom = null;
        }
        switch (type) {
            case 32: {
                if (geom != null && geom instanceof PgPolygonSet) break;
                PsDebug.notify("argument geom is incompatible with file geom,\n\tand replaced with PgPolygonSet object");
                geom = new PgPolygonSet(dim);
                break;
            }
            case 33: {
                if (geom != null && geom instanceof PgElementSet) break;
                PsDebug.notify("argument geom is incompatible with file geom,\n\tand replaced with PgElementSet object");
                geom = new PgElementSet(dim);
                break;
            }
            default: {
                if (geom != null && geom instanceof PgPointSet) break;
                PsDebug.notify("argument geom is incompatible with file geom,\n\tand replaced with PgPointSet object");
                geom = new PgPointSet(dim);
            }
        }
        return geom;
    }

    private static PgLoaderIf getLoader(String ext) {
        if (ext.endsWith(".gz") || ext.endsWith(".zip")) {
            ext = ext.substring(0, ext.lastIndexOf("."));
        }
        String id = String.valueOf(ext.charAt(0)).toUpperCase() + ext.substring(1, ext.length());
        String loaderName = "Pg" + id + "Loader";
        PgLoaderIf loader = null;
        if (ext.equalsIgnoreCase("mpl")) {
            loader = new PgMapleLoader();
        } else {
            loader = (PgLoaderIf)PsUtil.newInstance("jv.loader." + loaderName);
            if (loader == null) {
                loader = (PgLoaderIf)PsUtil.newInstance("jvx.loader." + loaderName);
            }
        }
        return loader;
    }

    private static PgJvxSrc[] assureJvx(PgGeometryIf[] geom) {
        PgJvxSrc[] src = new PgJvxSrc[geom.length];
        int i = 0;
        while (i < geom.length) {
            if (geom[i] == null) {
                PsDebug.warning("missing geometry at index i = " + i);
            } else if (geom[i] instanceof PgJvxSrc) {
                src[i] = (PgJvxSrc)geom[i];
            } else {
                src[i] = geom[i].getJvx();
                if (src[i] == null) {
                    PsDebug.warning("failed to create jvx source of geom = " + geom[i].getName());
                }
            }
            ++i;
        }
        return src;
    }

    public static double parseDouble(String string) {
        try {
            return new Double(string);
        }
        catch (NumberFormatException e) {
            PsDebug.warning("wrong format = " + string);
            return 0.0;
        }
    }

    public static PvDisplayOption[] loadDisplay(BufferedReader in, String ext) {
        if (in == null) {
            PsDebug.warning("missing buffered reader");
            return null;
        }
        if (ext == null) {
            PsDebug.warning("missing format type");
            return null;
        }
        if (ext.indexOf("jvd") == -1) {
            PsDebug.warning("wrong format for display options, ext = " + ext);
            return null;
        }
        PsDebug.notify("reading from reader");
        ext = ext.toLowerCase();
        try {
            if (!in.ready()) {
                PsDebug.notify("reader not ready");
                return null;
            }
        }
        catch (IOException ex) {
            PsDebug.warning("exception = " + ex.toString());
            PsDebug.message("failed reading from reader.", false);
            return null;
        }
        PvDisplayOption[] option = PvDisplayLoader.read(in);
        if (option == null || option.length == 0) {
            PsDebug.warning("reading of display from reader");
            return null;
        }
        PgLoader.setDisplayOption(option[0]);
        return option;
    }

    public static void showAnimationPanel(boolean flag) {
        m_bShowAnimationPanel = flag;
    }

    private static PgGeometry[] assureLength(PgGeometry[] geom, int length) {
        if (geom == null) {
            return new PgGeometry[length];
        }
        if (length == geom.length) {
            return geom;
        }
        PgGeometry[] newGeom = new PgGeometry[length];
        int i = 0;
        while (i < Math.min(length, geom.length)) {
            newGeom[i] = geom[i];
            ++i;
        }
        return newGeom;
    }
}

