/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import jv.geom.PgPointSet;
import jv.number.PdArray_IP;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;

public class PgPointSet_IP
extends PsPanel
implements ActionListener,
TextListener {
    protected PgPointSet m_pointSet;
    protected TextField m_tName;
    protected TextField m_tNumVertices;
    protected PdArray_IP m_vertexPanel;
    private int m_maxVisibleVectors = 5;
    private int m_maxVisibleDim = 5;
    private static String[] m_header = new String[]{"X", "Y", "Z", "W", "V"};
    protected boolean m_bInteractive = true;
    private static /* synthetic */ Class class$jv$geom$PgPointSet_IP;

    public PgPointSet_IP() {
        if (this.getClass() == (class$jv$geom$PgPointSet_IP != null ? class$jv$geom$PgPointSet_IP : (class$jv$geom$PgPointSet_IP = PgPointSet_IP.class$("jv.geom.PgPointSet_IP")))) {
            this.init();
        }
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_pointSet = (PgPointSet)parent;
    }

    public boolean update(Object anObject) {
        PsDebug.notify("called");
        if (this.m_pointSet == null) {
            PsDebug.warning("missing pointSet");
            return true;
        }
        if (anObject == this.m_pointSet) {
            ((TextComponent)this.m_tName).setText(this.m_pointSet.getName());
            this.m_bInteractive = false;
            ((TextComponent)this.m_tNumVertices).setText(String.valueOf(this.m_pointSet.getNumVertices()));
            this.m_bInteractive = true;
            this.m_vertexPanel.setVector(this.m_pointSet.getVertices(), m_header, this.m_pointSet.getNumVertices(), this.m_pointSet.getDimOfVertices());
            return true;
        }
        if (anObject == this.m_vertexPanel) {
            this.m_pointSet.update(this);
            return true;
        }
        return super.update(anObject);
    }

    public void actionPerformed(ActionEvent event) {
        PsDebug.notify("entered");
        Object source = event.getSource();
        if (source == this.m_tNumVertices) {
            String text = this.m_tNumVertices.getText();
            if (text == null || text.equals("")) {
                return;
            }
            try {
                int num = Integer.parseInt(text);
                if (num != this.m_pointSet.getNumVertices()) {
                    PsDebug.notify("setNumVertices=" + text);
                    this.m_pointSet.setNumVertices(num);
                    this.m_vertexPanel.setVector(this.m_pointSet.getVertices(), m_header, num, this.m_pointSet.getDimOfVertices());
                }
                this.m_pointSet.update(this);
            }
            catch (NumberFormatException e) {
                PsDebug.warning("wrong format = " + text, this);
                return;
            }
        } else if (source == this.m_tName) {
            this.m_pointSet.setName(this.m_tName.getText());
            this.m_pointSet.update(this);
        }
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setBorderType(3);
        this.addTitle(PsConfig.getMessage("mInspector"));
        Panel pName = new Panel();
        pName.setLayout(new GridLayout(1, 2));
        Label lName = new Label(PsConfig.getMessage("lName"));
        pName.add(lName);
        this.m_tName = new TextField("", 7);
        this.m_tName.addActionListener(this);
        pName.add(this.m_tName);
        this.add(pName);
        this.addLine(1);
        Panel pNumVertices = new Panel();
        pNumVertices.setLayout(new GridLayout(1, 2));
        this.add(pNumVertices);
        Label lNumVertices = new Label(PsConfig.getMessage("lNumVertices"));
        pNumVertices.add(lNumVertices);
        this.m_tNumVertices = new TextField("0", 7);
        this.m_tNumVertices.addTextListener(this);
        this.m_tNumVertices.addActionListener(this);
        pNumVertices.add(this.m_tNumVertices);
        this.m_vertexPanel = new PdArray_IP(this.m_maxVisibleVectors, this.m_maxVisibleDim);
        this.m_vertexPanel.setParent(this);
        this.add(this.m_vertexPanel);
    }

    public void textValueChanged(TextEvent event) {
        PsDebug.notify("entered");
        if (!this.m_bInteractive) {
            return;
        }
        Object source = event.getSource();
        if (source == this.m_tNumVertices) {
            try {
                int num = Integer.parseInt(this.m_tNumVertices.getText());
                if (num != this.m_pointSet.getNumVertices()) {
                    PsDebug.notify("setNumVertices=" + this.m_tNumVertices.getText());
                    this.m_pointSet.setNumVertices(num);
                    this.m_vertexPanel.setVector(this.m_pointSet.getVertices(), m_header, num, this.m_pointSet.getDimOfVertices());
                }
                this.m_pointSet.update(this);
            }
            catch (NumberFormatException e) {
                PsDebug.warning("wrong format = " + this.m_tNumVertices.getText(), this);
                return;
            }
        }
    }
}

