/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.acmeEncoders;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

public abstract class ImageEncoder
implements ImageConsumer {
    protected OutputStream out;
    private ImageProducer producer = null;
    private int width = -1;
    private int height = -1;
    private int hintflags = 0;
    private boolean started = false;
    private boolean encoding;
    private IOException iox;
    private static final ColorModel rgbModel = ColorModel.getRGBdefault();
    private Hashtable props = null;
    private Image image = null;
    private boolean wrongColorModel = false;
    private int alpha = 3;
    private int red = 16;
    private int green = 8;
    private int blue = 0;
    private boolean accumulate = false;
    private int[] accumulator;

    private void encodePixelsWrapper(int x, int y, int w, int h, int[] rgbPixels, int off, int scansize) throws IOException {
        if (!this.started) {
            this.started = true;
            this.encodeStart(this.width, this.height);
            if ((this.hintflags & 2) == 0) {
                this.accumulate = true;
                this.accumulator = new int[this.width * this.height];
            }
        }
        if (this.accumulate) {
            int row = 0;
            while (row < h) {
                System.arraycopy(rgbPixels, row * scansize + off, this.accumulator, (y + row) * this.width + x, w);
                ++row;
            }
        } else {
            this.encodePixels(x, y, w, h, rgbPixels, off, scansize);
        }
    }

    private synchronized void stop() {
        this.encoding = false;
        this.notifyAll();
    }

    public void setHints(int hintflags) {
        this.hintflags = hintflags;
    }

    public ImageEncoder(Image img, OutputStream out) throws IOException {
        this(img.getSource(), out);
        this.image = img;
    }

    public ImageEncoder(ImageProducer producer, OutputStream out) throws IOException {
        this.producer = producer;
        this.out = out;
    }

    abstract void encodeDone() throws IOException;

    public synchronized void encode() throws IOException {
        this.encoding = true;
        this.iox = null;
        Graphics grx = null;
        if (this.image != null) {
            try {
                grx = this.image.getGraphics();
            }
            catch (ClassCastException ex) {
                // empty catch block
            }
        }
        if (grx != null) {
            PixelGrabber pg = new PixelGrabber(this.image, 0, 0, 1, 1, false);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException e) {
                throw new IOException("interrupted waiting for pixels!");
            }
            if ((pg.getStatus() & 0x80) != 0) {
                throw new IOException("image fetch aborted or errored");
            }
            Object o = pg.getPixels();
            int origpix = o instanceof int[] ? ((int[])o)[0] : ((byte[])o)[0];
            Graphics gr = this.image.getGraphics();
            if (gr != null) {
                gr.setColor(new Color(4, 2, 1));
                gr.drawLine(0, 0, 0, 0);
            }
            pg = new PixelGrabber(this.image, 0, 0, 1, 1, false);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException e) {
                throw new IOException("interrupted waiting for pixels!");
            }
            if ((pg.getStatus() & 0x80) != 0) {
                throw new IOException("image fetch aborted or errored");
            }
            o = pg.getPixels();
            int pix = 0;
            pix = o instanceof byte[] ? ((byte[])o)[0] : ((int[])o)[0];
            ColorModel m = pg.getColorModel();
            int r = m.getRed(pix);
            int g = m.getGreen(pix);
            int b = m.getBlue(pix);
            if (r != 4 || g != 2 || b != 1) {
                this.red = -1;
                this.green = -1;
                this.blue = -1;
                int i = 0;
                while (i < 4) {
                    int t = pix >> i * 8 & 0xFF;
                    if (t == 4) {
                        this.red = i * 8;
                    } else if (t == 2) {
                        this.green = i * 8;
                    } else if (t == 1) {
                        this.blue = i * 8;
                    }
                    ++i;
                }
                if (this.red != -1 && this.green != -1 && this.blue != -1) {
                    this.wrongColorModel = true;
                }
            }
            if (gr != null) {
                gr.setColor(new Color(this.getCorrectRGB(origpix, m)));
                gr.drawLine(0, 0, 0, 0);
            }
        }
        this.producer.startProduction(this);
        while (this.encoding) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.iox != null) {
            throw this.iox;
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int[] rgbPixels = new int[w];
        int row = 0;
        while (row < h) {
            int rowOff = off + row * scansize;
            int col = 0;
            while (col < w) {
                rgbPixels[col] = model.getRGB(pixels[rowOff + col] & 0xFF);
                ++col;
            }
            try {
                this.encodePixelsWrapper(x, y + row, w, 1, rgbPixels, 0, w);
            }
            catch (IOException e) {
                this.iox = e;
                this.stop();
                return;
            }
            ++row;
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (model == rgbModel && !this.wrongColorModel) {
            try {
                this.encodePixelsWrapper(x, y, w, h, pixels, off, scansize);
            }
            catch (IOException e) {
                this.iox = e;
                this.stop();
                return;
            }
        }
        int[] rgbPixels = new int[w];
        int row = 0;
        while (row < h) {
            int rowOff = off + row * scansize;
            int col = 0;
            while (col < w) {
                rgbPixels[col] = this.wrongColorModel ? this.getCorrectRGB(pixels[rowOff + col], model) : model.getRGB(pixels[rowOff + col]);
                ++col;
            }
            try {
                this.encodePixelsWrapper(x, y + row, w, 1, rgbPixels, 0, w);
            }
            catch (IOException e) {
                this.iox = e;
                this.stop();
                return;
            }
            ++row;
        }
    }

    abstract void encodeStart(int var1, int var2) throws IOException;

    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setProperties(Hashtable props) {
        this.props = props;
    }

    private int getCorrectRGB(int col, ColorModel model) {
        int back = 0;
        back += (col >> this.red & 0xFF) << 16;
        back += (col >> this.green & 0xFF) << 8;
        back += col >> this.blue & 0xFF;
        return back += model.getAlpha(col) << 24;
    }

    private void encodeFinish() throws IOException {
        if (this.accumulate) {
            this.encodePixels(0, 0, this.width, this.height, this.accumulator, 0, this.width);
            this.accumulator = null;
            this.accumulate = false;
        }
    }

    public void imageComplete(int status) {
        this.producer.removeConsumer(this);
        if (status == 4) {
            this.iox = new IOException("image aborted");
        } else {
            try {
                this.encodeFinish();
                this.encodeDone();
            }
            catch (IOException e) {
                this.iox = e;
            }
        }
        this.stop();
    }

    public void setColorModel(ColorModel model) {
    }

    abstract void encodePixels(int var1, int var2, int var3, int var4, int[] var5, int var6, int var7) throws IOException;
}

