/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.acmeEncoders;

import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import jv.thirdParty.acmeEncoders.GifEncoderHashitem;
import jv.thirdParty.acmeEncoders.GifEncoderOcBlock;
import jv.thirdParty.acmeEncoders.ImageEncoder;
import jv.thirdParty.acmeEncoders.IntHashtable;

public class GifEncoder
extends ImageEncoder {
    private boolean interlace = false;
    int width;
    int height;
    int[][] rgbPixels;
    IntHashtable colorHash;
    int Width;
    int Height;
    boolean Interlace;
    int curx;
    int cury;
    int CountDown;
    int Pass = 0;
    static final int EOF = -1;
    static final int BITS = 12;
    static final int HSIZE = 5003;
    int n_bits;
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int[] htab = new int[5003];
    int[] codetab = new int[5003];
    int hsize = 5003;
    int free_ent = 0;
    boolean clear_flg = false;
    int g_init_bits;
    int ClearCode;
    int EOFCode;
    int cur_accum = 0;
    int cur_bits = 0;
    int[] masks;
    int a_count;
    byte[] accum;

    private boolean setVariance(GifEncoderOcBlock block, GifEncoderHashitem[] colors, int blockindex) {
        int num = colors.length;
        block.cr = 0.0;
        block.cg = 0.0;
        block.cb = 0.0;
        block.count = 0;
        int count = 0;
        int i = 0;
        while (i < num) {
            GifEncoderHashitem item = colors[i];
            if (item.red >= block.pr && item.green >= block.pg && item.blue >= block.pb && item.red <= block.qr && item.green <= block.qg && item.blue <= block.qb) {
                item.index = blockindex;
                ++count;
                block.cr += (double)item.red;
                block.cg += (double)item.green;
                block.cb += (double)item.blue;
                block.count += item.count;
            }
            ++i;
        }
        if (count == 0) {
            return false;
        }
        block.cr /= (double)count;
        block.cg /= (double)count;
        block.cb /= (double)count;
        double variance = 0.0;
        int i2 = 0;
        while (i2 < num) {
            GifEncoderHashitem item = colors[i2];
            if (item.red >= block.pr && item.green >= block.pg && item.blue >= block.pb && item.red <= block.qr && item.green <= block.qg && item.blue <= block.qb) {
                double a = (double)item.red - block.cr;
                double b = (double)item.green - block.cg;
                double c = (double)item.blue - block.cb;
                variance += (a * a + b * b + c * c) * (double)item.count;
            }
            ++i2;
        }
        block.var = variance /= (double)count;
        return true;
    }

    void output(int code, OutputStream outs) throws IOException {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= code << this.cur_bits) : code;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF), outs);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.MAXCODE(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
            }
        }
        if (code == this.EOFCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF), outs);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char(outs);
        }
    }

    void char_init() {
        this.a_count = 0;
    }

    void char_out(byte c, OutputStream outs) throws IOException {
        this.accum[this.a_count++] = c;
        if (this.a_count >= 254) {
            this.flush_char(outs);
        }
    }

    int GIFNextPixel() throws IOException {
        if (this.CountDown == 0) {
            return -1;
        }
        this.CountDown += -1;
        byte r = this.GetPixel(this.curx, this.cury);
        this.BumpPixel();
        return r & 0xFF;
    }

    public GifEncoder(Image img, OutputStream out) throws IOException {
        super(img, out);
        int[] nArray = new int[17];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        nArray[8] = 255;
        nArray[9] = 511;
        nArray[10] = 1023;
        nArray[11] = 2047;
        nArray[12] = 4095;
        nArray[13] = 8191;
        nArray[14] = 16383;
        nArray[15] = Short.MAX_VALUE;
        nArray[16] = 65535;
        this.masks = nArray;
        this.accum = new byte[256];
    }

    public GifEncoder(Image img, OutputStream out, boolean interlace) throws IOException {
        super(img, out);
        int[] nArray = new int[17];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        nArray[8] = 255;
        nArray[9] = 511;
        nArray[10] = 1023;
        nArray[11] = 2047;
        nArray[12] = 4095;
        nArray[13] = 8191;
        nArray[14] = 16383;
        nArray[15] = Short.MAX_VALUE;
        nArray[16] = 65535;
        this.masks = nArray;
        this.accum = new byte[256];
        this.interlace = interlace;
    }

    public GifEncoder(ImageProducer prod, OutputStream out) throws IOException {
        super(prod, out);
        int[] nArray = new int[17];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        nArray[8] = 255;
        nArray[9] = 511;
        nArray[10] = 1023;
        nArray[11] = 2047;
        nArray[12] = 4095;
        nArray[13] = 8191;
        nArray[14] = 16383;
        nArray[15] = Short.MAX_VALUE;
        nArray[16] = 65535;
        this.masks = nArray;
        this.accum = new byte[256];
    }

    public GifEncoder(ImageProducer prod, OutputStream out, boolean interlace) throws IOException {
        super(prod, out);
        int[] nArray = new int[17];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        nArray[8] = 255;
        nArray[9] = 511;
        nArray[10] = 1023;
        nArray[11] = 2047;
        nArray[12] = 4095;
        nArray[13] = 8191;
        nArray[14] = 16383;
        nArray[15] = Short.MAX_VALUE;
        nArray[16] = 65535;
        this.masks = nArray;
        this.accum = new byte[256];
        this.interlace = interlace;
    }

    void encodeDone() throws IOException {
        int transparentIndex = -1;
        int transparentRgb = -1;
        this.colorHash = new IntHashtable();
        int index = 0;
        int row = 0;
        while (row < this.height) {
            int col = 0;
            while (col < this.width) {
                GifEncoderHashitem item;
                boolean isTransparent;
                int rgb = this.rgbPixels[row][col];
                boolean bl = isTransparent = rgb >>> 24 < 128;
                if (isTransparent) {
                    if (transparentIndex < 0) {
                        transparentIndex = index;
                        transparentRgb = rgb;
                    } else if (rgb != transparentRgb) {
                        this.rgbPixels[row][col] = rgb = transparentRgb;
                    }
                }
                if ((item = (GifEncoderHashitem)this.colorHash.get(rgb)) == null) {
                    item = new GifEncoderHashitem(rgb, 1, index, isTransparent);
                    ++index;
                    this.colorHash.put(rgb, (Object)item);
                } else {
                    ++item.count;
                }
                ++col;
            }
            ++row;
        }
        if (index > 256) {
            GifEncoderHashitem[] colors = new GifEncoderHashitem[index];
            int count = 0;
            Enumeration e = this.colorHash.elements();
            while (e.hasMoreElements()) {
                GifEncoderHashitem item = (GifEncoderHashitem)e.nextElement();
                item.index = 0;
                colors[count] = item;
                ++count;
            }
            Vector<GifEncoderOcBlock> blocks = new Vector<GifEncoderOcBlock>(256);
            GifEncoderOcBlock block = new GifEncoderOcBlock(0, 0, 0, 255, 255, 255);
            this.setVariance(block, colors, 0);
            blocks.addElement(block);
            int numcolors = 1;
            int refine = 0;
            while (numcolors < 249) {
                boolean first = true;
                block = (GifEncoderOcBlock)blocks.elementAt(refine);
                int i = 0;
                while (i < 8) {
                    int qb;
                    int pb;
                    int qg;
                    int pg;
                    int qr;
                    int pr;
                    if (i < 4) {
                        pr = block.pr;
                        qr = block.pr + (block.qr - block.pr + 1) / 2 - 1;
                    } else {
                        pr = block.pr + (block.qr - block.pr + 1) / 2;
                        qr = block.qr;
                    }
                    if (i % 2 == 0) {
                        pg = block.pg;
                        qg = block.pg + (block.qg - block.pg + 1) / 2 - 1;
                    } else {
                        pg = block.pg + (block.qg - block.pg + 1) / 2;
                        qg = block.qg;
                    }
                    if (i == 0 || i == 1 || i == 4 || i == 5) {
                        pb = block.pb;
                        qb = block.pb + (block.qb - block.pb + 1) / 2 - 1;
                    } else {
                        pb = block.pb + (block.qb - block.pb + 1) / 2;
                        qb = block.qb;
                    }
                    GifEncoderOcBlock n = new GifEncoderOcBlock(pr, pg, pb, qr, qg, qb);
                    int k = first ? refine : numcolors;
                    if (this.setVariance(n, colors, k)) {
                        if (first) {
                            blocks.setElementAt(n, refine);
                            first = false;
                        } else {
                            blocks.addElement(n);
                            ++numcolors;
                        }
                    }
                    ++i;
                }
                double maxvar = ((GifEncoderOcBlock)blocks.elementAt((int)0)).var;
                refine = 0;
                int i2 = 1;
                while (i2 < numcolors) {
                    double v = ((GifEncoderOcBlock)blocks.elementAt((int)i2)).var;
                    if (v > maxvar) {
                        maxvar = v;
                        refine = i2;
                    }
                    ++i2;
                }
            }
            transparentIndex = -1;
            transparentRgb = -1;
            this.colorHash = new IntHashtable();
            int i = 0;
            while (i < numcolors) {
                block = (GifEncoderOcBlock)blocks.elementAt(i);
                int rgb = -16777216;
                rgb += (int)block.cr << 16;
                rgb += (int)block.cg << 8;
                block.crgb = rgb += (int)block.cb;
                this.colorHash.put(rgb, (Object)new GifEncoderHashitem(rgb, block.count, i, false));
                ++i;
            }
            index = numcolors - 1;
            IntHashtable hash = new IntHashtable();
            int i3 = 0;
            while (i3 < colors.length) {
                hash.put(colors[i3].rgb, (Object)colors[i3]);
                ++i3;
            }
            int row2 = 0;
            while (row2 < this.height) {
                int col = 0;
                while (col < this.width) {
                    int rgb = this.rgbPixels[row2][col];
                    GifEncoderHashitem item = (GifEncoderHashitem)hash.get(rgb);
                    if (item == null) {
                        throw new IOException("GIF encoding failed at color reduction!");
                    }
                    this.rgbPixels[row2][col] = ((GifEncoderOcBlock)blocks.elementAt((int)item.index)).crgb;
                    ++col;
                }
                ++row2;
            }
        }
        int logColors = index <= 2 ? 1 : (index <= 4 ? 2 : (index <= 16 ? 4 : 8));
        int mapSize = 1 << logColors;
        byte[] reds = new byte[mapSize];
        byte[] grns = new byte[mapSize];
        byte[] blus = new byte[mapSize];
        Enumeration e = this.colorHash.elements();
        while (e.hasMoreElements()) {
            GifEncoderHashitem item = (GifEncoderHashitem)e.nextElement();
            reds[item.index] = (byte)(item.rgb >> 16 & 0xFF);
            grns[item.index] = (byte)(item.rgb >> 8 & 0xFF);
            blus[item.index] = (byte)(item.rgb & 0xFF);
        }
        this.GIFEncode(this.out, this.width, this.height, this.interlace, (byte)0, transparentIndex, logColors, reds, grns, blus);
    }

    void Putbyte(byte b, OutputStream outs) throws IOException {
        outs.write(b);
    }

    byte GetPixel(int x, int y) throws IOException {
        GifEncoderHashitem item = (GifEncoderHashitem)this.colorHash.get(this.rgbPixels[y][x]);
        if (item == null) {
            throw new IOException("color not found");
        }
        return (byte)item.index;
    }

    protected void BumpPixel() {
        ++this.curx;
        if (this.curx == this.Width) {
            this.curx = 0;
            if (!this.Interlace) {
                ++this.cury;
            } else {
                switch (this.Pass) {
                    case 0: {
                        this.cury += 8;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 4;
                        break;
                    }
                    case 1: {
                        this.cury += 8;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 2;
                        break;
                    }
                    case 2: {
                        this.cury += 4;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 1;
                        break;
                    }
                    case 3: {
                        this.cury += 2;
                        break;
                    }
                }
            }
        }
    }

    void compress(int init_bits, OutputStream outs) throws IOException {
        int c;
        this.g_init_bits = init_bits;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.MAXCODE(this.n_bits);
        this.ClearCode = 1 << init_bits - 1;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.char_init();
        int ent = this.GIFNextPixel();
        int hshift = 0;
        int fcode = this.hsize;
        while (fcode < 65536) {
            ++hshift;
            fcode *= 2;
        }
        hshift = 8 - hshift;
        int hsize_reg = this.hsize;
        this.cl_hash(hsize_reg);
        this.output(this.ClearCode, outs);
        block1: while ((c = this.GIFNextPixel()) != -1) {
            int i = c << hshift ^ ent;
            fcode = (c << this.maxbits) + ent;
            if (this.htab[i] == fcode) {
                ent = this.codetab[i];
                continue;
            }
            if (this.htab[i] >= 0) {
                int disp = hsize_reg - i;
                if (i == 0) {
                    disp = 1;
                }
                do {
                    if ((i -= disp) < 0) {
                        i += hsize_reg;
                    }
                    if (this.htab[i] != fcode) continue;
                    ent = this.codetab[i];
                    continue block1;
                } while (this.htab[i] >= 0);
            }
            this.output(ent, outs);
            ent = c;
            if (this.free_ent < this.maxmaxcode) {
                ++this.free_ent;
                this.htab[i] = fcode;
                continue;
            }
            this.cl_block(outs);
        }
        this.output(ent, outs);
        this.output(this.EOFCode, outs);
    }

    void encodeStart(int width, int height) throws IOException {
        this.width = width;
        this.height = height;
        this.rgbPixels = new int[height][width];
    }

    void Putword(int w, OutputStream outs) throws IOException {
        this.Putbyte((byte)(w & 0xFF), outs);
        this.Putbyte((byte)(w >> 8 & 0xFF), outs);
    }

    void flush_char(OutputStream outs) throws IOException {
        if (this.a_count > 0) {
            outs.write(this.a_count);
            outs.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }

    void cl_block(OutputStream outs) throws IOException {
        this.cl_hash(this.hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        this.output(this.ClearCode, outs);
    }

    void cl_hash(int hsize) {
        int i = 0;
        while (i < hsize) {
            this.htab[i] = -1;
            ++i;
        }
    }

    void encodePixels(int x, int y, int w, int h, int[] rgbPixels, int off, int scansize) throws IOException {
        int row = 0;
        while (row < h) {
            System.arraycopy(rgbPixels, row * scansize + off, this.rgbPixels[y + row], x, w);
            ++row;
        }
    }

    static void writeString(OutputStream out, String str) throws IOException {
        byte[] buf = str.getBytes();
        out.write(buf);
    }

    void GIFEncode(OutputStream outs, int Width, int Height, boolean Interlace, byte Background, int Transparent, int BitsPerPixel, byte[] Red, byte[] Green, byte[] Blue) throws IOException {
        this.Width = Width;
        this.Height = Height;
        this.Interlace = Interlace;
        int ColorMapSize = 1 << BitsPerPixel;
        int TopOfs = 0;
        int LeftOfs = 0;
        this.CountDown = Width * Height;
        this.Pass = 0;
        int InitCodeSize = BitsPerPixel <= 1 ? 2 : BitsPerPixel;
        this.curx = 0;
        this.cury = 0;
        GifEncoder.writeString(outs, "GIF89a");
        this.Putword(Width, outs);
        this.Putword(Height, outs);
        byte B = -128;
        B = (byte)(B | 0x70);
        B = (byte)(B | (byte)(BitsPerPixel - 1));
        this.Putbyte(B, outs);
        this.Putbyte(Background, outs);
        this.Putbyte((byte)0, outs);
        int i = 0;
        while (i < ColorMapSize) {
            this.Putbyte(Red[i], outs);
            this.Putbyte(Green[i], outs);
            this.Putbyte(Blue[i], outs);
            ++i;
        }
        if (Transparent != -1) {
            this.Putbyte((byte)33, outs);
            this.Putbyte((byte)-7, outs);
            this.Putbyte((byte)4, outs);
            this.Putbyte((byte)1, outs);
            this.Putbyte((byte)0, outs);
            this.Putbyte((byte)0, outs);
            this.Putbyte((byte)Transparent, outs);
            this.Putbyte((byte)0, outs);
        }
        this.Putbyte((byte)44, outs);
        this.Putword(LeftOfs, outs);
        this.Putword(TopOfs, outs);
        this.Putword(Width, outs);
        this.Putword(Height, outs);
        if (Interlace) {
            this.Putbyte((byte)64, outs);
        } else {
            this.Putbyte((byte)0, outs);
        }
        this.Putbyte((byte)InitCodeSize, outs);
        this.compress(InitCodeSize + 1, outs);
        this.Putbyte((byte)0, outs);
        this.Putbyte((byte)59, outs);
    }

    final int MAXCODE(int n_bits) {
        return (1 << n_bits) - 1;
    }
}

