/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.io.Serializable;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsStackLayout;
import jv.object.PsUpdateIf;

public class PsPanel
extends Panel
implements PsUpdateIf,
Serializable {
    public static final int BORDER_NONE = 0;
    public static final int BORDER_LINE = 1;
    public static final int BORDER_SUNK = 2;
    public static final int BORDER_GROOVE = 3;
    protected int m_borderType = 0;
    protected int m_insetSize = 2;
    protected Label m_lTitle;
    protected String m_language;
    protected PsUpdateIf m_parent;
    protected Image m_image;
    protected boolean m_bOutOfDate = false;

    private static void drawLineRect(Graphics g, Rectangle rectangle) {
        g.setColor(Color.black);
        g.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        g.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        g.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1, rectangle.x, rectangle.y + rectangle.height - 1);
        g.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x, rectangle.y);
    }

    public void drawText(Graphics g, Point point, String string) {
        g.setFont(this.getFont());
        g.setColor(this.getForeground());
        g.drawString(string, point.x, point.y);
    }

    public void setBorderType(int borderType) {
        this.m_borderType = borderType;
    }

    public Insets getInsets() {
        return new Insets(this.m_insetSize, this.m_insetSize, this.m_insetSize, this.m_insetSize);
    }

    private static void drawSunkRect(Graphics g, Rectangle rectangle) {
        g.setColor(Color.darkGray);
        g.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 2, rectangle.y);
        g.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 2);
        g.setColor(Color.black);
        g.drawLine(rectangle.x + 2, rectangle.y + 1, rectangle.x + rectangle.width - 3, rectangle.y + 1);
        g.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 3);
        g.setColor(Color.lightGray);
        g.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        g.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        g.setColor(Color.white);
        g.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        g.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
    }

    protected static void assureState(Checkbox cb, boolean bState) {
        if (cb.getState() == bState) {
            return;
        }
        cb.setState(bState);
    }

    public void setParent(PsUpdateIf aParent) {
        this.m_parent = aParent;
    }

    public PsPanel() {
        this.setLayout(new PsStackLayout(1));
        this.setInsetSize(this.m_insetSize);
        this.m_language = PsConfig.getLanguage();
        if (this.instanceOf("PsPanel")) {
            this.init();
        }
    }

    public void paint(Graphics g) {
        if (this.m_bOutOfDate && this.m_parent != null) {
            this.update(this.m_parent);
            this.m_bOutOfDate = false;
        }
        super.paint(g);
        if (this.m_image != null) {
            Dimension dim = super.getSize();
            g.drawImage(this.m_image, 0, 0, dim.width, dim.height, this);
        }
        if (this.m_borderType != 0) {
            this.drawBorder(g, this.m_borderType);
        }
    }

    public void setVisible(boolean flag) {
        if (flag && this.m_parent != null) {
            this.update(this.m_parent);
        }
        super.setVisible(flag);
    }

    public Label addSubTitle(String aTitle) {
        Label title = new Label(aTitle, 0);
        title.setFont(PsConfig.getFont(3));
        this.add(title);
        return title;
    }

    public PsUpdateIf getFather() {
        return this.m_parent;
    }

    public TextField addTextField(String title, int length) {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2));
        Label label = new Label(title);
        panel.add(label);
        TextField textField = new TextField(length);
        panel.add(textField);
        this.add(panel);
        return textField;
    }

    public void drawBorder(Graphics g, int borderType) {
        Rectangle rectangle = new Rectangle(this.getSize());
        switch (borderType) {
            case 1: {
                PsPanel.drawLineRect(g, rectangle);
                break;
            }
            case 2: {
                PsPanel.drawSunkRect(g, rectangle);
                break;
            }
            case 3: {
                PsPanel.drawGrooveRect(g, rectangle);
                break;
            }
        }
    }

    public static void drawBorder(Component comp, Graphics g, int borderType) {
        Rectangle rectangle = new Rectangle(comp.getSize());
        switch (borderType) {
            case 1: {
                PsPanel.drawLineRect(g, rectangle);
                break;
            }
            case 2: {
                PsPanel.drawSunkRect(g, rectangle);
                break;
            }
            case 3: {
                PsPanel.drawGrooveRect(g, rectangle);
                break;
            }
        }
    }

    public String getLanguage() {
        return this.m_language;
    }

    public boolean update(Object event) {
        if (event == this.m_parent) {
            return true;
        }
        if (event != null) {
            PsDebug.notify("could not handle event = " + event.toString() + "\n\tmissing implementation of update(Object)");
            return false;
        }
        if (this.m_parent != null) {
            PsDebug.notify("update parent");
            return this.m_parent.update(this);
        }
        return false;
    }

    public void addLine(int size) {
        this.add(new PsLine(size));
    }

    public Panel addLabelComponent(String label, Component comp) {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2));
        panel.add(new Label(label));
        panel.add(comp);
        this.add(panel);
        return panel;
    }

    public void update(Graphics g) {
        if (this.m_image != null) {
            this.paint(g);
            return;
        }
        super.update(g);
    }

    public Label getTitle() {
        return this.m_lTitle;
    }

    public void setTitle(String title) {
        if (this.m_lTitle == null) {
            this.m_lTitle = new Label(title);
        } else {
            this.m_lTitle.setText(title);
        }
    }

    protected static void assureEnable(Component comp, boolean bEnable) {
        if (comp.isEnabled() == bEnable) {
            return;
        }
        comp.setEnabled(bEnable);
    }

    public void setInsetSize(int size) {
        this.m_insetSize = size;
    }

    public void setImage(Image image) {
        if (image != null) {
            this.setLayout(null);
        }
        this.m_image = image;
    }

    private static void drawGrooveRect(Graphics g, Rectangle rectangle) {
        g.setColor(Color.darkGray);
        g.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        g.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        g.drawLine(rectangle.x + 2, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        g.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        g.setColor(Color.white);
        g.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width - 1, rectangle.y + 1);
        g.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 1);
        g.drawLine(rectangle.x + 2, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        g.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + 2, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
    }

    public final boolean instanceOf(String aClassName) {
        String fullClassName = this.getClass().getName();
        return fullClassName.endsWith(aClassName);
    }

    public void init() {
        ((Component)this).setFont(PsConfig.getFont(0));
    }

    public void setOutOfDate(boolean state) {
        this.m_bOutOfDate = state;
    }

    public boolean hasTitle() {
        return this.m_lTitle != null;
    }

    public Label addTitle(String aTitle) {
        this.m_lTitle = new Label(aTitle, 0);
        this.m_lTitle.setFont(PsConfig.getFont(3));
        this.add(this.m_lTitle);
        return this.m_lTitle;
    }

    class PsLine
    extends Canvas {
        protected int m_size;

        public PsLine(int aSize) {
            PsPanel.this.getClass();
            this.m_size = 1;
            this.m_size = aSize;
            this.setSize(10, 10);
        }

        public void paint(Graphics g) {
            super.paint(g);
            Color bg = this.getBackground();
            Color fg = this.getForeground();
            Dimension d = this.getSize();
            int m_xMin = 0;
            int m_yMin = 0;
            int m_xMax = m_xMin + d.width;
            int m_yMax = m_yMin + d.height;
            int yPos = (m_yMin + m_yMax - this.m_size) / 2;
            g.setColor(new Color(Math.max(bg.getRed() - 64, 0), Math.max(bg.getGreen() - 64, 0), Math.max(bg.getBlue() - 64, 0)));
            g.drawLine(m_xMin + 1, yPos, m_xMax - 1, yPos);
            g.setColor(bg);
            int i = 1;
            while (i < this.m_size) {
                g.drawLine(m_xMin + 1, yPos + i, m_xMax - 1, yPos + i);
                ++i;
            }
            g.setColor(new Color(Math.min(bg.getRed() + 32, 255), Math.min(bg.getGreen() + 32, 255), Math.min(bg.getBlue() + 32, 255)));
            g.drawLine(m_xMin + 1, yPos + this.m_size, m_xMax - 1, yPos + this.m_size);
            g.setColor(fg);
        }
    }
}

