/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.ruler;

import java.awt.Color;
import java.text.NumberFormat;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgRuler
extends PgJvxSrc {
    private static final int MIN = 0;
    private static final int MAX = 1;
    private static final int NORMALHP1 = 0;
    private static final int NORMALHP2 = 1;
    private static final int UPHP1 = 2;
    private static final int UPHP2 = 3;
    public static final int NORMAL_DIRECTION = 0;
    public static final int UP_VECTOR_DIRECTION = 1;
    public static final int TITLE_ALIGN_LEFT = 0;
    public static final int TITLE_ALIGN_RIGHT = 1;
    public static final int TITLE_ALIGN_CENTER = 2;
    protected boolean m_bFixedMode;
    protected boolean m_bMajorMode;
    protected boolean m_bMinorMode;
    protected boolean m_bHashInNormalDir;
    protected boolean m_bHashInUpDir;
    protected boolean m_bShowLabels;
    protected boolean m_bShowRulerName;
    protected String m_rulerName;
    protected int m_rulerNamePos;
    protected PdVector m_minMax;
    protected PdVector m_origin = new PdVector(3);
    protected PdVector m_normalOffset = new PdVector(3);
    protected PdVector m_upOffset = new PdVector(3);
    protected PdVector m_v = new PdVector(3);
    protected PdVector m_n = new PdVector(3);
    protected PdVector m_u = new PdVector(3);
    protected double[] m_minorHashExtent = new double[4];
    protected double[] m_majorHashExtent = new double[4];
    protected Color m_majorHashExtentColor;
    protected Color m_minorHashExtentColor;
    protected PuInteger m_numMajorHashings;
    protected PuInteger m_numMinorHashings;
    protected PuDouble m_majorHashUnits;
    protected PuDouble m_minorHashUnits;
    private double m_defMin = -10.0;
    private double m_defMax = 10.0;
    private double m_defMajorHashUnit = 5.0;
    private double m_defMinorHashUnit = 2.5;
    private int m_defNumMajorHashings = 5;
    private int m_defNumMinorHashings = 2;
    private double m_defhMajor = 0.5;
    private double m_defhMinor = 0.25;
    private boolean m_defbHashInNormalDir = true;
    private boolean m_defbHashInUpDir = false;
    private Color m_defhMajorColor = new Color(0, 0, 255);
    private Color m_defhMinorColor = new Color(113, 113, 255);
    private int m_numMajor;
    private int m_numMinor;
    private double[] m_majorHashing = new double[1000];
    private double[] m_minorHashing = new double[1000];

    public double getMaxParameter() {
        return this.m_minMax.getEntry(1);
    }

    public void setMajorHashSize(double pt1, double pt2, int orthoType) {
        if (orthoType == 0) {
            this.m_majorHashExtent[0] = pt1;
            this.m_majorHashExtent[1] = pt2;
        } else if (orthoType == 1) {
            this.m_majorHashExtent[2] = pt1;
            this.m_majorHashExtent[3] = pt2;
        }
    }

    public double getMajorUnit() {
        return this.m_majorHashUnits.getValue();
    }

    public void setNameAlignment(int align, int labelhSide, int xoff, int yoff) {
        this.m_rulerNamePos = align;
        this.setLabelAttribute(2, xoff, yoff, labelhSide, 0, 3);
    }

    public void setOrigin(PdVector orig) {
        this.m_origin.copy(orig);
    }

    public boolean isShowingMinorHashings() {
        return this.m_bMinorMode;
    }

    public void showMinorHashings(boolean flag) {
        this.m_bMinorMode = flag;
    }

    protected void resetVertices() {
        int i = 0;
        while (i < this.m_maxNumVertices) {
            if (this.m_vertex[i] != null) {
                this.m_vertex[i].setName("");
            }
            ++i;
        }
        i = 0;
        while (i < this.m_maxNumPolygons) {
            if (this.m_polygon[i] != null) {
                this.m_polygon[i].setName("");
            }
            ++i;
        }
    }

    public int getNumMajorPartitions() {
        return this.m_numMajorHashings.getValue();
    }

    public boolean update(Object event) {
        PsDebug.notify("called");
        if (event == this) {
            this.computeHashings();
            return super.update(this);
        }
        if (event == this.m_minorHashUnits || event == this.m_majorHashUnits) {
            this.m_majorHashUnits.setBounds(0.1, Math.ceil(this.m_minMax.getEntry(1) + 0.25));
            this.m_minorHashUnits.setBounds(0.1, Math.ceil(this.m_minMax.getEntry(1) + 0.25));
            this.computeHashings();
            return super.update(this);
        }
        if (event == this.m_numMajorHashings || event == this.m_numMinorHashings) {
            int uppbnd = new Double(2.0 * this.m_minMax.getEntry(1)).intValue();
            this.m_numMajorHashings.setBounds(0, uppbnd);
            this.m_numMinorHashings.setBounds(0, uppbnd);
            this.computeHashings();
            return super.update(this);
        }
        return super.update(event);
    }

    public void setMajorColor(Color C) {
        this.m_majorHashExtentColor = C;
    }

    public boolean isShowingLabels() {
        return this.m_bShowLabels;
    }

    public void showLabels(boolean flag) {
        this.m_bShowLabels = flag;
    }

    public void setMinorColor(Color C) {
        this.m_minorHashExtentColor = C;
    }

    public boolean isShowingHashingsInNormalDir() {
        return this.m_bHashInNormalDir;
    }

    public boolean isShowingHashingsInUpDir() {
        return this.m_bHashInUpDir;
    }

    public void showHashingsInNormalDir(boolean flag) {
        this.m_bHashInNormalDir = flag;
    }

    public void showHashingsInUpDir(boolean flag) {
        this.m_bHashInUpDir = flag;
    }

    public double getMinParameter() {
        return this.m_minMax.getEntry(0);
    }

    public boolean isShowingMajorHashings() {
        return this.m_bMajorMode;
    }

    public void showMajorHashings(boolean flag) {
        this.m_bMajorMode = flag;
    }

    public void setPartitionedHashing(int major, int minor) {
        this.m_numMajorHashings.setValue(major);
        this.m_numMinorHashings.setValue(minor);
    }

    public PgRuler() {
        this(3);
    }

    public PgRuler(int dim) {
        super(dim);
        this.setTag(7);
        this.m_origin = new PdVector(dim);
        this.m_normalOffset = new PdVector(dim);
        this.m_upOffset = new PdVector(dim);
        this.m_minMax = new PdVector(2);
        this.m_majorHashUnits = new PuDouble("Major Units", this);
        this.m_minorHashUnits = new PuDouble("Minor Units", this);
        this.m_numMajorHashings = new PuInteger("Major Hashings", this);
        this.m_numMinorHashings = new PuInteger("Minor Hashings", this);
        this.init();
    }

    public PgRuler(PdVector rulerDir, PdVector rulerNormal) {
        this(3);
        this.setDirection(rulerDir);
        this.setNormal(rulerNormal);
        this.m_u.cross(this.m_v, this.m_n);
    }

    public double getMinorUnit() {
        return this.m_minorHashUnits.getValue();
    }

    public void setUpVector(PdVector U) {
        this.m_u.copy(U);
        this.m_u.normalize();
    }

    public void setHashOffsetInNormalDir(double xoff, double yoff, double zoff) {
        this.m_normalOffset.m_data[0] = xoff;
        this.m_normalOffset.m_data[1] = yoff;
        this.m_normalOffset.m_data[2] = zoff;
    }

    public void setHashOffsetInUpDir(double xoff, double yoff, double zoff) {
        this.m_upOffset.m_data[0] = xoff;
        this.m_upOffset.m_data[1] = yoff;
        this.m_upOffset.m_data[2] = zoff;
    }

    public boolean isShowingRulerName() {
        return this.m_bShowRulerName;
    }

    public void showRulerName(boolean flag) {
        this.m_bShowRulerName = flag;
    }

    public void setMinorHashSize(double pt1, double pt2, int orthogonalType) {
        if (orthogonalType == 0) {
            this.m_minorHashExtent[0] = pt1;
            this.m_minorHashExtent[1] = pt2;
        }
        if (orthogonalType == 1) {
            this.m_minorHashExtent[2] = pt1;
            this.m_minorHashExtent[3] = pt2;
        }
    }

    public void setRulerName(String s) {
        this.setRulerName(s, 1, false);
    }

    public void setRulerName(String s, int pos) {
        this.setRulerName(s, pos, false);
    }

    public void setRulerName(String s, boolean show) {
        this.setRulerName(s, 1, show);
    }

    public void setRulerName(String s, int pos, boolean show) {
        this.m_rulerName = s;
        this.m_rulerNamePos = pos;
        this.m_bShowRulerName = show;
        this.setName(this.m_rulerName);
    }

    public void setNormal(PdVector N) {
        this.m_n.copy(N);
        this.m_n.normalize();
    }

    public void setFixedHashing(double major, double minor) {
        if (major >= this.m_majorHashUnits.getMax() - 0.5) {
            this.m_majorHashUnits.setBounds(0.1, 2.0 * major);
        }
        if (minor >= this.m_minorHashUnits.getMax() - 0.5) {
            this.m_minorHashUnits.setBounds(0.1, 2.0 * minor);
        }
        this.m_majorHashUnits.setValue(major);
        this.m_minorHashUnits.setValue(minor);
    }

    public boolean isShowingFixedMode() {
        return this.m_bFixedMode;
    }

    public void showFixedMode(boolean flag) {
        this.m_bFixedMode = flag;
    }

    public void setMinMax(double min, double max) {
        this.m_minMax.m_data[0] = min;
        this.m_minMax.m_data[1] = max;
    }

    protected void computeHashings() {
        int i;
        PdVector hashOrigin;
        double maxval;
        double minval = this.m_minMax.getEntry(0);
        if (minval >= (maxval = this.m_minMax.getEntry(1))) {
            return;
        }
        int numMajor = 0;
        int numMinor = 0;
        if (this.m_bFixedMode) {
            double majorUnit = this.m_majorHashUnits.getValue();
            double minorUnit = this.m_minorHashUnits.getValue();
            if (this.m_bMajorMode) {
                numMajor = PgRuler.hashInterval(numMajor, this.m_majorHashing, majorUnit, minval, true, maxval, true);
                if (this.m_bMinorMode) {
                    if (numMajor == 0) {
                        numMinor = PgRuler.hashInterval(numMinor, this.m_minorHashing, minorUnit, minval, true, maxval, true);
                    } else {
                        numMinor = PgRuler.hashInterval(numMinor, this.m_minorHashing, minorUnit, minval, false, this.m_majorHashing[0], false);
                        numMinor = PgRuler.hashInterval(numMinor, this.m_minorHashing, minorUnit, this.m_majorHashing[numMajor - 1], false, maxval, false);
                        int i2 = 1;
                        while (i2 < numMajor) {
                            numMinor = PgRuler.hashInterval(numMinor, this.m_minorHashing, minorUnit, this.m_majorHashing[i2 - 1], false, this.m_majorHashing[i2], false);
                            ++i2;
                        }
                    }
                }
            } else if (this.m_bMinorMode) {
                numMinor = PgRuler.hashInterval(numMinor, this.m_minorHashing, minorUnit, minval, true, maxval, true);
            }
        } else {
            numMajor = this.partitionInterval(numMajor, this.m_majorHashing, this.m_numMajorHashings.getValue(), minval, true, maxval, true);
            if (this.m_bMinorMode) {
                int numPartitions = this.m_numMinorHashings.getValue();
                int i3 = 1;
                while (i3 < numMajor) {
                    numMinor = this.partitionInterval(numMinor, this.m_minorHashing, numPartitions, this.m_majorHashing[i3 - 1], false, this.m_majorHashing[i3], false);
                    ++i3;
                }
            }
        }
        int nop = 1;
        if (this.m_bHashInNormalDir) {
            nop += numMajor + numMinor;
        }
        if (this.m_bHashInUpDir) {
            nop += numMajor + numMinor;
        }
        if (this.m_bShowLabels) {
            nop += numMajor;
        }
        if (this.m_bShowRulerName) {
            ++nop;
        }
        int nov = 2 * nop;
        this.resetVertices();
        this.setNumVertices(nov);
        this.setNumPolygons(nop);
        PdVector[] vertex = this.getVertices();
        PiVector[] polygon = this.getPolygons();
        Color[] polyColor = this.getPolygonColors();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(1);
        PdVector rulerDir = this.m_v;
        int vInd = 0;
        int pInd = 0;
        polygon[pInd].set(vInd, vInd + 1);
        polyColor[pInd++] = this.m_majorHashExtentColor;
        vertex[vInd++].blendBase(this.m_origin, minval, rulerDir);
        vertex[vInd++].blendBase(this.m_origin, maxval, rulerDir);
        if (this.m_bShowLabels) {
            int i4 = 0;
            while (i4 < numMajor) {
                polygon[pInd].set(vInd, vInd + 1);
                polyColor[pInd++] = this.m_majorHashExtentColor;
                if (this.m_bShowLabels) {
                    vertex[vInd].setName(nf.format(this.m_majorHashing[i4]));
                }
                vertex[vInd++].blendBase(this.m_origin, this.m_majorHashing[i4], rulerDir);
                vertex[vInd++].blendBase(this.m_origin, this.m_majorHashing[i4], rulerDir);
                ++i4;
            }
        }
        PdVector hashBase = new PdVector(this.m_dim);
        PdVector hashTip = new PdVector(this.m_dim);
        if (this.m_bHashInUpDir) {
            hashOrigin = PdVector.addNew(this.m_origin, this.m_upOffset);
            hashBase.blendBase(hashOrigin, this.m_majorHashExtent[2], this.m_u);
            hashTip.blendBase(hashOrigin, this.m_majorHashExtent[3], this.m_u);
            i = 0;
            while (i < numMajor) {
                polygon[pInd].set(vInd, vInd + 1);
                polyColor[pInd++] = this.m_majorHashExtentColor;
                vertex[vInd++].blendBase(hashBase, this.m_majorHashing[i], rulerDir);
                vertex[vInd++].blendBase(hashTip, this.m_majorHashing[i], rulerDir);
                ++i;
            }
            hashBase.blendBase(hashOrigin, this.m_minorHashExtent[2], this.m_u);
            hashTip.blendBase(hashOrigin, this.m_minorHashExtent[3], this.m_u);
            i = 0;
            while (i < numMinor) {
                polygon[pInd].set(vInd, vInd + 1);
                polyColor[pInd++] = this.m_minorHashExtentColor;
                vertex[vInd++].blendBase(hashBase, this.m_minorHashing[i], rulerDir);
                vertex[vInd++].blendBase(hashTip, this.m_minorHashing[i], rulerDir);
                ++i;
            }
        }
        if (this.m_bHashInNormalDir) {
            hashOrigin = PdVector.addNew(this.m_origin, this.m_normalOffset);
            hashBase.blendBase(hashOrigin, this.m_majorHashExtent[0], this.m_n);
            hashTip.blendBase(hashOrigin, this.m_majorHashExtent[1], this.m_n);
            i = 0;
            while (i < numMajor) {
                polygon[pInd].set(vInd, vInd + 1);
                polyColor[pInd++] = this.m_majorHashExtentColor;
                vertex[vInd++].blendBase(hashBase, this.m_majorHashing[i], rulerDir);
                vertex[vInd++].blendBase(hashTip, this.m_majorHashing[i], rulerDir);
                ++i;
            }
            hashBase.blendBase(hashOrigin, this.m_minorHashExtent[0], this.m_n);
            hashTip.blendBase(hashOrigin, this.m_minorHashExtent[1], this.m_n);
            i = 0;
            while (i < numMinor) {
                polygon[pInd].set(vInd, vInd + 1);
                polyColor[pInd++] = this.m_minorHashExtentColor;
                vertex[vInd++].blendBase(hashBase, this.m_minorHashing[i], rulerDir);
                vertex[vInd++].blendBase(hashTip, this.m_minorHashing[i], rulerDir);
                ++i;
            }
        }
        if (this.m_bShowRulerName) {
            double currVal = minval;
            switch (this.m_rulerNamePos) {
                default: {
                    currVal = minval;
                    break;
                }
                case 1: {
                    currVal = maxval;
                    break;
                }
                case 2: {
                    currVal = (minval + maxval) / 2.0;
                }
            }
            polygon[pInd].set(vInd, vInd + 1);
            polyColor[pInd] = this.m_majorHashExtentColor;
            this.getPolygon(pInd).setName(this.m_rulerName);
            vertex[vInd].blendBase(this.m_origin, currVal, rulerDir);
            vertex[vInd + 1].copy(vertex[vInd]);
        }
    }

    public int getNumMinorPartitions() {
        return this.m_numMinorHashings.getValue();
    }

    public void setDefaultHashSizes(int orthogonalType) {
        if (orthogonalType == 0) {
            this.m_majorHashExtent[0] = 0.0;
            this.m_majorHashExtent[1] = this.m_defhMajor;
            this.m_minorHashExtent[0] = 0.0;
            this.m_minorHashExtent[1] = this.m_defhMinor;
            this.m_bHashInNormalDir = true;
            this.m_bHashInUpDir = false;
        } else if (orthogonalType == 1) {
            this.m_majorHashExtent[2] = 0.0;
            this.m_majorHashExtent[3] = this.m_defhMajor;
            this.m_minorHashExtent[2] = 0.0;
            this.m_minorHashExtent[3] = this.m_defhMinor;
            this.m_bHashInNormalDir = false;
            this.m_bHashInUpDir = true;
        }
    }

    public void init() {
        super.init();
        this.setDimOfPolygons(2);
        this.m_bHashInNormalDir = this.m_defbHashInNormalDir;
        this.m_bHashInUpDir = this.m_defbHashInUpDir;
        this.m_bMajorMode = true;
        this.m_bMinorMode = true;
        this.m_bFixedMode = true;
        this.m_bShowLabels = true;
        this.m_bShowRulerName = false;
        this.m_majorHashExtent[0] = 0.0;
        this.m_majorHashExtent[1] = this.m_defhMajor;
        this.m_majorHashExtent[2] = 0.0;
        this.m_majorHashExtent[3] = this.m_defhMajor;
        this.m_minorHashExtent[0] = 0.0;
        this.m_minorHashExtent[1] = this.m_defhMinor;
        this.m_minorHashExtent[2] = 0.0;
        this.m_minorHashExtent[3] = this.m_defhMinor;
        this.m_majorHashExtentColor = this.m_defhMajorColor;
        this.m_minorHashExtentColor = this.m_defhMinorColor;
        this.m_numMajorHashings.setDefValue(this.m_defNumMajorHashings);
        this.m_numMajorHashings.init();
        this.m_numMinorHashings.setDefValue(this.m_defNumMinorHashings);
        this.m_numMinorHashings.init();
        this.m_majorHashUnits.setDefValue(this.m_defMajorHashUnit);
        this.m_majorHashUnits.init();
        this.m_minorHashUnits.setDefValue(this.m_defMinorHashUnit);
        this.m_minorHashUnits.init();
        this.m_minMax.m_data[0] = this.m_defMin;
        this.m_minMax.m_data[1] = this.m_defMax;
        this.showIndices(true);
        this.showVertices(true);
        this.setGlobalVertexSize(0.0);
        this.setGlobalPolygonSize(1.0);
        this.setDefaultLabelEnabled(false);
        this.showPolygons(true);
        this.showPolygonColors(true);
        this.assurePolygonColors();
    }

    public void setEndPoint(PdVector endPnt, PdVector viewDir) {
        this.setDirection(PdVector.subNew(endPnt, this.m_origin));
        this.m_minMax.setEntry(0, 0.0);
        this.m_minMax.setEntry(1, PdVector.dist(endPnt, this.m_origin));
        if (endPnt.getSize() == 3) {
            this.setNormal(PdVector.crossNew(viewDir, this.m_v));
        } else if (Math.abs(this.m_v.m_data[1]) < 0.001) {
            this.setNormal(new PdVector(this.m_v.m_data[2], 0.0, this.m_v.m_data[0]));
        } else if (Math.abs(this.m_v.m_data[0]) < 0.001) {
            this.setNormal(new PdVector(0.0, -this.m_v.m_data[2], this.m_v.m_data[1]));
        } else if (Math.abs(this.m_v.m_data[2]) < 0.001) {
            this.setNormal(new PdVector(-this.m_v.m_data[1], this.m_v.m_data[0], 0.0));
        } else {
            this.setNormal(new PdVector(0.0, 0.0, 1.0));
        }
    }

    protected static int hashInterval(int numHash, double[] hashing, double incr, double tmin, boolean closedAtMin, double tmax, boolean closedAtMax) {
        double tfin;
        double EPS = 1.0E-7;
        double tstart = closedAtMin ? incr * Math.ceil(tmin / incr) : incr * Math.floor((tmin + incr) / incr);
        double d = tfin = closedAtMax ? incr * Math.floor(tmax / incr) : incr * Math.ceil((tmax - incr) / incr);
        if (Math.abs(tstart - tmin) < EPS) {
            tstart += incr;
        }
        if (Math.abs(tfin - tmax) < EPS) {
            tfin -= incr;
        }
        double t = tstart;
        while (t <= tfin + 1.0E-7 && numHash < hashing.length) {
            hashing[numHash++] = t;
            t += incr;
        }
        return numHash;
    }

    protected int partitionInterval(int numHash, double[] hashing, int numPartitions, double tmin, boolean closedAtMin, double tmax, boolean closedAtMax) {
        double incr = (tmax - tmin) / (double)(numPartitions + 1);
        if (!closedAtMin) {
            tmin += incr;
        }
        if (!closedAtMax) {
            tmax -= incr;
        }
        double t = tmin;
        while (t <= tmax + 1.0E-7 && numHash < hashing.length) {
            hashing[numHash++] = t;
            t += incr;
        }
        return numHash;
    }

    public void setHashLabel(int xoff, int yoff, int labelhSide, int labelvSide) {
        this.setLabelAttribute(0, xoff, yoff, labelhSide, labelvSide, 1);
    }

    public void setDirection(PdVector dir) {
        this.m_v.copy(dir);
        this.m_v.normalize();
    }
}

