/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.expr;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import jv.thirdParty.expr.Expr;
import jv.thirdParty.expr.Syntax_error;
import jv.thirdParty.expr.Variable;

public class Parser {
    static StreamTokenizer tokens;
    static String[] procs;
    static int[] rators;

    public static Expr parse(String input) throws Syntax_error {
        tokens = new StreamTokenizer(new StringReader(input));
        tokens.ordinaryChar(47);
        tokens.ordinaryChar(45);
        Parser.next();
        Expr expr = Parser.parse_expr(0);
        if (Parser.tokens.ttype != -1) {
            throw new Syntax_error("Incomplete expression: " + input);
        }
        return expr;
    }

    static void expect(int ttype) throws Syntax_error {
        if (Parser.tokens.ttype != ttype) {
            throw new Syntax_error("'" + (char)ttype + "' expected");
        }
        Parser.next();
    }

    static Expr parse_factor() throws Syntax_error {
        switch (Parser.tokens.ttype) {
            case -2: {
                Expr lit = Expr.make_literal(Parser.tokens.nval);
                Parser.next();
                return lit;
            }
            case -3: {
                int i = 0;
                while (i < procs.length) {
                    if (procs[i].equals(Parser.tokens.sval)) {
                        Parser.next();
                        Parser.expect(40);
                        Expr rand = Parser.parse_expr(0);
                        Parser.expect(41);
                        return Expr.make_app1(rators[i], rand);
                    }
                    ++i;
                }
                Expr var = Expr.make_var_ref(Variable.make(Parser.tokens.sval));
                Parser.next();
                return var;
            }
            case 40: {
                Parser.next();
                Expr enclosed = Parser.parse_expr(0);
                Parser.expect(41);
                return enclosed;
            }
            case 45: {
                Parser.next();
                return Expr.make_app1(110, Parser.parse_expr(15));
            }
        }
        throw new Syntax_error("Expected a factor");
    }

    static {
        procs = new String[]{"abs", "acos", "asin", "atan", "acot", "ceil", "cos", "exp", "floor", "log", "round", "sin", "sqrt", "tan", "cot", "sinh", "cosh", "tanh", "coth", "asinh", "acosh", "atanh", "acoth", "sign"};
        rators = new int[]{100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124};
    }

    static void next() {
        try {
            tokens.nextToken();
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error: " + e);
        }
    }

    static Expr parse_expr(int precedence) throws Syntax_error {
        Expr expr = Parser.parse_factor();
        block7: while (true) {
            int rator;
            int r;
            int l;
            switch (Parser.tokens.ttype) {
                case 43: {
                    l = 10;
                    r = 11;
                    rator = 0;
                    break;
                }
                case 45: {
                    l = 10;
                    r = 11;
                    rator = 1;
                    break;
                }
                case 42: {
                    l = 20;
                    r = 21;
                    rator = 2;
                    break;
                }
                case 47: {
                    l = 20;
                    r = 21;
                    rator = 3;
                    break;
                }
                case 94: {
                    l = 30;
                    r = 30;
                    rator = 4;
                    break;
                }
                default: {
                    break block7;
                }
            }
            if (l < precedence) break;
            Parser.next();
            expr = Expr.make_app2(rator, expr, Parser.parse_expr(r));
        }
        return expr;
    }
}

