/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDialog;

public class PuDouble_Config
extends PsDialog {
    protected PuDouble m_number = null;
    protected boolean m_fInitialized = false;
    protected TextField m_tMin;
    protected Label m_lMin;
    protected TextField m_tMax;
    protected Label m_lMax;
    protected TextField m_tLineIncr;
    protected Label m_lLineIncr;
    protected TextField m_tPageIncr;
    protected Label m_lPageIncr;
    protected TextField m_tAccuracy;
    protected Label m_lAccuracy;

    public void reset() {
        if (this.m_number != null) {
            this.m_number.init();
        }
    }

    public PuDouble_Config(PuDouble parent) {
        super(PsConfig.getFrame(), parent.getName(), true);
        this.m_number = parent;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_bOk) {
            double min = new Double(this.m_tMin.getText());
            double max = new Double(this.m_tMax.getText());
            double lineIncr = new Double(this.m_tLineIncr.getText());
            double pageIncr = new Double(this.m_tPageIncr.getText());
            if (max < min) {
                double tmp = min;
                min = max;
                max = tmp;
            }
            if (lineIncr >= max) {
                lineIncr = Math.min(max, 0.01);
            }
            if (pageIncr >= max) {
                pageIncr = Math.min(max, 0.1);
            }
            this.m_number.m_shownAccuracy = new Double(this.m_tAccuracy.getText());
            this.m_number.setBounds(min, max, lineIncr, pageIncr);
        }
        super.actionPerformed(event);
    }

    public boolean init(double min, double max, double lineIncr, double pageIncr, double accuracy) {
        if (this.m_fInitialized) {
            return false;
        }
        ((Component)this).setSize(300, 250);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(5, 2));
        Label title = new Label(PsConfig.getMessage("ConfigurationPanelOf") + " " + this.m_number.getName());
        title.setFont(PsConfig.getFont(3));
        this.add("North", title);
        this.add("Center", panel);
        this.m_lMin = new Label(PsConfig.getMessage("lMin"), 0);
        panel.add(this.m_lMin);
        this.m_tMin = new TextField(String.valueOf(min));
        panel.add(this.m_tMin);
        this.m_lMax = new Label(PsConfig.getMessage("lMax"), 0);
        panel.add(this.m_lMax);
        this.m_tMax = new TextField(String.valueOf(max));
        panel.add(this.m_tMax);
        this.m_lLineIncr = new Label(PsConfig.getMessage("lLineIncr"), 0);
        panel.add(this.m_lLineIncr);
        this.m_tLineIncr = new TextField(String.valueOf(lineIncr));
        panel.add(this.m_tLineIncr);
        this.m_lPageIncr = new Label(PsConfig.getMessage("lPageIncr"), 0);
        panel.add(this.m_lPageIncr);
        this.m_tPageIncr = new TextField(String.valueOf(pageIncr));
        panel.add(this.m_tPageIncr);
        this.m_lAccuracy = new Label(PsConfig.getMessage("lAccuracy"), 0);
        panel.add(this.m_lAccuracy);
        this.m_tAccuracy = new TextField(String.valueOf(accuracy));
        panel.add(this.m_tAccuracy);
        this.add("South", this.getBottomButtons(5));
        this.m_fInitialized = true;
        return true;
    }
}

