/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.vecmath.PiVector;

public class PiVector_IP
extends PsPanel
implements TextListener {
    protected PiVector m_vector;
    protected int m_length;
    protected Panel m_pVector;
    protected TextField[] m_text;
    private boolean m_bInteractive = true;
    private static /* synthetic */ Class class$jv$number$PiVector_IP;

    public PiVector_IP() {
        if (this.getClass() == (class$jv$number$PiVector_IP != null ? class$jv$number$PiVector_IP : (class$jv$number$PiVector_IP = PiVector_IP.class$("jv.number.PiVector_IP")))) {
            this.init();
        }
    }

    public boolean setVector(PiVector aVector) {
        if (aVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (!this.setLength(aVector.getSize())) {
            PsDebug.warning("invalid length");
            return false;
        }
        this.m_vector = aVector;
        this.update(this.m_vector);
        return true;
    }

    public PiVector getVector() {
        return this.m_vector;
    }

    public boolean update(Object event) {
        PsDebug.notify("isShowing = " + this.isShowing());
        if (event == null) {
            PsDebug.warning("missing event");
            return false;
        }
        if (this.m_vector == null) {
            PsDebug.warning("missing vector");
            return false;
        }
        if (event == this.m_vector) {
            this.m_bInteractive = false;
            int i = 0;
            while (i < this.m_length) {
                ((TextComponent)this.m_text[i]).setText(String.valueOf(this.m_vector.getEntry(i)));
                ++i;
            }
            this.m_bInteractive = true;
            return true;
        }
        return super.update(event);
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setLayout(new GridLayout(1, 2));
        this.addTitle("");
        this.m_pVector = new Panel();
        this.add(this.m_pVector);
    }

    public void textValueChanged(TextEvent event) {
        if (!this.m_bInteractive) {
            return;
        }
        PsDebug.notify("entered");
        if (this.m_vector == null) {
            PsDebug.warning("missing vector, return");
            return;
        }
        Object source = event.getSource();
        int i = 0;
        while (i < this.m_length) {
            if (source == this.m_text[i]) {
                PsDebug.notify("text[" + i + "] chosen");
                String text = this.m_text[i].getText();
                if (text == null || text.equals("")) {
                    return;
                }
                try {
                    int num = Integer.parseInt(text);
                    this.m_vector.setEntry(i, num);
                    PsDebug.notify("setValue=" + this.m_vector.getEntry(i));
                    this.m_parent.update(this);
                }
                catch (NumberFormatException e) {
                    PsDebug.warning("wrong format = " + text);
                    return;
                }
                return;
            }
            ++i;
        }
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.m_lTitle.setEnabled(flag);
        int i = 0;
        while (i < this.m_length) {
            this.m_text[i].setEnabled(flag);
            ++i;
        }
    }

    public boolean setLength(int length) {
        if (length == this.m_length) {
            return true;
        }
        if (length > 5) {
            PsDebug.warning("vector length=" + this.m_length + " too large");
            return false;
        }
        this.m_length = length;
        this.m_pVector.removeAll();
        if (this.m_text == null || this.m_text.length != this.m_length) {
            int i;
            if (this.m_text != null) {
                i = 0;
                while (i < this.m_text.length) {
                    this.m_text[i].removeTextListener(this);
                    ++i;
                }
            }
            this.m_pVector.setLayout(new GridLayout(1, this.m_length));
            this.m_text = new TextField[this.m_length];
            i = 0;
            while (i < this.m_length) {
                this.m_text[i] = new TextField();
                this.m_text[i].addTextListener(this);
                this.m_pVector.add(this.m_text[i]);
                ++i;
            }
            this.m_pVector.validate();
        }
        this.update(this.m_vector);
        return true;
    }
}

