/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsStackLayout;
import jv.object.PsUpdateIf;
import jv.objectGui.GuiStackLayout;
import jv.rsrc.PsAuthorInfo;

public final class PsAuthorInfo_IP
extends PsPanel
implements ItemListener {
    protected PsAuthorInfo m_authorInfo;
    protected Panel m_pAuthor;
    protected Panel m_pAffiliation;
    protected Label m_lAuthor;
    protected int m_numAuthors;
    protected static final int m_maxNumAuthors = 10;
    protected int m_currAuthorInd;
    protected Choice m_cAuthorIndex;
    protected Label[] m_lInfo;
    protected TextComponent[] m_tInfo;
    protected String[][] m_infoStore;

    public PsAuthorInfo_IP() {
        this.setInsetSize(0);
        this.setLayout(new BorderLayout());
        this.m_lInfo = new Label[PsAuthorInfo.getNumCodes()];
        this.m_tInfo = new TextComponent[PsAuthorInfo.getNumCodes()];
        this.m_infoStore = new String[PsAuthorInfo.getNumCodes()][];
        this.m_lInfo[0] = new Label("First Name");
        this.m_lInfo[1] = new Label("Last Name");
        this.m_lInfo[2] = new Label("Organization");
        this.m_lInfo[3] = new Label("Address");
        this.m_lInfo[4] = new Label("Email");
        this.m_lInfo[5] = new Label("Url");
        int code = PsAuthorInfo.getNumCodes() - 1;
        while (code >= 0) {
            if (code == 3) {
                this.m_tInfo[3] = new TextArea(4, 80);
            } else {
                this.m_tInfo[code] = new TextField();
            }
            this.m_infoStore[code] = new String[10];
            --code;
        }
        this.m_lAuthor = new Label("Author");
        this.m_lAuthor.setFont(PsConfig.getFont(3));
        this.m_cAuthorIndex = new Choice();
        int i = 0;
        while (i < 10) {
            this.m_cAuthorIndex.addItem(String.valueOf(i + 1));
            ++i;
        }
        this.m_currAuthorInd = 0;
        this.m_cAuthorIndex.addItemListener(this);
        this.init();
    }

    public void itemStateChanged(ItemEvent event) {
        if (this.m_authorInfo == null) {
            return;
        }
        Object source = event.getSource();
        if (source == this.m_cAuthorIndex) {
            int code = PsAuthorInfo.getNumCodes() - 1;
            while (code >= 0) {
                this.m_infoStore[code][this.m_currAuthorInd] = this.m_tInfo[code].getText();
                --code;
            }
            this.m_currAuthorInd = this.m_cAuthorIndex.getSelectedIndex();
            if (this.m_currAuthorInd >= this.m_numAuthors) {
                this.setNumAuthors(this.m_currAuthorInd + 1);
            }
            code = PsAuthorInfo.getNumCodes() - 1;
            while (code >= 0) {
                if (this.m_infoStore[code][this.m_currAuthorInd] != null) {
                    this.m_tInfo[code].setText(this.m_infoStore[code][this.m_currAuthorInd]);
                } else {
                    this.m_tInfo[code].setText("");
                }
                --code;
            }
            return;
        }
    }

    public void setParent(PsUpdateIf authorInfo) {
        super.setParent(authorInfo);
        this.m_authorInfo = (PsAuthorInfo)authorInfo;
    }

    public void accept() {
        int code = PsAuthorInfo.getNumCodes() - 1;
        while (code >= 0) {
            this.m_infoStore[code][this.m_currAuthorInd] = this.m_tInfo[code].getText();
            --code;
        }
        int ind = 0;
        int i = 0;
        while (i < this.m_numAuthors) {
            if (!this.m_infoStore[1][i].equals("")) {
                ++ind;
            }
            ++i;
        }
        this.m_authorInfo.setNumAuthors(ind);
        ind = 0;
        i = 0;
        while (i < this.m_numAuthors) {
            if (!this.m_infoStore[1][i].equals("")) {
                int code2 = PsAuthorInfo.getNumCodes() - 1;
                while (code2 >= 0) {
                    this.m_authorInfo.setInfo(ind, code2, this.m_infoStore[code2][i]);
                    --code2;
                }
                ++ind;
            }
            ++i;
        }
    }

    public boolean update(Object object) {
        PsDebug.notify("isShowing = " + this.isShowing());
        if (this.m_authorInfo == null) {
            PsDebug.warning("missing display");
            return false;
        }
        if (object == this.m_authorInfo) {
            this.setNumAuthors(this.m_authorInfo.getNumAuthors());
            if (this.m_numAuthors > 0) {
                this.m_currAuthorInd = this.m_authorInfo.getSelectedAuthor();
                if (this.m_currAuthorInd != this.m_cAuthorIndex.getSelectedIndex()) {
                    this.m_cAuthorIndex.select(this.m_currAuthorInd);
                }
                int code = PsAuthorInfo.getNumCodes() - 1;
                while (code >= 0) {
                    String content = this.m_authorInfo.getInfo(this.m_currAuthorInd, code);
                    if (content != null) {
                        this.m_tInfo[code].setText(content);
                    } else {
                        this.m_tInfo[code].setText("");
                    }
                    int i = 0;
                    while (i < this.m_numAuthors) {
                        content = this.m_authorInfo.getInfo(i, code);
                        this.m_infoStore[code][i] = content != null ? this.m_authorInfo.getInfo(i, code) : "";
                        ++i;
                    }
                    --code;
                }
            } else {
                int code = PsAuthorInfo.getNumCodes() - 1;
                while (code >= 0) {
                    this.m_tInfo[code].setText("");
                    --code;
                }
                this.setNumAuthors(this.m_authorInfo.getNumAuthors() + 1);
            }
        }
        return super.update(object);
    }

    private void setNumAuthors(int num) {
        this.m_numAuthors = num;
        if (this.m_currAuthorInd >= this.m_numAuthors) {
            this.m_currAuthorInd = 0;
            this.m_cAuthorIndex.select(this.m_currAuthorInd);
        }
        int code = PsAuthorInfo.getNumCodes() - 1;
        while (code >= 0) {
            int i = this.m_numAuthors;
            while (i < 10) {
                this.m_infoStore[code][i] = "";
                ++i;
            }
            --code;
        }
    }

    public void init() {
        super.init();
        this.setLayout(new PsStackLayout(1));
        this.m_pAuthor = new Panel();
        this.m_pAuthor.setLayout(new GuiStackLayout(0));
        Panel pLeft = new Panel();
        pLeft.setLayout(new BorderLayout());
        pLeft.add("North", this.m_lAuthor);
        this.m_pAuthor.add("Left Fill", pLeft);
        PsPanel pRight = new PsPanel();
        pRight.setLayout(new PsStackLayout(3));
        Panel panel = new Panel();
        panel.setLayout(new GuiStackLayout(0, 0));
        Panel p1 = new Panel();
        p1.setLayout(new GridLayout(2, 1));
        p1.add(new Label("Index"));
        p1.add(this.m_cAuthorIndex);
        panel.add("Left Fill", p1);
        Panel p2 = new Panel();
        p2.setLayout(new GridLayout(2, 2));
        p2.add(this.m_lInfo[0]);
        p2.add(this.m_lInfo[1]);
        p2.add(this.m_tInfo[0]);
        p2.add(this.m_tInfo[1]);
        panel.add("Right Fill*4", p2);
        pRight.add(panel);
        int code = 2;
        while (code < PsAuthorInfo.getNumCodes()) {
            panel = new Panel();
            panel.setLayout(new GuiStackLayout(0, 0));
            p1 = new Panel();
            p1.setLayout(new BorderLayout());
            p1.add("North", this.m_lInfo[code]);
            panel.add("Left Fill", p1);
            p2 = new Panel();
            p2.setLayout(new BorderLayout());
            p2.add("North", this.m_tInfo[code]);
            panel.add("Right Fill*4", p2);
            pRight.add(panel);
            ++code;
        }
        pRight.addLine(1);
        this.m_pAuthor.add("Right Fill*4", pRight);
        this.add(this.m_pAuthor);
    }
}

