/*
 * Decompiled with CFR 0.152.
 */
package jv.project;

import java.awt.Color;
import java.awt.Image;
import jv.number.PdColor;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PvGeometryIf;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;

public class PgJvxSrc
extends PgGeometry {
    protected int m_geomType;
    protected boolean m_bDefaultLabelEnabled;
    protected boolean m_bShowIndices;
    protected boolean m_bShowVertexLabels;
    protected boolean m_bShowPolygonLabels;
    protected boolean m_bShowEdgeLabels;
    protected boolean m_bShowElementLabels;
    protected boolean m_bShowOutline;
    protected boolean m_bShowBackface;
    protected int m_numVertices;
    protected int m_maxNumVertices;
    protected PdVector[] m_vertex;
    protected String[][] m_vertexFunction;
    protected Color[] m_vertexColor;
    protected PdVector[] m_vertexNormal;
    protected boolean m_bShowVertices;
    protected boolean m_bShowTaggedVertices;
    protected boolean m_bShowVertexNormals;
    protected boolean m_bShowVertexNormalArrow;
    protected boolean m_bShowVertexColors;
    protected double m_globalVertexSize;
    protected Color m_globalVertexColor;
    protected Color m_globalVertexTagColor;
    protected double m_globalVertexNormalLength;
    protected double m_globalVertexNormalSize;
    protected Color m_globalVertexNormalColor;
    protected int m_numVectorFields;
    private int[] m_dimOfVectors;
    protected PdVector[][] m_vector;
    protected Color[][] m_vectorColor;
    protected String[] m_vectorName;
    protected boolean[] m_bShowVectorField;
    protected boolean[] m_bShowVectorArrow;
    protected boolean[] m_vectorIsElementBased;
    protected double[] m_globalVectorLength;
    protected double[] m_globalVectorSize;
    protected boolean[] m_bShowVectorColors;
    protected Color[] m_globalVectorColor;
    protected int m_dimOfTextures;
    protected boolean m_bShowVertexTexture;
    protected boolean m_bShowElementTexture;
    protected String m_textureImageName;
    protected Image m_textureImage;
    protected PdVector[] m_vertexTexture;
    protected int m_numPolygons;
    protected int m_maxNumPolygons;
    protected int m_dimOfPolygons;
    protected PiVector[] m_polygon;
    protected Color[] m_polygonColor;
    protected PdVector[] m_polygonNormal;
    protected boolean m_bShowPolygons;
    protected boolean m_bShowTaggedPolygons;
    protected boolean m_bShowPolygonNormals;
    protected boolean m_bShowPolygonNormalArrow;
    protected boolean m_bShowPolygonColors;
    protected boolean m_bShowPolygonStartArrow;
    protected boolean m_bShowPolygonEndArrow;
    protected Color m_globalPolygonColor;
    protected Color m_globalPolygonTagColor;
    protected double m_globalPolygonSize;
    protected double m_globalPolygonNormalLength;
    protected double m_globalPolygonNormalSize;
    protected Color m_globalPolygonNormalColor;
    protected int m_numEdges;
    protected PiVector[] m_edge;
    protected boolean m_bShowEdges;
    protected boolean m_bShowTaggedEdges;
    protected boolean m_bShowEdgeColors;
    protected Color[] m_edgeColor;
    protected Color m_globalEdgeColor;
    protected Color m_globalEdgeTagColor;
    protected double m_globalEdgeSize;
    protected boolean m_bShowBoundaries;
    protected boolean m_bShowTaggedBoundaries;
    protected Color m_globalBndColor;
    protected Color m_globalBndTagColor;
    protected double m_globalBndSize;
    protected int m_dimOfElements;
    protected int m_maxDimOfElements = 300;
    protected int m_numElements;
    protected int m_maxNumElements;
    protected PiVector[] m_element;
    protected Color[] m_elementColor;
    protected PdVector[] m_elementNormal;
    protected PdVector[][] m_elementTexture;
    protected boolean m_bShowElements;
    protected boolean m_bShowTaggedElements;
    protected boolean m_bShowElementNormals;
    protected boolean m_bShowElementNormalArrow;
    protected boolean m_bShowElementColors;
    protected Color m_globalElementColor;
    protected Color m_globalElementTagColor;
    protected Color m_globalElementBackColor;
    protected Color[] m_elementBackColor;
    protected boolean m_bShowElementBackColor;
    protected boolean m_bShowElementBackColors;
    protected double m_globalElementNormalLength;
    protected double m_globalElementNormalSize;
    protected Color m_globalElementNormalColor;
    protected PiVector[] m_neighbour;

    public Image getTextureImage() {
        return this.m_textureImage;
    }

    public void setTextureImage(Image image) {
        this.m_textureImage = image;
    }

    public void setState(int aKey, boolean aState) {
        switch (aKey) {
            case 50: {
                this.showVertices(aState);
                break;
            }
            default: {
                super.setState(aKey, aState);
            }
        }
    }

    public PdVector[] getPolygonNormals() {
        return this.m_polygonNormal;
    }

    public void assurePolygonNormals() {
        if (this.m_polygonNormal == null || this.m_polygonNormal.length != this.m_maxNumPolygons) {
            this.m_polygonNormal = PdVector.realloc(this.m_polygonNormal, this.m_maxNumPolygons, this.m_dim);
        }
    }

    public void setPolygonNormals(PdVector[] normal) {
        if (normal == null) {
            this.m_polygonNormal = null;
            return;
        }
        if (normal.length < this.m_numPolygons) {
            PsDebug.warning("void length of normal array");
            return;
        }
        if (this.m_polygonNormal == null || this.m_numPolygons > this.m_polygonNormal.length) {
            this.assurePolygonNormals();
        }
        PdVector.copy(this.m_polygonNormal, 0, normal, 0, this.m_numPolygons);
    }

    public boolean isShowingPolygonNormals() {
        return this.m_bShowPolygonNormals;
    }

    public void showPolygonNormals(boolean flag) {
        this.m_bShowPolygonNormals = flag;
    }

    public boolean makeElementNormals() {
        if (this.m_numElements < 1) {
            return false;
        }
        if (this.m_dim == 1 || this.m_dim == 2) {
            PsDebug.warning("normals not computed since vertex dimension = " + this.m_dim);
            return false;
        }
        this.assureElementNormals();
        PdVector edgeB = new PdVector(this.m_dim);
        PdVector edgeC = new PdVector(this.m_dim);
        PdVector normal = new PdVector(this.m_dim);
        PdVector.setConstant(this.m_elementNormal, 0.0);
        int i = 0;
        while (i < this.m_numElements) {
            int numEdges = this.m_element[i].getSize();
            int j = 0;
            while (j < numEdges) {
                PdVector vertexA = this.m_vertex[this.m_element[i].m_data[j]];
                PdVector vertexB = this.m_vertex[this.m_element[i].m_data[(j + 1) % numEdges]];
                PdVector vertexC = this.m_vertex[this.m_element[i].m_data[(j + 2) % numEdges]];
                edgeB.sub(vertexA, vertexB);
                edgeC.sub(vertexC, vertexB);
                normal.cross(edgeC, edgeB);
                if (normal.normalize()) {
                    this.m_elementNormal[i].add(normal);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numElements) {
            this.m_elementNormal[i].normalize();
            ++i;
        }
        return true;
    }

    public PiVector getEdge(int anIndex) {
        if (anIndex < 0 || anIndex >= this.m_numEdges) {
            return null;
        }
        return this.m_edge[anIndex];
    }

    public boolean setEdge(int anIndex, PiVector aEdge) {
        if (anIndex < 0 || aEdge == null) {
            PsDebug.error("index out of range, corrupt argument", this);
            return false;
        }
        if (anIndex >= this.m_numEdges) {
            PsDebug.warning("index=" + anIndex + " > " + this.m_numEdges + "=m_numEdges, bad programming style", this);
            this.setNumEdges(anIndex + 1, -1);
        }
        this.m_edge[anIndex].copy(aEdge);
        return true;
    }

    public Color getGlobalVectorColor(int ind) {
        return this.m_globalVectorColor[ind];
    }

    public boolean setGlobalVectorColor(int ind, Color color) {
        this.m_globalVectorColor[ind] = color;
        return true;
    }

    public Color getGlobalBndTagColor() {
        return this.m_globalBndTagColor;
    }

    public void setGlobalBndTagColor(Color color) {
        this.m_globalBndTagColor = color;
    }

    public boolean isShowingElementBackColor() {
        return this.m_bShowElementBackColor;
    }

    public void showElementBackColor(boolean flag) {
        this.m_bShowElementBackColor = flag;
    }

    public boolean hasTagVertex(int anIndex, int aTag) {
        if (anIndex < 0 || anIndex > this.m_numVertices - 1) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return false;
        }
        return this.m_vertex[anIndex].hasTag(aTag);
    }

    public int addVertex(PdVector aVertex) {
        this.setVertex(this.m_numVertices, aVertex);
        return this.m_numVertices - 1;
    }

    public boolean isShowingPolygonNormalArrow() {
        return this.m_bShowPolygonNormalArrow;
    }

    public void showPolygonNormalArrow(boolean flag) {
        this.m_bShowPolygonNormalArrow = flag;
    }

    public Object clone() {
        PgJvxSrc clone = (PgJvxSrc)super.clone();
        if (clone == null) {
            return null;
        }
        if (this.m_vertex != null) {
            clone.m_vertex = (PdVector[])P_Vector.clone(this.m_vertex);
        }
        if (this.m_vertexColor != null) {
            clone.m_vertexColor = (Color[])this.m_vertexColor.clone();
        }
        if (this.m_vertexFunction != null) {
            clone.m_vertexFunction = PuString.clone(this.m_vertexFunction);
        }
        if (this.m_vertexNormal != null) {
            clone.m_vertexNormal = (PdVector[])P_Vector.clone(this.m_vertexNormal);
        }
        if (this.m_vertexTexture != null) {
            clone.m_vertexTexture = (PdVector[])P_Vector.clone(this.m_vertexTexture);
        }
        if (this.m_polygon != null) {
            clone.m_polygon = (PiVector[])P_Vector.clone(this.m_polygon);
        }
        if (this.m_polygonColor != null) {
            clone.m_polygonColor = (Color[])this.m_polygonColor.clone();
        }
        if (this.m_polygonNormal != null) {
            clone.m_polygonNormal = (PdVector[])P_Vector.clone(this.m_polygonNormal);
        }
        if (this.m_element != null) {
            clone.m_element = (PiVector[])P_Vector.clone(this.m_element);
        }
        if (this.m_elementColor != null) {
            clone.m_elementColor = (Color[])this.m_elementColor.clone();
        }
        if (this.m_elementBackColor != null) {
            clone.m_elementBackColor = (Color[])this.m_elementBackColor.clone();
        }
        if (this.m_elementNormal != null) {
            clone.m_elementNormal = (PdVector[])P_Vector.clone(this.m_elementNormal);
        }
        if (this.m_elementTexture != null) {
            clone.m_elementTexture = (PdVector[][])P_Vector.clone(this.m_elementTexture);
        }
        if (this.m_neighbour != null) {
            clone.m_neighbour = (PiVector[])P_Vector.clone(this.m_neighbour);
        }
        if (this.m_edge != null) {
            clone.m_edge = (PiVector[])P_Vector.clone(this.m_edge);
        }
        if (this.m_edgeColor != null) {
            clone.m_edgeColor = (Color[])this.m_edgeColor.clone();
        }
        return clone;
    }

    public int getNumVertices() {
        return this.m_numVertices;
    }

    public int getNumEdges() {
        return this.m_numEdges;
    }

    public void setNumVertices(int numVertices) {
        if (numVertices > this.m_maxNumVertices) {
            this.setMaxNumVertices(numVertices);
        }
        this.m_numVertices = numVertices;
    }

    public void setNumEdges(int aNumEdges, int dimOfEdges) {
        if (this.m_numEdges == aNumEdges) {
            return;
        }
        this.m_edge = dimOfEdges > -1 ? PiVector.realloc(this.m_edge, aNumEdges, dimOfEdges) : PiVector.realloc(this.m_edge, aNumEdges);
        this.m_numEdges = aNumEdges;
        if (this.m_edgeColor != null) {
            this.assureEdgeColors();
        }
    }

    public boolean isShowingBackface() {
        return this.m_bShowBackface;
    }

    public void showBackface(boolean flag) {
        this.m_bShowBackface = flag;
        if (!this.m_bShowBackface && this.m_elementNormal == null) {
            this.makeElementNormals();
        }
    }

    public void makeQuadrConn(int uDiscr, int vDiscr, boolean uClosed, boolean vClosed) {
        if (uDiscr < 2 || vDiscr < 2) {
            return;
        }
        int numUIntervals = uDiscr - 1;
        int numVIntervals = vDiscr - 1;
        if (uClosed) {
            ++numUIntervals;
        }
        if (vClosed) {
            ++numVIntervals;
        }
        int ind = 0;
        if (this.m_dimOfElements == 3) {
            this.setNumElements(2 * numUIntervals * numVIntervals);
            int i = 0;
            while (i < numUIntervals) {
                int ip = (i + 1) % uDiscr;
                int j = 0;
                while (j < numVIntervals) {
                    int jp = (j + 1) % vDiscr;
                    this.m_element[ind].m_data[0] = i * vDiscr + j;
                    this.m_element[ind].m_data[1] = ip * vDiscr + j;
                    this.m_element[ind].m_data[2] = i * vDiscr + jp;
                    this.m_element[++ind].m_data[0] = i * vDiscr + jp;
                    this.m_element[ind].m_data[1] = ip * vDiscr + j;
                    this.m_element[ind].m_data[2] = ip * vDiscr + jp;
                    ++ind;
                    ++j;
                }
                ++i;
            }
        } else {
            this.setDimOfElements(4);
            this.setNumElements(numUIntervals * numVIntervals);
            int i = 0;
            while (i < numUIntervals) {
                int ip = (i + 1) % uDiscr;
                int j = 0;
                while (j < numVIntervals) {
                    int jp = (j + 1) % vDiscr;
                    this.m_element[ind].m_data[0] = i * vDiscr + j;
                    this.m_element[ind].m_data[1] = ip * vDiscr + j;
                    this.m_element[ind].m_data[2] = ip * vDiscr + jp;
                    this.m_element[ind].m_data[3] = i * vDiscr + jp;
                    ++ind;
                    ++j;
                }
                ++i;
            }
        }
    }

    public void setDefaultLabelEnabled(boolean flag) {
        this.m_bDefaultLabelEnabled = flag;
    }

    public PdVector[] getAmbientBounds() {
        if (this.m_numVertices == 0) {
            return null;
        }
        PdVector[] bndBox = super.getAmbientBounds();
        PdVector.min(bndBox[0], this.m_vertex, this.m_numVertices);
        PdVector.max(bndBox[1], this.m_vertex, this.m_numVertices);
        return bndBox;
    }

    public PgGeometry reflect(PdMatrix mat, boolean bOrient, boolean bVector) {
        int i;
        PdVector[] reflNormal;
        if (mat == null || mat.getSize() != this.getDimOfVertices() + 1) {
            PsDebug.warning("missing or wrong transformation matrix mat = " + mat);
            return null;
        }
        PgJvxSrc reflGeom = (PgJvxSrc)super.reflect(mat, bOrient, bVector);
        PdVector[] vertex = this.getVertices();
        PdVector[] reflVertex = reflGeom.getVertices();
        int i2 = 0;
        while (i2 < this.m_numVertices) {
            reflVertex[i2].leftMultAffin(mat, vertex[i2], true);
            ++i2;
        }
        if (this.m_vertexNormal != null) {
            PdVector[] normal = this.getVertexNormals();
            reflNormal = reflGeom.getVertexNormals();
            i = 0;
            while (i < this.m_numVertices) {
                reflNormal[i].leftMultAffin(mat, normal[i], false);
                if (!bVector) {
                    reflNormal[i].multScalar(-1.0);
                }
                reflNormal[i].normalize();
                ++i;
            }
        }
        if (!bOrient) {
            PiVector[] reflElement = reflGeom.getElements();
            int i3 = 0;
            while (i3 < this.m_numElements) {
                reflElement[i3].invert();
                ++i3;
            }
        }
        if (this.m_elementNormal != null) {
            PdVector[] normal = this.getElementNormals();
            reflNormal = reflGeom.getElementNormals();
            i = 0;
            while (i < this.m_numElements) {
                reflNormal[i].leftMultAffin(mat, normal[i], false);
                if (!bVector) {
                    reflNormal[i].multScalar(-1.0);
                }
                reflNormal[i].normalize();
                ++i;
            }
        }
        if (!bOrient && this.m_elementTexture != null) {
            PdVector[][] reflTex = reflGeom.getElementTextures();
            i = 0;
            while (i < this.m_numElements) {
                int len = reflTex[i].length;
                int nop = len / 2;
                int k = 0;
                while (k < nop) {
                    PdVector tmp = reflTex[i][k];
                    reflTex[i][k] = reflTex[i][len - 1 - k];
                    reflTex[i][len - 1 - k] = tmp;
                    ++k;
                }
                ++i;
            }
        }
        return reflGeom;
    }

    public int addEdge(PiVector anEdge) {
        this.setEdge(this.m_numEdges, anEdge);
        return this.m_numEdges - 1;
    }

    public Color[] getVertexColors() {
        return this.m_vertexColor;
    }

    public void init() {
        super.init();
        this.m_geomType = -1;
        this.m_vertexColor = null;
        this.m_vertexNormal = null;
        this.m_vertexFunction = null;
        this.m_vertexTexture = null;
        this.m_bShowVertices = false;
        this.m_bShowTaggedVertices = true;
        this.m_bShowVertexNormals = false;
        this.m_bShowVertexNormalArrow = false;
        this.m_bShowVertexColors = false;
        this.setMaxNumVertices(0);
        this.m_bDefaultLabelEnabled = false;
        this.m_bShowIndices = false;
        this.m_bShowVertexLabels = false;
        this.m_bShowPolygonLabels = false;
        this.m_bShowEdgeLabels = false;
        this.m_bShowElementLabels = false;
        this.m_polygonColor = null;
        this.m_polygonNormal = null;
        this.m_bShowPolygons = false;
        this.m_bShowTaggedPolygons = true;
        this.m_bShowPolygonStartArrow = false;
        this.m_bShowPolygonEndArrow = false;
        this.m_bShowPolygonNormals = false;
        this.m_bShowPolygonNormalArrow = false;
        this.m_bShowPolygonColors = false;
        this.m_dimOfPolygons = -1;
        this.setMaxNumPolygons(0);
        this.m_elementNormal = null;
        this.m_elementColor = null;
        this.m_elementTexture = null;
        this.m_bShowElements = true;
        this.m_bShowTaggedElements = true;
        this.m_bShowBackface = true;
        this.m_bShowElementNormals = false;
        this.m_bShowElementNormalArrow = false;
        this.m_bShowElementColors = false;
        this.m_bShowElementBackColor = false;
        this.m_bShowElementBackColors = false;
        this.m_dimOfElements = -1;
        this.setMaxNumElements(0);
        this.m_edgeColor = null;
        this.m_bShowOutline = false;
        this.m_bShowEdges = true;
        this.m_bShowTaggedEdges = true;
        this.m_bShowEdgeColors = false;
        this.m_bShowBoundaries = false;
        this.m_bShowTaggedBoundaries = true;
        this.m_bShowVertexTexture = false;
        this.m_bShowElementTexture = false;
        this.m_globalVertexSize = 2.0;
        this.m_globalVertexColor = Color.red;
        this.m_globalVertexTagColor = Color.magenta;
        this.m_globalVertexNormalSize = 1.0;
        this.m_globalVertexNormalLength = 2.0;
        this.m_globalVertexNormalColor = Color.yellow;
        this.m_numVectorFields = 0;
        this.m_vector = null;
        this.m_bShowVectorField = null;
        this.m_bShowVectorArrow = null;
        this.m_globalVectorColor = null;
        this.m_globalVectorLength = null;
        this.m_globalVectorSize = null;
        this.m_dimOfTextures = 2;
        this.m_globalPolygonColor = Color.black;
        this.m_globalPolygonTagColor = Color.red;
        this.m_globalPolygonSize = 1.0;
        this.m_globalPolygonNormalSize = 1.0;
        this.m_globalPolygonNormalLength = 2.0;
        this.m_globalPolygonNormalColor = Color.yellow;
        this.m_globalElementColor = new Color(100, 230, 255);
        this.m_globalElementBackColor = new Color(100, 230, 255);
        this.m_globalElementTagColor = Color.magenta;
        this.m_globalElementNormalSize = 1.0;
        this.m_globalElementNormalLength = 2.0;
        this.m_globalElementNormalColor = Color.yellow;
        this.m_globalEdgeColor = Color.black;
        this.m_globalEdgeTagColor = Color.red;
        this.m_globalEdgeSize = 1.0;
        this.m_globalBndColor = Color.blue;
        this.m_globalBndTagColor = Color.magenta;
        this.m_globalBndSize = 3.0;
    }

    public Color[] getEdgeColors() {
        return this.m_edgeColor;
    }

    public Color[] getElementColors() {
        return this.m_elementColor;
    }

    public void assureVertexColors() {
        if (this.m_vertexColor == null || this.m_vertexColor.length != this.m_maxNumVertices) {
            this.m_vertexColor = PdColor.realloc(this.m_vertexColor, this.m_maxNumVertices);
        }
    }

    public int getDimOfVectors(int ind) {
        return this.m_dimOfVectors[ind];
    }

    public PdVector[] getVectors(int ind) {
        return this.m_vector[ind];
    }

    public void setVectors(int ind, PdVector[] list) {
        if (ind < 0 || this.m_numVectorFields <= ind) {
            PsDebug.warning("index out of bounds, ind=" + ind);
            return;
        }
        if (list == null) {
            PsDebug.warning("missing list of vectors of vector field[" + ind + "].");
            return;
        }
        if (list.length < this.m_vector[ind].length) {
            PsDebug.warning("length of argument list smaller than known size");
            return;
        }
        PdVector.copy(this.m_vector[ind], 0, list, 0, this.m_vector[ind].length);
    }

    public Color[] getVectorFieldColors(int ind) {
        return this.m_vectorColor[ind];
    }

    public void assureEdgeColors() {
        if (this.m_edgeColor == null || this.m_edgeColor.length != this.m_numEdges) {
            this.m_edgeColor = PdColor.realloc(this.m_edgeColor, this.m_numEdges);
        }
    }

    public void assureElementColors() {
        if (this.m_elementColor == null || this.m_elementColor.length != this.m_maxNumElements) {
            this.m_elementColor = PdColor.realloc(this.m_elementColor, this.m_maxNumElements);
        }
    }

    public void setVertexColors(Color[] aVertexColorList) {
        if (aVertexColorList == null) {
            this.m_vertexColor = null;
            return;
        }
        if (aVertexColorList.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVertexColors();
        PdColor.copy(this.m_vertexColor, 0, aVertexColorList, 0, this.m_numVertices);
    }

    public void setEdgeColors(Color[] color) {
        if (color == null) {
            this.m_edgeColor = null;
            return;
        }
        if (color.length < this.m_numEdges) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.m_edgeColor == null || this.m_numEdges > this.m_edgeColor.length) {
            this.assureEdgeColors();
        }
        PdColor.copy(this.m_edgeColor, 0, color, 0, this.m_numEdges);
    }

    public void setElementColors(Color[] color) {
        if (color == null) {
            this.m_elementColor = null;
            return;
        }
        if (color.length < this.m_numElements) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.m_elementColor == null || this.m_numElements > this.m_elementColor.length) {
            this.assureElementColors();
        }
        PdColor.copy(this.m_elementColor, 0, color, 0, this.m_numElements);
    }

    public boolean isShowingVertexColors() {
        return this.m_bShowVertexColors;
    }

    public void showVertexColors(boolean flag) {
        this.m_bShowVertexColors = flag;
    }

    public boolean isShowingEdgeColors() {
        return this.m_bShowEdgeColors;
    }

    public double getGlobalVectorSize(int ind) {
        return this.m_globalVectorSize[ind];
    }

    public boolean setGlobalVectorSize(int ind, double size) {
        this.m_globalVectorSize[ind] = size;
        return true;
    }

    public void showEdgeColors(boolean flag) {
        this.m_bShowEdgeColors = flag;
    }

    public boolean isShowingPolygonStartArrow() {
        return this.m_bShowPolygonStartArrow;
    }

    public void showPolygonStartArrow(boolean flag) {
        this.m_bShowPolygonStartArrow = flag;
    }

    public boolean isShowingElementColors() {
        return this.m_bShowElementColors;
    }

    public boolean isShowingVertexTexture() {
        return this.m_bShowVertexTexture;
    }

    public boolean isShowingElementTexture() {
        return this.m_bShowElementTexture;
    }

    public void showElementColors(boolean flag) {
        this.m_bShowElementColors = flag;
    }

    public void showVertexTexture(boolean flag) {
        this.m_bShowVertexTexture = flag;
    }

    public void showElementTexture(boolean flag) {
        this.m_bShowElementTexture = flag;
    }

    public int getNumPolygons() {
        return this.m_numPolygons;
    }

    public void setNumPolygons(int numPolygons) {
        this.setDimOfSimplex(1);
        if (numPolygons > this.m_maxNumPolygons) {
            this.setMaxNumPolygons(numPolygons);
        }
        this.m_numPolygons = numPolygons;
    }

    public boolean isDefaultLabelEnabled() {
        return this.m_bDefaultLabelEnabled;
    }

    public double getGlobalVertexNormalLength() {
        return this.m_globalVertexNormalLength;
    }

    public void setGlobalVertexNormalLength(double length) {
        this.m_globalVertexNormalLength = length;
    }

    public double getGlobalElementNormalLength() {
        return this.m_globalElementNormalLength;
    }

    public void setGlobalElementNormalLength(double length) {
        this.m_globalElementNormalLength = length;
    }

    public String getVectorFieldName(int ind) {
        return this.m_vectorName[ind];
    }

    public void setVectorFieldName(int ind, String name) {
        this.m_vectorName[ind] = name;
    }

    public PdVector[] getVertexNormals() {
        return this.m_vertexNormal;
    }

    public PdVector[] getElementNormals() {
        return this.m_elementNormal;
    }

    public void assureVertexNormals() {
        if (this.m_vertexNormal == null || this.m_vertexNormal.length != this.m_maxNumVertices) {
            this.m_vertexNormal = PdVector.realloc(this.m_vertexNormal, this.m_maxNumVertices, this.m_dim);
        }
    }

    public void assureElementNormals() {
        if (this.m_elementNormal == null || this.m_elementNormal.length != this.m_maxNumElements) {
            this.m_elementNormal = PdVector.realloc(this.m_elementNormal, this.m_maxNumElements, this.m_dim);
        }
    }

    public void setVertexNormals(PdVector[] aVertexNormalList) {
        if (aVertexNormalList == null) {
            this.m_vertexNormal = null;
            return;
        }
        if (aVertexNormalList.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVertexNormals();
        PdVector.copy(this.m_vertexNormal, 0, aVertexNormalList, 0, this.m_numVertices);
    }

    public void setElementNormals(PdVector[] normal) {
        if (normal == null) {
            this.m_elementNormal = null;
            return;
        }
        if (normal.length < this.m_numElements) {
            PsDebug.warning("void length of normal array");
            return;
        }
        if (this.m_elementNormal == null || this.m_numElements > this.m_elementNormal.length) {
            this.assureElementNormals();
        }
        PdVector.copy(this.m_elementNormal, 0, normal, 0, this.m_numElements);
    }

    public boolean isShowingVertexNormals() {
        return this.m_bShowVertexNormals;
    }

    public void showVertexNormals(boolean flag) {
        this.m_bShowVertexNormals = flag;
    }

    public boolean isShowingElementNormals() {
        return this.m_bShowElementNormals;
    }

    public void showElementNormals(boolean flag) {
        this.m_bShowElementNormals = flag;
    }

    public PgJvxSrc() {
        this(3);
        this.init();
    }

    protected PgJvxSrc(int dim) {
        super(dim);
        this.setDimOfSimplex(1);
        this.m_dim = dim;
    }

    public void paint(PvGeometryIf dc) {
        super.paint(dc);
        dc.setState(85, this.m_bDefaultLabelEnabled);
        dc.setState(80, this.isShowingIndices());
        dc.setState(81, this.isShowingVertexLabels());
        dc.setState(83, this.isShowingEdgeLabels());
        dc.setState(82, this.isShowingPolygonLabels());
        dc.setState(84, this.isShowingElementLabels());
        dc.setState(50, this.m_bShowVertices);
        dc.setState(51, this.m_bShowTaggedVertices);
        dc.setGlobalVertexSize((int)this.m_globalVertexSize);
        dc.setGlobalVertexColor(this.m_globalVertexColor);
        dc.setGlobalVertexTagColor(this.m_globalVertexTagColor);
        dc.setNumVertices(this.m_numVertices);
        dc.setVertices(this.m_vertex);
        dc.setVertexColors(this.m_vertexColor);
        dc.setVertexNormals(this.m_vertexNormal);
        dc.setGlobalVertexNormalSize(this.m_globalVertexNormalSize);
        dc.setGlobalVertexNormalLength(this.m_globalVertexNormalLength);
        dc.setGlobalVertexNormalColor(this.m_globalVertexNormalColor);
        dc.setState(90, this.m_bShowVertexColors && this.m_vertexColor != null);
        dc.setState(60, this.m_bShowVertexNormals);
        dc.setState(61, this.m_bShowVertexNormalArrow);
        dc.setVertexTextures(this.m_vertexTexture);
        dc.setState(71, this.m_vertexTexture != null && this.m_bShowVertexTexture);
        dc.setNumVectorFields(this.m_numVectorFields);
        int i = 0;
        while (i < this.m_numVectorFields) {
            if (this.m_vectorIsElementBased[i]) {
                dc.setNumVectors(i, this.m_numElements, this.m_dimOfVectors[i]);
            } else {
                dc.setNumVectors(i, this.m_numVertices, this.m_dimOfVectors[i]);
            }
            dc.setVectorList(i, this.m_vector[i]);
            dc.setElementBased(i, this.m_vectorIsElementBased[i]);
            dc.showVectorField(i, this.m_bShowVectorField[i]);
            dc.showVectorArrows(i, this.m_bShowVectorArrow[i]);
            dc.showVectorColors(i, this.m_bShowVectorColors[i]);
            dc.setGlobalVectorColor(i, this.m_globalVectorColor[i]);
            dc.setGlobalVectorLength(i, this.m_globalVectorLength[i]);
            dc.setGlobalVectorSize(i, this.m_globalVectorSize[i]);
            ++i;
        }
        dc.setState(54, this.m_bShowPolygons);
        dc.setState(55, this.m_bShowTaggedPolygons);
        dc.setGlobalPolygonSize(this.m_globalPolygonSize);
        dc.setGlobalPolygonColor(this.m_globalPolygonColor);
        dc.setNumPolygons(this.m_numPolygons);
        dc.setPolygons(this.m_polygon);
        dc.setPolygonColors(this.m_polygonColor);
        dc.setPolygonNormals(this.m_polygonNormal);
        dc.setGlobalPolygonNormalSize(this.m_globalPolygonNormalSize);
        dc.setGlobalPolygonNormalLength(this.m_globalPolygonNormalLength);
        dc.setGlobalPolygonNormalColor(this.m_globalPolygonNormalColor);
        dc.setState(88, this.m_bShowPolygonStartArrow);
        dc.setState(89, this.m_bShowPolygonEndArrow);
        dc.setState(92, this.m_bShowPolygonColors && this.m_polygonColor != null);
        dc.setState(64, this.m_bShowPolygonNormals);
        dc.setState(65, this.m_bShowPolygonNormalArrow);
        dc.setState(68, this.m_bShowBackface);
        dc.setState(87, this.m_bShowOutline);
        dc.setState(52, this.m_bShowEdges);
        dc.setState(53, this.m_bShowTaggedEdges);
        dc.setState(93, this.m_bShowEdgeColors);
        if (this.m_bShowEdges || this.m_bShowOutline) {
            dc.setGlobalEdgeSize(this.m_globalEdgeSize);
            dc.setGlobalEdgeColor(this.m_globalEdgeColor);
            dc.setGlobalEdgeTagColor(this.m_globalEdgeTagColor);
        }
        dc.setState(58, this.m_bShowBoundaries);
        dc.setState(59, this.m_bShowTaggedBoundaries);
        if (this.m_bShowBoundaries || this.m_bShowOutline) {
            dc.setGlobalBndSize(this.m_globalBndSize);
            dc.setGlobalBndColor(this.m_globalBndColor);
            dc.setGlobalBndTagColor(this.m_globalBndTagColor);
        }
        dc.setState(56, this.m_bShowElements);
        dc.setState(57, true);
        dc.setNumElements(this.m_numElements);
        dc.setElements(this.m_element);
        dc.setNeighbours(this.m_neighbour);
        dc.setState(94, this.isShowingElementColors() && this.m_elementColor != null);
        dc.setElementColors(this.m_elementColor);
        dc.setState(99, this.m_bShowElementBackColor);
        dc.setState(100, this.m_bShowElementBackColors);
        dc.setElementBackColors(this.m_elementBackColor);
        dc.setState(62, this.m_bShowElementNormals);
        dc.setState(63, this.m_bShowElementNormalArrow);
        dc.setElementNormals(this.m_elementNormal);
        dc.setGlobalElementNormalSize(this.m_globalElementNormalSize);
        dc.setGlobalElementNormalLength(this.m_globalElementNormalLength);
        dc.setGlobalElementNormalColor(this.m_globalElementNormalColor);
        dc.setState(72, this.m_elementTexture != null && this.m_bShowElementTexture);
        dc.setElementTextures(this.m_elementTexture);
        dc.setGlobalElementColor(this.m_globalElementColor);
        dc.setGlobalElementBackColor(this.m_globalElementBackColor);
        dc.setGlobalElementTagColor(this.m_globalElementTagColor);
    }

    public void clearTagVertex(int anIndex, int aTag) {
        if (anIndex < 0 || anIndex > this.m_numVertices - 1) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return;
        }
        this.m_vertex[anIndex].clearTag(aTag);
    }

    public PdVector getVertex(int anIndex) {
        if (anIndex < 0 || anIndex > this.m_numVertices - 1) {
            PsDebug.warning("index out of range");
            return null;
        }
        return this.m_vertex[anIndex];
    }

    public boolean setVertex(int anIndex, PdVector aVertex) {
        if (anIndex < 0 || anIndex > this.m_numVertices - 1) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return false;
        }
        if (aVertex == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        this.m_vertex[anIndex].copy(aVertex);
        return true;
    }

    public Color getGlobalPolygonTagColor() {
        return this.m_globalPolygonTagColor;
    }

    public boolean isShowingVectorField(int ind) {
        return this.m_bShowVectorField[ind];
    }

    public void showVectorField(int ind, boolean flag) {
        this.m_bShowVectorField[ind] = flag;
    }

    public void setGlobalPolygonTagColor(Color color) {
        this.m_globalPolygonTagColor = color;
    }

    public Color getGlobalBndColor() {
        return this.m_globalBndColor;
    }

    public void setGlobalBndColor(Color color) {
        this.m_globalBndColor = color;
    }

    public boolean isShowingVertexNormalArrow() {
        return this.m_bShowVertexNormalArrow;
    }

    public void showVertexNormalArrow(boolean flag) {
        this.m_bShowVertexNormalArrow = flag;
    }

    public boolean isShowingElementNormalArrow() {
        return this.m_bShowElementNormalArrow;
    }

    public void showElementNormalArrow(boolean flag) {
        this.m_bShowElementNormalArrow = flag;
    }

    public String[][] getVertexFunctions() {
        return this.m_vertexFunction;
    }

    public void setVertexFunctions(String[][] vertex) {
        if (vertex == null || vertex.length == 0 || vertex.length < this.m_numVertices) {
            PsDebug.warning("void length of argument vertex array");
            return;
        }
        int dimSav = vertex[0].length;
        int i = 0;
        while (i < this.m_numVertices) {
            int dim = vertex[i].length;
            this.m_vertex[i].setSize(dim);
            if (dimSav != -1 && dim != dimSav) {
                dimSav = -1;
            }
            ++i;
        }
        this.m_dim = dimSav;
        this.m_vertexFunction = vertex;
    }

    public boolean isShowingIndices() {
        return this.m_bShowIndices;
    }

    public void showIndices(boolean flag) {
        this.m_bShowIndices = flag;
    }

    public PgJvxSrc getJvx() {
        return this;
    }

    public void setJvx(PgJvxSrc src) {
        this.copy(src);
    }

    public int getNumElements() {
        return this.m_numElements;
    }

    public void setNumElements(int numElements) {
        this.setDimOfSimplex(2);
        if (numElements > this.m_maxNumElements) {
            this.setMaxNumElements(numElements);
        }
        this.m_numElements = numElements;
    }

    public int addPolygon(PiVector anPolygon) {
        this.setPolygon(this.m_numPolygons, anPolygon);
        return this.m_numPolygons - 1;
    }

    public boolean isShowingOutline() {
        return this.m_bShowOutline;
    }

    public void showOutline(boolean flag) {
        this.m_bShowOutline = flag;
    }

    public int addElement(PiVector anElement) {
        this.setNumElements(this.m_numElements + 1);
        this.setElement(this.m_numElements - 1, anElement);
        return this.m_numElements - 1;
    }

    public int getNumVectors(int ind) {
        return this.m_vector[ind].length;
    }

    public void setNumVectors(int ind, int num, int dimOfVectors) {
        this.m_dimOfVectors[ind] = dimOfVectors;
        this.m_vector[ind] = PdVector.realloc(this.m_vector[ind], num, dimOfVectors);
    }

    public boolean isShowingVectorColors(int ind) {
        return this.m_bShowVectorColors[ind];
    }

    public void showVectorColors(int ind, boolean flag) {
        this.m_bShowVectorColors[ind] = flag;
    }

    public void assureVectorColors(int ind) {
        if (ind < 0 || this.m_numVectorFields <= ind) {
            PsDebug.warning("index out of bounds, ind=" + ind);
            return;
        }
        if (this.m_vectorColor[ind] == null || this.m_vectorColor[ind].length != this.m_vector[ind].length) {
            this.m_vectorColor[ind] = PdColor.realloc(this.m_vectorColor[ind], this.m_vector[ind].length);
        }
    }

    public void setVectorColors(int ind, Color[] list) {
        if (ind < 0 || this.m_numVectorFields <= ind) {
            PsDebug.warning("index out of bounds, ind=" + ind);
            return;
        }
        if (list == null) {
            this.m_vectorColor[ind] = null;
            this.m_bShowVectorColors[ind] = false;
            return;
        }
        if (list != null && list.length < this.m_vector[ind].length) {
            PsDebug.warning("color array is too small");
            return;
        }
        this.assureVectorColors(ind);
        PdColor.copy(this.m_vectorColor[ind], 0, list, 0, this.m_vector[ind].length);
    }

    public Color getGlobalVertexColor() {
        return this.m_globalVertexColor;
    }

    public Color getGlobalVertexNormalColor() {
        return this.m_globalVertexNormalColor;
    }

    public void setGlobalVertexColor(Color color) {
        this.m_globalVertexColor = color;
    }

    public void setGlobalVertexNormalColor(Color color) {
        this.m_globalVertexNormalColor = color;
    }

    public Color getGlobalEdgeColor() {
        return this.m_globalEdgeColor;
    }

    public PdVector[] getVertexTextures() {
        return this.m_vertexTexture;
    }

    public PdVector[][] getElementTextures() {
        return this.m_elementTexture;
    }

    public void assureVertexTextures() {
        if (this.m_vertexTexture == null || this.m_vertexTexture.length != this.m_maxNumVertices) {
            this.m_vertexTexture = PdVector.realloc(this.m_vertexTexture, this.m_maxNumVertices, this.m_dimOfTextures);
        }
    }

    public void assureElementTextures() {
        if (this.m_elementTexture == null || this.m_elementTexture.length != this.m_maxNumElements) {
            this.m_elementTexture = new PdVector[this.m_maxNumElements][];
        }
        int i = 0;
        while (i < this.m_maxNumElements) {
            this.m_elementTexture[i] = PdVector.realloc(this.m_elementTexture[i], this.m_element[i].getSize(), this.m_dimOfTextures);
            ++i;
        }
    }

    public void setGlobalEdgeColor(Color color) {
        this.m_globalEdgeColor = color;
    }

    public Color getGlobalElementColor() {
        return this.m_globalElementColor;
    }

    public int getNumVectorFields() {
        return this.m_numVectorFields;
    }

    public void setNumVectorFields(int num) {
        if (num == this.m_numVectorFields) {
            return;
        }
        PdVector[][] newVector = new PdVector[num][];
        int i = 0;
        while (i < Math.min(num, this.m_numVectorFields)) {
            newVector[i] = this.m_vector[i];
            ++i;
        }
        i = Math.min(num, this.m_numVectorFields);
        while (i < num) {
            newVector[i] = new PdVector[0];
            ++i;
        }
        this.m_vector = newVector;
        Color[][] newColor = new Color[num][];
        int i2 = 0;
        while (i2 < Math.min(num, this.m_numVectorFields)) {
            newColor[i2] = this.m_vectorColor[i2];
            ++i2;
        }
        this.m_vectorColor = newColor;
        this.m_dimOfVectors = PuData.realloc(this.m_dimOfVectors, num);
        this.m_vectorName = PuData.realloc(this.m_vectorName, num);
        this.m_bShowVectorField = PuData.realloc(this.m_bShowVectorField, num);
        this.m_bShowVectorArrow = PuData.realloc(this.m_bShowVectorArrow, num);
        this.m_bShowVectorColors = PuData.realloc(this.m_bShowVectorColors, num);
        if (num > this.m_numVectorFields) {
            i2 = this.m_numVectorFields;
            while (i2 < num) {
                this.m_bShowVectorField[i2] = true;
                this.m_bShowVectorArrow[i2] = false;
                this.m_bShowVectorColors[i2] = false;
                ++i2;
            }
        }
        this.m_vectorIsElementBased = PuData.realloc(this.m_vectorIsElementBased, num);
        this.m_globalVectorLength = PuData.realloc(this.m_globalVectorLength, num);
        this.m_globalVectorSize = PuData.realloc(this.m_globalVectorSize, num);
        this.m_globalVectorColor = PdColor.realloc(this.m_globalVectorColor, num);
        this.m_numVectorFields = num;
        i2 = 0;
        while (i2 < this.m_numVectorFields) {
            this.m_globalVectorSize[i2] = 1.0;
            this.m_globalVectorLength[i2] = 1.0;
            this.m_globalVectorColor[i2] = Color.yellow;
            ++i2;
        }
    }

    public Color getGlobalElementNormalColor() {
        return this.m_globalElementNormalColor;
    }

    public void setGlobalElementColor(Color color) {
        this.m_globalElementColor = color;
    }

    public void setGlobalElementNormalColor(Color color) {
        this.m_globalElementNormalColor = color;
    }

    public double getGlobalBndSize() {
        return this.m_globalBndSize;
    }

    public void setGlobalBndSize(double size) {
        this.m_globalBndSize = size;
    }

    public void setVertexTextures(PdVector[] aVertexTextureList) {
        if (aVertexTextureList == null) {
            this.m_vertexTexture = null;
            return;
        }
        if (aVertexTextureList.length < this.m_numVertices) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVertexTextures();
        PdVector.copy(this.m_vertexTexture, 0, aVertexTextureList, 0, this.m_numVertices);
    }

    public void setElementTextures(PdVector[][] texCoords) {
        if (texCoords == null) {
            this.m_elementTexture = null;
            return;
        }
        if (texCoords.length < this.m_numElements) {
            PsDebug.warning("void length of tex array");
            return;
        }
        int i = 0;
        while (i < this.m_numElements) {
            if (texCoords[i] == null || texCoords[i].length != this.m_element[i].getSize()) {
                PsDebug.warning("void length of texCoords[" + i + "]");
                return;
            }
            ++i;
        }
        this.assureElementTextures();
        i = 0;
        while (i < this.m_numElements) {
            PdVector.copy(this.m_elementTexture[i], 0, texCoords[i], 0, this.m_element[i].getSize());
            ++i;
        }
    }

    public boolean isShowingVertexLabels() {
        return this.m_bShowVertexLabels;
    }

    public boolean isShowingEdgeLabels() {
        return this.m_bShowEdgeLabels;
    }

    public boolean isShowingElementLabels() {
        return this.m_bShowElementLabels;
    }

    public void showVertexLabels(boolean flag) {
        this.m_bShowVertexLabels = flag;
    }

    public void showEdgeLabels(boolean flag) {
        this.m_bShowEdgeLabels = flag;
    }

    public void showElementLabels(boolean flag) {
        this.m_bShowElementLabels = flag;
    }

    public boolean isShowingVectorArrows(int ind) {
        return this.m_bShowVectorArrow[ind];
    }

    public void showVectorArrows(int ind, boolean flag) {
        this.m_bShowVectorArrow[ind] = flag;
    }

    public PiVector[] getElements() {
        return this.m_element;
    }

    public void setDimOfElements(int aSize) {
        if (aSize == this.m_dimOfElements) {
            return;
        }
        if (aSize != -1 && aSize < 3) {
            PsDebug.warning("argument aSize=" + aSize + " out of range.");
            return;
        }
        this.m_dimOfElements = aSize;
        if (aSize == -1) {
            int i = this.m_numElements;
            while (i < this.m_maxNumElements) {
                this.m_element[i].setSize(0);
                this.m_neighbour[i].setSize(0);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.m_maxNumElements) {
                this.m_element[i].setSize(aSize);
                this.m_neighbour[i].setSize(aSize);
                this.m_neighbour[i].setConstant(-1);
                ++i;
            }
        }
    }

    protected void setMaxNumElements(int numElements) {
        if (this.m_maxNumElements == numElements) {
            return;
        }
        this.m_maxNumElements = numElements;
        this.m_element = this.m_dimOfElements > -1 ? PiVector.realloc(this.m_element, numElements, this.m_dimOfElements) : PiVector.realloc(this.m_element, numElements);
        this.assureNeighbours();
        if (this.m_elementNormal != null) {
            this.assureElementNormals();
        }
        if (this.m_elementColor != null) {
            this.assureElementColors();
        }
        if (this.m_elementBackColor != null) {
            this.assureElementBackColors();
        }
        if (this.m_maxNumElements < this.m_numElements) {
            this.m_numElements = this.m_maxNumElements;
        }
        if (this.m_elementTexture != null) {
            this.assureElementTextures();
        }
    }

    public String getTextureImageName() {
        return this.m_textureImageName;
    }

    public void setTextureImageName(String image) {
        this.m_textureImageName = image;
    }

    public void setElements(PiVector[] element) {
        if ((element == null || element.length == 0) && this.m_numElements == 0) {
            return;
        }
        if (element.length < this.m_numElements) {
            PsDebug.warning("void length of element array");
            return;
        }
        int maxElemDim = 0;
        int dimSav = element[0].getSize();
        int i = 0;
        while (i < this.m_numElements) {
            int dim;
            if (element[i].m_data == null) {
                dim = 0;
            } else {
                dim = element[i].m_data.length;
                if (dim > this.m_maxDimOfElements) {
                    maxElemDim = dim;
                    dim = this.m_maxDimOfElements;
                }
            }
            if (this.m_element[i].m_data == null || this.m_element[i].m_data.length != dim) {
                this.m_element[i].setSize(dim);
            }
            if (dimSav != -1 && dim != dimSav) {
                dimSav = -1;
            }
            ++i;
        }
        if (this.m_dimOfElements != dimSav) {
            this.setDimOfElements(dimSav);
        }
        PiVector.copy(this.m_element, 0, element, 0, this.m_numElements);
        if (this.m_dimOfElements == -1) {
            this.assureNeighbours();
        }
        if (maxElemDim > 0) {
            PsDebug.error("maximal dimension of an element = " + maxElemDim + " truncated to size = " + this.m_maxDimOfElements);
        }
    }

    public boolean isShowingElements() {
        return this.m_bShowElements;
    }

    public void showElements(boolean flag) {
        this.m_bShowElements = flag;
    }

    public void setVectorElementBased(int ind, boolean flag) {
        this.m_vectorIsElementBased[ind] = flag;
    }

    public boolean isShowingPolygonLabels() {
        return this.m_bShowPolygonLabels;
    }

    public void showPolygonLabels(boolean flag) {
        this.m_bShowPolygonLabels = flag;
    }

    public void copy(PgJvxSrc src) {
        if (src == this) {
            return;
        }
        PsDebug.warning("missing implementation of PgJvxSrc#copy(PgJvxSrc)");
        super.copy(src);
    }

    public boolean isShowingBoundaries() {
        return this.m_bShowBoundaries;
    }

    public void showBoundaries(boolean flag) {
        this.m_bShowBoundaries = flag;
    }

    public boolean isShowingPolygonEndArrow() {
        return this.m_bShowPolygonEndArrow;
    }

    public void showPolygonEndArrow(boolean flag) {
        this.m_bShowPolygonEndArrow = flag;
    }

    public Color getGlobalVertexTagColor() {
        return this.m_globalVertexTagColor;
    }

    public void setGlobalVertexTagColor(Color color) {
        this.m_globalVertexTagColor = color;
    }

    public Color getGlobalPolygonColor() {
        return this.m_globalPolygonColor;
    }

    public Color getGlobalPolygonNormalColor() {
        return this.m_globalPolygonNormalColor;
    }

    public void setGlobalPolygonColor(Color color) {
        this.m_globalPolygonColor = color;
    }

    public void setGlobalPolygonNormalColor(Color color) {
        this.m_globalPolygonNormalColor = color;
    }

    public Color getGlobalEdgeTagColor() {
        return this.m_globalEdgeTagColor;
    }

    public void setGlobalEdgeTagColor(Color color) {
        this.m_globalEdgeTagColor = color;
    }

    public Color getGlobalElementBackColor() {
        return this.m_globalElementBackColor;
    }

    public Color getGlobalElementTagColor() {
        return this.m_globalElementTagColor;
    }

    public void setGlobalElementBackColor(Color color) {
        this.m_globalElementBackColor = color;
    }

    public void setGlobalElementTagColor(Color color) {
        this.m_globalElementTagColor = color;
    }

    protected void setDimOfElement(int ind, int aSize) {
        if (this.m_dimOfElements == aSize) {
            return;
        }
        if (ind < 0 || this.m_numElements <= ind) {
            PsDebug.warning("index out of range, ind = " + ind);
            return;
        }
        if (aSize < 3) {
            PsDebug.warning("argument aSize=" + aSize + " out of range.");
            return;
        }
        if (this.m_numElements == 1) {
            this.setDimOfElements(aSize);
        } else if (this.m_dimOfElements != -1) {
            PsDebug.notify("m_dimOfElements != aSize = " + aSize);
            this.setDimOfElements(-1);
        }
        this.m_element[ind].setSize(aSize);
        this.m_neighbour[ind].setSize(aSize);
        this.m_neighbour[ind].setConstant(-1);
    }

    public PiVector getElement(int anIndex) {
        if (anIndex < 0 || anIndex >= this.m_numElements) {
            return null;
        }
        return this.m_element[anIndex];
    }

    public boolean setElement(int anIndex, PiVector newElem) {
        if (anIndex < 0 || anIndex > this.m_numElements - 1) {
            PsDebug.error("index=" + anIndex + " out of range", this);
            return false;
        }
        if (newElem == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        int elemLen = newElem.getSize();
        if (elemLen > this.m_maxDimOfElements) {
            elemLen = this.m_maxDimOfElements;
            PsDebug.error("maximal dimension of element = " + elemLen + " truncated to size = " + this.m_maxDimOfElements);
        }
        this.setDimOfElement(anIndex, elemLen);
        this.m_element[anIndex].copy(newElem);
        return true;
    }

    public PiVector[] getNeighbours() {
        return this.m_neighbour;
    }

    public double getGlobalVectorLength(int ind) {
        return this.m_globalVectorLength[ind];
    }

    public boolean setGlobalVectorLength(int ind, double length) {
        this.m_globalVectorLength[ind] = length;
        return true;
    }

    public void assureNeighbours() {
        int i;
        boolean bInit = false;
        if (this.m_neighbour != null && this.m_neighbour.length == this.m_maxNumElements) {
            i = 0;
            while (i < this.m_maxNumElements) {
                if (this.m_neighbour[i].m_data == null || this.m_element[i].m_data == null || this.m_neighbour[i].m_data.length != this.m_element[i].m_data.length) {
                    bInit = true;
                    break;
                }
                ++i;
            }
            if (!bInit) {
                return;
            }
        }
        if (this.m_dimOfElements != -1) {
            this.m_neighbour = PiVector.realloc(this.m_neighbour, this.m_maxNumElements, this.m_dimOfElements);
        } else {
            this.m_neighbour = PiVector.realloc(this.m_neighbour, this.m_maxNumElements);
            i = 0;
            while (i < this.m_maxNumElements) {
                this.m_neighbour[i].setSize(this.m_element[i].getSize());
                ++i;
            }
        }
        i = 0;
        while (i < this.m_maxNumElements) {
            this.m_neighbour[i].setConstant(-1);
            ++i;
        }
    }

    public void setNeighbours(PiVector[] neighbour) {
        if (neighbour == null) {
            this.m_neighbour = null;
            return;
        }
        if (neighbour.length < this.m_numElements) {
            PsDebug.warning("void length of neighbour array");
            return;
        }
        this.assureNeighbours();
        PiVector.copy(this.m_neighbour, 0, neighbour, 0, this.m_numElements);
    }

    public void setDimOfVertices(int dim) {
        this.m_dim = dim;
    }

    public PdVector[] getVertices() {
        return this.m_vertex;
    }

    public PiVector[] getEdges() {
        return this.m_edge;
    }

    protected void setMaxNumVertices(int numVertices) {
        if (this.m_maxNumVertices == numVertices) {
            return;
        }
        this.m_maxNumVertices = numVertices;
        this.m_vertex = PdVector.realloc(this.m_vertex, this.m_maxNumVertices, this.m_dim);
        if (this.m_numVertices > this.m_maxNumVertices) {
            this.m_numVertices = this.m_maxNumVertices;
        }
        if (this.m_vertexColor != null) {
            this.assureVertexColors();
        }
        if (this.m_vertexNormal != null) {
            this.assureVertexNormals();
        }
        if (this.m_vertexTexture != null) {
            this.assureVertexTextures();
        }
    }

    public void setVertices(PdVector[] vertex) {
        if ((vertex == null || vertex.length == 0) && this.m_numVertices == 0) {
            return;
        }
        if (vertex == null || vertex.length == 0 || vertex.length < this.m_numVertices) {
            PsDebug.warning("void length of argument vertex array");
            return;
        }
        int dimSav = vertex[0].getSize();
        int i = 0;
        while (i < this.m_numVertices) {
            int dim = vertex[i].m_data == null ? 0 : vertex[i].m_data.length;
            if (this.m_vertex[i].m_data == null || this.m_vertex[i].m_data.length != dim) {
                this.m_vertex[i].setSize(dim);
            }
            if (dimSav != -1 && dim != dimSav) {
                dimSav = -1;
            }
            ++i;
        }
        this.m_dim = dimSav;
        PdVector.copy(this.m_vertex, 0, vertex, 0, this.m_numVertices);
    }

    public void setEdges(PiVector[] edge) {
        if (edge == null || edge.length == 0 || edge.length < this.m_numEdges) {
            PsDebug.warning("void length of edge array");
            return;
        }
        PiVector.copy(this.m_edge, 0, edge, 0, this.m_numEdges);
    }

    public boolean isShowingVertices() {
        return this.m_bShowVertices;
    }

    public void showVertices(boolean flag) {
        this.m_bShowVertices = flag;
    }

    public boolean isShowingEdges() {
        return this.m_bShowEdges;
    }

    public void showEdges(boolean flag) {
        this.m_bShowEdges = flag;
    }

    public boolean makeElementColorsFromXYZ() {
        if (this.m_numElements == 0) {
            return true;
        }
        this.assureElementColors();
        Color[] color = this.getElementColors();
        PdVector[] bnd = this.getAmbientBounds();
        double[] diag = PdVector.subNew((PdVector)bnd[1], (PdVector)bnd[0]).m_data;
        PdVector vec = new PdVector(this.m_dim);
        PdVector center = new PdVector(this.m_dim);
        int i = 0;
        while (i < this.m_numElements) {
            vec.sub(PgGeometry.getCenterOfElement(center, this.m_vertex, this.m_element[i].m_data), bnd[0]);
            if (this.m_dim == 1) {
                color[i] = new Color((float)(vec.m_data[0] / diag[0]), 0.0f, 0.0f);
            } else if (this.m_dim == 2) {
                color[i] = new Color((float)(vec.m_data[0] / diag[0]), (float)(vec.m_data[1] / diag[1]), 0.0f);
            } else if (this.m_dim >= 3) {
                color[i] = new Color((float)(vec.m_data[0] / diag[0]), (float)(vec.m_data[1] / diag[1]), (float)(vec.m_data[2] / diag[2]));
            }
            ++i;
        }
        return true;
    }

    public int getType() {
        return this.m_geomType;
    }

    public void setType(int type) {
        this.m_geomType = type;
    }

    public PiVector getPolygon(int anIndex) {
        if (anIndex < 0 || anIndex >= this.m_numPolygons) {
            return null;
        }
        return this.m_polygon[anIndex];
    }

    public boolean setPolygon(int anIndex, PiVector aPolygon) {
        if (anIndex < 0) {
            PsDebug.error("index out of range, corrupt argument", this);
            return false;
        }
        if (aPolygon == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (anIndex >= this.m_numPolygons) {
            PsDebug.warning("index=" + anIndex + " >= " + this.m_numPolygons + "=m_numPolygons, bad programming style", this);
            this.setNumPolygons(anIndex + 1);
        }
        int size = aPolygon.getSize();
        this.m_polygon[anIndex].setSize(size);
        this.m_polygon[anIndex].copy(aPolygon);
        if (this.m_dimOfPolygons != size) {
            this.m_dimOfPolygons = -1;
        }
        return true;
    }

    public PdVector[] getBounds() {
        if (this.m_numVertices == 0) {
            return null;
        }
        PdVector[] bndBox = super.getBounds();
        PdVector.min(bndBox[0], this.m_vertex, this.m_numVertices);
        PdVector.max(bndBox[1], this.m_vertex, this.m_numVertices);
        int i = this.m_dim;
        while (i < 3) {
            bndBox[0].m_data[i] = 0.0;
            bndBox[1].m_data[i] = 0.0;
            ++i;
        }
        return bndBox;
    }

    public boolean isVectorElementBased(int ind) {
        return this.m_vectorIsElementBased[ind];
    }

    public void setElementBased(int ind, boolean flag) {
        this.setVectorElementBased(ind, flag);
    }

    public Color[] getPolygonColors() {
        return this.m_polygonColor;
    }

    public Color[] getElementBackColors() {
        return this.m_elementBackColor;
    }

    public void assurePolygonColors() {
        if (this.m_polygonColor == null || this.m_polygonColor.length != this.m_maxNumPolygons) {
            this.m_polygonColor = PdColor.realloc(this.m_polygonColor, this.m_maxNumPolygons);
        }
    }

    public void assureElementBackColors() {
        if (this.m_elementBackColor == null || this.m_elementBackColor.length != this.m_maxNumElements) {
            this.m_elementBackColor = PdColor.realloc(this.m_elementBackColor, this.m_maxNumElements);
        }
    }

    public void setPolygonColors(Color[] color) {
        if (color == null) {
            this.m_polygonColor = null;
            return;
        }
        if (color.length < this.m_numPolygons) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.m_polygonColor == null || this.m_numPolygons > this.m_polygonColor.length) {
            this.assurePolygonColors();
        }
        PdColor.copy(this.m_polygonColor, 0, color, 0, this.m_numPolygons);
    }

    public void setElementBackColors(Color[] color) {
        if (color == null) {
            this.m_elementBackColor = null;
            return;
        }
        if (color.length < this.m_numElements) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.m_elementBackColor == null || this.m_numElements > this.m_elementBackColor.length) {
            this.assureElementBackColors();
        }
        PdColor.copy(this.m_elementBackColor, 0, color, 0, this.m_numElements);
    }

    public boolean isShowingPolygonColors() {
        return this.m_bShowPolygonColors;
    }

    public void showPolygonColors(boolean flag) {
        this.m_bShowPolygonColors = flag;
    }

    public boolean isShowingElementBackColors() {
        return this.m_bShowElementBackColors;
    }

    public void showElementBackColors(boolean flag) {
        this.m_bShowElementBackColors = flag;
    }

    public double getGlobalVertexSize() {
        return this.m_globalVertexSize;
    }

    public double getGlobalVertexNormalSize() {
        return this.m_globalVertexNormalSize;
    }

    public void setGlobalVertexSize(double size) {
        this.m_globalVertexSize = size;
    }

    public void setGlobalVertexNormalSize(double size) {
        this.m_globalVertexNormalSize = size;
    }

    public double getGlobalEdgeSize() {
        return this.m_globalEdgeSize;
    }

    public void setGlobalEdgeSize(double size) {
        this.m_globalEdgeSize = size;
    }

    public double getGlobalElementNormalSize() {
        return this.m_globalElementNormalSize;
    }

    public void setGlobalElementNormalSize(double size) {
        this.m_globalElementNormalSize = size;
    }

    public void setTagVertex(int anIndex, int aTag) {
        if (anIndex < 0 || anIndex > this.m_numVertices - 1) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return;
        }
        this.m_vertex[anIndex].setTag(aTag);
    }

    public double getGlobalPolygonNormalLength() {
        return this.m_globalPolygonNormalLength;
    }

    public void setGlobalPolygonNormalLength(double length) {
        this.m_globalPolygonNormalLength = length;
    }

    public PiVector[] getPolygons() {
        return this.m_polygon;
    }

    public void setDimOfPolygons(int aSize) {
        if (aSize > -1) {
            int i = 0;
            while (i < this.m_maxNumPolygons) {
                this.m_polygon[i].setSize(aSize);
                ++i;
            }
        }
        this.m_dimOfPolygons = aSize;
    }

    protected void setMaxNumPolygons(int numPolygons) {
        if (this.m_maxNumPolygons == numPolygons) {
            return;
        }
        this.m_maxNumPolygons = numPolygons;
        this.m_polygon = this.m_dimOfPolygons > -1 ? PiVector.realloc(this.m_polygon, this.m_maxNumPolygons, this.m_dimOfPolygons) : PiVector.realloc(this.m_polygon, this.m_maxNumPolygons);
        if (this.m_polygonColor != null) {
            this.assurePolygonColors();
        }
        if (this.m_polygonNormal != null) {
            this.assurePolygonNormals();
        }
        if (this.m_numPolygons > this.m_maxNumPolygons) {
            this.m_numPolygons = this.m_maxNumPolygons;
        }
    }

    public double getGlobalPolygonSize() {
        return this.m_globalPolygonSize;
    }

    public double getGlobalPolygonNormalSize() {
        return this.m_globalPolygonNormalSize;
    }

    public void setGlobalPolygonSize(double size) {
        this.m_globalPolygonSize = size;
    }

    public void setGlobalPolygonNormalSize(double size) {
        this.m_globalPolygonNormalSize = size;
    }

    public void setPolygons(PiVector[] polygon) {
        if (polygon == null || polygon.length == 0 || polygon.length < this.m_numPolygons) {
            this.setMaxNumPolygons(0);
            return;
        }
        int i = 0;
        while (i < this.m_numPolygons) {
            this.m_polygon[i].setSize(polygon[i].getSize());
            ++i;
        }
        PiVector.copy(this.m_polygon, 0, polygon, 0, this.m_numPolygons);
    }

    public boolean isShowingPolygons() {
        return this.m_bShowPolygons;
    }

    public void showPolygons(boolean flag) {
        this.m_bShowPolygons = flag;
    }
}

