/*
 * Decompiled with CFR 0.152.
 */
package jv.objectGui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.Hashtable;

public final class GuiStackLayout
implements Serializable,
LayoutManager {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    int orientation = 0;
    int margin = 2;
    Hashtable codeTable = new Hashtable();
    static final int CENTER = 0;
    static final int FRONT = 1;
    static final int BACK = 2;
    static final int FILL = 4;
    static final int ABS = 8;
    static final int FLUSH = 16;
    static final int POSMASK = 3;
    static final int SIZEMASK = 12;
    int[] defaultCode = new int[4];

    int countDigits(String tag, int i) {
        int l = tag.length();
        int j = i;
        while (j < l && Character.isDigit(tag.charAt(j))) {
            ++j;
        }
        return j - i;
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.computeLayoutSize(parent, false);
    }

    public GuiStackLayout() {
    }

    public GuiStackLayout(int orientation) {
        this.orientation = orientation;
    }

    public GuiStackLayout(int orientation, int margin) {
        this.orientation = orientation;
        this.margin = margin;
    }

    int parseArg(String tag, int i, int n) {
        int num = -1;
        try {
            num = Integer.parseInt(tag.substring(i, i + n));
        }
        catch (Exception e) {
            // empty catch block
        }
        return num;
    }

    boolean stretches(Component comp) {
        int[] c = this.getCode(comp);
        return c[this.orientation] == 4;
    }

    Dimension computeLayoutSize(Container parent, boolean preferred) {
        Insets in = parent.getInsets();
        int inW = in.left + in.right;
        int inH = in.top + in.bottom;
        int n = parent.getComponentCount();
        if (this.orientation == 0) {
            int maxH = 0;
            int totW = 0;
            int i = 0;
            while (i < n) {
                Component comp = parent.getComponent(i);
                if (comp.isVisible()) {
                    int code = this.getCode(comp)[this.orientation];
                    int m = (code & 0x10) == 0 ? this.margin : 0;
                    Dimension d = preferred && (code & 0xC) == 4 ? comp.getPreferredSize() : comp.getMinimumSize();
                    maxH = Math.max(maxH, d.height + 2 * m);
                    totW += d.width + 2 * m;
                }
                ++i;
            }
            return new Dimension(totW + inW, maxH + inH);
        }
        int maxW = 0;
        int totH = 0;
        int i = 0;
        while (i < n) {
            Component comp = parent.getComponent(i);
            if (comp.isVisible()) {
                int code = this.getCode(comp)[this.orientation];
                int m = (code & 0x10) == 0 ? this.margin : 0;
                Dimension d = preferred && (code & 0xC) == 4 ? comp.getPreferredSize() : comp.getMinimumSize();
                maxW = Math.max(maxW, d.width + 2 * m);
                totH += d.height + 2 * m;
            }
            ++i;
        }
        return new Dimension(maxW + inW, totH + inH);
    }

    public void removeLayoutComponent(Component comp) {
        this.codeTable.remove(comp);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.computeLayoutSize(parent, true);
    }

    public void layoutContainer(Container parent) {
        int l;
        int along = this.orientation;
        int across = (this.orientation + 1) % 2;
        int n = parent.getComponentCount();
        Insets in = parent.getInsets();
        Dimension sz = parent.getSize();
        int W = sz.width - in.left - in.right;
        int H = sz.height - in.top - in.bottom;
        int L = this.orientation == 0 ? W : H;
        int D = this.orientation == 0 ? H : W;
        int nFills = 0;
        int nRubber = 0;
        int sum = 0;
        int prev = 1;
        int[][] codes = new int[n][];
        int[][] sizes = new int[n][2];
        int i = 0;
        while (i < n) {
            Component comp = parent.getComponent(i);
            if (comp.isVisible()) {
                Dimension d = comp.getMinimumSize();
                int[] code = this.getCode(comp);
                int[] size = sizes[i];
                codes[i] = code;
                size[0] = d.width;
                size[1] = d.height;
                l = size[along];
                int c = code[along];
                switch (c & 0xC) {
                    case 4: {
                        nFills += code[along + 2];
                        break;
                    }
                    case 8: {
                        sum += code[along + 2];
                        break;
                    }
                    default: {
                        sum += l;
                        break;
                    }
                }
                switch (c & 3) {
                    case 0: {
                        ++nRubber;
                        break;
                    }
                    case 2: {
                        if (prev == 2) break;
                        ++nRubber;
                        break;
                    }
                }
                if ((c & 0x10) == 0) {
                    sum += 2 * this.margin;
                }
                prev = c & 3;
            }
            ++i;
        }
        if (prev == 0) {
            ++nRubber;
        }
        int rubber = nFills != 0 || nRubber == 0 ? 0 : Math.max(0, (L - sum) / nRubber);
        int fill = nFills == 0 ? 0 : Math.max(0, (L - sum) / nFills);
        int r = this.orientation == 0 ? in.left : in.top;
        int s0 = this.orientation == 0 ? in.top : in.left;
        prev = 1;
        int i2 = 0;
        while (i2 < n) {
            int[] code = codes[i2];
            int[] size = sizes[i2];
            if (code != null) {
                int c = code[along];
                int ca = code[across];
                int m = (c & 0x10) == 0 ? this.margin : 0;
                r += m;
                int s = s0 + m;
                l = size[along];
                int d = size[across];
                switch (c & 0xC) {
                    case 4: {
                        if (fill <= 0) break;
                        l = fill * code[along + 2];
                        break;
                    }
                    case 8: {
                        l = code[along + 2];
                        break;
                    }
                }
                switch (c & 3) {
                    case 0: {
                        r += rubber;
                        break;
                    }
                    case 2: {
                        if (prev == 2) break;
                        r += rubber;
                        break;
                    }
                }
                prev = c & 3;
                switch (ca & 0xC) {
                    case 4: {
                        d = D - 2 * m;
                        break;
                    }
                    case 8: {
                        d = code[across + 2];
                        break;
                    }
                }
                switch (ca & 3) {
                    case 2: {
                        s += D - d;
                        break;
                    }
                    case 0: {
                        s += (D - d) / 2;
                        break;
                    }
                }
                Component comp = parent.getComponent(i2);
                if (this.orientation == 0) {
                    comp.setBounds(r, s, l, d);
                } else {
                    comp.setBounds(s, r, d, l);
                }
                r += l + m;
            }
            ++i2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addLayoutComponent(String tag, Component comp) {
        tag = tag.toUpperCase().trim();
        hcode = 0;
        vcode = 0;
        harg = 0;
        varg = 0;
        l = tag.length();
        i = 0;
        while (i < l) {
            block22: {
                block20: {
                    block21: {
                        block18: {
                            block19: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                block13: {
                                                    block12: {
                                                        block11: {
                                                            block10: {
                                                                if (!tag.startsWith("CENTER", i)) break block10;
                                                                i += 6;
                                                                ** GOTO lbl97
                                                            }
                                                            if (!tag.startsWith("LEFT", i)) break block11;
                                                            i += 4;
                                                            hcode |= 1;
                                                            ** GOTO lbl97
                                                        }
                                                        if (!tag.startsWith("TOP", i)) break block12;
                                                        i += 3;
                                                        vcode |= 1;
                                                        ** GOTO lbl97
                                                    }
                                                    if (!tag.startsWith("RIGHT", i)) break block13;
                                                    i += 5;
                                                    hcode |= 2;
                                                    ** GOTO lbl97
                                                }
                                                if (!tag.startsWith("BOTTOM", i)) break block14;
                                                i += 6;
                                                vcode |= 2;
                                                ** GOTO lbl97
                                            }
                                            if (!tag.startsWith("WIDE", i)) break block15;
                                            hcode |= 4;
                                            if (tag.startsWith("*", i += 4)) {
                                                n = this.countDigits(tag, ++i);
                                                harg = this.parseArg(tag, i, n);
                                                i += n;
                                            } else {
                                                harg = 1;
                                            }
                                            ** GOTO lbl97
                                        }
                                        if (!tag.startsWith("TALL", i)) break block16;
                                        vcode |= 4;
                                        if (tag.startsWith("*", i += 4)) {
                                            n = this.countDigits(tag, ++i);
                                            varg = this.parseArg(tag, i, n);
                                            i += n;
                                        } else {
                                            varg = 1;
                                        }
                                        ** GOTO lbl97
                                    }
                                    if (!tag.startsWith("FILL", i)) break block17;
                                    hcode |= 4;
                                    vcode |= 4;
                                    if (tag.startsWith("*", i += 4)) {
                                        n = this.countDigits(tag, ++i);
                                        harg = varg = this.parseArg(tag, i, n);
                                        i += n;
                                    } else {
                                        varg = 1;
                                        harg = 1;
                                    }
                                    ** GOTO lbl97
                                }
                                if (!tag.startsWith("WIDTH", i)) break block18;
                                hcode |= 8;
                                if (!tag.startsWith("=", i += 5)) break block19;
                                n = this.countDigits(tag, ++i);
                                harg = this.parseArg(tag, i, n);
                                i += n;
                                ** GOTO lbl97
                            }
                            harg = -1;
                            break;
                        }
                        if (!tag.startsWith("HEIGHT", i)) break block20;
                        vcode |= 8;
                        if (!tag.startsWith("=", i += 6)) break block21;
                        n = this.countDigits(tag, ++i);
                        varg = this.parseArg(tag, i, n);
                        i += n;
                        ** GOTO lbl97
                    }
                    varg = -1;
                    break;
                }
                if (!tag.startsWith("FLUSH", i)) break block22;
                i += 5;
                hcode |= 16;
                vcode |= 16;
                if (true) ** GOTO lbl97
            }
            harg = -1;
            break;
            do {
                ++i;
lbl97:
                // 15 sources

            } while (i < l && Character.isWhitespace(tag.charAt(i)));
        }
        if (harg == -1 || varg == -1) {
            System.out.println("StackLayout: can't understand \"" + tag + "\"");
        } else {
            codes = new int[]{hcode, vcode, harg, varg};
            this.codeTable.put(comp, codes);
        }
    }

    int[] getCode(Component comp) {
        int[] code = (int[])this.codeTable.get(comp);
        if (code == null) {
            return this.defaultCode;
        }
        return code;
    }
}

