/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import jv.loader.PgLoader;
import jv.number.PdColor;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.P_Vector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;

public class PsXmlLoader {
    private static final int UNKNOWN = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;

    public static void parseVectorAttr(P_Vector vec, PsXmlNode p, String[] attr) {
        if (vec == null || p == null || attr == null) {
            return;
        }
        int k = 0;
        while (k < attr.length) {
            String tag = p.getAttribute(attr[k]);
            if (tag != null) {
                if (tag.equalsIgnoreCase("mark")) {
                    vec.setTag(1);
                } else if (attr[k].equalsIgnoreCase("name")) {
                    vec.setName(tag);
                } else {
                    PsDebug.warning("unknown attribute = " + attr[k]);
                    attr = null;
                    break;
                }
            }
            ++k;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean parse(BufferedReader bufReader, PsXmlSrc src) throws IOException {
        StreamTokenizer st = new StreamTokenizer(bufReader);
        st.eolIsSignificant(true);
        st.ordinaryChars(48, 48);
        st.ordinaryChars(49, 57);
        st.ordinaryChar(124);
        st.ordinaryChar(60);
        st.ordinaryChar(62);
        st.ordinaryChar(47);
        st.ordinaryChar(33);
        st.ordinaryChar(63);
        st.ordinaryChar(91);
        st.ordinaryChar(93);
        st.ordinaryChar(123);
        st.ordinaryChar(125);
        st.ordinaryChar(45);
        st.ordinaryChar(43);
        st.ordinaryChar(46);
        st.ordinaryChar(39);
        st.ordinaryChar(92);
        st.ordinaryChar(96);
        st.ordinaryChar(180);
        st.ordinaryChar(176);
        st.wordChars(124, 124);
        st.wordChars(39, 39);
        st.wordChars(92, 92);
        st.wordChars(96, 96);
        st.wordChars(180, 180);
        st.wordChars(176, 176);
        st.wordChars(35, 35);
        st.wordChars(94, 94);
        st.wordChars(38, 38);
        st.wordChars(36, 36);
        st.wordChars(40, 40);
        st.wordChars(41, 41);
        st.wordChars(123, 123);
        st.wordChars(125, 125);
        st.wordChars(126, 126);
        st.wordChars(64, 64);
        st.wordChars(45, 45);
        st.wordChars(43, 43);
        st.wordChars(42, 42);
        st.wordChars(48, 48);
        st.wordChars(49, 57);
        st.wordChars(46, 46);
        st.wordChars(44, 44);
        st.wordChars(59, 59);
        st.wordChars(95, 95);
        st.wordChars(58, 58);
        st.whitespaceChars(61, 61);
        int depth = 0;
        PsXmlNode currNode = null;
        String currContent = null;
        boolean bAttributeMode = false;
        boolean bWrapMode = false;
        boolean bInlineDTDMode = false;
        boolean bParseElementContent = false;
        boolean bDTD = true;
        try {
            block17: while (true) {
                switch (st.nextToken()) {
                    default: {
                        PsDebug.warning("parsing broke abnormally\n\t in line=" + st.lineno() + " reading st.sval=" + st.sval + ", st.ttype=" + st.ttype);
                        return false;
                    }
                    case 10: {
                        if (!bWrapMode || currNode == null || !currNode.hasContent()) continue block17;
                        currNode.appendContent("\n");
                        break;
                    }
                    case -1: {
                        PsDebug.notify("num of lines  = " + st.lineno());
                        PsDebug.notify("... finished");
                        if (depth > 0) {
                            PsDebug.warning("missing closing element");
                            if (currNode != null) {
                                PsDebug.warning("current element = " + currNode.getType());
                            }
                            return false;
                        }
                        if (depth < 0) {
                            PsDebug.warning("too many closing element");
                            if (currNode != null) {
                                PsDebug.warning("current element = " + currNode.getType());
                            }
                            return false;
                        }
                        while (true) {
                            if (currNode == null || currNode.getFather() == null) {
                                src.setRootNode(currNode);
                                return true;
                            }
                            currNode = currNode.getFather();
                        }
                    }
                    case 60: {
                        bParseElementContent = false;
                        st.ordinaryChar(47);
                        st.ordinaryChar(34);
                        st.quoteChar(34);
                        if (bWrapMode && currNode != null && currNode.hasContent() && (currContent = currNode.getContent()).endsWith("\n")) {
                            currContent = currContent.substring(0, currContent.length() - 1);
                            currNode.setContent(currContent);
                        }
                        bWrapMode = false;
                        int nextToken = st.nextToken();
                        if (nextToken == 33 || nextToken == 63) {
                            st.nextToken();
                            if (st.sval.equals("xml")) {
                                while (st.nextToken() != 62) {
                                }
                                break;
                            }
                            if (st.sval.equals("DOCTYPE")) {
                                st.nextToken();
                                if (st.sval != null) {
                                    src.setDocName(st.sval);
                                } else {
                                    PsDebug.warning("missing DTD doc name.");
                                }
                                int c = st.nextToken();
                                if (st.sval != null && st.sval.equals("SYSTEM")) {
                                    st.nextToken();
                                    if (st.sval != null) {
                                        src.setDocType(st.sval);
                                        break;
                                    }
                                    PsDebug.warning("missing DTD doc type.");
                                    break;
                                }
                                if (c == 91) {
                                    bInlineDTDMode = true;
                                    break;
                                }
                                PsDebug.warning("error while parsing doctype.\n\t in line=" + st.lineno() + " reading st.sval=" + st.sval + ", st.ttype=" + st.ttype);
                                break;
                            }
                            if (st.sval.equals("ENTITY")) {
                                while (st.nextToken() != 62) {
                                }
                                break;
                            }
                            if (st.sval.equals("ELEMENT")) {
                                while (st.nextToken() != 62) {
                                }
                                break;
                            }
                            if (st.sval.equals("ATTLIST")) {
                                while (st.nextToken() != 62) {
                                }
                                break;
                            }
                            if (st.sval.equals("--")) {
                                while (st.nextToken() != 62) {
                                }
                                break;
                            }
                            PsDebug.warning("unknown command.\n\t in line=" + st.lineno() + " reading st.sval=" + st.sval + ", st.ttype=" + st.ttype);
                            while (st.nextToken() != 62) {
                            }
                            break;
                        }
                        if (nextToken == 47) {
                            --depth;
                            st.nextToken();
                            if (!st.sval.equals(currNode.getType())) {
                                currNode = currNode.getFather();
                            }
                            if (currNode.isMixedMode() && currNode.hasContent()) {
                                currNode.addMixedContent(currNode.getContent());
                                currNode.setContent(null);
                            }
                            currNode.expand(false);
                            break;
                        }
                        if (bDTD) {
                            bDTD = false;
                            st.wordChars(33, 33);
                            st.wordChars(63, 63);
                            st.wordChars(91, 91);
                            st.wordChars(93, 93);
                        }
                        ++depth;
                        PsXmlNode newNode = new PsXmlNode(st.sval);
                        if (currNode != null) {
                            if (currNode.isExpanded()) {
                                currNode.addChild(newNode);
                                if (!currNode.isMixedMode() && currNode.hasContent()) {
                                    currNode.setMixedMode(true);
                                }
                                if (currNode.isMixedMode()) {
                                    if (currNode.hasContent()) {
                                        currNode.addMixedContent(currNode.getContent());
                                        currNode.setContent(null);
                                    }
                                    currNode.addMixedContent(newNode);
                                }
                            } else {
                                currNode.setSibling(newNode);
                            }
                        }
                        currNode = newNode;
                        currNode.expand(true);
                        bAttributeMode = true;
                        st.whitespaceChars(61, 61);
                        break;
                    }
                    case 62: {
                        bAttributeMode = false;
                        st.ordinaryChar(61);
                        st.wordChars(61, 61);
                        bParseElementContent = true;
                        st.ordinaryChar(34);
                        st.wordChars(34, 34);
                        st.wordChars(47, 47);
                        break;
                    }
                    case 93: {
                        if (bInlineDTDMode) {
                            bInlineDTDMode = false;
                            break;
                        }
                        if (!bParseElementContent) continue block17;
                        if (!currNode.isMixedMode() && currNode.getChild() != null) {
                            currNode.setMixedMode(true);
                            currNode.addMixedContent(currNode.getChild());
                        }
                        currNode.appendContent("]");
                        break;
                    }
                    case 47: {
                        if (bAttributeMode) {
                            if (st.nextToken() != 62) {
                                PsDebug.error("found '/' in attribute mode, error in line=" + st.lineno());
                                return false;
                            }
                            bAttributeMode = false;
                            --depth;
                            currNode.expand(false);
                            break;
                        }
                        if (!currNode.isMixedMode() && currNode.getChild() != null) {
                            currNode.setMixedMode(true);
                            currNode.addMixedContent(currNode.getChild());
                        }
                        currNode.appendContent("/");
                        bWrapMode = true;
                        break;
                    }
                    case 91: {
                        if (bParseElementContent) {
                            if (!currNode.isMixedMode() && currNode.getChild() != null) {
                                currNode.setMixedMode(true);
                                currNode.addMixedContent(currNode.getChild());
                            }
                            currNode.appendContent(" [");
                            break;
                        }
                    }
                    case 34: {
                        if (!bParseElementContent) continue block17;
                        if (!currNode.isMixedMode() && currNode.getChild() != null) {
                            currNode.setMixedMode(true);
                            currNode.addMixedContent(currNode.getChild());
                        }
                        currNode.appendContent("\"");
                        break;
                    }
                    case 33: {
                        if (!bParseElementContent) continue block17;
                        if (!currNode.isMixedMode() && currNode.getChild() != null) {
                            currNode.setMixedMode(true);
                            currNode.addMixedContent(currNode.getChild());
                        }
                        currNode.appendContent("!");
                        break;
                    }
                    case 63: {
                        if (!bParseElementContent) continue block17;
                        if (!currNode.isMixedMode() && currNode.getChild() != null) {
                            currNode.setMixedMode(true);
                            currNode.addMixedContent(currNode.getChild());
                        }
                        currNode.appendContent("?");
                        break;
                    }
                    case 61: {
                        if (!bParseElementContent) continue block17;
                        if (!currNode.isMixedMode() && currNode.getChild() != null) {
                            currNode.setMixedMode(true);
                            currNode.addMixedContent(currNode.getChild());
                        }
                        currNode.appendContent("=");
                        break;
                    }
                    case -3: {
                        if (bAttributeMode) {
                            String key = st.sval;
                            st.nextToken();
                            String val = st.sval;
                            currNode.addAttribute(key, val);
                            break;
                        }
                        if (!currNode.isExpanded()) {
                            currNode = currNode.getFather();
                        }
                        if (!currNode.isMixedMode() && currNode.getChild() != null) {
                            currNode.setMixedMode(true);
                            currNode.addMixedContent(currNode.getChild());
                        }
                        currContent = currNode.getContent();
                        if (!currNode.hasContent()) {
                            currNode.setContent(st.sval);
                        } else if (currContent.endsWith("\n") || currContent.endsWith("/")) {
                            currContent = currContent + st.sval;
                            currNode.setContent(currContent);
                        } else {
                            currNode.appendContent(" " + st.sval);
                        }
                        bWrapMode = true;
                        break;
                    }
                    case -2: {
                        if (!currNode.isMixedMode() && currNode.getChild() != null) {
                            currNode.setMixedMode(true);
                        }
                        if (!currNode.hasContent()) {
                            currNode.setContent(String.valueOf(st.nval));
                        } else {
                            currNode.appendContent(" " + String.valueOf(st.nval));
                        }
                        bWrapMode = true;
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            PsDebug.warning("Exception thrown in line=" + st.lineno() + ", Exception = " + e);
            return false;
        }
    }

    public static PsXmlSrc read(String fileName) {
        BufferedReader in = PsUtil.open(fileName);
        if (in == null) {
            PsDebug.warning("could not open file = " + fileName);
            return null;
        }
        PsXmlSrc src = PsXmlLoader.read(in);
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (src == null) {
            PsDebug.warning("error when reading file = " + fileName);
            return null;
        }
        return src;
    }

    public static PsXmlSrc read(BufferedReader in) {
        if (in == null) {
            PsDebug.warning("missing buffered reader");
            return null;
        }
        PsXmlSrc src = new PsXmlSrc();
        try {
            boolean check = PsXmlLoader.parse(in, src);
            if (!check) {
                PsDebug.warning("failed reading stream = " + in);
                return null;
            }
        }
        catch (IOException e) {
            PsDebug.warning("failed reading stream = " + in);
            e.printStackTrace();
            return null;
        }
        return src;
    }

    public static PdVector[] parseDoubleList(PsXmlNode parentNode, String type, String[] attr) {
        PsXmlNode[] p = PsXmlSrc.getRsrcNodes(parentNode, type);
        if (p == null || p.length == 0) {
            return null;
        }
        PdVector[] vertex = new PdVector[p.length];
        int j = 0;
        while (j < p.length) {
            vertex[j] = PsXmlLoader.parsePdVector(p[j], attr);
            if (vertex[j] == null) {
                PsDebug.warning("failed to parse vector at index = " + j);
                return null;
            }
            ++j;
        }
        return vertex;
    }

    public static void addVectorList(PsXmlNode parentNode, String type, PdVector[] vector, int length) {
        if (vector == null || vector.length < length) {
            return;
        }
        boolean bName = "p".equals(type);
        parentNode.addAttribute("num", String.valueOf(length));
        int i = 0;
        while (i < length) {
            PsXmlLoader.addVector(parentNode, type, vector[i], bName);
            ++i;
        }
    }

    public static Color parseColorContent(PsXmlNode p) {
        if (p == null) {
            return null;
        }
        String pStr = p.getContent();
        return PdColor.parseColor(pStr);
    }

    public static void addVectorList(PsXmlNode parentNode, String type, PiVector[] vector, int length) {
        if (vector == null || vector.length < length) {
            return;
        }
        boolean bName = "e".equals(type) || "f".equals(type) || "l".equals(type);
        parentNode.addAttribute("num", String.valueOf(length));
        int i = 0;
        while (i < length) {
            PsXmlLoader.addVector(parentNode, type, vector[i], bName);
            ++i;
        }
    }

    public static void addVectorList(PsXmlNode parentNode, String type, PdVector[][] vector, int length) {
        if (vector == null || vector.length < length) {
            return;
        }
        int i = 0;
        while (i < length) {
            if (vector[i] == null) {
                return;
            }
            ++i;
        }
        int size = 0;
        int i2 = 0;
        while (i2 < length) {
            int j = 0;
            while (j < vector[i2].length) {
                parentNode.addChild(type, PuData.toString(vector[i2][j].m_data));
                ++j;
            }
            size += vector[i2].length;
            ++i2;
        }
        parentNode.addAttribute("num", String.valueOf(size));
    }

    public static void addVectorList(PsXmlNode parentNode, String type, Color[] vector, int length) {
        if (vector == null || vector.length < length) {
            return;
        }
        parentNode.addAttribute("num", String.valueOf(length));
        int i = 0;
        while (i < length) {
            String str = String.valueOf(vector[i].getRed()) + " " + String.valueOf(vector[i].getGreen()) + " " + String.valueOf(vector[i].getBlue());
            parentNode.addChild(type, str);
            ++i;
        }
    }

    public static PiVector parsePiVector(String string) {
        if (string == null) {
            PsDebug.warning("missing integer string.");
            return null;
        }
        try {
            String[] comp = PuString.splitString(string, ' ');
            if (comp == null || comp.length == 0) {
                PsDebug.warning("missing integer entries = " + string);
                return null;
            }
            PiVector vec = new PiVector(comp.length);
            int k = 0;
            while (k < comp.length) {
                vec.setEntry(k, Integer.parseInt(comp[k]));
                ++k;
            }
            return vec;
        }
        catch (NumberFormatException e) {
            PsDebug.warning("wrong format in integer string = " + string);
            return null;
        }
    }

    public static PiVector parsePiVector(PsXmlNode parentNode, String type, String[] attr) {
        PsXmlNode p = PsXmlSrc.getRsrcNode(parentNode, type);
        if (p == null) {
            return null;
        }
        return PsXmlLoader.parsePiVector(p, attr);
    }

    public static PiVector parsePiVector(PsXmlNode p, String[] attr) {
        if (p == null) {
            PsDebug.warning("missing xml node.");
            return null;
        }
        PiVector vertex = PsXmlLoader.parsePiVector(p.getContent());
        if (attr != null) {
            PsXmlLoader.parseVectorAttr(vertex, p, attr);
        }
        return vertex;
    }

    public static void addVector(PsXmlNode parentNode, String type, PdVector vector, boolean bAttr) {
        if (vector == null) {
            return;
        }
        PsXmlNode v = parentNode.addChild(type, PuData.toString(vector.m_data));
        if (bAttr && vector.getName() != null) {
            v.addAttribute("name", vector.getName());
        }
        if (vector.hasTag(1)) {
            v.addAttribute("tag", "mark");
        }
    }

    public static void addVector(PsXmlNode parentNode, String type, PiVector vector, boolean bAttr) {
        if (vector == null) {
            return;
        }
        PsXmlNode v = parentNode.addChild(type, PuData.toString(vector.m_data));
        if (bAttr && vector.getName() != null) {
            v.addAttribute("name", vector.getName());
        }
        if (vector.hasTag(1)) {
            v.addAttribute("tag", "mark");
        }
    }

    public static PsXmlNode addColor(PsXmlNode parentNode, String type, Color color) {
        if (color == null) {
            return null;
        }
        PsXmlNode colorNode = parentNode.addChild(type);
        colorNode.setContent(String.valueOf(color.getRed()) + " " + String.valueOf(color.getGreen()) + " " + String.valueOf(color.getBlue()));
        colorNode.addAttribute("type", "rgb");
        return colorNode;
    }

    public static PiVector[] parseIntegerList(PsXmlNode parentNode, String type, String[] attr) {
        PsXmlNode[] p = PsXmlSrc.getRsrcNodes(parentNode, type);
        if (p == null || p.length == 0) {
            return null;
        }
        PiVector[] vertex = new PiVector[p.length];
        int j = 0;
        while (j < p.length) {
            vertex[j] = PsXmlLoader.parsePiVector(p[j], attr);
            if (vertex[j] == null) {
                PsDebug.warning("failed to parse vector at index = " + j);
                return null;
            }
            ++j;
        }
        return vertex;
    }

    public static Color[] parseColorList(PsXmlNode parentNode, String type) {
        PsXmlNode[] c = PsXmlSrc.getRsrcNodes(parentNode, type);
        if (c == null || c.length == 0) {
            return null;
        }
        Color[] color = new Color[c.length];
        int j = 0;
        while (j < c.length) {
            color[j] = PsXmlLoader.parseColorContent(c[j]);
            if (color[j] == null) {
                PsDebug.warning("failed to parse color at index = " + j);
                return null;
            }
            ++j;
        }
        return color;
    }

    public static Color parseColorRGB(PsXmlNode parentNode, String type) {
        PsXmlNode c = PsXmlSrc.getRsrcNode(parentNode, type);
        if (c == null) {
            return null;
        }
        return PsXmlLoader.parseColorContent(c);
    }

    public static PdVector parsePdVector(PsXmlNode parentNode, String type, String[] attr) {
        PsXmlNode p = PsXmlSrc.getRsrcNode(parentNode, type);
        if (p == null) {
            return null;
        }
        return PsXmlLoader.parsePdVector(p, attr);
    }

    public static PdVector parsePdVector(PsXmlNode p, String[] attr) {
        if (p == null) {
            PsDebug.warning("missing xml node.");
            return null;
        }
        PdVector vertex = PsXmlLoader.parsePdVector(p.getContent());
        if (attr != null) {
            PsXmlLoader.parseVectorAttr(vertex, p, attr);
        }
        return vertex;
    }

    public static PdVector parsePdVector(String string) {
        if (string == null) {
            PsDebug.warning("missing double string.");
            return null;
        }
        String[] comp = PuString.splitString(string, ' ');
        if (comp == null || comp.length == 0) {
            PsDebug.warning("missing double entries = " + string);
            return null;
        }
        PdVector vertex = new PdVector(comp.length);
        int k = 0;
        while (k < comp.length) {
            vertex.setEntry(k, PgLoader.parseDouble(comp[k]));
            ++k;
        }
        return vertex;
    }
}

