/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import jv.geom.PgPointSet;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.vecmath.P_Vector;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgPolygonSet
extends PgPointSet {
    protected boolean m_bShowEdgeLabels;
    protected boolean m_bShowPolygonLabels;
    protected int m_dimOfPolygons;
    protected int m_numPolygons;
    protected int m_maxNumPolygons;
    protected PiVector[] m_polygon;
    protected Color[] m_polygonColor;
    protected PdVector[] m_polygonNormal;
    protected boolean m_bShowPolygons;
    protected boolean m_bShowTaggedPolygons;
    protected boolean m_bShowPolygonStartArrow;
    protected boolean m_bShowPolygonEndArrow;
    protected boolean m_bShowPolygonNormals;
    protected boolean m_bShowPolygonNormalArrow;
    protected PuDouble m_globalPolygonNormalLength;
    protected PuDouble m_globalPolygonNormalSize;
    protected PdColor m_globalPolygonNormalColor;
    protected boolean m_bShowPolygonColors;
    protected PdColor m_globalPolygonColor;
    protected PdColor m_globalPolygonTagColor;
    protected PuDouble m_globalPolygonSize;
    protected boolean m_useGlobalPolygonSize;
    public int NORMAL = 100;
    public int BINORMAL = 101;
    public int OFFSET_NORMAL = 102;
    public int CURVATURE_NORMAL = 103;
    private static /* synthetic */ Class class$jv$geom$PgPolygonSet;

    public int addPolygon(PiVector aPolygon) {
        this.setNumPolygons(this.m_numPolygons + 1);
        this.setPolygon(this.m_numPolygons - 1, aPolygon);
        return this.m_numPolygons - 1;
    }

    public boolean hasTagPolygon(int anIndex, int aTag) {
        if (anIndex < 0 || anIndex > this.m_numPolygons - 1) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return false;
        }
        return this.m_polygon[anIndex].hasTag(aTag);
    }

    public double getLengthOfPolygon(int ind) {
        PdVector[] v = this.getPolygonVertices(ind);
        if (v == null || v.length < 2) {
            return 0.0;
        }
        double len = 0.0;
        int i = 1;
        while (i < v.length) {
            len += PdVector.dist(v[i - 1], v[i]);
            ++i;
        }
        return len;
    }

    public PvPickEvent intersectionWithLine(PdVector rayBase, PdVector rayDir) {
        if (this.m_dim != 2 && this.m_dim != 3) {
            return null;
        }
        PdVector polygonDir = new PdVector(this.m_dim);
        PdVector minPolygonDir = new PdVector(this.m_dim);
        int vertexInd = -1;
        int minElem = -1;
        int minSubElem = -1;
        double dist = Double.MAX_VALUE;
        double minDist = Double.MAX_VALUE;
        double horDist = Double.MAX_VALUE;
        double minHorDist = Double.MAX_VALUE;
        PdVector pos = new PdVector(3);
        PdVector pos2D = this.m_dim == 2 ? new PdVector(2) : pos;
        PdVector minPos = new PdVector(3);
        PdBary bary = new PdBary(2);
        PdBary minBary = new PdBary(2);
        PdVector polyBase3D = null;
        PdVector polyTip3D = null;
        if (this.m_dim == 2) {
            polyBase3D = new PdVector(3);
            polyTip3D = new PdVector(3);
        }
        PdVector polyDir3D = null;
        if (this.m_dim == 2) {
            polyDir3D = new PdVector(3);
        }
        rayDir.normalize();
        int i = 0;
        while (i < this.m_numPolygons) {
            PdVector[] v = this.getPolygonVertices(i);
            if (v != null && v.length >= 2) {
                int j = 1;
                while (j < v.length) {
                    polygonDir.sub(v[j], v[j - 1]);
                    if (!(polygonDir.sqrLength() < 1.0E-10)) {
                        if (this.m_dim == 2) {
                            polyBase3D.copyArray(v[j - 1]);
                            polyTip3D.copyArray(v[j]);
                            polyDir3D.copyArray(polygonDir);
                        } else {
                            polyBase3D = v[j - 1];
                            polyTip3D = v[j];
                            polyDir3D = polygonDir;
                        }
                        polyDir3D.normalize();
                        horDist = PuVectorGeom.distOfLineToLine(rayBase, rayDir, polyBase3D, polyDir3D);
                        if (!(horDist >= minHorDist) && !(horDist > 0.1)) {
                            dist = PuVectorGeom.intersectionOfLineAndLine(pos, rayBase, rayDir, polyBase3D, polyDir3D);
                            if (this.m_dim == 2) {
                                pos2D.m_data[0] = pos.m_data[0];
                                pos2D.m_data[1] = pos.m_data[1];
                            }
                            PdBary.getBary(bary, pos, polyBase3D, polyTip3D);
                            boolean bInside = bary.isInside();
                            if (bInside || Math.abs(1.0 - bary.getEntry(0)) < 0.1 || Math.abs(1.0 - bary.getEntry(1)) < 0.1) {
                                minHorDist = horDist;
                                minDist = dist;
                                minElem = i;
                                minSubElem = j;
                                minPolygonDir.copyArray(polygonDir);
                                vertexInd = -1;
                                if (bInside) {
                                    minBary.copy(bary);
                                    minPos.blend(bary.getEntry(0), polyBase3D, bary.getEntry(1), polyTip3D);
                                } else if (Math.abs(1.0 - bary.getEntry(0)) < 0.1) {
                                    minBary.setEntry(0, 1.0);
                                    minBary.setEntry(1, 0.0);
                                    minPos.copyArray(polyBase3D);
                                    vertexInd = this.m_polygon[i].getEntry(j - 1);
                                } else if (Math.abs(1.0 - bary.getEntry(1)) < 0.1) {
                                    minBary.setEntry(0, 0.0);
                                    minBary.setEntry(1, 1.0);
                                    minPos.copyArray(polyTip3D);
                                    vertexInd = this.m_polygon[i].getEntry(j);
                                }
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (minElem == -1) {
            return null;
        }
        PvPickEvent point = new PvPickEvent(this.m_dim);
        point.setVertex(minPos);
        point.setDistance(minDist);
        point.setElementInd(minElem);
        point.setElementSubInd(minSubElem);
        point.setBary(minBary);
        point.setVertexInd(vertexInd);
        point.setViewBase(rayBase);
        point.setViewDir(rayDir);
        point.setNormal(minPolygonDir);
        return point;
    }

    public PdVector[] getPolygonNormals() {
        return this.m_polygonNormal;
    }

    public boolean isShowingPolygonNormals() {
        return this.m_bShowPolygonNormals;
    }

    public void showPolygonNormals(boolean flag) {
        this.m_bShowPolygonNormals = flag;
    }

    public void assurePolygonNormals() {
        if (this.m_polygonNormal == null || this.m_polygonNormal.length != this.m_maxNumPolygons) {
            this.m_polygonNormal = PdVector.realloc(this.m_polygonNormal, this.m_maxNumPolygons, this.m_dim);
        }
    }

    public void setPolygonNormals(PdVector[] normal) {
        if (normal == null) {
            this.m_polygonNormal = null;
            return;
        }
        if (normal.length < this.m_numPolygons) {
            PsDebug.warning("void length of normal array");
            return;
        }
        if (this.m_polygonNormal == null || this.m_numPolygons > this.m_polygonNormal.length) {
            this.assurePolygonNormals();
        }
        PdVector.copy(this.m_polygonNormal, 0, normal, 0, this.m_numPolygons);
    }

    public void makeNormals() {
        this.makeNormals(this.NORMAL, 1.0);
    }

    public void makeNormals(int type, double length) {
        this.assureVertexNormals();
        PdVector v = new PdVector(this.m_dim);
        PdVector w = new PdVector(this.m_dim);
        PdVector normal = new PdVector(this.m_dim);
        PdVector normalPrev = new PdVector(this.m_dim);
        PdVector binormal = new PdVector(3);
        PdVector binormalPrev = new PdVector(3);
        int nop = this.getNumPolygons();
        int i = 0;
        while (i < nop) {
            int size = this.m_polygon[i].getSize();
            boolean bClosed = this.isClosed(i);
            if (bClosed) {
                --size;
            }
            if (this.m_polygon[i] == null || size < 3) {
                PsDebug.warning("polygon[" + i + "] null or less than 3 vertices");
            } else {
                int ind;
                int locIndPrev = 0;
                int locInd = 1;
                int indPrev = this.m_polygon[i].getEntry(locIndPrev);
                do {
                    ind = this.m_polygon[i].getEntry(locInd);
                    v.sub(this.m_vertex[ind], this.m_vertex[indPrev]);
                } while (v.sqrLength() < 1.0E-10 && ++locInd < size);
                if (locInd >= size) {
                    PsDebug.warning("polygon[" + i + "] is degenerated to a point");
                    normal.setEntry(this.m_dim - 1, 1.0);
                    PdVector.setConstant(this.m_vertexNormal, normal);
                } else {
                    int firstUnusedInd;
                    int k;
                    int firstLocInd = size - 2;
                    if (bClosed) {
                        firstLocInd = locInd - 1;
                    }
                    normal.normalToVector(v);
                    if (locInd >= size - 1) {
                        PsDebug.warning("polygon[" + i + "] is a line");
                        PdVector.setConstant(this.m_vertexNormal, normal);
                        return;
                    }
                    normalPrev.copy(normal);
                    v.normalize();
                    binormalPrev.cross(v, normal);
                    normal.setLength(length);
                    int firstEqualVertex = -1;
                    boolean bRecentZeroEdge = false;
                    boolean bRecentZeroAngle = false;
                    if (!bClosed) {
                        bRecentZeroAngle = true;
                    }
                    int locIndNext = locInd;
                    int indNext = ind;
                    while (locInd != firstLocInd) {
                        double len;
                        locInd = locIndNext;
                        locIndNext = (locIndNext + 1) % size;
                        ind = indNext;
                        indNext = this.m_polygon[i].getEntry(locIndNext);
                        w.sub(this.m_vertex[indNext], this.m_vertex[ind]);
                        if (w.sqrLength() < 1.0E-10) {
                            bRecentZeroEdge = true;
                            if (firstEqualVertex != -1) continue;
                            firstEqualVertex = locInd;
                            continue;
                        }
                        w.sub(this.m_vertex[indNext], this.m_vertex[ind]);
                        w.normalize();
                        normal.sub(w, v);
                        if (!normal.normalize()) {
                            firstEqualVertex = -1;
                            bRecentZeroAngle = true;
                            continue;
                        }
                        binormal.cross(v, normal);
                        if (type == this.NORMAL) {
                            normal.setLength(length);
                        } else if (type == this.BINORMAL) {
                            normal.copy(binormal);
                            normal.setLength(length);
                        } else if (type == this.OFFSET_NORMAL) {
                            double angle = PdVector.angleWithOrientation(v, w, binormal);
                            len = length / Math.cos(angle / 2.0);
                            normal.setLength(len);
                        } else if (type == this.CURVATURE_NORMAL) {
                            double angle = PdVector.angleWithOrientation(v, w, binormal);
                            len = length * angle;
                            normal.setLength(len);
                        }
                        if (PdVector.dot(binormal, binormalPrev) < 0.0) {
                            normal.multScalar(-1.0);
                            binormal.multScalar(-1.0);
                        }
                        if (bRecentZeroAngle) {
                            int firstUnusedInd2 = (locIndPrev + 1) % size;
                            if (!bClosed && locIndPrev == 0) {
                                firstUnusedInd2 = 0;
                            }
                            bRecentZeroAngle = false;
                            normalPrev.cross(binormal, v);
                            normalPrev.normalize();
                            if (type == this.NORMAL) {
                                normalPrev.setLength(length);
                            } else if (type == this.BINORMAL) {
                                normalPrev.copy(binormal);
                                normalPrev.setLength(length);
                            } else if (type == this.OFFSET_NORMAL) {
                                normalPrev.setLength(length);
                            } else if (type == this.CURVATURE_NORMAL) {
                                normalPrev.setConstant(0.0);
                            }
                            k = firstUnusedInd2;
                            while (k != locInd) {
                                this.m_vertexNormal[this.m_polygon[i].getEntry(k)].copy(normalPrev);
                                k = (k + 1) % size;
                            }
                        }
                        normalPrev.copy(normal);
                        if (type == this.NORMAL) {
                            normalPrev.setLength(length);
                        } else if (type == this.BINORMAL) {
                            normalPrev.copy(binormal);
                            normalPrev.setLength(length);
                        } else if (type == this.OFFSET_NORMAL) {
                            double angle = PdVector.angleWithOrientation(v, w, binormal);
                            len = length / Math.cos(angle / 2.0);
                            normalPrev.setLength(len);
                        } else if (type == this.CURVATURE_NORMAL) {
                            double angle = PdVector.angleWithOrientation(v, w, binormal);
                            len = length * angle;
                            normalPrev.setLength(len);
                        }
                        if (bRecentZeroEdge) {
                            bRecentZeroEdge = false;
                            k = firstEqualVertex;
                            firstEqualVertex = -1;
                            while (k != locInd) {
                                this.m_vertexNormal[this.m_polygon[i].getEntry(k)].copy(normalPrev);
                                k = (k + 1) % size;
                            }
                        }
                        this.m_vertexNormal[this.m_polygon[i].getEntry(locInd)].copy(normalPrev);
                        v.copy(w);
                        normalPrev.copy(normal);
                        binormalPrev.copy(binormal);
                        indPrev = ind;
                        locIndPrev = locInd;
                    }
                    if (!bClosed && (firstUnusedInd = (locIndPrev + 1) % size) < size) {
                        normalPrev.cross(binormalPrev, v);
                        normalPrev.normalize();
                        if (type == this.NORMAL) {
                            normalPrev.setLength(length);
                        } else if (type == this.BINORMAL) {
                            normalPrev.copy(binormal);
                            normalPrev.setLength(length);
                        } else if (type == this.OFFSET_NORMAL) {
                            normalPrev.setLength(length);
                        } else if (type == this.CURVATURE_NORMAL) {
                            normalPrev.setConstant(0.0);
                        }
                        k = firstUnusedInd;
                        while (k < size) {
                            this.m_vertexNormal[this.m_polygon[i].getEntry(k)].copy(normalPrev);
                            ++k;
                        }
                    }
                }
            }
            ++i;
        }
    }

    public boolean makePolygonColorsFromZ() {
        if (this.m_dim == 0) {
            return false;
        }
        if (this.m_numPolygons == 0) {
            return true;
        }
        int dim = Math.min(2, this.m_dim - 1);
        this.assurePolygonColors();
        Color[] color = this.getPolygonColors();
        PdVector[] bnd = this.getAmbientBounds();
        float diag = (float)(bnd[1].m_data[dim] - bnd[0].m_data[dim]);
        PdVector vec = new PdVector(this.m_dim);
        PdVector center = new PdVector(this.m_dim);
        int i = 0;
        while (i < this.m_numPolygons) {
            vec.sub(PgGeometry.getCenterOfElement(center, this.m_vertex, this.m_polygon[i].m_data), bnd[0]);
            float col = (float)vec.m_data[dim] / diag;
            color[i] = new Color(1.0f - col, 0.0f, col);
            ++i;
        }
        return true;
    }

    public boolean makePolygonColorsFromZHue() {
        if (this.m_dim == 0) {
            return false;
        }
        if (this.m_numPolygons == 0) {
            return true;
        }
        int dim = Math.min(2, this.m_dim - 1);
        this.assurePolygonColors();
        Color[] color = this.getPolygonColors();
        PdVector[] bnd = this.getAmbientBounds();
        float diag = (float)(bnd[1].m_data[dim] - bnd[0].m_data[dim]);
        PdVector vec = new PdVector(this.m_dim);
        PdVector center = new PdVector(this.m_dim);
        int i = 0;
        while (i < this.m_numPolygons) {
            vec.sub(PgGeometry.getCenterOfElement(center, this.m_vertex, this.m_polygon[i].m_data), bnd[0]);
            float col = (float)vec.m_data[dim] / diag;
            color[i] = new Color(Color.HSBtoRGB(1.0f - col, 1.0f, 1.0f));
            ++i;
        }
        return true;
    }

    public Color getPolygonColor(int anIndex) {
        if (anIndex < 0 || anIndex >= this.m_numPolygons) {
            return null;
        }
        return this.m_polygonColor[anIndex];
    }

    public boolean isShowingEdgeLabels() {
        return this.m_bShowEdgeLabels;
    }

    public void showEdgeLabels(boolean flag) {
        this.m_bShowEdgeLabels = flag;
    }

    public boolean hasPolygonNormals() {
        if (this.m_polygonNormal == null || this.m_polygonNormal.length != this.m_maxNumPolygons) {
            return false;
        }
        return this.m_polygonNormal.length <= 0 || !(Math.abs(this.m_polygonNormal[0].sqrLength() - 1.0) > 1.0E-10);
    }

    public boolean setPolygonColor(int anIndex, Color aColor) {
        if (anIndex < 0 || anIndex >= this.m_numPolygons) {
            PsDebug.warning("index=" + anIndex + " out of range", this);
            return false;
        }
        if (aColor == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (this.m_polygonColor == null || this.m_numPolygons > this.m_polygonColor.length) {
            this.assurePolygonColors();
        }
        this.m_polygonColor[anIndex] = aColor;
        return true;
    }

    public boolean isShowingPolygonNormalArrow() {
        return this.m_bShowPolygonNormalArrow;
    }

    public void showPolygonNormalArrow(boolean flag) {
        this.m_bShowPolygonNormalArrow = flag;
    }

    public void useGlobalPolygonSize(boolean flag) {
        this.m_useGlobalPolygonSize = flag;
    }

    public Object clone() {
        PgPolygonSet clone = (PgPolygonSet)super.clone();
        if (clone == null) {
            return null;
        }
        clone.m_globalPolygonSize = (PuDouble)this.m_globalPolygonSize.clone();
        clone.m_globalPolygonColor = (PdColor)this.m_globalPolygonColor.clone();
        clone.m_globalPolygonTagColor = (PdColor)this.m_globalPolygonTagColor.clone();
        clone.m_globalPolygonSize.setParent(clone);
        clone.m_globalPolygonColor.setParent(clone);
        clone.m_globalPolygonTagColor.setParent(clone);
        clone.m_globalPolygonNormalLength = (PuDouble)this.m_globalPolygonNormalLength.clone();
        clone.m_globalPolygonNormalSize = (PuDouble)this.m_globalPolygonNormalSize.clone();
        clone.m_globalPolygonNormalColor = (PdColor)this.m_globalPolygonNormalColor.clone();
        clone.m_globalPolygonNormalLength.setParent(clone);
        clone.m_globalPolygonNormalSize.setParent(clone);
        clone.m_globalPolygonNormalColor.setParent(clone);
        if (this.m_polygon != null) {
            clone.m_polygon = (PiVector[])P_Vector.clone(this.m_polygon);
        }
        if (this.m_polygonColor != null) {
            clone.m_polygonColor = (Color[])this.m_polygonColor.clone();
        }
        if (this.m_polygonNormal != null) {
            clone.m_polygonNormal = (PdVector[])P_Vector.clone(this.m_polygonNormal);
        }
        return clone;
    }

    public PdVector getPolygonNormal(int anIndex) {
        if (anIndex < 0 || anIndex >= this.m_numPolygons) {
            return null;
        }
        return this.m_polygonNormal[anIndex];
    }

    public boolean setPolygonNormal(int anIndex, PdVector aNormal) {
        if (anIndex < 0 || anIndex >= this.m_numPolygons) {
            PsDebug.warning("index=" + anIndex + " out of range", this);
            return false;
        }
        if (aNormal == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (this.m_polygonNormal == null || this.m_numPolygons > this.m_polygonNormal.length) {
            this.assurePolygonNormals();
        }
        this.m_polygonNormal[anIndex].copy(aNormal);
        return true;
    }

    public double getLength() {
        double volume = 0.0;
        int i = 0;
        while (i < this.m_numPolygons) {
            volume += this.getLengthOfPolygon(i);
            ++i;
        }
        return volume;
    }

    public int getNumEdges() {
        int numEdges = 0;
        int i = 0;
        while (i < this.m_numPolygons) {
            numEdges += this.m_polygon[i].getSize();
            ++i;
        }
        return numEdges;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("");
        strBuf.append(super.toString());
        strBuf.append("\t ******* PgPolygonSet *********\n");
        strBuf.append("\t m_numPolygons    = " + this.m_numPolygons + "\n");
        strBuf.append("\t ******* m_polygon *******\n");
        if (this.m_polygon != null) {
            int i = 0;
            while (i < this.m_numPolygons) {
                strBuf.append("\t [" + i + "] = " + this.m_polygon[i].toShortString());
                ++i;
            }
        } else {
            strBuf.append("\t m_polygon = null\n");
        }
        return strBuf.toString();
    }

    public boolean setClosed(int ind, boolean flag) {
        if (ind < 0 || ind >= this.m_numPolygons) {
            PsDebug.warning("index=" + ind + " out of range", this);
            return false;
        }
        if (this.isClosed(ind)) {
            return true;
        }
        this.m_polygon[ind].addEntry(this.m_polygon[ind].getFirstEntry());
        return true;
    }

    public boolean isShowingPolygonLabels() {
        return this.m_bShowPolygonLabels;
    }

    public void showPolygonLabels(boolean flag) {
        this.m_bShowPolygonLabels = flag;
    }

    public void copy(PgGeometry geom) {
        super.copy(geom);
        if (!(geom instanceof PgPolygonSet)) {
            return;
        }
        this.copyPolygonSet((PgPolygonSet)geom);
    }

    public void makeBiNormals() {
        this.makeNormals(this.BINORMAL, 1.0);
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public boolean isShowingPolygonEndArrow() {
        return this.m_bShowPolygonEndArrow;
    }

    public void setDimOfColors(int aSize) {
        if (aSize < 0 || this.m_dimOfColors == aSize) {
            return;
        }
        super.setDimOfColors(aSize);
    }

    public void setDimOfVectors(int aSize) {
        if (aSize < 0 || aSize == this.m_dim) {
            return;
        }
        super.setDimOfVectors(aSize);
        if (this.m_polygonNormal != null) {
            int i = 0;
            while (i < this.m_maxNumPolygons) {
                this.m_polygonNormal[i].setSize(aSize);
                ++i;
            }
        }
    }

    public void init() {
        super.init();
        this.m_bShowEdgeLabels = false;
        this.m_bShowPolygonLabels = false;
        this.m_bShowVertices = true;
        this.setGlobalVertexColor(Color.yellow);
        this.setGlobalVertexSize(2);
        this.m_polygonNormal = null;
        this.m_bShowPolygonNormals = false;
        this.m_bShowPolygonNormalArrow = false;
        this.m_globalPolygonNormalSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalPolygonNormalSize.setDefValue(1.0);
        this.m_globalPolygonNormalSize.init();
        this.m_globalPolygonNormalLength.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_globalPolygonNormalLength.setDefValue(0.5);
        this.m_globalPolygonNormalLength.init();
        this.m_globalPolygonNormalColor.setColor(Color.red);
        this.m_dimOfPolygons = -1;
        this.setMaxNumPolygons(0);
        this.m_bShowPolygons = true;
        this.m_bShowTaggedPolygons = true;
        this.m_bShowPolygonStartArrow = false;
        this.m_bShowPolygonEndArrow = false;
        this.m_polygonColor = null;
        this.m_bShowPolygonColors = false;
        this.m_globalPolygonColor.setColor(new Color(25, 20, 200));
        this.m_globalPolygonTagColor.setColor(Color.magenta);
        this.m_useGlobalPolygonSize = true;
        this.m_globalPolygonSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalPolygonSize.setDefValue(2.0);
        this.m_globalPolygonSize.init();
    }

    public void showPolygonEndArrow(boolean flag) {
        this.m_bShowPolygonEndArrow = flag;
    }

    public Color getGlobalPolygonColor() {
        return this.m_globalPolygonColor.getColor();
    }

    public Color getGlobalPolygonNormalColor() {
        return this.m_globalPolygonNormalColor.getColor();
    }

    public void setGlobalPolygonColor(Color color) {
        this.m_globalPolygonColor.setColor(color);
    }

    public void setGlobalPolygonNormalColor(Color color) {
        this.m_globalPolygonNormalColor.setColor(color);
    }

    public boolean merge(PgGeometryIf aGeom) {
        int oldNov = this.getNumVertices();
        if (!super.merge(aGeom)) {
            return false;
        }
        if (!(aGeom instanceof PgPolygonSet)) {
            return false;
        }
        PgPolygonSet geom = (PgPolygonSet)aGeom;
        if (this.m_numPolygons == 0) {
            this.setDimOfPolygons(geom.m_dimOfPolygons);
        } else if (geom.m_dimOfPolygons != this.m_dimOfPolygons) {
            this.setDimOfPolygons(-1);
        }
        int oldNoe = this.m_numPolygons;
        int newNoe = this.m_numPolygons + geom.m_numPolygons;
        this.setNumPolygons(newNoe);
        PiVector.copy(this.m_polygon, oldNoe, geom.m_polygon, 0, geom.m_numPolygons);
        int i = 0;
        while (i < geom.m_numPolygons) {
            int polySize = geom.m_polygon[i].getSize();
            this.m_polygon[oldNoe + i].setSize(polySize);
            int j = 0;
            while (j < polySize) {
                int n = j++;
                this.m_polygon[oldNoe + i].m_data[n] = this.m_polygon[oldNoe + i].m_data[n] + oldNov;
            }
            ++i;
        }
        if (geom.m_polygonNormal != null) {
            this.assurePolygonNormals();
            PdVector.copy(this.m_polygonNormal, oldNoe, geom.m_polygonNormal, 0, geom.m_numPolygons);
        }
        if (geom.m_polygonColor != null) {
            this.assurePolygonColors();
            PdColor.copy(this.m_polygonColor, oldNoe, geom.m_polygonColor, 0, geom.m_numPolygons);
        }
        return true;
    }

    public boolean isShowingPolygonStartArrow() {
        return this.m_bShowPolygonStartArrow;
    }

    public void showPolygonStartArrow(boolean flag) {
        this.m_bShowPolygonStartArrow = flag;
    }

    public int getNumPolygons() {
        return this.m_numPolygons;
    }

    public void setNumPolygons(int aNumPolygons) {
        if (aNumPolygons > this.m_maxNumPolygons) {
            this.setMaxNumPolygons(aNumPolygons);
        } else if (aNumPolygons < this.m_numPolygons && this.m_dimOfPolygons == -1) {
            int i = aNumPolygons;
            while (i < this.m_numPolygons) {
                this.m_polygon[i].setSize(0);
                ++i;
            }
        }
        this.m_numPolygons = aNumPolygons;
    }

    public int[] removeMarkedVertices() {
        int DELETE = -1;
        int[] index = super.removeMarkedVertices();
        int i = 0;
        while (i < this.m_numPolygons) {
            int num = 0;
            int len = this.m_polygon[i].getSize();
            int j = 0;
            while (j < len) {
                if (index[this.m_polygon[i].m_data[j]] != DELETE) {
                    this.m_polygon[i].m_data[num] = index[this.m_polygon[i].m_data[j]];
                    ++num;
                }
                ++j;
            }
            if (num <= 1) {
                this.m_polygon[i].setTag(2);
            } else {
                this.m_polygon[i].setSize(num);
            }
            ++i;
        }
        this.removeMarkedPolygons();
        this.assureDimOfPolygons();
        return index;
    }

    public boolean removeUnusedVertices() {
        int j;
        int USED = 1;
        int UNUSED = -1;
        PiVector indVec = new PiVector(this.m_numVertices);
        indVec.setConstant(UNUSED);
        int[] index = indVec.m_data;
        int i = 0;
        while (i < this.m_numPolygons) {
            j = 0;
            while (j < this.m_polygon[i].m_data.length) {
                index[this.m_polygon[i].m_data[j]] = USED;
                ++j;
            }
            ++i;
        }
        int newnop = 0;
        i = 0;
        while (i < this.m_numVertices) {
            if (index[i] == USED) {
                index[i] = newnop++;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numVertices) {
            if (index[i] != UNUSED && index[i] < i) {
                this.m_vertex[index[i]] = this.m_vertex[i];
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numPolygons) {
            j = 0;
            while (j < this.m_polygon[i].m_data.length) {
                this.m_polygon[i].m_data[j] = index[this.m_polygon[i].m_data[j]];
                ++j;
            }
            ++i;
        }
        if (this.m_vertexNormal != null) {
            i = 0;
            while (i < this.m_numVertices) {
                if (index[i] != UNUSED && index[i] < i) {
                    this.m_vertexNormal[index[i]] = this.m_vertexNormal[i];
                }
                ++i;
            }
        }
        if (this.m_vertexColor != null) {
            i = 0;
            while (i < this.m_numVertices) {
                if (index[i] != UNUSED && index[i] < i) {
                    this.m_vertexColor[index[i]] = this.m_vertexColor[i];
                }
                ++i;
            }
        }
        PsDebug.notify("number of deleted vertices = " + (this.m_numVertices - newnop));
        this.setNumVertices(newnop);
        this.setMaxNumVertices(newnop);
        return true;
    }

    public boolean update(Object event) {
        PsDebug.notify("called");
        if (event == null) {
            return super.update(null);
        }
        if (event == this.m_globalPolygonColor) {
            PsDebug.notify("called with event=m_globalPolygonColor");
            return super.update(null);
        }
        if (event == this.m_globalPolygonTagColor) {
            PsDebug.notify("called with event=m_globalPolygonColor");
            return super.update(null);
        }
        if (event == this.m_globalPolygonSize) {
            PsDebug.notify("called with event=m_globalPolygonSize");
            return super.update(null);
        }
        if (event == this.m_globalPolygonNormalColor) {
            PsDebug.notify("called with event=m_globalPolygonNormalColor");
            return super.update(null);
        }
        if (event == this.m_globalPolygonNormalLength) {
            PsDebug.notify("called with event=m_globalPolygonNormalLength");
            return super.update(null);
        }
        if (event == this.m_globalPolygonNormalSize) {
            PsDebug.notify("called with event=m_globalPolygonNormalSize");
            return super.update(null);
        }
        return super.update(event);
    }

    public void clearTagPolygon(int anIndex, int aTag) {
        if (anIndex < 0 || anIndex > this.m_numPolygons - 1) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return;
        }
        this.m_polygon[anIndex].clearTag(aTag);
    }

    public PiVector getPolygon(int anIndex) {
        if (anIndex < 0 || anIndex >= this.m_numPolygons) {
            return null;
        }
        return this.m_polygon[anIndex];
    }

    public void setPolygon(int anIndex, int a, int b) {
        if (anIndex < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (anIndex >= this.m_numPolygons) {
            PsDebug.warning("index=" + anIndex + " > " + this.m_numPolygons + "=m_numPolygons, bad programming style");
            this.setNumPolygons(anIndex + 1);
        }
        this.setSizeOfPolygon(anIndex, 2);
        this.m_polygon[anIndex].set(a, b);
    }

    public boolean setPolygon(int anIndex, PiVector aPolygon) {
        if (anIndex < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return false;
        }
        if (aPolygon == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (anIndex >= this.m_numPolygons) {
            PsDebug.warning("index=" + anIndex + " > " + this.m_numPolygons + "=m_numPolygons, bad programming style");
            this.setNumPolygons(anIndex + 1);
        }
        this.setSizeOfPolygon(anIndex, aPolygon.getSize());
        this.m_polygon[anIndex].copy(aPolygon);
        return true;
    }

    public boolean makePolygonColorsFromXYZ() {
        if (this.m_numPolygons == 0) {
            return true;
        }
        this.assurePolygonColors();
        Color[] color = this.getPolygonColors();
        PdVector[] bnd = this.getAmbientBounds();
        double[] diag = PdVector.subNew((PdVector)bnd[1], (PdVector)bnd[0]).m_data;
        PdVector vec = new PdVector(this.m_dim);
        PdVector center = new PdVector(this.m_dim);
        int i = 0;
        while (i < this.m_numPolygons) {
            vec.sub(PgGeometry.getCenterOfElement(center, this.m_vertex, this.m_polygon[i].m_data), bnd[0]);
            if (this.m_dim == 1) {
                color[i] = new Color((float)(vec.m_data[0] / diag[0]), 0.0f, 0.0f);
            } else if (this.m_dim == 2) {
                color[i] = new Color((float)(vec.m_data[0] / diag[0]), (float)(vec.m_data[1] / diag[1]), 0.0f);
            } else if (this.m_dim >= 3) {
                color[i] = new Color((float)(vec.m_data[0] / diag[0]), (float)(vec.m_data[1] / diag[1]), (float)(vec.m_data[2] / diag[2]));
            }
            ++i;
        }
        return true;
    }

    public void copyPolygonSet(PgPolygonSet geom) {
        this.setNumPolygons(geom.getNumPolygons());
        int i = 0;
        while (i < this.m_numPolygons) {
            this.m_polygon[i].setSize(geom.getPolygon(i).getSize());
            ++i;
        }
        PiVector.copy(this.m_polygon, 0, geom.getPolygons(), 0, this.m_numPolygons);
        if (geom.m_polygonNormal != null) {
            this.assurePolygonNormals();
            PdVector.copy(this.m_polygonNormal, 0, geom.getPolygonNormals(), 0, this.m_numPolygons);
        }
        if (geom.m_polygonColor != null) {
            this.assurePolygonColors();
            PdColor.copy(this.m_polygonColor, 0, geom.getPolygonColors(), 0, this.m_numPolygons);
        }
    }

    public boolean isClosed(int ind) {
        if (ind < 0 || ind >= this.m_numPolygons) {
            PsDebug.warning("index=" + ind + " out of range", this);
            return false;
        }
        return this.m_polygon[ind].getFirstEntry() == this.m_polygon[ind].getLastEntry();
    }

    public Color[] getPolygonColors() {
        return this.m_polygonColor;
    }

    public boolean isShowingPolygonColors() {
        return this.m_bShowPolygonColors;
    }

    public void showPolygonColors(boolean flag) {
        this.m_bShowPolygonColors = flag;
    }

    public void assurePolygonColors() {
        if (this.m_polygonColor == null || this.m_polygonColor.length != this.m_maxNumPolygons) {
            this.m_polygonColor = PdColor.realloc(this.m_polygonColor, this.m_maxNumPolygons);
        }
    }

    public void setPolygonColors(Color[] color) {
        if (color == null) {
            this.m_polygonColor = null;
            return;
        }
        if (color.length < this.m_numPolygons) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.m_polygonColor == null || this.m_numPolygons > this.m_polygonColor.length) {
            this.assurePolygonColors();
        }
        PdColor.copy(this.m_polygonColor, 0, color, 0, this.m_numPolygons);
    }

    public void makeOffsetNormals() {
        this.makeNormals(this.OFFSET_NORMAL, 1.0);
    }

    public void makeCurvatureNormals() {
        this.makeNormals(this.CURVATURE_NORMAL, 1.0);
    }

    public void setSizeOfPolygon(int ind, int aSize) {
        if (this.m_dimOfPolygons == aSize) {
            return;
        }
        if (ind < 0 || this.m_numPolygons <= ind) {
            PsDebug.warning("index out of bounds, index = " + ind);
            return;
        }
        if (aSize < 1) {
            PsDebug.warning("argument aSize=" + aSize + " out of range.");
            return;
        }
        if (this.m_numPolygons == 1) {
            this.setDimOfPolygons(aSize);
        } else if (this.m_dimOfPolygons != -1) {
            this.setDimOfPolygons(-1);
        }
        this.m_polygon[ind].setSize(aSize);
    }

    public int[] removePolygon(int ind) {
        this.m_polygon[ind].setTag(2);
        return this.removeMarkedPolygons();
    }

    public void setTagPolygon(int anIndex, int aTag) {
        if (anIndex < 0 || anIndex > this.m_numPolygons - 1) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return;
        }
        this.m_polygon[anIndex].setTag(aTag);
    }

    public boolean hasPolygonColors() {
        return this.m_polygonColor != null && this.m_polygonColor.length == this.m_maxNumPolygons;
    }

    public PgPolygonSet() {
        this(3);
    }

    public PgPolygonSet(int aVertexDim) {
        super(aVertexDim);
        this.setDimOfSimplex(1);
        this.m_polygon = new PiVector[0];
        this.m_globalPolygonColor = new PdColor(PsConfig.getMessage("globalPolygonColor"), this);
        this.m_globalPolygonTagColor = new PdColor(PsConfig.getMessage("globalPolygonTagColor"), this);
        this.m_globalPolygonSize = new PuDouble(PsConfig.getMessage("globalPolygonSize"), this);
        this.m_globalPolygonNormalLength = new PuDouble(PsConfig.getMessage("globalPolygonNormalLength"), this);
        this.m_globalPolygonNormalSize = new PuDouble(PsConfig.getMessage("globalPolygonNormalSize"), this);
        this.m_globalPolygonNormalColor = new PdColor(PsConfig.getMessage("globalPolygonNormalColor"), this);
        if (this.getClass() == (class$jv$geom$PgPolygonSet != null ? class$jv$geom$PgPolygonSet : (class$jv$geom$PgPolygonSet = PgPolygonSet.class$("jv.geom.PgPolygonSet")))) {
            this.init();
        }
    }

    public Color getGlobalPolygonTagColor() {
        return this.m_globalPolygonTagColor.getColor();
    }

    public void setGlobalPolygonTagColor(Color color) {
        this.m_globalPolygonTagColor.setColor(color);
    }

    public void useGlobalPolygonColor(boolean flag) {
        this.m_bShowPolygonColors = !flag;
    }

    public void paint(PvGeometryIf dc) {
        super.paint(dc);
        dc.setState(83, this.isShowingEdgeLabels());
        dc.setState(82, this.isShowingPolygonLabels());
        dc.setState(54, this.m_bShowPolygons);
        dc.setState(88, this.m_bShowPolygonStartArrow);
        dc.setState(89, this.m_bShowPolygonEndArrow);
        dc.setState(92, this.m_bShowPolygonColors);
        if (this.m_bShowPolygons) {
            if (this.m_globalPolygonSize != null) {
                dc.setGlobalPolygonSize(this.m_globalPolygonSize.getValue());
            }
            if (this.m_globalPolygonColor != null) {
                dc.setGlobalPolygonColor(this.m_globalPolygonColor.getColor());
            }
            if (this.m_globalPolygonTagColor != null) {
                dc.setGlobalPolygonTagColor(this.m_globalPolygonTagColor.getColor());
            }
        }
        dc.setNumPolygons(this.m_numPolygons);
        dc.setPolygons(this.m_polygon);
        dc.setPolygonColors(this.m_polygonColor);
        dc.setState(64, this.m_bShowPolygonNormals);
        dc.setState(65, this.m_bShowPolygonNormalArrow);
        dc.setPolygonNormals(this.m_polygonNormal);
        if (this.m_globalPolygonNormalSize != null) {
            dc.setGlobalPolygonNormalSize(this.m_globalPolygonNormalSize.getValue());
        }
        if (this.m_globalPolygonNormalLength != null) {
            dc.setGlobalPolygonNormalLength(this.m_globalPolygonNormalLength.getValue());
        }
        if (this.m_globalPolygonNormalColor != null) {
            dc.setGlobalPolygonNormalColor(this.m_globalPolygonNormalColor.getColor());
        }
    }

    public int getPolygonWithVertex(int vertexInd) {
        int i = 0;
        while (i < this.m_numPolygons) {
            if (this.m_polygon[i].getIndexOf(vertexInd) > -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean blend(double s, PgGeometry ag, double t, PgGeometry bg) {
        if (!super.blend(s, ag, t, bg)) {
            return false;
        }
        if (!(ag instanceof PgPolygonSet)) {
            return false;
        }
        PgPolygonSet a = (PgPolygonSet)ag;
        PgPolygonSet b = (PgPolygonSet)bg;
        if (a.m_numPolygons != b.m_numPolygons) {
            PsDebug.warning("unequal number of polygons", this);
            return false;
        }
        this.setNumPolygons(a.m_numPolygons);
        int i = 0;
        while (i < this.m_numPolygons) {
            this.m_polygon[i].copy(a.m_polygon[i]);
            ++i;
        }
        if (a.m_polygonNormal != null && b.m_polygonNormal != null) {
            this.m_polygonNormal = PdVector.realloc(this.m_polygonNormal, this.m_numPolygons, this.m_dim);
            i = 0;
            while (i < this.m_numPolygons) {
                this.m_polygonNormal[i].blend(s, a.m_polygonNormal[i], t, b.m_polygonNormal[i]);
                this.m_polygonNormal[i].normalize();
                ++i;
            }
        }
        if (a.m_polygonColor != null && b.m_polygonColor != null) {
            this.m_polygonColor = PdColor.realloc(this.m_polygonColor, this.m_numPolygons);
            i = 0;
            while (i < this.m_numPolygons) {
                this.m_polygonColor[i] = PdColor.blend(s, a.m_polygonColor[i], t, b.m_polygonColor[i]);
                ++i;
            }
        }
        return true;
    }

    public double getGlobalPolygonNormalLength() {
        return this.m_globalPolygonNormalLength.getValue();
    }

    public void setGlobalPolygonNormalLength(double length) {
        this.m_globalPolygonNormalLength.setValue(length);
    }

    public double getVertexAngle(int ind, int locInd) {
        int elemLen = this.m_polygon[ind].getSize();
        PdVector p = this.m_vertex[this.m_polygon[ind].m_data[locInd]];
        PdVector q = this.m_vertex[this.m_polygon[ind].m_data[(locInd + 1) % elemLen]];
        PdVector r = this.m_vertex[this.m_polygon[ind].m_data[(locInd - 1 + elemLen) % elemLen]];
        return PdVector.angle(p, q, r);
    }

    public int getDimOfPolygons() {
        return this.m_dimOfPolygons;
    }

    public boolean assureDimOfPolygons() {
        int newNum = PiVector.getSameSize(this.m_polygon, this.m_numPolygons);
        if (newNum != this.m_dimOfPolygons) {
            this.m_dimOfPolygons = newNum;
            return false;
        }
        return true;
    }

    public int[] removeMarkedPolygons() {
        int USED = 1;
        int UNUSED = -1;
        PiVector indVec = new PiVector(this.m_numPolygons);
        indVec.setConstant(UNUSED);
        int[] index = indVec.m_data;
        int i = 0;
        while (i < this.m_numPolygons) {
            if (!this.m_polygon[i].hasTag(2)) {
                index[i] = USED;
            }
            ++i;
        }
        int newnoe = 0;
        i = 0;
        while (i < this.m_numPolygons) {
            if (index[i] == USED) {
                index[i] = newnoe++;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numPolygons) {
            if (index[i] != UNUSED && index[i] < i) {
                this.m_polygon[index[i]].setSize(this.m_polygon[i].getSize());
                this.m_polygon[index[i]].copy(this.m_polygon[i]);
            }
            ++i;
        }
        if (this.m_polygonNormal != null) {
            i = 0;
            while (i < this.m_numPolygons) {
                if (index[i] != UNUSED && index[i] < i) {
                    this.m_polygonNormal[index[i]].setSize(this.m_polygonNormal[i].getSize());
                    this.m_polygonNormal[index[i]].copy(this.m_polygonNormal[i]);
                }
                ++i;
            }
        }
        if (this.m_polygonColor != null) {
            i = 0;
            while (i < this.m_numPolygons) {
                if (index[i] != UNUSED && index[i] < i) {
                    this.m_polygonColor[index[i]] = this.m_polygonColor[i];
                }
                ++i;
            }
        }
        PsDebug.notify("number of deleted polygons = " + (this.m_numPolygons - newnoe));
        this.setNumPolygons(newnoe);
        this.setMaxNumPolygons(newnoe);
        return index;
    }

    public PiVector[] getPolygons() {
        return this.m_polygon;
    }

    public double getGlobalPolygonSize() {
        return this.m_globalPolygonSize.getValue();
    }

    public double getGlobalPolygonNormalSize() {
        return this.m_globalPolygonNormalSize.getValue();
    }

    public void setGlobalPolygonSize(double size) {
        this.m_globalPolygonSize.setValue(size);
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc jvx = super.getJvx();
        jvx.setType(32);
        jvx.showEdgeLabels(this.isShowingEdgeLabels());
        jvx.showPolygonLabels(this.isShowingPolygonLabels());
        jvx.showPolygons(this.isShowingPolygons());
        jvx.showPolygonStartArrow(this.isShowingPolygonStartArrow());
        jvx.showPolygonEndArrow(this.isShowingPolygonEndArrow());
        jvx.setDimOfPolygons(-1);
        jvx.setNumPolygons(this.getNumPolygons());
        jvx.setPolygons(this.getPolygons());
        jvx.setPolygonColors(this.getPolygonColors());
        jvx.setGlobalPolygonColor(this.getGlobalPolygonColor());
        jvx.setGlobalPolygonTagColor(this.getGlobalPolygonTagColor());
        jvx.setGlobalPolygonSize(this.getGlobalPolygonSize());
        if (this.hasPolygonColors()) {
            jvx.showPolygonColors(this.isShowingPolygonColors());
            jvx.setPolygonColors(this.getPolygonColors());
        } else {
            jvx.showPolygonColors(false);
        }
        if (this.hasPolygonNormals()) {
            jvx.showPolygonNormals(this.isShowingPolygonNormals());
            jvx.setPolygonNormals(this.getPolygonNormals());
        } else {
            jvx.showPolygonNormals(false);
        }
        jvx.showPolygonNormalArrow(this.isShowingPolygonNormalArrow());
        jvx.setGlobalPolygonNormalColor(this.getGlobalPolygonNormalColor());
        jvx.setGlobalPolygonNormalLength(this.getGlobalPolygonNormalLength());
        jvx.setGlobalPolygonNormalSize(this.getGlobalPolygonNormalSize());
        return jvx;
    }

    public void setJvx(PgJvxSrc src) {
        super.setJvx(src);
        this.showEdgeLabels(src.isShowingEdgeLabels());
        this.showPolygonLabels(src.isShowingPolygonLabels());
        this.showPolygons(src.isShowingPolygons());
        this.showPolygonStartArrow(src.isShowingPolygonStartArrow());
        this.showPolygonEndArrow(src.isShowingPolygonEndArrow());
        this.setNumPolygons(src.getNumPolygons());
        int dim = PiVector.getSameSize(src.getPolygons(), src.getNumPolygons());
        this.setDimOfPolygons(dim);
        this.setPolygons(src.getPolygons());
        this.setPolygonColors(src.getPolygonColors());
        this.showPolygonColors(src.isShowingPolygonColors());
        if (src.getGlobalPolygonColor() != null) {
            this.setGlobalPolygonColor(src.getGlobalPolygonColor());
        }
        if (src.getGlobalPolygonTagColor() != null) {
            this.setGlobalPolygonTagColor(src.getGlobalPolygonTagColor());
        }
        if (src.getGlobalPolygonSize() != 0.0) {
            this.setGlobalPolygonSize(src.getGlobalPolygonSize());
        }
        this.showPolygonNormals(src.isShowingPolygonNormals());
        this.showPolygonNormalArrow(src.isShowingPolygonNormalArrow());
        if (src.getPolygonNormals() != null) {
            this.setPolygonNormals(src.getPolygonNormals());
        }
        if (src.getGlobalPolygonNormalColor() != null) {
            this.setGlobalPolygonNormalColor(src.getGlobalPolygonNormalColor());
        }
        if (src.getGlobalPolygonNormalLength() != 0.0) {
            this.setGlobalPolygonNormalLength(src.getGlobalPolygonNormalLength());
        }
        if (src.getGlobalPolygonNormalSize() != 0.0) {
            this.setGlobalPolygonNormalSize(src.getGlobalPolygonNormalSize());
        }
    }

    public void setGlobalPolygonNormalSize(double size) {
        this.m_globalPolygonNormalSize.setValue(size);
    }

    public boolean isShowingPolygons() {
        return this.m_bShowPolygons;
    }

    public void showPolygons(boolean flag) {
        this.m_bShowPolygons = flag;
    }

    public int getMaxNumPolygons() {
        return this.m_maxNumPolygons;
    }

    protected void setMaxNumPolygons(int aNumPolygons) {
        if (this.m_maxNumPolygons == aNumPolygons) {
            return;
        }
        this.m_polygon = this.m_dimOfPolygons > -1 ? PiVector.realloc(this.m_polygon, aNumPolygons, this.m_dimOfPolygons) : PiVector.realloc(this.m_polygon, aNumPolygons);
        if (this.m_polygonNormal != null) {
            this.m_polygonNormal = PdVector.realloc(this.m_polygonNormal, aNumPolygons, this.m_dim);
        }
        if (this.m_polygonColor != null) {
            this.m_polygonColor = PdColor.realloc(this.m_polygonColor, aNumPolygons);
        }
        this.m_maxNumPolygons = aNumPolygons;
        if (this.m_maxNumPolygons < this.m_numPolygons) {
            this.m_numPolygons = this.m_maxNumPolygons;
        }
    }

    public void setDimOfPolygons(int aSize) {
        if (aSize == this.m_dimOfPolygons) {
            return;
        }
        if (aSize != -1 && aSize <= 0) {
            PsDebug.warning("argument aSize=" + aSize + " out of range.");
            return;
        }
        this.m_dimOfPolygons = aSize;
        if (aSize == -1) {
            int i = this.m_numPolygons;
            while (i < this.m_maxNumPolygons) {
                this.m_polygon[i].setSize(0);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.m_maxNumPolygons) {
                this.m_polygon[i].setSize(aSize);
                ++i;
            }
        }
    }

    public PdVector[] getPolygonVertices(int ind) {
        if (ind < 0 || this.m_numPolygons <= ind) {
            PsDebug.warning("ind out of bounds, ind = " + ind);
            return null;
        }
        if (this.m_polygon[ind].getSize() == 0) {
            PsDebug.notify("empty polygon, ind = " + ind);
            return null;
        }
        int polySize = this.m_polygon[ind].getSize();
        PdVector[] vectorArray = new PdVector[polySize];
        --polySize;
        while (polySize >= 0) {
            vectorArray[polySize] = this.m_vertex[this.m_polygon[ind].m_data[polySize]];
            --polySize;
        }
        return vectorArray;
    }

    public boolean setPolygonVertices(int ind, PdVector[] vArray) {
        int polySize = this.m_polygon[ind].getSize();
        if (polySize != vArray.length) {
            PsDebug.warning("polygon and array have different length");
            return false;
        }
        --polySize;
        while (polySize >= 0) {
            this.m_vertex[this.m_polygon[ind].m_data[polySize]].copy(vArray[polySize]);
            --polySize;
        }
        return true;
    }

    public void setPolygons(PiVector[] polygon) {
        if (polygon == null || polygon.length < this.m_numPolygons) {
            PsDebug.warning("void length of polygon array");
            return;
        }
        int dimSav = polygon[0].getSize();
        int i = 0;
        while (i < this.m_numPolygons) {
            int dim = polygon[i].getSize();
            this.m_polygon[i].setSize(dim);
            if (dimSav != -1 && dim != dimSav) {
                dimSav = -1;
            }
            ++i;
        }
        PiVector.copy(this.m_polygon, 0, polygon, 0, this.m_numPolygons);
    }
}

