/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ListIterator;
import java.util.Random;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jv.vecmath.PdVector;

public class LampAdmin
extends JFrame
implements ActionListener {
    final int N = 7;
    JPanel[] lampPanel = new JPanel[8];
    JPanel[] lampPanelContent = new JPanel[8];
    boolean lastRAB;
    public Vector lampList = new Vector();
    double lastScale = 1.0;
    PdVector lastViewDir = new PdVector(3.2, 0.3, -0.9);
    PdVector lastPosition = new PdVector(10.0, 20.0, -20.0);
    PdVector lastUpVector = new PdVector(0.0, 0.0, 0.0);
    PdVector lastInterest = new PdVector(0.0, 0.0, 0.0);
    Project pro;
    Lamp theDarkLamp;
    int selectedLamp;
    boolean lampIsSelected = false;
    surfex surfex;
    RayFrame LampPrevRayFrame;
    JButton addButton = new JButton();
    JSlider scaleSlider;
    public jv4surfex jv4sx = null;
    boolean showOnlySelectedLamp = true;
    JLabel scaleLabel;
    JPanel Panel = new JPanel(new BorderLayout());
    JButton bt7 = new JButton();
    JCheckBox raytracePreview = new JCheckBox("ray preview", true);
    JCheckBox showTriangPrev = new JCheckBox("triang prev", true);
    JCheckBox antialiasing = new JCheckBox("antialiasing", false);
    JButton bgColorButton = null;
    String tmp_surfex_file = "tmp_surfex.jpg";
    UpdateRayframeImmediatlyThread updateRayframeImmediatlyThread;

    LampAdmin(surfex surfex2, Project project) {
        super("Configure lamps of " + project.filename);
        JButton jButton;
        this.surfex = surfex2;
        this.makeDarkLamp();
        this.pro = project;
        Random random = new Random();
        int n = random.nextInt(99999999);
        this.tmp_surfex_file = "tmp_surfex_lampPrev" + n + "_" + project.ProjectNumber + ".jpg";
        this.jv4sx = this.surfex.iaa ? new jv4surfex(true, this.surfex.theApplet, this.surfex, 624, 100.0) : new jv4surfex(false, null, this.surfex, 624, 100.0);
        JPanel jPanel = new JPanel(new FlowLayout());
        try {
            jButton = this.surfex.filePrefix.equals("") ? new JButton(new ImageIcon("saveas.gif")) : new JButton(new ImageIcon(new URL(this.surfex.filePrefix + "saveas.gif")));
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException.toString());
            jButton = new JButton();
        }
        jButton.setToolTipText("save this Lamp settings" + project.projectName + " as");
        jButton.addActionListener(this);
        jButton.setActionCommand("saveas");
        jPanel.add(jButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.lampPanel[0] = new JPanel(new BorderLayout());
        for (int i = 0; i < 7; ++i) {
            this.lampPanel[i + 1] = new JPanel(new BorderLayout());
            this.lampPanelContent[i] = new JPanel(new GridLayout(11, 1));
            this.lampPanel[i].add((Component)this.lampPanelContent[i], "West");
            this.lampPanel[i].add((Component)this.lampPanel[i + 1], "Center");
        }
        this.lampPanelContent[7] = new JPanel(new GridLayout(11, 1));
        this.lampPanel[7].add((Component)this.lampPanelContent[7], "West");
        this.lampPanelContent[0].add(new JLabel(" Lamp "));
        this.lampPanelContent[1].add(new JLabel(" preview "));
        this.lampPanelContent[2].add(new JLabel(" x-Koord "));
        this.lampPanelContent[3].add(new JLabel(" y-Koord "));
        this.lampPanelContent[4].add(new JLabel(" z-Koord "));
        this.lampPanelContent[5].add(new JLabel(" intensity "));
        this.lampPanelContent[6].add(new JLabel(" color "));
        this.lampPanelContent[7].add(new JLabel(" shines "));
        this.bgColorButton = new JButton();
        this.bgColorButton.setBackground(Color.white);
        this.bgColorButton.setToolTipText("select the background color");
        this.bgColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LampAdmin.this.bgColorButton.setBackground(JColorChooser.showDialog(null, "change the background color", LampAdmin.this.bgColorButton.getBackground()));
            }
        });
        this.raytracePreview.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LampAdmin.this.raytraceAlwaysChanged(changeEvent);
            }
        });
        jPanel.add(this.raytracePreview);
        this.showTriangPrev.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LampAdmin.this.showTriangPrevChanged(changeEvent);
            }
        });
        jPanel.add(this.showTriangPrev);
        JScrollPane jScrollPane = new JScrollPane(this.lampPanel[0]);
        this.Panel.add((Component)jPanel, "North");
        this.Panel.add((Component)jScrollPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.out.println("closeevent");
                LampAdmin.this.lampManagerInvisible();
            }
        });
        this.loadDefaultLampSettig1();
        this.lampPanelContent[0].add(new JLabel(" "));
        this.setContentPane(this.Panel);
        this.Panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.pack();
        this.setVisible(false);
        this.lastRAB = this.raytracePreview.isSelected();
        this.LampPrevRayFrame = new RayFrame("raytraced lamp preview");
        this.LampPrevRayFrame.setSize(200 + this.LampPrevRayFrame.getInsets().left + this.LampPrevRayFrame.getInsets().right, 200 + this.LampPrevRayFrame.getInsets().top + this.LampPrevRayFrame.getInsets().bottom);
        this.LampPrevRayFrame.setLocation(624, 200);
        this.LampPrevRayFrame.setInfo("your viewing direction\n is the lamp's one");
        this.jv4sx.setPosTextFields2(this.getSelectedLamp().xPos, this.getSelectedLamp().yPos, this.getSelectedLamp().zPos);
        this.updateJV4SXandReconstructLastView();
        this.updateRayframeImmediatlyThread = new UpdateRayframeImmediatlyThread(this.LampPrevRayFrame, this.surfex, project, this.jv4sx, project.jv4sx, this.getModifiedLampList(), this.showOnlySelectedLamp, this.getSelectedLamp());
        this.updateRayframeImmediatlyThread.start();
        SwingUtilities.updateComponentTreeUI(this);
    }

    public String vec2Str(double[] dArray) {
        return "<" + dArray[0] + "," + dArray[1] + "," + dArray[2] + ">";
    }

    public Lamp getSelectedLamp() {
        return (Lamp)this.lampList.elementAt(this.selectedLamp);
    }

    public Lamp getCameraLamp() {
        return this.getSelectedLamp().previewLamp(0.0, 0.0, 100.0);
    }

    public Vector getModifiedLampList() {
        Vector<Lamp> vector = new Vector<Lamp>();
        vector.add(this.getCameraLamp());
        this.makeDarkLamp();
        vector.add(this.theDarkLamp);
        vector.add(this.theDarkLamp);
        vector.add(this.theDarkLamp);
        vector.add(this.theDarkLamp);
        vector.add(this.theDarkLamp);
        vector.add(this.theDarkLamp);
        vector.add(this.theDarkLamp);
        vector.add(this.theDarkLamp);
        return vector;
    }

    public void loadDefaultLampSettig1() {
        this.newLamp(-100.0, 100.0, 100.0, 255, 255, 255, 50, true);
        this.newLamp(0.0, 100.0, 100.0, 255, 255, 255, 50, false);
        this.newLamp(100.0, 100.0, 100.0, 255, 255, 255, 70, true);
        this.newLamp(-100.0, 0.0, 100.0, 255, 255, 255, 50, false);
        this.newLamp(0.0, 0.0, 100.0, 255, 255, 255, 50, false);
        this.newLamp(100.0, 0.0, 100.0, 255, 255, 255, 50, false);
        this.newLamp(-100.0, -100.0, 100.0, 255, 255, 255, 50, false);
        this.newLamp(0.0, -100.0, 100.0, 255, 255, 255, 30, true);
        this.newLamp(100.0, -100.0, 100.0, 255, 255, 255, 50, false);
        this.lampIsSelected = true;
        this.setSelectedLamp(2);
    }

    public void makeDarkLamp() {
        Color color = new Color(0, 0, 0);
        this.theDarkLamp = this.getNewLamp(0.0, 0.0, 0.0, color, 0, true);
    }

    public Lamp getNewLamp(double d, double d2, double d3, Color color, int n, boolean bl) {
        Lamp lamp = new Lamp(this.pro, this);
        lamp.setKoords(d, d2, d3);
        lamp.setIntensity(n);
        lamp.setColor(color);
        lamp.setIsShining(bl);
        return lamp;
    }

    public Vector getLampsForJv4sx() {
        Vector<Lamp> vector = new Vector<Lamp>();
        ListIterator listIterator = this.lampList.listIterator();
        while (listIterator.hasNext()) {
            Lamp lamp = (Lamp)listIterator.next();
            if (!lamp.isShining() || lamp.lampNo - 1 == this.selectedLamp) continue;
            vector.add(lamp);
        }
        return vector;
    }

    public boolean lampIsSelected() {
        return this.lampIsSelected;
    }

    public synchronized void setSelectedLamp(int n) {
        if (this.lampIsSelected()) {
            if (this.updateRayframeImmediatlyThread != null) {
                this.updateRayframeImmediatlyThread.stop();
            }
            this.getSelectedLamp().setSelected(false);
            this.selectedLamp = n;
            if (this.jv4sx != null) {
                this.jv4sx.setPosTextFields2(this.getSelectedLamp().xPos, this.getSelectedLamp().yPos, this.getSelectedLamp().zPos);
                this.jv4sx.setLamps(this.getLampsForJv4sx());
            }
            this.lampIsSelected = true;
        } else {
            this.selectedLamp = n;
        }
        this.getSelectedLamp().setSelected(true);
        this.updatePreview();
    }

    public void updatePreview() {
        this.jv4sx.showDefault();
        this.jv4sx.disp.getCamera().setPosition(this.getSelectedLamp().getPos());
        this.newUpdateRayframeImmediatlyThread();
        this.jv4sx.updateDisp();
    }

    public Vector getAllLamps() {
        Vector<Lamp> vector = new Vector<Lamp>();
        ListIterator listIterator = this.lampList.listIterator();
        while (listIterator.hasNext()) {
            Lamp lamp = (Lamp)listIterator.next();
            if (!lamp.isShining()) continue;
            vector.add(lamp);
        }
        while (vector.size() < 9) {
            vector.add(this.theDarkLamp);
        }
        return vector;
    }

    public void newLamp(double d, double d2, double d3, int n, int n2, int n3, int n4, boolean bl) {
        this.newLamp();
        Lamp lamp = (Lamp)this.lampList.lastElement();
        lamp.setKoords(d, d2, d3);
        lamp.setIntensity(n4);
        lamp.setColor(n, n2, n3);
        lamp.setIsShining(bl);
    }

    public void raytracePreviewChanged(ChangeEvent changeEvent) {
    }

    public void showTriangPrevChanged(ChangeEvent changeEvent) {
        if (this.showTriangPrev.isSelected() != this.lastRAB) {
            if (this.showTriangPrev.isSelected()) {
                this.jv4sx.setVisible(true);
                this.lastRAB = this.showTriangPrev.isSelected();
            } else {
                this.jv4sx.setVisible(false);
                this.lastRAB = this.showTriangPrev.isSelected();
            }
        }
    }

    public synchronized void raytraceAlwaysChanged(ChangeEvent changeEvent) {
        if (this.raytracePreview.isSelected() != this.lastRAB) {
            if (this.raytracePreview.isSelected()) {
                this.startRaytraceAlways();
                this.LampPrevRayFrame.setVisible(true);
                this.lastRAB = this.raytracePreview.isSelected();
            } else {
                this.LampPrevRayFrame.setVisible(false);
                this.lastRAB = this.raytracePreview.isSelected();
            }
        }
    }

    public void startRaytraceAlways() {
        this.newUpdateRayframeImmediatlyThread();
    }

    public void newUpdateRayframeImmediatlyThread() {
    }

    public void addButtonActionPerformed(ActionEvent actionEvent) {
        this.newLamp();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println("close");
        this.lampManagerInvisible();
    }

    public void lampManagerInvisible() {
        this.setVisible(false);
        this.LampPrevRayFrame.setVisible(false);
        this.jv4sx.setVisible(false);
    }

    public void newLamp() {
        Lamp lamp = new Lamp(this.pro, this, this.lampPanelContent);
        int n = this.lampList.size() + 1;
        ListIterator listIterator = this.lampList.listIterator();
        while (listIterator.hasNext()) {
            if (n != ((Lamp)listIterator.next()).lampNo) continue;
            ++n;
            while (listIterator.hasPrevious()) {
                listIterator.previous();
            }
        }
        lamp.setLampNo(n);
        this.lampList.add(lamp);
    }

    public String save() {
        String string = "";
        ListIterator listIterator = this.lampList.listIterator();
        string = string + "////////////////// LAMPS: /////////////////////////\n";
        string = string + this.lampList.size() + "\n";
        while (listIterator.hasNext()) {
            string = string + ((Lamp)listIterator.next()).saveYourself();
        }
        return string;
    }

    public void loadParameters(BufferedReader bufferedReader, String string) {
        try {
            String string2 = bufferedReader.readLine();
            boolean bl = true;
            for (int i = Integer.parseInt(bufferedReader.readLine()); i > 0; --i) {
                String string3 = bufferedReader.readLine();
                this.newLamp();
                if (string.equals("specify")) {
                    try {
                        bufferedReader.mark(255);
                        String string4 = bufferedReader.readLine();
                        while (string4.equals("parno:") || string4.equals("fromtoval:")) {
                            if (string4.equals("parno:")) {
                                ((OneParameter)this.lampList.lastElement()).setParNo(Integer.parseInt(bufferedReader.readLine()));
                            }
                            if (string4.equals("fromtoval:")) {
                                ((OneParameter)this.lampList.lastElement()).newFrom = ((OneParameter)this.lampList.lastElement()).oldFrom = Double.parseDouble(bufferedReader.readLine());
                                ((OneParameter)this.lampList.lastElement()).newTo = ((OneParameter)this.lampList.lastElement()).oldTo = Double.parseDouble(bufferedReader.readLine());
                                ((OneParameter)this.lampList.lastElement()).parSlider.setValue(Integer.parseInt(bufferedReader.readLine()));
                                ((OneParameter)this.lampList.lastElement()).updateparSliderAndLabel();
                            }
                            bufferedReader.mark(255);
                            string4 = bufferedReader.readLine();
                        }
                        bufferedReader.reset();
                    }
                    catch (Exception exception) {
                        bufferedReader.reset();
                    }
                }
                if (string.equals("complete") || string.equals("onlyeqns") || string.equals("eqnsvis")) {
                    ((OneParameter)this.lampList.lastElement()).setParNo(Integer.parseInt(bufferedReader.readLine()));
                    ((OneParameter)this.lampList.lastElement()).newFrom = ((OneParameter)this.lampList.lastElement()).oldFrom = Double.parseDouble(bufferedReader.readLine());
                    ((OneParameter)this.lampList.lastElement()).newTo = ((OneParameter)this.lampList.lastElement()).oldTo = Double.parseDouble(bufferedReader.readLine());
                    ((OneParameter)this.lampList.lastElement()).parSlider.setValue(Integer.parseInt(bufferedReader.readLine()));
                    ((OneParameter)this.lampList.lastElement()).from.setText("" + ((OneParameter)this.lampList.lastElement()).newFrom);
                    ((OneParameter)this.lampList.lastElement()).to.setText("" + ((OneParameter)this.lampList.lastElement()).newTo);
                    ((OneParameter)this.lampList.lastElement()).updateparSliderAndLabel();
                    ((OneParameter)this.lampList.lastElement()).repaint();
                }
                if (!string.equals("complete") && !string.equals("onlystyle")) continue;
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public OneParameter getParameter(String string) {
        ListIterator listIterator = this.lampList.listIterator();
        while (listIterator.hasNext()) {
            OneParameter oneParameter = (OneParameter)listIterator.next();
            if (oneParameter.nameLabel.getText().compareTo(string) != 0) continue;
            return oneParameter;
        }
        return null;
    }

    public void showall() {
        this.jv4sx.show();
        this.LampPrevRayFrame.setVisible(true);
        this.LampPrevRayFrame.toFront();
        this.setVisible(true);
        this.toFront();
    }

    public void lampManagerToFront() {
        this.setVisible(true);
        this.LampPrevRayFrame.setVisible(true);
        this.jv4sx.setVisible(true);
    }

    public void updateJV4SXandReconstructLastView() {
        this.jv4sx.changeFrameTitle("Lamppreview " + this.pro.projectName + "(uses JavaView)");
        this.jv4sx.updateDisp();
    }
}

