/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.number.PuString;
import jv.object.PsDebug;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PuData;
import jv.vecmath.PuMath;

public class PiVector
extends P_Vector {
    public int[] m_data;

    public static int[][] getEntries(PiVector[] vArr) {
        if (vArr == null) {
            return null;
        }
        int size = vArr.length;
        int[][] data = new int[size][];
        int i = 0;
        while (i < size) {
            data[i] = vArr[i].getEntries();
            ++i;
        }
        return data;
    }

    public int[] getEntries() {
        return (int[])this.m_data.clone();
    }

    public int getEntry(int ind) {
        if (ind < 0 || this.m_data.length <= ind) {
            PsDebug.warning("index out of range, index=" + ind);
            return 0;
        }
        return this.m_data[ind];
    }

    public void setEntry(int ind, int value) {
        if (this.m_data == null || this.m_data.length <= ind) {
            this.setSize(ind + 1);
        }
        this.m_data[ind] = value;
    }

    public int getLastEntry() {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return 0;
        }
        return this.m_data[this.m_data.length - 1];
    }

    public void setLastEntry(int value) {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return;
        }
        this.m_data[this.m_data.length - 1] = value;
    }

    public int indexOfMax() {
        int index = 0;
        int max = Integer.MIN_VALUE;
        int i = 0;
        while (i < this.m_data.length) {
            if (this.m_data[i] > max) {
                max = this.m_data[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public int dist(PiVector v) {
        int sum = 0;
        int i = 0;
        while (i < this.m_data.length) {
            int tmp = this.m_data[i] - v.m_data[i];
            sum += tmp * tmp;
            ++i;
        }
        return (int)Math.sqrt(sum);
    }

    public static PiVector[] copyNew(int[][] data) {
        if (data == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        int size = data.length;
        PiVector[] newData = new PiVector[size];
        int i = 0;
        while (i < size) {
            newData[i] = new PiVector(data[i]);
            ++i;
        }
        return newData;
    }

    public static PiVector[] copyNew(PiVector[] data) {
        if (data == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        return PiVector.copyNew(data, data.length);
    }

    public static PiVector[] copyNew(PiVector[] data, int size) {
        if (data == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PiVector[] newData = new PiVector[size];
        int i = 0;
        while (i < size) {
            newData[i] = PiVector.copyNew(data[i]);
            ++i;
        }
        return newData;
    }

    public static PiVector copyNew(PiVector v) {
        if (v == null) {
            PsDebug.warning("missing argument vector");
            return null;
        }
        if (v.m_data == null) {
            PsDebug.warning("v.m_data==null", v);
            return null;
        }
        PiVector newVector = new PiVector(v.m_data.length);
        newVector.copy(v);
        return newVector;
    }

    public boolean equals(int[] list) {
        int len = this.getSize();
        if (list == null && len == 0) {
            return true;
        }
        if (list == null) {
            return false;
        }
        if (len != list.length) {
            return false;
        }
        --len;
        while (len >= 0) {
            if (this.m_data[len] != list[len]) {
                return false;
            }
            --len;
        }
        return true;
    }

    public boolean equals(PiVector vec) {
        if (vec == null && this.getSize() == 0) {
            return true;
        }
        return this.equals(vec.m_data);
    }

    public static int getSameSize(PiVector[] vecArray, int numUsed) {
        if (vecArray == null || vecArray.length == 0) {
            return -1;
        }
        if (vecArray[0] == null) {
            return -1;
        }
        if (vecArray.length < numUsed) {
            PsDebug.warning("used vectors larger than array size.");
            numUsed = vecArray.length;
        }
        int len = vecArray[0].getSize();
        int i = 1;
        while (i < numUsed) {
            if (len != vecArray[i].getSize()) {
                len = -1;
                break;
            }
            ++i;
        }
        return len;
    }

    public int getSize() {
        if (this.m_data == null) {
            return 0;
        }
        return this.m_data.length;
    }

    public int setSize(int aSize) {
        if (this.m_data == null) {
            this.m_data = new int[aSize];
        } else if (this.m_data.length != aSize) {
            this.m_data = PuData.realloc(this.m_data, aSize);
        }
        return aSize;
    }

    public void blendBase(PiVector v, int b, PiVector w) {
        if (this.m_data == null) {
            this.setSize(v.m_data.length);
        }
        if (this.m_data.length != v.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = v.m_data[i] + b * w.m_data[i];
            ++i;
        }
    }

    public Object clone() {
        return PiVector.copyNew(this);
    }

    public int sqrLength() {
        int sum = 0;
        int i = 0;
        while (i < this.m_data.length) {
            sum += this.m_data[i] * this.m_data[i];
            ++i;
        }
        return sum;
    }

    public int length() {
        int sum = 0;
        int i = 0;
        while (i < this.m_data.length) {
            sum += this.m_data[i] * this.m_data[i];
            ++i;
        }
        return (int)Math.sqrt(sum);
    }

    public void setLength(int aLength) {
        int fac = this.length();
        if (fac == 0) {
            return;
        }
        fac /= aLength;
        int i = 0;
        while (i < this.m_data.length) {
            int n = i++;
            this.m_data[n] = this.m_data[n] / fac;
        }
    }

    public int changeValue(int usedSize, int oldValue, int newValue) {
        int count = 0;
        int k = 0;
        while (k < usedSize) {
            if (this.m_data[k] == oldValue) {
                this.m_data[k] = newValue;
                ++count;
            }
            ++k;
        }
        return count;
    }

    public int changeValue(int oldValue, int newValue) {
        int count = 0;
        int k = 0;
        while (k < this.m_data.length) {
            if (this.m_data[k] == oldValue) {
                this.m_data[k] = newValue;
                ++count;
            }
            ++k;
        }
        return count;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("");
        strBuf.append(super.toString() + "\n");
        strBuf.append("\t ******* PiVector ***********\n");
        int size = this.getSize();
        strBuf.append("\t size\t = " + size + "\n");
        if (size > 0) {
            strBuf.append("\t m_data = (" + this.m_data[0]);
            int i = 1;
            while (i < size) {
                strBuf.append(", " + this.m_data[i]);
                ++i;
            }
            strBuf.append(")\n");
        } else {
            strBuf.append("\t m_data = null");
        }
        return strBuf.toString();
    }

    public static final boolean max(PiVector max, PiVector[] aVecArray, int arrayLength) {
        if (aVecArray == null || aVecArray.length == 0 || aVecArray.length < arrayLength || aVecArray[0] == null) {
            PsDebug.warning("null pointer argument or array too small");
            return false;
        }
        if (max == null || max.m_data == null) {
            PsDebug.warning("missing max argument");
            return false;
        }
        max.setConstant(Integer.MIN_VALUE);
        int i = 0;
        while (i < arrayLength) {
            int k = Math.min(max.m_data.length, aVecArray[i].m_data.length) - 1;
            while (k >= 0) {
                if (max.m_data[k] < aVecArray[i].m_data[k]) {
                    max.m_data[k] = aVecArray[i].m_data[k];
                }
                --k;
            }
            ++i;
        }
        return true;
    }

    public int max() {
        int max = -2147483647;
        int i = 0;
        while (i < this.m_data.length) {
            if (this.m_data[i] > max) {
                max = this.m_data[i];
            }
            ++i;
        }
        return max;
    }

    public boolean hasUniqueEntries() {
        if (this == null || this.m_data == null || this.getSize() <= 1) {
            return true;
        }
        PiVector s = new PiVector(this.getSize());
        this.sort(s);
        int i = 0;
        while (i < this.getSize() - 1) {
            if (this.m_data[i] == this.m_data[i + 1]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int sqrDist(PiVector v) {
        int sum = 0;
        int i = 0;
        while (i < this.m_data.length) {
            int tmp = this.m_data[i] - v.m_data[i];
            sum += tmp * tmp;
            ++i;
        }
        return sum;
    }

    public int indexOfAbsMin() {
        int index = 0;
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.m_data.length) {
            if (Math.abs(this.m_data[i]) < min) {
                min = Math.abs(this.m_data[i]);
                index = i;
            }
            ++i;
        }
        return index;
    }

    public void sub(PiVector m) {
        if (this.m_data == null) {
            this.setSize(m.m_data.length);
        }
        if (this.m_data.length != m.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int i = 0;
        while (i < this.m_data.length) {
            int n = i;
            this.m_data[n] = this.m_data[n] - m.m_data[i];
            ++i;
        }
    }

    public void sub(PiVector m1, PiVector m2) {
        if (this.m_data == null) {
            this.setSize(m1.m_data.length);
        }
        if (this.m_data.length != m1.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = m1.m_data[i] - m2.m_data[i];
            ++i;
        }
    }

    public int getFirstEntry() {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return 0;
        }
        return this.m_data[0];
    }

    public static boolean copy(PiVector[] dataDest, int destInd, PiVector[] dataSrc, int srcInd, int size) {
        if (dataDest == null || dataDest.length < destInd + size) {
            PsDebug.error("missing space in dataDest", dataSrc);
            return false;
        }
        int i = 0;
        while (i < size) {
            dataDest[destInd + i].copy(dataSrc[srcInd + i]);
            ++i;
        }
        return true;
    }

    public void setFirstEntry(int value) {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return;
        }
        this.m_data[0] = value;
    }

    public boolean copy(int destInd, PiVector dataSrc, int srcInd, int size) {
        if (this.m_data.length < destInd + size) {
            PsDebug.error("missing space in this", this);
            return false;
        }
        if (this.m_data == null || this.m_data.length < destInd + size) {
            this.setSize(destInd + size);
        }
        System.arraycopy(dataSrc.m_data, srcInd, this.m_data, destInd, size);
        return true;
    }

    public void copy(PiVector v) {
        if (v == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (v.m_data == null) {
            PsDebug.warning("missing data of argument vector");
            return;
        }
        this.copyArray(v);
        super.copy(v);
    }

    public void copy(int[] anArray, int aSize) {
        if (anArray == null) {
            PsDebug.warning("null vector 'm' passed\n");
            return;
        }
        if (this.m_data == null) {
            this.setSize(aSize);
        }
        int len = Math.min(this.m_data.length, aSize);
        System.arraycopy(anArray, 0, this.m_data, 0, len);
        int i = len;
        while (i < this.m_data.length) {
            this.m_data[i] = 0;
            ++i;
        }
    }

    public static void setConstant(PiVector[] aVecArray, int aValue) {
        if (aVecArray == null || aVecArray.length == 0 || aVecArray[0] == null) {
            return;
        }
        int i = 0;
        while (i < aVecArray.length) {
            aVecArray[i].setConstant(aValue);
            ++i;
        }
    }

    public static void setConstant(PiVector[] aVecArray, int[] data) {
        if (aVecArray == null || aVecArray.length == 0 || aVecArray[0] == null) {
            return;
        }
        if (aVecArray[0].m_data.length != data.length) {
            PsDebug.notify("arrays have different length");
            return;
        }
        int len = Math.min(aVecArray[0].m_data.length, data.length);
        int i = 0;
        while (i < aVecArray.length) {
            int j = 0;
            while (j < len) {
                aVecArray[i].m_data[j] = data[j];
                ++j;
            }
            ++i;
        }
    }

    public static void setConstant(PiVector[] aVecArray, PiVector aVector) {
        if (aVector == null) {
            return;
        }
        PiVector.setConstant(aVecArray, aVector.m_data);
    }

    public static void setConstant(PiVector v, int aValue) {
        if (v == null || v.m_data == null) {
            return;
        }
        int i = v.getSize() - 1;
        while (i >= 0) {
            v.m_data[i] = aValue;
            --i;
        }
    }

    public void setConstant(int aValue) {
        if (this.m_data == null) {
            return;
        }
        int i = this.m_data.length - 1;
        while (i >= 0) {
            this.m_data[i] = aValue;
            --i;
        }
    }

    public int addEntry(int val) {
        int size = this.getSize() + 1;
        this.setSize(size);
        this.m_data[size - 1] = val;
        return size;
    }

    public int indexOfMin() {
        int index = 0;
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.m_data.length) {
            if (this.m_data[i] < min) {
                min = this.m_data[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static final PiVector[] realloc(PiVector[] data, int arraySize, int vectorSize) {
        int commonSize;
        if (data != null && data.length == arraySize) {
            int j = 0;
            while (j < data.length) {
                if (data[j].m_data == null || data[j].m_data.length != vectorSize) {
                    data[j].setSize(vectorSize);
                }
                ++j;
            }
            return data;
        }
        PiVector[] newData = new PiVector[arraySize];
        if (data == null) {
            commonSize = 0;
        } else {
            commonSize = Math.min(data.length, arraySize);
            System.arraycopy(data, 0, newData, 0, commonSize);
        }
        int i = 0;
        while (i < commonSize) {
            if (newData[i].m_data == null || newData[i].m_data.length != vectorSize) {
                newData[i].setSize(vectorSize);
            }
            ++i;
        }
        i = commonSize;
        while (i < arraySize) {
            newData[i] = new PiVector(vectorSize);
            ++i;
        }
        return newData;
    }

    public static final PiVector[] realloc(PiVector[] data, int arraySize) {
        int commonSize;
        if (data != null && data.length == arraySize) {
            return data;
        }
        PiVector[] newData = new PiVector[arraySize];
        if (data == null) {
            commonSize = 0;
        } else {
            commonSize = Math.min(data.length, arraySize);
            System.arraycopy(data, 0, newData, 0, commonSize);
        }
        int i = commonSize;
        while (i < arraySize) {
            newData[i] = new PiVector();
            ++i;
        }
        return newData;
    }

    public static int dot(PiVector v, PiVector w) {
        int sum = 0;
        int i = 0;
        while (i < v.m_data.length) {
            sum += v.m_data[i] * w.m_data[i];
            ++i;
        }
        return sum;
    }

    public int dot(PiVector v) {
        int sum = 0;
        int i = 0;
        while (i < this.m_data.length) {
            sum += this.m_data[i] * v.m_data[i];
            ++i;
        }
        return sum;
    }

    public boolean normalize() {
        int length = this.length();
        if (length == 0) {
            return false;
        }
        int i = 0;
        while (i < this.m_data.length) {
            int n = i++;
            this.m_data[n] = this.m_data[n] / length;
        }
        return true;
    }

    public void normalize(PiVector v) {
        int length = v.length();
        if (length == 0) {
            this.copy(v);
            return;
        }
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = v.m_data[i] / length;
            ++i;
        }
    }

    public void add(int val) {
        if (this.m_data == null) {
            return;
        }
        int i = 0;
        while (i < this.m_data.length) {
            int n = i++;
            this.m_data[n] = this.m_data[n] + val;
        }
    }

    public void add(PiVector m) {
        if (this.m_data == null) {
            this.setSize(m.m_data.length);
        }
        if (this.m_data.length != m.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int i = 0;
        while (i < this.m_data.length) {
            int n = i;
            this.m_data[n] = this.m_data[n] + m.m_data[i];
            ++i;
        }
    }

    public void add(PiVector m1, PiVector m2) {
        if (this.m_data == null) {
            this.setSize(m1.m_data.length);
        }
        if (this.m_data.length != m1.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = m1.m_data[i] + m2.m_data[i];
            ++i;
        }
    }

    public String toShortString() {
        int j;
        StringBuffer strBuf = new StringBuffer("");
        int size = this.getSize();
        if (this.m_data == null || size == 0) {
            strBuf.append("{ m_data = null} \t");
        } else {
            strBuf.append("{ " + PuString.intToString(this.m_data[0], 6));
            j = 1;
            while (j < size) {
                strBuf.append(", " + PuString.intToString(this.m_data[j], 6));
                ++j;
            }
            strBuf.append("} \t");
        }
        strBuf.append("Attr = ");
        if (this.m_bits == null) {
            strBuf.append("{ } \t");
        } else {
            strBuf.append("{ " + PuString.intToString((int)this.m_bits[0], 4));
            j = 1;
            while (j < this.m_bits.length) {
                strBuf.append("\t " + PuString.intToString((int)this.m_bits[j], 4));
                ++j;
            }
            strBuf.append("} \t");
        }
        strBuf.append("\n");
        return strBuf.toString();
    }

    public void copyArray(PiVector v) {
        if (v == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (v.m_data == null) {
            PsDebug.warning("missing data of argument vector");
            return;
        }
        int argLen = v.m_data.length;
        if (this.m_data == null) {
            this.setSize(argLen);
        }
        if (this.m_data.length > argLen) {
            int i = argLen;
            while (i < this.m_data.length) {
                this.m_data[i] = 0;
                ++i;
            }
        } else {
            argLen = this.m_data.length;
        }
        switch (argLen) {
            case 3: {
                this.m_data[2] = v.m_data[2];
            }
            case 2: {
                this.m_data[1] = v.m_data[1];
            }
            case 1: {
                this.m_data[0] = v.m_data[0];
                break;
            }
            default: {
                System.arraycopy(v.m_data, 0, this.m_data, 0, argLen);
            }
        }
    }

    public void leftMultMatrix(PdMatrix m) {
        if (m.m_iSize != m.m_jSize || m.m_iSize != this.m_data.length) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        int[] tmp = new int[this.m_data.length];
        int i = 0;
        while (i < this.m_data.length) {
            tmp[i] = 0;
            int j = 0;
            while (j < this.m_data.length) {
                int n = i;
                tmp[n] = (int)((double)tmp[n] + m.m_data[i][j] * (double)this.m_data[j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = tmp[i];
            ++i;
        }
    }

    public void leftMultMatrix(PdMatrix m, PiVector v) {
        if (this == v) {
            PsDebug.warning("'this' must be different from argument");
            return;
        }
        if (this.m_data.length != m.m_iSize) {
            this.setSize(m.m_iSize);
        }
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = 0;
            int j = 0;
            while (j < this.m_data.length) {
                int n = i;
                this.m_data[n] = (int)((double)this.m_data[n] + m.m_data[i][j] * (double)v.m_data[j]);
                ++j;
            }
            ++i;
        }
    }

    public void invert(int usedSize) {
        int nop = usedSize / 2;
        int k = 0;
        while (k < nop) {
            int tmp = this.m_data[k];
            this.m_data[k] = this.m_data[usedSize - 1 - k];
            this.m_data[usedSize - 1 - k] = tmp;
            ++k;
        }
    }

    public void invert() {
        int nop = this.m_data.length / 2;
        int k = 0;
        while (k < nop) {
            int tmp = this.m_data[k];
            this.m_data[k] = this.m_data[this.m_data.length - 1 - k];
            this.m_data[this.m_data.length - 1 - k] = tmp;
            ++k;
        }
    }

    public static final boolean min(PiVector min, PiVector[] aVecArray, int arrayLength) {
        if (aVecArray == null || aVecArray.length == 0 || aVecArray.length < arrayLength || aVecArray[0] == null) {
            PsDebug.warning("null pointer argument or array too small");
            return false;
        }
        if (min == null || min.m_data == null) {
            PsDebug.warning("missing min argument");
            return false;
        }
        min.setConstant(Integer.MAX_VALUE);
        int i = 0;
        while (i < arrayLength) {
            int k = Math.min(min.m_data.length, aVecArray[i].m_data.length) - 1;
            while (k >= 0) {
                if (min.m_data[k] > aVecArray[i].m_data[k]) {
                    min.m_data[k] = aVecArray[i].m_data[k];
                }
                --k;
            }
            ++i;
        }
        return true;
    }

    public int min() {
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.m_data.length) {
            if (this.m_data[i] < min) {
                min = this.m_data[i];
            }
            ++i;
        }
        return min;
    }

    public double maxAbs() {
        double max = -2.147483647E9;
        int i = 0;
        while (i < this.m_data.length) {
            if ((double)Math.abs(this.m_data[i]) > max) {
                max = Math.abs(this.m_data[i]);
            }
            ++i;
        }
        return max;
    }

    public static PiVector blendNew(int a, PiVector v, int b, PiVector w) {
        PiVector bv = new PiVector(v.getSize());
        bv.blend(a, v, b, w);
        return bv;
    }

    public void multScalar(int scalar) {
        int i = 0;
        while (i < this.m_data.length) {
            int n = i++;
            this.m_data[n] = this.m_data[n] * scalar;
        }
    }

    public void multScalar(PiVector v, int scalar) {
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = v.m_data[i] * scalar;
            ++i;
        }
    }

    public void set(PiVector x, int from, int len) {
        if (x == null || x.getSize() < from + len) {
            PsDebug.warning("argument array too small.");
            return;
        }
        if (this.m_data == null || this.m_data.length != len) {
            this.setSize(len);
        }
        int i = 0;
        while (i < len) {
            this.m_data[i] = x.m_data[from + i];
            ++i;
        }
    }

    public void set(int[] x, int from, int len) {
        if (x == null || x.length < from + len) {
            PsDebug.warning("argument array too small.");
            return;
        }
        if (this.m_data == null || this.m_data.length != len) {
            this.setSize(len);
        }
        int i = 0;
        while (i < len) {
            this.m_data[i] = x[from + i];
            ++i;
        }
    }

    public void set(int[] x, int len) {
        this.set(x, 0, len);
    }

    public void set(int[] x) {
        if (x == null) {
            PsDebug.warning("missing argument array.");
            return;
        }
        this.set(x, 0, x.length);
    }

    public void set(int x) {
        if (this.m_data == null || this.m_data.length < 1) {
            this.setSize(1);
        }
        this.m_data[0] = x;
    }

    public PiVector() {
    }

    public PiVector(int aSize) {
        this.m_data = new int[aSize];
    }

    public PiVector(int x, int y) {
        this(2);
        this.m_data[0] = x;
        this.m_data[1] = y;
    }

    public PiVector(int x, int y, int z) {
        this(3);
        this.m_data[0] = x;
        this.m_data[1] = y;
        this.m_data[2] = z;
    }

    public PiVector(int x, int y, int z, int w) {
        this(4);
        this.m_data[0] = x;
        this.m_data[1] = y;
        this.m_data[2] = z;
        this.m_data[3] = w;
    }

    public PiVector(int[] x) {
        this();
        this.set(x);
    }

    public void set(int x, int y) {
        if (this.m_data == null || this.m_data.length < 2) {
            this.setSize(2);
        }
        this.m_data[0] = x;
        this.m_data[1] = y;
    }

    public void set(int x, int y, int z) {
        if (this.m_data == null || this.m_data.length < 3) {
            this.setSize(3);
        }
        this.m_data[0] = x;
        this.m_data[1] = y;
        this.m_data[2] = z;
    }

    public void set(int x, int y, int z, int w) {
        if (this.m_data == null || this.m_data.length < 4) {
            this.setSize(4);
        }
        this.m_data[0] = x;
        this.m_data[1] = y;
        this.m_data[2] = z;
        this.m_data[3] = w;
    }

    public void shift(int num) {
        if (num != 1 && num != -1) {
            PsDebug.warning("method allows num==1 or num=-1");
            return;
        }
        int len = this.m_data.length;
        int sav = this.m_data[0];
        int ind = 0;
        int k = 0;
        while (k < len - 1) {
            int prevInd = (ind - num + len) % len;
            this.m_data[ind] = this.m_data[prevInd];
            ind = prevInd;
            ++k;
        }
        this.m_data[num] = sav;
    }

    public static PiVector subNew(PiVector m1, PiVector m2) {
        int size2;
        if (m1 == null || m2 == null) {
            PsDebug.notify("missing argument");
            return null;
        }
        int minSize = m1.getSize();
        if (minSize != (size2 = m2.getSize())) {
            PsDebug.notify("different size of argument vectors");
            minSize = Math.min(minSize, size2);
        }
        PiVector v = new PiVector(minSize);
        v.sub(m1, m2);
        return v;
    }

    public void blend(int a, PiVector v, int b, PiVector w) {
        if (this.m_data == null) {
            this.setSize(v.m_data.length);
        }
        if (this.m_data.length != v.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = a * v.m_data[i] + b * w.m_data[i];
            ++i;
        }
    }

    public void sort(PiVector vecOut) {
        int size = this.getSize();
        if (vecOut == null || vecOut.m_data == null) {
            vecOut = new PiVector(size);
        }
        if (vecOut.getSize() != size) {
            vecOut.setSize(size);
        }
        if (size < 10) {
            int[] data = vecOut.m_data;
            int i = 0;
            while (i < size) {
                data[i] = this.m_data[i];
                ++i;
            }
            int i2 = size - 1;
            while (i2 > 0) {
                int j = 0;
                while (j < i2) {
                    if (data[j] > data[j + 1]) {
                        int d = data[j + 1];
                        data[j + 1] = data[j];
                        data[j] = d;
                    }
                    ++j;
                }
                --i2;
            }
        } else {
            int[] index = new int[size];
            PuMath.heapsort(size, this.m_data, index);
            int i = 0;
            while (i < size) {
                vecOut.m_data[i] = this.m_data[index[i]];
                ++i;
            }
        }
    }

    public void sort() {
        int size = this.getSize();
        if (size < 10) {
            int i = size - 1;
            while (i > 0) {
                int j = 0;
                while (j < i) {
                    if (this.m_data[j] > this.m_data[j + 1]) {
                        int d = this.m_data[j + 1];
                        this.m_data[j + 1] = this.m_data[j];
                        this.m_data[j] = d;
                    }
                    ++j;
                }
                --i;
            }
        } else {
            int[] index = new int[size];
            int[] data = new int[size];
            int i = 0;
            while (i < size) {
                data[i] = this.m_data[i];
                ++i;
            }
            PuMath.heapsort(size, data, index);
            i = 0;
            while (i < size) {
                this.m_data[i] = data[index[i]];
                ++i;
            }
        }
    }

    public void rightMultMatrix(PdMatrix m) {
        if (m.m_iSize != m.m_jSize || m.m_iSize != this.m_data.length) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        int[] tmp = new int[this.m_data.length];
        int j = 0;
        while (j < this.m_data.length) {
            tmp[j] = 0;
            int i = 0;
            while (i < this.m_data.length) {
                int n = j;
                tmp[n] = (int)((double)tmp[n] + (double)this.m_data[i] * m.m_data[i][j]);
                ++i;
            }
            ++j;
        }
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = tmp[i];
            ++i;
        }
    }

    public void rightMultMatrix(PiVector v, PdMatrix m) {
        if (this == v) {
            PsDebug.warning("'this' must be different from argument");
            return;
        }
        if (this.m_data.length != m.m_jSize) {
            this.setSize(m.m_jSize);
        }
        int j = 0;
        while (j < m.m_jSize) {
            this.m_data[j] = 0;
            int i = 0;
            while (i < m.m_iSize) {
                int n = j;
                this.m_data[n] = (int)((double)this.m_data[n] + (double)v.m_data[i] * m.m_data[i][j]);
                ++i;
            }
            ++j;
        }
    }

    public int getIndexOf(int aValue) {
        int k = 0;
        while (k < this.m_data.length) {
            if (this.m_data[k] == aValue) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public int indexOfAbsMax() {
        int index = 0;
        int max = 0;
        int i = 0;
        while (i < this.m_data.length) {
            if (Math.abs(this.m_data[i]) > max) {
                max = this.m_data[i];
                index = i;
            }
            ++i;
        }
        return index;
    }
}

