/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import jv.loader.PgLoader;
import jv.loader.PjImportModel;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.objectGui.GuiStackLayout;
import jv.project.PjProject_IP;

public final class PjImportModel_IP
extends PjProject_IP
implements ActionListener,
ItemListener {
    protected static int NUM_ROWS = 10;
    protected PjImportModel m_import;
    protected String[] m_subDir;
    protected List m_lCategory;
    protected List m_lEntry;
    protected TextField m_tSelectedEntry;
    protected Label m_lCurrDir;
    private static /* synthetic */ Class class$jv$loader$PjImportModel_IP;

    public PjImportModel_IP() {
        if (this.getClass() == (class$jv$loader$PjImportModel_IP != null ? class$jv$loader$PjImportModel_IP : (class$jv$loader$PjImportModel_IP = PjImportModel_IP.class$("jv.loader.PjImportModel_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        PsDebug.notify("called");
        Object source = event.getSource();
        if (source == this.m_lEntry && this.m_lEntry.getItemCount() > 0) {
            PsDebug.notify("number of items = " + this.m_lEntry.getItemCount());
            String sel = this.m_lEntry.getSelectedItem();
            boolean isCategory = false;
            if (this.m_subDir != null) {
                int i = 0;
                while (i < this.m_subDir.length) {
                    if (this.m_subDir[i].equals(sel)) {
                        this.readCategories(this.m_import.getBaseDir() + this.m_import.getCategory() + PjImportModel.DIR_LIST);
                        this.m_import.setCategory(this.m_import.getCategory() + sel + '/');
                        this.selectCategory(sel + '/');
                        isCategory = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!isCategory) {
                ((TextComponent)this.m_tSelectedEntry).setText(sel);
            }
            PsDebug.notify("selected Model = " + this.m_tSelectedEntry.getText());
        } else if (source == this.m_lCategory) {
            PsDebug.notify("select category");
            String cat = this.m_lCategory.getSelectedItem();
            if (cat.equals("..")) {
                this.selectCategory(cat);
            } else {
                this.selectCategory(cat + '/');
            }
        }
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_import = (PjImportModel)parent;
        this.readCategories(this.m_import.getBaseDir() + PjImportModel.DIR_LIST);
        this.selectCategory(this.m_import.getCategory());
    }

    public boolean update(Object anObject) {
        if (this.m_project == null) {
            PsDebug.warning("missing parent, setParent not called");
            return false;
        }
        if (anObject == this.m_project) {
            String impCat = this.m_import.getCategory();
            if (impCat == null) {
                PsDebug.warning("missing model category in project");
                return false;
            }
            String currCat = this.m_lCategory.getSelectedItem();
            if (currCat != null && impCat.startsWith(currCat)) {
                return true;
            }
            this.selectCategory(this.m_import.getCategory());
            return true;
        }
        return super.update(anObject);
    }

    public void actionPerformed(ActionEvent event) {
        PsDebug.notify("called");
        Object source = event.getSource();
        if (source == this.m_lEntry || source == this.m_tSelectedEntry) {
            String sel = this.m_tSelectedEntry.getText();
            if ("".compareTo(sel) != 0) {
                PsDebug.notify("selected = " + sel);
                if (this.m_subDir != null) {
                    int i = 0;
                    while (i < this.m_subDir.length) {
                        if (this.m_subDir[i].equals(sel)) {
                            return;
                        }
                        ++i;
                    }
                }
                String modelName = this.m_import.getBaseDir() + this.m_import.getCategory() + sel;
                this.m_import.setConfirm(PjImportModel.CONFIRM_CLICKED);
                this.m_import.load(modelName);
                return;
            }
            PsDebug.notify("no Model selected");
        }
    }

    private void selectCategory(String category) {
        if (category.equals("..")) {
            String currCat = this.m_import.getCategory();
            if (currCat == null || currCat.length() == 0) {
                return;
            }
            currCat = currCat.substring(0, currCat.length() - 1);
            int endOfUp = currCat.lastIndexOf(47);
            currCat = currCat.substring(0, endOfUp);
            endOfUp = currCat.lastIndexOf(47);
            String currUp = currCat.substring(0, endOfUp + 1);
            this.readCategories(this.m_import.getBaseDir() + currUp + PjImportModel.DIR_LIST);
            this.m_import.setCategory(currCat + '/');
            this.readModels(this.m_import.getBaseDir() + this.m_import.getCategory() + PjImportModel.DIR_LIST);
            return;
        }
        int ind = this.getIndex(this.m_lCategory, category);
        if (ind == -1) {
            PsDebug.warning("category not found in list.");
            return;
        }
        this.m_lCategory.select(ind);
        String currCat = this.m_import.getCategory();
        if (currCat.length() > 0) {
            currCat = currCat.substring(0, currCat.length() - 1);
        }
        int endOfUp = currCat.lastIndexOf(47);
        String currUp = currCat.substring(0, endOfUp + 1);
        this.m_import.setCategory(currUp + category);
        this.readModels(this.m_import.getBaseDir() + this.m_import.getCategory() + PjImportModel.DIR_LIST);
    }

    private int getIndex(List list, String entry) {
        String[] entries = list.getItems();
        if (entries == null || entries.length == 0 || entry == null) {
            return -1;
        }
        String base = entry.endsWith("/") ? entry.substring(0, entry.length() - 1) : entry;
        int i = 0;
        while (i < entries.length) {
            if (entries[i] != null && base.equals(entries[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public String getSelection() {
        return this.m_tSelectedEntry.getText();
    }

    private void readCategories(String modelName) {
        try {
            if (!PgLoader.readDirs(this.m_lCategory, modelName)) {
                return;
            }
        }
        catch (IOException e1) {
            PsDebug.warning("failed reading model list\n\t file = " + modelName);
        }
    }

    public void init() {
        super.init();
        this.addTitle(PsConfig.getMessage("ImportModelsOfJavaView"));
        Panel pBody = new Panel();
        pBody.setLayout(new GuiStackLayout(0));
        Panel pLeft = new Panel();
        pLeft.setLayout(new BorderLayout());
        pLeft.add("North", new Label(PsConfig.getMessage("Category")));
        this.m_lCategory = new List(NUM_ROWS, false);
        this.m_lCategory.addItemListener(this);
        pLeft.add("Center", this.m_lCategory);
        Panel pBottom = new Panel();
        pBottom.setLayout(new GridLayout(2, 1));
        pBottom.add(new Label(PsConfig.getMessage("Directory") + ": ", 0));
        pBottom.add(new Label(PsConfig.getMessage("Selection") + ": ", 0));
        pLeft.add("South", pBottom);
        pBody.add("Left Fill", pLeft);
        Panel pRight = new Panel();
        pRight.setLayout(new BorderLayout());
        pRight.add("North", new Label(PsConfig.getMessage("Model")));
        this.m_lEntry = new List(NUM_ROWS, false);
        this.m_lEntry.addActionListener(this);
        this.m_lEntry.addItemListener(this);
        pRight.add("Center", this.m_lEntry);
        Panel pBottom2 = new Panel();
        pBottom2.setLayout(new GridLayout(2, 1));
        this.m_lCurrDir = new Label();
        pBottom2.add(this.m_lCurrDir);
        this.m_tSelectedEntry = new TextField(25);
        this.m_tSelectedEntry.addActionListener(this);
        pBottom2.add(this.m_tSelectedEntry);
        pRight.add("South", pBottom2);
        pBody.add("Right Fill*2", pRight);
        this.add(pBody);
    }

    private void readModels(String modelName) {
        this.m_lCurrDir.setText(this.m_import.getBaseDir() + this.m_import.getCategory());
        try {
            if (!PgLoader.readAll(this.m_lEntry, modelName)) {
                return;
            }
            this.m_subDir = PgLoader.readDirs(modelName);
        }
        catch (IOException e1) {
            PsDebug.warning("failed reading model list\n\t file = " + modelName);
        }
    }
}

