/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsStackLayout;
import jv.object.PsUpdateIf;
import jv.object.PsUtil;

public class PsDialog
extends Dialog
implements PsUpdateIf,
ActionListener,
ItemListener,
WindowListener {
    protected PsUpdateIf m_parent = null;
    public static final int BUTTON_CANCEL = 1;
    public static final int BUTTON_HIDE = 2;
    public static final int BUTTON_OK = 4;
    public static final int BUTTON_RESET = 8;
    public static final int BUTTON_CLOSE = 16;
    public static final int BUTTON_SAVE = 32;
    protected int m_action = 1;
    protected Button m_bCancel;
    protected Button m_bHide;
    protected Button m_bOk;
    protected Button m_bReset;
    protected Button m_bClose;
    protected Button m_bSave;
    protected Label m_lHeader;

    public Label setHeader(String header) {
        if (this.m_lHeader == null) {
            this.m_lHeader = new Label(header, 0);
            this.m_lHeader.setFont(PsConfig.getFont(3));
        } else {
            this.m_lHeader.setText(header);
        }
        return this.m_lHeader;
    }

    public int getUserAction() {
        return this.m_action;
    }

    public void reset() {
        if (this.m_parent != null) {
            this.m_parent.update(this.m_parent);
        }
    }

    public void setParent(PsUpdateIf object) {
        this.m_parent = object;
    }

    public void itemStateChanged(ItemEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public PsDialog(Frame frame, String name, boolean modal) {
        super(frame, name, modal);
        this.addWindowListener(this);
        this.setLayout(new PsStackLayout(5));
        if (this.instanceOf("PsDialog")) {
            this.init();
        }
    }

    public void windowClosing(WindowEvent event) {
        this.dispose();
    }

    public PsDialog(Frame frame, boolean modal) {
        this(frame, null, modal);
    }

    public PsUpdateIf getFather() {
        return this.m_parent;
    }

    public boolean update(Object event) {
        if (event != null) {
            PsDebug.notify("could not handle event = " + event.toString() + "\n\tmissing implementation of update(Object)");
            return false;
        }
        if (this.m_parent != null) {
            PsDebug.notify("update parent");
            return this.m_parent.update(this);
        }
        return false;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_bOk) {
            PsDebug.notify("ok");
            this.m_action = 4;
            this.dispose();
        } else if (source == this.m_bCancel) {
            PsDebug.notify("cancel");
            this.m_action = 1;
            this.dispose();
        } else if (source == this.m_bReset) {
            this.m_action = 8;
            PsDebug.notify("reset");
            this.reset();
        } else if (source == this.m_bHide) {
            this.m_action = 2;
            ((Component)this).setVisible(false);
        } else if (source == this.m_bClose) {
            this.m_action = 16;
            this.dispose();
        } else if (source == this.m_bSave) {
            this.m_action = 32;
            this.dispose();
        }
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosed(WindowEvent event) {
        if (this.m_parent != null) {
            this.m_action = 16;
            this.m_parent.update(this);
        }
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public final boolean instanceOf(String aClassName) {
        String fullClassName = this.getClass().getName();
        return fullClassName.endsWith(aClassName);
    }

    public Panel getBottomButtons(int flag) {
        Panel pBottomButtons = new Panel();
        pBottomButtons.setLayout(new FlowLayout(1));
        if (PsUtil.hasBits(flag, 4)) {
            this.m_bOk = new Button(PsConfig.getMessage("bOk"));
            this.m_bOk.addActionListener(this);
            pBottomButtons.add(this.m_bOk);
        }
        if (PsUtil.hasBits(flag, 1)) {
            this.m_bCancel = new Button(PsConfig.getMessage("bCancel"));
            this.m_bCancel.addActionListener(this);
            pBottomButtons.add(this.m_bCancel);
        }
        if (PsUtil.hasBits(flag, 8)) {
            this.m_bReset = new Button(PsConfig.getMessage("bReset"));
            this.m_bReset.addActionListener(this);
            pBottomButtons.add(this.m_bReset);
        }
        if (PsUtil.hasBits(flag, 2)) {
            this.m_bHide = new Button(PsConfig.getMessage("bHide"));
            this.m_bHide.addActionListener(this);
            pBottomButtons.add(this.m_bHide);
        }
        if (PsUtil.hasBits(flag, 16)) {
            this.m_bClose = new Button(PsConfig.getMessage("bClose"));
            this.m_bClose.addActionListener(this);
            pBottomButtons.add(this.m_bClose);
        }
        if (PsUtil.hasBits(flag, 32)) {
            this.m_bSave = new Button(PsConfig.getMessage("Save"));
            this.m_bSave.addActionListener(this);
            this.m_bSave.setEnabled(PsConfig.isApplication());
            pBottomButtons.add(this.m_bSave);
        }
        return pBottomButtons;
    }

    public void init() {
        ((Component)this).setFont(PsConfig.getFont(0));
    }

    public void windowIconified(WindowEvent event) {
    }

    public void setLocation(int x, int y) {
        if (x < 0 || x > 635) {
            x = 10;
        }
        if (y < 0 || y > 475) {
            y = 10;
        }
        super.setLocation(x, y);
    }
}

