/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import jv.loader.PgLoader;
import jv.loader.PvDisplayOption;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUtil;
import jv.project.PgGeometry;
import jv.project.PgJvxSrc;
import jv.project.PjProject;

public class PjImportModel
extends PjProject {
    protected PjProject m_parentProject;
    protected PgGeometry[] m_geomList;
    protected static final int m_numModels = 15;
    public static int FULL_INFO_PANEL = 0;
    public static int SMALL_INFO_PANEL = 1;
    protected int m_infoPanelType = FULL_INFO_PANEL;
    public static String DIR_LIST = "_modelList.xml";
    protected String m_defBaseDir = "models/";
    protected String m_baseDir;
    protected String m_defCategory = "byu/";
    protected String m_category;
    protected String m_defFileName = "Brezel_96.byu";
    protected String m_fileName;
    protected String m_fullFileName = "models/byu/Brezel_96.byu";
    public static int CONFIRM_OK = 0;
    public static int CONFIRM_CANCEL = 1;
    public static int CONFIRM_CLICKED = 2;
    protected int m_confirm;
    private static /* synthetic */ Class class$jv$loader$PjImportModel;

    public void setFileName(String fullFileName) {
        this.m_fullFileName = fullFileName;
    }

    public String getBaseDir() {
        return this.m_baseDir;
    }

    public void setTypeOfInfoPanel(int infoType) {
        this.m_infoPanelType = infoType;
    }

    public PsPanel getInfoPanel() {
        this.setConfirm(CONFIRM_CANCEL);
        if (this.hasInspector("Info")) {
            return super.getInfoPanel();
        }
        if (this.m_infoPanelType == FULL_INFO_PANEL) {
            return super.getInfoPanel();
        }
        if (this.m_infoPanelType == SMALL_INFO_PANEL) {
            PsPanel infoPanel = (PsPanel)PsUtil.newInstance(this.getClass(), "_InfoBox");
            if (infoPanel == null) {
                return null;
            }
            this.addInspector("Info", infoPanel);
            return infoPanel;
        }
        PsDebug.warning("unknown panel type.");
        return null;
    }

    public PjImportModel() {
        super("Import Model");
        this.m_geomList = new PgGeometry[1];
        this.m_geomList[0] = new PgJvxSrc();
        this.m_geomList[0].setName("Import Geometry");
        if (this.getClass() == (class$jv$loader$PjImportModel != null ? class$jv$loader$PjImportModel : (class$jv$loader$PjImportModel = PjImportModel.class$("jv.loader.PjImportModel")))) {
            this.init();
        }
    }

    public int getConfirm() {
        return this.m_confirm;
    }

    protected void setConfirm(int choice) {
        this.m_confirm = choice;
        if (this.m_parentProject != null && this.m_geomList != null && this.m_geomList.length > 0) {
            if (this.m_confirm == CONFIRM_CANCEL) {
                int i = 0;
                while (i < this.m_geomList.length) {
                    this.m_parentProject.removeGeometry(this.m_geomList[i]);
                    ++i;
                }
            } else if (this.m_confirm == CONFIRM_OK) {
                this.m_parentProject.selectGeometry(this.m_geomList[0]);
            }
        }
    }

    public void setBase(String baseDir) {
        this.m_baseDir = baseDir;
    }

    public void setParentProject(PjProject project) {
        this.m_parentProject = project;
        if (this.m_parentProject == null) {
            return;
        }
        int i = 0;
        while (i < this.m_geomList.length) {
            this.m_parentProject.addGeometry(this.m_geomList[i]);
            ++i;
        }
    }

    public boolean load(String fullFileName) {
        if (fullFileName == null) {
            PsDebug.warning("missing fullFileName");
            return false;
        }
        PsDebug.notify("loading = " + fullFileName);
        PgGeometry[] geomArr = new PgGeometry[this.m_geomList.length];
        int i = 0;
        while (i < this.m_geomList.length) {
            geomArr[i] = this.m_geomList[i];
            ++i;
        }
        if ((geomArr = PgLoader.load(geomArr, fullFileName)) == null || geomArr.length == 0 || geomArr[0] == null) {
            PsDebug.warning("loading failed");
            return false;
        }
        PvDisplayOption dispOption = PgLoader.getDisplayOption();
        if (dispOption != null) {
            if (this.m_display != null) {
                dispOption.configure(this.m_display);
            } else if (this.m_parentProject.getDisplay() != null) {
                dispOption.configure(this.m_parentProject.getDisplay());
            }
        }
        this.m_fullFileName = fullFileName;
        int i2 = Math.min(geomArr.length, this.m_geomList.length);
        while (i2 < this.m_geomList.length) {
            if (this.m_geomList[i2] != null) {
                this.removeGeometry(this.m_geomList[i2]);
                if (this.m_parentProject != null) {
                    this.m_parentProject.removeGeometry(this.m_geomList[i2]);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < Math.min(geomArr.length, this.m_geomList.length)) {
            if (geomArr[i2] != this.m_geomList[i2]) {
                this.removeGeometry(this.m_geomList[i2]);
                if (this.m_parentProject != null) {
                    this.m_parentProject.removeGeometry(this.m_geomList[i2]);
                    if (geomArr[i2] != null) {
                        this.m_parentProject.addGeometry(geomArr[i2]);
                    }
                }
                this.addGeometry(geomArr[i2]);
            } else {
                this.addGeometry(geomArr[i2]);
                geomArr[i2].update(geomArr[i2]);
            }
            ++i2;
        }
        i2 = Math.min(geomArr.length, this.m_geomList.length);
        while (i2 < geomArr.length) {
            if (this.m_parentProject != null && geomArr[i2] != null) {
                this.m_parentProject.addGeometry(geomArr[i2]);
            }
            this.addGeometry(geomArr[i2], false);
            ++i2;
        }
        if (this.m_display != null) {
            this.m_display.update(this.m_display);
        }
        this.m_geomList = geomArr;
        if (this.m_geomList[0] != null) {
            this.selectGeometry(this.m_geomList[0]);
            if (this.m_parentProject != null) {
                this.m_parentProject.selectGeometry(this.m_geomList[0]);
                if (this.m_parentProject.isEnabledAutoFit()) {
                    this.m_parentProject.fitDisplays();
                }
            }
        }
        if (this.isEnabledAutoFit()) {
            this.fitDisplays();
        }
        this.update(this);
        return true;
    }

    public String getCategory() {
        return this.m_category;
    }

    public void setCategory(String category) {
        this.m_category = category;
    }

    public void start() {
        if (this.m_fullFileName != null) {
            PsDebug.notify("file field = " + this.m_fullFileName);
            this.load(this.m_fullFileName);
        }
        super.start();
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void init() {
        super.init();
        this.m_baseDir = PsConfig.getCodeBase();
        if (!this.m_baseDir.endsWith("/")) {
            this.m_baseDir = this.m_baseDir + PsConfig.getFileSeparator();
        }
        this.m_baseDir = this.m_baseDir + this.m_defBaseDir;
        this.m_category = this.m_defCategory;
        this.m_fileName = this.m_defFileName;
        this.m_geomList[0].init();
        this.m_confirm = CONFIRM_OK;
        this.addGeometry(this.m_geomList[0]);
        this.selectGeometry(this.m_geomList[0]);
    }

    public String getFileName() {
        return this.m_fullFileName;
    }
}

