/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.util.Date;
import java.util.Hashtable;
import jv.object.PsConfig;

public class PSGr
extends Graphics {
    private static final boolean NOTIFY = false;
    private static float PS_ZOOM = 1.0f;
    public static final int CLONE = 49;
    protected static final int XOFFSET = 10;
    protected static final int YOFFSET = 10;
    protected static final int PAGEWIDTH = 592;
    protected static final int PAGEHEIGHT = 772;
    protected int[] m_bndBox;
    protected static final char[] hd = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static final int charsPerRow = 72;
    protected MyStringBuffer os = new MyStringBuffer();
    protected Color clr = Color.black;
    protected Color backClr = Color.white;
    protected Font font = new Font("Helvetica", 0, 12);
    protected Rectangle clippingRect = new Rectangle(0, 0, 592, 772);
    protected Graphics g;
    protected String m_geomName;
    protected double m_scale = 1.0;

    public Rectangle getClipBounds() {
        return this.clippingRect;
    }

    public void drawLine(int x1Int, int y1Int, int x2Int, int y2Int) {
        float x1 = (float)x1Int / PS_ZOOM;
        float y1 = (float)y1Int / PS_ZOOM;
        float x2 = (float)x2Int / PS_ZOOM;
        float y2 = (float)y2Int / PS_ZOOM;
        y1 = this.transformY(y1);
        y2 = this.transformY(y2);
        this.os.print(x1 + " " + y1 + " m " + x2 + " " + y2 + " l s\n");
    }

    private void emitBoundingBox() {
        if (this.m_bndBox == null) {
            return;
        }
        this.os.println("%%BoundingBox: " + (this.m_bndBox[0] + 10) + " " + (this.m_bndBox[1] + 10) + " " + (this.m_bndBox[2] + 10) + " " + (this.m_bndBox[3] + 10));
    }

    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        Color c = this.getColor();
        Color brighter = c.brighter();
        Color darker = c.darker();
        this.setColor(raised ? brighter : darker);
        this.drawLine(x, y, x, y + height);
        this.drawLine(x + 1000, y, x + width - 1000, y);
        this.setColor(raised ? darker : brighter);
        this.drawLine(x + 1000, y + height, x + width, y + height);
        this.drawLine(x + width, y, x + width, y + height);
        this.setColor(c);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.doArc(x, y, width, height, 0, 360, true);
    }

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this.drawString(new String(data, offset, length), x, y);
    }

    public String toString() {
        return this.os.toString();
    }

    public Graphics create() {
        PSGr psgr = new PSGr(this.g, 49);
        psgr.font = this.font;
        psgr.clippingRect = this.clippingRect;
        psgr.clr = this.clr;
        return psgr;
    }

    public Graphics create(int x, int y, int width, int height) {
        Graphics g = this.create();
        g.translate(x, y);
        g.setClip(0, 0, width, height);
        return g;
    }

    public void translate(int x, int y) {
        this.os.print(x + " " + y + " t\n");
    }

    public void gsave() {
        this.os.println("gsave");
    }

    protected void emitProlog() {
        this.os.println("%!PS-Adobe-2.0 JavaView PostScript Export");
        if (this.m_geomName != null) {
            this.os.println("%%Title:   " + this.m_geomName);
        } else {
            this.os.println("%%Title:   JavaView Output");
        }
        this.os.println("%%Date:    " + new Date().toString());
        this.os.println("%%Creator: JavaView v." + PsConfig.getVersion());
        this.os.println("%%JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage());
        this.os.println("%%by " + PsConfig.getAuthors());
        this.os.println("%%PostScript filter based on: PSGr Java PostScript Context");
        this.os.println("%%PSGr is (C) 1996 Ernest Friedman-Hill and Sandia National Labs");
        this.emitBoundingBox();
        this.os.println("%%EndComments");
        this.os.println("%%BeginProlog");
        this.os.println(String.valueOf(10) + " " + String.valueOf(10) + " translate");
        this.os.println("%%Modify scaling when including in TeX:");
        this.os.println(String.valueOf((float)(1.0 / this.m_scale)) + " " + String.valueOf((float)(1.0 / this.m_scale)) + " scale");
        this.setFont(this.font);
        this.os.println("/c {setrgbcolor} bind def");
        this.os.println("/e {eofill} bind def");
        this.os.println("/g {gsave} bind def");
        this.os.println("/l {lineto} bind def");
        this.os.println("/m {moveto} bind def");
        this.os.println("/s {stroke} bind def");
        this.os.println("/t {translate} bind def");
        this.os.println("/w {show} bind def");
        this.os.println("/ac {arc closepath eofill grestore} bind def");
        this.os.println("/as {arc stroke grestore} bind def");
        this.os.println("%%EndProlog");
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font f) {
        if (f != null) {
            String psName;
            this.font = f;
            String javaName = this.font.getName();
            int javaStyle = this.font.getStyle();
            if (javaName.equals("Symbol")) {
                psName = "Symbol";
            } else if (javaName.startsWith("Times")) {
                psName = "Times-";
                switch (javaStyle) {
                    case 0: {
                        psName = psName + "Roman";
                        break;
                    }
                    case 1: {
                        psName = psName + "Bold";
                        break;
                    }
                    case 2: {
                        psName = psName + "Italic";
                        break;
                    }
                    case 3: {
                        psName = psName + "BoldItalic";
                        break;
                    }
                }
            } else if (javaName.equals("Helvetica") || javaName.equals("Courier")) {
                psName = javaName;
                switch (javaStyle) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        psName = psName + "-Bold";
                        break;
                    }
                    case 2: {
                        psName = psName + "-Oblique";
                        break;
                    }
                    case 3: {
                        psName = psName + "BoldOblique";
                        break;
                    }
                }
            } else {
                psName = "Courier";
            }
            this.os.print("/" + psName + " findfont ");
            this.os.println(this.font.getSize() + " scalefont setfont");
        }
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public FontMetrics getFontMetrics(Font f) {
        return this.g.getFontMetrics(f);
    }

    public void clearRect(int x, int y, int width, int height) {
        this.os.print("g ");
        Color c = this.getColor();
        this.setColor(this.backClr);
        this.doRect(x, y, width, height, true);
        this.setColor(c);
        this.os.print("grestore\n");
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        throw new RuntimeException("copyArea not supported");
    }

    private void doRoundRect(int xInt, int yInt, int widthInt, int heightInt, int arcWidthInt, int arcHeightInt, boolean fill) {
        float x = (float)xInt / PS_ZOOM;
        float y = (float)yInt / PS_ZOOM;
        float width = (float)widthInt / PS_ZOOM;
        float height = (float)heightInt / PS_ZOOM;
        float arcHeight = (float)arcHeightInt / PS_ZOOM;
        y = this.transformY(y);
        this.os.print(x + arcHeight);
        this.os.print(" " + y + " m\n");
        this.os.print(x + width);
        this.os.print(" " + y + " ");
        this.os.print(x + width);
        this.os.print(" ");
        this.os.print(y - height);
        this.os.print(" " + arcHeight + " arcto\n");
        this.os.print("4 {pop} repeat\n");
        this.os.print(x + width);
        this.os.print(" ");
        this.os.print(y - height);
        this.os.print(" " + x + " ");
        this.os.print(y - height);
        this.os.print(" " + arcHeight + " arcto\n");
        this.os.print("4 {pop} repeat\n");
        this.os.print(x);
        this.os.print(" ");
        this.os.print(y - height);
        this.os.print(" " + x + " " + y + " " + arcHeight + " arcto\n");
        this.os.print("4 {pop} repeat\n");
        this.os.print(x + " " + y + " ");
        this.os.print(x + width);
        this.os.print(" " + y + " ");
        this.os.print(arcHeight + " arcto\n");
        this.os.print("4 {pop} repeat\n");
        if (fill) {
            this.os.print("e\n");
        } else {
            this.os.print("s\n");
        }
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.doRoundRect(x, y, width, height, arcWidth, arcHeight, false);
    }

    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        Color c = this.getColor();
        Color brighter = c.brighter();
        Color darker = c.darker();
        if (!raised) {
            this.setColor(darker);
        }
        this.fillRect(x + 1000, y + 1000, width - 2000, height - 2000);
        this.setColor(raised ? brighter : darker);
        this.drawLine(x, y, x, y + height - 1000);
        this.drawLine(x + 1000, y, x + width - 2000, y);
        this.setColor(raised ? darker : brighter);
        this.drawLine(x + 1000, y + height - 1000, x + width - 1000, y + height - 1000);
        this.drawLine(x + width - 1000, y, x + width - 1000, y + height - 1000);
        this.setColor(c);
    }

    public void dispose() {
        this.os.flush();
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.doRoundRect(x, y, width, height, arcWidth, arcHeight, true);
    }

    protected void doRect(int xInt, int yInt, int widthInt, int heightInt, boolean fill) {
        float x = (float)xInt / PS_ZOOM;
        float y = (float)yInt / PS_ZOOM;
        float width = (float)widthInt / PS_ZOOM;
        float height = (float)heightInt / PS_ZOOM;
        y = this.transformY(y);
        this.os.print(x + " " + y + " m " + (x + width) + " " + y + " l ");
        this.os.print(x + width + " " + (y - height) + " l ");
        this.os.print(x + " " + (y - height) + " l " + x + " " + y + " l ");
        if (fill) {
            this.os.print("e\n");
        } else {
            this.os.print("s\n");
        }
    }

    public void drawRect(int x, int y, int width, int height) {
        this.doRect(x, y, width, height, false);
    }

    public void setXORMode(Color c1) {
        System.err.println("Warning: PSGr does not support XOR mode");
    }

    private void doArc(int xInt, int yInt, int widthInt, int heightInt, int startAngle, int arcAngle, boolean fill) {
        if (widthInt < 1 || heightInt < 1) {
            return;
        }
        float x = (float)xInt / PS_ZOOM;
        float y = (float)yInt / PS_ZOOM;
        float width = (float)widthInt / PS_ZOOM;
        float height = (float)heightInt / PS_ZOOM;
        y = this.transformY(y);
        this.os.print("g ");
        float cx = x + width / 2.0f;
        float cy = y - height / 2.0f;
        this.os.print(cx);
        this.os.print(" ");
        this.os.print(cy);
        this.os.print(" t ");
        float yscale = height / width;
        this.os.print(1.0);
        this.os.print(" ");
        this.os.print(yscale);
        this.os.print(" s ");
        if (fill) {
            this.os.print("0 0 m ");
        }
        float endAngle = startAngle + arcAngle;
        this.os.print("0 0 ");
        this.os.print((double)width / 2.0);
        this.os.print(" ");
        this.os.print(startAngle);
        this.os.print(" ");
        this.os.print(endAngle);
        if (fill) {
            this.os.print(" ac\n");
        } else {
            this.os.print(" as\n");
        }
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.doArc(x, y, width, height, startAngle, arcAngle, false);
    }

    public void drawString(String str, int x, int y) {
        this.os.print((float)x / PS_ZOOM + " ");
        this.os.print(this.transformY((float)y / PS_ZOOM));
        this.os.print(" m (" + str + ") w s\n");
    }

    public void emitThis(String s) {
        this.os.println(s);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.doPoly(xPoints, yPoints, nPoints, false);
    }

    public void drawPolygon(Polygon p) {
        this.doPoly(p.xpoints, p.ypoints, p.npoints, false);
    }

    public boolean doImage(Image img, int xInt, int yInt, int widthInt, int heightInt, ImageObserver observer, Color bgcolor) {
        float x = (float)xInt / PS_ZOOM;
        float y = (float)yInt / PS_ZOOM;
        float width = (float)widthInt / PS_ZOOM;
        float height = (float)heightInt / PS_ZOOM;
        this.os.println("%doImage");
        y = this.transformY(y);
        PixelConsumer pc = new PixelConsumer(img);
        this.os.println("g");
        this.os.println("% build a temporary dictionary");
        this.os.println("20 dict begin");
        this.emitColorImageProlog(pc.xdim);
        this.os.println("% lower left corner");
        this.os.print(x);
        this.os.print(" ");
        this.os.print(y);
        this.os.println(" translate");
        if (height == 0.0f || width == 0.0f) {
            height = pc.ydim;
            width = pc.xdim;
        }
        this.os.println("% size of image");
        this.os.print(width);
        this.os.print(" ");
        this.os.print(height);
        this.os.println(" scale");
        this.os.print(pc.xdim);
        this.os.print(" ");
        this.os.print(pc.ydim);
        this.os.println(" 8");
        this.os.print("[");
        this.os.print(pc.xdim);
        this.os.print(" 0 0 -");
        this.os.print(pc.ydim);
        this.os.print(" 0 ");
        this.os.print(0);
        this.os.println("]");
        this.os.println("{currentfile pix readhexstring pop}");
        this.os.println("false 3 colorimage");
        this.os.println("");
        char[] sb = new char[73];
        int i = 0;
        while (i < pc.ydim) {
            int j;
            int offset = 0;
            if (bgcolor == null) {
                j = 0;
                while (j < pc.xdim) {
                    int n = pc.pix[j][i];
                    int alpha = (n & 0xFF000000) >> 24;
                    if (alpha == 0) {
                        int k = 0;
                        while (k < 6) {
                            sb[offset++] = hd[15];
                            ++k;
                        }
                    } else {
                        sb[offset++] = hd[(n & 0xF00000) >> 20];
                        sb[offset++] = hd[(n & 0xF0000) >> 16];
                        sb[offset++] = hd[(n & 0xF000) >> 12];
                        sb[offset++] = hd[(n & 0xF00) >> 8];
                        sb[offset++] = hd[(n & 0xF0) >> 4];
                        sb[offset++] = hd[n & 0xF];
                    }
                    if (offset >= 72) {
                        String s = String.copyValueOf(sb, 0, offset);
                        this.os.println(s);
                        offset = 0;
                    }
                    ++j;
                }
            } else {
                this.os.println("%FalseColor");
                j = 0;
                while (j < pc.xdim) {
                    int bg = bgcolor.getGreen() << 16 + bgcolor.getBlue() << 8 + bgcolor.getRed();
                    int fg = this.clr.getGreen() << 16 + this.clr.getBlue() << 8 + this.clr.getRed();
                    int n = pc.pix[j][i] == 1 ? fg : bg;
                    sb[offset++] = hd[n & 0xF0];
                    sb[offset++] = hd[n & 0xF];
                    sb[offset++] = hd[n & 0xF000];
                    sb[offset++] = hd[n & 0xF00];
                    sb[offset++] = hd[n & 0xF00000];
                    sb[offset++] = hd[n & 0xF0000];
                    if (offset >= 72) {
                        String s = String.copyValueOf(sb, 0, offset);
                        this.os.println(s);
                        offset = 0;
                    }
                    ++j;
                }
            }
            if (offset != 0) {
                String s = String.copyValueOf(sb, 0, offset);
                this.os.println(s);
            }
            ++i;
        }
        this.os.println("");
        this.os.println("end");
        this.os.println("grestore");
        return true;
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        this.os.println("%drawImage-1");
        return this.doImage(img, x, y, 0, 0, observer, null);
    }

    public void setClip(int xInt, int yInt, int widthInt, int heightInt) {
        int x = (int)((float)xInt / PS_ZOOM);
        int y = (int)((float)yInt / PS_ZOOM);
        int width = (int)((float)widthInt / PS_ZOOM);
        int height = (int)((float)heightInt / PS_ZOOM);
        y = this.transformY(y);
        this.clippingRect = new Rectangle(x, y, width, height);
        this.os.print("initclip ");
        this.os.print(x + " " + y + " m ");
        this.os.print(x + width + " " + y + " l ");
        this.os.print(x + width + " " + (y - height) + " l ");
        this.os.print(x + " " + (y - height) + " l ");
        this.os.print("closepath eoclip newpath\n");
    }

    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.drawString(new String(data, offset, length), x, y);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        this.os.println("%drawImage-2");
        return this.doImage(img, x, y, width, height, observer, null);
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        this.os.println("%drawImage-3");
        return this.doImage(img, x, y, 0, 0, observer, bgcolor);
    }

    public void boundingBox(int xMin, int yMin, int xMax, int yMax) {
        int[] nArray = new int[4];
        nArray[0] = xMin;
        nArray[2] = xMax;
        nArray[3] = yMax - yMin;
        this.m_bndBox = nArray;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        this.os.println("%drawImage-4");
        return this.doImage(img, x, y, width, height, observer, bgcolor);
    }

    protected void emitColorImageProlog(int xdim) {
        this.os.println("% Color picture stuff, lifted from XV's PS files");
        this.os.println("% define string to hold a scanline's worth of data");
        this.os.print("/pix ");
        this.os.print(xdim * 3);
        this.os.println(" string def");
        this.os.println("% define space for color conversions");
        this.os.print("/grays ");
        this.os.print(xdim);
        this.os.println(" string def  % space for gray scale line");
        this.os.println("/npixls 0 def");
        this.os.println("/rgbindx 0 def");
        this.os.println("% define 'colorimage' if it isn't defined");
        this.os.println("%   ('colortogray' and 'mergeprocs' come from xwd2ps");
        this.os.println("%     via xgrab)");
        this.os.println("/colorimage where   % do we know about 'colorimage'?");
        this.os.println("{ pop }           % yes: pop off the 'dict' returned");
        this.os.println("{                 % no:  define one");
        this.os.println("/colortogray {  % define an RGB->I function");
        this.os.println("/rgbdata exch store    % call input 'rgbdata'");
        this.os.println("rgbdata length 3 idiv");
        this.os.println("/npixls exch store");
        this.os.println("/rgbindx 0 store");
        this.os.println("0 1 npixls 1 sub {");
        this.os.println("grays exch");
        this.os.println("rgbdata rgbindx       get 20 mul    % Red");
        this.os.println("rgbdata rgbindx 1 add get 32 mul    % Green");
        this.os.println("rgbdata rgbindx 2 add get 12 mul    % Blue");
        this.os.println("add add 64 idiv      % I = .5G + .31R + .18B");
        this.os.println("put");
        this.os.println("/rgbindx rgbindx 3 add store");
        this.os.println("} for");
        this.os.println("grays 0 npixls getinterval");
        this.os.println("} bind def");
        this.os.println("");
        this.os.println("% Utility procedure for colorimage operator.");
        this.os.println("% This procedure takes two procedures off the");
        this.os.println("% stack and merges them into a single procedure.");
        this.os.println("");
        this.os.println("/mergeprocs { % def");
        this.os.println("dup length");
        this.os.println("3 -1 roll");
        this.os.println("dup");
        this.os.println("length");
        this.os.println("dup");
        this.os.println("5 1 roll");
        this.os.println("3 -1 roll");
        this.os.println("add");
        this.os.println("array cvx");
        this.os.println("dup");
        this.os.println("3 -1 roll");
        this.os.println("0 exch");
        this.os.println("putinterval");
        this.os.println("dup");
        this.os.println("4 2 roll");
        this.os.println("putinterval");
        this.os.println("} bind def");
        this.os.println("");
        this.os.println("/colorimage { % def");
        this.os.println("pop pop     % remove 'false 3' operands");
        this.os.println("{colortogray} mergeprocs");
        this.os.println("image");
        this.os.println("} bind def");
        this.os.println("} ifelse          % end of 'false' case");
    }

    public Shape getClip() {
        System.err.println("Warning: PSGr does not support XOR mode");
        return null;
    }

    public void setClip(Shape shape) {
        System.err.println("Warning: PSGr does not support XOR mode");
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, int x1, int x2, int x3, int x4, ImageObserver observer) {
        System.err.println("Warning: PSGr does not support XOR mode");
        return true;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, int x1, int x2, int x3, int x4, Color col, ImageObserver observer) {
        System.err.println("Warning: PSGr does not support XOR mode");
        return true;
    }

    public void scale(float sx, float sy) {
        this.os.print(sx + " " + sy + " s\n");
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.doPoly(xPoints, yPoints, nPoints, true);
    }

    public void fillPolygon(Polygon p) {
        this.doPoly(p.xpoints, p.ypoints, p.npoints, true);
    }

    public void grestore() {
        this.os.println("grestore");
    }

    public void setZoom(float zoom) {
        PS_ZOOM = zoom;
    }

    public void fillRect(int x, int y, int width, int height) {
        this.doRect(x, y, width, height, true);
    }

    public void clipRect(int x, int y, int width, int height) {
        System.err.println("Warning: PSGr does not support XOR mode");
        this.setClip(x, y, width, height);
    }

    public void setBackground(Color c) {
        this.backClr = c;
    }

    public void drawOval(int x, int y, int width, int height) {
        this.doArc(x, y, width, height, 0, 360, false);
    }

    public PSGr(Graphics g, String name, int width, int height) {
        this.g = g;
        this.m_geomName = name;
        double xScale = 1.0;
        if (width > 592) {
            xScale = (float)width / 592.0f;
        }
        double yScale = 1.0;
        if (height > 772) {
            yScale = (float)height / 772.0f;
        }
        this.m_scale = Math.max(xScale, yScale);
        this.boundingBox(0, 0, (int)((double)width / this.m_scale), (int)((double)height / this.m_scale));
        this.emitProlog();
    }

    public PSGr(Graphics g, int what) {
        this.g = g;
        if (what != 49) {
            this.emitProlog();
        }
    }

    public Color getColor() {
        return this.clr;
    }

    public void setColor(Color c) {
        if (c != null) {
            this.clr = c;
        }
        this.os.print((float)((double)this.clr.getRed() / 255.0));
        this.os.print(" ");
        this.os.print((float)((double)this.clr.getGreen() / 255.0));
        this.os.print(" ");
        this.os.print((float)((double)this.clr.getBlue() / 255.0));
        this.os.print(" c\n");
    }

    public void setPaintMode() {
    }

    private void doPoly(int[] xPoints, int[] yPoints, int nPoints, boolean fill) {
        if (nPoints < 2) {
            return;
        }
        this.os.print((float)xPoints[0] / PS_ZOOM + " " + this.transformY((float)yPoints[0] / PS_ZOOM) + " m ");
        int i = 1;
        while (i < nPoints) {
            this.os.print((float)xPoints[i] / PS_ZOOM + " " + this.transformY((float)yPoints[i] / PS_ZOOM) + " l ");
            ++i;
        }
        if (fill) {
            this.os.println("e");
        } else {
            this.os.print((float)xPoints[0] / PS_ZOOM + " " + this.transformY((float)yPoints[0] / PS_ZOOM) + " l ");
            this.os.println("s");
        }
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.doArc(x, y, width, height, startAngle, arcAngle, true);
    }

    public void finalize() {
        this.dispose();
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        System.err.println("Warning: PSGr does not support XOR mode");
        this.drawPolygon(xPoints, yPoints, nPoints);
    }

    protected int transformY(int y) {
        return (int)((double)this.m_bndBox[3] * this.m_scale) - y;
    }

    protected float transformY(float y) {
        return (float)((double)this.m_bndBox[3] * this.m_scale - (double)y);
    }

    class MyStringBuffer {
        protected StringBuffer m_buffer;

        public void println(int x) {
            this.m_buffer.append(String.valueOf(x) + "\n");
        }

        public void println(float x) {
            this.m_buffer.append(String.valueOf(x) + "\n");
        }

        public void println(double x) {
            this.m_buffer.append(String.valueOf(x) + "\n");
        }

        public String toString() {
            return this.m_buffer.toString();
        }

        MyStringBuffer() {
            PSGr.this.getClass();
            this.m_buffer = new StringBuffer();
        }

        public void flush() {
        }

        public void print(String text) {
            this.m_buffer.append(text);
        }

        public void print(int x) {
            this.m_buffer.append(String.valueOf(x));
        }

        public void print(float x) {
            this.m_buffer.append(String.valueOf(x));
        }

        public void print(double x) {
            this.m_buffer.append(String.valueOf(x));
        }

        public void println(String text) {
            this.m_buffer.append(text + "\n");
        }
    }

    class PixelConsumer
    implements ImageConsumer {
        boolean complete;
        int xdim;
        int ydim;
        int[][] pix;

        public void setHints(int param) {
        }

        PixelConsumer(Image picture) {
            PSGr.this.getClass();
            this.complete = false;
            picture.getSource().startProduction(this);
            int t = 1000;
            while (t > 0 && !this.complete) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Throwable ex) {
                    // empty catch block
                }
                t -= 100;
            }
        }

        public void setPixels(int x1, int y1, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
            int x2 = x1 + w;
            int y2 = y1 + h;
            int sy = off;
            int y = y1;
            while (y < y2) {
                int sx = sy;
                int x = x1;
                while (x < x2) {
                    this.pix[x][y] = model.getRGB(pixels[sx++] & 0xFF);
                    ++x;
                }
                sy += scansize;
                ++y;
            }
        }

        public void setPixels(int x1, int y1, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
            int x2 = x1 + w;
            int y2 = y1 + h;
            int sy = off;
            int y = y1;
            while (y < y2) {
                int sx = sy;
                int x = x1;
                while (x < x2) {
                    this.pix[x][y] = pixels[sx++];
                    ++x;
                }
                sy += scansize;
                ++y;
            }
        }

        public void setDimensions(int x, int y) {
            this.xdim = x;
            this.ydim = y;
            this.pix = new int[x][y];
        }

        public void setProperties(Hashtable param) {
        }

        public void imageComplete(int param) {
            this.complete = true;
        }

        public void setColorModel(ColorModel param) {
        }
    }
}

