/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import jv.geom.PgPointSet;
import jv.geom.PgUtil;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgJvxSrc;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgPolygon
extends PgPointSet {
    protected boolean m_bShowEdgeLabels;
    protected boolean m_bClosed;
    protected boolean m_bShowEdges;
    protected boolean m_bShowTaggedEdges;
    protected boolean m_bShowPolygonStartArrow;
    protected boolean m_bShowPolygonEndArrow;
    protected boolean m_bShowEdgeNormals;
    protected boolean m_bShowEdgeColors;
    protected boolean m_bShowPolygonColors;
    protected boolean m_useGlobalPolygonSize;
    protected PdColor m_globalPolygonColor;
    protected PdColor m_globalPolygonTagColor;
    protected PuDouble m_globalPolygonSize;
    public int NORMAL = 100;
    public int BINORMAL = 101;
    public int OFFSET_NORMAL = 102;
    public int CURVATURE_NORMAL = 103;
    private static /* synthetic */ Class class$jv$geom$PgPolygon;

    public boolean isShowingPolygonStartArrow() {
        return this.m_bShowPolygonStartArrow;
    }

    public void showPolygonStartArrow(boolean flag) {
        this.m_bShowPolygonStartArrow = flag;
    }

    public PiVector[] triangulate() {
        if (this.m_numVertices < 3) {
            PsDebug.warning("number of vertices < 3");
            return null;
        }
        PiVector[] elemList = PgUtil.triangulate(this.m_vertex);
        if (elemList == null) {
            PsDebug.warning("triangulation failed");
            return null;
        }
        return elemList;
    }

    public PvPickEvent intersectionWithLine(PdVector rayBase, PdVector rayDir) {
        if (this.m_dim != 2 && this.m_dim != 3) {
            return null;
        }
        PdVector polygonDir = new PdVector(this.m_dim);
        PdVector minPolygonDir = new PdVector(this.m_dim);
        int vertexInd = -1;
        int minElem = -1;
        int minSubElem = -1;
        double dist = Double.MAX_VALUE;
        double minDist = Double.MAX_VALUE;
        double horDist = Double.MAX_VALUE;
        double minHorDist = Double.MAX_VALUE;
        PdVector pos = new PdVector(3);
        PdVector pos2D = this.m_dim == 2 ? new PdVector(2) : pos;
        PdVector minPos = new PdVector(3);
        PdBary bary = new PdBary(2);
        PdBary minBary = new PdBary(2);
        PdVector polyBase3D = null;
        PdVector polyTip3D = null;
        if (this.m_dim == 2) {
            polyBase3D = new PdVector(3);
            polyTip3D = new PdVector(3);
        }
        PdVector polyDir3D = null;
        if (this.m_dim == 2) {
            polyDir3D = new PdVector(3);
        }
        rayDir.normalize();
        PdVector[] v = this.m_vertex;
        int j = 1;
        while (j < this.m_numVertices) {
            polygonDir.sub(v[j], v[j - 1]);
            if (!(polygonDir.sqrLength() < 1.0E-10)) {
                if (this.m_dim == 2) {
                    polyBase3D.copyArray(v[j - 1]);
                    polyTip3D.copyArray(v[j]);
                    polyDir3D.copyArray(polygonDir);
                } else {
                    polyBase3D = v[j - 1];
                    polyTip3D = v[j];
                    polyDir3D = polygonDir;
                }
                polyDir3D.normalize();
                horDist = PuVectorGeom.distOfLineToLine(rayBase, rayDir, polyBase3D, polyDir3D);
                if (!(horDist >= minHorDist) && !(horDist > 0.1)) {
                    dist = PuVectorGeom.intersectionOfLineAndLine(pos, rayBase, rayDir, polyBase3D, polyDir3D);
                    if (this.m_dim == 2) {
                        pos2D.m_data[0] = pos.m_data[0];
                        pos2D.m_data[1] = pos.m_data[1];
                    }
                    PdBary.getBary(bary, pos, polyBase3D, polyTip3D);
                    boolean bInside = bary.isInside();
                    if (bInside || Math.abs(1.0 - bary.getEntry(0)) < 0.1 || Math.abs(1.0 - bary.getEntry(1)) < 0.1) {
                        minHorDist = horDist;
                        minDist = dist;
                        minElem = j;
                        minPolygonDir.copyArray(polygonDir);
                        vertexInd = -1;
                        if (bInside) {
                            minBary.copy(bary);
                            minPos.blend(bary.getEntry(0), polyBase3D, bary.getEntry(1), polyTip3D);
                        } else if (Math.abs(1.0 - bary.getEntry(0)) < 0.1) {
                            minBary.setEntry(0, 1.0);
                            minBary.setEntry(1, 0.0);
                            minPos.copyArray(polyBase3D);
                            vertexInd = j - 1;
                        } else if (Math.abs(1.0 - bary.getEntry(1)) < 0.1) {
                            minBary.setEntry(0, 0.0);
                            minBary.setEntry(1, 1.0);
                            minPos.copyArray(polyTip3D);
                            vertexInd = j;
                        }
                    }
                }
            }
            ++j;
        }
        if (minElem == -1) {
            return null;
        }
        PvPickEvent point = new PvPickEvent(this.m_dim);
        point.setVertex(minPos);
        point.setDistance(minDist);
        point.setElementInd(minElem);
        point.setElementSubInd(minSubElem);
        point.setBary(minBary);
        point.setVertexInd(vertexInd);
        point.setViewBase(rayBase);
        point.setViewDir(rayDir);
        point.setNormal(minPolygonDir);
        return point;
    }

    public void makeNormals() {
        this.makeNormals(this.NORMAL, 1.0);
    }

    public void makeNormals(int type, double length) {
        int firstUnusedInd;
        int k;
        int ind;
        this.assureVertexNormals();
        PdVector v = new PdVector(this.m_dim);
        PdVector w = new PdVector(this.m_dim);
        PdVector normal = new PdVector(this.m_dim);
        PdVector normalPrev = new PdVector(this.m_dim);
        PdVector binormal = new PdVector(3);
        PdVector binormalPrev = new PdVector(3);
        int size = this.getNumVertices();
        boolean bClosed = this.isClosed();
        PiVector m_polygon = new PiVector(size);
        int i = 0;
        while (i < size) {
            m_polygon.setEntry(i, i);
            ++i;
        }
        if (m_polygon == null || size < 3) {
            PsDebug.warning("polygon[" + i + "] null or less than 3 vertices");
            return;
        }
        int locIndPrev = 0;
        int locInd = 1;
        int indPrev = m_polygon.getEntry(locIndPrev);
        do {
            ind = m_polygon.getEntry(locInd);
            v.sub(this.m_vertex[ind], this.m_vertex[indPrev]);
        } while (v.sqrLength() < 1.0E-10 && ++locInd < size);
        if (locInd >= size) {
            PsDebug.warning("polygon[" + i + "] is degenerated to a point");
            normal.setEntry(this.m_dim - 1, 1.0);
            PdVector.setConstant(this.m_vertexNormal, normal);
            return;
        }
        int firstLocInd = size - 2;
        if (bClosed) {
            firstLocInd = locInd - 1;
        }
        normal.normalToVector(v);
        if (locInd >= size - 1) {
            PsDebug.warning("polygon is a line");
            PdVector.setConstant(this.m_vertexNormal, normal);
            return;
        }
        normalPrev.copy(normal);
        v.normalize();
        binormalPrev.cross(v, normal);
        normal.setLength(length);
        int firstEqualVertex = -1;
        boolean bRecentZeroEdge = false;
        boolean bRecentZeroAngle = false;
        if (!bClosed) {
            bRecentZeroAngle = true;
        }
        int locIndNext = locInd;
        int indNext = ind;
        while (locInd != firstLocInd) {
            double len;
            locInd = locIndNext;
            locIndNext = (locIndNext + 1) % size;
            ind = indNext;
            indNext = m_polygon.getEntry(locIndNext);
            w.sub(this.m_vertex[indNext], this.m_vertex[ind]);
            if (w.sqrLength() < 1.0E-10) {
                bRecentZeroEdge = true;
                if (firstEqualVertex != -1) continue;
                firstEqualVertex = locInd;
                continue;
            }
            w.sub(this.m_vertex[indNext], this.m_vertex[ind]);
            w.normalize();
            normal.sub(w, v);
            if (!normal.normalize()) {
                firstEqualVertex = -1;
                bRecentZeroAngle = true;
                continue;
            }
            binormal.cross(v, normal);
            if (type == this.NORMAL) {
                normal.setLength(length);
            } else if (type == this.BINORMAL) {
                normal.copy(binormal);
                normal.setLength(length);
            } else if (type == this.OFFSET_NORMAL) {
                double angle = PdVector.angleWithOrientation(v, w, binormal);
                len = length / Math.cos(angle / 2.0);
                normal.setLength(len);
            } else if (type == this.CURVATURE_NORMAL) {
                double angle = PdVector.angleWithOrientation(v, w, binormal);
                len = length * angle;
                normal.setLength(len);
            }
            if (PdVector.dot(binormal, binormalPrev) < 0.0) {
                normal.multScalar(-1.0);
                binormal.multScalar(-1.0);
            }
            if (bRecentZeroAngle) {
                int firstUnusedInd2 = (locIndPrev + 1) % size;
                if (!bClosed && locIndPrev == 0) {
                    firstUnusedInd2 = 0;
                }
                bRecentZeroAngle = false;
                normalPrev.cross(binormal, v);
                normalPrev.normalize();
                if (type == this.NORMAL) {
                    normalPrev.setLength(length);
                } else if (type == this.BINORMAL) {
                    normalPrev.copy(binormal);
                    normalPrev.setLength(length);
                } else if (type == this.OFFSET_NORMAL) {
                    normalPrev.setLength(length);
                } else if (type == this.CURVATURE_NORMAL) {
                    normalPrev.setConstant(0.0);
                }
                k = firstUnusedInd2;
                while (k != locInd) {
                    this.m_vertexNormal[m_polygon.getEntry(k)].copy(normalPrev);
                    k = (k + 1) % size;
                }
            }
            normalPrev.copy(normal);
            if (type == this.NORMAL) {
                normalPrev.setLength(length);
            } else if (type == this.BINORMAL) {
                normalPrev.copy(binormal);
                normalPrev.setLength(length);
            } else if (type == this.OFFSET_NORMAL) {
                double angle = PdVector.angleWithOrientation(v, w, binormal);
                len = length / Math.cos(angle / 2.0);
                normalPrev.setLength(len);
            } else if (type == this.CURVATURE_NORMAL) {
                double angle = PdVector.angleWithOrientation(v, w, binormal);
                len = length * angle;
                normalPrev.setLength(len);
            }
            if (bRecentZeroEdge) {
                bRecentZeroEdge = false;
                k = firstEqualVertex;
                firstEqualVertex = -1;
                while (k != locInd) {
                    this.m_vertexNormal[m_polygon.getEntry(k)].copy(normalPrev);
                    k = (k + 1) % size;
                }
            }
            this.m_vertexNormal[m_polygon.getEntry(locInd)].copy(normalPrev);
            v.copy(w);
            normalPrev.copy(normal);
            binormalPrev.copy(binormal);
            indPrev = ind;
            locIndPrev = locInd;
        }
        if (!bClosed && (firstUnusedInd = (locIndPrev + 1) % size) < size) {
            normalPrev.cross(binormalPrev, v);
            normalPrev.normalize();
            if (type == this.NORMAL) {
                normalPrev.setLength(length);
            } else if (type == this.BINORMAL) {
                normalPrev.copy(binormal);
                normalPrev.setLength(length);
            } else if (type == this.OFFSET_NORMAL) {
                normalPrev.setLength(length);
            } else if (type == this.CURVATURE_NORMAL) {
                normalPrev.setConstant(0.0);
            }
            k = firstUnusedInd;
            while (k < size) {
                this.m_vertexNormal[m_polygon.getEntry(k)].copy(normalPrev);
                ++k;
            }
        }
    }

    public void computeCircle(int numPoints, double radius) {
        this.setNumVertices(numPoints);
        this.assureVertexNormals();
        if (this.m_dim > 2) {
            PdVector.setConstant(this.m_vertex, 0.0);
            if (this.m_vertexNormal != null) {
                PdVector.setConstant(this.m_vertexNormal, 0.0);
            }
        }
        double uFac = Math.PI * 2 / (double)this.m_numVertices;
        int i = 0;
        while (i < this.m_numVertices) {
            this.m_vertex[i].m_data[0] = radius * Math.cos(uFac * (double)i);
            this.m_vertex[i].m_data[1] = radius * Math.sin(uFac * (double)i);
            ++i;
        }
        if (this.m_vertexNormal != null) {
            i = 0;
            while (i < this.m_numVertices) {
                this.m_vertexNormal[i].m_data[0] = Math.cos(uFac * (double)i);
                this.m_vertexNormal[i].m_data[1] = Math.sin(uFac * (double)i);
                ++i;
            }
        }
        this.m_bClosed = true;
    }

    public boolean isShowingEdges() {
        return this.m_bShowEdges;
    }

    public void showEdges(boolean flag) {
        this.m_bShowEdges = flag;
    }

    public boolean update(Object event) {
        PsDebug.notify("called");
        if (event == null) {
            return super.update(null);
        }
        if (event == this.m_globalPolygonSize) {
            PsDebug.notify("called with event=m_globalPolygonSize");
            return super.update(null);
        }
        if (event == this.m_globalPolygonColor) {
            PsDebug.notify("called with event=m_globalPolygonColor");
            return super.update(null);
        }
        return super.update(event);
    }

    public boolean isShowingEdgeLabels() {
        return this.m_bShowEdgeLabels;
    }

    public void showEdgeLabels(boolean flag) {
        this.m_bShowEdgeLabels = flag;
    }

    public PiVector getPolygon() {
        int num = this.m_numVertices;
        if (this.isClosed()) {
            ++num;
        }
        PiVector polygon = new PiVector(num);
        int i = 0;
        while (i < this.m_numVertices) {
            polygon.m_data[i] = i;
            ++i;
        }
        if (this.isClosed()) {
            polygon.m_data[num - 1] = 0;
        }
        return polygon;
    }

    public void useGlobalPolygonSize(boolean flag) {
        this.m_useGlobalPolygonSize = flag;
    }

    public Object clone() {
        PgPolygon clone = (PgPolygon)super.clone();
        if (clone == null) {
            return null;
        }
        clone.m_globalPolygonSize = (PuDouble)this.m_globalPolygonSize.clone();
        clone.m_globalPolygonColor = (PdColor)this.m_globalPolygonColor.clone();
        clone.m_globalPolygonTagColor = (PdColor)this.m_globalPolygonTagColor.clone();
        clone.m_globalPolygonSize.setParent(clone);
        clone.m_globalPolygonColor.setParent(clone);
        clone.m_globalPolygonTagColor.setParent(clone);
        return clone;
    }

    public boolean isClosed() {
        return this.m_bClosed;
    }

    public void showPolygonColors(boolean flag) {
        this.m_bShowPolygonColors = flag;
    }

    public boolean isShowingEdgeNormals() {
        return this.m_bShowEdgeNormals;
    }

    public boolean isShowingPolygonColors() {
        return this.m_bShowPolygonColors;
    }

    public void showEdgeNormals(boolean flag) {
        this.m_bShowEdgeNormals = flag;
    }

    public double getLength() {
        double length = 0.0;
        int i = 1;
        while (i < this.m_numVertices) {
            length += this.m_vertex[i - 1].dist(this.m_vertex[i]);
            ++i;
        }
        if (this.isClosed()) {
            length += PdVector.dist(this.m_vertex[0], this.m_vertex[this.m_numVertices - 1]);
        }
        return length;
    }

    public void makeOffsetNormals() {
        this.makeNormals(this.OFFSET_NORMAL, 1.0);
    }

    public void makeCurvatureNormals() {
        this.makeNormals(this.CURVATURE_NORMAL, 1.0);
    }

    public boolean checkTriangleCut(int vertexInd, PdVector normal) {
        PdVector[] p = new PdVector[3];
        PdVector[] triEdge = new PdVector[3];
        PdVector[] planeNor = new PdVector[3];
        double[] d = new double[3];
        vertexInd = (vertexInd + this.m_numVertices - 1) % this.m_numVertices;
        int i = 0;
        while (i < 3) {
            p[i] = this.m_vertex[(vertexInd + i) % this.m_numVertices];
            ++i;
        }
        i = 0;
        while (i < 3) {
            triEdge[i] = PdVector.subNew(p[(vertexInd + i + 1) % this.m_numVertices], p[(vertexInd + i) % this.m_numVertices]);
            planeNor[i] = PdVector.crossNew(normal, triEdge[i]);
            boolean ok = planeNor[i].normalize();
            if (!ok) {
                PsDebug.warning("two vertices may be identical");
                return false;
            }
            d[i] = -PdVector.dot(planeNor[i], p[i]);
            ++i;
        }
        int ind = (vertexInd + 2) % vertexInd;
        while (ind != vertexInd) {
            if (PdVector.dot(this.m_vertex[ind], planeNor[0]) + d[0] > 0.0 && PdVector.dot(this.m_vertex[ind], planeNor[1]) + d[1] > 0.0 && PdVector.dot(this.m_vertex[ind], planeNor[2]) + d[2] > 0.0) {
                return false;
            }
            ind = ind++ % vertexInd;
        }
        return true;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("");
        strBuf.append(super.toString());
        strBuf.append("\t ******* PgPolygon ***********\n");
        strBuf.append("\t m_bClosed = " + this.m_bClosed + "\n");
        return strBuf.toString();
    }

    public PgPolygon() {
        this(3);
    }

    public PgPolygon(int aVertexDim) {
        super(aVertexDim);
        this.setDimOfSimplex(1);
        this.m_globalPolygonColor = new PdColor(PsConfig.getMessage("globalPolygonColor"), this);
        this.m_globalPolygonTagColor = new PdColor(PsConfig.getMessage("globalPolygonTagColor"), this);
        this.m_globalPolygonSize = new PuDouble(PsConfig.getMessage("globalPolygonSize"), this);
        if (this.getClass() == (class$jv$geom$PgPolygon != null ? class$jv$geom$PgPolygon : (class$jv$geom$PgPolygon = PgPolygon.class$("jv.geom.PgPolygon")))) {
            this.init();
        }
    }

    public Color getGlobalPolygonTagColor() {
        return this.m_globalPolygonTagColor.getColor();
    }

    public void setGlobalPolygonTagColor(Color color) {
        this.m_globalPolygonTagColor.setColor(color);
    }

    public void useGlobalPolygonColor(boolean flag) {
        this.showPolygonColors(!flag);
    }

    public void paint(PvGeometryIf dc) {
        super.paint(dc);
        dc.setState(83, this.isShowingEdgeLabels());
        dc.setState(54, this.m_bShowEdges);
        dc.setState(52, this.m_bShowEdges);
        dc.setState(53, this.m_bShowTaggedEdges);
        dc.setState(88, this.m_bShowPolygonStartArrow);
        dc.setState(89, this.m_bShowPolygonEndArrow);
        dc.setState(92, this.m_bShowPolygonColors);
        if (this.m_bShowEdges) {
            if (this.m_globalPolygonSize != null) {
                dc.setGlobalPolygonSize(this.m_globalPolygonSize.getValue());
            }
            if (this.m_globalPolygonColor != null) {
                dc.setGlobalPolygonColor(this.m_globalPolygonColor.getColor());
            }
            if (this.m_globalPolygonTagColor != null) {
                dc.setGlobalPolygonTagColor(this.m_globalPolygonTagColor.getColor());
            }
        }
        dc.setNumPolygons(1);
        dc.setPolygon(0, this.getPolygon());
    }

    public boolean blend(double s, PgPolygon a, double t, PgPolygon b) {
        if (a == null || a.m_numVertices == 0) {
            PsDebug.warning("empty first argument", this);
            return false;
        }
        if (b == null || a.m_numVertices != b.m_numVertices) {
            PsDebug.warning("wrong second argument", this);
            return false;
        }
        if (Math.abs(s) < 1.0E-10) {
            s = 0.0;
        }
        if (Math.abs(t) < 1.0E-10) {
            t = 0.0;
        }
        if (!super.blend(s, a, t, b)) {
            return false;
        }
        this.m_bClosed = a.m_bClosed == b.m_bClosed ? a.m_bClosed : false;
        return true;
    }

    public void setClosed(boolean flag) {
        this.m_bClosed = flag;
    }

    public void makeBiNormals() {
        this.makeNormals(this.BINORMAL, 1.0);
    }

    public void copy(PgGeometry aGeom) {
        super.copy(aGeom);
        if (!(aGeom instanceof PgPolygon)) {
            return;
        }
        PgPolygon geom = (PgPolygon)aGeom;
        this.m_bClosed = geom.m_bClosed;
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public double getGlobalPolygonSize() {
        return this.m_globalPolygonSize.getValue();
    }

    public void setGlobalPolygonSize(double size) {
        this.m_globalPolygonSize.setValue(size);
    }

    public void computeEight(int numPoints) {
        this.setNumVertices(numPoints);
        if (this.m_dim > 2) {
            PdVector.setConstant(this.m_vertex, 0.0);
            if (this.m_vertexNormal != null) {
                PdVector.setConstant(this.m_vertexNormal, 0.0);
            }
        }
        double uFac = Math.PI * 2 / (double)this.m_numVertices;
        int i = 0;
        while (i < this.m_numVertices) {
            this.m_vertex[i].m_data[0] = 2.0 * Math.cos(uFac * (double)i);
            this.m_vertex[i].m_data[1] = 2.0 * Math.sin(2.0 * uFac * (double)i);
            ++i;
        }
        this.setClosed(true);
        this.makeNormals();
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc jvx = super.getJvx();
        jvx.setType(31);
        jvx.showEdgeLabels(this.isShowingEdgeLabels());
        jvx.showPolygons(this.m_bShowEdges);
        jvx.showPolygonStartArrow(this.isShowingPolygonStartArrow());
        jvx.showPolygonEndArrow(this.isShowingPolygonEndArrow());
        jvx.setDimOfPolygons(this.getNumVertices());
        jvx.setNumPolygons(1);
        jvx.setPolygon(0, this.getPolygon());
        jvx.setPolygonColors(new Color[]{this.getGlobalPolygonColor()});
        jvx.setGlobalPolygonColor(this.getGlobalPolygonColor());
        jvx.setGlobalPolygonTagColor(this.getGlobalPolygonTagColor());
        jvx.setGlobalPolygonSize(this.getGlobalPolygonSize());
        return jvx;
    }

    public void setJvx(PgJvxSrc src) {
        super.setJvx(src);
        this.showEdgeLabels(src.isShowingEdgeLabels());
        this.showEdges(src.isShowingPolygons());
        this.showPolygonStartArrow(src.isShowingPolygonStartArrow());
        this.showPolygonEndArrow(src.isShowingPolygonEndArrow());
        this.showPolygonColors(false);
        if (src.getGlobalPolygonColor() != null) {
            this.setGlobalPolygonColor(src.getGlobalPolygonColor());
        }
        if (src.getGlobalPolygonTagColor() != null) {
            this.setGlobalPolygonTagColor(src.getGlobalPolygonTagColor());
        }
        if (src.getGlobalPolygonSize() != 0.0) {
            this.setGlobalPolygonSize(src.getGlobalPolygonSize());
        }
    }

    public boolean isShowingEdgeColors() {
        return this.m_bShowEdgeColors;
    }

    public void init() {
        super.init();
        this.m_bClosed = false;
        this.m_bShowEdges = true;
        this.m_bShowTaggedEdges = true;
        this.m_bShowEdgeNormals = false;
        this.m_bShowEdgeColors = false;
        this.m_bShowPolygonStartArrow = false;
        this.m_bShowPolygonEndArrow = false;
        this.m_bShowPolygonColors = false;
        this.m_useGlobalPolygonSize = true;
        this.m_globalPolygonColor.setColor(Color.black);
        this.m_globalPolygonTagColor.setColor(Color.red);
        this.m_globalPolygonSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalPolygonSize.setDefValue(1.0);
        this.m_globalPolygonSize.init();
    }

    public boolean isShowingPolygonEndArrow() {
        return this.m_bShowPolygonEndArrow;
    }

    public void showEdgeColors(boolean flag) {
        this.m_bShowEdgeColors = flag;
    }

    public void showPolygonEndArrow(boolean flag) {
        this.m_bShowPolygonEndArrow = flag;
    }

    public Color getGlobalPolygonColor() {
        return this.m_globalPolygonColor.getColor();
    }

    public void setGlobalPolygonColor(Color color) {
        this.m_globalPolygonColor.setColor(color);
    }
}

