////////////////////////////////////////////////////////////////////////////////
/// @brief in-memory database definition
///
/// WARNING: This file is automatically generated. Please edit the corresponding
/// input file. All changes made to this file will be lost.
///
////////////////////////////////////////////////////////////////////////////////

#ifndef TRIAGENS_HPDF_IN_MEMORY_DATABASE_H_376509974
#define TRIAGENS_HPDF_IN_MEMORY_DATABASE_H_376509974

#include <Basics.h>
#include <Hpdf.h>

// /////////////////////////////////////////////////////////////////////////////
// ROWS
// /////////////////////////////////////////////////////////////////////////////

namespace triagens {
  namespace hpdf {
    namespace databases {
      namespace simple {

        // PRIMARY TABLE 'SimpleTable'
        struct TR_SimpleTable /* : public Row */ {
          char* A_identifier;
          blob_t A_data;
          blob_t A_extended;
          uint64_t A_flags;
          uint64_t A_flush_number;
          uint64_t A_cas_unique;
          datetime_t A_created;
          datetime_t A_lastAccess;
          datetime_t A_lastUpdate;
          datetime_t A_expireTime;
          datetime_t A_deletionTime;
          uint16_t A_deletionPending;
        };

        // MODIFY DELETE ROW OF PRIMARY TABLE 'SimpleTable'
        struct MD_SimpleTable {

          MD_SimpleTable() : allowSnapShot(false), recoveryType(0) {
          }

          static void destroy (TR_SimpleTable * rowPtr) {
            TR_SimpleTable * row __MAYBE_UNUSED__ = rowPtr;
            basics::StringUtils::destroy(row->A_identifier);
            basics::StringUtils::destroy(row->A_data.data, row->A_data.length);
            basics::StringUtils::destroy(row->A_extended.data, row->A_extended.length);
          }

          static void preModify (TR_SimpleTable * oldRow, TR_SimpleTable * newRow) {
            TR_SimpleTable * oRow __MAYBE_UNUSED__ = oldRow;
            TR_SimpleTable * nRow __MAYBE_UNUSED__ = newRow;

          }

          static void postModify (TR_SimpleTable * oldRow, TR_SimpleTable * newRow) {
            TR_SimpleTable * oRow __MAYBE_UNUSED__ = oldRow;
            TR_SimpleTable * nRow __MAYBE_UNUSED__ = newRow;

            // release memory 'SimpleTable'
            if (oRow->A_identifier != nRow->A_identifier) {
              basics::StringUtils::destroy(oRow->A_identifier);
            }
            if (oRow->A_data.data != nRow->A_data.data) {
              basics::StringUtils::destroy(oRow->A_data.data, oRow->A_data.length);
            }
            if (oRow->A_extended.data != nRow->A_extended.data) {
              basics::StringUtils::destroy(oRow->A_extended.data, oRow->A_extended.length);
            }
          }

          static void dumpTableRow (TR_SimpleTable const* row, char*& data, size_t& dataLength) {
            // this function should never be called -- internal error if called
            data = 0;
            dataLength = 0;
          }

          static bool restoreTableRow (TR_SimpleTable* row, const char* data, const size_t dataLength) {
            // this function should never be called -- internal error if called
            if (row || data || dataLength) {
            }
            return false;
          }

          static void setRecoveryRowId (TR_SimpleTable* row, uint64_t rowId) {
            // this function should never be called -- internal error if called
            if (row || rowId) {
            }
          }

          
          bool allowSnapShot;
          int recoveryType;
        };


        // QUERY ROW 'HashQuery'
        struct TR_HashQuery /* : public Row */ {
          void const* A_row;
        };

        // QUERY ROW 'PrefixQuery'
        struct TR_PrefixQuery /* : public Row */ {
          void const* A_row;
        };

      }
    }
  }
}

// /////////////////////////////////////////////////////////////////////////////
// INDEXES
// /////////////////////////////////////////////////////////////////////////////

namespace triagens {
  namespace hpdf {
    namespace databases {
      namespace simple {

        // INDEXES FOR PRIMARY TABLE 'SimpleTable'

        // HASH INDEX DESCRIPTION CLASS FOR TABLE TR_SimpleTable HASH INDEX SimpleHash
        template< typename R >
        struct HIX_SimpleTable_D_SimpleHash {

          void clearElement (IX_Unique_HashElement<R>& element) {
            element.data = 0;
          }


          bool isEmptyElement (const IX_Unique_HashElement<R>& element) const {
            if (element.data == 0) {
              return true;
            }
            return false;
          }

          bool isEqualElementElement (const IX_Unique_HashElement<R>& leftElement, const IX_Unique_HashElement<R>& rightElement) const {
            if (leftElement.data->A_identifier == 0) {
              if (rightElement.data->A_identifier != 0) {
                return false;
              }
              return true;
            }
            else if (rightElement.data->A_identifier == 0) {
              if (leftElement.data->A_identifier != 0) {
                return false;
              }
            }
            else if (strcmp(leftElement.data->A_identifier, rightElement.data->A_identifier) != 0) {
              return false;
            }

            return true;
          }

          bool isEqualKeyElement (const IX_Unique_HashElement<R>& leftElement, const IX_Unique_HashElement<R>& rightElement) const {
            if (leftElement.data->A_identifier == 0) {
              if (rightElement.data->A_identifier != 0) {
                return false;
              }
              return true;
            }
            else if (rightElement.data->A_identifier == 0) {
              if (leftElement.data->A_identifier != 0) {
                return false;
              }
            }
            else if (strcmp(leftElement.data->A_identifier, rightElement.data->A_identifier) != 0) {
              return false;
            }

            return true;
          }

          size_t hashElement (const IX_Unique_HashElement<R>& element) const {
            size_t hash;
            hash = basics::Crc32Hash::initialiseValue();
            hash = basics::Crc32Hash::crcValue(hash, (const unsigned char*)(element.data->A_identifier));
            hash = basics::Crc32Hash::finaliseValue(hash);
            return  hash;
          }

          size_t hashKey (const IX_Unique_HashElement<R>& element) const {
            size_t hash;
            hash = basics::Crc32Hash::initialiseValue();
            hash = basics::Crc32Hash::crcValue(hash, (const unsigned char*)(element.data->A_identifier));
            hash = basics::Crc32Hash::finaliseValue(hash);
            return  hash;
          }

        };


        // HASH INDEX STRUCTURE FOR TABLE TR_SimpleTable INDEX SimpleHash
        template< typename R >
        struct HIX_SimpleTable_I_SimpleHash {

          HIX_SimpleTable_I_SimpleHash() : indexData(100) {
          }

          inline void addIndex (R* r) {
            IX_Unique_HashElement<R> element;
            element.data = r;
            bool added = indexData.addElement(element,false);
            if (! added) {
              // Possible causes are (i) duplicate entry, or (ii) key has zero length, need a human to fix this
              LOGGER_ERROR << "cannot extend hash index, internal error encountered in IX_Unique_HashElement<R>: " << __FILE__ << "@" << __LINE__;
            }
          }

          inline R* findIndex (R& r) {
            IX_Unique_HashElement<R> element;
            element.data = &r;
            IX_Unique_HashElement<R> result = indexData.findElement(element);
            return (result.data);
          }

          inline void preModifyIndex (R* oldRow, R* newRow) {
            bool remove = false;

            if ( (!remove) && (oldRow->A_identifier != newRow->A_identifier) ) {
              remove = true;
            }

            if (remove) {
              removeIndex(oldRow);
            }

          }

          inline void postModifyIndex (R* oldRow, R* newRow) {
            bool add = false;

            if ( (!add) && (oldRow->A_identifier != newRow->A_identifier) ) {
              add = true;
            }

            if (add) {
              addIndex(newRow);
            }

          }

          inline void replaceIndex (R* r) {
            IX_Unique_HashElement<R> element;
            element.data = r;
            bool added = indexData.addElement(element,true);
            if (added) {
              // only possible cause is a missing entry, need a human to fix this
              LOGGER_ERROR << "replace found a new entry, internal error encountered in IX_Unique_HashElement<R>: " << __FILE__ << "@" << __LINE__;
            }
          }

          inline void removeIndex (R* r) {
            IX_Unique_HashElement<R> element;
            element.data = r;
            bool removed = indexData.removeElement(element);
            if (! removed) {
              // this is impossible, need a human to fix this
              LOGGER_ERROR << "cannot delete from index, internal error encountered in IX_Unique_HashElement<R>: " << __FILE__ << "@" << __LINE__;
            }
          }

          basics::AssociativeArray< IX_Unique_HashElement<R>, IX_Unique_HashElement<R>, HIX_SimpleTable_D_SimpleHash<R> > indexData;
        }; // end of structure HIX_SimpleTable_I_SimpleHash

        // PREFIX INDEX DESCRIPTION CLASS FOR TABLE TR_SimpleTable PREFIX INDEX IX
        template< typename R >
        struct PIX_SimpleTable_D_SimplePrefix {

          inline static bool isLessAdd (const R* const left, const R* const right) {
            int result;

            if (left == 0) {
              return (right != 0);
            }
            else if (right == 0) {
              return false;
            }

            result = sortedArray->CMP(left->A_identifier, right->A_identifier);
            if (result < 0) {
              return true;
            }
            else if (result > 0) {
              return false;
            }

            return false;
          }

          inline static bool isLessFind (const R* const left, const R* const right) {
            int result = 0;

            if (left == 0) {
              return (right != 0);
            }
            else if (right == 0) {
              return false;
            }

            if (len_A_identifier== 0) {
              return false;
            }

            result = sortedArray->NCMP(left->A_identifier, right->A_identifier, len_A_identifier);
            if (result < 0) {
              return true;
            }
            else if (result > 0) {
              return false;
            }


            return false;
          }

          inline static bool isEqualFind (const R* const left, const R* const right) {
            int result;

            if (len_A_identifier == 0) {
              return true;
            }

            result = sortedArray->NCMP(left->A_identifier, right->A_identifier, len_A_identifier);
            if (result != 0) {
              return false;
            }


            return true;
          }

          static size_t len_A_identifier;

          static SortedArray< R, PIX_SimpleTable_D_SimplePrefix<R> >* sortedArray;
          
        };

        // PREFIX INDEX STRUCTURE FOR TABLE TR_SimpleTable INDEX IX
        template< typename R >
        struct PIX_SimpleTable_I_SimplePrefix {

          PIX_SimpleTable_I_SimplePrefix() : indexData(10000, 5000, false, "fruit") {
            PIX_SimpleTable_D_SimplePrefix<R>::sortedArray = &indexData;
          }

          inline void addIndex (R* r) {
            indexData.addElement(r);
          }

          inline vector<R*>* findIndex (R& r) {
            PIX_SimpleTable_D_SimplePrefix<R>::len_A_identifier = strlen(r.A_identifier);
            vector<R*>* result = new vector<R*>();
            indexData.findElement(&r, result);
            return result;
          }

          inline void preModifyIndex (R* oldRow, R* newRow) {
            bool remove = false;

            if ( (!remove) && (oldRow->A_identifier != newRow->A_identifier) ) {
              remove = true;
            }

            if (remove) {
              removeIndex(oldRow);
            }

          }

          inline void postModifyIndex (R* oldRow, R* newRow) {
            bool add = false;

            if ( (!add) && (oldRow->A_identifier != newRow->A_identifier) ) {
              add = true;
            }

            if (add) {
              addIndex(newRow);
            }

          }

          inline void replaceIndex (R* oldRow, R* newRow) {
            indexData.removeElement(oldRow);
            indexData.addElement(newRow);
          }

          inline void removeIndex (R* r) {
            indexData.removeElement(r);
          }

          SortedArray< R, PIX_SimpleTable_D_SimplePrefix<R> > indexData;
        }; // end of structure PIX_SimpleTable_I_SimplePrefix

        // INDEX STRUCTURE FOR TABLE TR_SimpleTable
        template< typename R >
        struct IX_SimpleTable {

          inline void addIndexes (R* r) {
            I_SimpleHash.addIndex(r);
            I_SimplePrefix.addIndex(r);
          }

          inline void preModifyIndexes (R* oldRow, R* newRow) {
            I_SimpleHash.preModifyIndex(oldRow, newRow);
            I_SimplePrefix.preModifyIndex(oldRow, newRow);
          }

          inline void postModifyIndexes (R* oldRow, R* newRow) {
            I_SimpleHash.postModifyIndex(oldRow, newRow);
            I_SimplePrefix.postModifyIndex(oldRow, newRow);
          }

          inline void removeIndexes (R* r) {
            I_SimpleHash.removeIndex(r);
            I_SimplePrefix.removeIndex(r);
          }

          inline void replaceIndexes (R * oldRowU, R * newRowU) {
            R * oldRow __MAYBE_UNUSED__ = oldRowU;
            R * newRow __MAYBE_UNUSED__ = newRowU;

            I_SimpleHash.replaceIndex(newRow);
            I_SimplePrefix.replaceIndex(oldRow, newRow);
          }

          inline R* recoveryFindRow (R* r) {
            return 0;
          }

          HIX_SimpleTable_I_SimpleHash<R> I_SimpleHash;
          PIX_SimpleTable_I_SimplePrefix<R> I_SimplePrefix;
        };

      }
    }
  }
}

// /////////////////////////////////////////////////////////////////////////////
// PARAMETERS
// /////////////////////////////////////////////////////////////////////////////

namespace triagens {
  namespace hpdf {
    namespace databases {
      namespace simple {

        // QUERY PARAMETER 'HashQuery'
        struct PA_HashQuery /* : public Parameter */ {
          char* P_identifier_param;
        };

        // QUERY PARAMETER 'PrefixQuery'
        struct PA_PrefixQuery /* : public Parameter */ {
          char* P_identifier_param;
        };

      }
    }
  }
}

// /////////////////////////////////////////////////////////////////////////////
// TABLES
// /////////////////////////////////////////////////////////////////////////////

namespace triagens {
  namespace hpdf {
    namespace databases {
      namespace simple {

        // PRIMARY TABLE 'SimpleTable'
        extern PrimaryTable< TR_SimpleTable, MD_SimpleTable, IX_SimpleTable<TR_SimpleTable> > PT_SimpleTable;

      }
    }
  }
}

// /////////////////////////////////////////////////////////////////////////////
// ATTRIBUTES
// /////////////////////////////////////////////////////////////////////////////

namespace triagens {
  namespace hpdf {
    namespace databases {
      namespace simple {

      }
    }
  }
}

// /////////////////////////////////////////////////////////////////////////////
// QUERIES
// /////////////////////////////////////////////////////////////////////////////

namespace triagens {
  namespace hpdf {
    namespace databases {
      namespace simple {

        // QUERY 'HashQuery'
        struct QT_HashQuery : public Query {
          Table * execute (Parameter const * param);
        };

        // QUERY 'PrefixQuery'
        struct QT_PrefixQuery : public Query {
          Table * execute (Parameter const * param);
        };

      }
    }
  }
}


#endif
