////////////////////////////////////////////////////////////////////////////////
/// @brief statistics and figures
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Oreste Costa-Panaia
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#include "SimpleVocFigures.h"

using namespace triagens::basics;

namespace triagens {
  namespace simple {
    string StatisticsName (stat_e e) {
      switch (e) {
        case STAT_MC_INVALID: return "memcacheInvalid";
        case STAT_MC_ADD: return "memcacheAdd";
        case STAT_MC_APPEND: return "memcacheAppend";
        case STAT_MC_CAS: return "memcacheCas";
        case STAT_MC_DECR: return "memcacheDecr";
        case STAT_MC_DELETE: return "memcacheDelete";
        case STAT_MC_FLUSH_ALL: return "memcacheFlushAll";
        case STAT_MC_GET: return "memcacheGet";
        case STAT_MC_GETS: return "memcacheGets";
        case STAT_MC_INCR: return "memcacheIncr";
        case STAT_MC_PGET: return "memcachePGet";
        case STAT_MC_PGETS: return "memcachePGets";
        case STAT_MC_PREPEND: return "memcachePrepend";
        case STAT_MC_REPLACE: return "memcacheReplace";
        case STAT_MC_SET: return "memcacheSet";
        case STAT_MC_STAT: return "memcacheStat";
        case STAT_MC_VERSION: return "memcacheVersion";

        case STAT_POSTFIX_INVALID: return "postfixInvalid";
        case STAT_POSTFIX_GET: return "postfixGet";
        case STAT_POSTFIX_PUT: return "postfixPut";

        case STAT_REST_INVALID: return "restInvalid";
        case STAT_REST_FLUSH: return "restFlush";
        case STAT_REST_PREFIX: return "restPrefix";
        case STAT_REST_VALUE_GET: return "restValueGet";
        case STAT_REST_VALUE_POST: return "restValuePost";
        case STAT_REST_VALUE_PUT: return "restValuePut";
        case STAT_REST_VALUE_DELETE: return "restValueDelete";
        case STAT_REST_VERSION: return "restVersion";
        case STAT_REST_STATS: return "restStats";

        case STAT_END: return "end";
      }

      return "unknown";
    }



    group_e StatisticsGroup (stat_e e) {
      switch (e) {
        case STAT_MC_INVALID:
        case STAT_MC_ADD:
        case STAT_MC_APPEND:
        case STAT_MC_CAS:
        case STAT_MC_DECR:
        case STAT_MC_DELETE:
        case STAT_MC_FLUSH_ALL:
        case STAT_MC_GET:
        case STAT_MC_GETS:
        case STAT_MC_INCR:
        case STAT_MC_PGET:
        case STAT_MC_PGETS:
        case STAT_MC_PREPEND:
        case STAT_MC_REPLACE:
        case STAT_MC_SET:
        case STAT_MC_STAT:
        case STAT_MC_VERSION:
          return GROUP_MC;

        case STAT_POSTFIX_INVALID:
        case STAT_POSTFIX_GET:
        case STAT_POSTFIX_PUT:
          return GROUP_POSTFIX;

        case STAT_REST_INVALID:
        case STAT_REST_FLUSH:
        case STAT_REST_PREFIX:
        case STAT_REST_VALUE_GET:
        case STAT_REST_VALUE_POST:
        case STAT_REST_VALUE_PUT:
        case STAT_REST_VALUE_DELETE:
        case STAT_REST_VERSION:
        case STAT_REST_STATS:
          return GROUP_REST;

        case STAT_END:
          return GROUP_ALL;
      }

      return GROUP_ALL;
    }



    string GroupName (group_e e) {
      switch (e) {
        case GROUP_ALL:  return "all";
        case GROUP_MC:  return "memcache";
        case GROUP_POSTFIX:  return "postfix";
        case GROUP_REST:  return "rest";
        case GROUP_END:  return "end";
      }

      return "unknown";
    }



    RoundRobinFigures<1, 61, SimpleVocStatistics> FiguresSecond;
    RoundRobinFigures<60, 61, SimpleVocStatistics> FiguresMinute;
    RoundRobinFigures<60 * 60, 25, SimpleVocStatistics> FiguresHour;
    RoundRobinFigures<24 * 60 * 60, 31, SimpleVocStatistics> FiguresDay;
  }
}

