////////////////////////////////////////////////////////////////////////////////
/// @brief value request handler
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Achim Brandt
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef SIMPLEVOC_RESTHANDLER_REST_VALUE_HANDLER_H
#define SIMPLEVOC_RESTHANDLER_REST_VALUE_HANDLER_H 1

#include "RestHandler/RestDefaultHandler.h"

#define VOC_HEADER_FIELD_CREATED      "X-VOC-Created"
#define VOC_HEADER_FIELD_EXTENDED     "X-VOC-Extended"
#define VOC_HEADER_FIELD_EXPIRES      "X-VOC-Expires"
#define VOC_HEADER_FIELD_FLAGS        "X-VOC-Flags"
#define VOC_HEADER_FIELD_DELETE_TIME  "X-VOC-Delete-Time"
#define VOC_HEADER_FIELD_FLUSHDELAY   "X-VOC-Flush-Delay"

namespace triagens {
  namespace simple {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief value request handler
    ////////////////////////////////////////////////////////////////////////////////

    class RestValueHandler : public RestDefaultHandler {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief creator
        ////////////////////////////////////////////////////////////////////////////////

        static rest::HttpHandler* create (rest::HttpRequest* request, void* model) {
          return new RestValueHandler(request, model);
        }

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        RestValueHandler (rest::HttpRequest* request, void* model)
          : RestDefaultHandler(request, model, STAT_REST_INVALID) {
        }

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        status_e execute ();

      private:
        void computeKey ();
        status_e executeGet ();
        status_e executePost ();
        status_e executePut ();
        status_e executeDelete ();

      private:
        string key;
    };
  }
}

#endif
