////////////////////////////////////////////////////////////////////////////////
/// @brief tasks used to handle signals
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Achim Brandt
/// @author Copyright 2008-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef TRIAGENS_REST_SIGNAL_TASK_H
#define TRIAGENS_REST_SIGNAL_TASK_H 1

#include <Rest/Task.h>

#include <Basics/Mutex.h>

namespace triagens {
  namespace rest {

    ////////////////////////////////////////////////////////////////////////////////
    /// @ingroup Scheduler
    /// @brief task used to handle signals
    ////////////////////////////////////////////////////////////////////////////////

    class  SignalTask : virtual public Task {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief maximal number of signals per task
        ////////////////////////////////////////////////////////////////////////////////

        static size_t const MAX_SIGNALS = 10;

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructs a new task
        ////////////////////////////////////////////////////////////////////////////////

        SignalTask ();

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructs a new task for a given signal
        ////////////////////////////////////////////////////////////////////////////////

        explicit
        SignalTask (int signal);

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief adds a signal which will be handled
        ///
        /// Note that this method can be called on a signal task, which has already
        /// been set up.
        ////////////////////////////////////////////////////////////////////////////////

        bool addSignal (int signal);

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief called when the signal is received
        ////////////////////////////////////////////////////////////////////////////////

        virtual bool handleSignal () = 0;

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// destructor
        ////////////////////////////////////////////////////////////////////////////////

        ~SignalTask ();

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void setup (Scheduler*, event_loop_t*);

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void cleanup ();

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        bool handleEvent (void* token, int event);

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        bool needsMainEventLoop () const;

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief callback structure
        ////////////////////////////////////////////////////////////////////////////////

        struct watcher_t;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief callback data
        ////////////////////////////////////////////////////////////////////////////////

        watcher_t* watcher;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief callback function
        ////////////////////////////////////////////////////////////////////////////////

        static void callback (event_loop_t*, watcher_t*, int revents);

      private:
        set<int> signals;
        basics::Mutex changeLock;
    };
  }
}

#endif
