////////////////////////////////////////////////////////////////////////////////
/// @brief abstract line handler factory
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Copyright 2009-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#include "LineHandlerFactory.h"

#include <Rest/LineHandler.h>
#include <Rest/LineRequest.h>
#include <Rest/LineResponse.h>

namespace triagens {
  namespace rest {

    // -----------------------------------------------------------------------------
    // public methods
    // -----------------------------------------------------------------------------

    pair<size_t, size_t> LineHandlerFactory::sizeRestrictions () {
      static size_t m = (size_t) -1;

      return make_pair(m, m);
    }

  }
}


