////////////////////////////////////////////////////////////////////////////////
/// @brief abstract class for line handlers
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Copyright 2009-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef TRIAGENS_REST_LINE_HANDLER_H
#define TRIAGENS_REST_LINE_HANDLER_H 1

#include <Rest/Handler.h>

namespace triagens {
  namespace rest {
    class DispatcherThread;
    class LineRequest;
    class LineResponse;

    ////////////////////////////////////////////////////////////////////////////////
    /// @ingroup LineServer
    /// @brief abstract class for line handlers
    ////////////////////////////////////////////////////////////////////////////////

    class  LineHandler : public Handler {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructs a new handler
        ///
        /// Note that the handler owns the request and the response. It is its
        /// responsibility to destroy them both.
        ////////////////////////////////////////////////////////////////////////////////

        explicit
        LineHandler (LineRequest*);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief destructs a handler
        ////////////////////////////////////////////////////////////////////////////////

        ~LineHandler ();

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief returns true if we need a body
        ////////////////////////////////////////////////////////////////////////////////

        virtual bool requiresBody () = 0;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief returns true if we need body lines
        ////////////////////////////////////////////////////////////////////////////////

        virtual bool requiresBodyLines () = 0;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief returns the required body lengths
        ////////////////////////////////////////////////////////////////////////////////

        virtual size_t requiredBodyLength () = 0;

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief returns the response
        ////////////////////////////////////////////////////////////////////////////////

        LineResponse* getResponse () {
          return response;
        }

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief the request
        ////////////////////////////////////////////////////////////////////////////////

        LineRequest* request;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief the response
        ////////////////////////////////////////////////////////////////////////////////

        LineResponse* response;
    };
  }
}

#endif
