////////////////////////////////////////////////////////////////////////////////
/// @brief abstract I/O task
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Achim Brandt
/// @author Copyright 2009-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#include "IoTask.h"

#include "Scheduler/EventLoop.h"

namespace triagens {
  namespace rest {

    // -----------------------------------------------------------------------------
    // classes
    // -----------------------------------------------------------------------------

    struct IoTask::watcher_t {
      ev_io io;
      IoTask* task;
    };

    // -----------------------------------------------------------------------------
    // static protected methods
    // -----------------------------------------------------------------------------

    void IoTask::callback (event_loop_t*, watcher_t* w, int revents) {
      IoTask* task = w->task;

      if (task != 0 && task->isActive()) {
        task->handleEvent(reinterpret_cast<void*>(w), revents);
      }
    }

    // -----------------------------------------------------------------------------
    // constructors and destructors
    // -----------------------------------------------------------------------------

    IoTask::IoTask ()
      : Task("IoTask") {
      readWatcher = new watcher_t;
      readWatcher->task = this;

      writeWatcher = new watcher_t;
      writeWatcher->task = this;
    }



    IoTask::~IoTask () {
      delete readWatcher;
      delete writeWatcher;
    }

    // -----------------------------------------------------------------------------
    // Task methods
    // -----------------------------------------------------------------------------

    void IoTask::setup (Scheduler* scheduler, event_loop_t* loop) {
      this->scheduler = scheduler;
      this->loop = loop;
    }
  }
}

