////////////////////////////////////////////////////////////////////////////////
/// @brief postfix transformation
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Oreste Costa-Panaia
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#include "Transformation.h"

#include <Basics/DeleteObject.h>
#include <Basics/Logger.h>

using namespace triagens::basics;

namespace triagens {
  namespace simple {

    // -----------------------------------------------------------------------------
    // constructors and destructors
    // -----------------------------------------------------------------------------

    Transformation::Transformation (string const& format) {
      char const* ptr = format.c_str();
      char const* end = ptr + format.size();

      string token = "";

      while (ptr < end) {
        if (*ptr == '{') {
          ++ptr;

          if (*ptr == '{') {
            token += *ptr++;
          }
          else {
            if (! token.empty()) {
              LOGGER_TRACE << "found constant token '" << token << "'";
              parts.push_back(new Constant(token));
            }

            token.clear();

            char const* start = ptr;

            for (;  ptr < end && *ptr != '}';  ++ptr) {
            }

            string key(start, ptr - start);

            LOGGER_TRACE << "found dictionary entry '" << key << "'";
            parts.push_back(new Entry(key));

            if (*ptr == '}') {
              ++ptr;
            }
          }
        }
        else {
          token += *ptr++;
        }
      }

      if (! token.empty()) {
        LOGGER_TRACE << "found constant token '" << token << "'";
        parts.push_back(new Constant(token));
      }
    }



    Transformation::Transformation (Transformation const& that) {
      for (vector<Part*>::const_iterator i = that.parts.begin();  i != that.parts.end();  ++i) {
        parts.push_back((*i)->clone());
      }
    }



    Transformation& Transformation::operator= (Transformation const& that) {
      if (this != &that) {
        for_each(parts.begin(), parts.end(), DeleteObject());
        parts.clear();

        for (vector<Part*>::const_iterator i = that.parts.begin();  i != that.parts.end();  ++i) {
          parts.push_back((*i)->clone());
        }
      }

      return *this;
    }



    Transformation::~Transformation () {
      for_each(parts.begin(), parts.end(), DeleteObject());
    }

    // -----------------------------------------------------------------------------
    // public methods
    // -----------------------------------------------------------------------------

    string Transformation::evaluate (map<string, string> const& dictionary) const {
      string result = "";

      for (vector<Part*>::const_iterator i = parts.begin();  i != parts.end();  ++i) {
        Part* part = *i;

        result += part->value(dictionary);
      }

      return result;
    }
  }
}
