////////////////////////////////////////////////////////////////////////////////
/// @brief postfix request
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef SIMPLEVOC_POSTFIXHANDLER_POSTFIX_REQUEST_H
#define SIMPLEVOC_POSTFIXHANDLER_POSTFIX_REQUEST_H 1

#include <Rest/LineRequest.h>

#include <Basics/Exceptions.h>

namespace triagens {
  namespace simple {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief line request
    ///
    /// The line server reads a line of text and sends onto here to determine what
    /// type of request we have.
    ////////////////////////////////////////////////////////////////////////////////

    class  PostfixRequest : public rest::LineRequest {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief various requests
        ////////////////////////////////////////////////////////////////////////////////

        enum PostfixRequestType {
          POSTFIX_REQUEST_INVALID,
          POSTFIX_REQUEST_GET,
          POSTFIX_REQUEST_PUT
        };

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        PostfixRequest ();

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        explicit PostfixRequest (string const& line);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        explicit PostfixRequest (char const* line, size_t length);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief destructor
        ////////////////////////////////////////////////////////////////////////////////

        virtual ~PostfixRequest ();

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void setLineRequestInvalid ()  {
          type = POSTFIX_REQUEST_INVALID;
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void addBodyLine (char const*, size_t) {
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void addBody (char const*, size_t) {
        }

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief returns the key
        ////////////////////////////////////////////////////////////////////////////////

        char const* getKey () const {
          return key;
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief returns the value
        ////////////////////////////////////////////////////////////////////////////////

        char const* getValue () const {
          return value;
        }

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief returns what action the command line specified
        ////////////////////////////////////////////////////////////////////////////////

        PostfixRequestType requestType () const {
          return type;
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief returns what action the command line specified as string
        ////////////////////////////////////////////////////////////////////////////////

        string requestTypeString () const {
          switch (type) {
            case POSTFIX_REQUEST_INVALID: return "POSTFIX_REQUEST_INVALID";
            case POSTFIX_REQUEST_GET: return "POSTFIX_REQUEST_GET";
            case POSTFIX_REQUEST_PUT: return "POSTFIX_REQUEST_PUT";
          }

          THROW_INTERNAL_ERROR("unknown request type");
        }

      private:
        void parseLine (size_t length);
        void readHexcaped (char*& start, char*& stop, char* end);

      private:
        PostfixRequestType type;
        char* input;
        char const* key;
        char const* value;
    };
  }
}

#endif
