////////////////////////////////////////////////////////////////////////////////
/// @brief memcached line handler factory
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Oreste Costa-Panaia
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#include "PostfixHandler/PostfixHandlerFactory.h"

#include "PostfixHandler/PostfixGetHandler.h"
#include "PostfixHandler/PostfixPutHandler.h"
#include "PostfixHandler/PostfixInvalidHandler.h"

namespace triagens {
  namespace simple {

    // -----------------------------------------------------------------------------
    // LineHandlerFactory methods
    // -----------------------------------------------------------------------------

    rest::LineRequest* PostfixHandlerFactory::createRequest (char const* ptr, size_t length) const {
      return new PostfixRequest(ptr, length);
    }



    rest::LineHandler* PostfixHandlerFactory::createHandler (rest::LineRequest* lineReq) const {
      PostfixRequest* request = dynamic_cast<PostfixRequest*>(lineReq);

      if (request == 0) {
        return 0;
      }

      switch (request->requestType()) {
        case PostfixRequest::POSTFIX_REQUEST_GET: return new PostfixGetHandler(lineReq, model, transformations);
        case PostfixRequest::POSTFIX_REQUEST_PUT: return new PostfixPutHandler(lineReq, model);
        case PostfixRequest::POSTFIX_REQUEST_INVALID: return new PostfixInvalidHandler(lineReq, model);
      }

      return 0;
    }
  }
}


