////////////////////////////////////////////////////////////////////////////////
/// @brief pgets request handler (partial key match)
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Oreste Costa-Panaia
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef SIMPLEVOC_MCHANDLER_MCPGETS_HANDLER_H
#define SIMPLEVOC_MCHANDLER_MCPGETS_HANDLER_H 1

#include "MCHandler/MCBaseHandler.h"

namespace triagens {
  namespace simple {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief pget request handler (parital key match)
    ////////////////////////////////////////////////////////////////////////////////

    class MCPGetsHandler : public MCBaseHandler {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        MCPGetsHandler (rest::LineRequest* request, SimpleModel* model)
          : MCBaseHandler(request, model,size_t(STAT_MC_PGETS)) {
        }

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void work (MCRequest* request, MCResponse* response) {
          for (vector< pair<char*,size_t> >::const_iterator j = request->cmdStructure.keys.begin();  j != request->cmdStructure.keys.end();  ++j) {

            // safety first
            if ((*j).first == 0) {
              continue;
            }

            Value value;
            value.identifier = request->cmdStructure.keys[0].first;

            vector<Value> values;

            if (model->prefixGetValue(value, values) != OK) {
              continue;
            }

            for (vector<Value>::iterator k = values.begin();  k != values.end();  ++k) {
              Value& v = *k;

              response->body().appendText("VALUE ",6);
              response->body().appendText(v.identifier);
              response->body().appendChar(' ');
              response->body().appendInteger(v.flags);
              response->body().appendChar(' ');
              response->body().appendInteger(v.data.size());
              response->body().appendChar(' ');
              response->body().appendInteger(v.cas);
              response->body().appendText("\r\n",2);
              response->body().appendText(v.data.c_str(), v.data.size());
              response->body().appendText("\r\n",2);
            }
          }

          response->body().appendText("END\r\n",5);
        }
    };
  }
}

#endif
