////////////////////////////////////////////////////////////////////////////////
/// @brief memcached line handler factory
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Oreste Costa-Panaia
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#include "MCHandler/MCHandlerFactory.h"

#include "MCHandler/MCAddHandler.h"
#include "MCHandler/MCAppendHandler.h"
#include "MCHandler/MCCasHandler.h"
#include "MCHandler/MCDecrHandler.h"
#include "MCHandler/MCDeleteHandler.h"
#include "MCHandler/MCFlushAllHandler.h"
#include "MCHandler/MCGetHandler.h"
#include "MCHandler/MCGetsHandler.h"
#include "MCHandler/MCIncrHandler.h"
#include "MCHandler/MCInvalidHandler.h"
#include "MCHandler/MCPGetHandler.h"
#include "MCHandler/MCPGetsHandler.h"
#include "MCHandler/MCPrependHandler.h"
#include "MCHandler/MCReplaceHandler.h"
#include "MCHandler/MCRequest.h"
#include "MCHandler/MCSetHandler.h"
#include "MCHandler/MCStatHandler.h"
#include "MCHandler/MCVersionHandler.h"

namespace triagens {
  namespace simple {

    // -----------------------------------------------------------------------------
    // LineHandlerFactory methods
    // -----------------------------------------------------------------------------

    rest::LineRequest* MCHandlerFactory::createRequest (char const* ptr, size_t length) const {
      return new MCRequest(ptr,length);
    }



    rest::LineHandler* MCHandlerFactory::createHandler (rest::LineRequest* lineReq) const {
      MCRequest* request = dynamic_cast<MCRequest*>(lineReq);

      if (request == 0) {
        return 0;
      }

      switch (request->requestType()) {
        case MCRequest::MC_REQUEST_ADD: return new MCAddHandler(lineReq, model);
        case MCRequest::MC_REQUEST_APPEND: return new MCAppendHandler(lineReq, model);
        case MCRequest::MC_REQUEST_CAS: return new MCCasHandler(lineReq, model);
        case MCRequest::MC_REQUEST_DATABASE: return 0;
        case MCRequest::MC_REQUEST_DECR: return new MCDecrHandler(lineReq, model);
        case MCRequest::MC_REQUEST_DELETE: return new MCDeleteHandler(lineReq, model);
        case MCRequest::MC_REQUEST_FLUSH_ALL: return new MCFlushAllHandler(lineReq, model);
        case MCRequest::MC_REQUEST_GET: return new MCGetHandler(lineReq, model);
        case MCRequest::MC_REQUEST_GETS: return new MCGetsHandler(lineReq, model);
        case MCRequest::MC_REQUEST_INCR: return new MCIncrHandler(lineReq, model);
        case MCRequest::MC_REQUEST_INVALID: return new MCInvalidHandler(lineReq, model);
        case MCRequest::MC_REQUEST_PGET: return new MCPGetHandler(lineReq, model);
        case MCRequest::MC_REQUEST_PGETS: return new MCPGetsHandler(lineReq, model);
        case MCRequest::MC_REQUEST_QUERY: return 0;
        case MCRequest::MC_REQUEST_QUIT: return 0;
        case MCRequest::MC_REQUEST_PREPEND: return new MCPrependHandler(lineReq, model);
        case MCRequest::MC_REQUEST_REPLACE: return new MCReplaceHandler(lineReq, model);
        case MCRequest::MC_REQUEST_SET: return new MCSetHandler(lineReq, model);
        case MCRequest::MC_REQUEST_STATS: return new MCStatHandler(lineReq, model);
        case MCRequest::MC_REQUEST_VERSION: return new MCVersionHandler(lineReq, model);
      }

      return 0;
    }
  }
}
