////////////////////////////////////////////////////////////////////////////////
/// @brief get request handler
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Oreste Costa-Panaia
/// @author Copyright 2010, triagens GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef SIMPLEVOC_MCHANDLER_MCGET_HANDLER_H
#define SIMPLEVOC_MCHANDLER_MCGET_HANDLER_H 1

#include "MCHandler/MCBodyLessHandler.h"

namespace triagens {
  namespace simple {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief get request handler
    ////////////////////////////////////////////////////////////////////////////////

    class MCGetHandler : public MCBodyLessHandler {

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        MCGetHandler (rest::LineRequest* request, SimpleModel* model)
          : MCBodyLessHandler(request, model, size_t(STAT_MC_GET)) {
        }

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void work (MCRequest* request, MCResponse* response) {

          // attempt to extract the rows for all keys sent
          for (vector< pair<char*,size_t> >::const_iterator j = request->cmdStructure.keys.begin();  j != request->cmdStructure.keys.end();  ++j) {

            // safety first
            if ((*j).first == 0) {
              continue;
            }

            Value value;

            value.identifier = request->cmdStructure.keys[0].first;

            if (model->getValue(value) != OK) {
              continue;
            }

            response->body().appendText("VALUE ",6);
            response->body().appendText((*j).first, (*j).second);
            response->body().appendChar(' ');
            response->body().appendInteger(value.flags);
            response->body().appendChar(' ');
            response->body().appendInteger(value.data.size());
            response->body().appendText("\r\n",2);
            response->body().appendText(value.data.c_str(),value.data.size());
            response->body().appendText("\r\n",2);

          }

          response->body().appendText("END\r\n",5);
        }
    };
  }
}

#endif
