////////////////////////////////////////////////////////////////////////////////
/// @brief line server
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Achim Brandt
/// @author Copyright 2009-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef FYN_LINESERVER_LINE_SERVER_H
#define FYN_LINESERVER_LINE_SERVER_H 1

#include <Basics/Common.h>

#include "GeneralServer/GeneralServer.h"

#include <Rest/LineHandlerFactory.h>
#include <Rest/LineHandler.h>

namespace triagens {
  namespace rest {
    class LineCommTask;
    class LineHandlerFactory;
    class LineListenTask;
    class LineRequest;

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief line server
    ////////////////////////////////////////////////////////////////////////////////

    class LineServer : public GeneralServer<LineServer, LineHandlerFactory, LineCommTask> {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructs a new line server
        ////////////////////////////////////////////////////////////////////////////////

        explicit
        LineServer (Scheduler* scheduler)
          : GeneralServer<LineServer, LineHandlerFactory, LineCommTask>(scheduler) {
        }

    };
  }
}

#endif
