////////////////////////////////////////////////////////////////////////////////
/// @brief class for result rows
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Achim Brandt
/// @author Copyright 2008-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef TRIAGENS_HPDF_VARIANT_ROW_H
#define TRIAGENS_HPDF_VARIANT_ROW_H 1

#include <Hpdf/Common.h>

#include <Basics/VariantArray.h>

namespace triagens {
  namespace basics {
    struct StringBuffer;
  }

  namespace hpdf {
    struct AttributeDescriptor;
    struct Row;

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief class for result rows
    ////////////////////////////////////////////////////////////////////////////////

    class VariantRow : public basics::VariantArray {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief type of VariantObject
        ////////////////////////////////////////////////////////////////////////////////

        static ObjectType const TYPE = VARIANT_ROW;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief set ups generating functions
        ////////////////////////////////////////////////////////////////////////////////

        static void initialise ();

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructs an empty row
        ////////////////////////////////////////////////////////////////////////////////

        VariantRow ();

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructs a new row
        ////////////////////////////////////////////////////////////////////////////////

        VariantRow (hpdf::Row const*, hpdf::AttributeDescriptor const*);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructs a new row
        ////////////////////////////////////////////////////////////////////////////////

        VariantRow (void const* row, hpdf::AttributeDescriptor const*);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructs a new row
        ////////////////////////////////////////////////////////////////////////////////

        VariantRow (hpdf::Row const*, hpdf::AttributeDescriptor const*, set<string> const& hidden);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructs a new row
        ////////////////////////////////////////////////////////////////////////////////

        VariantRow (void const* row, hpdf::AttributeDescriptor const*, set<string> const& hidden);

      public:
        using VariantArray::print;

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        ObjectType type () const {
          return TYPE;
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        VariantObject* clone () const;

      private:
        void generate (void const* row, AttributeDescriptor const* desc, set<string> const& hidden);
        void generate (void const* row, AttributeDescriptor const* desc);
    };
  }
}

#endif
